# Copyrights 2011-2015 by [Mark Overmeer].
#  For other contributors see ChangeLog.
# See the manual pages for details on the licensing terms.
# Pod stripped from pm file by OODoc 2.01.
use warnings;
use strict;

package POSIX::1003::Locale;
use vars '$VERSION';
$VERSION = '0.99_01';

use base 'POSIX::1003::Module';

# Blocks from resp. limits.h and local.h
my @constants;
my @functions = qw/localeconv setlocale/;

our %EXPORT_TAGS =
  ( constants => \@constants
  , functions => \@functions
  , tables    => [ '%locale' ]
  );

my  $locale;
our %locale;

BEGIN {
    $locale = locale_table;
    push @constants, keys %$locale;
    tie %locale, 'POSIX::1003::ReadOnlyTable', $locale;
}




sub _create_constant($)
{   my ($class, $name) = @_;
    my $val = $locale->{$name};
    sub () {$val};
}


1;
