# NEVER EDIT this file.  It was generated and will be overwritten without
# notice upon regeneration of this application.  You have been warned.
package Bigtop::Example::Billing::GEN::LineItem;

use strict;

use base 'Bigtop::Example::Billing';

use Bigtop::Example::Billing::Model::line_item qw(
    $LINE_ITEM
);
use Gantry::Plugins::Calendar qw(
    do_calendar_month
    calendar_month_js
);



#-----------------------------------------------------------------
# $self->do_main(  )
#-----------------------------------------------------------------
sub do_main {
    my ( $self ) = @_;

    $self->stash->view->template( 'results.tt' );
    $self->stash->view->title( 'Line Items' );

    my $retval = {
        headings       => [
            'Name',
            'Invoice Number',
            'Due Date',
        ],
        header_options => [
            {
                text => 'Add',
                link => $self->location() . "/add",
            },
        ],
    };

    my $schema = $self->get_schema();
    my @rows   = $LINE_ITEM->get_listing( { schema => $schema } );

    foreach my $row ( @rows ) {
        my $id = $row->id;
        push(
            @{ $retval->{rows} }, {
                data => [
                    $row->name,
                    $row->invoice->foreign_display(),
                    $row->due_date,
                ],
                options => [
                    {
                        text => 'Edit',
                        link => $self->location() . "/edit/$id",
                    },
                    {
                        text => 'Delete',
                        link => $self->location() . "/delete/$id",
                    },
                ],
            }
        );
    }

    $self->stash->view->data( $retval );
} # END do_main

#-----------------------------------------------------------------
# $self->form( $row )
#-----------------------------------------------------------------
sub form {
    my ( $self, $row ) = @_;

    my $selections = $LINE_ITEM->get_form_selections(
            { schema => $self->get_schema() }
    );

    return {
        name       => 'line_item',
        row        => $row,
        legend => $self->path_info =~ /edit/i ? 'Edit' : 'Add',
        javascript => $self->calendar_month_js( 'line_item' ),
        fields     => [
            {
                date_select_text => 'Select',
                name => 'due_date',
                label => 'Due Date',
                type => 'text',
                is => 'date',
            },
            {
                name => 'name',
                label => 'Name',
                type => 'text',
                is => 'varchar',
            },
            {
                options => $selections->{invoice},
                name => 'invoice',
                label => 'Invoice Number',
                type => 'select',
                is => 'int4',
            },
            {
                name => 'hours',
                label => 'Hours',
                type => 'text',
                is => 'int4',
            },
            {
                name => 'charge_per_hour',
                label => 'Rate',
                type => 'text',
                is => 'int4',
            },
            {
                name => 'notes',
                optional => 1,
                label => 'Notes to Customer',
                type => 'textarea',
                is => 'text',
                rows => 4,
                cols => 50,
            },
            {
                name => 'description',
                optional => 1,
                label => 'Notes to Self',
                type => 'textarea',
                is => 'text',
                rows => 4,
                cols => 50,
            },
        ],
    };
} # END form


1;

=head1 NAME

Bigtop::Example::Billing::GEN::LineItem - generated support module for Bigtop::Example::Billing::LineItem

=head1 SYNOPSIS

In Bigtop::Example::Billing::LineItem:

    use Bigtop::Example::Billing::GEN::LineItem qw(
        do_main
        form
    );

=head1 DESCRIPTION

This module was generated by bigtop and IS subject to regeneration.
Use it in Bigtop::Example::Billing::LineItem to provide the methods below.
They are exported by default.

=head1 METHODS

=over 4

=item do_main

=item form


=back

=head1 AUTHOR

Generated by bigtop and subject to regeneration.

=cut

