use strict;
use Test::More tests => 3;

BEGIN {
	use_ok( 'GSM::SMS::OTA::CLIicon' );
}

my $correct = "00480E0107800000000001F0001FE00000000007FC003FF0000000000FFE007FF8000000000CCE007FC0000000000D5600FF00000000000EEE00FC06318C6318CFFE63FC06318C6318CFFE63FF00000000000FFE007FC0000000000EAE007FF8000000000D56003FF0000000000FFE001FE0000000000CE600078000000000084200";

my $b64image = <<EOT;
R0lGODlhSAAOAIAAAP///wAAACwAAAAASAAOAEACZ4QdGcftDyNTSSKqrN4Qe+ll3KhVywlU
VriQ7qOKasTO713bzefMfpsC/g7DYO1CPOWAN5cpBdXBQs2qkUdbWp2tmDSJ3b4y5O+FMk2q
kezg2n2lwt1HMRelZE5Z9pF2g9ZHwkQYUQAAOw==
EOT

my $stream = GSM::SMS::OTA::CLIicon::OTACLIicon_fromfile( "t/test_72x14.gif" );
is( $stream, $correct, "Compare 'fromfile' to test stream" );

$stream = GSM::SMS::OTA::CLIicon::OTACLIicon_fromb64( $b64image );
is( $stream, $correct, "Compare 'fromb64' to test stream" );
