/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.pattern;

import java.util.Iterator;
import java.util.Set;
import net.sf.saxon.om.Item;
import net.sf.saxon.om.NameOfNode;
import net.sf.saxon.om.NodeInfo;
import net.sf.saxon.om.NodeName;
import net.sf.saxon.om.StructuredQName;
import net.sf.saxon.pattern.AnyNodeTest;
import net.sf.saxon.pattern.NodeKindTest;
import net.sf.saxon.trans.XPathException;
import net.sf.saxon.tree.tiny.NodeVectorTree;
import net.sf.saxon.type.AnyItemType;
import net.sf.saxon.type.AnySimpleType;
import net.sf.saxon.type.AnyType;
import net.sf.saxon.type.AtomicType;
import net.sf.saxon.type.BuiltInAtomicType;
import net.sf.saxon.type.ItemType;
import net.sf.saxon.type.PrimitiveUType;
import net.sf.saxon.type.SchemaComponentVisitor;
import net.sf.saxon.type.SchemaType;
import net.sf.saxon.type.TypeHierarchy;
import net.sf.saxon.value.SequenceType;
import net.sf.saxon.z.IntPredicate;
import net.sf.saxon.z.IntSet;
import net.sf.saxon.z.IntUniversalSet;

public abstract class NodeTest
implements ItemType.WithSequenceTypeCache {
    private SequenceType _one;
    private SequenceType _oneOrMore;
    private SequenceType _zeroOrOne;
    private SequenceType _zeroOrMore;

    public abstract double getDefaultPriority();

    public boolean matches(Item item, TypeHierarchy th) {
        return item instanceof NodeInfo && this.matchesNode((NodeInfo)item);
    }

    public ItemType getPrimitiveItemType() {
        int p = this.getPrimitiveType();
        if (p == 0) {
            return AnyNodeTest.getInstance();
        }
        return NodeKindTest.makeNodeKindTest(p);
    }

    public int getPrimitiveType() {
        return 0;
    }

    public int getFingerprint() {
        return -1;
    }

    public StructuredQName getMatchingNodeName() {
        return null;
    }

    public boolean isAtomicType() {
        return false;
    }

    public boolean isPlainType() {
        return false;
    }

    public AtomicType getAtomizedItemType() {
        return BuiltInAtomicType.ANY_ATOMIC;
    }

    public boolean isAtomizable() {
        return true;
    }

    public String toExportString() {
        return this.toString();
    }

    public IntPredicate getMatcher(final NodeVectorTree tree) {
        return new IntPredicate(){

            public boolean matches(int nodeNr) {
                return NodeTest.this.matchesNode(tree.getNode(nodeNr));
            }
        };
    }

    public abstract boolean matches(int var1, NodeName var2, SchemaType var3);

    public boolean matchesNode(NodeInfo node) {
        return this.matches(node.getNodeKind(), NameOfNode.makeName(node), node.getSchemaType());
    }

    public int getNodeKindMask() {
        return 9102;
    }

    public SchemaType getContentType() {
        Set<PrimitiveUType> m = this.getUType().decompose();
        Iterator<PrimitiveUType> it = m.iterator();
        if (m.size() == 1 && it.hasNext()) {
            PrimitiveUType p = it.next();
            switch (p) {
                case DOCUMENT: {
                    return AnyType.getInstance();
                }
                case ELEMENT: {
                    return AnyType.getInstance();
                }
                case ATTRIBUTE: {
                    return AnySimpleType.getInstance();
                }
                case COMMENT: {
                    return BuiltInAtomicType.STRING;
                }
                case TEXT: {
                    return BuiltInAtomicType.UNTYPED_ATOMIC;
                }
                case PI: {
                    return BuiltInAtomicType.STRING;
                }
                case NAMESPACE: {
                    return BuiltInAtomicType.STRING;
                }
            }
        }
        return AnyType.getInstance();
    }

    public IntSet getRequiredNodeNames() {
        return IntUniversalSet.getInstance();
    }

    public boolean isNillable() {
        return true;
    }

    public void visitNamedSchemaComponents(SchemaComponentVisitor visitor) throws XPathException {
    }

    public NodeTest copy() {
        return this;
    }

    public String generateJavaScriptItemTypeAcceptor(String errorCode, int targetVersion) throws XPathException {
        return "function test(item) {" + this.generateJavaScriptItemTypeTest(AnyItemType.getInstance(), targetVersion) + "};" + "if (test(val)) {return val;} else {throw SaxonJS.XError('Conversion failed', '" + errorCode + "');}";
    }

    public SequenceType one() {
        if (this._one == null) {
            this._one = new SequenceType(this, 16384);
        }
        return this._one;
    }

    public SequenceType zeroOrOne() {
        if (this._zeroOrOne == null) {
            this._zeroOrOne = new SequenceType(this, 24576);
        }
        return this._zeroOrOne;
    }

    public SequenceType oneOrMore() {
        if (this._oneOrMore == null) {
            this._oneOrMore = new SequenceType(this, 49152);
        }
        return this._oneOrMore;
    }

    public SequenceType zeroOrMore() {
        if (this._zeroOrMore == null) {
            this._zeroOrMore = new SequenceType(this, 57344);
        }
        return this._zeroOrMore;
    }
}

