# Generated by default/object.tt
package Paws::FinspaceData::ChangesetInfo;
  use Moose;
  has ChangesetArn => (is => 'ro', isa => 'Str', request_name => 'changesetArn', traits => ['NameInRequest']);
  has ChangesetLabels => (is => 'ro', isa => 'Paws::FinspaceData::StringMap', request_name => 'changesetLabels', traits => ['NameInRequest']);
  has ChangeType => (is => 'ro', isa => 'Str', request_name => 'changeType', traits => ['NameInRequest']);
  has CreateTimestamp => (is => 'ro', isa => 'Str', request_name => 'createTimestamp', traits => ['NameInRequest']);
  has DatasetId => (is => 'ro', isa => 'Str', request_name => 'datasetId', traits => ['NameInRequest']);
  has ErrorInfo => (is => 'ro', isa => 'Paws::FinspaceData::ErrorInfo', request_name => 'errorInfo', traits => ['NameInRequest']);
  has FormatParams => (is => 'ro', isa => 'Paws::FinspaceData::StringMap', request_name => 'formatParams', traits => ['NameInRequest']);
  has FormatType => (is => 'ro', isa => 'Str', request_name => 'formatType', traits => ['NameInRequest']);
  has Id => (is => 'ro', isa => 'Str', request_name => 'id', traits => ['NameInRequest']);
  has SourceParams => (is => 'ro', isa => 'Paws::FinspaceData::StringMap', request_name => 'sourceParams', traits => ['NameInRequest']);
  has SourceType => (is => 'ro', isa => 'Str', request_name => 'sourceType', traits => ['NameInRequest']);
  has Status => (is => 'ro', isa => 'Str', request_name => 'status', traits => ['NameInRequest']);
  has UpdatedByChangesetId => (is => 'ro', isa => 'Str', request_name => 'updatedByChangesetId', traits => ['NameInRequest']);
  has UpdatesChangesetId => (is => 'ro', isa => 'Str', request_name => 'updatesChangesetId', traits => ['NameInRequest']);

1;

### main pod documentation begin ###

=head1 NAME

Paws::FinspaceData::ChangesetInfo

=head1 USAGE

This class represents one of two things:

=head3 Arguments in a call to a service

Use the attributes of this class as arguments to methods. You shouldn't make instances of this class. 
Each attribute should be used as a named argument in the calls that expect this type of object.

As an example, if Att1 is expected to be a Paws::FinspaceData::ChangesetInfo object:

  $service_obj->Method(Att1 => { ChangesetArn => $value, ..., UpdatesChangesetId => $value  });

=head3 Results returned from an API call

Use accessors for each attribute. If Att1 is expected to be an Paws::FinspaceData::ChangesetInfo object:

  $result = $service_obj->Method(...);
  $result->Att1->ChangesetArn

=head1 DESCRIPTION

A changeset is unit of data in a dataset.

=head1 ATTRIBUTES


=head2 ChangesetArn => Str

The ARN identifier of the changeset.


=head2 ChangesetLabels => L<Paws::FinspaceData::StringMap>

Tags associated with the changeset.


=head2 ChangeType => Str

Change type indicates how a changeset is applied to a dataset.

=over

=item *

C<REPLACE> - Changeset is considered as a replacement to all prior
loaded changesets.

=item *

C<APPEND> - Changeset is considered as an addition to the end of all
prior loaded changesets.

=item *

C<MODIFY> - Changeset is considered as a replacement to a specific
prior ingested changeset.

=back



=head2 CreateTimestamp => Str

The timestamp at which the changeset was created in FinSpace.


=head2 DatasetId => Str

The unique identifier for the FinSpace dataset in which the changeset
is created.


=head2 ErrorInfo => L<Paws::FinspaceData::ErrorInfo>

The structure with error messages.


=head2 FormatParams => L<Paws::FinspaceData::StringMap>

Structure of the source file(s).


=head2 FormatType => Str

Format type of the input files loaded into the changeset.


=head2 Id => Str

Unique identifier for a changeset.


=head2 SourceParams => L<Paws::FinspaceData::StringMap>

Source path from which the files to create the changeset are sourced.


=head2 SourceType => Str

Type of the data source from which the files to create the changeset
are sourced.

=over

=item *

C<S3> - Amazon S3.

=back



=head2 Status => Str

The status of changeset creation operation.


=head2 UpdatedByChangesetId => Str

Unique identifier of the changeset that is updated a changeset.


=head2 UpdatesChangesetId => Str

Unique identifier of the changeset that is updated.



=head1 SEE ALSO

This class forms part of L<Paws>, describing an object used in L<Paws::FinspaceData>

=head1 BUGS and CONTRIBUTIONS

The source code is located here: L<https://github.com/pplu/aws-sdk-perl>

Please report bugs to: L<https://github.com/pplu/aws-sdk-perl/issues>

=cut

