# Generated by default/object.tt
package Paws::ElastiCache::GlobalReplicationGroup;
  use Moose;
  has ARN => (is => 'ro', isa => 'Str');
  has AtRestEncryptionEnabled => (is => 'ro', isa => 'Bool');
  has AuthTokenEnabled => (is => 'ro', isa => 'Bool');
  has CacheNodeType => (is => 'ro', isa => 'Str');
  has ClusterEnabled => (is => 'ro', isa => 'Bool');
  has Engine => (is => 'ro', isa => 'Str');
  has EngineVersion => (is => 'ro', isa => 'Str');
  has GlobalNodeGroups => (is => 'ro', isa => 'ArrayRef[Paws::ElastiCache::GlobalNodeGroup]', request_name => 'GlobalNodeGroup', traits => ['NameInRequest']);
  has GlobalReplicationGroupDescription => (is => 'ro', isa => 'Str');
  has GlobalReplicationGroupId => (is => 'ro', isa => 'Str');
  has Members => (is => 'ro', isa => 'ArrayRef[Paws::ElastiCache::GlobalReplicationGroupMember]', request_name => 'GlobalReplicationGroupMember', traits => ['NameInRequest']);
  has Status => (is => 'ro', isa => 'Str');
  has TransitEncryptionEnabled => (is => 'ro', isa => 'Bool');

1;

### main pod documentation begin ###

=head1 NAME

Paws::ElastiCache::GlobalReplicationGroup

=head1 USAGE

This class represents one of two things:

=head3 Arguments in a call to a service

Use the attributes of this class as arguments to methods. You shouldn't make instances of this class. 
Each attribute should be used as a named argument in the calls that expect this type of object.

As an example, if Att1 is expected to be a Paws::ElastiCache::GlobalReplicationGroup object:

  $service_obj->Method(Att1 => { ARN => $value, ..., TransitEncryptionEnabled => $value  });

=head3 Results returned from an API call

Use accessors for each attribute. If Att1 is expected to be an Paws::ElastiCache::GlobalReplicationGroup object:

  $result = $service_obj->Method(...);
  $result->Att1->ARN

=head1 DESCRIPTION

Consists of a primary cluster that accepts writes and an associated
secondary cluster that resides in a different AWS region. The secondary
cluster accepts only reads. The primary cluster automatically
replicates updates to the secondary cluster.

=over

=item *

The B<GlobalReplicationGroupIdSuffix> represents the name of the Global
datastore, which is what you use to associate a secondary cluster.

=back


=head1 ATTRIBUTES


=head2 ARN => Str

The ARN (Amazon Resource Name) of the global replication group.


=head2 AtRestEncryptionEnabled => Bool

A flag that enables encryption at rest when set to C<true>.

You cannot modify the value of C<AtRestEncryptionEnabled> after the
replication group is created. To enable encryption at rest on a
replication group you must set C<AtRestEncryptionEnabled> to C<true>
when you create the replication group.

B<Required:> Only available when creating a replication group in an
Amazon VPC using redis version C<3.2.6>, C<4.x> or later.


=head2 AuthTokenEnabled => Bool

A flag that enables using an C<AuthToken> (password) when issuing Redis
commands.

Default: C<false>


=head2 CacheNodeType => Str

The cache node type of the Global datastore


=head2 ClusterEnabled => Bool

A flag that indicates whether the Global datastore is cluster enabled.


=head2 Engine => Str

The Elasticache engine. For Redis only.


=head2 EngineVersion => Str

The Elasticache Redis engine version.


=head2 GlobalNodeGroups => ArrayRef[L<Paws::ElastiCache::GlobalNodeGroup>]

Indicates the slot configuration and global identifier for each slice
group.


=head2 GlobalReplicationGroupDescription => Str

The optional description of the Global datastore


=head2 GlobalReplicationGroupId => Str

The name of the Global datastore


=head2 Members => ArrayRef[L<Paws::ElastiCache::GlobalReplicationGroupMember>]

The replication groups that comprise the Global datastore.


=head2 Status => Str

The status of the Global datastore


=head2 TransitEncryptionEnabled => Bool

A flag that enables in-transit encryption when set to true. You cannot
modify the value of C<TransitEncryptionEnabled> after the cluster is
created. To enable in-transit encryption on a cluster you must set
C<TransitEncryptionEnabled> to true when you create a cluster.

B<Required:> Only available when creating a replication group in an
Amazon VPC using redis version C<3.2.6>, C<4.x> or later.



=head1 SEE ALSO

This class forms part of L<Paws>, describing an object used in L<Paws::ElastiCache>

=head1 BUGS and CONTRIBUTIONS

The source code is located here: L<https://github.com/pplu/aws-sdk-perl>

Please report bugs to: L<https://github.com/pplu/aws-sdk-perl/issues>

=cut

