# Generated by default/object.tt
package Paws::ElasticInference::KeyValuePair;
  use Moose;
  has Key => (is => 'ro', isa => 'Str', request_name => 'key', traits => ['NameInRequest']);
  has Value => (is => 'ro', isa => 'Int', request_name => 'value', traits => ['NameInRequest']);

1;

### main pod documentation begin ###

=head1 NAME

Paws::ElasticInference::KeyValuePair

=head1 USAGE

This class represents one of two things:

=head3 Arguments in a call to a service

Use the attributes of this class as arguments to methods. You shouldn't make instances of this class. 
Each attribute should be used as a named argument in the calls that expect this type of object.

As an example, if Att1 is expected to be a Paws::ElasticInference::KeyValuePair object:

  $service_obj->Method(Att1 => { Key => $value, ..., Value => $value  });

=head3 Results returned from an API call

Use accessors for each attribute. If Att1 is expected to be an Paws::ElasticInference::KeyValuePair object:

  $result = $service_obj->Method(...);
  $result->Att1->Key

=head1 DESCRIPTION

A throughput entry for an Elastic Inference Accelerator type.

=head1 ATTRIBUTES


=head2 Key => Str

The throughput value of the Elastic Inference Accelerator type. It can
assume the following values: TFLOPS16bit: the throughput expressed in
16bit TeraFLOPS. TFLOPS32bit: the throughput expressed in 32bit
TeraFLOPS.


=head2 Value => Int

The throughput value of the Elastic Inference Accelerator type.



=head1 SEE ALSO

This class forms part of L<Paws>, describing an object used in L<Paws::ElasticInference>

=head1 BUGS and CONTRIBUTIONS

The source code is located here: L<https://github.com/pplu/aws-sdk-perl>

Please report bugs to: L<https://github.com/pplu/aws-sdk-perl/issues>

=cut

