/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.nlp.process;

import edu.stanford.nlp.ling.CoreAnnotations;
import edu.stanford.nlp.ling.Document;
import edu.stanford.nlp.ling.HasWord;
import edu.stanford.nlp.process.ListProcessor;
import edu.stanford.nlp.util.CoreMap;
import edu.stanford.nlp.util.Generics;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class WordToSentenceProcessor<IN>
implements ListProcessor<IN, List<IN>> {
    private static final boolean DEBUG = false;
    private final Pattern sentenceBoundaryTokenPattern;
    private final Set<String> sentenceBoundaryFollowers;
    private List<Pattern> sentenceBoundaryToDiscard;
    private final Pattern sentenceRegionBeginPattern;
    private final Pattern sentenceRegionEndPattern;
    private boolean isOneSentence;

    public void setSentenceBoundaryToDiscard(Set<String> regexSet) {
        this.sentenceBoundaryToDiscard = new ArrayList<Pattern>(regexSet.size());
        for (String s : regexSet) {
            this.sentenceBoundaryToDiscard.add(Pattern.compile(Pattern.quote(s)));
        }
    }

    public boolean isOneSentence() {
        return this.isOneSentence;
    }

    public void setOneSentence(boolean oneSentence) {
        this.isOneSentence = oneSentence;
    }

    public void addHtmlSentenceBoundaryToDiscard(Set<String> set) {
        if (this.sentenceBoundaryToDiscard == null) {
            this.sentenceBoundaryToDiscard = new ArrayList<Pattern>();
        }
        for (String s : set) {
            this.sentenceBoundaryToDiscard.add(Pattern.compile("<\\s*/?\\s*" + s + "\\s*/?\\s*>", 2));
            this.sentenceBoundaryToDiscard.add(Pattern.compile("<\\s*" + s + "\\s+[^>]+>", 2));
        }
    }

    private boolean matchesSentenceBoundaryToDiscard(String word) {
        for (Pattern p : this.sentenceBoundaryToDiscard) {
            Matcher m = p.matcher(word);
            if (!m.matches()) continue;
            return true;
        }
        return false;
    }

    @Override
    public List<List<IN>> process(List<? extends IN> words) {
        if (this.isOneSentence) {
            ArrayList<List<IN>> sentences = Generics.newArrayList();
            sentences.add(new ArrayList<IN>(words));
            return sentences;
        }
        return this.wordsToSentences(words);
    }

    public List<List<IN>> wordsToSentences(List<? extends IN> words) {
        ArrayList<List<IN>> sentences = Generics.newArrayList();
        ArrayList<IN> currentSentence = null;
        ArrayList<IN> lastSentence = null;
        boolean insideRegion = false;
        for (IN o : words) {
            Boolean forcedEndValue;
            String word;
            if (o instanceof HasWord) {
                HasWord h = (HasWord)o;
                word = h.word();
            } else if (o instanceof String) {
                word = (String)o;
            } else if (o instanceof CoreMap) {
                word = (String)((CoreMap)o).get(CoreAnnotations.TextAnnotation.class);
            } else {
                throw new RuntimeException("Expected token to be either Word or String.");
            }
            boolean forcedEnd = false;
            if (o instanceof CoreMap && (forcedEndValue = (Boolean)((CoreMap)o).get(CoreAnnotations.ForcedSentenceEndAnnotation.class)) != null) {
                forcedEnd = forcedEndValue;
            }
            if (currentSentence == null) {
                currentSentence = new ArrayList<IN>();
            }
            if (this.sentenceRegionBeginPattern != null && !insideRegion) {
                if (!this.sentenceRegionBeginPattern.matcher(word).matches()) continue;
                insideRegion = true;
                continue;
            }
            if (this.sentenceBoundaryFollowers.contains(word) && lastSentence != null && currentSentence.isEmpty()) {
                lastSentence.add(o);
                continue;
            }
            boolean newSent = false;
            if (this.matchesSentenceBoundaryToDiscard(word)) {
                newSent = true;
            } else if (this.sentenceRegionEndPattern != null && this.sentenceRegionEndPattern.matcher(word).matches()) {
                insideRegion = false;
                newSent = true;
            } else if (this.sentenceBoundaryTokenPattern.matcher(word).matches()) {
                currentSentence.add(o);
                newSent = true;
            } else if (forcedEnd) {
                currentSentence.add(o);
                newSent = true;
            } else {
                currentSentence.add(o);
            }
            if (!newSent || currentSentence.size() <= 0) continue;
            sentences.add(currentSentence);
            lastSentence = currentSentence;
            currentSentence = null;
        }
        if (currentSentence != null && currentSentence.size() > 0) {
            sentences.add(currentSentence);
        }
        return sentences;
    }

    public <L, F> Document<L, F, List<IN>> processDocument(Document<L, F, IN> in) {
        Document doc = in.blankDocument();
        doc.addAll(this.process(in));
        return doc;
    }

    public WordToSentenceProcessor() {
        this("\\.|[!?]+");
    }

    public WordToSentenceProcessor(String boundaryTokenRegex) {
        this(boundaryTokenRegex, Generics.newHashSet(Arrays.asList(")", "]", "\"", "'", "''", "-RRB-", "-RSB-", "-RCB-")));
    }

    public WordToSentenceProcessor(String boundaryTokenRegex, Set<String> boundaryFollowers) {
        this(boundaryTokenRegex, boundaryFollowers, Collections.singleton("\n"));
    }

    public WordToSentenceProcessor(String boundaryTokenRegex, Set<String> boundaryFollowers, Set<String> boundaryToDiscard) {
        this(boundaryTokenRegex, boundaryFollowers, boundaryToDiscard, null, null);
    }

    public WordToSentenceProcessor(Pattern regionBeginPattern, Pattern regionEndPattern) {
        this("", Collections.emptySet(), Collections.emptySet(), regionBeginPattern, regionEndPattern);
    }

    private WordToSentenceProcessor(String boundaryTokenRegex, Set<String> boundaryFollowers, Set<String> boundaryToDiscard, Pattern regionBeginPattern, Pattern regionEndPattern) {
        this.sentenceBoundaryTokenPattern = Pattern.compile(boundaryTokenRegex);
        this.sentenceBoundaryFollowers = boundaryFollowers;
        this.setSentenceBoundaryToDiscard(boundaryToDiscard);
        this.sentenceRegionBeginPattern = regionBeginPattern;
        this.sentenceRegionEndPattern = regionEndPattern;
    }
}

