/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.nlp.trees;

import edu.stanford.nlp.ling.Label;
import edu.stanford.nlp.ling.LabelFactory;
import edu.stanford.nlp.trees.Constituent;
import edu.stanford.nlp.trees.ConstituentFactory;

public class SimpleConstituent
extends Constituent {
    private int start;
    private int end;

    public SimpleConstituent() {
    }

    public SimpleConstituent(int start, int end) {
        this.start = start;
        this.end = end;
    }

    @Override
    public int start() {
        return this.start;
    }

    @Override
    public void setStart(int start) {
        this.start = start;
    }

    @Override
    public int end() {
        return this.end;
    }

    @Override
    public void setEnd(int end) {
        this.end = end;
    }

    @Override
    public LabelFactory labelFactory() {
        return LabelFactoryHolder.lf;
    }

    public ConstituentFactory constituentFactory() {
        return ConstituentFactoryHolder.cf;
    }

    public static ConstituentFactory factory() {
        return ConstituentFactoryHolder.cf;
    }

    private static class ConstituentFactoryHolder {
        static final ConstituentFactory cf = new SimpleConstituentFactory();

        private ConstituentFactoryHolder() {
        }

        private static class SimpleConstituentFactory
        implements ConstituentFactory {
            private SimpleConstituentFactory() {
            }

            @Override
            public Constituent newConstituent(int start, int end) {
                return new SimpleConstituent(start, end);
            }

            @Override
            public Constituent newConstituent(int start, int end, Label label, double score) {
                return new SimpleConstituent(start, end);
            }
        }
    }

    private static class LabelFactoryHolder {
        static final LabelFactory lf = new SimpleConstituentLabelFactory();

        private LabelFactoryHolder() {
        }
    }

    private static class SimpleConstituentLabelFactory
    implements LabelFactory {
        private SimpleConstituentLabelFactory() {
        }

        @Override
        public Label newLabel(String labelStr) {
            return new SimpleConstituent(0, 0);
        }

        @Override
        public Label newLabel(String labelStr, int options) {
            return this.newLabel(labelStr);
        }

        @Override
        public Label newLabelFromString(String labelStr) {
            return this.newLabel(labelStr);
        }

        @Override
        public Label newLabel(Label oldLabel) {
            return new SimpleConstituent(0, 0);
        }
    }
}

