/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pdfbox.pdmodel.documentinterchange.logicalstructure;

import java.io.IOException;
import org.apache.pdfbox.cos.COSBase;
import org.apache.pdfbox.cos.COSDictionary;
import org.apache.pdfbox.cos.COSName;
import org.apache.pdfbox.pdmodel.common.COSObjectable;
import org.apache.pdfbox.pdmodel.graphics.xobject.PDXObject;
import org.apache.pdfbox.pdmodel.interactive.annotation.PDAnnotation;

public class PDObjectReference
implements COSObjectable {
    public static final String TYPE = "OBJR";
    private COSDictionary dictionary;

    protected COSDictionary getCOSDictionary() {
        return this.dictionary;
    }

    public PDObjectReference() {
        this.dictionary = new COSDictionary();
        this.dictionary.setName(COSName.TYPE, TYPE);
    }

    public PDObjectReference(COSDictionary dictionary) {
        this.dictionary = dictionary;
    }

    public COSBase getCOSObject() {
        return this.dictionary;
    }

    public COSObjectable getReferencedObject() {
        COSBase obj = this.getCOSDictionary().getDictionaryObject(COSName.OBJ);
        try {
            return PDAnnotation.createAnnotation(obj);
        }
        catch (IOException e) {
            try {
                return PDXObject.createXObject(obj);
            }
            catch (IOException iOException) {
                return null;
            }
        }
    }

    public void setReferencedObject(PDAnnotation annotation) {
        this.getCOSDictionary().setItem(COSName.OBJ, (COSObjectable)annotation);
    }

    public void setReferencedObject(PDXObject xobject) {
        this.getCOSDictionary().setItem(COSName.OBJ, (COSObjectable)xobject);
    }
}

