/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.mime4j.field;

import java.util.Arrays;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import java.util.TimeZone;
import java.util.regex.Pattern;
import org.apache.james.mime4j.codec.DecodeMonitor;
import org.apache.james.mime4j.codec.EncoderUtil;
import org.apache.james.mime4j.dom.FieldParser;
import org.apache.james.mime4j.dom.address.Address;
import org.apache.james.mime4j.dom.address.Mailbox;
import org.apache.james.mime4j.dom.field.AddressListField;
import org.apache.james.mime4j.dom.field.ContentDispositionField;
import org.apache.james.mime4j.dom.field.ContentTransferEncodingField;
import org.apache.james.mime4j.dom.field.ContentTypeField;
import org.apache.james.mime4j.dom.field.DateTimeField;
import org.apache.james.mime4j.dom.field.MailboxField;
import org.apache.james.mime4j.dom.field.MailboxListField;
import org.apache.james.mime4j.dom.field.MimeVersionField;
import org.apache.james.mime4j.dom.field.ParsedField;
import org.apache.james.mime4j.dom.field.UnstructuredField;
import org.apache.james.mime4j.field.AddressListFieldImpl;
import org.apache.james.mime4j.field.ContentDispositionFieldImpl;
import org.apache.james.mime4j.field.ContentTransferEncodingFieldImpl;
import org.apache.james.mime4j.field.ContentTypeFieldImpl;
import org.apache.james.mime4j.field.DateTimeFieldImpl;
import org.apache.james.mime4j.field.MailboxFieldImpl;
import org.apache.james.mime4j.field.MailboxListFieldImpl;
import org.apache.james.mime4j.field.MimeVersionFieldLenientImpl;
import org.apache.james.mime4j.field.UnstructuredFieldImpl;
import org.apache.james.mime4j.field.address.AddressFormatter;
import org.apache.james.mime4j.stream.NameValuePair;
import org.apache.james.mime4j.stream.RawField;
import org.apache.james.mime4j.util.MimeUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Fields {
    private static final Pattern FIELD_NAME_PATTERN = Pattern.compile("[\\x21-\\x39\\x3b-\\x7e]+");

    private Fields() {
    }

    public static MimeVersionField version(String ver) {
        return Fields.parse(MimeVersionFieldLenientImpl.PARSER, "MIME-Version", ver);
    }

    public static ContentTypeField contentType(String contentType) {
        return Fields.parse(ContentTypeFieldImpl.PARSER, "Content-Type", contentType);
    }

    public static ContentTypeField contentType(String mimeType, Map<String, String> parameters) {
        if (!Fields.isValidMimeType(mimeType)) {
            throw new IllegalArgumentException();
        }
        if (parameters == null || parameters.isEmpty()) {
            return Fields.parse(ContentTypeFieldImpl.PARSER, "Content-Type", mimeType);
        }
        StringBuilder sb = new StringBuilder(mimeType);
        for (Map.Entry<String, String> entry : parameters.entrySet()) {
            sb.append("; ");
            sb.append(EncoderUtil.encodeHeaderParameter(entry.getKey(), entry.getValue()));
        }
        String contentType = sb.toString();
        return Fields.contentType(contentType);
    }

    public static ContentTypeField contentType(String mimeType, Iterable<NameValuePair> parameters) {
        if (!Fields.isValidMimeType(mimeType)) {
            throw new IllegalArgumentException(mimeType + " is not a valid MIME type");
        }
        if (parameters == null) {
            return Fields.parse(ContentTypeFieldImpl.PARSER, "Content-Type", mimeType);
        }
        StringBuilder sb = new StringBuilder(mimeType);
        for (NameValuePair param : parameters) {
            sb.append("; ");
            String name = param.getName();
            String value = param.getValue();
            sb.append(EncoderUtil.encodeHeaderParameter(name, value != null ? value : ""));
        }
        String contentType = sb.toString();
        return Fields.contentType(contentType);
    }

    public static ContentTypeField contentType(String mimeType, NameValuePair ... parameters) {
        return Fields.contentType(mimeType, parameters != null || parameters.length == 0 ? Arrays.asList(parameters) : null);
    }

    public static ContentTransferEncodingField contentTransferEncoding(String contentTransferEncoding) {
        return Fields.parse(ContentTransferEncodingFieldImpl.PARSER, "Content-Transfer-Encoding", contentTransferEncoding);
    }

    public static ContentDispositionField contentDisposition(String contentDisposition) {
        return Fields.parse(ContentDispositionFieldImpl.PARSER, "Content-Disposition", contentDisposition);
    }

    public static ContentDispositionField contentDisposition(String dispositionType, Map<String, String> parameters) {
        if (!Fields.isValidDispositionType(dispositionType)) {
            throw new IllegalArgumentException();
        }
        if (parameters == null || parameters.isEmpty()) {
            return Fields.parse(ContentDispositionFieldImpl.PARSER, "Content-Disposition", dispositionType);
        }
        StringBuilder sb = new StringBuilder(dispositionType);
        for (Map.Entry<String, String> entry : parameters.entrySet()) {
            sb.append("; ");
            sb.append(EncoderUtil.encodeHeaderParameter(entry.getKey(), entry.getValue()));
        }
        String contentDisposition = sb.toString();
        return Fields.contentDisposition(contentDisposition);
    }

    public static ContentDispositionField contentDisposition(String dispositionType, Iterable<NameValuePair> parameters) {
        if (!Fields.isValidDispositionType(dispositionType)) {
            throw new IllegalArgumentException();
        }
        if (parameters == null) {
            return Fields.parse(ContentDispositionFieldImpl.PARSER, "Content-Disposition", dispositionType);
        }
        StringBuilder sb = new StringBuilder(dispositionType);
        for (NameValuePair param : parameters) {
            sb.append("; ");
            String name = param.getName();
            String value = param.getValue();
            sb.append(EncoderUtil.encodeHeaderParameter(name, value != null ? value : ""));
        }
        String contentDisposition = sb.toString();
        return Fields.contentDisposition(contentDisposition);
    }

    public static ContentDispositionField contentDisposition(String dispositionType, String filename) {
        return Fields.contentDisposition(dispositionType, filename, -1L, null, null, null);
    }

    public static ContentDispositionField contentDisposition(String dispositionType, String filename, long size) {
        return Fields.contentDisposition(dispositionType, filename, size, null, null, null);
    }

    public static ContentDispositionField contentDisposition(String dispositionType, String filename, long size, Date creationDate, Date modificationDate, Date readDate) {
        HashMap<String, String> parameters = new HashMap<String, String>();
        if (filename != null) {
            parameters.put("filename", filename);
        }
        if (size >= 0L) {
            parameters.put("size", Long.toString(size));
        }
        if (creationDate != null) {
            parameters.put("creation-date", MimeUtil.formatDate(creationDate, null));
        }
        if (modificationDate != null) {
            parameters.put("modification-date", MimeUtil.formatDate(modificationDate, null));
        }
        if (readDate != null) {
            parameters.put("read-date", MimeUtil.formatDate(readDate, null));
        }
        return Fields.contentDisposition(dispositionType, parameters);
    }

    public static DateTimeField date(Date date) {
        return Fields.date0("Date", date, null);
    }

    public static DateTimeField date(String fieldName, Date date) {
        Fields.checkValidFieldName(fieldName);
        return Fields.date0(fieldName, date, null);
    }

    public static DateTimeField date(String fieldName, Date date, TimeZone zone) {
        Fields.checkValidFieldName(fieldName);
        return Fields.date0(fieldName, date, zone);
    }

    public static UnstructuredField generateMessageId(String hostname) {
        String fieldValue = MimeUtil.createUniqueMessageId(hostname);
        return Fields.parse(UnstructuredFieldImpl.PARSER, "Message-ID", fieldValue);
    }

    public static UnstructuredField messageId(String messageId) {
        return Fields.parse(UnstructuredFieldImpl.PARSER, "Message-ID", messageId);
    }

    public static UnstructuredField subject(String subject) {
        int usedCharacters = "Subject".length() + 2;
        String fieldValue = EncoderUtil.encodeIfNecessary(subject, EncoderUtil.Usage.TEXT_TOKEN, usedCharacters);
        return Fields.parse(UnstructuredFieldImpl.PARSER, "Subject", fieldValue);
    }

    public static MailboxField sender(Mailbox mailbox) {
        return Fields.mailbox0("Sender", mailbox);
    }

    public static MailboxListField from(Mailbox mailbox) {
        return Fields.mailboxList0("From", Collections.singleton(mailbox));
    }

    public static MailboxListField from(Mailbox ... mailboxes) {
        return Fields.mailboxList0("From", Arrays.asList(mailboxes));
    }

    public static MailboxListField from(Iterable<Mailbox> mailboxes) {
        return Fields.mailboxList0("From", mailboxes);
    }

    public static AddressListField to(Address address) {
        return Fields.addressList0("To", Collections.singleton(address));
    }

    public static AddressListField to(Address ... addresses) {
        return Fields.addressList0("To", Arrays.asList(addresses));
    }

    public static AddressListField to(Iterable<Address> addresses) {
        return Fields.addressList0("To", addresses);
    }

    public static AddressListField cc(Address address) {
        return Fields.addressList0("Cc", Collections.singleton(address));
    }

    public static AddressListField cc(Address ... addresses) {
        return Fields.addressList0("Cc", Arrays.asList(addresses));
    }

    public static AddressListField cc(Iterable<Address> addresses) {
        return Fields.addressList0("Cc", addresses);
    }

    public static AddressListField bcc(Address address) {
        return Fields.addressList0("Bcc", Collections.singleton(address));
    }

    public static AddressListField bcc(Address ... addresses) {
        return Fields.addressList0("Bcc", Arrays.asList(addresses));
    }

    public static AddressListField bcc(Iterable<Address> addresses) {
        return Fields.addressList0("Bcc", addresses);
    }

    public static AddressListField replyTo(Address address) {
        return Fields.addressList0("Reply-To", Collections.singleton(address));
    }

    public static AddressListField replyTo(Address ... addresses) {
        return Fields.addressList0("Reply-To", Arrays.asList(addresses));
    }

    public static AddressListField replyTo(Iterable<Address> addresses) {
        return Fields.addressList0("Reply-To", addresses);
    }

    public static MailboxField mailbox(String fieldName, Mailbox mailbox) {
        Fields.checkValidFieldName(fieldName);
        return Fields.mailbox0(fieldName, mailbox);
    }

    public static MailboxListField mailboxList(String fieldName, Iterable<Mailbox> mailboxes) {
        Fields.checkValidFieldName(fieldName);
        return Fields.mailboxList0(fieldName, mailboxes);
    }

    public static AddressListField addressList(String fieldName, Iterable<? extends Address> addresses) {
        Fields.checkValidFieldName(fieldName);
        return Fields.addressList0(fieldName, addresses);
    }

    private static DateTimeField date0(String fieldName, Date date, TimeZone zone) {
        String formattedDate = MimeUtil.formatDate(date, zone);
        return Fields.parse(DateTimeFieldImpl.PARSER, fieldName, formattedDate);
    }

    private static MailboxField mailbox0(String fieldName, Mailbox mailbox) {
        String fieldValue = Fields.encodeAddresses(Collections.singleton(mailbox));
        return Fields.parse(MailboxFieldImpl.PARSER, fieldName, fieldValue);
    }

    private static MailboxListField mailboxList0(String fieldName, Iterable<Mailbox> mailboxes) {
        String fieldValue = Fields.encodeAddresses(mailboxes);
        return Fields.parse(MailboxListFieldImpl.PARSER, fieldName, fieldValue);
    }

    private static AddressListField addressList0(String fieldName, Iterable<? extends Address> addresses) {
        String fieldValue = Fields.encodeAddresses(addresses);
        return Fields.parse(AddressListFieldImpl.PARSER, fieldName, fieldValue);
    }

    private static void checkValidFieldName(String fieldName) {
        if (!FIELD_NAME_PATTERN.matcher(fieldName).matches()) {
            throw new IllegalArgumentException("Invalid field name");
        }
    }

    private static boolean isValidMimeType(String mimeType) {
        if (mimeType == null) {
            return false;
        }
        int idx = mimeType.indexOf(47);
        if (idx == -1) {
            return false;
        }
        String type = mimeType.substring(0, idx);
        String subType = mimeType.substring(idx + 1);
        return EncoderUtil.isToken(type) && EncoderUtil.isToken(subType);
    }

    private static boolean isValidDispositionType(String dispositionType) {
        return dispositionType != null && EncoderUtil.isToken(dispositionType);
    }

    private static <F extends ParsedField> F parse(FieldParser<F> parser, String fieldName, String fieldBody) {
        RawField rawField = new RawField(fieldName, fieldBody);
        return parser.parse(rawField, DecodeMonitor.SILENT);
    }

    private static String encodeAddresses(Iterable<? extends Address> addresses) {
        StringBuilder sb = new StringBuilder();
        for (Address address : addresses) {
            if (sb.length() > 0) {
                sb.append(", ");
            }
            AddressFormatter.DEFAULT.encode(sb, address);
        }
        return sb.toString();
    }
}

