use utf8;

package SemanticWeb::Schema::Answer;

# ABSTRACT: An answer offered to a question; perhaps correct

use Moo;

extends qw/ SemanticWeb::Schema::Comment /;


use MooX::JSON_LD 'Answer';
use Ref::Util qw/ is_plain_hashref /;
# RECOMMEND PREREQ: Ref::Util::XS

use namespace::autoclean;

our $VERSION = 'v14.0.0';


has answer_explanation => (
    is        => 'rw',
    predicate => '_has_answer_explanation',
    json_ld   => 'answerExplanation',
);





1;

__END__

=pod

=encoding UTF-8

=head1 NAME

SemanticWeb::Schema::Answer - An answer offered to a question; perhaps correct

=head1 VERSION

version v14.0.0

=head1 DESCRIPTION

An answer offered to a question; perhaps correct, perhaps opinionated or
wrong.

=head1 ATTRIBUTES

=head2 C<answer_explanation>

C<answerExplanation>

A step-by-step or full explanation about Answer. Can outline how this
Answer was achieved or contain more broad clarification or statement about
it. 

A answer_explanation should be one of the following types:

=over

=item C<InstanceOf['SemanticWeb::Schema::Comment']>

=item C<InstanceOf['SemanticWeb::Schema::WebContent']>

=back

=head2 C<_has_answer_explanation>

A predicate for the L</answer_explanation> attribute.

=head1 SEE ALSO

L<SemanticWeb::Schema::Comment>

=head1 SOURCE

The development version is on github at L<https://github.com/robrwo/SemanticWeb-Schema>
and may be cloned from L<git://github.com/robrwo/SemanticWeb-Schema.git>

=head1 BUGS

Please report any bugs or feature requests on the bugtracker website
L<https://github.com/robrwo/SemanticWeb-Schema/issues>

When submitting a bug or request, please include a test-file or a
patch to an existing test-file that illustrates the bug or desired
feature.

=head1 AUTHOR

Robert Rothenberg <rrwo@cpan.org>

=head1 COPYRIGHT AND LICENSE

This software is Copyright (c) 2018-2022 by Robert Rothenberg.

This is free software, licensed under:

  The Artistic License 2.0 (GPL Compatible)

=cut
