#!/usr/bin/perl -w

# $Id: tiger.pl,v 1.8 2005/01/15 14:28:56 mertz Exp $
# This simple demo has been developped by C. Mertz <mertz@intuilab.com>
 
####### This file has been initially generated from tiger.svg by SVG2zinc.pm Version: Revision: 1.10 
### the idea of using the shape extension (as possible with TkZinc 
### under linux) was from Daniel Etienne! Thx!

use vars qw( $VERSION );
($VERSION) = sprintf("%d.%02d", q$Revision: 1.8 $ =~ /(\d+)\.(\d+)/);


use Tk::Zinc;
use Tk::Zinc::Debug;

my $mw = MainWindow->new();
$mw->title('tiger generated from svg file');

my ($WIDTH,$HEIGHT) = (600,600);
my $zinc = $mw->Zinc(-width => $WIDTH, -height => $HEIGHT,
		     -borderwidth => 0,
                     -backcolor => "grey90",
		     -render => 1,
                     -reshape => 1,
                     -fullreshape => 1,
		      )->pack;


&Tk::Zinc::Debug::init($zinc, 
                       -optionsToDisplay => '-tags', 
                       -optionsFormat => 'row',
                      );

my $top_group = $zinc->add('group', 1);

$text = "
Drag-Button 1 for moving the tiger,
Drag-Button 2 for zooming the tiger,
Drag-Button 3 for rotating the tiger,
esc for getting help on Tk::Zinc::Debug functions.
";

my $clip= $zinc->add('curve',1,
                     [ [0,150], [150,0], [470,20], [580, 200], [600,300], [500,560], [50,550], [10,450] ],
                     -closed => 1, -visible => 0);

$zinc->itemconfigure(1, -clip => $clip);

$zinc->add('text', 1, -position => [51,521], -anchor => 'w',
	   -priority => 20, -text => $text, -color => "white");
$zinc->add('text', 1, -position => [50,520], -anchor => 'w',
	   -priority => 20, -text => $text, -color => "black");

$zinc->add('curve',$top_group,[[122.304, 84.285], [-122.304, 84.285, 'c'], [-122.203, 86.179, 'c'], [-123.027, 86.16], [-123.851, 86.141, 'c'], [-140.305, 38.066, 'c'], [-160.833, 40.309], [-160.833, 40.309, 'c'], [-143.05, 32.956, 'c'], [-122.304, 84.285]],  -closed => 1, -linecolor => "#000000", -fillcolor => "#ffffff", -filled => 1, -linewidth => 0.172);
$zinc->add('curve',$top_group,[[118.774, 81.262], [-118.774, 81.262, 'c'], [-119.323, 83.078, 'c'], [-120.092, 82.779], [-120.86, 82.481, 'c'], [-119.977, 31.675, 'c'], [-140.043, 26.801], [-140.043, 26.801, 'c'], [-120.82, 25.937, 'c'], [-118.774, 81.262]],  -closed => 1, -linecolor => "#000000", -fillcolor => "#ffffff", -filled => 1, -linewidth => 0.172);
$zinc->add('curve',$top_group,[[91.284, 123.59], [-91.284, 123.59, 'c'], [-89.648, 124.55, 'c'], [-90.118, 125.227], [-90.589, 125.904, 'c'], [-139.763, 113.102, 'c'], [-149.218, 131.459], [-149.218, 131.459, 'c'], [-145.539, 112.572, 'c'], [-91.284, 123.59]],  -closed => 1, -linecolor => "#000000", -fillcolor => "#ffffff", -filled => 1, -linewidth => 0.172);
$zinc->add('curve',$top_group,[[94.093, 133.801], [-94.093, 133.801, 'c'], [-92.237, 134.197, 'c'], [-92.471, 134.988], [-92.704, 135.779, 'c'], [-143.407, 139.121, 'c'], [-146.597, 159.522], [-146.597, 159.522, 'c'], [-149.055, 140.437, 'c'], [-94.093, 133.801]],  -closed => 1, -linecolor => "#000000", -fillcolor => "#ffffff", -filled => 1, -linewidth => 0.172);
$zinc->add('curve',$top_group,[[98.304, 128.276], [-98.304, 128.276, 'c'], [-96.526, 128.939, 'c'], [-96.872, 129.687], [-97.218, 130.435, 'c'], [-147.866, 126.346, 'c'], [-153.998, 146.064], [-153.998, 146.064, 'c'], [-153.646, 126.825, 'c'], [-98.304, 128.276]],  -closed => 1, -linecolor => "#000000", -fillcolor => "#ffffff", -filled => 1, -linewidth => 0.172);
$zinc->add('curve',$top_group,[[109.009, 110.072], [-109.009, 110.072, 'c'], [-107.701, 111.446, 'c'], [-108.34, 111.967], [-108.979, 112.488, 'c'], [-152.722, 86.634, 'c'], [-166.869, 101.676], [-166.869, 101.676, 'c'], [-158.128, 84.533, 'c'], [-109.009, 110.072]],  -closed => 1, -linecolor => "#000000", -fillcolor => "#ffffff", -filled => 1, -linewidth => 0.172);
$zinc->add('curve',$top_group,[[116.554, 114.263], [-116.554, 114.263, 'c'], [-115.098, 115.48, 'c'], [-115.674, 116.071], [-116.25, 116.661, 'c'], [-162.638, 95.922, 'c'], [-174.992, 112.469], [-174.992, 112.469, 'c'], [-168.247, 94.447, 'c'], [-116.554, 114.263]],  -closed => 1, -linecolor => "#000000", -fillcolor => "#ffffff", -filled => 1, -linewidth => 0.172);
$zinc->add('curve',$top_group,[[119.154, 118.335], [-119.154, 118.335, 'c'], [-117.546, 119.343, 'c'], [-118.036, 120.006], [-118.526, 120.669, 'c'], [-167.308, 106.446, 'c'], [-177.291, 124.522], [-177.291, 124.522, 'c'], [-173.066, 105.749, 'c'], [-119.154, 118.335]],  -closed => 1, -linecolor => "#000000", -fillcolor => "#ffffff", -filled => 1, -linewidth => 0.172);
$zinc->add('curve',$top_group,[[108.42, 118.949], [-108.42, 118.949, 'c'], [-107.298, 120.48, 'c'], [-107.999, 120.915], [-108.7, 121.35, 'c'], [-148.769, 90.102, 'c'], [-164.727, 103.207], [-164.727, 103.207, 'c'], [-153.862, 87.326, 'c'], [-108.42, 118.949]],  -closed => 1, -linecolor => "#000000", -fillcolor => "#ffffff", -filled => 1, -linewidth => 0.172);
$zinc->add('curve',$top_group,[[128.2, 90], [-128.2, 90, 'c'], [-127.6, 91.8, 'c'], [-128.4, 92], [-129.2, 92.2, 'c'], [-157.8, 50.2, 'c'], [-177.001, 57.8], [-177.001, 57.8, 'c'], [-161.8, 46, 'c'], [-128.2, 90]],  -closed => 1, -linecolor => "#000000", -fillcolor => "#ffffff", -filled => 1, -linewidth => 0.172);
$zinc->add('curve',$top_group,[[127.505, 96.979], [-127.505, 96.979, 'c'], [-126.53, 98.608, 'c'], [-127.269, 98.975], [-128.007, 99.343, 'c'], [-164.992, 64.499, 'c'], [-182.101, 76.061], [-182.101, 76.061, 'c'], [-169.804, 61.261, 'c'], [-127.505, 96.979]],  -closed => 1, -linecolor => "#000000", -fillcolor => "#ffffff", -filled => 1, -linewidth => 0.172);
$zinc->add('curve',$top_group,[[127.62, 101.349], [-127.62, 101.349, 'c'], [-126.498, 102.88, 'c'], [-127.199, 103.315], [-127.9, 103.749, 'c'], [-167.969, 72.502, 'c'], [-183.927, 85.607], [-183.927, 85.607, 'c'], [-173.062, 69.726, 'c'], [-127.62, 101.349]],  -closed => 1, -linecolor => "#000000", -fillcolor => "#ffffff", -filled => 1, -linewidth => 0.172);
$zinc->add('curve',$top_group,[[129.83, 103.065], [-129.327, 109.113, 'c'], [-128.339, 115.682, 'c'], [-126.6, 118.801], [-126.6, 118.801, 'c'], [-130.2, 131.201, 'c'], [-121.4, 144.401], [-121.4, 144.401, 'c'], [-121.8, 151.601, 'c'], [-120.2, 154.801], [-120.2, 154.801, 'c'], [-116.2, 163.201, 'c'], [-111.4, 164.001], [-107.516, 164.648, 'c'], [-98.793, 167.717, 'c'], [-88.932, 169.121], [-88.932, 169.121, 'c'], [-71.8, 183.201, 'c'], [-75, 196.001], [-75, 196.001, 'c'], [-75.4, 212.401, 'c'], [-79, 214.001], [-79, 214.001, 'c'], [-67.4, 202.801, 'c'], [-77, 219.601], [-81.4, 238.401], [-81.4, 238.401, 'c'], [-55.8, 216.801, 'c'], [-71.4, 235.201], [-81.4, 261.201], [-81.4, 261.201, 'c'], [-61.8, 242.801, 'c'], [-69, 251.201], [-72.2, 260.001], [-72.2, 260.001, 'c'], [-29, 232.801, 'c'], [-59.8, 262.401], [-59.8, 262.401, 'c'], [-51.8, 258.801, 'c'], [-47.4, 261.601], [-47.4, 261.601, 'c'], [-40.6, 260.401, 'c'], [-41.4, 262.001], [-41.4, 262.001, 'c'], [-62.2, 272.401, 'c'], [-65.8, 290.801], [-65.8, 290.801, 'c'], [-57.4, 280.801, 'c'], [-60.6, 291.601], [-60.2, 303.201], [-60.2, 303.201, 'c'], [-56.2, 281.601, 'c'], [-56.6, 319.201], [-56.6, 319.201, 'c'], [-37.4, 301.201, 'c'], [-49, 322.001], [-49, 338.801], [-49, 338.801, 'c'], [-33.8, 322.401, 'c'], [-40.2, 335.201], [-40.2, 335.201, 'c'], [-30.2, 326.401, 'c'], [-34.2, 341.601], [-34.2, 341.601, 'c'], [-35, 352.001, 'c'], [-30.6, 340.801], [-30.6, 340.801, 'c'], [-14.6, 310.201, 'c'], [-20.6, 336.401], [-20.6, 336.401, 'c'], [-21.4, 355.601, 'c'], [-16.6, 340.801], [-16.6, 340.801, 'c'], [-16.2, 351.201, 'c'], [-7, 358.401], [-7, 358.401, 'c'], [-8.2, 307.601, 'c'], [4.6, 343.601], [8.6, 360.001], [8.6, 360.001, 'c'], [11.4, 350.801, 'c'], [11, 345.601], [11, 345.601, 'c'], [25.8, 329.201, 'c'], [19, 353.601], [19, 353.601, 'c'], [34.2, 330.801, 'c'], [31, 344.001], [31, 344.001, 'c'], [23.4, 360.001, 'c'], [25, 364.801], [25, 364.801, 'c'], [41.8, 330.001, 'c'], [43, 328.401], [43, 328.401, 'c'], [41, 370.802, 'c'], [51.8, 334.801], [51.8, 334.801, 'c'], [57.4, 346.801, 'c'], [54.6, 351.201], [54.6, 351.201, 'c'], [62.6, 343.201, 'c'], [61.8, 340.001], [61.8, 340.001, 'c'], [66.4, 331.801, 'c'], [69.2, 345.401], [69.2, 345.401, 'c'], [71, 354.801, 'c'], [72.6, 351.601], [72.6, 351.601, 'c'], [76.6, 375.602, 'c'], [77.8, 352.801], [77.8, 352.801, 'c'], [79.4, 339.201, 'c'], [72.2, 327.601], [72.2, 327.601, 'c'], [73, 324.401, 'c'], [70.2, 320.401], [70.2, 320.401, 'c'], [83.8, 342.001, 'c'], [76.6, 313.201], [76.6, 313.201, 'c'], [87.801, 321.201, 'c'], [89.001, 321.201], [89.001, 321.201, 'c'], [75.4, 298.001, 'c'], [84.2, 302.801], [84.2, 302.801, 'c'], [79, 292.401, 'c'], [97.001, 304.401], [97.001, 304.401, 'c'], [81, 288.401, 'c'], [98.601, 298.001], [98.601, 298.001, 'c'], [106.601, 304.401, 'c'], [99.001, 294.401], [99.001, 294.401, 'c'], [84.6, 278.401, 'c'], [106.601, 296.401], [106.601, 296.401, 'c'], [118.201, 312.801, 'c'], [119.001, 315.601], [119.001, 315.601, 'c'], [109.001, 286.401, 'c'], [104.601, 283.601], [104.601, 283.601, 'c'], [113.001, 247.201, 'c'], [154.201, 262.801], [154.201, 262.801, 'c'], [161.001, 280.001, 'c'], [165.401, 261.601], [165.401, 261.601, 'c'], [178.201, 255.201, 'c'], [189.401, 282.801], [189.401, 282.801, 'c'], [193.401, 269.201, 'c'], [192.601, 266.401], [192.601, 266.401, 'c'], [199.401, 267.601, 'c'], [198.601, 266.401], [198.601, 266.401, 'c'], [211.801, 270.801, 'c'], [213.001, 270.001], [213.001, 270.001, 'c'], [219.801, 276.801, 'c'], [220.201, 273.201], [220.201, 273.201, 'c'], [229.401, 276.001, 'c'], [227.401, 272.401], [227.401, 272.401, 'c'], [236.201, 288.001, 'c'], [236.601, 291.601], [239.001, 277.601], [241.001, 280.401], [241.001, 280.401, 'c'], [242.601, 272.801, 'c'], [241.801, 271.601], [241.001, 270.401, 'c'], [261.801, 278.401, 'c'], [266.601, 299.201], [268.601, 307.601], [268.601, 307.601, 'c'], [274.601, 292.801, 'c'], [273.001, 288.801], [273.001, 288.801, 'c'], [278.201, 289.601, 'c'], [278.601, 294.001], [278.601, 294.001, 'c'], [282.601, 270.801, 'c'], [277.801, 264.801], [277.801, 264.801, 'c'], [282.201, 264.001, 'c'], [283.401, 267.601], [283.401, 260.401], [283.401, 260.401, 'c'], [290.601, 261.201, 'c'], [290.601, 258.801], [290.601, 258.801, 'c'], [295.001, 254.801, 'c'], [297.001, 259.601], [297.001, 259.601, 'c'], [284.601, 224.401, 'c'], [303.001, 243.601], [303.001, 243.601, 'c'], [310.201, 254.401, 'c'], [306.601, 235.601], [303.001, 216.801, 'c'], [299.001, 215.201, 'c'], [303.801, 214.801], [303.801, 214.801, 'c'], [304.601, 211.201, 'c'], [302.601, 209.601], [300.601, 208.001, 'c'], [303.801, 209.601, 'c'], [303.801, 209.601], [303.801, 209.601, 'c'], [308.601, 213.601, 'c'], [303.401, 191.601], [303.401, 191.601, 'c'], [309.801, 193.201, 'c'], [297.801, 164.001], [297.801, 164.001, 'c'], [300.601, 161.601, 'c'], [296.601, 153.201], [296.601, 153.201, 'c'], [304.601, 157.601, 'c'], [307.401, 156.001], [307.401, 156.001, 'c'], [307.001, 154.401, 'c'], [303.801, 150.401], [303.801, 150.401, 'c'], [282.201, 95.6, 'c'], [302.601, 117.601], [302.601, 117.601, 'c'], [314.451, 131.151, 'c'], [308.051, 108.351], [308.051, 108.351, 'c'], [298.94, 84.341, 'c'], [299.717, 80.045], [-129.83, 103.065]],  -closed => 1, -linecolor => "#000000", -fillcolor => "#ffffff", -filled => 1);
$zinc->add('curve',$top_group,[[299.717, 80.245], [300.345, 80.426, 'c'], [302.551, 81.55, 'c'], [303.801, 83.2], [303.801, 83.2, 'c'], [310.601, 94, 'c'], [305.401, 75.6], [305.401, 75.6, 'c'], [296.201, 46.8, 'c'], [305.001, 58], [305.001, 58, 'c'], [311.001, 65.2, 'c'], [307.801, 51.6], [303.936, 35.173, 'c'], [301.401, 28.8, 'c'], [301.401, 28.8], [301.401, 28.8, 'c'], [313.001, 33.6, 'c'], [286.201, -6], [295.001, -2.4], [295.001, -2.4, 'c'], [275.401, -42, 'c'], [253.801, -47.2], [245.801, -53.2], [245.801, -53.2, 'c'], [284.201, -91.2, 'c'], [271.401, -128], [271.401, -128, 'c'], [264.601, -133.2, 'c'], [255.001, -124], [255.001, -124, 'c'], [248.601, -119.2, 'c'], [242.601, -120.8], [242.601, -120.8, 'c'], [211.801, -119.6, 'c'], [209.801, -119.6], [207.801, -119.6, 'c'], [173.001, -156.8, 'c'], [107.401, -139.2], [107.401, -139.2, 'c'], [102.201, -137.2, 'c'], [97.801, -138.4], [97.801, -138.4, 'c'], [79.4, -154.4, 'c'], [30.6, -131.6], [30.6, -131.6, 'c'], [20.6, -129.6, 'c'], [19, -129.6], [17.4, -129.6, 'c'], [14.6, -129.6, 'c'], [6.6, -123.2], [-1.4, -116.8, 'c'], [-1.8, -116, 'c'], [-3.8, -114.4], [-3.8, -114.4, 'c'], [-20.2, -103.2, 'c'], [-25, -102.4], [-25, -102.4, 'c'], [-36.6, -96, 'c'], [-41, -86], [-44.6, -84.8], [-44.6, -84.8, 'c'], [-46.2, -77.6, 'c'], [-46.6, -76.4], [-46.6, -76.4, 'c'], [-51.4, -72.8, 'c'], [-52.2, -67.2], [-52.2, -67.2, 'c'], [-61, -61.2, 'c'], [-60.6, -56.8], [-60.6, -56.8, 'c'], [-62.2, -51.6, 'c'], [-63, -46.8], [-63, -46.8, 'c'], [-70.2, -42, 'c'], [-69.4, -39.2], [-69.4, -39.2, 'c'], [-77, -25.2, 'c'], [-75.8, -18.4], [-75.8, -18.4, 'c'], [-82.2, -18.8, 'c'], [-85, -16.4], [-85, -16.4, 'c'], [-85.8, -11.6, 'c'], [-87.4, -11.2], [-87.4, -11.2, 'c'], [-90.2, -10, 'c'], [-87.8, -6], [-87.8, -6, 'c'], [-89.4, -3.2, 'c'], [-89.8, -1.6], [-89.8, -1.6, 'c'], [-89, 1.2, 'c'], [-93.4, 6.8], [-93.4, 6.8, 'c'], [-99.8, 25.6, 'c'], [-97.8, 30.8], [-97.8, 30.8, 'c'], [-97.4, 35.6, 'c'], [-100.2, 37.2], [-100.2, 37.2, 'c'], [-103.8, 36.8, 'c'], [-95.4, 48.8], [-95.4, 48.8, 'c'], [-94.6, 50, 'c'], [-97.8, 52.4], [-97.8, 52.4, 'c'], [-115, 56, 'c'], [-117.4, 72.4], [-117.4, 72.4, 'c'], [-131, 87.2, 'c'], [-131, 92.4], [-131, 94.705, 'c'], [-130.729, 97.852, 'c'], [-130.03, 102.465], [-130.03, 102.465, 'c'], [-130.6, 110.801, 'c'], [-103, 111.601], [-75.4, 112.401, 'c'], [299.717, 80.245, 'c'], [299.717, 80.245]],  -closed => 1, -linecolor => "#000000", -fillcolor => "#cc7226", -filled => 1);

$zinc->add('curve',$top_group,[[115.6, 102.6], [-140.6, 63.2, 'c'], [-126.2, 119.601, 'c'], [-126.2, 119.601], [-117.4, 154.001, 'c'], [12.2, 116.401, 'c'], [12.2, 116.401], [12.2, 116.401, 'c'], [181.001, 86, 'c'], [192.201, 82], [203.401, 78, 'c'], [298.601, 84.4, 'c'], [298.601, 84.4], [293.001, 67.6], [228.201, 21.2, 'c'], [209.001, 44.4, 'c'], [195.401, 40.4], [181.801, 36.4, 'c'], [184.201, 46, 'c'], [181.001, 46.8], [177.801, 47.6, 'c'], [138.601, 22.8, 'c'], [132.201, 23.6], [125.801, 24.4, 'c'], [100.459, 0.649, 'c'], [115.401, 32.4], [131.401, 66.4, 'c'], [57, 71.6, 'c'], [40.2, 60.4], [23.4, 49.2, 'c'], [47.4, 78.8, 'c'], [47.4, 78.8], [65.8, 98.8, 'c'], [31.4, 82, 'c'], [31.4, 82], [-3, 69.2, 'c'], [-27, 94.8, 'c'], [-30.2, 95.6], [-33.4, 96.4, 'c'], [-38.2, 99.6, 'c'], [-39, 93.2], [-39.8, 86.8, 'c'], [-47.31, 70.099, 'c'], [-79, 96.4], [-99, 113.001, 'c'], [-112.8, 91, 'c'], [-112.8, 91], [-115.6, 102.6]],  -closed => 1, -fillcolor => "#cc7226", -filled => 1, -linecolor => "#cc7226");
$zinc->add('curve',$top_group,[[133.51, 25.346], [127.11, 26.146, 'c'], [101.743, 2.407, 'c'], [116.71, 34.146], [133.31, 69.346, 'c'], [58.31, 73.346, 'c'], [41.51, 62.146], [24.709, 50.946, 'c'], [48.71, 80.546, 'c'], [48.71, 80.546], [67.11, 100.546, 'c'], [32.709, 83.746, 'c'], [32.709, 83.746], [-1.691, 70.946, 'c'], [-25.691, 96.546, 'c'], [-28.891, 97.346], [-32.091, 98.146, 'c'], [-36.891, 101.346, 'c'], [-37.691, 94.946], [-38.491, 88.546, 'c'], [-45.87, 72.012, 'c'], [-77.691, 98.146], [-98.927, 115.492, 'c'], [-112.418, 94.037, 'c'], [-112.418, 94.037], [-115.618, 104.146], [-140.618, 64.346, 'c'], [-125.546, 122.655, 'c'], [-125.546, 122.655], [-116.745, 157.056, 'c'], [13.509, 118.146, 'c'], [13.509, 118.146], [13.509, 118.146, 'c'], [182.31, 87.746, 'c'], [193.51, 83.746], [204.71, 79.746, 'c'], [299.038, 86.073, 'c'], [299.038, 86.073], [293.51, 68.764], [228.71, 22.364, 'c'], [210.31, 46.146, 'c'], [196.71, 42.146], [183.11, 38.146, 'c'], [185.51, 47.746, 'c'], [182.31, 48.546], [179.11, 49.346, 'c'], [139.91, 24.546, 'c'], [133.51, 25.346]],  -closed => 1, -fillcolor => "#e87f3a", -filled => 1, -linecolor => "#e87f3a");
$zinc->add('curve',$top_group,[[134.819, 27.091], [128.419, 27.891, 'c'], [103.685, 3.862, 'c'], [118.019, 35.891], [134.219, 72.092, 'c'], [59.619, 75.092, 'c'], [42.819, 63.892], [26.019, 52.692, 'c'], [50.019, 82.292, 'c'], [50.019, 82.292], [68.419, 102.292, 'c'], [34.019, 85.492, 'c'], [34.019, 85.492], [-0.381, 72.692, 'c'], [-24.382, 98.292, 'c'], [-27.582, 99.092], [-30.782, 99.892, 'c'], [-35.582, 103.092, 'c'], [-36.382, 96.692], [-37.182, 90.292, 'c'], [-44.43, 73.925, 'c'], [-76.382, 99.892], [-98.855, 117.983, 'c'], [-112.036, 97.074, 'c'], [-112.036, 97.074], [-115.636, 105.692], [-139.436, 66.692, 'c'], [-124.891, 125.71, 'c'], [-124.891, 125.71], [-116.091, 160.11, 'c'], [14.819, 119.892, 'c'], [14.819, 119.892], [14.819, 119.892, 'c'], [183.619, 89.492, 'c'], [194.819, 85.492], [206.019, 81.492, 'c'], [299.474, 87.746, 'c'], [299.474, 87.746], [294.02, 69.928], [229.219, 23.528, 'c'], [211.619, 47.891, 'c'], [198.019, 43.891], [184.419, 39.891, 'c'], [186.819, 49.491, 'c'], [183.619, 50.292], [180.419, 51.092, 'c'], [141.219, 26.291, 'c'], [134.819, 27.091]],  -closed => 1, -fillcolor => "#ea8c4d", -filled => 1, -linecolor => "#ea8c4d");
$zinc->add('curve',$top_group,[[136.128, 28.837], [129.728, 29.637, 'c'], [104.999, 5.605, 'c'], [119.328, 37.637], [136.128, 75.193, 'c'], [60.394, 76.482, 'c'], [44.128, 65.637], [27.328, 54.437, 'c'], [51.328, 84.037, 'c'], [51.328, 84.037], [69.728, 104.037, 'c'], [35.328, 87.237, 'c'], [35.328, 87.237], [0.928, 74.437, 'c'], [-23.072, 100.037, 'c'], [-26.272, 100.837], [-29.472, 101.637, 'c'], [-34.272, 104.837, 'c'], [-35.072, 98.437], [-35.872, 92.037, 'c'], [-42.989, 75.839, 'c'], [-75.073, 101.637], [-98.782, 120.474, 'c'], [-111.655, 100.11, 'c'], [-111.655, 100.11], [-115.655, 107.237], [-137.455, 70.437, 'c'], [-124.236, 128.765, 'c'], [-124.236, 128.765], [-115.436, 163.165, 'c'], [16.128, 121.637, 'c'], [16.128, 121.637], [16.128, 121.637, 'c'], [184.928, 91.237, 'c'], [196.129, 87.237], [207.329, 83.237, 'c'], [299.911, 89.419, 'c'], [299.911, 89.419], [294.529, 71.092], [229.729, 24.691, 'c'], [212.929, 49.637, 'c'], [199.329, 45.637], [185.728, 41.637, 'c'], [188.128, 51.237, 'c'], [184.928, 52.037], [181.728, 52.837, 'c'], [142.528, 28.037, 'c'], [136.128, 28.837]],  -closed => 1, -fillcolor => "#ec9961", -filled => 1, -linecolor => "#ec9961");
$zinc->add('curve',$top_group,[[137.438, 30.583], [131.037, 31.383, 'c'], [106.814, 7.129, 'c'], [120.637, 39.383], [137.438, 78.583, 'c'], [62.237, 78.583, 'c'], [45.437, 67.383], [28.637, 56.183, 'c'], [52.637, 85.783, 'c'], [52.637, 85.783], [71.037, 105.783, 'c'], [36.637, 88.983, 'c'], [36.637, 88.983], [2.237, 76.183, 'c'], [-21.763, 101.783, 'c'], [-24.963, 102.583], [-28.163, 103.383, 'c'], [-32.963, 106.583, 'c'], [-33.763, 100.183], [-34.563, 93.783, 'c'], [-41.548, 77.752, 'c'], [-73.763, 103.383], [-98.709, 122.965, 'c'], [-111.273, 103.146, 'c'], [-111.273, 103.146], [-115.673, 108.783], [-135.473, 73.982, 'c'], [-123.582, 131.819, 'c'], [-123.582, 131.819], [-114.782, 166.22, 'c'], [17.437, 123.383, 'c'], [17.437, 123.383], [17.437, 123.383, 'c'], [186.238, 92.983, 'c'], [197.438, 88.983], [208.638, 84.983, 'c'], [300.347, 91.092, 'c'], [300.347, 91.092], [295.038, 72.255], [230.238, 25.855, 'c'], [214.238, 51.383, 'c'], [200.638, 47.383], [187.038, 43.383, 'c'], [189.438, 52.983, 'c'], [186.238, 53.783], [183.038, 54.583, 'c'], [143.838, 29.783, 'c'], [137.438, 30.583]],  -closed => 1, -fillcolor => "#eea575", -filled => 1, -linecolor => "#eea575");
$zinc->add('curve',$top_group,[[138.747, 32.328], [132.347, 33.128, 'c'], [106.383, 9.677, 'c'], [121.947, 41.128], [141.147, 79.928, 'c'], [63.546, 80.328, 'c'], [46.746, 69.128], [29.946, 57.928, 'c'], [53.946, 87.528, 'c'], [53.946, 87.528], [72.346, 107.528, 'c'], [37.946, 90.728, 'c'], [37.946, 90.728], [3.546, 77.928, 'c'], [-20.454, 103.528, 'c'], [-23.654, 104.328], [-26.854, 105.128, 'c'], [-31.654, 108.328, 'c'], [-32.454, 101.928], [-33.254, 95.528, 'c'], [-40.108, 79.665, 'c'], [-72.454, 105.128], [-98.636, 125.456, 'c'], [-110.891, 106.183, 'c'], [-110.891, 106.183], [-115.691, 110.328], [-133.691, 77.128, 'c'], [-122.927, 134.874, 'c'], [-122.927, 134.874], [-114.127, 169.274, 'c'], [18.746, 125.128, 'c'], [18.746, 125.128], [18.746, 125.128, 'c'], [187.547, 94.728, 'c'], [198.747, 90.728], [209.947, 86.728, 'c'], [300.783, 92.764, 'c'], [300.783, 92.764], [295.547, 73.419], [230.747, 27.019, 'c'], [215.547, 53.128, 'c'], [201.947, 49.128], [188.347, 45.128, 'c'], [190.747, 54.728, 'c'], [187.547, 55.528], [184.347, 56.328, 'c'], [145.147, 31.528, 'c'], [138.747, 32.328]],  -closed => 1, -fillcolor => "#f1b288", -filled => 1, -linecolor => "#f1b288");
$zinc->add('curve',$top_group,[[140.056, 34.073], [133.655, 34.873, 'c'], [107.313, 11.613, 'c'], [123.255, 42.873], [143.656, 82.874, 'c'], [64.855, 82.074, 'c'], [48.055, 70.874], [31.255, 59.674, 'c'], [55.255, 89.274, 'c'], [55.255, 89.274], [73.655, 109.274, 'c'], [39.255, 92.474, 'c'], [39.255, 92.474], [4.855, 79.674, 'c'], [-19.145, 105.274, 'c'], [-22.345, 106.074], [-25.545, 106.874, 'c'], [-30.345, 110.074, 'c'], [-31.145, 103.674], [-31.945, 97.274, 'c'], [-38.668, 81.578, 'c'], [-71.145, 106.874], [-98.564, 127.947, 'c'], [-110.509, 109.219, 'c'], [-110.509, 109.219], [-115.709, 111.874], [-131.709, 81.674, 'c'], [-122.273, 137.929, 'c'], [-122.273, 137.929], [-113.473, 172.329, 'c'], [20.055, 126.874, 'c'], [20.055, 126.874], [20.055, 126.874, 'c'], [188.856, 96.474, 'c'], [200.056, 92.474], [211.256, 88.474, 'c'], [301.22, 94.437, 'c'], [301.22, 94.437], [296.056, 74.583], [231.256, 28.183, 'c'], [216.856, 54.874, 'c'], [203.256, 50.874], [189.656, 46.873, 'c'], [192.056, 56.474, 'c'], [188.856, 57.274], [185.656, 58.074, 'c'], [146.456, 33.273, 'c'], [140.056, 34.073]],  -closed => 1, -fillcolor => "#f3bf9c", -filled => 1, -linecolor => "#f3bf9c");
$zinc->add('curve',$top_group,[[141.365, 35.819], [134.965, 36.619, 'c'], [107.523, 13.944, 'c'], [124.565, 44.619], [146.565, 84.219, 'c'], [66.164, 83.819, 'c'], [49.364, 72.619], [32.564, 61.419, 'c'], [56.564, 91.019, 'c'], [56.564, 91.019], [74.964, 111.019, 'c'], [40.564, 94.219, 'c'], [40.564, 94.219], [6.164, 81.419, 'c'], [-17.836, 107.019, 'c'], [-21.036, 107.819], [-24.236, 108.619, 'c'], [-29.036, 111.819, 'c'], [-29.836, 105.419], [-30.636, 99.019, 'c'], [-37.227, 83.492, 'c'], [-69.836, 108.619], [-98.491, 130.438, 'c'], [-110.127, 112.256, 'c'], [-110.127, 112.256], [-115.727, 113.419], [-130.128, 85.019, 'c'], [-121.618, 140.983, 'c'], [-121.618, 140.983], [-112.818, 175.384, 'c'], [21.364, 128.619, 'c'], [21.364, 128.619], [21.364, 128.619, 'c'], [190.165, 98.219, 'c'], [201.365, 94.219], [212.565, 90.219, 'c'], [301.656, 96.11, 'c'], [301.656, 96.11], [296.565, 75.746], [231.765, 29.346, 'c'], [218.165, 56.619, 'c'], [204.565, 52.619], [190.965, 48.619, 'c'], [193.365, 58.219, 'c'], [190.165, 59.019], [186.965, 59.819, 'c'], [147.765, 35.019, 'c'], [141.365, 35.819]],  -closed => 1, -fillcolor => "#f5ccb0", -filled => 1, -linecolor => "#f5ccb0");
$zinc->add('curve',$top_group,[[142.674, 37.565], [136.274, 38.365, 'c'], [108.832, 15.689, 'c'], [125.874, 46.365], [147.874, 85.965, 'c'], [67.474, 85.565, 'c'], [50.674, 74.365], [33.874, 63.165, 'c'], [57.874, 92.765, 'c'], [57.874, 92.765], [76.274, 112.765, 'c'], [41.874, 95.965, 'c'], [41.874, 95.965], [7.473, 83.165, 'c'], [-16.527, 108.765, 'c'], [-19.727, 109.565], [-22.927, 110.365, 'c'], [-27.727, 113.565, 'c'], [-28.527, 107.165], [-29.327, 100.765, 'c'], [-35.786, 85.405, 'c'], [-68.527, 110.365], [-98.418, 132.929, 'c'], [-109.745, 115.293, 'c'], [-109.745, 115.293], [-115.745, 114.965], [-129.346, 88.564, 'c'], [-120.963, 144.038, 'c'], [-120.963, 144.038], [-112.163, 178.438, 'c'], [22.673, 130.365, 'c'], [22.673, 130.365], [22.673, 130.365, 'c'], [191.474, 99.965, 'c'], [202.674, 95.965], [213.874, 91.965, 'c'], [302.093, 97.783, 'c'], [302.093, 97.783], [297.075, 76.91], [232.274, 30.51, 'c'], [219.474, 58.365, 'c'], [205.874, 54.365], [192.274, 50.365, 'c'], [194.674, 59.965, 'c'], [191.474, 60.765], [188.274, 61.565, 'c'], [149.074, 36.765, 'c'], [142.674, 37.565]],  -closed => 1, -fillcolor => "#f8d8c4", -filled => 1, -linecolor => "#f8d8c4");
$zinc->add('curve',$top_group,[[143.983, 39.31], [137.583, 40.11, 'c'], [110.529, 17.223, 'c'], [127.183, 48.11], [149.183, 88.91, 'c'], [68.783, 87.31, 'c'], [51.983, 76.11], [35.183, 64.91, 'c'], [59.183, 94.51, 'c'], [59.183, 94.51], [77.583, 114.51, 'c'], [43.183, 97.71, 'c'], [43.183, 97.71], [8.783, 84.91, 'c'], [-15.217, 110.51, 'c'], [-18.417, 111.31], [-21.618, 112.11, 'c'], [-26.418, 115.31, 'c'], [-27.218, 108.91], [-28.018, 102.51, 'c'], [-34.346, 87.318, 'c'], [-67.218, 112.11], [-98.345, 135.42, 'c'], [-109.363, 118.329, 'c'], [-109.363, 118.329], [-115.764, 116.51], [-128.764, 92.51, 'c'], [-120.309, 147.093, 'c'], [-120.309, 147.093], [-111.509, 181.493, 'c'], [23.983, 132.11, 'c'], [23.983, 132.11], [23.983, 132.11, 'c'], [192.783, 101.71, 'c'], [203.983, 97.71], [215.183, 93.71, 'c'], [302.529, 99.456, 'c'], [302.529, 99.456], [297.583, 78.074], [232.783, 31.673, 'c'], [220.783, 60.11, 'c'], [207.183, 56.11], [193.583, 52.11, 'c'], [195.983, 61.71, 'c'], [192.783, 62.51], [189.583, 63.31, 'c'], [150.383, 38.51, 'c'], [143.983, 39.31]],  -closed => 1, -fillcolor => "#fae5d7", -filled => 1, -linecolor => "#fae5d7");
$zinc->add('curve',$top_group,[[145.292, 41.055], [138.892, 41.855, 'c'], [112.917, 18.411, 'c'], [128.492, 49.855], [149.692, 92.656, 'c'], [70.092, 89.056, 'c'], [53.292, 77.856], [36.492, 66.656, 'c'], [60.492, 96.256, 'c'], [60.492, 96.256], [78.892, 116.256, 'c'], [44.492, 99.456, 'c'], [44.492, 99.456], [10.092, 86.656, 'c'], [-13.908, 112.256, 'c'], [-17.108, 113.056], [-20.308, 113.856, 'c'], [-25.108, 117.056, 'c'], [-25.908, 110.656], [-26.708, 104.256, 'c'], [-32.905, 89.232, 'c'], [-65.908, 113.856], [-98.273, 137.911, 'c'], [-108.982, 121.365, 'c'], [-108.982, 121.365], [-115.782, 118.056], [-128.582, 94.856, 'c'], [-119.654, 150.147, 'c'], [-119.654, 150.147], [-110.854, 184.547, 'c'], [25.292, 133.856, 'c'], [25.292, 133.856], [25.292, 133.856, 'c'], [194.093, 103.456, 'c'], [205.293, 99.456], [216.493, 95.456, 'c'], [302.965, 101.128, 'c'], [302.965, 101.128], [298.093, 79.237], [233.292, 32.837, 'c'], [222.093, 61.856, 'c'], [208.493, 57.856], [194.893, 53.855, 'c'], [197.293, 63.456, 'c'], [194.093, 64.256], [190.892, 65.056, 'c'], [151.692, 40.255, 'c'], [145.292, 41.055]],  -closed => 1, -fillcolor => "#fcf2eb", -filled => 1, -linecolor => "#fcf2eb");
$zinc->add('curve',$top_group,[[115.8, 119.601], [-128.6, 97.6, 'c'], [-119, 153.201, 'c'], [-119, 153.201], [-110.2, 187.601, 'c'], [26.6, 135.601, 'c'], [26.6, 135.601], [26.6, 135.601, 'c'], [195.401, 105.2, 'c'], [206.601, 101.2], [217.801, 97.2, 'c'], [303.401, 102.8, 'c'], [303.401, 102.8], [298.601, 80.4], [233.801, 34, 'c'], [223.401, 63.6, 'c'], [209.801, 59.6], [196.201, 55.6, 'c'], [198.601, 65.2, 'c'], [195.401, 66], [192.201, 66.8, 'c'], [153.001, 42, 'c'], [146.601, 42.8], [140.201, 43.6, 'c'], [114.981, 19.793, 'c'], [129.801, 51.6], [152.028, 99.307, 'c'], [69.041, 89.227, 'c'], [54.6, 79.6], [37.8, 68.4, 'c'], [61.8, 98, 'c'], [61.8, 98], [80.2, 118.001, 'c'], [45.8, 101.2, 'c'], [45.8, 101.2], [11.4, 88.4, 'c'], [-12.6, 114.001, 'c'], [-15.8, 114.801], [-19, 115.601, 'c'], [-23.8, 118.801, 'c'], [-24.6, 112.401], [-25.4, 106, 'c'], [-31.465, 91.144, 'c'], [-64.6, 115.601], [-98.2, 140.401, 'c'], [-108.6, 124.401, 'c'], [-108.6, 124.401], [-115.8, 119.601]],  -closed => 1, -fillcolor => "#ffffff", -filled => 1, -linecolor => "#ffffff");
$zinc->add('curve',$top_group,[[74.2, 149.601], [-74.2, 149.601, 'c'], [-81.4, 161.201, 'c'], [-60.6, 174.401], [-60.6, 174.401, 'c'], [-59.2, 175.801, 'c'], [-77.2, 171.601], [-77.2, 171.601, 'c'], [-83.4, 169.601, 'c'], [-85, 159.201], [-85, 159.201, 'c'], [-89.8, 154.801, 'c'], [-94.6, 149.201], [-99.4, 143.601, 'c'], [-74.2, 149.601, 'c'], [-74.2, 149.601]],  -closed => 1, -fillcolor => "#000000", -filled => 1, -linecolor => "#000000");
$zinc->add('curve',$top_group,[[65.8, 102], [65.8, 102, 'c'], [83.498, 128.821, 'c'], [82.9, 133.601], [81.6, 144.001, 'c'], [81.4, 153.601, 'c'], [84.6, 157.601], [87.801, 161.601, 'c'], [96.601, 194.801, 'c'], [96.601, 194.801], [96.601, 194.801, 'c'], [96.201, 196.001, 'c'], [108.601, 158.001], [108.601, 158.001, 'c'], [120.201, 142.001, 'c'], [100.201, 123.601], [100.201, 123.601, 'c'], [65, 94.8, 'c'], [65.8, 102]],  -closed => 1, -fillcolor => "#cccccc", -filled => 1, -linecolor => "#cccccc");
$zinc->add('curve',$top_group,[[54.2, 176.401], [-54.2, 176.401, 'c'], [-43, 183.601, 'c'], [-57.4, 214.801], [-51, 212.401], [-51, 212.401, 'c'], [-51.8, 223.601, 'c'], [-55, 226.001], [-47.8, 222.801], [-47.8, 222.801, 'c'], [-43, 230.801, 'c'], [-47, 235.601], [-47, 235.601, 'c'], [-30.2, 243.601, 'c'], [-31, 250.001], [-31, 250.001, 'c'], [-24.6, 242.001, 'c'], [-28.6, 235.601], [-32.6, 229.201, 'c'], [-39.8, 233.201, 'c'], [-39, 214.801], [-47.8, 218.001], [-47.8, 218.001, 'c'], [-42.2, 209.201, 'c'], [-42.2, 202.801], [-50.2, 205.201], [-50.2, 205.201, 'c'], [-34.731, 178.623, 'c'], [-45.4, 177.201], [-51.4, 176.401, 'c'], [-54.2, 176.401, 'c'], [-54.2, 176.401]],  -closed => 1, -fillcolor => "#000000", -filled => 1, -linecolor => "#000000");
$zinc->add('curve',$top_group,[[21.8, 193.201], [-21.8, 193.201, 'c'], [-19, 188.801, 'c'], [-21.8, 189.601], [-24.6, 190.401, 'c'], [-55.8, 205.201, 'c'], [-61.8, 214.801], [-61.8, 214.801, 'c'], [-27.4, 190.401, 'c'], [-21.8, 193.201]],  -closed => 1, -fillcolor => "#cccccc", -filled => 1, -linecolor => "#cccccc");
$zinc->add('curve',$top_group,[[11.4, 201.201], [-11.4, 201.201, 'c'], [-8.6, 196.801, 'c'], [-11.4, 197.601], [-14.2, 198.401, 'c'], [-45.4, 213.201, 'c'], [-51.4, 222.801], [-51.4, 222.801, 'c'], [-17, 198.401, 'c'], [-11.4, 201.201]],  -closed => 1, -fillcolor => "#cccccc", -filled => 1, -linecolor => "#cccccc");
$zinc->add('curve',$top_group,[[1.8, 186.001], [1.8, 186.001, 'c'], [4.6, 181.601, 'c'], [1.8, 182.401], [-1, 183.201, 'c'], [-32.2, 198.001, 'c'], [-38.2, 207.601], [-38.2, 207.601, 'c'], [-3.8, 183.201, 'c'], [1.8, 186.001]],  -closed => 1, -fillcolor => "#cccccc", -filled => 1, -linecolor => "#cccccc");
$zinc->add('curve',$top_group,[[21.4, 229.601], [-21.4, 229.601, 'c'], [-21.4, 223.601, 'c'], [-24.2, 224.401], [-27, 225.201, 'c'], [-63, 242.801, 'c'], [-69, 252.401], [-69, 252.401, 'c'], [-27, 226.801, 'c'], [-21.4, 229.601]],  -closed => 1, -fillcolor => "#cccccc", -filled => 1, -linecolor => "#cccccc");
$zinc->add('curve',$top_group,[[20.2, 218.801], [-20.2, 218.801, 'c'], [-19, 214.001, 'c'], [-21.8, 214.801], [-23.8, 214.801, 'c'], [-50.2, 226.401, 'c'], [-56.2, 236.001], [-56.2, 236.001, 'c'], [-26.6, 214.401, 'c'], [-20.2, 218.801]],  -closed => 1, -fillcolor => "#cccccc", -filled => 1, -linecolor => "#cccccc");
$zinc->add('curve',$top_group,[[34.6, 266.401], [-44.6, 274.001], [-44.6, 274.001, 'c'], [-34.2, 266.401, 'c'], [-30.6, 267.601], [-30.6, 267.601, 'c'], [-37.4, 278.801, 'c'], [-38.2, 284.001], [-38.2, 284.001, 'c'], [-27.8, 271.201, 'c'], [-22.2, 271.601], [-22.2, 271.601, 'c'], [-14.6, 272.001, 'c'], [-14.6, 282.801], [-14.6, 282.801, 'c'], [-9, 272.401, 'c'], [-5.8, 272.801], [-5.8, 272.801, 'c'], [-4.6, 279.201, 'c'], [-5.8, 286.001], [-5.8, 286.001, 'c'], [-1.8, 278.401, 'c'], [2.2, 280.001], [2.2, 280.001, 'c'], [8.6, 278.001, 'c'], [7.8, 289.601], [7.8, 289.601, 'c'], [7.8, 300.001, 'c'], [7, 302.801], [7, 302.801, 'c'], [12.6, 276.401, 'c'], [15, 276.001], [15, 276.001, 'c'], [23, 274.801, 'c'], [27.8, 283.601], [27.8, 283.601, 'c'], [23.8, 276.001, 'c'], [28.6, 278.001], [28.6, 278.001, 'c'], [39.4, 279.601, 'c'], [42.6, 286.401], [42.6, 286.401, 'c'], [35.8, 274.401, 'c'], [41.4, 277.601], [41.4, 277.601, 'c'], [48.2, 277.601, 'c'], [49.4, 284.001], [49.4, 284.001, 'c'], [57.8, 305.201, 'c'], [59.8, 306.801], [59.8, 306.801, 'c'], [52.2, 285.201, 'c'], [53.8, 285.201], [53.8, 285.201, 'c'], [51.8, 273.201, 'c'], [57, 288.001], [57, 288.001, 'c'], [53.8, 274.001, 'c'], [59.4, 274.801], [65, 275.601, 'c'], [69.4, 285.601, 'c'], [77.8, 283.201], [77.8, 283.201, 'c'], [87.401, 288.801, 'c'], [89.401, 219.601], [-34.6, 266.401]],  -closed => 1, -fillcolor => "#cccccc", -filled => 1, -linecolor => "#cccccc");
$zinc->add('curve',$top_group,[[29.8, 173.601], [-29.8, 173.601, 'c'], [-15, 167.601, 'c'], [25, 173.601], [25, 173.601, 'c'], [32.2, 174.001, 'c'], [39, 165.201], [45.8, 156.401, 'c'], [72.6, 149.201, 'c'], [79, 151.201], [88.601, 157.601], [89.401, 158.801], [89.401, 158.801, 'c'], [101.801, 169.201, 'c'], [102.201, 176.801], [102.601, 184.401, 'c'], [87.801, 232.401, 'c'], [78.2, 248.401], [68.6, 264.401, 'c'], [59, 276.801, 'c'], [39.8, 274.401], [39.8, 274.401, 'c'], [19, 270.401, 'c'], [-6.6, 274.401], [-6.6, 274.401, 'c'], [-35.8, 272.801, 'c'], [-38.6, 264.801], [-41.4, 256.801, 'c'], [-27.4, 241.601, 'c'], [-27.4, 241.601], [-27.4, 241.601, 'c'], [-23, 233.201, 'c'], [-24.2, 218.801], [-25.4, 204.401, 'c'], [-25, 176.401, 'c'], [-29.8, 173.601]],  -closed => 1, -fillcolor => "#000000", -filled => 1, -linecolor => "#000000");
$zinc->add('curve',$top_group,[[7.8, 175.601], [0.6, 194.001, 'c'], [-29, 259.201, 'c'], [-29, 259.201], [-31, 260.801, 'c'], [-16.34, 266.846, 'c'], [-6.2, 264.401], [4.746, 261.763, 'c'], [45, 266.001, 'c'], [45, 266.001], [68.6, 250.401, 'c'], [81.4, 206.001, 'c'], [81.4, 206.001], [81.4, 206.001, 'c'], [91.801, 182.001, 'c'], [74.2, 178.801], [56.6, 175.601, 'c'], [-7.8, 175.601, 'c'], [-7.8, 175.601]],  -closed => 1, -fillcolor => "#e5668c", -filled => 1, -linecolor => "#e5668c");
$zinc->add('curve',$top_group,[[9.831, 206.497], [-6.505, 193.707, 'c'], [-4.921, 181.906, 'c'], [-7.8, 175.601], [-7.8, 175.601, 'c'], [54.6, 182.001, 'c'], [65.8, 161.201], [70.041, 153.326, 'c'], [84.801, 184.001, 'c'], [84.4, 193.601], [84.4, 193.601, 'c'], [21.4, 208.001, 'c'], [6.6, 196.801], [-9.831, 206.497]],  -closed => 1, -fillcolor => "#b23259", -filled => 1, -linecolor => "#b23259");
$zinc->add('curve',$top_group,[[5.4, 222.801], [-5.4, 222.801, 'c'], [-3.4, 230.001, 'c'], [-5.8, 234.001], [-5.8, 234.001, 'c'], [-7.4, 234.801, 'c'], [-8.6, 235.201], [-8.6, 235.201, 'c'], [-7.4, 238.801, 'c'], [-1.4, 240.401], [-1.4, 240.401, 'c'], [0.6, 244.801, 'c'], [3, 245.201], [5.4, 245.601, 'c'], [10.2, 251.201, 'c'], [14.2, 250.001], [18.2, 248.801, 'c'], [29.4, 244.801, 'c'], [29.4, 244.801], [29.4, 244.801, 'c'], [35, 241.601, 'c'], [43.8, 245.201], [43.8, 245.201, 'c'], [46.175, 244.399, 'c'], [46.6, 240.401], [47.1, 235.701, 'c'], [50.2, 232.001, 'c'], [52.2, 230.001], [54.2, 228.001, 'c'], [63.8, 215.201, 'c'], [62.6, 214.801], [61.4, 214.401, 'c'], [-5.4, 222.801, 'c'], [-5.4, 222.801]],  -closed => 1, -fillcolor => "#a5264c", -filled => 1, -linecolor => "#a5264c");
$zinc->add('curve',$top_group,[[9.8, 174.401], [-9.8, 174.401, 'c'], [-12.6, 196.801, 'c'], [-9.4, 205.201], [-6.2, 213.601, 'c'], [-7, 215.601, 'c'], [-7.8, 219.601], [-8.6, 223.601, 'c'], [-4.2, 233.601, 'c'], [1.4, 239.601], [13.4, 241.201], [13.4, 241.201, 'c'], [28.6, 237.601, 'c'], [37.8, 240.401], [37.8, 240.401, 'c'], [46.794, 241.744, 'c'], [50.2, 226.801], [50.2, 226.801, 'c'], [55, 220.401, 'c'], [62.2, 217.601], [69.4, 214.801, 'c'], [76.6, 173.201, 'c'], [72.6, 165.201], [68.6, 157.201, 'c'], [54.2, 152.801, 'c'], [38.2, 168.401], [22.2, 184.001, 'c'], [20.2, 167.201, 'c'], [-9.8, 174.401]],  -closed => 1, -linecolor => "#000000", -fillcolor => "#ff727f", -filled => 1);
$zinc->add('curve',$top_group,[[8.2, 249.201], [-8.2, 249.201, 'c'], [-9, 247.201, 'c'], [-13.4, 246.801], [-13.4, 246.801, 'c'], [-35.8, 243.201, 'c'], [-44.2, 230.801], [-44.2, 230.801, 'c'], [-51, 225.201, 'c'], [-46.6, 236.801], [-46.6, 236.801, 'c'], [-36.2, 257.201, 'c'], [-29.4, 260.001], [-29.4, 260.001, 'c'], [-13, 264.001, 'c'], [-8.2, 249.201]],  -closed => 1, -linecolor => "#000000", -fillcolor => "#ffffcc", -filled => 1, -linewidth => 0.5);


$zinc->add('curve',$top_group,[[71.742, 185.229], [72.401, 177.323, 'c'], [74.354, 168.709, 'c'], [72.6, 165.201], [66.154, 152.307, 'c'], [49.181, 157.695, 'c'], [38.2, 168.401], [22.2, 184.001, 'c'], [20.2, 167.201, 'c'], [-9.8, 174.401], [-9.8, 174.401, 'c'], [-11.545, 188.364, 'c'], [-10.705, 198.376], [-10.705, 198.376, 'c'], [26.6, 186.801, 'c'], [27.4, 192.401], [27.4, 192.401, 'c'], [29, 189.201, 'c'], [38.2, 189.201], [47.4, 189.201, 'c'], [70.142, 188.029, 'c'], [71.742, 185.229]],  -closed => 1, -fillcolor => "#cc3f4c", -filled => 1, -linecolor => "#cc3f4c");
$zinc->add('curve',$top_group,[[28.6, 175.201], [28.6, 175.201, 'c'], [33.4, 180.001, 'c'], [29.8, 189.601], [29.8, 189.601, 'c'], [15.4, 205.601, 'c'], [17.4, 219.601]],  -closed => 0, -linecolor => "#a51926", -linewidth => 2);
$zinc->add('curve',$top_group,[[19.4, 260.001], [-19.4, 260.001, 'c'], [-23.8, 247.201, 'c'], [-15, 254.001], [-15, 254.001, 'c'], [-10.2, 256.001, 'c'], [-11.4, 257.601], [-12.6, 259.201, 'c'], [-18.2, 263.201, 'c'], [-19.4, 260.001]],  -closed => 1, -linecolor => "#000000", -fillcolor => "#ffffcc", -filled => 1, -linewidth => 0.5);
$zinc->add('curve',$top_group,[[14.36, 261.201], [-14.36, 261.201, 'c'], [-17.88, 250.961, 'c'], [-10.84, 256.401], [-10.84, 256.401, 'c'], [-6.419, 258.849, 'c'], [-7.96, 259.281], [-12.52, 260.561, 'c'], [-7.96, 263.121, 'c'], [-14.36, 261.201]],  -closed => 1, -linecolor => "#000000", -fillcolor => "#ffffcc", -filled => 1, -linewidth => 0.5);
$zinc->add('curve',$top_group,[[9.56, 261.201], [-9.56, 261.201, 'c'], [-13.08, 250.961, 'c'], [-6.04, 256.401], [-6.04, 256.401, 'c'], [-1.665, 258.711, 'c'], [-3.16, 259.281], [-6.52, 260.561, 'c'], [-3.16, 263.121, 'c'], [-9.56, 261.201]],  -closed => 1, -linecolor => "#000000", -fillcolor => "#ffffcc", -filled => 1, -linewidth => 0.5);
$zinc->add('curve',$top_group,[[2.96, 261.401], [-2.96, 261.401, 'c'], [-6.48, 251.161, 'c'], [0.56, 256.601], [0.56, 256.601, 'c'], [4.943, 258.933, 'c'], [3.441, 259.481], [0.48, 260.561, 'c'], [3.441, 263.321, 'c'], [-2.96, 261.401]],  -closed => 1, -linecolor => "#000000", -fillcolor => "#ffffcc", -filled => 1, -linewidth => 0.5);
$zinc->add('curve',$top_group,[[3.52, 261.321], [3.52, 261.321, 'c'], [0, 251.081, 'c'], [7.041, 256.521], [7.041, 256.521, 'c'], [10.881, 258.121, 'c'], [9.921, 259.401], [8.961, 260.681, 'c'], [9.921, 263.241, 'c'], [3.52, 261.321]],  -closed => 1, -linecolor => "#000000", -fillcolor => "#ffffcc", -filled => 1, -linewidth => 0.5);
$zinc->add('curve',$top_group,[[10.2, 262.001], [10.2, 262.001, 'c'], [5.4, 249.601, 'c'], [14.6, 256.001], [14.6, 256.001, 'c'], [19.4, 258.001, 'c'], [18.2, 259.601], [17, 261.201, 'c'], [18.2, 264.401, 'c'], [10.2, 262.001]],  -closed => 1, -linecolor => "#000000", -fillcolor => "#ffffcc", -filled => 1, -linewidth => 0.5);
$zinc->add('curve',$top_group,[[18.2, 244.801], [-18.2, 244.801, 'c'], [-5, 242.001, 'c'], [1, 245.201], [1, 245.201, 'c'], [7, 246.401, 'c'], [8.2, 246.001], [9.4, 245.601, 'c'], [12.6, 245.201, 'c'], [12.6, 245.201]],  -closed => 0, -linecolor => "#a5264c", -linewidth => 2);
$zinc->add('curve',$top_group,[[15.8, 253.601], [15.8, 253.601, 'c'], [27.8, 240.001, 'c'], [39.8, 244.401], [46.816, 246.974, 'c'], [45.8, 243.601, 'c'], [46.6, 240.801], [47.4, 238.001, 'c'], [47.6, 233.801, 'c'], [52.6, 230.801]],  -closed => 0, -linecolor => "#a5264c", -linewidth => 2);
$zinc->add('curve',$top_group,[[33, 237.601], [33, 237.601, 'c'], [29, 226.801, 'c'], [26.2, 239.601], [23.4, 252.401, 'c'], [20.2, 256.001, 'c'], [18.6, 258.801], [18.6, 258.801, 'c'], [18.6, 264.001, 'c'], [27, 263.601], [27, 263.601, 'c'], [37.8, 263.201, 'c'], [38.2, 260.401], [38.6, 257.601, 'c'], [37, 246.001, 'c'], [33, 237.601]],  -closed => 1, -linecolor => "#000000", -fillcolor => "#ffffcc", -filled => 1, -linewidth => 0.5);
$zinc->add('curve',$top_group,[[47, 244.801], [47, 244.801, 'c'], [50.6, 242.401, 'c'], [53, 243.601]],  -closed => 0, -linecolor => "#a5264c", -linewidth => 2);
$zinc->add('curve',$top_group,[[53.5, 228.401], [53.5, 228.401, 'c'], [56.4, 223.501, 'c'], [61.2, 222.701]],  -closed => 0, -linecolor => "#a5264c", -linewidth => 2);
$zinc->add('curve',$top_group,[[25.8, 265.201], [-25.8, 265.201, 'c'], [-7.8, 268.401, 'c'], [-3.4, 266.801], [-3.4, 266.801, 'c'], [5.4, 266.801, 'c'], [-3, 268.801], [-3, 268.801, 'c'], [-15.8, 268.801, 'c'], [-23.8, 267.601], [-23.8, 267.601, 'c'], [-35.4, 262.001, 'c'], [-25.8, 265.201]],  -closed => 1, -fillcolor => "#b2b2b2", -filled => 1, -linecolor => "#b2b2b2");
$zinc->add('curve',$top_group,[[11.8, 172.001], [-11.8, 172.001, 'c'], [5.8, 172.001, 'c'], [7.8, 172.801], [7.8, 172.801, 'c'], [15, 203.601, 'c'], [11.4, 211.201], [11.4, 211.201, 'c'], [10.2, 214.001, 'c'], [7.4, 208.401], [7.4, 208.401, 'c'], [-11, 175.601, 'c'], [-14.2, 173.601], [-17.4, 171.601, 'c'], [-13, 172.001, 'c'], [-11.8, 172.001]],  -closed => 1, -linecolor => "#000000", -fillcolor => "#ffffcc", -filled => 1, -linewidth => 0.5);

$zinc->add('curve',$top_group,[[-88.9, 169.301], [-88.9, 169.301, 'c'], [-80, 171.001, 'c'], [-67.4, 173.601], [-67.4, 173.601, 'c'], [-62.6, 196.001, 'c'], [-59.4, 200.801], [-56.2, 205.601, 'c'], [-59.8, 205.601, 'c'], [-63.4, 202.801], [-67, 200.001, 'c'], [-81.8, 186.001, 'c'], [-83.8, 181.601], [-85.8, 177.201, 'c'], [-88.9, 169.301, 'c'], [-88.9, 169.301]],  -closed => 1, -linecolor => "#000000", -fillcolor => "#ffffcc", -filled => 1, -linewidth => 0.5);

$zinc->add('curve',$top_group,[[-67.039, 173.818], [-67.039, 173.818, 'c'], [-61.239, 175.366, 'c'], [-60.23, 177.581], [-59.222, 179.795, 'c'], [-61.432, 183.092, 'c'], [-61.432, 183.092], [-61.432, 183.092, 'c'], [-62.432, 186.397, 'c'], [-63.634, 184.235], [-64.836, 182.072, 'c'], [-67.708, 174.412, 'c'], [-67.039, 173.818]],  -closed => 1, -linecolor => "#000000", -fillcolor => "#ffffcc", -filled => 1, -linewidth => 0.5);

$zinc->add('curve',$top_group,[[-67, 173.601], [-67, 173.601, 'c'], [-63.4, 178.801, 'c'], [-59.8, 178.801], [-56.2, 178.801, 'c'], [-55.818, 178.388, 'c'], [-53, 179.001], [-48.4, 180.001, 'c'], [-48.8, 178.001, 'c'], [-42.2, 179.201], [-39.56, 179.681, 'c'], [-37, 178.801, 'c'], [-34.2, 180.001], [-31.4, 181.201, 'c'], [-28.2, 180.401, 'c'], [-27, 178.401], [-25.8, 176.401, 'c'], [-21, 172.201, 'c'], [-21, 172.201], [-21, 172.201, 'c'], [-33.8, 174.001, 'c'], [-36.6, 174.801], [-36.6, 174.801, 'c'], [-59, 176.001, 'c'], [-67, 173.601]],  -closed => 1, -fillcolor => "#000000", -filled => 1, -linecolor => "#000000");

$zinc->add('curve',$top_group,[[-22.4, 173.801], [-22.4, 173.801, 'c'], [-28.85, 177.301, 'c'], [-29.25, 179.701], [-29.65, 182.101, 'c'], [-24, 185.801, 'c'], [-24, 185.801], [-24, 185.801, 'c'], [-21.25, 190.401, 'c'], [-20.65, 188.001], [-20.05, 185.601, 'c'], [-21.6, 174.201, 'c'], [-22.4, 173.801]],  -closed => 1, -linecolor => "#000000", -fillcolor => "#ffffcc", -filled => 1, -linewidth => 0.5);

$zinc->add('curve',$top_group,[[-59.885, 179.265], [-59.885, 179.265, 'c'], [-52.878, 190.453, 'c'], [-52.661, 179.242], [-52.661, 179.242, 'c'], [-52.104, 177.984, 'c'], [-53.864, 177.962], [-59.939, 177.886, 'c'], [-58.418, 173.784, 'c'], [-59.885, 179.265]],  -closed => 1, -linecolor => "#000000", -fillcolor => "#ffffcc", -filled => 1, -linewidth => 0.5);

$zinc->add('curve',$top_group,[[-52.707, 179.514], [-52.707, 179.514, 'c'], [-44.786, 190.701, 'c'], [-45.422, 179.421], [-45.422, 179.421, 'c'], [-45.415, 179.089, 'c'], [-47.168, 178.936], [-51.915, 178.522, 'c'], [-51.57, 174.004, 'c'], [-52.707, 179.514]],  -closed => 1, -linecolor => "#000000", -fillcolor => "#ffffcc", -filled => 1, -linewidth => 0.5);

$zinc->add('curve',$top_group,[[-45.494, 179.522], [-45.494, 179.522, 'c'], [-37.534, 190.15, 'c'], [-38.203, 180.484], [-38.203, 180.484, 'c'], [-38.084, 179.251, 'c'], [-39.738, 178.95], [-43.63, 178.244, 'c'], [-43.841, 174.995, 'c'], [-45.494, 179.522]],  -closed => 1, -linecolor => "#000000", -fillcolor => "#ffffcc", -filled => 1, -linewidth => 0.5);

$zinc->add('curve',$top_group,[[-38.618, 179.602], [-38.618, 179.602, 'c'], [-30.718, 191.163, 'c'], [-30.37, 181.382], [-30.37, 181.382, 'c'], [-28.726, 180.004, 'c'], [-30.472, 179.782], [-36.29, 179.042, 'c'], [-35.492, 174.588, 'c'], [-38.618, 179.602]],  -closed => 1, -linecolor => "#000000", -fillcolor => "#ffffcc", -filled => 1, -linewidth => 0.5);

$zinc->add('curve',$top_group,[[-74.792, 183.132], [-82.45, 181.601], [-85.05, 176.601, 'c'], [-87.15, 170.451, 'c'], [-87.15, 170.451], [-87.15, 170.451, 'c'], [-80.8, 171.451, 'c'], [-68.3, 174.251], [-68.3, 174.251, 'c'], [-67.424, 177.569, 'c'], [-65.952, 183.364], [-74.792, 183.132]],  -closed => 1, -fillcolor => "#e5e5b2", -filled => 1, -linecolor => "#e5e5b2");

$zinc->add('curve',$top_group,[[-9.724, 178.47], [-11.39, 175.964, 'c'], [-12.707, 174.206, 'c'], [-13.357, 173.8], [-16.37, 171.917, 'c'], [-12.227, 172.294, 'c'], [-11.098, 172.294], [-11.098, 172.294, 'c'], [5.473, 172.294, 'c'], [7.356, 173.047], [7.356, 173.047, 'c'], [7.88, 175.289, 'c'], [8.564, 178.68], [8.564, 178.68, 'c'], [-1.524, 176.67, 'c'], [-9.724, 178.47]],  -closed => 1, -fillcolor => "#e5e5b2", -filled => 1, -linecolor => "#e5e5b2");

$zinc->add('curve',$top_group,[[43.88, 40.321], [71.601, 44.281, 'c'], [97.121, 8.641, 'c'], [98.881, -1.04], [100.641, -10.72, 'c'], [90.521, -22.6, 'c'], [90.521, -22.6], [91.841, -25.68, 'c'], [87.001, -39.76, 'c'], [81.721, -49], [76.441, -58.24, 'c'], [60.54, -57.266, 'c'], [43, -58.24], [27.16, -59.12, 'c'], [8.68, -35.8, 'c'], [7.36, -34.04], [6.04, -32.28, 'c'], [12.2, 6.001, 'c'], [13.52, 11.721], [14.84, 17.441, 'c'], [12.2, 43.841, 'c'], [12.2, 43.841], [46.44, 34.741, 'c'], [16.16, 36.361, 'c'], [43.88, 40.321]],  -closed => 1, -fillcolor => "#cc7226", -filled => 1, -linecolor => "#cc7226");

$zinc->add('curve',$top_group,[[8.088, -33.392], [6.792, -31.664, 'c'], [12.84, 5.921, 'c'], [14.136, 11.537], [15.432, 17.153, 'c'], [12.84, 43.073, 'c'], [12.84, 43.073], [45.512, 34.193, 'c'], [16.728, 35.729, 'c'], [43.944, 39.617], [71.161, 43.505, 'c'], [96.217, 8.513, 'c'], [97.945, -0.992], [99.673, -10.496, 'c'], [89.737, -22.16, 'c'], [89.737, -22.16], [91.033, -25.184, 'c'], [86.281, -39.008, 'c'], [81.097, -48.08], [75.913, -57.152, 'c'], [60.302, -56.195, 'c'], [43.08, -57.152], [27.528, -58.016, 'c'], [9.384, -35.12, 'c'], [8.088, -33.392]],  -closed => 1, -fillcolor => "#ea8e51", -filled => 1, -linecolor => "#ea8e51");

$zinc->add('curve',$top_group,[[8.816, -32.744], [7.544, -31.048, 'c'], [13.48, 5.841, 'c'], [14.752, 11.353], [16.024, 16.865, 'c'], [13.48, 42.305, 'c'], [13.48, 42.305], [44.884, 33.145, 'c'], [17.296, 35.097, 'c'], [44.008, 38.913], [70.721, 42.729, 'c'], [95.313, 8.385, 'c'], [97.009, -0.944], [98.705, -10.272, 'c'], [88.953, -21.72, 'c'], [88.953, -21.72], [90.225, -24.688, 'c'], [85.561, -38.256, 'c'], [80.473, -47.16], [75.385, -56.064, 'c'], [60.063, -55.125, 'c'], [43.16, -56.064], [27.896, -56.912, 'c'], [10.088, -34.44, 'c'], [8.816, -32.744]],  -closed => 1, -fillcolor => "#efaa7c", -filled => 1, -linecolor => "#efaa7c");

$zinc->add('curve',$top_group,[[9.544, -32.096], [8.296, -30.432, 'c'], [14.12, 5.761, 'c'], [15.368, 11.169], [16.616, 16.577, 'c'], [14.12, 41.537, 'c'], [14.12, 41.537], [43.556, 32.497, 'c'], [17.864, 34.465, 'c'], [44.072, 38.209], [70.281, 41.953, 'c'], [94.409, 8.257, 'c'], [96.073, -0.895], [97.737, -10.048, 'c'], [88.169, -21.28, 'c'], [88.169, -21.28], [89.417, -24.192, 'c'], [84.841, -37.504, 'c'], [79.849, -46.24], [74.857, -54.976, 'c'], [59.824, -54.055, 'c'], [43.24, -54.976], [28.264, -55.808, 'c'], [10.792, -33.76, 'c'], [9.544, -32.096]],  -closed => 1, -fillcolor => "#f4c6a8", -filled => 1, -linecolor => "#f4c6a8");

$zinc->add('curve',$top_group,[[10.272, -31.448], [9.048, -29.816, 'c'], [14.76, 5.681, 'c'], [15.984, 10.985], [17.208, 16.289, 'c'], [14.76, 40.769, 'c'], [14.76, 40.769], [42.628, 31.849, 'c'], [18.432, 33.833, 'c'], [44.136, 37.505], [69.841, 41.177, 'c'], [93.505, 8.129, 'c'], [95.137, -0.848], [96.769, -9.824, 'c'], [87.385, -20.84, 'c'], [87.385, -20.84], [88.609, -23.696, 'c'], [84.121, -36.752, 'c'], [79.225, -45.32], [74.329, -53.888, 'c'], [59.585, -52.985, 'c'], [43.32, -53.888], [28.632, -54.704, 'c'], [11.496, -33.08, 'c'], [10.272, -31.448]],  -closed => 1, -fillcolor => "#f9e2d3", -filled => 1, -linecolor => "#f9e2d3");

$zinc->add('curve',$top_group,[[44.2, 36.8], [69.4, 40.4, 'c'], [92.601, 8, 'c'], [94.201, -0.8], [95.801, -9.6, 'c'], [86.601, -20.4, 'c'], [86.601, -20.4], [87.801, -23.2, 'c'], [83.4, -36, 'c'], [78.6, -44.4], [73.8, -52.8, 'c'], [59.346, -51.914, 'c'], [43.4, -52.8], [29, -53.6, 'c'], [12.2, -32.4, 'c'], [11, -30.8], [9.8, -29.2, 'c'], [15.4, 5.6, 'c'], [16.6, 10.8], [17.8, 16, 'c'], [15.4, 40, 'c'], [15.4, 40], [40.9, 31.4, 'c'], [19, 33.2, 'c'], [44.2, 36.8]],  -closed => 1, -fillcolor => "#ffffff", -filled => 1, -linecolor => "#ffffff");

$zinc->add('curve',$top_group,[[90.601, 2.8], [90.601, 2.8, 'c'], [62.8, 10.4, 'c'], [51.2, 8.8], [51.2, 8.8, 'c'], [35.4, 2.2, 'c'], [26.6, 24], [26.6, 24, 'c'], [23, 31.2, 'c'], [21, 33.2], [19, 35.2, 'c'], [90.601, 2.8, 'c'], [90.601, 2.8]],  -closed => 1, -fillcolor => "#cccccc", -filled => 1, -linecolor => "#cccccc");

$zinc->add('curve',$top_group,[[94.401, 0.6], [94.401, 0.6, 'c'], [65.4, 12.8, 'c'], [55.4, 12.4], [55.4, 12.4, 'c'], [39, 7.8, 'c'], [30.6, 22.4], [30.6, 22.4, 'c'], [22.2, 31.6, 'c'], [19, 33.2], [19, 33.2, 'c'], [18.6, 34.8, 'c'], [25, 30.8], [35.4, 36], [35.4, 36, 'c'], [50.2, 45.6, 'c'], [59.8, 29.6], [59.8, 29.6, 'c'], [63.8, 18.4, 'c'], [63.8, 16.4], [63.8, 14.4, 'c'], [85, 8.8, 'c'], [86.601, 8.4], [88.201, 8, 'c'], [94.801, 3.8, 'c'], [94.401, 0.6]],  -closed => 1, -fillcolor => "#000000", -filled => 1, -linecolor => "#000000");

$zinc->add('curve',$top_group,[[47, 36.514], [40.128, 36.514, 'c'], [31.755, 32.649, 'c'], [31.755, 26.4], [31.755, 20.152, 'c'], [40.128, 13.887, 'c'], [47, 13.887], [53.874, 13.887, 'c'], [59.446, 18.952, 'c'], [59.446, 25.2], [59.446, 31.449, 'c'], [53.874, 36.514, 'c'], [47, 36.514]],  -closed => 1, -fillcolor => "#99cc32", -filled => 1, -linecolor => "#99cc32");

$zinc->add('curve',$top_group,[[43.377, 19.83], [38.531, 20.552, 'c'], [33.442, 22.055, 'c'], [33.514, 21.839], [35.054, 17.22, 'c'], [41.415, 13.887, 'c'], [47, 13.887], [51.296, 13.887, 'c'], [55.084, 15.865, 'c'], [57.32, 18.875], [57.32, 18.875, 'c'], [52.004, 18.545, 'c'], [43.377, 19.83]],  -closed => 1, -fillcolor => "#659900", -filled => 1, -linecolor => "#659900");

$zinc->add('curve',$top_group,[[55.4, 19.6], [55.4, 19.6, 'c'], [51, 16.4, 'c'], [51, 18.6], [51, 18.6, 'c'], [54.6, 23, 'c'], [55.4, 19.6]],  -closed => 1, -fillcolor => "#ffffff", -filled => 1, -linecolor => "#ffffff");

$zinc->add('curve',$top_group,[[45.4, 27.726], [42.901, 27.726, 'c'], [40.875, 25.7, 'c'], [40.875, 23.2], [40.875, 20.701, 'c'], [42.901, 18.675, 'c'], [45.4, 18.675], [47.9, 18.675, 'c'], [49.926, 20.701, 'c'], [49.926, 23.2], [49.926, 25.7, 'c'], [47.9, 27.726, 'c'], [45.4, 27.726]],  -closed => 1, -fillcolor => "#000000", -filled => 1, -linecolor => "#000000");

$zinc->add('curve',$top_group,[[-58.6, 14.4], [-58.6, 14.4, 'c'], [-61.8, -6.8, 'c'], [-59.4, -11.2], [-59.4, -11.2, 'c'], [-48.6, -21.2, 'c'], [-49, -24.8], [-49, -24.8, 'c'], [-49.4, -42.8, 'c'], [-50.6, -43.6], [-51.8, -44.4, 'c'], [-59.4, -50.4, 'c'], [-65.4, -44], [-65.4, -44, 'c'], [-75.8, -26, 'c'], [-75, -19.6], [-75, -17.6], [-75, -17.6, 'c'], [-82.6, -18, 'c'], [-84.2, -16], [-84.2, -16, 'c'], [-85.4, -10.8, 'c'], [-86.6, -10.4], [-86.6, -10.4, 'c'], [-89.4, -8, 'c'], [-87.4, -5.2], [-87.4, -5.2, 'c'], [-89.4, -2.8, 'c'], [-89, 1.2], [-81.4, 5.2], [-81.4, 5.2, 'c'], [-79.4, 19.6, 'c'], [-68.6, 24.8], [-63.764, 27.129, 'c'], [-60.6, 20.4, 'c'], [-58.6, 14.4]],  -closed => 1, -fillcolor => "#cc7226", -filled => 1, -linecolor => "#cc7226");

$zinc->add('curve',$top_group,[[-59.6, 12.56], [-59.6, 12.56, 'c'], [-62.48, -6.52, 'c'], [-60.32, -10.48], [-60.32, -10.48, 'c'], [-50.6, -19.48, 'c'], [-50.96, -22.72], [-50.96, -22.72, 'c'], [-51.32, -38.92, 'c'], [-52.4, -39.64], [-53.48, -40.36, 'c'], [-60.32, -45.76, 'c'], [-65.72, -40], [-65.72, -40, 'c'], [-75.08, -23.8, 'c'], [-74.36, -18.04], [-74.36, -16.24], [-74.36, -16.24, 'c'], [-81.2, -16.6, 'c'], [-82.64, -14.8], [-82.64, -14.8, 'c'], [-83.72, -10.12, 'c'], [-84.8, -9.76], [-84.8, -9.76, 'c'], [-87.32, -7.6, 'c'], [-85.52, -5.08], [-85.52, -5.08, 'c'], [-87.32, -2.92, 'c'], [-86.96, 0.68], [-80.12, 4.28], [-80.12, 4.28, 'c'], [-78.32, 17.24, 'c'], [-68.6, 21.92], [-64.248, 24.015, 'c'], [-61.4, 17.96, 'c'], [-59.6, 12.56]],  -closed => 1, -fillcolor => "#ffffff", -filled => 1, -linecolor => "#ffffff");

$zinc->add('curve',$top_group,[[-51.05, -42.61], [-52.14, -43.47, 'c'], [-59.63, -49.24, 'c'], [-65.48, -43], [-65.48, -43, 'c'], [-75.62, -25.45, 'c'], [-74.84, -19.21], [-74.84, -17.26], [-74.84, -17.26, 'c'], [-82.25, -17.65, 'c'], [-83.81, -15.7], [-83.81, -15.7, 'c'], [-84.98, -10.63, 'c'], [-86.15, -10.24], [-86.15, -10.24, 'c'], [-88.88, -7.9, 'c'], [-86.93, -5.17], [-86.93, -5.17, 'c'], [-88.88, -2.83, 'c'], [-88.49, 1.07], [-81.08, 4.97], [-81.08, 4.97, 'c'], [-79.13, 19.01, 'c'], [-68.6, 24.08], [-63.886, 26.35, 'c'], [-60.8, 19.79, 'c'], [-58.85, 13.94], [-58.85, 13.94, 'c'], [-61.97, -6.73, 'c'], [-59.63, -11.02], [-59.63, -11.02, 'c'], [-49.1, -20.77, 'c'], [-49.49, -24.28], [-49.49, -24.28, 'c'], [-49.88, -41.83, 'c'], [-51.05, -42.61]],  -closed => 1, -fillcolor => "#eb955c", -filled => 1, -linecolor => "#eb955c");

$zinc->add('curve',$top_group,[[-51.5, -41.62], [-52.48, -42.54, 'c'], [-59.86, -48.08, 'c'], [-65.56, -42], [-65.56, -42, 'c'], [-75.44, -24.9, 'c'], [-74.68, -18.82], [-74.68, -16.92], [-74.68, -16.92, 'c'], [-81.9, -17.3, 'c'], [-83.42, -15.4], [-83.42, -15.4, 'c'], [-84.56, -10.46, 'c'], [-85.7, -10.08], [-85.7, -10.08, 'c'], [-88.36, -7.8, 'c'], [-86.46, -5.14], [-86.46, -5.14, 'c'], [-88.36, -2.86, 'c'], [-87.98, 0.94], [-80.76, 4.74], [-80.76, 4.74, 'c'], [-78.86, 18.42, 'c'], [-68.6, 23.36], [-64.006, 25.572, 'c'], [-61, 19.18, 'c'], [-59.1, 13.48], [-59.1, 13.48, 'c'], [-62.14, -6.66, 'c'], [-59.86, -10.84], [-59.86, -10.84, 'c'], [-49.6, -20.34, 'c'], [-49.98, -23.76], [-49.98, -23.76, 'c'], [-50.36, -40.86, 'c'], [-51.5, -41.62]],  -closed => 1, -fillcolor => "#f2b892", -filled => 1, -linecolor => "#f2b892");

$zinc->add('curve',$top_group,[[-51.95, -40.63], [-52.82, -41.61, 'c'], [-60.09, -46.92, 'c'], [-65.64, -41], [-65.64, -41, 'c'], [-75.26, -24.35, 'c'], [-74.52, -18.43], [-74.52, -16.58], [-74.52, -16.58, 'c'], [-81.55, -16.95, 'c'], [-83.03, -15.1], [-83.03, -15.1, 'c'], [-84.14, -10.29, 'c'], [-85.25, -9.92], [-85.25, -9.92, 'c'], [-87.84, -7.7, 'c'], [-85.99, -5.11], [-85.99, -5.11, 'c'], [-87.84, -2.89, 'c'], [-87.47, 0.81], [-80.44, 4.51], [-80.44, 4.51, 'c'], [-78.59, 17.83, 'c'], [-68.6, 22.64], [-64.127, 24.794, 'c'], [-61.2, 18.57, 'c'], [-59.35, 13.02], [-59.35, 13.02, 'c'], [-62.31, -6.59, 'c'], [-60.09, -10.66], [-60.09, -10.66, 'c'], [-50.1, -19.91, 'c'], [-50.47, -23.24], [-50.47, -23.24, 'c'], [-50.84, -39.89, 'c'], [-51.95, -40.63]],  -closed => 1, -fillcolor => "#f8dcc8", -filled => 1, -linecolor => "#f8dcc8");

$zinc->add('curve',$top_group,[[-59.6, 12.46], [-59.6, 12.46, 'c'], [-62.48, -6.52, 'c'], [-60.32, -10.48], [-60.32, -10.48, 'c'], [-50.6, -19.48, 'c'], [-50.96, -22.72], [-50.96, -22.72, 'c'], [-51.32, -38.92, 'c'], [-52.4, -39.64], [-53.16, -40.68, 'c'], [-60.32, -45.76, 'c'], [-65.72, -40], [-65.72, -40, 'c'], [-75.08, -23.8, 'c'], [-74.36, -18.04], [-74.36, -16.24], [-74.36, -16.24, 'c'], [-81.2, -16.6, 'c'], [-82.64, -14.8], [-82.64, -14.8, 'c'], [-83.72, -10.12, 'c'], [-84.8, -9.76], [-84.8, -9.76, 'c'], [-87.32, -7.6, 'c'], [-85.52, -5.08], [-85.52, -5.08, 'c'], [-87.32, -2.92, 'c'], [-86.96, 0.68], [-80.12, 4.28], [-80.12, 4.28, 'c'], [-78.32, 17.24, 'c'], [-68.6, 21.92], [-64.248, 24.015, 'c'], [-61.4, 17.86, 'c'], [-59.6, 12.46]],  -closed => 1, -fillcolor => "#ffffff", -filled => 1, -linecolor => "#ffffff");

$zinc->add('curve',$top_group,[[-62.7, 6.2], [-62.7, 6.2, 'c'], [-84.3, -4, 'c'], [-85.2, -4.8], [-85.2, -4.8, 'c'], [-76.1, 3.4, 'c'], [-75.3, 3.4], [-74.5, 3.4, 'c'], [-62.7, 6.2, 'c'], [-62.7, 6.2]],  -closed => 1, -fillcolor => "#cccccc", -filled => 1, -linecolor => "#cccccc");

$zinc->add('curve',$top_group,[[-79.8, 0], [-79.8, 0, 'c'], [-61.4, 3.6, 'c'], [-61.4, 8], [-61.4, 10.912, 'c'], [-61.643, 24.331, 'c'], [-67, 22.8], [-75.4, 20.4, 'c'], [-71.8, 6, 'c'], [-79.8, 0]],  -closed => 1, -fillcolor => "#000000", -filled => 1, -linecolor => "#000000");

$zinc->add('curve',$top_group,[[-71.4, 3.8], [-71.4, 3.8, 'c'], [-62.422, 5.274, 'c'], [-61.4, 8], [-60.8, 9.6, 'c'], [-60.137, 17.908, 'c'], [-65.6, 19], [-70.152, 19.911, 'c'], [-72.382, 9.69, 'c'], [-71.4, 3.8]],  -closed => 1, -fillcolor => "#99cc32", -filled => 1, -linecolor => "#99cc32");

$zinc->add('curve',$top_group,[[14.595, 46.349], [14.098, 44.607, 'c'], [15.409, 44.738, 'c'], [17.2, 44.2], [19.2, 43.6, 'c'], [31.4, 39.8, 'c'], [32.2, 37.2], [33, 34.6, 'c'], [46.2, 39, 'c'], [46.2, 39], [48, 39.8, 'c'], [52.4, 42.4, 'c'], [52.4, 42.4], [57.2, 43.6, 'c'], [63.8, 44, 'c'], [63.8, 44], [66.2, 45, 'c'], [69.6, 47.8, 'c'], [69.6, 47.8], [84.2, 58, 'c'], [96.601, 50.8, 'c'], [96.601, 50.8], [116.601, 44.2, 'c'], [110.601, 27, 'c'], [110.601, 27], [107.601, 18, 'c'], [110.801, 14.6, 'c'], [110.801, 14.6], [111.001, 10.8, 'c'], [118.201, 17.2, 'c'], [118.201, 17.2], [120.801, 21.4, 'c'], [121.601, 26.4, 'c'], [121.601, 26.4], [129.601, 37.6, 'c'], [126.201, 19.8, 'c'], [126.201, 19.8], [126.401, 18.8, 'c'], [123.601, 15.2, 'c'], [123.601, 14], [123.601, 12.8, 'c'], [121.801, 9.4, 'c'], [121.801, 9.4], [118.801, 6, 'c'], [121.201, -1, 'c'], [121.201, -1], [123.001, -14.8, 'c'], [120.801, -13, 'c'], [120.801, -13], [119.601, -14.8, 'c'], [110.401, -4.8, 'c'], [110.401, -4.8], [108.201, -1.4, 'c'], [102.201, 0.2, 'c'], [102.201, 0.2], [99.401, 2, 'c'], [96.001, 0.6, 'c'], [96.001, 0.6], [93.401, 0.2, 'c'], [87.801, 7.2, 'c'], [87.801, 7.2], [90.601, 7, 'c'], [93.001, 11.4, 'c'], [95.401, 11.6], [97.801, 11.8, 'c'], [99.601, 9.2, 'c'], [101.201, 8.6], [102.801, 8, 'c'], [105.601, 13.8, 'c'], [105.601, 13.8], [106.001, 16.4, 'c'], [100.401, 21.2, 'c'], [100.401, 21.2], [100.001, 25.8, 'c'], [98.401, 24.2, 'c'], [98.401, 24.2], [95.401, 23.6, 'c'], [94.201, 27.4, 'c'], [93.201, 32], [92.201, 36.6, 'c'], [88.001, 37, 'c'], [88.001, 37], [86.401, 44.4, 'c'], [85.2, 41.4, 'c'], [85.2, 41.4], [85, 35.8, 'c'], [79, 41.6, 'c'], [79, 41.6], [77.8, 43.6, 'c'], [73.2, 41.4, 'c'], [73.2, 41.4], [66.4, 39.4, 'c'], [68.8, 37.4, 'c'], [68.8, 37.4], [70.6, 35.2, 'c'], [81.8, 37.4, 'c'], [81.8, 37.4], [84, 35.8, 'c'], [76, 31.8, 'c'], [76, 31.8], [75.4, 30, 'c'], [76.4, 25.6, 'c'], [76.4, 25.6], [77.6, 22.4, 'c'], [84.4, 16.8, 'c'], [84.4, 16.8], [93.801, 15.6, 'c'], [91.001, 14, 'c'], [91.001, 14], [84.801, 8.8, 'c'], [79, 16.4, 'c'], [79, 16.4], [76.8, 22.6, 'c'], [59.4, 37.6, 'c'], [59.4, 37.6], [54.6, 41, 'c'], [57.2, 34.2, 'c'], [53.2, 37.6], [49.2, 41, 'c'], [28.6, 32, 'c'], [28.6, 32], [17.038, 30.807, 'c'], [14.306, 46.549, 'c'], [10.777, 43.429], [10.777, 43.429, 'c'], [16.195, 51.949, 'c'], [14.595, 46.349]],  -closed => 1, -fillcolor => "#000000", -filled => 1, -linecolor => "#000000");

$zinc->add('curve',$top_group,[[209.401, -120], [209.401, -120, 'c'], [183.801, -112, 'c'], [181.001, -93.2], [181.001, -93.2, 'c'], [178.601, -70.4, 'c'], [199.001, -52.8], [199.001, -52.8, 'c'], [199.401, -46.4, 'c'], [201.401, -43.2], [201.401, -43.2, 'c'], [199.801, -38.4, 'c'], [218.601, -46], [245.801, -54.4], [245.801, -54.4, 'c'], [252.201, -56.8, 'c'], [257.401, -65.6], [262.601, -74.4, 'c'], [277.801, -93.2, 'c'], [274.201, -118.4], [274.201, -118.4, 'c'], [275.401, -129.6, 'c'], [269.401, -130], [269.401, -130, 'c'], [261.001, -131.6, 'c'], [253.801, -124], [253.801, -124, 'c'], [247.001, -120.8, 'c'], [244.601, -121.2], [209.401, -120]],  -closed => 1, -fillcolor => "#000000", -filled => 1, -linecolor => "#000000");

$zinc->add('curve',$top_group,[[264.022, -120.99], [264.022, -120.99, 'c'], [266.122, -129.92, 'c'], [261.282, -125.08], [261.282, -125.08, 'c'], [254.242, -119.36, 'c'], [246.761, -119.36], [246.761, -119.36, 'c'], [232.241, -117.16, 'c'], [227.841, -103.96], [227.841, -103.96, 'c'], [223.881, -77.12, 'c'], [231.801, -71.4], [231.801, -71.4, 'c'], [236.641, -63.92, 'c'], [243.681, -70.52], [250.722, -77.12, 'c'], [266.222, -107.35, 'c'], [264.022, -120.99]],  -closed => 1, -fillcolor => "#000000", -filled => 1, -linecolor => "#000000");

$zinc->add('curve',$top_group,[[263.648, -120.632], [263.648, -120.632, 'c'], [265.738, -129.376, 'c'], [260.986, -124.624], [260.986, -124.624, 'c'], [254.074, -119.008, 'c'], [246.729, -119.008], [246.729, -119.008, 'c'], [232.473, -116.848, 'c'], [228.153, -103.888], [228.153, -103.888, 'c'], [224.265, -77.536, 'c'], [232.041, -71.92], [232.041, -71.92, 'c'], [236.793, -64.576, 'c'], [243.705, -71.056], [250.618, -77.536, 'c'], [265.808, -107.24, 'c'], [263.648, -120.632]],  -closed => 1, -fillcolor => "#323232", -filled => 1, -linecolor => "#323232");

$zinc->add('curve',$top_group,[[263.274, -120.274], [263.274, -120.274, 'c'], [265.354, -128.832, 'c'], [260.69, -124.168], [260.69, -124.168, 'c'], [253.906, -118.656, 'c'], [246.697, -118.656], [246.697, -118.656, 'c'], [232.705, -116.536, 'c'], [228.465, -103.816], [228.465, -103.816, 'c'], [224.649, -77.952, 'c'], [232.281, -72.44], [232.281, -72.44, 'c'], [236.945, -65.232, 'c'], [243.729, -71.592], [250.514, -77.952, 'c'], [265.394, -107.13, 'c'], [263.274, -120.274]],  -closed => 1, -fillcolor => "#666666", -filled => 1, -linecolor => "#666666");

$zinc->add('curve',$top_group,[[262.9, -119.916], [262.9, -119.916, 'c'], [264.97, -128.288, 'c'], [260.394, -123.712], [260.394, -123.712, 'c'], [253.738, -118.304, 'c'], [246.665, -118.304], [246.665, -118.304, 'c'], [232.937, -116.224, 'c'], [228.777, -103.744], [228.777, -103.744, 'c'], [225.033, -78.368, 'c'], [232.521, -72.96], [232.521, -72.96, 'c'], [237.097, -65.888, 'c'], [243.753, -72.128], [250.41, -78.368, 'c'], [264.98, -107.02, 'c'], [262.9, -119.916]],  -closed => 1, -fillcolor => "#999999", -filled => 1, -linecolor => "#999999");

$zinc->add('curve',$top_group,[[262.526, -119.558], [262.526, -119.558, 'c'], [264.586, -127.744, 'c'], [260.098, -123.256], [260.098, -123.256, 'c'], [253.569, -117.952, 'c'], [246.633, -117.952], [246.633, -117.952, 'c'], [233.169, -115.912, 'c'], [229.089, -103.672], [229.089, -103.672, 'c'], [225.417, -78.784, 'c'], [232.761, -73.48], [232.761, -73.48, 'c'], [237.249, -66.544, 'c'], [243.777, -72.664], [250.305, -78.784, 'c'], [264.566, -106.91, 'c'], [262.526, -119.558]],  -closed => 1, -fillcolor => "#cccccc", -filled => 1, -linecolor => "#cccccc");

$zinc->add('curve',$top_group,[[262.151, -119.2], [262.151, -119.2, 'c'], [264.201, -127.2, 'c'], [259.801, -122.8], [259.801, -122.8, 'c'], [253.401, -117.6, 'c'], [246.601, -117.6], [246.601, -117.6, 'c'], [233.401, -115.6, 'c'], [229.401, -103.6], [229.401, -103.6, 'c'], [225.801, -79.2, 'c'], [233.001, -74], [233.001, -74, 'c'], [237.401, -67.2, 'c'], [243.801, -73.2], [250.201, -79.2, 'c'], [264.151, -106.8, 'c'], [262.151, -119.2]],  -closed => 1, -fillcolor => "#ffffff", -filled => 1, -linecolor => "#ffffff");

$zinc->add('curve',$top_group,[[50.6, 84], [50.6, 84, 'c'], [30.2, 64.8, 'c'], [22.2, 64], [22.2, 64, 'c'], [-12.2, 60, 'c'], [-27, 78], [-27, 78, 'c'], [-9.4, 57.6, 'c'], [18.2, 63.2], [18.2, 63.2, 'c'], [-3.4, 58.8, 'c'], [-15.8, 62], [-15.8, 62, 'c'], [-32.6, 62, 'c'], [-42.2, 76], [-45, 80.8], [-45, 80.8, 'c'], [-41, 66, 'c'], [-22.6, 60], [-22.6, 60, 'c'], [0.2, 55.2, 'c'], [11, 60], [11, 60, 'c'], [-10.6, 53.2, 'c'], [-20.6, 55.2], [-20.6, 55.2, 'c'], [-51, 52.8, 'c'], [-63.8, 79.2], [-63.8, 79.2, 'c'], [-59.8, 64.8, 'c'], [-45, 57.6], [-45, 57.6, 'c'], [-31.4, 48.8, 'c'], [-11, 51.6], [-11, 51.6, 'c'], [3.4, 54.8, 'c'], [8.6, 57.2], [13.8, 59.6, 'c'], [12.6, 56.8, 'c'], [4.2, 52], [4.2, 52, 'c'], [-1.4, 42, 'c'], [-15.4, 42.4], [-15.4, 42.4, 'c'], [-58.2, 46, 'c'], [-68.6, 58], [-68.6, 58, 'c'], [-55, 46.8, 'c'], [-44.6, 44], [-44.6, 44, 'c'], [-22.2, 36, 'c'], [-13.8, 36.8], [-13.8, 36.8, 'c'], [11, 37.8, 'c'], [18.6, 33.8], [18.6, 33.8, 'c'], [7.4, 38.8, 'c'], [10.6, 42], [13.8, 45.2, 'c'], [20.6, 52.8, 'c'], [20.6, 54], [20.6, 55.2, 'c'], [44.8, 77.3, 'c'], [48.4, 81.7], [50.6, 84]],  -closed => 1, -fillcolor => "#992600", -filled => 1, -linecolor => "#992600");

$zinc->add('curve',$top_group,[[189, 278], [189, 278, 'c'], [173.5, 241.5, 'c'], [161, 232], [161, 232, 'c'], [187, 248, 'c'], [190.5, 266], [190.5, 266, 'c'], [190.5, 276, 'c'], [189, 278]],  -closed => 1, -fillcolor => "#cccccc", -filled => 1, -linecolor => "#cccccc");

$zinc->add('curve',$top_group,[[236, 285.5], [236, 285.5, 'c'], [209.5, 230.5, 'c'], [191, 206.5], [191, 206.5, 'c'], [234.5, 244, 'c'], [239.5, 270.5], [240, 276], [237, 273.5], [237, 273.5, 'c'], [236.5, 282.5, 'c'], [236, 285.5]],  -closed => 1, -fillcolor => "#cccccc", -filled => 1, -linecolor => "#cccccc");

$zinc->add('curve',$top_group,[[292.5, 237], [292.5, 237, 'c'], [230, 177.5, 'c'], [228.5, 175], [228.5, 175, 'c'], [289, 241, 'c'], [292, 248.5], [292, 248.5, 'c'], [290, 239.5, 'c'], [292.5, 237]],  -closed => 1, -fillcolor => "#cccccc", -filled => 1, -linecolor => "#cccccc");

$zinc->add('curve',$top_group,[[104, 280.5], [104, 280.5, 'c'], [123.5, 228.5, 'c'], [142.5, 251], [142.5, 251, 'c'], [157.5, 261, 'c'], [157, 264], [157, 264, 'c'], [153, 257.5, 'c'], [135, 258], [135, 258, 'c'], [116, 255, 'c'], [104, 280.5]],  -closed => 1, -fillcolor => "#cccccc", -filled => 1, -linecolor => "#cccccc");

$zinc->add('curve',$top_group,[[294.5, 153], [294.5, 153, 'c'], [249.5, 124.5, 'c'], [242, 123], [230.193, 120.639, 'c'], [291.5, 152, 'c'], [296.5, 162.5], [296.5, 162.5, 'c'], [298.5, 160, 'c'], [294.5, 153]],  -closed => 1, -fillcolor => "#cccccc", -filled => 1, -linecolor => "#cccccc");

$zinc->add('curve',$top_group,[[143.801, 259.601], [143.801, 259.601, 'c'], [164.201, 257.601, 'c'], [171.001, 250.801], [175.401, 254.401], [193.001, 216.001], [196.601, 221.201], [196.601, 221.201, 'c'], [211.001, 206.401, 'c'], [210.201, 198.401], [209.401, 190.401, 'c'], [223.001, 204.401, 'c'], [223.001, 204.401], [223.001, 204.401, 'c'], [222.201, 192.801, 'c'], [229.401, 199.601], [229.401, 199.601, 'c'], [227.001, 184.001, 'c'], [235.401, 192.001], [235.401, 192.001, 'c'], [224.864, 161.844, 'c'], [247.401, 187.601], [253.001, 194.001, 'c'], [248.601, 187.201, 'c'], [248.601, 187.201], [248.601, 187.201, 'c'], [222.601, 139.201, 'c'], [244.201, 153.601], [244.201, 153.601, 'c'], [246.201, 130.801, 'c'], [245.001, 126.401], [243.801, 122.001, 'c'], [241.801, 99.6, 'c'], [237.001, 94.4], [232.201, 89.2, 'c'], [237.401, 87.6, 'c'], [243.001, 92.8], [243.001, 92.8, 'c'], [231.801, 68.8, 'c'], [245.001, 80.8], [245.001, 80.8, 'c'], [241.401, 65.6, 'c'], [237.001, 62.8], [237.001, 62.8, 'c'], [231.401, 45.6, 'c'], [246.601, 56.4], [246.601, 56.4, 'c'], [242.201, 44, 'c'], [239.001, 40.8], [239.001, 40.8, 'c'], [227.401, 13.2, 'c'], [234.601, 18], [239.001, 21.6], [239.001, 21.6, 'c'], [232.201, 7.6, 'c'], [238.601, 12], [245.001, 16.4, 'c'], [245.001, 16, 'c'], [245.001, 16], [245.001, 16, 'c'], [223.801, -17.2, 'c'], [244.201, 0.4], [244.201, 0.4, 'c'], [236.042, -13.518, 'c'], [232.601, -20.4], [232.601, -20.4, 'c'], [213.801, -40.8, 'c'], [228.201, -34.4], [233.001, -32.8], [233.001, -32.8, 'c'], [224.201, -42.8, 'c'], [216.201, -44.4], [208.201, -46, 'c'], [218.601, -52.4, 'c'], [225.001, -50.4], [231.401, -48.4, 'c'], [247.001, -40.8, 'c'], [247.001, -40.8], [247.001, -40.8, 'c'], [259.801, -22, 'c'], [263.801, -21.6], [263.801, -21.6, 'c'], [243.801, -29.2, 'c'], [249.801, -21.2], [249.801, -21.2, 'c'], [264.201, -7.2, 'c'], [257.001, -7.6], [257.001, -7.6, 'c'], [251.001, -0.4, 'c'], [255.801, 8.4], [255.801, 8.4, 'c'], [237.342, -9.991, 'c'], [252.201, 15.6], [259.001, 32], [259.001, 32, 'c'], [234.601, 7.2, 'c'], [245.801, 29.2], [245.801, 29.2, 'c'], [263.001, 52.8, 'c'], [265.001, 53.2], [267.001, 53.6, 'c'], [271.401, 62.4, 'c'], [271.401, 62.4], [267.001, 60.4], [272.201, 69.2], [272.201, 69.2, 'c'], [261.001, 57.2, 'c'], [267.001, 70.4], [272.601, 84.8], [272.601, 84.8, 'c'], [252.201, 62.8, 'c'], [265.801, 92.4], [265.801, 92.4, 'c'], [249.401, 87.2, 'c'], [258.201, 104.4], [258.201, 104.4, 'c'], [256.601, 120.401, 'c'], [257.001, 125.601], [257.401, 130.801, 'c'], [258.601, 159.201, 'c'], [254.201, 167.201], [249.801, 175.201, 'c'], [260.201, 194.401, 'c'], [262.201, 198.401], [264.201, 202.401, 'c'], [267.801, 213.201, 'c'], [259.001, 204.001], [250.201, 194.801, 'c'], [254.601, 200.401, 'c'], [256.601, 209.201], [258.601, 218.001, 'c'], [264.601, 233.601, 'c'], [263.801, 239.201], [263.801, 239.201, 'c'], [262.601, 240.401, 'c'], [259.401, 236.801], [259.401, 236.801, 'c'], [244.601, 214.001, 'c'], [246.201, 228.401], [246.201, 228.401, 'c'], [245.001, 236.401, 'c'], [241.801, 245.201], [241.801, 245.201, 'c'], [238.601, 256.001, 'c'], [238.601, 247.201], [238.601, 247.201, 'c'], [235.401, 230.401, 'c'], [232.601, 238.001], [229.801, 245.601, 'c'], [226.201, 251.601, 'c'], [223.401, 254.001], [220.601, 256.401, 'c'], [215.401, 233.601, 'c'], [214.201, 244.001], [214.201, 244.001, 'c'], [202.201, 231.601, 'c'], [197.401, 248.001], [185.801, 264.401], [185.801, 264.401, 'c'], [185.401, 252.001, 'c'], [184.201, 258.001], [184.201, 258.001, 'c'], [154.201, 264.001, 'c'], [143.801, 259.601]],  -closed => 1, -fillcolor => "#000000", -filled => 1, -linecolor => "#000000");

$zinc->add('curve',$top_group,[[109.401, -97.2], [109.401, -97.2, 'c'], [97.801, -105.2, 'c'], [93.801, -104.8], [89.801, -104.4, 'c'], [121.401, -113.6, 'c'], [162.601, -86], [162.601, -86, 'c'], [167.401, -83.2, 'c'], [171.001, -83.6], [171.001, -83.6, 'c'], [174.201, -81.2, 'c'], [171.401, -77.6], [171.401, -77.6, 'c'], [162.601, -68, 'c'], [173.801, -56.8], [173.801, -56.8, 'c'], [192.201, -50, 'c'], [186.601, -58.8], [186.601, -58.8, 'c'], [197.401, -54.8, 'c'], [199.801, -50.8], [202.201, -46.8, 'c'], [201.001, -50.8, 'c'], [201.001, -50.8], [201.001, -50.8, 'c'], [194.601, -58, 'c'], [188.601, -63.2], [188.601, -63.2, 'c'], [183.401, -65.2, 'c'], [180.601, -73.6], [177.801, -82, 'c'], [175.401, -92, 'c'], [179.801, -95.2], [179.801, -95.2, 'c'], [175.801, -90.8, 'c'], [176.601, -94.8], [177.401, -98.8, 'c'], [181.001, -102.4, 'c'], [182.601, -102.8], [184.201, -103.2, 'c'], [200.601, -119, 'c'], [207.401, -119.4], [207.401, -119.4, 'c'], [198.201, -118, 'c'], [195.201, -119], [192.201, -120, 'c'], [165.601, -131.4, 'c'], [159.601, -132.6], [159.601, -132.6, 'c'], [142.801, -139.2, 'c'], [154.801, -137.2], [154.801, -137.2, 'c'], [190.601, -133.4, 'c'], [208.801, -120.2], [208.801, -120.2, 'c'], [201.601, -128.6, 'c'], [183.201, -135.6], [183.201, -135.6, 'c'], [161.001, -148.2, 'c'], [125.801, -143.2], [125.801, -143.2, 'c'], [108.001, -140, 'c'], [100.201, -138.2], [100.201, -138.2, 'c'], [97.601, -138.8, 'c'], [97.001, -139.2], [96.401, -139.6, 'c'], [84.6, -148.6, 'c'], [57, -141.6], [57, -141.6, 'c'], [40, -137, 'c'], [31.4, -132.2], [31.4, -132.2, 'c'], [16.2, -131, 'c'], [12.6, -127.8], [12.6, -127.8, 'c'], [-6, -113.2, 'c'], [-8, -112.4], [-10, -111.6, 'c'], [-21.4, -104, 'c'], [-22.2, -103.6], [-22.2, -103.6, 'c'], [2.4, -110.2, 'c'], [4.8, -112.6], [7.2, -115, 'c'], [24.6, -117.6, 'c'], [27, -116.2], [29.4, -114.8, 'c'], [37.8, -115.4, 'c'], [28.2, -114.8], [28.2, -114.8, 'c'], [103.801, -100, 'c'], [104.601, -98], [105.401, -96, 'c'], [109.401, -97.2, 'c'], [109.401, -97.2]],  -closed => 1, -fillcolor => "#000000", -filled => 1, -linecolor => "#000000");

$zinc->add('curve',$top_group,[[180.801, -106.4], [180.801, -106.4, 'c'], [170.601, -113.8, 'c'], [168.601, -113.8], [166.601, -113.8, 'c'], [154.201, -124, 'c'], [150.001, -123.6], [145.801, -123.2, 'c'], [133.601, -133.2, 'c'], [106.201, -125], [106.201, -125, 'c'], [105.601, -127, 'c'], [109.201, -127.8], [109.201, -127.8, 'c'], [115.601, -130, 'c'], [116.001, -130.6], [116.001, -130.6, 'c'], [136.201, -134.8, 'c'], [143.401, -131.2], [143.401, -131.2, 'c'], [152.601, -128.6, 'c'], [158.801, -122.4], [158.801, -122.4, 'c'], [170.001, -119.2, 'c'], [173.201, -120.2], [173.201, -120.2, 'c'], [182.001, -118, 'c'], [182.401, -116.2], [182.401, -116.2, 'c'], [188.201, -113.2, 'c'], [186.401, -110.6], [186.401, -110.6, 'c'], [186.801, -109, 'c'], [180.801, -106.4]],  -closed => 1, -fillcolor => "#cc7226", -filled => 1, -linecolor => "#cc7226");

$zinc->add('curve',$top_group,[[168.33, -108.509], [169.137, -107.877, 'c'], [170.156, -107.779, 'c'], [170.761, -106.97], [170.995, -106.656, 'c'], [170.706, -106.33, 'c'], [170.391, -106.233], [169.348, -105.916, 'c'], [168.292, -106.486, 'c'], [167.15, -105.898], [166.748, -105.691, 'c'], [166.106, -105.873, 'c'], [165.553, -106.022], [163.921, -106.463, 'c'], [162.092, -106.488, 'c'], [160.401, -105.8], [158.416, -106.929, 'c'], [156.056, -106.345, 'c'], [153.975, -107.346], [153.917, -107.373, 'c'], [153.695, -107.027, 'c'], [153.621, -107.054], [150.575, -108.199, 'c'], [146.832, -107.916, 'c'], [144.401, -110.2], [141.973, -110.612, 'c'], [139.616, -111.074, 'c'], [137.188, -111.754], [135.37, -112.263, 'c'], [133.961, -113.252, 'c'], [132.341, -114.084], [130.964, -114.792, 'c'], [129.507, -115.314, 'c'], [127.973, -115.686], [126.11, -116.138, 'c'], [124.279, -116.026, 'c'], [122.386, -116.546], [122.293, -116.571, 'c'], [122.101, -116.227, 'c'], [122.019, -116.254], [121.695, -116.362, 'c'], [121.405, -116.945, 'c'], [121.234, -116.892], [119.553, -116.37, 'c'], [118.065, -117.342, 'c'], [116.401, -117], [115.223, -118.224, 'c'], [113.495, -117.979, 'c'], [111.949, -118.421], [108.985, -119.269, 'c'], [105.831, -117.999, 'c'], [102.801, -119], [106.914, -120.842, 'c'], [111.601, -119.61, 'c'], [115.663, -121.679], [117.991, -122.865, 'c'], [120.653, -121.763, 'c'], [123.223, -122.523], [123.71, -122.667, 'c'], [124.401, -122.869, 'c'], [124.801, -122.2], [124.935, -122.335, 'c'], [125.117, -122.574, 'c'], [125.175, -122.546], [127.625, -121.389, 'c'], [129.94, -120.115, 'c'], [132.422, -119.049], [132.763, -118.903, 'c'], [133.295, -119.135, 'c'], [133.547, -118.933], [135.067, -117.717, 'c'], [137.01, -117.82, 'c'], [138.401, -116.6], [140.099, -117.102, 'c'], [141.892, -116.722, 'c'], [143.621, -117.346], [143.698, -117.373, 'c'], [143.932, -117.032, 'c'], [143.965, -117.054], [145.095, -117.802, 'c'], [146.25, -117.531, 'c'], [147.142, -117.227], [147.48, -117.112, 'c'], [148.143, -116.865, 'c'], [148.448, -116.791], [149.574, -116.515, 'c'], [150.43, -116.035, 'c'], [151.609, -115.852], [151.723, -115.834, 'c'], [151.908, -116.174, 'c'], [151.98, -116.146], [153.103, -115.708, 'c'], [154.145, -115.764, 'c'], [154.801, -114.6], [154.936, -114.735, 'c'], [155.101, -114.973, 'c'], [155.183, -114.946], [156.21, -114.608, 'c'], [156.859, -113.853, 'c'], [157.96, -113.612], [158.445, -113.506, 'c'], [159.057, -112.88, 'c'], [159.633, -112.704], [162.025, -111.973, 'c'], [163.868, -110.444, 'c'], [166.062, -109.549], [166.821, -109.239, 'c'], [167.697, -109.005, 'c'], [168.33, -108.509]],  -closed => 1, -fillcolor => "#cc7226", -filled => 1, -linecolor => "#cc7226");

$zinc->add('curve',$top_group,[[91.696, -122.739], [89.178, -124.464, 'c'], [86.81, -125.57, 'c'], [84.368, -127.356], [84.187, -127.489, 'c'], [83.827, -127.319, 'c'], [83.625, -127.441], [82.618, -128.05, 'c'], [81.73, -128.631, 'c'], [80.748, -129.327], [80.209, -129.709, 'c'], [79.388, -129.698, 'c'], [78.88, -129.956], [76.336, -131.248, 'c'], [73.707, -131.806, 'c'], [71.2, -133], [71.882, -133.638, 'c'], [73.004, -133.394, 'c'], [73.6, -134.2], [73.795, -133.92, 'c'], [74.033, -133.636, 'c'], [74.386, -133.827], [76.064, -134.731, 'c'], [77.914, -134.884, 'c'], [79.59, -134.794], [81.294, -134.702, 'c'], [83.014, -134.397, 'c'], [84.789, -134.125], [85.096, -134.078, 'c'], [85.295, -133.555, 'c'], [85.618, -133.458], [87.846, -132.795, 'c'], [90.235, -133.32, 'c'], [92.354, -132.482], [93.945, -131.853, 'c'], [95.515, -131.03, 'c'], [96.754, -129.755], [97.006, -129.495, 'c'], [96.681, -129.194, 'c'], [96.401, -129], [96.789, -129.109, 'c'], [97.062, -128.903, 'c'], [97.173, -128.59], [97.257, -128.351, 'c'], [97.257, -128.049, 'c'], [97.173, -127.81], [97.061, -127.498, 'c'], [96.782, -127.397, 'c'], [96.408, -127.346], [95.001, -127.156, 'c'], [96.773, -128.536, 'c'], [96.073, -128.088], [94.8, -127.274, 'c'], [95.546, -125.868, 'c'], [94.801, -124.6], [94.521, -124.794, 'c'], [94.291, -125.012, 'c'], [94.401, -125.4], [94.635, -124.878, 'c'], [94.033, -124.588, 'c'], [93.865, -124.272], [93.48, -123.547, 'c'], [92.581, -122.132, 'c'], [91.696, -122.739]],  -closed => 1, -fillcolor => "#cc7226", -filled => 1, -linecolor => "#cc7226");

$zinc->add('curve',$top_group,[[59.198, -115.391], [56.044, -116.185, 'c'], [52.994, -116.07, 'c'], [49.978, -117.346], [49.911, -117.374, 'c'], [49.688, -117.027, 'c'], [49.624, -117.054], [48.258, -117.648, 'c'], [47.34, -118.614, 'c'], [46.264, -119.66], [45.351, -120.548, 'c'], [43.693, -120.161, 'c'], [42.419, -120.648], [42.095, -120.772, 'c'], [41.892, -121.284, 'c'], [41.591, -121.323], [40.372, -121.48, 'c'], [39.445, -122.429, 'c'], [38.4, -123], [40.736, -123.795, 'c'], [43.147, -123.764, 'c'], [45.609, -124.148], [45.722, -124.166, 'c'], [45.867, -123.845, 'c'], [46, -123.845], [46.136, -123.845, 'c'], [46.266, -124.066, 'c'], [46.4, -124.2], [46.595, -123.92, 'c'], [46.897, -123.594, 'c'], [47.154, -123.848], [47.702, -124.388, 'c'], [48.258, -124.198, 'c'], [48.798, -124.158], [48.942, -124.148, 'c'], [49.067, -123.845, 'c'], [49.2, -123.845], [49.336, -123.845, 'c'], [49.467, -124.156, 'c'], [49.6, -124.156], [49.736, -124.155, 'c'], [49.867, -123.845, 'c'], [50, -123.845], [50.136, -123.845, 'c'], [50.266, -124.066, 'c'], [50.4, -124.2], [51.092, -123.418, 'c'], [51.977, -123.972, 'c'], [52.799, -123.793], [53.837, -123.566, 'c'], [54.104, -122.418, 'c'], [55.178, -122.12], [59.893, -120.816, 'c'], [64.03, -118.671, 'c'], [68.393, -116.584], [68.7, -116.437, 'c'], [68.91, -116.189, 'c'], [68.8, -115.8], [69.067, -115.8, 'c'], [69.38, -115.888, 'c'], [69.57, -115.756], [70.628, -115.024, 'c'], [71.669, -114.476, 'c'], [72.366, -113.378], [72.582, -113.039, 'c'], [72.253, -112.632, 'c'], [72.02, -112.684], [67.591, -113.679, 'c'], [63.585, -114.287, 'c'], [59.198, -115.391]],  -closed => 1, -fillcolor => "#cc7226", -filled => 1, -linecolor => "#cc7226");

$zinc->add('curve',$top_group,[[45.338, -71.179], [43.746, -72.398, 'c'], [43.162, -74.429, 'c'], [42.034, -76.221], [41.82, -76.561, 'c'], [42.094, -76.875, 'c'], [42.411, -76.964], [42.971, -77.123, 'c'], [43.514, -76.645, 'c'], [43.923, -76.443], [45.668, -75.581, 'c'], [47.203, -74.339, 'c'], [49.2, -74.2], [51.19, -71.966, 'c'], [55.45, -71.581, 'c'], [55.457, -68.2], [55.458, -67.341, 'c'], [54.03, -68.259, 'c'], [53.6, -67.4], [51.149, -68.403, 'c'], [48.76, -68.3, 'c'], [46.38, -69.767], [45.763, -70.148, 'c'], [46.093, -70.601, 'c'], [45.338, -71.179]],  -closed => 1, -fillcolor => "#cc7226", -filled => 1, -linecolor => "#cc7226");

$zinc->add('curve',$top_group,[[17.8, -123.756], [17.935, -123.755, 'c'], [24.966, -123.522, 'c'], [24.949, -123.408], [24.904, -123.099, 'c'], [17.174, -122.05, 'c'], [16.81, -122.22], [16.646, -122.296, 'c'], [9.134, -119.866, 'c'], [9, -120], [9.268, -120.135, 'c'], [17.534, -123.756, 'c'], [17.8, -123.756]],  -closed => 1, -fillcolor => "#cc7226", -filled => 1, -linecolor => "#cc7226");

$zinc->add('curve',$top_group,[[33.2, -114], [33.2, -114, 'c'], [18.4, -112.2, 'c'], [14, -111], [9.6, -109.8, 'c'], [-9, -102.2, 'c'], [-12, -100.2], [-12, -100.2, 'c'], [-25.4, -94.8, 'c'], [-42.4, -74.8], [-42.4, -74.8, 'c'], [-34.8, -78.2, 'c'], [-32.6, -81], [-32.6, -81, 'c'], [-19, -93.6, 'c'], [-19.2, -91], [-19.2, -91, 'c'], [-7, -99.6, 'c'], [-7.6, -97.4], [-7.6, -97.4, 'c'], [16.8, -108.6, 'c'], [14.8, -105.4], [14.8, -105.4, 'c'], [36.4, -110, 'c'], [35.4, -108], [35.4, -108, 'c'], [54.2, -103.6, 'c'], [51.4, -103.4], [51.4, -103.4, 'c'], [45.6, -102.2, 'c'], [52, -98.6], [52, -98.6, 'c'], [48.6, -94.2, 'c'], [43.2, -98.2], [37.8, -102.2, 'c'], [40.8, -100, 'c'], [35.8, -99], [35.8, -99, 'c'], [33.2, -98.2, 'c'], [28.6, -102.2], [28.6, -102.2, 'c'], [23, -106.8, 'c'], [14.2, -103.2], [14.2, -103.2, 'c'], [-16.4, -90.6, 'c'], [-18.4, -90], [-18.4, -90, 'c'], [-22, -87.2, 'c'], [-24.4, -83.6], [-24.4, -83.6, 'c'], [-30.2, -79.2, 'c'], [-33.2, -77.8], [-33.2, -77.8, 'c'], [-46, -66.2, 'c'], [-47.2, -64.8], [-47.2, -64.8, 'c'], [-50.6, -59.6, 'c'], [-51.4, -59.2], [-51.4, -59.2, 'c'], [-45, -63, 'c'], [-43, -65], [-43, -65, 'c'], [-29, -75, 'c'], [-23.6, -75.8], [-23.6, -75.8, 'c'], [-19.2, -78.8, 'c'], [-18.4, -80.2], [-18.4, -80.2, 'c'], [-4, -89.4, 'c'], [0.2, -89.4], [0.2, -89.4, 'c'], [9.4, -84.2, 'c'], [11.8, -91.2], [11.8, -91.2, 'c'], [17.6, -93, 'c'], [23.2, -91.8], [23.2, -91.8, 'c'], [26.4, -94.4, 'c'], [25.6, -96.6], [25.6, -96.6, 'c'], [27.2, -98.4, 'c'], [28.2, -94.6], [28.2, -94.6, 'c'], [31.6, -91, 'c'], [36.4, -93], [36.4, -93, 'c'], [40.4, -93.2, 'c'], [38.4, -90.8], [38.4, -90.8, 'c'], [34, -87, 'c'], [22.2, -86.8], [22.2, -86.8, 'c'], [9.8, -86.2, 'c'], [-6.6, -78.6], [-6.6, -78.6, 'c'], [-36.4, -68.2, 'c'], [-45.6, -57.8], [-45.6, -57.8, 'c'], [-52, -49, 'c'], [-57.4, -47.8], [-57.4, -47.8, 'c'], [-63.2, -47, 'c'], [-69.2, -39.6], [-69.2, -39.6, 'c'], [-59.4, -45.4, 'c'], [-50.4, -45.4], [-50.4, -45.4, 'c'], [-46.4, -47.8, 'c'], [-50.2, -44.2], [-50.2, -44.2, 'c'], [-53.8, -36.6, 'c'], [-52.2, -31.2], [-52.2, -31.2, 'c'], [-52.8, -26, 'c'], [-53.6, -24.4], [-53.6, -24.4, 'c'], [-61.4, -11.6, 'c'], [-61.4, -9.2], [-61.4, -6.8, 'c'], [-60.2, 3, 'c'], [-59.8, 3.6], [-59.4, 4.2, 'c'], [-60.8, 2, 'c'], [-57, 4.4], [-53.2, 6.8, 'c'], [-50.4, 8.4, 'c'], [-49.6, 11.2], [-48.8, 14, 'c'], [-51.6, 5.8, 'c'], [-51.8, 4], [-52, 2.2, 'c'], [-56.2, -5, 'c'], [-55.4, -7.4], [-55.4, -7.4, 'c'], [-54.4, -6.4, 'c'], [-53.6, -5], [-53.6, -5, 'c'], [-54.2, -5.6, 'c'], [-53.6, -9.2], [-53.6, -9.2, 'c'], [-52.8, -14.4, 'c'], [-51.4, -17.6], [-50, -20.8, 'c'], [-48, -24.6, 'c'], [-47.6, -25.4], [-47.2, -26.2, 'c'], [-47.2, -32, 'c'], [-45.8, -29.4], [-42.4, -26.8], [-42.4, -26.8, 'c'], [-45.2, -29.4, 'c'], [-43, -31.6], [-43, -31.6, 'c'], [-44, -37.2, 'c'], [-42.2, -39.8], [-42.2, -39.8, 'c'], [-35.2, -48.2, 'c'], [-33.6, -49.2], [-32, -50.2, 'c'], [-33.4, -49.8, 'c'], [-33.4, -49.8], [-33.4, -49.8, 'c'], [-27.4, -54, 'c'], [-33.2, -52.4], [-33.2, -52.4, 'c'], [-37.2, -50.8, 'c'], [-40.2, -50.8], [-40.2, -50.8, 'c'], [-47.8, -48.8, 'c'], [-43.8, -53], [-39.8, -57.2, 'c'], [-29.8, -62.6, 'c'], [-26, -62.4], [-25.2, -60.8], [-14, -63.2], [-15.2, -62.4], [-15.2, -62.4, 'c'], [-15.4, -62.6, 'c'], [-11.2, -63], [-7, -63.4, 'c'], [-1.2, -62, 'c'], [0.2, -63.8], [1.6, -65.6, 'c'], [5, -66.6, 'c'], [4.6, -65.2], [4.2, -63.8, 'c'], [4, -61.8, 'c'], [4, -61.8], [4, -61.8, 'c'], [9, -67.6, 'c'], [8.4, -65.4], [7.8, -63.2, 'c'], [-0.4, -58, 'c'], [-1.8, -51.8], [8.6, -60], [12.2, -63], [12.2, -63, 'c'], [15.8, -60.8, 'c'], [16, -62.4], [16.2, -64, 'c'], [20.8, -69.8, 'c'], [22, -69.6], [23.2, -69.4, 'c'], [25.2, -72.2, 'c'], [25, -69.6], [24.8, -67, 'c'], [32.4, -61.6, 'c'], [32.4, -61.6], [32.4, -61.6, 'c'], [35.6, -63.4, 'c'], [37, -62], [38.4, -60.6, 'c'], [42.6, -81.8, 'c'], [42.6, -81.8], [67.6, -92.4], [111.201, -95.8], [94.201, -102.6], [33.2, -114]],  -closed => 1, -fillcolor => "#000000", -filled => 1, -linecolor => "#000000");

$zinc->add('curve',$top_group,[[20.895, 54.407], [22.437, 55.87, 'c'], [49.4, 84.8, 'c'], [49.4, 84.8], [84.6, 121.401, 'c'], [56.6, 87.2, 'c'], [56.6, 87.2], [49, 82.4, 'c'], [39.8, 63.6, 'c'], [39.8, 63.6], [38.6, 60.8, 'c'], [53.8, 70.8, 'c'], [53.8, 70.8], [57.8, 71.6, 'c'], [71.4, 90.8, 'c'], [71.4, 90.8], [64.6, 88.4, 'c'], [69.4, 95.6, 'c'], [69.4, 95.6], [72.2, 97.6, 'c'], [92.601, 113.201, 'c'], [92.601, 113.201], [96.201, 117.201, 'c'], [100.201, 118.801, 'c'], [100.201, 118.801], [114.201, 113.601, 'c'], [107.801, 126.801, 'c'], [107.801, 126.801], [110.201, 133.601, 'c'], [115.801, 122.001, 'c'], [115.801, 122.001], [127.001, 105.2, 'c'], [110.601, 107.601, 'c'], [110.601, 107.601], [80.6, 110.401, 'c'], [73.8, 94.4, 'c'], [73.8, 94.4], [71.4, 92, 'c'], [80.2, 94.4, 'c'], [80.2, 94.4], [88.601, 96.4, 'c'], [73, 82, 'c'], [73, 82], [75.4, 82, 'c'], [84.6, 88.8, 'c'], [84.6, 88.8], [95.001, 98, 'c'], [97.001, 96, 'c'], [97.001, 96], [115.001, 87.2, 'c'], [125.401, 94.8, 'c'], [125.401, 94.8], [127.401, 96.4, 'c'], [121.801, 103.2, 'c'], [123.401, 108.401], [125.001, 113.601, 'c'], [129.801, 126.001, 'c'], [129.801, 126.001], [127.401, 127.601, 'c'], [127.801, 138.401, 'c'], [127.801, 138.401], [144.601, 161.601, 'c'], [135.001, 159.601, 'c'], [135.001, 159.601], [119.401, 159.201, 'c'], [134.201, 166.801, 'c'], [134.201, 166.801], [137.401, 168.801, 'c'], [146.201, 176.001, 'c'], [146.201, 176.001], [143.401, 174.801, 'c'], [141.801, 180.001, 'c'], [141.801, 180.001], [146.601, 184.001, 'c'], [143.801, 188.801, 'c'], [143.801, 188.801], [137.801, 190.001, 'c'], [136.601, 194.001, 'c'], [136.601, 194.001], [143.401, 202.001, 'c'], [133.401, 202.401, 'c'], [133.401, 202.401], [137.001, 206.801, 'c'], [132.201, 218.801, 'c'], [132.201, 218.801], [127.401, 218.801, 'c'], [121.001, 224.401, 'c'], [121.001, 224.401], [123.401, 229.201, 'c'], [113.001, 234.801, 'c'], [113.001, 234.801], [104.601, 236.401, 'c'], [107.401, 243.201, 'c'], [107.401, 243.201], [99.401, 249.201, 'c'], [97.001, 265.201, 'c'], [97.001, 265.201], [96.201, 275.601, 'c'], [93.801, 278.801, 'c'], [99.001, 276.801], [104.201, 274.801, 'c'], [103.401, 262.401, 'c'], [103.401, 262.401], [98.601, 246.801, 'c'], [141.401, 230.801, 'c'], [141.401, 230.801], [145.401, 229.201, 'c'], [146.201, 224.001, 'c'], [146.201, 224.001], [148.201, 224.401, 'c'], [157.001, 232.001, 'c'], [157.001, 232.001], [164.601, 243.201, 'c'], [165.001, 234.001, 'c'], [165.001, 234.001], [166.201, 230.401, 'c'], [164.601, 224.401, 'c'], [164.601, 224.401], [170.601, 202.801, 'c'], [156.601, 196.401, 'c'], [156.601, 196.401], [146.601, 162.801, 'c'], [160.601, 171.201, 'c'], [160.601, 171.201], [163.401, 176.801, 'c'], [174.201, 182.001, 'c'], [174.201, 182.001], [177.801, 179.601], [176.201, 174.801, 'c'], [184.601, 168.801, 'c'], [184.601, 168.801], [187.401, 175.201, 'c'], [193.401, 167.201, 'c'], [193.401, 167.201], [197.001, 142.801, 'c'], [209.401, 157.201, 'c'], [209.401, 157.201], [213.401, 158.401, 'c'], [214.601, 151.601, 'c'], [214.601, 151.601], [218.201, 141.201, 'c'], [214.601, 127.601, 'c'], [214.601, 127.601], [218.201, 127.201, 'c'], [227.801, 133.201, 'c'], [227.801, 133.201], [230.601, 129.601, 'c'], [221.401, 112.801, 'c'], [225.401, 115.201], [229.401, 117.601, 'c'], [233.801, 119.201, 'c'], [233.801, 119.201], [234.601, 117.201, 'c'], [224.601, 104.801, 'c'], [224.601, 104.801], [220.201, 102, 'c'], [215.001, 81.6, 'c'], [215.001, 81.6], [222.201, 85.2, 'c'], [212.201, 70, 'c'], [212.201, 70], [212.201, 66.8, 'c'], [218.201, 55.6, 'c'], [218.201, 55.6], [217.401, 48.8, 'c'], [218.201, 49.2, 'c'], [218.201, 49.2], [221.001, 50.4, 'c'], [229.001, 52, 'c'], [222.201, 45.6], [215.401, 39.2, 'c'], [223.001, 34.4, 'c'], [223.001, 34.4], [227.401, 31.6, 'c'], [213.801, 32, 'c'], [213.801, 32], [208.601, 27.6, 'c'], [209.001, 23.6, 'c'], [209.001, 23.6], [217.001, 25.6, 'c'], [202.601, 11.2, 'c'], [200.201, 7.6], [197.801, 4, 'c'], [207.401, -1.2, 'c'], [207.401, -1.2], [220.601, -4.8, 'c'], [209.001, -8, 'c'], [209.001, -8], [189.401, -7.6, 'c'], [200.201, -18.4, 'c'], [200.201, -18.4], [206.201, -18, 'c'], [204.601, -20.4, 'c'], [204.601, -20.4], [199.401, -21.6, 'c'], [189.801, -28, 'c'], [189.801, -28], [185.801, -31.6, 'c'], [189.401, -30.8, 'c'], [189.401, -30.8], [206.201, -29.6, 'c'], [177.401, -40.8, 'c'], [177.401, -40.8], [185.401, -40.8, 'c'], [167.401, -51.2, 'c'], [167.401, -51.2], [165.401, -52.8, 'c'], [162.201, -60.4, 'c'], [162.201, -60.4], [156.201, -65.6, 'c'], [151.401, -72.4, 'c'], [151.401, -72.4], [151.001, -76.8, 'c'], [146.201, -81.6, 'c'], [146.201, -81.6], [134.601, -95.2, 'c'], [129.001, -94.8, 'c'], [129.001, -94.8], [114.201, -98.4, 'c'], [109.001, -97.6, 'c'], [109.001, -97.6], [56.2, -93.2], [29.8, -80.4, 'c'], [37.6, -59.4, 'c'], [37.6, -59.4], [44, -51, 'c'], [53.2, -54.8, 'c'], [53.2, -54.8], [57.8, -61, 'c'], [69.4, -58.8, 'c'], [69.4, -58.8], [89.801, -55.6, 'c'], [87.201, -59.2, 'c'], [87.201, -59.2], [84.801, -63.8, 'c'], [68.6, -70, 'c'], [68.4, -70.6], [68.2, -71.2, 'c'], [59.4, -74.6, 'c'], [59.4, -74.6], [56.4, -75.8, 'c'], [52, -85, 'c'], [52, -85], [48.8, -88.4, 'c'], [64.6, -82.6, 'c'], [64.6, -82.6], [63.4, -81.6, 'c'], [70.8, -77.6, 'c'], [70.8, -77.6], [88.201, -78.6, 'c'], [98.801, -67.8, 'c'], [98.801, -67.8], [109.601, -51.2, 'c'], [109.801, -59.4, 'c'], [109.801, -59.4], [112.601, -68.8, 'c'], [100.801, -90, 'c'], [100.801, -90], [101.201, -92, 'c'], [109.401, -85.4, 'c'], [109.401, -85.4], [110.801, -87.4, 'c'], [111.601, -81.6, 'c'], [111.601, -81.6], [111.801, -79.2, 'c'], [115.601, -71.2, 'c'], [115.601, -71.2], [118.401, -58.2, 'c'], [122.001, -65.6, 'c'], [122.001, -65.6], [126.601, -56.2], [128.001, -53.6, 'c'], [122.001, -46, 'c'], [122.001, -46], [121.801, -43.2, 'c'], [122.601, -43.4, 'c'], [117.001, -35.8], [111.401, -28.2, 'c'], [114.801, -23.8, 'c'], [114.801, -23.8], [113.401, -17.2, 'c'], [122.201, -17.6, 'c'], [122.201, -17.6], [124.801, -15.4, 'c'], [128.201, -15.4, 'c'], [128.201, -15.4], [130.001, -13.4, 'c'], [132.401, -14, 'c'], [132.401, -14], [134.001, -17.8, 'c'], [140.201, -15.8, 'c'], [140.201, -15.8], [141.601, -18.2, 'c'], [149.801, -18.6, 'c'], [149.801, -18.6], [150.801, -21.2, 'c'], [151.201, -22.8, 'c'], [154.601, -23.4], [158.001, -24, 'c'], [133.401, -67, 'c'], [133.401, -67], [139.801, -67.8, 'c'], [131.601, -80.2, 'c'], [131.601, -80.2], [129.401, -86.8, 'c'], [140.801, -72.2, 'c'], [143.001, -70.8], [145.201, -69.4, 'c'], [146.201, -67.2, 'c'], [144.601, -67.4], [143.001, -67.6, 'c'], [141.201, -65.4, 'c'], [142.601, -65.2], [144.001, -65, 'c'], [157.001, -50, 'c'], [160.401, -39.8], [163.801, -29.6, 'c'], [169.801, -25.6, 'c'], [176.001, -19.6], [182.201, -13.6, 'c'], [181.401, 10.6, 'c'], [181.401, 10.6], [181.001, 19.4, 'c'], [187.001, 30, 'c'], [187.001, 30], [189.001, 33.8, 'c'], [184.801, 52, 'c'], [184.801, 52], [182.801, 54.2, 'c'], [184.201, 55, 'c'], [184.201, 55], [185.201, 56.2, 'c'], [192.001, 69.4, 'c'], [192.001, 69.4], [190.201, 69.2, 'c'], [193.801, 72.8, 'c'], [193.801, 72.8], [199.001, 78.8, 'c'], [192.601, 75.8, 'c'], [192.601, 75.8], [186.601, 74.2, 'c'], [193.601, 84, 'c'], [193.601, 84], [194.801, 85.8, 'c'], [185.801, 81.2, 'c'], [185.801, 81.2], [176.601, 80.6, 'c'], [188.201, 87.8, 'c'], [188.201, 87.8], [196.801, 95, 'c'], [185.401, 90.6, 'c'], [185.401, 90.6], [180.801, 88.8, 'c'], [184.001, 95.6, 'c'], [184.001, 95.6], [187.201, 97.2, 'c'], [204.401, 104.2, 'c'], [204.401, 104.2], [204.801, 108.001, 'c'], [201.801, 113.001, 'c'], [201.801, 113.001], [202.201, 117.001, 'c'], [200.001, 120.401, 'c'], [200.001, 120.401], [198.801, 128.601, 'c'], [198.201, 129.401, 'c'], [198.201, 129.401], [194.001, 129.601, 'c'], [186.601, 143.401, 'c'], [186.601, 143.401], [184.801, 146.001, 'c'], [174.601, 158.001, 'c'], [174.601, 158.001], [172.601, 165.001, 'c'], [154.601, 157.801, 'c'], [154.601, 157.801], [148.001, 161.201, 'c'], [150.001, 157.801, 'c'], [150.001, 157.801], [149.601, 155.601, 'c'], [154.401, 149.601, 'c'], [154.401, 149.601], [161.401, 147.001, 'c'], [158.801, 136.201, 'c'], [158.801, 136.201], [162.801, 134.801, 'c'], [151.601, 132.001, 'c'], [151.801, 130.801], [152.001, 129.601, 'c'], [157.801, 128.201, 'c'], [157.801, 128.201], [165.801, 126.201, 'c'], [161.401, 123.801, 'c'], [161.401, 123.801], [160.801, 119.801, 'c'], [163.801, 114.201, 'c'], [163.801, 114.201], [175.401, 113.401, 'c'], [163.801, 97.2, 'c'], [163.801, 97.2], [153.001, 89.6, 'c'], [152.001, 83.8, 'c'], [152.001, 83.8], [164.601, 75.6, 'c'], [156.401, 63.2, 'c'], [156.601, 59.6], [156.801, 56, 'c'], [158.001, 34.4, 'c'], [158.001, 34.4], [156.001, 28.2, 'c'], [153.001, 14.6, 'c'], [153.001, 14.6], [155.201, 9.4, 'c'], [162.601, -3.2, 'c'], [162.601, -3.2], [165.401, -7.4, 'c'], [174.201, -12.2, 'c'], [172.001, -15.2], [169.801, -18.2, 'c'], [162.001, -16.4, 'c'], [162.001, -16.4], [154.201, -17.8, 'c'], [154.801, -12.6, 'c'], [154.801, -12.6], [153.201, -11.6, 'c'], [152.401, -6.6, 'c'], [152.401, -6.6], [151.68, 1.333, 'c'], [142.801, 7.6, 'c'], [142.801, 7.6], [131.601, 13.8, 'c'], [140.801, 17.8, 'c'], [140.801, 17.8], [146.801, 24.4, 'c'], [137.001, 24.6, 'c'], [137.001, 24.6], [126.001, 22.8, 'c'], [134.201, 33, 'c'], [134.201, 33], [145.001, 45.8, 'c'], [142.001, 48.6, 'c'], [142.001, 48.6], [131.801, 49.6, 'c'], [144.401, 58.8, 'c'], [144.401, 58.8], [144.401, 58.8, 'c'], [143.601, 56.8, 'c'], [143.801, 58.6], [144.001, 60.4, 'c'], [147.001, 64.6, 'c'], [147.801, 66.6], [148.601, 68.6, 'c'], [144.601, 68.8, 'c'], [144.601, 68.8], [145.201, 78.4, 'c'], [129.801, 74.2, 'c'], [129.801, 74.2], [129.801, 74.2, 'c'], [129.801, 74.2, 'c'], [128.201, 74.4], [126.601, 74.6, 'c'], [115.401, 73.8, 'c'], [109.601, 71.6], [103.801, 69.4, 'c'], [97.001, 69.4, 'c'], [97.001, 69.4], [97.001, 69.4, 'c'], [93.001, 71.2, 'c'], [85.4, 71], [77.8, 70.8, 'c'], [69.8, 73.6, 'c'], [69.8, 73.6], [65.4, 73.2, 'c'], [74, 68.8, 'c'], [74.2, 69], [74.4, 69.2, 'c'], [80, 63.6, 'c'], [72, 64.2], [50.203, 65.835, 'c'], [39.4, 55.6, 'c'], [39.4, 55.6], [37.4, 54.2, 'c'], [34.8, 51.4, 'c'], [34.8, 51.4], [24.8, 49.4, 'c'], [36.2, 63.8, 'c'], [36.2, 63.8], [37.4, 65.2, 'c'], [36, 66.2, 'c'], [36, 66.2], [35.2, 64.6, 'c'], [27.4, 59.2, 'c'], [27.4, 59.2], [24.589, 58.227, 'c'], [23.226, 56.893, 'c'], [20.895, 54.407]],  -closed => 1, -fillcolor => "#000000", -filled => 1, -linecolor => "#000000");

$zinc->add('curve',$top_group,[[-3, 42.8], [-3, 42.8, 'c'], [8.6, 48.4, 'c'], [11.2, 51.2], [13.8, 54, 'c'], [27.8, 65.4, 'c'], [27.8, 65.4], [27.8, 65.4, 'c'], [22.4, 63.4, 'c'], [19.8, 61.6], [17.2, 59.8, 'c'], [6.4, 51.6, 'c'], [6.4, 51.6], [6.4, 51.6, 'c'], [2.6, 45.6, 'c'], [-3, 42.8]],  -closed => 1, -fillcolor => "#4c0000", -filled => 1, -linecolor => "#4c0000");

$zinc->add('curve',$top_group,[[-61.009, 11.603], [-60.672, 11.455, 'c'], [-61.196, 8.743, 'c'], [-61.4, 8.2], [-62.422, 5.474, 'c'], [-71.4, 4, 'c'], [-71.4, 4], [-71.627, 5.365, 'c'], [-71.682, 6.961, 'c'], [-71.576, 8.599], [-71.576, 8.599, 'c'], [-66.708, 14.118, 'c'], [-61.009, 11.603]],  -closed => 1, -fillcolor => "#99cc32", -filled => 1, -linecolor => "#99cc32");

$zinc->add('curve',$top_group,[[-61.009, 11.403], [-61.458, 11.561, 'c'], [-61.024, 8.669, 'c'], [-61.2, 8.2], [-62.222, 5.474, 'c'], [-71.4, 3.9, 'c'], [-71.4, 3.9], [-71.627, 5.265, 'c'], [-71.682, 6.861, 'c'], [-71.576, 8.499], [-71.576, 8.499, 'c'], [-67.308, 13.618, 'c'], [-61.009, 11.403]],  -closed => 1, -fillcolor => "#659900", -filled => 1, -linecolor => "#659900");

$zinc->add('curve',$top_group,[[-65.4, 11.546], [-66.025, 11.546, 'c'], [-66.531, 10.406, 'c'], [-66.531, 9], [-66.531, 7.595, 'c'], [-66.025, 6.455, 'c'], [-65.4, 6.455], [-64.775, 6.455, 'c'], [-64.268, 7.595, 'c'], [-64.268, 9], [-64.268, 10.406, 'c'], [-64.775, 11.546, 'c'], [-65.4, 11.546]],  -closed => 1, -fillcolor => "#000000", -filled => 1, -linecolor => "#000000");

$zinc->add('curve',$top_group,[[-65.4, 9]],  -closed => 1, -fillcolor => "#000000", -filled => 1, -linecolor => "#000000");

$zinc->add('curve',$top_group,[[-111, 109.601], [-111, 109.601, 'c'], [-116.6, 119.601, 'c'], [-91.8, 113.601], [-91.8, 113.601, 'c'], [-77.8, 112.401, 'c'], [-75.4, 110.001], [-74.2, 110.801, 'c'], [-65.834, 113.734, 'c'], [-63, 114.401], [-56.2, 116.001, 'c'], [-47.8, 106, 'c'], [-47.8, 106], [-47.8, 106, 'c'], [-43.2, 95.5, 'c'], [-40.4, 95.5], [-37.6, 95.5, 'c'], [-40.8, 97.1, 'c'], [-40.8, 97.1], [-40.8, 97.1, 'c'], [-47.4, 107.201, 'c'], [-47, 108.801], [-47, 108.801, 'c'], [-52.2, 128.801, 'c'], [-68.2, 129.601], [-68.2, 129.601, 'c'], [-84.35, 130.551, 'c'], [-83, 136.401], [-83, 136.401, 'c'], [-74.2, 134.001, 'c'], [-71.8, 136.401], [-71.8, 136.401, 'c'], [-61, 136.001, 'c'], [-69, 142.401], [-75.8, 154.001], [-75.8, 154.001, 'c'], [-75.66, 157.919, 'c'], [-85.8, 154.401], [-95.6, 151.001, 'c'], [-105.9, 138.101, 'c'], [-105.9, 138.101], [-105.9, 138.101, 'c'], [-121.85, 123.551, 'c'], [-111, 109.601]],  -closed => 1, -fillcolor => "#000000", -filled => 1, -linecolor => "#000000");

$zinc->add('curve',$top_group,[[-112.2, 113.601], [-112.2, 113.601, 'c'], [-114.2, 123.201, 'c'], [-77.4, 112.801], [-77.4, 112.801, 'c'], [-73, 112.801, 'c'], [-70.6, 113.601], [-68.2, 114.401, 'c'], [-56.2, 117.201, 'c'], [-54.2, 116.001], [-54.2, 116.001, 'c'], [-61.4, 129.601, 'c'], [-73, 128.001], [-73, 128.001, 'c'], [-86.2, 129.601, 'c'], [-85.8, 134.401], [-85.8, 134.401, 'c'], [-81.8, 141.601, 'c'], [-77, 144.001], [-77, 144.001, 'c'], [-74.2, 146.401, 'c'], [-74.6, 149.601], [-75, 152.801, 'c'], [-77.8, 154.401, 'c'], [-79.8, 155.201], [-81.8, 156.001, 'c'], [-85, 152.801, 'c'], [-86.6, 152.801], [-88.2, 152.801, 'c'], [-96.6, 146.401, 'c'], [-101, 141.601], [-105.4, 136.801, 'c'], [-113.8, 124.801, 'c'], [-113.4, 122.001], [-113, 119.201, 'c'], [-112.2, 113.601, 'c'], [-112.2, 113.601]],  -closed => 1, -fillcolor => "#e59999", -filled => 1, -linecolor => "#e59999");

$zinc->add('curve',$top_group,[[-109, 131.051], [-106.4, 135.001, 'c'], [-103.2, 139.201, 'c'], [-101, 141.601], [-96.6, 146.401, 'c'], [-88.2, 152.801, 'c'], [-86.6, 152.801], [-85, 152.801, 'c'], [-81.8, 156.001, 'c'], [-79.8, 155.201], [-77.8, 154.401, 'c'], [-75, 152.801, 'c'], [-74.6, 149.601], [-74.2, 146.401, 'c'], [-77, 144.001, 'c'], [-77, 144.001], [-80.066, 142.468, 'c'], [-82.806, 138.976, 'c'], [-84.385, 136.653], [-84.385, 136.653, 'c'], [-84.2, 139.201, 'c'], [-89.4, 138.401], [-94.6, 137.601, 'c'], [-99.8, 134.801, 'c'], [-101.4, 131.601], [-103, 128.401, 'c'], [-105.4, 126.001, 'c'], [-103.8, 129.601], [-102.2, 133.201, 'c'], [-99.8, 136.801, 'c'], [-98.2, 137.201], [-96.6, 137.601, 'c'], [-97, 138.801, 'c'], [-99.4, 138.401], [-101.8, 138.001, 'c'], [-104.6, 137.601, 'c'], [-109, 132.401]],  -closed => 1, -fillcolor => "#b26565", -filled => 1, -linecolor => "#b26565");

$zinc->add('curve',$top_group,[[-111.6, 110.001], [-111.6, 110.001, 'c'], [-109.8, 96.4, 'c'], [-108.6, 92.4], [-108.6, 92.4, 'c'], [-109.4, 85.6, 'c'], [-107, 81.4], [-104.6, 77.2, 'c'], [-102.6, 71, 'c'], [-99.6, 65.6], [-96.6, 60.2, 'c'], [-96.4, 56.2, 'c'], [-92.4, 54.6], [-88.4, 53, 'c'], [-82.4, 44.4, 'c'], [-79.6, 43.4], [-76.8, 42.4, 'c'], [-77, 43.2, 'c'], [-77, 43.2], [-77, 43.2, 'c'], [-70.2, 28.4, 'c'], [-56.6, 32.4], [-56.6, 32.4, 'c'], [-72.8, 29.6, 'c'], [-57, 20.2], [-57, 20.2, 'c'], [-61.8, 21.3, 'c'], [-58.5, 14.3], [-56.299, 9.632, 'c'], [-56.8, 16.4, 'c'], [-67.8, 28.2], [-67.8, 28.2, 'c'], [-72.8, 36.8, 'c'], [-78, 39.8], [-83.2, 42.8, 'c'], [-95.2, 49.8, 'c'], [-96.4, 53.6], [-97.6, 57.4, 'c'], [-100.8, 63.2, 'c'], [-102.8, 64.8], [-104.8, 66.4, 'c'], [-107.6, 70.6, 'c'], [-108, 74], [-108, 74, 'c'], [-109.2, 78, 'c'], [-110.6, 79.2], [-112, 80.4, 'c'], [-112.2, 83.6, 'c'], [-112.2, 85.6], [-112.2, 87.6, 'c'], [-114.2, 90.4, 'c'], [-114, 92.8], [-114, 92.8, 'c'], [-113.2, 111.801, 'c'], [-113.6, 113.801], [-111.6, 110.001]],  -closed => 1, -fillcolor => "#992600", -filled => 1, -linecolor => "#992600");

$zinc->add('curve',$top_group,[[-120.2, 114.601], [-120.2, 114.601, 'c'], [-122.2, 113.201, 'c'], [-126.6, 119.201], [-126.6, 119.201, 'c'], [-119.3, 152.201, 'c'], [-119.3, 153.601], [-119.3, 153.601, 'c'], [-118.2, 151.501, 'c'], [-119.5, 144.301], [-120.8, 137.101, 'c'], [-121.7, 124.401, 'c'], [-121.7, 124.401], [-120.2, 114.601]],  -closed => 1, -fillcolor => "#ffffff", -filled => 1, -linecolor => "#ffffff");

$zinc->add('curve',$top_group,[[-98.6, 54], [-98.6, 54, 'c'], [-116.2, 57.2, 'c'], [-115.8, 86.4], [-116.6, 111.201], [-116.6, 111.201, 'c'], [-117.8, 85.6, 'c'], [-119, 84], [-120.2, 82.4, 'c'], [-116.2, 71.2, 'c'], [-119.4, 77.2], [-119.4, 77.2, 'c'], [-133.4, 91.2, 'c'], [-125.4, 112.401], [-125.4, 112.401, 'c'], [-123.9, 115.701, 'c'], [-126.9, 111.101], [-126.9, 111.101, 'c'], [-131.5, 98.5, 'c'], [-130.4, 92.1], [-130.4, 92.1, 'c'], [-130.2, 89.9, 'c'], [-128.3, 87.1], [-128.3, 87.1, 'c'], [-119.7, 75.4, 'c'], [-117, 73.1], [-117, 73.1, 'c'], [-115.2, 58.7, 'c'], [-99.8, 53.5], [-99.8, 53.5, 'c'], [-94.1, 51.2, 'c'], [-98.6, 54]],  -closed => 1, -fillcolor => "#992600", -filled => 1, -linecolor => "#992600");

$zinc->add('curve',$top_group,[[40.8, -12.2], [41.46, -12.554, 'c'], [41.451, -13.524, 'c'], [42.031, -13.697], [43.18, -14.041, 'c'], [43.344, -15.108, 'c'], [43.862, -15.892], [44.735, -17.211, 'c'], [44.928, -18.744, 'c'], [45.51, -20.235], [45.782, -20.935, 'c'], [45.809, -21.89, 'c'], [45.496, -22.55], [44.322, -25.031, 'c'], [43.62, -27.48, 'c'], [42.178, -29.906], [41.91, -30.356, 'c'], [41.648, -31.15, 'c'], [41.447, -31.748], [40.984, -33.132, 'c'], [39.727, -34.123, 'c'], [38.867, -35.443], [38.579, -35.884, 'c'], [39.104, -36.809, 'c'], [38.388, -36.893], [37.491, -36.998, 'c'], [36.042, -37.578, 'c'], [35.809, -36.552], [35.221, -33.965, 'c'], [36.232, -31.442, 'c'], [37.2, -29], [36.418, -28.308, 'c'], [36.752, -27.387, 'c'], [36.904, -26.62], [37.614, -23.014, 'c'], [36.416, -19.662, 'c'], [35.655, -16.188], [35.632, -16.084, 'c'], [35.974, -15.886, 'c'], [35.946, -15.824], [34.724, -13.138, 'c'], [33.272, -10.693, 'c'], [31.453, -8.312], [30.695, -7.32, 'c'], [29.823, -6.404, 'c'], [29.326, -5.341], [28.958, -4.554, 'c'], [28.55, -3.588, 'c'], [28.8, -2.6], [25.365, 0.18, 'c'], [23.115, 4.025, 'c'], [20.504, 7.871], [20.042, 8.551, 'c'], [20.333, 9.76, 'c'], [20.884, 10.029], [21.697, 10.427, 'c'], [22.653, 9.403, 'c'], [23.123, 8.557], [23.512, 7.859, 'c'], [23.865, 7.209, 'c'], [24.356, 6.566], [24.489, 6.391, 'c'], [24.31, 5.972, 'c'], [24.445, 5.851], [27.078, 3.504, 'c'], [28.747, 0.568, 'c'], [31.2, -1.8], [33.15, -2.129, 'c'], [34.687, -3.127, 'c'], [36.435, -4.14], [36.743, -4.319, 'c'], [37.267, -4.07, 'c'], [37.557, -4.265], [39.31, -5.442, 'c'], [39.308, -7.478, 'c'], [39.414, -9.388], [39.464, -10.272, 'c'], [39.66, -11.589, 'c'], [40.8, -12.2]],  -closed => 1, -fillcolor => "#000000", -filled => 1, -linecolor => "#000000");

$zinc->add('curve',$top_group,[[31.959, -16.666], [32.083, -16.743, 'c'], [31.928, -17.166, 'c'], [32.037, -17.382], [32.199, -17.706, 'c'], [32.602, -17.894, 'c'], [32.764, -18.218], [32.873, -18.434, 'c'], [32.71, -18.814, 'c'], [32.846, -18.956], [35.179, -21.403, 'c'], [35.436, -24.427, 'c'], [34.4, -27.4], [35.424, -28.02, 'c'], [35.485, -29.282, 'c'], [35.06, -30.129], [34.207, -31.829, 'c'], [34.014, -33.755, 'c'], [33.039, -35.298], [32.237, -36.567, 'c'], [30.659, -37.811, 'c'], [29.288, -36.508], [28.867, -36.108, 'c'], [28.546, -35.321, 'c'], [28.824, -34.609], [28.888, -34.446, 'c'], [29.173, -34.3, 'c'], [29.146, -34.218], [29.039, -33.894, 'c'], [28.493, -33.67, 'c'], [28.487, -33.398], [28.457, -31.902, 'c'], [27.503, -30.391, 'c'], [28.133, -29.062], [28.905, -27.433, 'c'], [29.724, -25.576, 'c'], [30.4, -23.8], [29.166, -21.684, 'c'], [30.199, -19.235, 'c'], [28.446, -17.358], [28.31, -17.212, 'c'], [28.319, -16.826, 'c'], [28.441, -16.624], [28.733, -16.138, 'c'], [29.139, -15.732, 'c'], [29.625, -15.44], [29.827, -15.319, 'c'], [30.175, -15.317, 'c'], [30.375, -15.441], [30.953, -15.803, 'c'], [31.351, -16.29, 'c'], [31.959, -16.666]],  -closed => 1, -fillcolor => "#000000", -filled => 1, -linecolor => "#000000");

$zinc->add('curve',$top_group,[[94.771, -26.977], [96.16, -25.185, 'c'], [96.45, -22.39, 'c'], [94.401, -21], [94.951, -17.691, 'c'], [98.302, -19.67, 'c'], [100.401, -20.2], [100.292, -20.588, 'c'], [100.519, -20.932, 'c'], [100.802, -20.937], [101.859, -20.952, 'c'], [102.539, -21.984, 'c'], [103.601, -21.8], [104.035, -23.357, 'c'], [105.673, -24.059, 'c'], [106.317, -25.439], [108.043, -29.134, 'c'], [107.452, -33.407, 'c'], [104.868, -36.653], [104.666, -36.907, 'c'], [104.883, -37.424, 'c'], [104.759, -37.786], [104.003, -39.997, 'c'], [101.935, -40.312, 'c'], [100.001, -41], [98.824, -44.875, 'c'], [98.163, -48.906, 'c'], [96.401, -52.6], [94.787, -52.85, 'c'], [94.089, -54.589, 'c'], [92.752, -55.309], [91.419, -56.028, 'c'], [90.851, -54.449, 'c'], [90.892, -53.403], [90.899, -53.198, 'c'], [91.351, -52.974, 'c'], [91.181, -52.609], [91.105, -52.445, 'c'], [90.845, -52.334, 'c'], [90.845, -52.2], [90.846, -52.065, 'c'], [91.067, -51.934, 'c'], [91.201, -51.8], [90.283, -50.98, 'c'], [88.86, -50.503, 'c'], [88.565, -49.358], [87.611, -45.648, 'c'], [90.184, -42.523, 'c'], [91.852, -39.322], [92.443, -38.187, 'c'], [91.707, -36.916, 'c'], [90.947, -35.708], [90.509, -35.013, 'c'], [90.617, -33.886, 'c'], [90.893, -33.03], [91.645, -30.699, 'c'], [93.236, -28.96, 'c'], [94.771, -26.977]],  -closed => 1, -fillcolor => "#000000", -filled => 1, -linecolor => "#000000");

$zinc->add('curve',$top_group,[[57.611, -8.591], [56.124, -6.74, 'c'], [52.712, -4.171, 'c'], [55.629, -2.243], [55.823, -2.114, 'c'], [56.193, -2.11, 'c'], [56.366, -2.244], [58.387, -3.809, 'c'], [60.39, -4.712, 'c'], [62.826, -5.294], [62.95, -5.323, 'c'], [63.224, -4.856, 'c'], [63.593, -5.017], [65.206, -5.72, 'c'], [67.216, -5.662, 'c'], [68.4, -7], [72.167, -6.776, 'c'], [75.732, -7.892, 'c'], [79.123, -9.2], [80.284, -9.648, 'c'], [81.554, -10.207, 'c'], [82.755, -10.709], [84.131, -11.285, 'c'], [85.335, -12.213, 'c'], [86.447, -13.354], [86.58, -13.49, 'c'], [86.934, -13.4, 'c'], [87.201, -13.4], [87.161, -14.263, 'c'], [88.123, -14.39, 'c'], [88.37, -15.012], [88.462, -15.244, 'c'], [88.312, -15.64, 'c'], [88.445, -15.742], [90.583, -17.372, 'c'], [91.503, -19.39, 'c'], [90.334, -21.767], [90.049, -22.345, 'c'], [89.8, -22.963, 'c'], [89.234, -23.439], [88.149, -24.35, 'c'], [87.047, -23.496, 'c'], [86, -23.8], [85.841, -23.172, 'c'], [85.112, -23.344, 'c'], [84.726, -23.146], [83.867, -22.707, 'c'], [82.534, -23.292, 'c'], [81.675, -22.854], [80.313, -22.159, 'c'], [79.072, -21.99, 'c'], [77.65, -21.613], [77.338, -21.531, 'c'], [76.56, -21.627, 'c'], [76.4, -21], [76.266, -21.134, 'c'], [76.118, -21.368, 'c'], [76.012, -21.346], [74.104, -20.95, 'c'], [72.844, -20.736, 'c'], [71.543, -19.044], [71.44, -18.911, 'c'], [70.998, -19.09, 'c'], [70.839, -18.955], [69.882, -18.147, 'c'], [69.477, -16.913, 'c'], [68.376, -16.241], [68.175, -16.118, 'c'], [67.823, -16.286, 'c'], [67.629, -16.157], [66.983, -15.726, 'c'], [66.616, -15.085, 'c'], [65.974, -14.638], [65.645, -14.409, 'c'], [65.245, -14.734, 'c'], [65.277, -14.99], [65.522, -16.937, 'c'], [66.175, -18.724, 'c'], [65.6, -20.6], [67.677, -23.12, 'c'], [70.194, -25.069, 'c'], [72, -27.8], [72.015, -29.966, 'c'], [72.707, -32.112, 'c'], [72.594, -34.189], [72.584, -34.382, 'c'], [72.296, -35.115, 'c'], [72.17, -35.462], [71.858, -36.316, 'c'], [72.764, -37.382, 'c'], [71.92, -38.106], [70.516, -39.309, 'c'], [69.224, -38.433, 'c'], [68.4, -37], [66.562, -36.61, 'c'], [64.496, -35.917, 'c'], [62.918, -37.151], [61.911, -37.938, 'c'], [61.333, -38.844, 'c'], [60.534, -39.9], [59.549, -41.202, 'c'], [59.884, -42.638, 'c'], [59.954, -44.202], [59.96, -44.33, 'c'], [59.645, -44.466, 'c'], [59.645, -44.6], [59.646, -44.735, 'c'], [59.866, -44.866, 'c'], [60, -45], [59.294, -45.626, 'c'], [59.019, -46.684, 'c'], [58, -47], [58.305, -48.092, 'c'], [57.629, -48.976, 'c'], [56.758, -49.278], [54.763, -49.969, 'c'], [53.086, -48.057, 'c'], [51.194, -47.984], [50.68, -47.965, 'c'], [50.213, -49.003, 'c'], [49.564, -49.328], [49.132, -49.544, 'c'], [48.428, -49.577, 'c'], [48.066, -49.311], [47.378, -48.807, 'c'], [46.789, -48.693, 'c'], [46.031, -48.488], [44.414, -48.052, 'c'], [43.136, -46.958, 'c'], [41.656, -46.103], [40.171, -45.246, 'c'], [39.216, -43.809, 'c'], [38.136, -42.489], [37.195, -41.337, 'c'], [37.059, -38.923, 'c'], [38.479, -38.423], [40.322, -37.773, 'c'], [41.626, -40.476, 'c'], [43.592, -40.15], [43.904, -40.099, 'c'], [44.11, -39.788, 'c'], [44, -39.4], [44.389, -39.291, 'c'], [44.607, -39.52, 'c'], [44.8, -39.8], [45.658, -38.781, 'c'], [46.822, -38.444, 'c'], [47.76, -37.571], [48.73, -36.667, 'c'], [50.476, -37.085, 'c'], [51.491, -36.088], [53.02, -34.586, 'c'], [52.461, -31.905, 'c'], [54.4, -30.6], [53.814, -29.287, 'c'], [53.207, -28.01, 'c'], [52.872, -26.583], [52.59, -25.377, 'c'], [53.584, -24.18, 'c'], [54.795, -24.271], [56.053, -24.365, 'c'], [56.315, -25.124, 'c'], [56.8, -26.2], [57.067, -25.933, 'c'], [57.536, -25.636, 'c'], [57.495, -25.42], [57.038, -23.033, 'c'], [56.011, -21.04, 'c'], [55.553, -18.609], [55.494, -18.292, 'c'], [55.189, -18.09, 'c'], [54.8, -18.2], [54.332, -14.051, 'c'], [50.28, -11.657, 'c'], [47.735, -8.492], [47.332, -7.99, 'c'], [47.328, -6.741, 'c'], [47.737, -6.338], [49.14, -4.951, 'c'], [51.1, -6.497, 'c'], [52.8, -7], [53.013, -8.206, 'c'], [53.872, -9.148, 'c'], [55.204, -9.092], [55.46, -9.082, 'c'], [55.695, -9.624, 'c'], [56.019, -9.754], [56.367, -9.892, 'c'], [56.869, -9.668, 'c'], [57.155, -9.866], [58.884, -11.061, 'c'], [60.292, -12.167, 'c'], [62.03, -13.356], [62.222, -13.487, 'c'], [62.566, -13.328, 'c'], [62.782, -13.436], [63.107, -13.598, 'c'], [63.294, -13.985, 'c'], [63.617, -14.17], [63.965, -14.37, 'c'], [64.207, -14.08, 'c'], [64.4, -13.8], [63.754, -13.451, 'c'], [63.75, -12.494, 'c'], [63.168, -12.292], [62.393, -12.024, 'c'], [61.832, -11.511, 'c'], [61.158, -11.064], [60.866, -10.871, 'c'], [60.207, -11.119, 'c'], [60.103, -10.94], [59.505, -9.912, 'c'], [58.321, -9.474, 'c'], [57.611, -8.591]],  -closed => 1, -fillcolor => "#000000", -filled => 1, -linecolor => "#000000");

$zinc->add('curve',$top_group,[[2.2, -58], [2.2, -58, 'c'], [-7.038, -60.872, 'c'], [-18.2, -35.2], [-18.2, -35.2, 'c'], [-20.6, -30, 'c'], [-23, -28], [-25.4, -26, 'c'], [-36.6, -22.4, 'c'], [-38.6, -18.4], [-49, -2.4], [-49, -2.4, 'c'], [-34.2, -18.4, 'c'], [-31, -20.8], [-31, -20.8, 'c'], [-23, -29.2, 'c'], [-26.2, -22.4], [-26.2, -22.4, 'c'], [-40.2, -11.6, 'c'], [-39, -2.4], [-39, -2.4, 'c'], [-44.6, 12, 'c'], [-45.4, 14], [-45.4, 14, 'c'], [-29.4, -18, 'c'], [-27, -19.2], [-24.6, -20.4, 'c'], [-23.4, -20.4, 'c'], [-24.6, -16.8], [-25.8, -13.2, 'c'], [-26.2, 3.2, 'c'], [-29, 5.2], [-29, 5.2, 'c'], [-21, -15.2, 'c'], [-21.8, -18.4], [-21.8, -18.4, 'c'], [-18.6, -22, 'c'], [-16.2, -16.8], [-17.4, -0.8], [-13, 11.2], [-13, 11.2, 'c'], [-15.4, 0, 'c'], [-13.8, -15.6], [-13.8, -15.6, 'c'], [-15.8, -26, 'c'], [-11.8, -20.4], [-7.8, -14.8, 'c'], [1.8, -8.8, 'c'], [1.8, -4], [1.8, -4, 'c'], [-3.4, -21.6, 'c'], [-12.6, -26.4], [-16.6, -20.4], [-17.8, -22.4], [-17.8, -22.4, 'c'], [-21.4, -23.2, 'c'], [-17, -30], [-12.6, -36.8, 'c'], [-13, -37.6, 'c'], [-13, -37.6], [-13, -37.6, 'c'], [-6.6, -30.4, 'c'], [-5, -30.4], [-5, -30.4, 'c'], [8.2, -38, 'c'], [9.4, -13.6], [9.4, -13.6, 'c'], [16.2, -28, 'c'], [7, -34.8], [7, -34.8, 'c'], [-7.8, -36.8, 'c'], [-6.6, -42], [0.6, -54.4], [4.2, -59.6, 'c'], [2.6, -56.8, 'c'], [2.6, -56.8]],  -closed => 1, -fillcolor => "#000000", -filled => 1, -linecolor => "#000000");

$zinc->add('curve',$top_group,[[-17.8, -41.6], [-17.8, -41.6, 'c'], [-30.6, -41.6, 'c'], [-33.8, -36.4], [-41, -26.8], [-41, -26.8, 'c'], [-23.8, -36.8, 'c'], [-19.8, -38], [-15.8, -39.2, 'c'], [-17.8, -41.6, 'c'], [-17.8, -41.6]],  -closed => 1, -fillcolor => "#000000", -filled => 1, -linecolor => "#000000");

$zinc->add('curve',$top_group,[[-57.8, -35.2], [-57.8, -35.2, 'c'], [-59.8, -34, 'c'], [-60.2, -31.2], [-60.6, -28.4, 'c'], [-63, -28, 'c'], [-62.2, -25.2], [-61.4, -22.4, 'c'], [-59.4, -20, 'c'], [-59.4, -24], [-59.4, -28, 'c'], [-57.8, -30, 'c'], [-57, -31.2], [-56.2, -32.4, 'c'], [-54.6, -36.8, 'c'], [-57.8, -35.2]],  -closed => 1, -fillcolor => "#000000", -filled => 1, -linecolor => "#000000");

$zinc->add('curve',$top_group,[[-66.6, 26], [-66.6, 26, 'c'], [-75, 22, 'c'], [-78.2, 18.4], [-81.4, 14.8, 'c'], [-80.948, 19.966, 'c'], [-85.8, 19.6], [-91.647, 19.159, 'c'], [-90.6, 3.2, 'c'], [-90.6, 3.2], [-94.6, 10.8], [-94.6, 10.8, 'c'], [-95.8, 25.2, 'c'], [-87.8, 22.8], [-83.893, 21.628, 'c'], [-82.6, 23.2, 'c'], [-84.2, 24], [-85.8, 24.8, 'c'], [-78.6, 25.2, 'c'], [-81.4, 26.8], [-84.2, 28.4, 'c'], [-69.8, 23.2, 'c'], [-72.2, 33.6], [-66.6, 26]],  -closed => 1, -fillcolor => "#000000", -filled => 1, -linecolor => "#000000");

$zinc->add('curve',$top_group,[[-79.2, 40.4], [-79.2, 40.4, 'c'], [-94.6, 44.8, 'c'], [-98.2, 35.2], [-98.2, 35.2, 'c'], [-103, 37.6, 'c'], [-100.8, 40.6], [-98.6, 43.6, 'c'], [-97.4, 44, 'c'], [-97.4, 44], [-97.4, 44, 'c'], [-92, 45.2, 'c'], [-92.6, 46], [-93.2, 46.8, 'c'], [-95.6, 50.2, 'c'], [-95.6, 50.2], [-95.6, 50.2, 'c'], [-85.4, 44.2, 'c'], [-79.2, 40.4]],  -closed => 1, -fillcolor => "#000000", -filled => 1, -linecolor => "#000000");

$zinc->add('curve',$top_group,[[149.201, 118.601], [148.774, 120.735, 'c'], [147.103, 121.536, 'c'], [145.201, 122.201], [143.284, 121.243, 'c'], [140.686, 118.137, 'c'], [138.801, 120.201], [138.327, 119.721, 'c'], [137.548, 119.661, 'c'], [137.204, 118.999], [136.739, 118.101, 'c'], [137.011, 117.055, 'c'], [136.669, 116.257], [136.124, 114.985, 'c'], [135.415, 113.619, 'c'], [135.601, 112.201], [137.407, 111.489, 'c'], [138.002, 109.583, 'c'], [137.528, 107.82], [137.459, 107.563, 'c'], [137.03, 107.366, 'c'], [137.23, 107.017], [137.416, 106.694, 'c'], [137.734, 106.467, 'c'], [138.001, 106.2], [137.866, 106.335, 'c'], [137.721, 106.568, 'c'], [137.61, 106.548], [137, 106.442, 'c'], [137.124, 105.805, 'c'], [137.254, 105.418], [137.839, 103.672, 'c'], [139.853, 103.408, 'c'], [141.201, 104.6], [141.457, 104.035, 'c'], [141.966, 104.229, 'c'], [142.401, 104.2], [142.351, 103.621, 'c'], [142.759, 103.094, 'c'], [142.957, 102.674], [143.475, 101.576, 'c'], [145.104, 102.682, 'c'], [145.901, 102.07], [146.977, 101.245, 'c'], [148.04, 100.546, 'c'], [149.118, 101.149], [150.927, 102.162, 'c'], [152.636, 103.374, 'c'], [153.835, 105.115], [154.41, 105.949, 'c'], [154.65, 107.23, 'c'], [154.592, 108.188], [154.554, 108.835, 'c'], [153.173, 108.483, 'c'], [152.83, 109.412], [152.185, 111.16, 'c'], [154.016, 111.679, 'c'], [154.772, 113.017], [154.97, 113.366, 'c'], [154.706, 113.67, 'c'], [154.391, 113.768], [153.98, 113.896, 'c'], [153.196, 113.707, 'c'], [153.334, 114.16], [154.306, 117.353, 'c'], [151.55, 118.031, 'c'], [149.201, 118.601]],  -closed => 1, -fillcolor => "#ffffff", -filled => 1, -linecolor => "#ffffff");

$zinc->add('curve',$top_group,[[139.6, 138.201], [139.593, 136.463, 'c'], [137.992, 134.707, 'c'], [139.201, 133.001], [139.336, 133.135, 'c'], [139.467, 133.356, 'c'], [139.601, 133.356], [139.736, 133.356, 'c'], [139.867, 133.135, 'c'], [140.001, 133.001], [141.496, 135.217, 'c'], [145.148, 136.145, 'c'], [145.006, 138.991], [144.984, 139.438, 'c'], [143.897, 140.356, 'c'], [144.801, 141.001], [142.988, 142.349, 'c'], [142.933, 144.719, 'c'], [142.001, 146.601], [140.763, 146.315, 'c'], [139.551, 145.952, 'c'], [138.401, 145.401], [138.753, 143.915, 'c'], [138.636, 142.231, 'c'], [139.456, 140.911], [139.89, 140.213, 'c'], [139.603, 139.134, 'c'], [139.6, 138.201]],  -closed => 1, -fillcolor => "#ffffff", -filled => 1, -linecolor => "#ffffff");

$zinc->add('curve',$top_group,[[-26.6, 129.201], [-26.6, 129.201, 'c'], [-43.458, 139.337, 'c'], [-29.4, 124.001], [-20.6, 114.401, 'c'], [-10.6, 108.801, 'c'], [-10.6, 108.801], [-10.6, 108.801, 'c'], [-0.2, 104.4, 'c'], [3.4, 103.2], [7, 102, 'c'], [22.2, 96.8, 'c'], [25.4, 96.4], [28.6, 96, 'c'], [38.2, 92, 'c'], [45, 96], [51.8, 100, 'c'], [59.8, 104.4, 'c'], [59.8, 104.4], [59.8, 104.4, 'c'], [43.4, 96, 'c'], [39.8, 98.4], [36.2, 100.8, 'c'], [29, 100.4, 'c'], [23, 103.6], [23, 103.6, 'c'], [8.2, 108.001, 'c'], [5, 110.001], [1.8, 112.001, 'c'], [-8.6, 123.601, 'c'], [-10.2, 122.801], [-11.8, 122.001, 'c'], [-9.8, 121.601, 'c'], [-8.6, 118.801], [-7.4, 116.001, 'c'], [-9.4, 114.401, 'c'], [-17.4, 120.801], [-25.4, 127.201, 'c'], [-26.6, 129.201, 'c'], [-26.6, 129.201]],  -closed => 1, -fillcolor => "#cccccc", -filled => 1, -linecolor => "#cccccc");

$zinc->add('curve',$top_group,[[-19.195, 123.234], [-19.195, 123.234, 'c'], [-17.785, 110.194, 'c'], [-9.307, 111.859], [-9.307, 111.859, 'c'], [-1.081, 107.689, 'c'], [1.641, 105.721], [1.641, 105.721, 'c'], [9.78, 104.019, 'c'], [11.09, 103.402], [29.569, 94.702, 'c'], [44.288, 99.221, 'c'], [44.835, 98.101], [45.381, 96.982, 'c'], [65.006, 104.099, 'c'], [68.615, 108.185], [69.006, 108.628, 'c'], [58.384, 102.588, 'c'], [48.686, 100.697], [40.413, 99.083, 'c'], [18.811, 100.944, 'c'], [7.905, 106.48], [4.932, 107.989, 'c'], [-4.013, 113.773, 'c'], [-6.544, 113.662], [-9.075, 113.55, 'c'], [-19.195, 123.234, 'c'], [-19.195, 123.234]],  -closed => 1, -fillcolor => "#000000", -filled => 1, -linecolor => "#000000");

$zinc->add('curve',$top_group,[[-23, 148.801], [-23, 148.801, 'c'], [-38.2, 146.401, 'c'], [-21.4, 144.801], [-21.4, 144.801, 'c'], [-3.4, 142.801, 'c'], [0.6, 137.601], [0.6, 137.601, 'c'], [14.2, 128.401, 'c'], [17, 128.001], [19.8, 127.601, 'c'], [49.8, 120.401, 'c'], [50.2, 118.001], [50.6, 115.601, 'c'], [56.2, 115.601, 'c'], [57.8, 116.401], [59.4, 117.201, 'c'], [58.6, 118.401, 'c'], [55.8, 119.201], [53, 120.001, 'c'], [21.8, 136.401, 'c'], [15.4, 137.601], [9, 138.801, 'c'], [-2.6, 146.401, 'c'], [-7.4, 147.601], [-12.2, 148.801, 'c'], [-23, 148.801, 'c'], [-23, 148.801]],  -closed => 1, -fillcolor => "#cccccc", -filled => 1, -linecolor => "#cccccc");

$zinc->add('curve',$top_group,[[-3.48, 141.403], [-3.48, 141.403, 'c'], [-12.062, 140.574, 'c'], [-3.461, 139.755], [-3.461, 139.755, 'c'], [5.355, 136.331, 'c'], [7.403, 133.668], [7.403, 133.668, 'c'], [14.367, 128.957, 'c'], [15.8, 128.753], [17.234, 128.548, 'c'], [31.194, 124.861, 'c'], [31.399, 123.633], [31.604, 122.404, 'c'], [65.67, 109.823, 'c'], [70.09, 113.013], [73.001, 115.114, 'c'], [63.1, 113.437, 'c'], [53.466, 117.847], [52.111, 118.467, 'c'], [18.258, 133.054, 'c'], [14.981, 133.668], [11.704, 134.283, 'c'], [5.765, 138.174, 'c'], [3.307, 138.788], [0.85, 139.403, 'c'], [-3.48, 141.403, 'c'], [-3.48, 141.403]],  -closed => 1, -fillcolor => "#000000", -filled => 1, -linecolor => "#000000");

$zinc->add('curve',$top_group,[[-11.4, 143.601], [-11.4, 143.601, 'c'], [-6.2, 143.201, 'c'], [-7.4, 144.801], [-8.6, 146.401, 'c'], [-11, 145.601, 'c'], [-11, 145.601], [-11.4, 143.601]],  -closed => 1, -fillcolor => "#000000", -filled => 1, -linecolor => "#000000");

$zinc->add('curve',$top_group,[[-18.6, 145.201], [-18.6, 145.201, 'c'], [-13.4, 144.801, 'c'], [-14.6, 146.401], [-15.8, 148.001, 'c'], [-18.2, 147.201, 'c'], [-18.2, 147.201], [-18.6, 145.201]],  -closed => 1, -fillcolor => "#000000", -filled => 1, -linecolor => "#000000");

$zinc->add('curve',$top_group,[[-29, 146.801], [-29, 146.801, 'c'], [-23.8, 146.401, 'c'], [-25, 148.001], [-26.2, 149.601, 'c'], [-28.6, 148.801, 'c'], [-28.6, 148.801], [-29, 146.801]],  -closed => 1, -fillcolor => "#000000", -filled => 1, -linecolor => "#000000");

$zinc->add('curve',$top_group,[[-36.6, 147.601], [-36.6, 147.601, 'c'], [-31.4, 147.201, 'c'], [-32.6, 148.801], [-33.8, 150.401, 'c'], [-36.2, 149.601, 'c'], [-36.2, 149.601], [-36.6, 147.601]],  -closed => 1, -fillcolor => "#000000", -filled => 1, -linecolor => "#000000");

$zinc->add('curve',$top_group,[[1.8, 108.001], [1.8, 108.001, 'c'], [6.2, 108.001, 'c'], [5, 109.601], [3.8, 111.201, 'c'], [0.6, 110.801, 'c'], [0.6, 110.801], [1.8, 108.001]],  -closed => 1, -fillcolor => "#000000", -filled => 1, -linecolor => "#000000");

$zinc->add('curve',$top_group,[[-8.2, 113.601], [-8.2, 113.601, 'c'], [-1.694, 111.46, 'c'], [-4.2, 114.801], [-5.4, 116.401, 'c'], [-7.8, 115.601, 'c'], [-7.8, 115.601], [-8.2, 113.601]],  -closed => 1, -fillcolor => "#000000", -filled => 1, -linecolor => "#000000");

$zinc->add('curve',$top_group,[[-19.4, 118.401], [-19.4, 118.401, 'c'], [-14.2, 118.001, 'c'], [-15.4, 119.601], [-16.6, 121.201, 'c'], [-19, 120.401, 'c'], [-19, 120.401], [-19.4, 118.401]],  -closed => 1, -fillcolor => "#000000", -filled => 1, -linecolor => "#000000");

$zinc->add('curve',$top_group,[[-27, 124.401], [-27, 124.401, 'c'], [-21.8, 124.001, 'c'], [-23, 125.601], [-24.2, 127.201, 'c'], [-26.6, 126.401, 'c'], [-26.6, 126.401], [-27, 124.401]],  -closed => 1, -fillcolor => "#000000", -filled => 1, -linecolor => "#000000");

$zinc->add('curve',$top_group,[[-33.8, 129.201], [-33.8, 129.201, 'c'], [-28.6, 128.801, 'c'], [-29.8, 130.401], [-31, 132.001, 'c'], [-33.4, 131.201, 'c'], [-33.4, 131.201], [-33.8, 129.201]],  -closed => 1, -fillcolor => "#000000", -filled => 1, -linecolor => "#000000");

$zinc->add('curve',$top_group,[[5.282, 135.598], [5.282, 135.598, 'c'], [12.203, 135.066, 'c'], [10.606, 137.195], [9.009, 139.325, 'c'], [5.814, 138.26, 'c'], [5.814, 138.26], [5.282, 135.598]],  -closed => 1, -fillcolor => "#000000", -filled => 1, -linecolor => "#000000");

$zinc->add('curve',$top_group,[[15.682, 130.798], [15.682, 130.798, 'c'], [22.603, 130.266, 'c'], [21.006, 132.395], [19.409, 134.525, 'c'], [16.214, 133.46, 'c'], [16.214, 133.46], [15.682, 130.798]],  -closed => 1, -fillcolor => "#000000", -filled => 1, -linecolor => "#000000");

$zinc->add('curve',$top_group,[[26.482, 126.398], [26.482, 126.398, 'c'], [33.403, 125.866, 'c'], [31.806, 127.995], [30.209, 130.125, 'c'], [27.014, 129.06, 'c'], [27.014, 129.06], [26.482, 126.398]],  -closed => 1, -fillcolor => "#000000", -filled => 1, -linecolor => "#000000");

$zinc->add('curve',$top_group,[[36.882, 121.598], [36.882, 121.598, 'c'], [43.803, 121.066, 'c'], [42.206, 123.195], [40.609, 125.325, 'c'], [37.414, 124.26, 'c'], [37.414, 124.26], [36.882, 121.598]],  -closed => 1, -fillcolor => "#000000", -filled => 1, -linecolor => "#000000");

$zinc->add('curve',$top_group,[[9.282, 103.598], [9.282, 103.598, 'c'], [16.203, 103.066, 'c'], [14.606, 105.195], [13.009, 107.325, 'c'], [9.014, 107.06, 'c'], [9.014, 107.06], [9.282, 103.598]],  -closed => 1, -fillcolor => "#000000", -filled => 1, -linecolor => "#000000");

$zinc->add('curve',$top_group,[[19.282, 100.398], [19.282, 100.398, 'c'], [26.203, 99.866, 'c'], [24.606, 101.995], [23.009, 104.125, 'c'], [18.614, 103.86, 'c'], [18.614, 103.86], [19.282, 100.398]],  -closed => 1, -fillcolor => "#000000", -filled => 1, -linecolor => "#000000");

$zinc->add('curve',$top_group,[[-3.4, 140.401], [-3.4, 140.401, 'c'], [1.8, 140.001, 'c'], [0.6, 141.601], [-0.6, 143.201, 'c'], [-3, 142.401, 'c'], [-3, 142.401], [-3.4, 140.401]],  -closed => 1, -fillcolor => "#000000", -filled => 1, -linecolor => "#000000");

$zinc->add('curve',$top_group,[[-76.6, 41.2], [-76.6, 41.2, 'c'], [-81, 50, 'c'], [-81.4, 53.2], [-81.4, 53.2, 'c'], [-80.6, 44.4, 'c'], [-79.4, 42.4], [-78.2, 40.4, 'c'], [-76.6, 41.2, 'c'], [-76.6, 41.2]],  -closed => 1, -fillcolor => "#992600", -filled => 1, -linecolor => "#992600");

$zinc->add('curve',$top_group,[[-95, 55.2], [-95, 55.2, 'c'], [-98.2, 69.6, 'c'], [-97.8, 72.4], [-97.8, 72.4, 'c'], [-99, 60.8, 'c'], [-98.6, 59.6], [-98.2, 58.4, 'c'], [-95, 55.2, 'c'], [-95, 55.2]],  -closed => 1, -fillcolor => "#992600", -filled => 1, -linecolor => "#992600");

$zinc->add('curve',$top_group,[[-74.2, -19.4], [-74.4, -16.2], [-76.6, -16], [-76.6, -16, 'c'], [-62.4, -3.4, 'c'], [-61.8, 4.2], [-61.8, 4.2, 'c'], [-61, -4, 'c'], [-74.2, -19.4]],  -closed => 1, -fillcolor => "#cccccc", -filled => 1, -linecolor => "#cccccc");

$zinc->add('curve',$top_group,[[-70.216, -18.135], [-70.647, -18.551, 'c'], [-70.428, -19.296, 'c'], [-70.836, -19.556], [-71.645, -20.072, 'c'], [-69.538, -20.129, 'c'], [-69.766, -20.845], [-70.149, -22.051, 'c'], [-69.962, -22.072, 'c'], [-70.084, -23.348], [-70.141, -23.946, 'c'], [-69.553, -25.486, 'c'], [-69.168, -25.926], [-67.722, -27.578, 'c'], [-69.046, -30.51, 'c'], [-67.406, -32.061], [-67.102, -32.35, 'c'], [-66.726, -32.902, 'c'], [-66.441, -33.32], [-65.782, -34.283, 'c'], [-64.598, -34.771, 'c'], [-63.648, -35.599], [-63.33, -35.875, 'c'], [-63.531, -36.702, 'c'], [-62.962, -36.61], [-62.248, -36.495, 'c'], [-61.007, -36.625, 'c'], [-61.052, -35.784], [-61.165, -33.664, 'c'], [-62.494, -31.944, 'c'], [-63.774, -30.276], [-63.323, -29.572, 'c'], [-63.781, -28.937, 'c'], [-64.065, -28.38], [-65.4, -25.76, 'c'], [-65.211, -22.919, 'c'], [-65.385, -20.079], [-65.39, -19.994, 'c'], [-65.697, -19.916, 'c'], [-65.689, -19.863], [-65.336, -17.528, 'c'], [-64.752, -15.329, 'c'], [-63.873, -13.1], [-63.507, -12.17, 'c'], [-63.036, -11.275, 'c'], [-62.886, -10.348], [-62.775, -9.662, 'c'], [-62.672, -8.829, 'c'], [-63.08, -8.124], [-61.045, -5.234, 'c'], [-62.354, -2.583, 'c'], [-61.185, 0.948], [-60.978, 1.573, 'c'], [-59.286, 3.487, 'c'], [-59.749, 3.326], [-62.262, 2.455, 'c'], [-62.374, 2.057, 'c'], [-62.551, 1.304], [-62.697, 0.681, 'c'], [-63.027, -0.696, 'c'], [-63.264, -1.298], [-63.328, -1.462, 'c'], [-63.499, -3.346, 'c'], [-63.577, -3.468], [-65.09, -5.85, 'c'], [-63.732, -5.674, 'c'], [-65.102, -8.032], [-66.53, -8.712, 'c'], [-67.496, -9.816, 'c'], [-68.619, -10.978], [-68.817, -11.182, 'c'], [-67.674, -11.906, 'c'], [-67.855, -12.119], [-68.947, -13.408, 'c'], [-70.1, -14.175, 'c'], [-69.764, -15.668], [-69.609, -16.358, 'c'], [-69.472, -17.415, 'c'], [-70.216, -18.135]],  -closed => 1, -fillcolor => "#000000", -filled => 1, -linecolor => "#000000");

$zinc->add('curve',$top_group,[[-73.8, -16.4], [-73.8, -16.4, 'c'], [-73.4, -9.6, 'c'], [-71, -8], [-68.6, -6.4, 'c'], [-69.8, -7.2, 'c'], [-73, -8.4], [-76.2, -9.6, 'c'], [-75, -10.4, 'c'], [-75, -10.4], [-75, -10.4, 'c'], [-77.8, -10, 'c'], [-75.4, -8], [-73, -6, 'c'], [-69.4, -3.6, 'c'], [-71, -3.6], [-72.6, -3.6, 'c'], [-80.2, -7.6, 'c'], [-80.2, -10.4], [-80.2, -13.2, 'c'], [-81.2, -17.3, 'c'], [-81.2, -17.3], [-81.2, -17.3, 'c'], [-80.1, -18.1, 'c'], [-75.3, -18], [-75.3, -18, 'c'], [-73.9, -17.3, 'c'], [-73.8, -16.4]],  -closed => 1, -fillcolor => "#000000", -filled => 1, -linecolor => "#000000");

$zinc->add('curve',$top_group,[[-74.6, 2.2], [-74.6, 2.2, 'c'], [-83.12, -0.591, 'c'], [-101.6, 2.8], [-101.6, 2.8, 'c'], [-92.569, 0.722, 'c'], [-73.8, 3], [-63.5, 4.25, 'c'], [-74.6, 2.2, 'c'], [-74.6, 2.2]],  -closed => 1, -linecolor => "#000000", -fillcolor => "#ffffff", -filled => 1, -linewidth => 0.1);

$zinc->add('curve',$top_group,[[-72.502, 2.129], [-72.502, 2.129, 'c'], [-80.748, -1.389, 'c'], [-99.453, 0.392], [-99.453, 0.392, 'c'], [-90.275, -0.897, 'c'], [-71.774, 2.995], [-61.62, 5.131, 'c'], [-72.502, 2.129, 'c'], [-72.502, 2.129]],  -closed => 1, -linecolor => "#000000", -fillcolor => "#ffffff", -filled => 1, -linewidth => 0.1);

$zinc->add('curve',$top_group,[[-70.714, 2.222], [-70.714, 2.222, 'c'], [-78.676, -1.899, 'c'], [-97.461, -1.514], [-97.461, -1.514, 'c'], [-88.213, -2.118, 'c'], [-70.052, 3.14], [-60.086, 6.025, 'c'], [-70.714, 2.222, 'c'], [-70.714, 2.222]],  -closed => 1, -linecolor => "#000000", -fillcolor => "#ffffff", -filled => 1, -linewidth => 0.1);

$zinc->add('curve',$top_group,[[-69.444, 2.445], [-69.444, 2.445, 'c'], [-76.268, -1.862, 'c'], [-93.142, -2.96], [-93.142, -2.96, 'c'], [-84.803, -2.79, 'c'], [-68.922, 3.319], [-60.206, 6.672, 'c'], [-69.444, 2.445, 'c'], [-69.444, 2.445]],  -closed => 1, -linecolor => "#000000", -fillcolor => "#ffffff", -filled => 1, -linewidth => 0.1);

$zinc->add('curve',$top_group,[[45.84, 12.961], [45.84, 12.961, 'c'], [44.91, 13.605, 'c'], [45.124, 12.424], [45.339, 11.243, 'c'], [73.547, -1.927, 'c'], [77.161, -1.677], [77.161, -1.677, 'c'], [46.913, 11.529, 'c'], [45.84, 12.961]],  -closed => 1, -linecolor => "#000000", -fillcolor => "#ffffff", -filled => 1, -linewidth => 0.1);

$zinc->add('curve',$top_group,[[42.446, 13.6], [42.446, 13.6, 'c'], [41.57, 14.315, 'c'], [41.691, 13.121], [41.812, 11.927, 'c'], [68.899, -3.418, 'c'], [72.521, -3.452], [72.521, -3.452, 'c'], [43.404, 12.089, 'c'], [42.446, 13.6]],  -closed => 1, -linecolor => "#000000", -fillcolor => "#ffffff", -filled => 1, -linewidth => 0.1);

$zinc->add('curve',$top_group,[[39.16, 14.975], [39.16, 14.975, 'c'], [38.332, 15.747, 'c'], [38.374, 14.547], [38.416, 13.348, 'c'], [58.233, -2.149, 'c'], [68.045, -4.023], [68.045, -4.023, 'c'], [50.015, 4.104, 'c'], [39.16, 14.975]],  -closed => 1, -linecolor => "#000000", -fillcolor => "#ffffff", -filled => 1, -linewidth => 0.1);

$zinc->add('curve',$top_group,[[36.284, 16.838], [36.284, 16.838, 'c'], [35.539, 17.532, 'c'], [35.577, 16.453], [35.615, 15.373, 'c'], [53.449, 1.426, 'c'], [62.28, -0.26], [62.28, -0.26, 'c'], [46.054, 7.054, 'c'], [36.284, 16.838]],  -closed => 1, -linecolor => "#000000", -fillcolor => "#ffffff", -filled => 1, -linewidth => 0.1);

$zinc->add('curve',$top_group,[[4.6, 164.801], [4.6, 164.801, 'c'], [-10.6, 162.401, 'c'], [6.2, 160.801], [6.2, 160.801, 'c'], [24.2, 158.801, 'c'], [28.2, 153.601], [28.2, 153.601, 'c'], [41.8, 144.401, 'c'], [44.6, 144.001], [47.4, 143.601, 'c'], [63.8, 140.001, 'c'], [64.2, 137.601], [64.6, 135.201, 'c'], [70.6, 132.801, 'c'], [72.2, 133.601], [73.8, 134.401, 'c'], [73.8, 143.601, 'c'], [71, 144.401], [68.2, 145.201, 'c'], [49.4, 152.401, 'c'], [43, 153.601], [36.6, 154.801, 'c'], [25, 162.401, 'c'], [20.2, 163.601], [15.4, 164.801, 'c'], [4.6, 164.801, 'c'], [4.6, 164.801]],  -closed => 1, -fillcolor => "#cccccc", -filled => 1, -linecolor => "#cccccc");

$zinc->add('curve',$top_group,[[77.6, 127.401], [77.6, 127.401, 'c'], [74.6, 129.001, 'c'], [73.4, 131.601], [73.4, 131.601, 'c'], [67, 142.201, 'c'], [52.8, 145.401], [52.8, 145.401, 'c'], [29.8, 154.401, 'c'], [22, 156.401], [22, 156.401, 'c'], [8.6, 161.401, 'c'], [1.2, 160.601], [1.2, 160.601, 'c'], [-5.8, 160.801, 'c'], [0.4, 162.401], [0.4, 162.401, 'c'], [20.6, 160.401, 'c'], [24, 158.601], [24, 158.601, 'c'], [39.6, 153.401, 'c'], [42.6, 150.801], [45.6, 148.201, 'c'], [63.8, 143.201, 'c'], [66, 141.201], [68.2, 139.201, 'c'], [78, 130.801, 'c'], [77.6, 127.401]],  -closed => 1, -fillcolor => "#000000", -filled => 1, -linecolor => "#000000");

$zinc->add('curve',$top_group,[[18.882, 158.911], [18.882, 158.911, 'c'], [24.111, 158.685, 'c'], [22.958, 160.234], [21.805, 161.784, 'c'], [19.357, 160.91, 'c'], [19.357, 160.91], [18.882, 158.911]],  -closed => 1, -fillcolor => "#000000", -filled => 1, -linecolor => "#000000");

$zinc->add('curve',$top_group,[[11.68, 160.263], [11.68, 160.263, 'c'], [16.908, 160.037, 'c'], [15.756, 161.586], [14.603, 163.136, 'c'], [12.155, 162.263, 'c'], [12.155, 162.263], [11.68, 160.263]],  -closed => 1, -fillcolor => "#000000", -filled => 1, -linecolor => "#000000");

$zinc->add('curve',$top_group,[[1.251, 161.511], [1.251, 161.511, 'c'], [6.48, 161.284, 'c'], [5.327, 162.834], [4.174, 164.383, 'c'], [1.726, 163.51, 'c'], [1.726, 163.51], [1.251, 161.511]],  -closed => 1, -fillcolor => "#000000", -filled => 1, -linecolor => "#000000");

$zinc->add('curve',$top_group,[[-6.383, 162.055], [-6.383, 162.055, 'c'], [-1.154, 161.829, 'c'], [-2.307, 163.378], [-3.46, 164.928, 'c'], [-5.908, 164.054, 'c'], [-5.908, 164.054], [-6.383, 162.055]],  -closed => 1, -fillcolor => "#000000", -filled => 1, -linecolor => "#000000");

$zinc->add('curve',$top_group,[[35.415, 151.513], [35.415, 151.513, 'c'], [42.375, 151.212, 'c'], [40.84, 153.274], [39.306, 155.336, 'c'], [36.047, 154.174, 'c'], [36.047, 154.174], [35.415, 151.513]],  -closed => 1, -fillcolor => "#000000", -filled => 1, -linecolor => "#000000");

$zinc->add('curve',$top_group,[[45.73, 147.088], [45.73, 147.088, 'c'], [51.689, 143.787, 'c'], [51.155, 148.849], [50.885, 151.405, 'c'], [46.362, 149.749, 'c'], [46.362, 149.749], [45.73, 147.088]],  -closed => 1, -fillcolor => "#000000", -filled => 1, -linecolor => "#000000");

$zinc->add('curve',$top_group,[[54.862, 144.274], [54.862, 144.274, 'c'], [62.021, 140.573, 'c'], [60.287, 146.035], [59.509, 148.485, 'c'], [55.493, 146.935, 'c'], [55.493, 146.935], [54.862, 144.274]],  -closed => 1, -fillcolor => "#000000", -filled => 1, -linecolor => "#000000");

$zinc->add('curve',$top_group,[[64.376, 139.449], [64.376, 139.449, 'c'], [68.735, 134.548, 'c'], [69.801, 141.21], [70.207, 143.748, 'c'], [65.008, 142.11, 'c'], [65.008, 142.11], [64.376, 139.449]],  -closed => 1, -fillcolor => "#000000", -filled => 1, -linecolor => "#000000");

$zinc->add('curve',$top_group,[[26.834, 155.997], [26.834, 155.997, 'c'], [32.062, 155.77, 'c'], [30.91, 157.32], [29.757, 158.869, 'c'], [27.308, 157.996, 'c'], [27.308, 157.996], [26.834, 155.997]],  -closed => 1, -fillcolor => "#000000", -filled => 1, -linecolor => "#000000");

$zinc->add('curve',$top_group,[[62.434, 34.603], [62.434, 34.603, 'c'], [61.708, 35.268, 'c'], [61.707, 34.197], [61.707, 33.127, 'c'], [79.191, 19.863, 'c'], [88.034, 18.479], [88.034, 18.479, 'c'], [71.935, 25.208, 'c'], [62.434, 34.603]],  -closed => 1, -linecolor => "#000000", -fillcolor => "#ffffff", -filled => 1, -linewidth => 0.1);

$zinc->add('curve',$top_group,[[65.4, 98.4], [65.4, 98.4, 'c'], [87.401, 120.801, 'c'], [96.601, 124.401], [96.601, 124.401, 'c'], [105.801, 135.601, 'c'], [101.801, 161.601], [101.801, 161.601, 'c'], [98.601, 169.201, 'c'], [95.401, 148.401], [95.401, 148.401, 'c'], [98.601, 123.201, 'c'], [87.401, 139.201], [87.401, 139.201, 'c'], [79, 129.301, 'c'], [85.4, 129.601], [85.4, 129.601, 'c'], [88.601, 131.601, 'c'], [89.001, 130.001], [89.401, 128.401, 'c'], [81.4, 114.801, 'c'], [64.2, 100.4], [47, 86, 'c'], [65.4, 98.4, 'c'], [65.4, 98.4]],  -closed => 1, -fillcolor => "#000000", -filled => 1, -linecolor => "#000000");

$zinc->add('curve',$top_group,[[7, 137.201], [7, 137.201, 'c'], [6.8, 135.401, 'c'], [8.6, 136.201], [10.4, 137.001, 'c'], [104.601, 143.201, 'c'], [136.201, 167.201], [136.201, 167.201, 'c'], [91.001, 144.001, 'c'], [7, 137.201]],  -closed => 1, -linecolor => "#000000", -fillcolor => "#ffffff", -filled => 1, -linewidth => 0.1);

$zinc->add('curve',$top_group,[[17.4, 132.801], [17.4, 132.801, 'c'], [17.2, 131.001, 'c'], [19, 131.801], [20.8, 132.601, 'c'], [157.401, 131.601, 'c'], [181.001, 164.001], [181.001, 164.001, 'c'], [159.001, 138.801, 'c'], [17.4, 132.801]],  -closed => 1, -linecolor => "#000000", -fillcolor => "#ffffff", -filled => 1, -linewidth => 0.1);

$zinc->add('curve',$top_group,[[29, 128.801], [29, 128.801, 'c'], [28.8, 127.001, 'c'], [30.6, 127.801], [32.4, 128.601, 'c'], [205.801, 115.601, 'c'], [229.401, 148.001], [229.401, 148.001, 'c'], [219.801, 122.401, 'c'], [29, 128.801]],  -closed => 1, -linecolor => "#000000", -fillcolor => "#ffffff", -filled => 1, -linewidth => 0.1);

$zinc->add('curve',$top_group,[[39, 124.001], [39, 124.001, 'c'], [38.8, 122.201, 'c'], [40.6, 123.001], [42.4, 123.801, 'c'], [164.601, 85.2, 'c'], [188.201, 117.601], [188.201, 117.601, 'c'], [174.801, 93, 'c'], [39, 124.001]],  -closed => 1, -linecolor => "#000000", -fillcolor => "#ffffff", -filled => 1, -linewidth => 0.1);

$zinc->add('curve',$top_group,[[-19, 146.801], [-19, 146.801, 'c'], [-19.2, 145.001, 'c'], [-17.4, 145.801], [-15.6, 146.601, 'c'], [2.2, 148.801, 'c'], [4.2, 187.601], [4.2, 187.601, 'c'], [-3, 145.601, 'c'], [-19, 146.801]],  -closed => 1, -linecolor => "#000000", -fillcolor => "#ffffff", -filled => 1, -linewidth => 0.1);

$zinc->add('curve',$top_group,[[-27.8, 148.401], [-27.8, 148.401, 'c'], [-28, 146.601, 'c'], [-26.2, 147.401], [-24.4, 148.201, 'c'], [-10.2, 143.601, 'c'], [-13, 182.401], [-13, 182.401, 'c'], [-11.8, 147.201, 'c'], [-27.8, 148.401]],  -closed => 1, -linecolor => "#000000", -fillcolor => "#ffffff", -filled => 1, -linewidth => 0.1);

$zinc->add('curve',$top_group,[[-35.8, 148.801], [-35.8, 148.801, 'c'], [-36, 147.001, 'c'], [-34.2, 147.801], [-32.4, 148.601, 'c'], [-17, 149.201, 'c'], [-29.4, 171.601], [-29.4, 171.601, 'c'], [-19.8, 147.601, 'c'], [-35.8, 148.801]],  -closed => 1, -linecolor => "#000000", -fillcolor => "#ffffff", -filled => 1, -linewidth => 0.1);

$zinc->add('curve',$top_group,[[11.526, 104.465], [11.526, 104.465, 'c'], [11.082, 106.464, 'c'], [12.631, 105.247], [28.699, 92.622, 'c'], [61.141, 33.72, 'c'], [116.826, 28.086], [116.826, 28.086, 'c'], [78.518, 15.976, 'c'], [11.526, 104.465]],  -closed => 1, -linecolor => "#000000", -fillcolor => "#ffffff", -filled => 1, -linewidth => 0.1);

$zinc->add('curve',$top_group,[[22.726, 102.665], [22.726, 102.665, 'c'], [21.363, 101.472, 'c'], [23.231, 100.847], [25.099, 100.222, 'c'], [137.541, 27.72, 'c'], [176.826, 35.686], [176.826, 35.686, 'c'], [149.719, 28.176, 'c'], [22.726, 102.665]],  -closed => 1, -linecolor => "#000000", -fillcolor => "#ffffff", -filled => 1, -linewidth => 0.1);

$zinc->add('curve',$top_group,[[1.885, 108.767], [1.885, 108.767, 'c'], [1.376, 110.366, 'c'], [3.087, 109.39], [12.062, 104.27, 'c'], [15.677, 47.059, 'c'], [59.254, 45.804], [59.254, 45.804, 'c'], [26.843, 31.09, 'c'], [1.885, 108.767]],  -closed => 1, -linecolor => "#000000", -fillcolor => "#ffffff", -filled => 1, -linewidth => 0.1);

$zinc->add('curve',$top_group,[[-18.038, 119.793], [-18.038, 119.793, 'c'], [-19.115, 121.079, 'c'], [-17.162, 120.825], [-6.916, 119.493, 'c'], [14.489, 78.222, 'c'], [58.928, 83.301], [58.928, 83.301, 'c'], [26.962, 68.955, 'c'], [-18.038, 119.793]],  -closed => 1, -linecolor => "#000000", -fillcolor => "#ffffff", -filled => 1, -linewidth => 0.1);

$zinc->add('curve',$top_group,[[-6.8, 113.667], [-6.8, 113.667, 'c'], [-7.611, 115.136, 'c'], [-5.742, 114.511], [4.057, 111.237, 'c'], [17.141, 66.625, 'c'], [61.729, 63.078], [61.729, 63.078, 'c'], [27.603, 55.135, 'c'], [-6.8, 113.667]],  -closed => 1, -linecolor => "#000000", -fillcolor => "#ffffff", -filled => 1, -linewidth => 0.1);

$zinc->add('curve',$top_group,[[-25.078, 124.912], [-25.078, 124.912, 'c'], [-25.951, 125.954, 'c'], [-24.369, 125.748], [-16.07, 124.669, 'c'], [1.268, 91.24, 'c'], [37.264, 95.354], [37.264, 95.354, 'c'], [11.371, 83.734, 'c'], [-25.078, 124.912]],  -closed => 1, -linecolor => "#000000", -fillcolor => "#ffffff", -filled => 1, -linewidth => 0.1);

$zinc->add('curve',$top_group,[[-32.677, 130.821], [-32.677, 130.821, 'c'], [-33.682, 131.866, 'c'], [-32.091, 131.748], [-27.923, 131.439, 'c'], [2.715, 98.36, 'c'], [21.183, 113.862], [21.183, 113.862, 'c'], [9.168, 95.139, 'c'], [-32.677, 130.821]],  -closed => 1, -linecolor => "#000000", -fillcolor => "#ffffff", -filled => 1, -linewidth => 0.1);

$zinc->add('curve',$top_group,[[36.855, 98.898], [36.855, 98.898, 'c'], [35.654, 97.543, 'c'], [37.586, 97.158], [39.518, 96.774, 'c'], [160.221, 39.061, 'c'], [198.184, 51.927], [198.184, 51.927, 'c'], [172.243, 41.053, 'c'], [36.855, 98.898]],  -closed => 1, -linecolor => "#000000", -fillcolor => "#ffffff", -filled => 1, -linewidth => 0.1);

$zinc->add('curve',$top_group,[[3.4, 163.201], [3.4, 163.201, 'c'], [3.2, 161.401, 'c'], [5, 162.201], [6.8, 163.001, 'c'], [22.2, 163.601, 'c'], [9.8, 186.001], [9.8, 186.001, 'c'], [19.4, 162.001, 'c'], [3.4, 163.201]],  -closed => 1, -linecolor => "#000000", -fillcolor => "#ffffff", -filled => 1, -linewidth => 0.1);

$zinc->add('curve',$top_group,[[13.8, 161.601], [13.8, 161.601, 'c'], [13.6, 159.801, 'c'], [15.4, 160.601], [17.2, 161.401, 'c'], [35, 163.601, 'c'], [37, 202.401], [37, 202.401, 'c'], [29.8, 160.401, 'c'], [13.8, 161.601]],  -closed => 1, -linecolor => "#000000", -fillcolor => "#ffffff", -filled => 1, -linewidth => 0.1);

$zinc->add('curve',$top_group,[[20.6, 160.001], [20.6, 160.001, 'c'], [20.4, 158.201, 'c'], [22.2, 159.001], [24, 159.801, 'c'], [48.6, 163.201, 'c'], [72.2, 195.601], [72.2, 195.601, 'c'], [36.6, 158.801, 'c'], [20.6, 160.001]],  -closed => 1, -linecolor => "#000000", -fillcolor => "#ffffff", -filled => 1, -linewidth => 0.1);

$zinc->add('curve',$top_group,[[28.225, 157.972], [28.225, 157.972, 'c'], [27.788, 156.214, 'c'], [29.678, 156.768], [31.568, 157.322, 'c'], [52.002, 155.423, 'c'], [90.099, 189.599], [90.099, 189.599, 'c'], [43.924, 154.656, 'c'], [28.225, 157.972]],  -closed => 1, -linecolor => "#000000", -fillcolor => "#ffffff", -filled => 1, -linewidth => 0.1);

$zinc->add('curve',$top_group,[[38.625, 153.572], [38.625, 153.572, 'c'], [38.188, 151.814, 'c'], [40.078, 152.368], [41.968, 152.922, 'c'], [76.802, 157.423, 'c'], [128.499, 192.399], [128.499, 192.399, 'c'], [54.324, 150.256, 'c'], [38.625, 153.572]],  -closed => 1, -linecolor => "#000000", -fillcolor => "#ffffff", -filled => 1, -linewidth => 0.1);

$zinc->add('curve',$top_group,[[-1.8, 142.001], [-1.8, 142.001, 'c'], [-2, 140.201, 'c'], [-0.2, 141.001], [1.6, 141.801, 'c'], [55, 144.401, 'c'], [85.4, 171.201], [85.4, 171.201, 'c'], [50.499, 146.426, 'c'], [-1.8, 142.001]],  -closed => 1, -linecolor => "#000000", -fillcolor => "#ffffff", -filled => 1, -linewidth => 0.1);

$zinc->add('curve',$top_group,[[-11.8, 146.001], [-11.8, 146.001, 'c'], [-12, 144.201, 'c'], [-10.2, 145.001], [-8.4, 145.801, 'c'], [16.2, 149.201, 'c'], [39.8, 181.601], [39.8, 181.601, 'c'], [4.2, 144.801, 'c'], [-11.8, 146.001]],  -closed => 1, -linecolor => "#000000", -fillcolor => "#ffffff", -filled => 1, -linewidth => 0.1);

$zinc->add('curve',$top_group,[[49.503, 148.962], [49.503, 148.962, 'c'], [48.938, 147.241, 'c'], [50.864, 147.655], [52.79, 148.068, 'c'], [87.86, 150.004, 'c'], [141.981, 181.098], [141.981, 181.098, 'c'], [64.317, 146.704, 'c'], [49.503, 148.962]],  -closed => 1, -linecolor => "#000000", -fillcolor => "#ffffff", -filled => 1, -linewidth => 0.1);

$zinc->add('curve',$top_group,[[57.903, 146.562], [57.903, 146.562, 'c'], [57.338, 144.841, 'c'], [59.264, 145.255], [61.19, 145.668, 'c'], [96.26, 147.604, 'c'], [150.381, 178.698], [150.381, 178.698, 'c'], [73.317, 143.904, 'c'], [57.903, 146.562]],  -closed => 1, -linecolor => "#000000", -fillcolor => "#ffffff", -filled => 1, -linewidth => 0.1);

$zinc->add('curve',$top_group,[[67.503, 141.562], [67.503, 141.562, 'c'], [66.938, 139.841, 'c'], [68.864, 140.255], [70.79, 140.668, 'c'], [113.86, 145.004, 'c'], [203.582, 179.298], [203.582, 179.298, 'c'], [82.917, 138.904, 'c'], [67.503, 141.562]],  -closed => 1, -linecolor => "#000000", -fillcolor => "#ffffff", -filled => 1, -linewidth => 0.1);

$zinc->add('curve',$top_group,[[-43.8, 148.401], [-43.8, 148.401, 'c'], [-38.6, 148.001, 'c'], [-39.8, 149.601], [-41, 151.201, 'c'], [-43.4, 150.401, 'c'], [-43.4, 150.401], [-43.8, 148.401]],  -closed => 1, -fillcolor => "#000000", -filled => 1, -linecolor => "#000000");

$zinc->add('curve',$top_group,[[-13, 162.401], [-13, 162.401, 'c'], [-7.8, 162.001, 'c'], [-9, 163.601], [-10.2, 165.201, 'c'], [-12.6, 164.401, 'c'], [-12.6, 164.401], [-13, 162.401]],  -closed => 1, -fillcolor => "#000000", -filled => 1, -linecolor => "#000000");

$zinc->add('curve',$top_group,[[-21.8, 162.001], [-21.8, 162.001, 'c'], [-16.6, 161.601, 'c'], [-17.8, 163.201], [-19, 164.801, 'c'], [-21.4, 164.001, 'c'], [-21.4, 164.001], [-21.8, 162.001]],  -closed => 1, -fillcolor => "#000000", -filled => 1, -linecolor => "#000000");

$zinc->add('curve',$top_group,[[-117.169, 150.182], [-117.169, 150.182, 'c'], [-112.124, 151.505, 'c'], [-113.782, 152.624], [-115.439, 153.744, 'c'], [-117.446, 152.202, 'c'], [-117.446, 152.202], [-117.169, 150.182]],  -closed => 1, -fillcolor => "#000000", -filled => 1, -linecolor => "#000000");

$zinc->add('curve',$top_group,[[-115.169, 140.582], [-115.169, 140.582, 'c'], [-110.124, 141.905, 'c'], [-111.782, 143.024], [-113.439, 144.144, 'c'], [-115.446, 142.602, 'c'], [-115.446, 142.602], [-115.169, 140.582]],  -closed => 1, -fillcolor => "#000000", -filled => 1, -linecolor => "#000000");

$zinc->add('curve',$top_group,[[-122.369, 136.182], [-122.369, 136.182, 'c'], [-117.324, 137.505, 'c'], [-118.982, 138.624], [-120.639, 139.744, 'c'], [-122.646, 138.202, 'c'], [-122.646, 138.202], [-122.369, 136.182]],  -closed => 1, -fillcolor => "#000000", -filled => 1, -linecolor => "#000000");

$zinc->add('curve',$top_group,[[-42.6, 211.201], [-42.6, 211.201, 'c'], [-44.2, 211.201, 'c'], [-48.2, 213.201], [-50.2, 213.201, 'c'], [-61.4, 216.801, 'c'], [-67, 226.801], [-67, 226.801, 'c'], [-54.6, 217.201, 'c'], [-42.6, 211.201]],  -closed => 1, -fillcolor => "#cccccc", -filled => 1, -linecolor => "#cccccc");

$zinc->add('curve',$top_group,[[45.116, 303.847], [45.257, 304.105, 'c'], [45.312, 304.525, 'c'], [45.604, 304.542], [46.262, 304.582, 'c'], [47.495, 304.883, 'c'], [47.37, 304.247], [46.522, 299.941, 'c'], [45.648, 295.004, 'c'], [41.515, 293.197], [40.876, 292.918, 'c'], [39.434, 293.331, 'c'], [39.36, 294.215], [39.233, 295.739, 'c'], [39.116, 297.088, 'c'], [39.425, 298.554], [39.725, 299.975, 'c'], [41.883, 299.985, 'c'], [42.8, 298.601], [43.736, 300.273, 'c'], [44.168, 302.116, 'c'], [45.116, 303.847]],  -closed => 1, -fillcolor => "#cccccc", -filled => 1, -linecolor => "#cccccc");

$zinc->add('curve',$top_group,[[34.038, 308.581], [34.786, 309.994, 'c'], [34.659, 311.853, 'c'], [36.074, 312.416], [36.814, 312.71, 'c'], [38.664, 311.735, 'c'], [38.246, 310.661], [37.444, 308.6, 'c'], [37.056, 306.361, 'c'], [35.667, 304.55], [35.467, 304.288, 'c'], [35.707, 303.755, 'c'], [35.547, 303.427], [34.953, 302.207, 'c'], [33.808, 301.472, 'c'], [32.4, 301.801], [31.285, 304.004, 'c'], [32.433, 306.133, 'c'], [33.955, 307.842], [34.091, 307.994, 'c'], [33.925, 308.37, 'c'], [34.038, 308.581]],  -closed => 1, -fillcolor => "#cccccc", -filled => 1, -linecolor => "#cccccc");

$zinc->add('curve',$top_group,[[-5.564, 303.391], [-5.672, 303.014, 'c'], [-5.71, 302.551, 'c'], [-5.545, 302.23], [-5.014, 301.197, 'c'], [-4.221, 300.075, 'c'], [-4.558, 299.053], [-4.906, 297.997, 'c'], [-6.022, 298.179, 'c'], [-6.672, 298.748], [-7.807, 299.742, 'c'], [-7.856, 301.568, 'c'], [-8.547, 302.927], [-8.743, 303.313, 'c'], [-8.692, 303.886, 'c'], [-9.133, 304.277], [-9.607, 304.698, 'c'], [-10.047, 306.222, 'c'], [-9.951, 306.793], [-9.898, 307.106, 'c'], [-10.081, 317.014, 'c'], [-9.859, 316.751], [-9.24, 316.018, 'c'], [-6.19, 306.284, 'c'], [-6.121, 305.392], [-6.064, 304.661, 'c'], [-5.332, 304.196, 'c'], [-5.564, 303.391]],  -closed => 1, -fillcolor => "#cccccc", -filled => 1, -linecolor => "#cccccc");

$zinc->add('curve',$top_group,[[-31.202, 296.599], [-28.568, 294.1, 'c'], [-25.778, 291.139, 'c'], [-26.22, 287.427], [-26.336, 286.451, 'c'], [-28.111, 286.978, 'c'], [-28.298, 287.824], [-29.1, 291.449, 'c'], [-31.139, 294.11, 'c'], [-33.707, 296.502], [-35.903, 298.549, 'c'], [-37.765, 304.893, 'c'], [-38, 305.401], [-34.303, 300.145, 'c'], [-32.046, 297.399, 'c'], [-31.202, 296.599]],  -closed => 1, -fillcolor => "#cccccc", -filled => 1, -linecolor => "#cccccc");

$zinc->add('curve',$top_group,[[-44.776, 290.635], [-44.253, 290.265, 'c'], [-44.555, 289.774, 'c'], [-44.338, 289.442], [-43.385, 287.984, 'c'], [-42.084, 286.738, 'c'], [-42.066, 285], [-42.063, 284.723, 'c'], [-42.441, 284.414, 'c'], [-42.776, 284.638], [-43.053, 284.822, 'c'], [-43.395, 284.952, 'c'], [-43.503, 285.082], [-45.533, 287.531, 'c'], [-46.933, 290.202, 'c'], [-48.376, 293.014], [-48.559, 293.371, 'c'], [-49.703, 297.862, 'c'], [-49.39, 297.973], [-49.151, 298.058, 'c'], [-47.431, 293.877, 'c'], [-47.221, 293.763], [-45.958, 293.077, 'c'], [-45.946, 291.462, 'c'], [-44.776, 290.635]],  -closed => 1, -fillcolor => "#cccccc", -filled => 1, -linecolor => "#cccccc");

$zinc->add('curve',$top_group,[[-28.043, 310.179], [-27.599, 309.31, 'c'], [-26.023, 308.108, 'c'], [-26.136, 307.219], [-26.254, 306.291, 'c'], [-25.786, 304.848, 'c'], [-26.698, 305.536], [-27.955, 306.484, 'c'], [-31.404, 307.833, 'c'], [-31.674, 313.641], [-31.7, 314.212, 'c'], [-28.726, 311.519, 'c'], [-28.043, 310.179]],  -closed => 1, -fillcolor => "#cccccc", -filled => 1, -linecolor => "#cccccc");

$zinc->add('curve',$top_group,[[-13.6, 293.001], [-13.2, 292.333, 'c'], [-12.492, 292.806, 'c'], [-12.033, 292.543], [-11.385, 292.171, 'c'], [-10.774, 291.613, 'c'], [-10.482, 290.964], [-9.512, 288.815, 'c'], [-7.743, 286.995, 'c'], [-7.6, 284.601], [-9.091, 283.196, 'c'], [-9.77, 285.236, 'c'], [-10.4, 286.201], [-11.723, 284.554, 'c'], [-12.722, 286.428, 'c'], [-14.022, 286.947], [-14.092, 286.975, 'c'], [-14.305, 286.628, 'c'], [-14.38, 286.655], [-15.557, 287.095, 'c'], [-16.237, 288.176, 'c'], [-17.235, 288.957], [-17.406, 289.091, 'c'], [-17.811, 288.911, 'c'], [-17.958, 289.047], [-18.61, 289.65, 'c'], [-19.583, 289.975, 'c'], [-19.863, 290.657], [-20.973, 293.364, 'c'], [-24.113, 295.459, 'c'], [-26, 303.001], [-25.619, 303.91, 'c'], [-21.488, 296.359, 'c'], [-21.001, 295.661], [-20.165, 294.465, 'c'], [-20.047, 297.322, 'c'], [-18.771, 296.656], [-18.72, 296.629, 'c'], [-18.534, 296.867, 'c'], [-18.4, 297.001], [-18.206, 296.721, 'c'], [-17.988, 296.492, 'c'], [-17.6, 296.601], [-17.6, 296.201, 'c'], [-17.734, 295.645, 'c'], [-17.533, 295.486], [-16.296, 294.509, 'c'], [-16.38, 293.441, 'c'], [-15.6, 292.201], [-15.142, 292.99, 'c'], [-14.081, 292.271, 'c'], [-13.6, 293.001]],  -closed => 1, -fillcolor => "#cccccc", -filled => 1, -linecolor => "#cccccc");

$zinc->add('curve',$top_group,[[46.2, 347.401], [46.2, 347.401, 'c'], [53.6, 327.001, 'c'], [49.2, 315.801], [49.2, 315.801, 'c'], [60.6, 337.401, 'c'], [56, 348.601], [56, 348.601, 'c'], [55.6, 338.201, 'c'], [51.6, 333.201], [51.6, 333.201, 'c'], [47.6, 346.001, 'c'], [46.2, 347.401]],  -closed => 1, -fillcolor => "#cccccc", -filled => 1, -linecolor => "#cccccc");

$zinc->add('curve',$top_group,[[31.4, 344.801], [31.4, 344.801, 'c'], [36.8, 336.001, 'c'], [28.8, 317.601], [28.8, 317.601, 'c'], [28, 338.001, 'c'], [21.2, 349.001], [21.2, 349.001, 'c'], [35.4, 328.801, 'c'], [31.4, 344.801]],  -closed => 1, -fillcolor => "#cccccc", -filled => 1, -linecolor => "#cccccc");

$zinc->add('curve',$top_group,[[21.4, 342.801], [21.4, 342.801, 'c'], [21.2, 322.801, 'c'], [21.6, 319.801], [21.6, 319.801, 'c'], [17.8, 336.401, 'c'], [7.6, 346.001], [7.6, 346.001, 'c'], [22, 334.001, 'c'], [21.4, 342.801]],  -closed => 1, -fillcolor => "#cccccc", -filled => 1, -linecolor => "#cccccc");

$zinc->add('curve',$top_group,[[11.8, 310.801], [11.8, 310.801, 'c'], [17.8, 324.401, 'c'], [7.8, 342.801], [7.8, 342.801, 'c'], [14.2, 330.601, 'c'], [9.4, 323.601], [9.4, 323.601, 'c'], [12, 320.201, 'c'], [11.8, 310.801]],  -closed => 1, -fillcolor => "#cccccc", -filled => 1, -linecolor => "#cccccc");

$zinc->add('curve',$top_group,[[-7.4, 342.401], [-7.4, 342.401, 'c'], [-8.4, 326.801, 'c'], [-6.6, 324.601], [-6.6, 324.601, 'c'], [-6.4, 318.201, 'c'], [-6.8, 317.201], [-6.8, 317.201, 'c'], [-2.8, 311.001, 'c'], [-2.6, 318.401], [-2.6, 318.401, 'c'], [-1.2, 326.201, 'c'], [1.6, 330.801], [1.6, 330.801, 'c'], [5.2, 336.201, 'c'], [5, 342.601], [5, 342.601, 'c'], [-5, 312.401, 'c'], [-7.4, 342.401]],  -closed => 1, -fillcolor => "#cccccc", -filled => 1, -linecolor => "#cccccc");

$zinc->add('curve',$top_group,[[-11, 314.801], [-11, 314.801, 'c'], [-17.6, 325.601, 'c'], [-19.4, 344.601], [-19.4, 344.601, 'c'], [-20.8, 338.401, 'c'], [-17, 324.001], [-17, 324.001, 'c'], [-12.8, 308.601, 'c'], [-11, 314.801]],  -closed => 1, -fillcolor => "#cccccc", -filled => 1, -linecolor => "#cccccc");

$zinc->add('curve',$top_group,[[-32.8, 334.601], [-32.8, 334.601, 'c'], [-27.8, 329.201, 'c'], [-26.4, 324.201], [-26.4, 324.201, 'c'], [-22.8, 308.401, 'c'], [-29.2, 317.001], [-29.2, 317.001, 'c'], [-29, 325.001, 'c'], [-37.2, 332.401], [-37.2, 332.401, 'c'], [-32.4, 330.001, 'c'], [-32.8, 334.601]],  -closed => 1, -fillcolor => "#cccccc", -filled => 1, -linecolor => "#cccccc");

$zinc->add('curve',$top_group,[[-38.6, 329.601], [-38.6, 329.601, 'c'], [-35.2, 312.201, 'c'], [-34.4, 311.401], [-34.4, 311.401, 'c'], [-32.6, 308.001, 'c'], [-35.4, 311.201], [-35.4, 311.201, 'c'], [-44.2, 330.401, 'c'], [-48.2, 337.001], [-48.2, 337.001, 'c'], [-40.2, 327.801, 'c'], [-38.6, 329.601]],  -closed => 1, -fillcolor => "#cccccc", -filled => 1, -linecolor => "#cccccc");

$zinc->add('curve',$top_group,[[-44.4, 313.001], [-44.4, 313.001, 'c'], [-32.8, 290.601, 'c'], [-54.6, 316.401], [-54.6, 316.401, 'c'], [-43.6, 306.601, 'c'], [-44.4, 313.001]],  -closed => 1, -fillcolor => "#cccccc", -filled => 1, -linecolor => "#cccccc");

$zinc->add('curve',$top_group,[[-59.8, 298.401], [-59.8, 298.401, 'c'], [-55, 279.601, 'c'], [-52.4, 279.801], [-52.4, 279.801, 'c'], [-44.2, 270.801, 'c'], [-50.8, 281.401], [-50.8, 281.401, 'c'], [-56.8, 291.001, 'c'], [-56.2, 300.801], [-56.2, 300.801, 'c'], [-56.8, 291.201, 'c'], [-59.8, 298.401]],  -closed => 1, -fillcolor => "#cccccc", -filled => 1, -linecolor => "#cccccc");

$zinc->add('curve',$top_group,[[270.5, 287], [270.5, 287, 'c'], [258.5, 277, 'c'], [256, 273.5], [256, 273.5, 'c'], [269.5, 292, 'c'], [269.5, 299], [269.5, 299, 'c'], [272, 291.5, 'c'], [270.5, 287]],  -closed => 1, -fillcolor => "#cccccc", -filled => 1, -linecolor => "#cccccc");

$zinc->add('curve',$top_group,[[276, 265], [276, 265, 'c'], [255, 250, 'c'], [251.5, 242.5], [251.5, 242.5, 'c'], [278, 272, 'c'], [278, 276.5], [278, 276.5, 'c'], [278.5, 267.5, 'c'], [276, 265]],  -closed => 1, -fillcolor => "#cccccc", -filled => 1, -linecolor => "#cccccc");

$zinc->add('curve',$top_group,[[293, 111], [293, 111, 'c'], [281, 103, 'c'], [279.5, 105], [279.5, 105, 'c'], [290, 111.5, 'c'], [292.5, 120], [292.5, 120, 'c'], [291, 111, 'c'], [293, 111]],  -closed => 1, -fillcolor => "#cccccc", -filled => 1, -linecolor => "#cccccc");

$zinc->add('curve',$top_group,[[301.5, 191.5], [284, 179.5], [284, 179.5, 'c'], [303, 196.5, 'c'], [303.5, 200.5], [301.5, 191.5]],  -closed => 1, -fillcolor => "#cccccc", -filled => 1, -linecolor => "#cccccc");



### translating ojects for making them all visibles
$zinc->translate($top_group, 200, 150);


### on ajoute quelques binding bien pratiques pour la mise au point

my $i=0;

$zinc->Tk::bind('<ButtonPress-1>', [\&press, \&motion]);
$zinc->Tk::bind('<ButtonRelease-1>', [\&release]);
$zinc->Tk::bind('<ButtonPress-2>', [\&press, \&zoom]);
$zinc->Tk::bind('<ButtonRelease-2>', [\&release]);
$zinc->Tk::bind('<ButtonPress-3>', [\&press, \&rotate]);
$zinc->Tk::bind('<ButtonRelease-3>', [\&release]);


&Tk::MainLoop;


##### bindings for moving, rotating, scaling the items
my ($cur_x, $cur_y, $cur_angle);
sub press {
    my ($zinc, $action) = @_;
    my $ev = $zinc->XEvent();
    $cur_x = $ev->x;
    $cur_y = $ev->y;
    $cur_angle = atan2($cur_y, $cur_x);
    $zinc->Tk::bind('<Motion>', [$action]);
}

sub motion {
    my ($zinc) = @_;
    my $ev = $zinc->XEvent();
    my $lx = $ev->x;
    my $ly = $ev->y;
    my @res = $zinc->transform($top_group, [$lx, $ly, $cur_x, $cur_y]);
    $zinc->translate($top_group, $res[0] - $res[2], $res[1] - $res[3]);
    $cur_x = $lx;
    $cur_y = $ly;
    $i++;
}

sub zoom {
    my ($zinc, $self) = @_;
    my $ev = $zinc->XEvent();
    my $lx = $ev->x;
    my $ly = $ev->y;
    my $maxx;
    my $maxy;
    my $sx;
    my $sy;
    
    if ($lx > $cur_x) {
	$maxx = $lx;
    } else {
	$maxx = $cur_x;
    }
    if ($ly > $cur_y) {
	$maxy = $ly
    } else {
	$maxy = $cur_y;
    }
    return if ($maxx == 0 || $maxy == 0);
    $sx = 1.0 + ($lx - $cur_x)/$maxx;
    $sy = 1.0 + ($ly - $cur_y)/$maxy;
    $cur_x = $lx;
    $cur_y = $ly;
    $zinc->scale($top_group, $sx, $sx); #$sy);
}

sub rotate {
    my ($zinc) = @_;
    my $ev = $zinc->XEvent();
    my $lx = $ev->x;
    my $ly = $ev->y;
    my $langle;
    
    $langle = atan2($ly, $lx);
    $zinc->rotate($top_group, -($langle - $cur_angle));
    $cur_angle = $langle;
}

sub release {
    my ($zinc) = @_;
    $zinc->Tk::bind('<Motion>', '');
}
