use strict;
use warnings;
use Test::More tests => 68;
use Digest::Luffa qw(luffa_512 luffa_512_hex);

my $len = 0;

while (my $line = <DATA>) {
    chomp $line;
    my ($msg, $digest) = split '\|', $line, 2;
    my $data = pack 'H*', $msg;
    $digest = lc $digest;

    if ($len and not $len % 8) {
        my $md = Digest::Luffa->new(512)->add($data)->hexdigest;
        is($md, $digest, "new/add/hexdigest: $len bits of $msg");
        is(
            luffa_512_hex($data), $digest,
            "luffa_512_hex: $len bits of $msg"
        );
        ok(
            luffa_512($data) eq pack('H*', $digest),
            "luffa_512: $len bits of $msg"
        );
    }

    my $md = Digest::Luffa->new(512)->add_bits($data, $len)->hexdigest;
    is($md, $digest, "new/add_bits/hexdigest: $len bits of $msg");
}
continue { $len++ }

__DATA__
00|6E7DE4501189B3CA58F3AC114916654BBCD4922024B4CC1CD764ACFE8AB4B7805DF133EAB345FFDB1C414564C924F48E0A301824E2AC4C34BD4EFDE2E43DA90E
00|D062D0C5B9C659F0B2BBA6C3DA3E864123E8D4683DF4581742CCFD43FD32771FECB9FC63BA83B08D9FD4B7EA335CFCABA70EC9E4913BE51FF9D3998863CBA949
C0|451DC23AB8BDD17E901F047983B7AE718831C3152A0AF26B3EEA64FCFFCE3262D96AFB01C82468096826A09ADF931A2C59831215589674F6B3B8D71DCD080073
C0|8B410D904C3B8BBFC7E18F8941B794A4F9C794579C740B8B07B5AEBA87C931C58F8DE2A2D2F873D87609554D1609541D508FD209AE6BDFD7BA139A3CF6562FEC
80|7A36F2784332F1EB3861AE9794B690501F7ED416472F2B1DC593D671C187BA0DC02D4FABC0DF694B0E89757E9B66E41750173D52A73F1BDC701996381C126E79
48|877149DA711A2C7F205EC0D7E809E6AD03F7C6961F9D88F7DFB8368D3D6135D5D1681E626E3B6431D9CAB0285D95016C766272A4E8EC93D40ED8719206C68ED2
50|B44CD91D02E959476F2BBF479E0B6ABB447377C5DC5130AEE434DC8956FB3AA387C6E08D4E7C991213F6BD5ED453BDA5B527F8CC6467E7A477A5AFC59099C184
98|BB1124724CE035B220F67E52C0854634EF6830FC0DA67DAA2A671442BA41B14EB8E3B52737CDDCFFDB8C5D6D8E9E693020B7BB92FCC1389D97C0D1C7C48B307C
CC|91F1B09B2842871BC2F069E5D278D2D707DDAFABFE3CED5154FAF841E96781908290E6533D146183E8B7EC298F6DA20E0CFB1D41F4F711A3050FAA8DD4641F7F
9800|69720129F7F1061BD523C2A91425D265AEF3B760DCE321F6926018500F0B62050C85D57351A37DF8A0016B5B1E551A6AE6BCFF0BCABCB3AC30F983D54F607D63
9D40|FCB599C76158A657DEA7AFFF69BD220D7D601D9EA458060E5DBF3755A19A8DF5C3F56A582090CE68E835F12DC838A16521E14C4CA6C28C4C356644DA40DB3519
AA80|E7D96E21B6665918BD8488DA64D5F8FB9A910628B030EC3ED981929B42C35412513F5A01773461AC283FE00AC2C767BF5408FE7D950E8A9CDD02F0B49CADC793
9830|1754073150DA8448DB3BC3B98F74B248ED920530266D65B7FD6403107697F0C336B7703B2739B94FAF55B6DD5ADDE28EF5D10526AA212CC123908E8D3E522FF8
5030|93A5B2D5C846F8C7628FD27960CFE5AF3F23D4967F80EA8E5402A4DF7A650503E282ECD89A4B78D5B2180B4FCFB346EF11AD114890ED13A0D6C0557D9C3527E9
4D24|0EE77B99CC583595B0561EA0B2573FD6AC2EE528F775F4C929EDA5F09D40AF806933F366C70ED891A16DE6773B5ED44ADA2434F32F4EE6E5EFC967A54A662B14
CBDE|BD6E5599B6F90B4AF2DBECF4CCCD53739B2C6B747A4ED978762262E633E7789660317605D2A9C6BAA7C009D56414013FF270BFF9670C4662992E0EA644463907
41FB|3448D8766E1C8CF84CA83D0882305A8EBCAB3F9C5B87F8F1BB94EC8ABBE86320E6D33024FBE9363595ED3B36BF49A5440A1248F0606940AEC1321FC74DBB6BE5
4FF400|C36A901450186920AFFFEF469C99A458215BD171EDD90E5C60650FE2D95491AF040A817F11A6725BC9233CDB082F073C0FCD3697E49E25FA395CC98640436BDA
FD0440|6CC5CD298B6477CDD12387CE71E75A40240E97C6062BA8674E8BD3205F7B2A84E75CD2269D69E80E725563FF5D32F2B1BDC6466483830C17574EE92AE1401426
424D00|63901ED882627E18299C23AC45032B061EA868F3D0CC234FFCEA3890FC64AD1A90DC419BFE01AD21D7A96F3593F134A0228917BB87E5E8086AA9C01B9F6766A5
3FDEE0|380934D0648B65B3FC6BAB238968FBB886033D4DC07B819FF637155BBA1B99E063D5AD0690B4A728228C4BB4576FADC5AFAD2604070FEA7207FF64E70059DCD4
335768|5FBC20818E7452C736A2787649010EA880B94D7D90AD092FEEADFF8B73E028AFEDFD8B6D6B9B668D186D07E29154E9EFAA2EF2929CCAA5B516EA95CB3DFC6896
051E7C|CB08BC41B0EDBD6DA100F5F8F7353442483F5619C1FF73C1559F686E7B90EC1B19C2170D7C94718CD84B499E365C35B351CCF01A139332E297A8741EA1FAFF63
717F8C|DAE31A9B257304923573A172844A9EBAE66DD55529AC152F9AAED24165C1341E27258FA5722367D169C7DDD8E7F6BA07C253AD73990E0A2FB5AFAB844167AF56
1F877C|327ED73E847B90A1D098250020E45915CE4991B686E3920043AB17F026B2D3C77F9FED996673D527E4A1F628FB2F4F05949D3EABB0B00D9967063877E4370015
EB35CF80|C188F6BF4DE39A3849BF9985FCDD665BAD28826C38EA0072052B03870D8D22F15FB4AD2683215B33227A64104F5D8F1F4EDB8BDEFEE9628B240CDF480E959582
B406C480|2FAF5F4B9B5312574B6C8955E7A79E0B092E3BBB9F3D60B4624F0865A89C8050C91F37CF61EC7F04DD03E3F2304F963033AE95705FFE4D3A0A400363DB957B7E
CEE88040|5EA7280CA926D1260E4A6CCB942C3656F7F25C8CB8CC2A49ED6EB1186B03EDAA6D638C13682C86BCABFCF76CDA78E35281A2F30E5A2FA52C9E05E664A3AD760F
C584DB70|37236F6607D29EBED664959AE0FD56186148741AE46B9DA8DA7B419D7FC6B371232C6F5B8CE97DA6D90C7808DC57D21AEA6A12DEE718D9DF289A74AD6CEC8958
53587BC8|AD4604A78DCA48CF039337A1C94D80A0EF28B9C29FF7D940A42CF460E3EB6F30998E8A7734F3216B78EC18285D989A4F76CEE5948D9C4A65CEBAE8063CEF8F1A
69A305B0|D134525274FED536DE0F824BEF759372EE8FBB6CB8616CDC8FAD08A25ADF66A4CE86E55C1EAEE4E859F0D2ADEEAE924E730E270F7D0AEE32CF43A7C7B64D1204
C9375ECE|BFAB227544A32708BAAE5948935671235F9345B268C9BA8B0B86A99B8200591277FB6E3DE46CC40BF7D689DCC221A6A73108C3956ACB571833EE3FD9DC17732B
C1ECFDFC|D6C06A024D386A58A01D9C5852229593F2197BD9F3AFC9EB3F3230807D99C06D8EEB7AA36D7EEA74FDA69EC1356191985CADEDB24BF0C312BA1DB9E974442B16
8D73E8A280|44CBAB152F8782C44B74DD2597711348785919287D3DE5ECF7D17D74D3878F228013A16DE5BD2C0A4CCB60A281D48E6F7848BA2F9A77642F47095310311C742A
06F2522080|7792465976B747D91622A6DF7C623FE9720570204C6AB05F8351F3CCCADDFAEABB95A94F389FDD948ADE370395700D2540F37C0285614499FD64FFC8EC369F68
3EF6C36F20|05B2BD3F477231564516E77D0E5FD91DCA6C967C3566BD361A3B9F5EB6E3D5F87D32CB5E2C2C765B8565C25384704956B858842DAF8988EEF9CA89E33F680A06
0127A1D340|0397DEF0F20BEEF121DC280F14F20E1AE9CB1ABBBA2BB83BADC2F2382522B3B2087CDE778CDF98D07CB9E7DE9FA574B9D5D5D10235F662DE9B0B0FFC958471B8
6A6AB6C210|8769712C29AAAB2BBC9FEE310AECEF98064700ED37ED17B03CAF286FA8506348349B9CD88E44FBEAEED2CD1DA10DB8E5074A961F2BD383C4BAAF1233EC351D26
AF3175E160|C73693F130B96AD5020F1B293E9346F9EC0DE37BE38739FB10F6088BCAB682341A3EAF05F5FE1124A77905D86129E74241AD449B2054B60A0C16695865DCFBA7
B66609ED86|9676E909C909898E754FFD0E61945A7BF02B1EE35569B92E3C472512775FC59D76BBC0E012F1398FB6C5689C993F12BCFF8185EB3B07628CD08C99752C6A25E3
21F134AC57|7B576D395D624F6FFFF5E97954B56B9E5BCDD6F50BEAEDD2A0E24E2439CB48F1E567B1D7442EB3D60C95BE6C366967689B9B59D79A5794E764C2708386E5A8E2
3DC2AADFFC80|15BADFB17D8FFA864D04AB30FAF94848CF7939886709EB9637FC0AA42E04F396365B7C5B35DC66816BAB4FB81DA39F40526677306508A6024B6FB6478275EE8F
9202736D2240|7A7FF04DA7546DE36E45C036F9F372E576BA850E7AA1A5C770121800D19B0DEDCCDBBEB96D96D74315A34ABE3CDA6D34A36702CB69AF42D52D236C51DC1ECEB2
F219BD629820|0A6B01068D795F5788177976DB2F5B7489C3EA9CE4B17E43D700041C17A6DAEFA8B420DE475F1FF45FE1AEF3AAE0D96F9B53C3709FFBD7D1A184C4D38061D93D
F3511EE2C4B0|3CE69DCD40BE25B7C871FB2E01406FE97F1810CE761B2F007C512E2F48E17DA41E7D153755174A219BB78039840415BC8477339ECBDF41B9EBAF84FD099168FB
3ECAB6BF7720|509BF60395DA8BF9FC1FD4E5109B2B2B6D88FD449093B68D6773EA26CEBDE48EBDB95BC12CEF9395B4DCADC8E79A599F26FA3BCBFE440147D5D132678CE3E16E
CD62F688F498|87ABE25795112AE8AB3D504C72348B9F4E9CF81429381A3DF315BE2233FD38218578B5AB79AF6B65EC55F3F8966EB8A3C83150362CE651D83C7A686DD150AE63
C2CBAA33A9F8|061F06A39CA230269278143A944AA4868CAE33EF203C2BD314169CBD37C9727A0FF3D44CF616266688CC5799A96085FFAF7D469533323BBD4377E80DD548B2D9
C6F50BB74E29|08E6C3B2B275005BA963EA7A06D16A4397F9895B635956FF8C5FC53FDC3684F3883297743E2776690F69669AB816E7CFDCBFFAD427026F6E7F22EEF93832DFE0
79F1B4CCC62A00|F0CD348D60A11BB612CB3A992B9278D0A18B7EFD001FCC02401FCD4915B0B4F4EDD0725A5ED0A5AEF0B1138711C12A4BA85F7F36E422873C20C94270F68B1752
