{ use 5.008001; }
use warnings;
use strict;
 
use Module::Build;
 
Module::Build->subclass(code => q{
        unless(__PACKAGE__->can("cbuilder")) {
                *cbuilder = sub { $_[0]->_cbuilder or die "no C support" };
        }
        sub compile_c {
                my($self, $file, %args) = @_;
                my $cc0_h =
                        $self->localize_file_path("lib/JSON/XS/callchecker0.h");
                unless(-f $cc0_h) {
                        require Devel::CallChecker;
                        Devel::CallChecker->VERSION(0.001);
                        my $content = &Devel::CallChecker::callchecker0_h();
                        $self->add_to_cleanup($cc0_h);
                        require IO::File;
                        my $fh = IO::File->new($cc0_h, "w") or die $!;
                        $fh->printflush($content) or die $!;
                        $fh->close or die $!;
                }
                return $self->SUPER::compile_c($file, %args);
        }
        sub link_c {
                no strict "refs";
                my($self, $spec) = @_;
                my $cb = $self->cbuilder;
                my $cbclass = ref($cb);
                my $orig_cb_link = $cb->can("link");
                local *{"${cbclass}::link"} = sub {
                        my($self, %args) = @_;
                        if($args{module_name} eq "JSON::XS::Sugar") {
                                require Devel::CallChecker;
                                Devel::CallChecker->VERSION(0.002);
                                $args{objects} = [
                                    @{$args{objects}},
                                    Devel::CallChecker::callchecker_linkable(),
                                ];
                        }
                        @_ = ($self, %args);
                        goto &$orig_cb_link;
                };
                $self->SUPER::link_c($spec);
        }
})->new( __mb_args() )->create_build_script();

sub __mb_args {

    # This is a funky way of allowing this code to run stand-alone and as a
    # template to be processed by Dist::Zilla::Plugin::ModuleBuild::Custom
    my $data = do { local $/; <DATA> };

    if ( $data !~ /^\#/ ) {
        my $args = eval $data;
        return %{$args};
    }
    else {
        return (
            module_name          => 'JSON::XS::Sugar',
            dist_abstract        => 'Whatever',
            license              => 'perl',
            recursive_test_files => 1,
        );
    }
}
 
1;

__DATA__
 {
          'module_name' => 'JSON::XS::Sugar',
          'configure_requires' => {
                                    'Module::Build' => '0.28',
                                    'perl' => '5.014000',
                                    'warnings' => '0',
                                    'strict' => '0'
                                  },
          'license' => 'perl',
          'script_files' => [],
          'dist_name' => 'JSON-XS-Sugar',
          'recursive_test_files' => 1,
          'requires' => {
                          'Devel::CallChecker' => '0.003',
                          'constant' => '0',
                          'Types::Serialiser' => '0',
                          'warnings' => '0',
                          'strict' => '0',
                          'XSLoader' => '0',
                          'perl' => '5.014000',
                          'base' => '0',
                          'Exporter' => '0'
                        },
          'build_requires' => {
                                'Module::Build' => '0.28'
                              },
          'dist_abstract' => 'sugar for using JSON::XS',
          'dist_version' => '1.00',
          'dist_author' => [
                             'Mark Fowler <mfowler@maxmind.com>'
                           ],
          'recommends' => {},
          'test_requires' => {
                               'B' => '0',
                               'Test::Warn' => '0',
                               'perl' => '5.014000',
                               'IPC::Open3' => '0',
                               'ExtUtils::MakeMaker' => '0',
                               'IO::Handle' => '0',
                               'File::Spec' => '0',
                               'Test::More' => '0.96'
                             }
        };
