/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.nlp.parser.lexparser;

import edu.stanford.nlp.parser.lexparser.IntTaggedWord;
import edu.stanford.nlp.util.StringUtils;
import java.io.Serializable;

public class IntDependency
implements Serializable {
    public static final String LEFT = "left";
    public static final String RIGHT = "right";
    public static final int ANY_DISTANCE_INT = -1;
    public IntTaggedWord head;
    public IntTaggedWord arg;
    public boolean leftHeaded;
    public short distance;
    private static final char[] charsToEscape = new char[]{'\"'};
    private static final long serialVersionUID = 1L;

    public int hashCode() {
        return this.head.hashCode() ^ this.arg.hashCode() << 8 ^ (this.leftHeaded ? 1 : 0) << 15 ^ this.distance << 16;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o instanceof IntDependency) {
            IntDependency d = (IntDependency)o;
            return this.head.equals(d.head) && this.arg.equals(d.arg) && this.distance == d.distance && this.leftHeaded == d.leftHeaded;
        }
        return false;
    }

    public String toString() {
        return "\"" + StringUtils.escapeString(this.head.toString(), charsToEscape, '\\') + "\" -> \"" + StringUtils.escapeString(this.arg.toString(), charsToEscape, '\\') + "\" " + (this.leftHeaded ? LEFT : RIGHT) + " " + this.distance;
    }

    public IntDependency() {
    }

    public IntDependency(IntTaggedWord head, IntTaggedWord arg, boolean leftHeaded, int distance) {
        this.head = head;
        this.arg = arg;
        this.distance = (short)distance;
        this.leftHeaded = leftHeaded;
    }

    public IntDependency(int headWord, int headTag, int argWord, int argTag, boolean leftHeaded, int distance) {
        this.head = new IntTaggedWord(headWord, headTag);
        this.arg = new IntTaggedWord(argWord, argTag);
        this.distance = (short)distance;
        this.leftHeaded = leftHeaded;
    }
}

