#!/usr/bin/env perl

use 5.010;
use strict;
use warnings;

package Medical::Growth::NHANES_2000::Weight_for_Length::Infant::Female;

our ($VERSION) = '1.00';

use Moo::Lax;    # Vanilla Moo considered harmful

extends 'Medical::Growth::NHANES_2000::Base';

__PACKAGE__->_declare_params_LMS;

1;

# wtleninf, sex = 2

__DATA__

45	0.666839915	2.305396985	0.168969897
45.5	0.699616404	2.403256702	0.157654766
46.5	0.747915684	2.606020484	0.139389663
47.5	0.751754737	2.817114082	0.125837223
48.5	0.691329975	3.035356101	0.115888948
49.5	0.559107556	3.259693318	0.108648608
50.5	0.361549127	3.48922017	0.103402703
51.5	0.116436203	3.723195489	0.099599651
52.5	-0.152509094	3.961034945	0.096830356
53.5	-0.421478627	4.202270022	0.09480477
54.5	-0.671388289	4.446476028	0.093323068
55.5	-0.889973526	4.693220151	0.092246459
56.5	-1.071844454	4.942029343	0.091473166
57.5	-1.216671445	5.192403337	0.090923715
58.5	-1.327360462	5.443830096	0.090532906
59.5	-1.408261687	5.69581328	0.090246768
60.5	-1.464051065	5.947889759	0.090021128
61.5	-1.499105627	6.199640267	0.089820688
62.5	-1.517197913	6.450695818	0.089618171
63.5	-1.521479703	6.700736725	0.089393174
64.5	-1.514481331	6.949493534	0.089131254
65.5	-1.498204976	7.196744733	0.088822943
66.5	-1.474231858	7.442313819	0.088462854
67.5	-1.443808911	7.686067039	0.088048963
68.5	-1.407959107	7.92790936	0.087581916
69.5	-1.367521025	8.167783677	0.087064605
70.5	-1.32324327	8.405666621	0.086501667
71.5	-1.275834578	8.641566305	0.085899159
72.5	-1.226014257	8.875519723	0.085264271
73.5	-1.174555804	9.107590221	0.084605096
74.5	-1.122323639	9.337865054	0.083930435
75.5	-1.070302348	9.566453061	0.083249631
76.5	-1.019617172	9.793482492	0.082572421
77.5	-0.971544123	10.01909902	0.081908788
78.5	-0.927495981	10.24346467	0.081268832
79.5	-0.889046221	10.46675386	0.080662561
80.5	-0.857844783	10.6891553	0.080099785
81.5	-0.835600041	10.91086924	0.079589888
82.5	-0.824007806	11.13210717	0.079141623
83.5	-0.824673085	11.35309164	0.078762888
84.5	-0.839021353	11.57405623	0.078460511
85.5	-0.868191531	11.79524697	0.078240047
86.5	-0.912987527	12.0169203	0.078105554
87.5	-0.973732843	12.23934838	0.078059544
88.5	-1.050238631	12.46281861	0.078102898
89.5	-1.141750538	12.68763627	0.078234935
90.5	-1.246935039	12.9141268	0.078453576
91.5	-1.363881842	13.1426393	0.078755652
92.5	-1.490235591	13.37354263	0.079137144
93.5	-1.623204367	13.60723197	0.079593737
94.5	-1.759750536	13.84412275	0.080121122
95.5	-1.896722704	14.08464853	0.080715361
96.5	-2.031079769	14.32925018	0.081372938
97.5	-2.159985258	14.57837334	0.082090922
98.5	-2.280992946	14.8324557	0.082866693
99.5	-2.392125361	15.09192012	0.083697706
100.5	-2.491985117	15.35716167	0.08458092
101.5	-2.579688446	15.62854849	0.085512655
102.5	-2.654922113	15.90640903	0.086487929
103.5	-2.717782155	16.19103966	0.087500575

__END__

=head1 NAME

Medical::Growth::NHANES_2000::Weight_for_Length::Infant::Female

=head1 SYNOPSIS

  use Medical::Growth::NHANES_2000;
  Medical::Growth::NHANES_2000->find_measure_class(
    ages => 'Infant', sex => 'Female',
    measure => 'Weight for Length')->pct_for_value($wt,$len);

=head1 DESCRIPTION

This class provides the NHANES 2000 parameters for weight-for-length
tables for girls ages 0-36 months.

Weight values are expressed in kilograms, and length values in centimeters.

For details of the methods provided to operate on observations, please see
L<Medical::Growth::NHANES_2000::Base>.  For overall information on use of
the NHANES 2000 system, please see L<Medical::Growth::NHANES_2000>.

=head1 VERSION

version 1.00

=head1 AUTHOR

Charles Bailey <cbail@cpan.org>

=head1 COPYRIGHT AND LICENSE

Copyright 2012-2014 Charles Bailey.

This software may be used under the terms of the Artistic License or
the GNU General Public License, as the user prefers.

=head1 ACKNOWLEDGMENT

The code incorporated into this package was originally written with
United States federal funding as part of research work done by the
author at the Children's Hospital of Philadelphia.

=cut
