# Generated by default/object.tt
package Paws::CodeArtifact::RepositorySummary;
  use Moose;
  has AdministratorAccount => (is => 'ro', isa => 'Str', request_name => 'administratorAccount', traits => ['NameInRequest']);
  has Arn => (is => 'ro', isa => 'Str', request_name => 'arn', traits => ['NameInRequest']);
  has Description => (is => 'ro', isa => 'Str', request_name => 'description', traits => ['NameInRequest']);
  has DomainName => (is => 'ro', isa => 'Str', request_name => 'domainName', traits => ['NameInRequest']);
  has DomainOwner => (is => 'ro', isa => 'Str', request_name => 'domainOwner', traits => ['NameInRequest']);
  has Name => (is => 'ro', isa => 'Str', request_name => 'name', traits => ['NameInRequest']);

1;

### main pod documentation begin ###

=head1 NAME

Paws::CodeArtifact::RepositorySummary

=head1 USAGE

This class represents one of two things:

=head3 Arguments in a call to a service

Use the attributes of this class as arguments to methods. You shouldn't make instances of this class. 
Each attribute should be used as a named argument in the calls that expect this type of object.

As an example, if Att1 is expected to be a Paws::CodeArtifact::RepositorySummary object:

  $service_obj->Method(Att1 => { AdministratorAccount => $value, ..., Name => $value  });

=head3 Results returned from an API call

Use accessors for each attribute. If Att1 is expected to be an Paws::CodeArtifact::RepositorySummary object:

  $result = $service_obj->Method(...);
  $result->Att1->AdministratorAccount

=head1 DESCRIPTION

Details about a repository, including its Amazon Resource Name (ARN),
description, and domain information. The ListRepositories
(https://docs.aws.amazon.com/codeartifact/latest/APIReference/API_ListRepositories.html)
operation returns a list of C<RepositorySummary> objects.

=head1 ATTRIBUTES


=head2 AdministratorAccount => Str

The AWS account ID that manages the repository.


=head2 Arn => Str

The ARN of the repository.


=head2 Description => Str

The description of the repository.


=head2 DomainName => Str

The name of the domain that contains the repository.


=head2 DomainOwner => Str

The 12-digit account number of the AWS account that owns the domain. It
does not include dashes or spaces.


=head2 Name => Str

The name of the repository.



=head1 SEE ALSO

This class forms part of L<Paws>, describing an object used in L<Paws::CodeArtifact>

=head1 BUGS and CONTRIBUTIONS

The source code is located here: L<https://github.com/pplu/aws-sdk-perl>

Please report bugs to: L<https://github.com/pplu/aws-sdk-perl/issues>

=cut

