package Shipment::UPS::WSDL::RateTypes::FRSPaymentInfoType;
$Shipment::UPS::WSDL::RateTypes::FRSPaymentInfoType::VERSION = '3.04';
use strict;
use warnings;


__PACKAGE__->_set_element_form_qualified(1);

sub get_xmlns {'http://www.ups.com/XMLSchema/XOLTWS/Rate/v1.1'}

our $XML_ATTRIBUTE_CLASS;
undef $XML_ATTRIBUTE_CLASS;

sub __get_attr_class {
    return $XML_ATTRIBUTE_CLASS;
}

use Class::Std::Fast::Storable constructor => 'none';
use base qw(SOAP::WSDL::XSD::Typelib::ComplexType);

Class::Std::initialize();

{    # BLOCK to scope variables

    my %Type_of : ATTR(:get<Type>);
    my %AccountNumber_of : ATTR(:get<AccountNumber>);
    my %Address_of : ATTR(:get<Address>);

    __PACKAGE__->_factory(
        [   qw(        Type
              AccountNumber
              Address

              )
        ],
        {   'Type'          => \%Type_of,
            'AccountNumber' => \%AccountNumber_of,
            'Address'       => \%Address_of,
        },
        {   'Type' => 'Shipment::UPS::WSDL::RateTypes::CodeDescriptionType',
            'AccountNumber' => 'SOAP::WSDL::XSD::Typelib::Builtin::string',
            'Address' => 'Shipment::UPS::WSDL::RateTypes::PayerAddressType',
        },
        {

            'Type'          => 'Type',
            'AccountNumber' => 'AccountNumber',
            'Address'       => 'Address',
        }
    );

}    # end BLOCK


1;

__END__

=pod

=encoding UTF-8

=head1 NAME

Shipment::UPS::WSDL::RateTypes::FRSPaymentInfoType

=head1 VERSION

version 3.04

=head1 DESCRIPTION

Perl data type class for the XML Schema defined complexType
FRSPaymentInfoType from the namespace http://www.ups.com/XMLSchema/XOLTWS/Rate/v1.1.

=head2 PROPERTIES

The following properties may be accessed using get_PROPERTY / set_PROPERTY
methods:

=over

=item * Type (min/maxOccurs: 1/1)

=item * AccountNumber (min/maxOccurs: 1/1)

=item * Address (min/maxOccurs: 0/1)

=back

=head1 NAME

Shipment::UPS::WSDL::RateTypes::FRSPaymentInfoType

=head1 METHODS

=head2 new

Constructor. The following data structure may be passed to new():

 { # Shipment::UPS::WSDL::RateTypes::FRSPaymentInfoType
   Type =>  { # Shipment::UPS::WSDL::RateTypes::CodeDescriptionType
     Code =>  $some_value, # string
     Description =>  $some_value, # string
   },
   AccountNumber =>  $some_value, # string
   Address =>  { # Shipment::UPS::WSDL::RateTypes::PayerAddressType
     PostalCode =>  $some_value, # string
     CountryCode =>  $some_value, # string
   },
 },

=head1 AUTHOR

Generated by SOAP::WSDL

=head1 AUTHOR

Andrew Baerg <baergaj@cpan.org>

=head1 COPYRIGHT AND LICENSE

This software is copyright (c) 2018 by Andrew Baerg.

This is free software; you can redistribute it and/or modify it under
the same terms as the Perl 5 programming language system itself.

=cut
