use Test::More tests => 50;

use Net::IP::AddrRanges;

sub list_ranges_ok {
    my($input, $expected) = @_;
    my $ranges = Net::IP::AddrRanges->new();
    for(@$input) {
        my $adr = $_; #copy
        $adr =~ s/^([\+\-])//;
        if(not defined $1 or $1 eq '+') {
            $ranges->add($adr);
        }
        else {
            $ranges->subtract($adr);
        }
    }
#    $ranges->_dump;
    is_deeply([$ranges->list_ranges], $expected, join(', ', @$input));
}

list_ranges_ok [
    '+0.0.0.10-0.0.0.20',
],[
    '0.0.0.10-0.0.0.20',
];

list_ranges_ok [
    '+0.0.0.10-0.0.0.20',
    '+0.0.0.1-0.0.0.5',    
],[
    '0.0.0.1-0.0.0.5',
    '0.0.0.10-0.0.0.20',
];

list_ranges_ok [
    '+0.0.0.30-0.0.0.40',
    '+0.0.0.10-0.0.0.20',
    '+0.0.0.5-0.0.0.9',
],[
    '0.0.0.5-0.0.0.20',
    '0.0.0.30-0.0.0.40',
];

list_ranges_ok [
    '+0.0.0.30-0.0.0.40',
    '+0.0.0.10-0.0.0.20',
    '+0.0.0.5-0.0.0.10'
],[
    '0.0.0.5-0.0.0.20',
    '0.0.0.30-0.0.0.40',
];

list_ranges_ok [
    '+0.0.0.30-0.0.0.40',
    '+0.0.0.10-0.0.0.20',
    '+0.0.0.5-0.0.0.10'
],[
    '0.0.0.5-0.0.0.20',
    '0.0.0.30-0.0.0.40',
];

list_ranges_ok [
    '+0.0.0.30-0.0.0.40',
    '+0.0.0.10-0.0.0.20',
    '+0.0.0.5-0.0.0.19',
],[
    '0.0.0.5-0.0.0.20',
    '0.0.0.30-0.0.0.40',
];

list_ranges_ok [
    '+0.0.0.30-0.0.0.40',
    '+0.0.0.10-0.0.0.20',
    '+0.0.0.5-0.0.0.20',
],[
    '0.0.0.5-0.0.0.20',
    '0.0.0.30-0.0.0.40',
];

list_ranges_ok [
    '+0.0.0.30-0.0.0.40',
    '+0.0.0.10-0.0.0.20',
    '+0.0.0.5-0.0.0.21',
],[
    '0.0.0.5-0.0.0.21',
    '0.0.0.30-0.0.0.40',
];

list_ranges_ok [
    '+0.0.0.30-0.0.0.40',
    '+0.0.0.10-0.0.0.20',
    '+0.0.0.9-0.0.0.21',
],[
    '0.0.0.9-0.0.0.21',
    '0.0.0.30-0.0.0.40',
];

list_ranges_ok [
    '+0.0.0.30-0.0.0.40',
    '+0.0.0.10-0.0.0.20',
    '+0.0.0.10-0.0.0.20',
],[
    '0.0.0.10-0.0.0.20',
    '0.0.0.30-0.0.0.40',
];

list_ranges_ok [
    '+0.0.0.30-0.0.0.40',
    '+0.0.0.10-0.0.0.20',
    '+0.0.0.10-0.0.0.21',
],[
    '0.0.0.10-0.0.0.21',
    '0.0.0.30-0.0.0.40',
];

list_ranges_ok [
    '+0.0.0.30-0.0.0.40',
    '+0.0.0.10-0.0.0.20',
    '+0.0.0.11-0.0.0.21',
],[
    '0.0.0.10-0.0.0.21',
    '0.0.0.30-0.0.0.40',
];

list_ranges_ok [
    '+0.0.0.30-0.0.0.40',
    '+0.0.0.10-0.0.0.20',
    '+0.0.0.11-0.0.0.20',
],[
    '0.0.0.10-0.0.0.20',
    '0.0.0.30-0.0.0.40',
];

list_ranges_ok [
    '+0.0.0.30-0.0.0.40',
    '+0.0.0.10-0.0.0.20',
    '+0.0.0.11-0.0.0.19',
],[
    '0.0.0.10-0.0.0.20',
    '0.0.0.30-0.0.0.40',
];

list_ranges_ok [
    '+0.0.0.30-0.0.0.40',
    '+0.0.0.10-0.0.0.20',
    '+0.0.0.19-0.0.0.25',
],[
    '0.0.0.10-0.0.0.25',
    '0.0.0.30-0.0.0.40',
];

list_ranges_ok [
    '+0.0.0.30-0.0.0.40',
    '+0.0.0.10-0.0.0.20',
    '+0.0.0.20-0.0.0.25',
],[
    '0.0.0.10-0.0.0.25',
    '0.0.0.30-0.0.0.40',
];

list_ranges_ok [
    '+0.0.0.30-0.0.0.40',
    '+0.0.0.10-0.0.0.20',
    '+0.0.0.21-0.0.0.25',
],[
    '0.0.0.10-0.0.0.25',
    '0.0.0.30-0.0.0.40',
];

list_ranges_ok [
    '+0.0.0.30-0.0.0.40',
    '+0.0.0.10-0.0.0.20',
    '+0.0.0.22-0.0.0.25',
],[
    '0.0.0.10-0.0.0.20',
    '0.0.0.22-0.0.0.25',
    '0.0.0.30-0.0.0.40',
];

list_ranges_ok [
    '+0.0.0.10-0.0.0.20',
    '+0.0.0.30-0.0.0.40',
    '+0.0.0.9-0.0.0.41',
],[
    '0.0.0.9-0.0.0.41',
];

list_ranges_ok [
    '+0.0.0.10-0.0.0.20',
    '+0.0.0.30-0.0.0.40',
    '+0.0.0.10-0.0.0.40',
],[
    '0.0.0.10-0.0.0.40',
];

list_ranges_ok [
    '+0.0.0.10-0.0.0.20',
    '+0.0.0.30-0.0.0.40',
    '+0.0.0.11-0.0.0.39',
],[
    '0.0.0.10-0.0.0.40',
];

list_ranges_ok [
    '+0.0.0.10-0.0.0.40',
    '-0.0.0.1-0.0.0.9',
],[
    '0.0.0.10-0.0.0.40',
];

list_ranges_ok [
    '+0.0.0.10-0.0.0.40',
    '-0.0.0.1-0.0.0.10',
],[
    '0.0.0.11-0.0.0.40',
];

list_ranges_ok [
    '+0.0.0.10-0.0.0.40',
    '-0.0.0.1-0.0.0.11',
],[
    '0.0.0.12-0.0.0.40',
];

list_ranges_ok [
    '+0.0.0.10-0.0.0.40',
    '-0.0.0.9-0.0.0.20',
],[
    '0.0.0.21-0.0.0.40',
];

list_ranges_ok [
    '+0.0.0.10-0.0.0.40',
    '-0.0.0.10-0.0.0.20',
],[
    '0.0.0.21-0.0.0.40',
];

list_ranges_ok [
    '+0.0.0.10-0.0.0.40',
    '-0.0.0.11-0.0.0.20',
],[
    '0.0.0.10-0.0.0.10',
    '0.0.0.21-0.0.0.40',
];

list_ranges_ok [
    '+0.0.0.10-0.0.0.40',
    '-0.0.0.11-0.0.0.39',
],[
    '0.0.0.10-0.0.0.10',
    '0.0.0.40-0.0.0.40',
];

list_ranges_ok [
    '+0.0.0.10-0.0.0.40',
    '-0.0.0.11-0.0.0.40',
],[
    '0.0.0.10-0.0.0.10',
];

list_ranges_ok [
    '+0.0.0.10-0.0.0.40',
    '-0.0.0.11-0.0.0.41',
],[
    '0.0.0.10-0.0.0.10',
];

list_ranges_ok [
    '+0.0.0.10-0.0.0.40',
    '-0.0.0.10-0.0.0.40',
],[
];

list_ranges_ok [
    '+0.0.0.10-0.0.0.40',
    '-0.0.0.9-0.0.0.41',
],[
];

list_ranges_ok [
    '+0.0.0.10-0.0.0.20',
    '+0.0.0.30-0.0.0.40',
    '-0.0.0.21-0.0.0.29',
],[
    '0.0.0.10-0.0.0.20',
    '0.0.0.30-0.0.0.40',
];

list_ranges_ok [
    '+0.0.0.10-0.0.0.20',
    '+0.0.0.30-0.0.0.40',
    '-0.0.0.20-0.0.0.29',
],[
    '0.0.0.10-0.0.0.19',
    '0.0.0.30-0.0.0.40',
];

list_ranges_ok [
    '+0.0.0.10-0.0.0.20',
    '+0.0.0.30-0.0.0.40',
    '-0.0.0.20-0.0.0.30',
],[
    '0.0.0.10-0.0.0.19',
    '0.0.0.31-0.0.0.40',
];

list_ranges_ok [
    '+0.0.0.10-0.0.0.20',
    '+0.0.0.30-0.0.0.40',
    '-0.0.0.20-0.0.0.30',
],[
    '0.0.0.10-0.0.0.19',
    '0.0.0.31-0.0.0.40',
];

list_ranges_ok [
    '+0.0.0.10-0.0.0.20',
    '+0.0.0.30-0.0.0.40',
    '-0.0.0.20-0.0.0.40',
],[
    '0.0.0.10-0.0.0.19',
];

list_ranges_ok [
    '+0.0.0.10-0.0.0.20',
    '+0.0.0.30-0.0.0.40',
    '-0.0.0.10-0.0.0.30',
],[
    '0.0.0.31-0.0.0.40',
];

list_ranges_ok [
    '+0.0.0.0-0.0.0.0',
    '+0.0.0.1-0.0.0.10',
],[
    '0.0.0.0-0.0.0.10',
];

list_ranges_ok [
    '+0.0.0.0-0.0.0.0',
    '+0.0.0.0-0.0.0.0',
],[
    '0.0.0.0-0.0.0.0',
];

list_ranges_ok [
    '+0.0.0.0-255.255.255.255',
    '-255.255.0.0-255.255.255.255',
],[
    '0.0.0.0-255.254.255.255',
];

list_ranges_ok [
    '+0.0.0.0/0',
],[
    '0.0.0.0-255.255.255.255',
];

list_ranges_ok [
    '+10.0.0.0/24',
],[
    '10.0.0.0-10.0.0.255',
];

list_ranges_ok [
    '+10.0.0.1/32',
],[
    '10.0.0.1-10.0.0.1',
];

list_ranges_ok [
    '+10.0.0.1/32',
],[
    '10.0.0.1-10.0.0.1',
];

list_ranges_ok [
    '+10.0.0.1',
],[
    '10.0.0.1-10.0.0.1',
];

list_ranges_ok [
    '+10.0.0.1-10.0.0.1',
],[
    '10.0.0.1-10.0.0.1',
];

list_ranges_ok [
    'ffff::/16',
],[
    'ffff::-ffff:ffff:ffff:ffff:ffff:ffff:ffff:ffff',
];

list_ranges_ok [
    'fffc::/16',
    'ffff::/16',
],[
    'fffc::-fffc:ffff:ffff:ffff:ffff:ffff:ffff:ffff',
    'ffff::-ffff:ffff:ffff:ffff:ffff:ffff:ffff:ffff',
];

list_ranges_ok [
    'fffe::/16',
    'ffff::/16',
],[
    'fffe::-ffff:ffff:ffff:ffff:ffff:ffff:ffff:ffff',
];
