#!/usr/bin/env perl
use lib 'lib';

use strict;
use warnings;

use Test::More tests => 11;
use File::Spec ();

BEGIN {
  use_ok( 'FTN::Outbound::BSO' );
}

Log::Log4perl -> easy_init( $Log::Log4perl::DEBUG );

my $out = FTN::Outbound::BSO
  -> new( outbound_root => File::Spec -> tmpdir,
          domain => 'fidonet',
          zone => 15,
          domain_abbrev => { fidonet => 'out',
                           },
        );

ok( defined $out, 'object created' );

# let's fake scanning
for my $case
  ( [ { fidonet => { '14' => { 'Out.00e' => {},
                               'out.00E' => { 451 => { 31 => { points_dir => { '01c3001f.pnt' => 'the best' },
                                                             },
                                                     },
                                            },
                               'out.00e' => {},
                             },
                   },
      },                          # 'scanned' structure
      [ 'fidonet', 14, 451, 31 ], # looking for points dir for this node
      'the best',                 # correct answer
      'domain.other_zone does not have points dir, but domain.Other_Zone does', # diag message
    ],
    [ { fidonet => { '14' => { 'ouT.00e' => {},
                               'ouT.00E' => { 451 => { 31 => { points_dir => { '01C3001f.pnt' => 'the best' },
                                                             },
                                                     },
                                            },
                               'out.00e' => {},
                             },
                   },
      },
      [ 'fidonet', 14, 451, 31 ],
      'the best',
      'domain.other_zone does not have points dir, but domain.Other_Zone does - 2',
    ],
    [ { fidonet => { '14' => { 'ouT.00e' => {},
                               'ouT.00E' => { 451 => { 31 => { points_dir => { '01C3001f.pnt' => 'good 1',
                                                                               '01c3001f.pnt' => 'the best',
                                                                               '01c3001F.pnt' => 'good 2',
                                                                             },
                                                             },
                                                     },
                                            },
                               'out.00e' => {},
                             },
                   }
      },
      [ 'fidonet', 14, 451, 31 ],
      'the best',
      'domain.other_zone does not have points dir, but domain.Other_Zone does.  even few',
    ],
    [ { fidonet => { '15' => { 'out' => {},
                               'ouT' => { 451 => { 31 => { points_dir => { '01c3001f.pnt' => 'the best' },
                                                         },
                                                 },
                                        },
                               'Out' => {},
                             },
                   },
      },
      [ 'fidonet', 15, 451, 31 ],
      'the best',
      'our_domain (our_zone) does not have points dir, but Our_Domain does',
    ],
    [ { fidonet => { '15' => { 'ouT' => { 451 => { 31 => { points_dir => { '01c3001f.pnt' => 'not the best' },
                                                         },
                                                 },
                                        },
                               'out' => { 451 => { 31 => { points_dir => { '01c3001f.PnT' => 'the best' },
                                                         },
                                                 },
                                        },
                               'Out' => {},
                             },
                   }
      },
      [ 'fidonet', 15, 451, 31 ],
      'the best',
      'our_domain and Our_Domain have point dirs, but our_domain does not have best formatting of it',
    ],
    [ { fidonet => { '15' => { 'out' => {},
                               'Out' => { 451 => { 31 => { points_dir => { '01c3001f.PnT' => 'not the best' },
                                                         },
                                                 },
                                        },
                               'ouT' => { 451 => { 31 => { points_dir => { '01c3001f.pnt' => 'the best' },
                                                         },
                                                 },
                                        },
                             },
                   },
      },
      [ 'fidonet', 15, 451, 31 ],
      'the best',
      'our_Domain and Our_Domain have point dirs, but one of them has best formatting of it',
    ],
    [ { fidonet => { '15' => { 'out' => {},
                               'Out' => { 451 => { 31 => { points_dir => { '01c3001f.PnT' => 'not the best 1' },
                                                         },
                                                 },
                                        },
                               'ouT' => { 451 => { 31 => { points_dir => { '01c3001f.pNt' => 'not the best 2',
                                                                           '01c3001f.pnt' => 'the best',
                                                                         },
                                                         },
                                                 },
                                        },
                             },
                   },
      },
      [ 'fidonet', 15, 451, 31 ],
      'the best',
      'our_Domain and Our_Domain have point dirs (not ideally formatted) plus one of them has ideally formatted points dir',
    ],
    [ { fidonet => { '15' => { 'out' => {},
                               'Out' => { 451 => { 31 => { points_dir => { '01c3001f.PnT' => 'not the best 1' },
                                                         },
                                                 },
                                        },
                               'ouT' => { 451 => { 31 => { points_dir => { '01c3001f.pNt' => 'the best',
                                                                           '01c3001F.pnt' => 'not the best 2',
                                                                           '01C3001f.pnt' => 'not the best 3',
                                                                         },
                                                         },
                                                 },
                                        },
                             },
                   },
      },
      [ 'fidonet', 15, 451, 31 ],
      'the best',
      'our_Domain and Our_Domain have point dirs (not ideally formatted)',
    ],
    [ { fidonet => { '15' => { 'ouT' => { 451 => { 31 => { points_dir => { '01c3001f.pnt' => 'not the best 1' },
                                                         },
                                                 },
                                        },
                               'Out' => { 451 => { 31 => { points_dir => { '01c3001f.pnt' => 'not the best 2' },
                                                         },
                                                 },
                                        },
                               'out' => { 451 => { 31 => { points_dir => { '01c3001f.pNt' => 'the best',
                                                                           '01c3001F.pnt' => 'not the best 3',
                                                                           '01C3001f.pnt' => 'not the best 4',
                                                                         },
                                                         },
                                                 },
                                        },
                             },
                   },
      },
      [ 'fidonet', 15, 451, 31 ],
      'the best',
      'our_Domain and Our_Domain have ideally formatted point dirs, but we prefer our_domain that does not and we  pick best there',
    ],
  ) {
  $out -> {scanned} = $case -> [ 0 ];

  is $out -> _select_points_dir( @{ $case -> [ 1 ] } ),
    $case -> [ 2 ],
    $case -> [ 3 ];
}

# $out -> {scanned}{fidonet}{15} = { 'out' => {},
#                                    'Out' => { 451 => { 31 => { points_dir => { '01c3001f.pnt' => 'the best' },
#                                                              },
#                                                      },
#                                             },
#                                    # 'ouT' => { 451 => { 31 => { points_dir => { '01c3001f.pnt' => 'not the best' },
#                                    #                           },
#                                    #                   },
#                                    #          },
#                                  };
# is( $out -> _select_points_dir( 'fidonet', 15, 451, 31 ), 'the best', 'our_Domain and Our_Domain have point dirs and both of them have best formatting of it' );

# $out -> {scanned}{fidonet}{15} = { 'out' => {},
#                                    'Out' => { 451 => { 31 => { points_dir => { '01c3001f.PnT' => 'the best' },
#                                                              },
#                                                      },
#                                             },
#                                    'ouT' => { 451 => { 31 => { points_dir => { '01c3001f.pNt' => 'not the best' },
#                                                              },
#                                                      },
#                                             },
#                                  };
# is( $out -> _select_points_dir( 'fidonet', 15, 451, 31 ), 'the best', 'our_Domain and Our_Domain have point dirs and none of them have best formatting of it' );
