use utf8;
use strict;
use warnings;

package Number::Phone::FR::Full;

our $VERSION;
BEGIN {
    $VERSION = '0.0917215';
}

use Number::Phone::FR;

use parent 'Number::Phone::FR';
use Scalar::Util 'blessed';

sub RE_0() {
    qr/(?:(?:9(?:7(?:6(?:[06][1-9]|1[0-378]|7[1-367]|3[1-37]|4[017]|5[0-2]|2[27]|9[0-9])|8(?:[156][0-9]|3[5-9]|2[0-3]|4[0-2]|[07][0-9]|9[78])|4(?:5[0-79]|1[2-9]|[246-8][0-9]|00|91)|3(?:[1256][0-9]|[37][0-4]|8[2-7]|0[0-9])|2(?:[1-69][0-9]|7[0-3]|8[0-9]|0[09])|0(?:[0-24-8][0-9]|3[02-689]|9[0-9])|7(?:[013-9][0-9]|2[0-2])|[159][0-9][0-9])|8(?:8(?:[03-5][0-9]|2[0-258]|1[0189]|6[6-8]|9[089]|8[0-9]|77)|7(?:[013-57][0-9]|6[5-7]|8[6-8]|9[89]|27)|2(?:[2-7][0-9]|1[0-2]|9[89]|05|82)|0(?:[3-9][0-9]|0[0189]|1[03])|5(?:[346-8][1-9]|[59][0-9])|6(?:[0-7][0-9]|8[67]|98)|(?:9[0-5]|1[0-9])[0-9]|3(?:[02-9][0-9]|10)|4(?:[0-5][0-9]|98))|[56][0-9][0-9][0-9])|6(?:9(?:3(?:4[0-7]|9[0-479]|0[0-46]|8[0-38]|6[0-26]|1[013]|2[0-2]|3[039]|5[05]|7[07])|6(?:[0-47-9][0-9]|5[0-6]|6[0-4])|4(?:3[0-48]|[0-249][0-9])|1(?:3[0-5]|2[29])|[589][0-9][0-9]|[02][0-9][0-9]|727)|3(?:9(?:0[0-79]|9[04-79]|7[06-9]|1[019]|[26][0-9]|3[09]|[45]0)|8(?:[1-9][0-9]|0[0-57-9])|6(?:[5-9][0-9]|[0-4][0-9])|[0-57][0-9][0-9])|4(?:9(?:[0-46-8][0-9]|[59][0-9])|(?:[235-8][0-9]|4[0-9])[0-9]|0(?:[1-9][0-9]|0[0-9])|1(?:[0-57-9][0-9]|6[0-9]))|0(?:(?:[137-9][0-9]|[245][0-9])[0-9]|6(?:[0-4][0-9]|[5-9][0-9]))|5(?:(?:[0-2457-9][0-9]|3[0-9])[0-9]|6(?:[0-57-9][0-9]|6[0-9]))|(?:6(?:[0-8][0-9]|9[0-9])|[1278][0-9][0-9])[0-9])|4(?:2(?:2(?:5[1-9]|7[013-9]|8[0-46-9]|[0-469][0-9])|0(?:5[57-9]|[01][0-9]|[2-4]0|6[01]|9[45]|88)|8(?:[0-35-9][0-9]|4[0-24-9])|3(?:0[0-8]|1[12])|[67][0-9][0-9])|8(?:5(?:7[1-9]|4[0-5]|8[05-8]|[0-3][0-9])|7(?:9[04-9]|[0-5][0-9]|8[89])|[0-4689][0-9][0-9])|4(?:4(?:0[0-6]|5[0-5]|3[7-9]|8[89]|4[0-9])|8(?:[0-46-9][0-9]|5[0-79])|[23][0-9][0-9])|6(?:5(?:2[0-689]|7[02-9]|5[0-6]|8[0-5]|6[5-9]|[0134][0-9])|[36-9][0-9][0-9])|1(?:5(?:8[0-8]|[0-7][0-9])|[13][0-9][0-9])|5(?:8(?:[0-7][0-9]|8[0-5])|[067][0-9][0-9])|(?:(?:3[02478]|7[0-9])|9[0-9])[0-9][0-9])|5(?:9(?:6(?:0[0-7]|4[0-246-8]|3[05-9]|9[4-8]|[5-7][0-9]|2[78]|8[09]|10)|0(?:4[0-46-9]|[02589][0-9]|3[0-289]|1[0-3]|6[0189]|7[07])|4(?:4[0346-9]|5[6-9]|6[0-3]|[023][0-9]|9[014]|1[01]|80))|3(?:6(?:[34][0-8]|1[1-9]|2[0-57-9]|0[0-9]|53)|2(?:[0-58][0-9]|6[0-3])|[13-5][0-9][0-9])|8(?:6(?:8[0-35-9]|[0-479][0-9]|6[5-9]|5[01])|2(?:[0-79][0-9]|8[013-9])|[17][0-9][0-9])|5(?:4(?:2[1-9]|5[0-8]|[0134][0-9])|[35-9][0-9][0-9])|6(?:4(?:[0-24-9][0-9]|3[013-9])|[1-357][0-9][0-9])|(?:4[024-79]|(?:24|79))[0-9][0-9]|1(?:80[0-6]|[679][0-9][0-9])|08(?:4[0-24]|5[05]))|2(?:6(?:2(?:0[1-9]|[1-79][0-9]|8[0-257-9])|9(?:6[0-79]|0[67]|5[01]|[78]0)|1(?:[0-8][0-9]|9[03-9]))|5(?:7(?:[0-8][0-9]|9[0-24-9])|5(?:[0-36-9][0-9]|5[5-9])|8(?:2[0-2]|[01][0-9])|[0-46][0-9][0-9])|7(?:9(?:3[0-8]|8[0-24-9]|[0-2][0-9]|9[0-2]|79)|[26-8][0-9][0-9])|2(?:1(?:1[1-9]|5[0-7]|[02-4][0-9])|[237-9][0-9][0-9])|4(?:2(?:[0-8][0-9]|9[0-6])|[013-9][0-9][0-9])|(?:(?:(?:1[48]|85)|3[0-8])|9[06-9])[0-9][0-9])|3(?:7(?:4(?:1[1-9]|2[0-24-9]|[03-589][0-9]|6[0-5]|7[4-9])|5(?:2[0-8]|6[0-5]|[013-5][0-9])|9(?:[0-2][0-9]|3[01])|[0-3][0-9][0-9])|5(?:3(?:0[02-9]|4[0-7]|[1-3][0-9])|6(?:[0-4][0-9]|5[0-2])|[12457-9][0-9][0-9])|6(?:7(?:1[0-57-9]|8[0-689]|4[0-6]|[023679][0-9])|[0-689][0-9][0-9])|(?:(?:(?:(?:2[0-9]|10)|4[45])|8[0-9])|9[01])[0-9][0-9]|39(?:7[0-7]|[0-489][0-9]|50))|1(?:8(?:6(?:2[0-46-9]|[01346-9][0-9]|5[01])|0(?:[013-9][0-9]|2[1-9])|7(?:2[1-9]|[3-9][0-9])|(?:[1-5][0-9]|8[01])[0-9])|(?:(?:(?:(?:3[049]|4[0-9])|5[035-8])|6[0149])|7[0-9])[0-9][0-9]|(?:(?:9[01]|05)[0-9]|24[12])[0-9]))[0-9]|8(?:(?:2(?:1(?:4[02-9]|2[0-589]|5[0-57]|3[0346-8]|6[0-256]|7[04578]|[0189][0-9])|6(?:[14][0-6]|0[0-24-9]|5[0-35-79]|8[0-24-68]|9[05-79]|[2367][0-9])|5(?:2[0-8]|4[02-57-9]|6[0235-9]|9[024578]|[01358][0-9]|7[24-7])|0(?:4[0-8]|7[0-57-9]|9[02-9]|6[0-25-9]|[0-358][0-9]))|6(?:0(?:0[0-24-79]|1[0-25-9]|4[0-24-7]|9[0-469]|6[0-2458]|7[014589]|8[246-8]|3[0378]|2[268]|5[17])|8(?:3[02389]|4[0-26]|9[0-29]|7[089]|8[468]|0[17]|5[27]|6[08]|11|22))|1(?:1(?:[27][0-8]|[89][0-24-9]|3[0-46-9]|4[0-689]|5[0-79]|6[024-9]|[01][0-9])|2(?:0[0-68]|1[0-4]|2[0-2]|8[01]|34|42)|9(?:0[25]|1[09])|0[0-9][0-9])|4(?:1(?:0[013-5]|1[0-3]|4[12])|3(?:0[0-589]|99))|5(?:0[0-2469]|8[58]|[45]0|28|66)[0-9]|8428)[0-9]|9(?:(?:0(?:3[0-79]|0[0-478]|4[0-6]|5[04-9]|7[015-9]|2[0-5]|8[014-69]|9[0-27-9]|1[0-3]|6[0145])|2(?:0[0-79]|1[02-9]|3[013-9]|4[0-35-9]|5[1-9]|6[0-689]|8[0146-9]|[279][0-9])|9(?:[159][02-9]|[78][0-24-9]|2[1-9]|4[0-689]|0[1-46-9]|6[0-69]|3[346-9])|1(?:0[0-7]|1[0-24689]|3[035-9]|5[013-7]|2[2-6]|4[3-68]|6[0579]|7[0178]|8[049]|9[27])|7(?:7[0-24-689]|1[02368]|0[0145]|2[1-4]|5[05-7]|3[7-9]|4[469]|6[569]|8[79]|97))[0-9]|5(?:0(?:8[0-29]|7[79]|20)|2(?:3[2-4]|2[67]|00)|8(?:9[5-8]|8[89])|1(?:0[0-9]|23)|6(?:8[01]|9[0-9])|7(?:0[01]|95)|[59]00)|84(?:0[124]|4[0-9])|30(?:0[0-9]|10))|0(?:(?:5(?:3[02-9]|4[0-79]|9[0-35-9]|6[0-3569]|7[0135-7]|8[0-2568]|[0-25][0-9])|6(?:1[0-46]|0[06-9]|[69][09]|5[04]|8[01]|23|70)|1(?:2[0136]|8[0-2]|1[01]|0[0-9]|38|77|90)|3(?:0[1-9]|8[0-468]|3[02357])|9(?:1[0239]|0[126]|3[268]|[489]0|54)|0[0-9][0-9])[0-9]|88(?:0[015-9]|10))|36(?:(?:0[1-36-9]|4[7-9]|5[49]|6[02]|99)[0-9]|7(?:[35][0-9]|47)))|7(?:(?:5(?:7(?:5[0-8]|0[0-57]|[239][0-9]|6[37]|7[79]|[18]7|4[0-9])|0(?:[1-489][0-9]|5[0-378]|7[0-5]|[06][0-9])|5(?:[0-47-9][0-9]|6[0-8]|5[0-7])|2(?:[1-9][0-9]|0[0-6])|4(?:[0-24-9][0-9]|3[0-2])|(?:[389][0-9]|[16][0-9])[0-9])|8(?:(?:[1-359][0-9]|[478][0-9])[0-9]|0(?:[0-8][0-9]|9[0-9])|6(?:[1-9][0-9]|0[0-9]))|7(?:(?:[6-9][0-9]|5[0-6]|0[0-9])[0-9]|1(?:[0-46-8][0-9]|9[0-4]|5[0-9]))|6(?:(?:[1-57-9][0-9]|69)[0-9]|0(?:[1-9][0-9]|0[0-9])))[0-9]|0000[0-4]))[0-9][0-9][0-9]/
}

sub RE_SUBSCRIBER() {
    qr/\A(?:(3(?:2(?:0[0-689]|1[0-689]|2[02-9]|3[0-79]|5[0-46-9]|8[02-9]|6[024-8]|9[02-49]|4[0-9]|7[0-9])|9(?:0[0-79]|1[0-4679]|3[0-35-79]|2[0-479]|4[03-689]|7[0135-79]|9[0-24579]|5[0579]|8[0189]|6[069])|6(?:2[0-689]|3[0-24-79]|5[0-24-8]|6[013-79]|0[015-9]|9[025689]|7[0679]|8[02]|1[0-9]|4[0-9])|0(?:0[024579]|3[0-356]|2[02356]|1[057]|8[079]|[467]0|5[05]|9[09])|4(?:9[13-79]|4[02-57]|3[03-6]|5[04-6]|2[024]|0[04]|88)|1(?:1[0-367]|0[036]|2[013]|3[0-2]|55|90)))|(?:(?:3651)?(?:[047-9]|16(?:1[013-578]|2[1356]|6[04-6]|3[038]|5[479]|9[079]|[78]0|03|44))|(?:00|\+)33)((?:(?:9(?:7(?:6(?:[06][1-9]|1[0-378]|7[1-367]|3[1-37]|4[017]|5[0-2]|2[27]|9[0-9])|8(?:[156][0-9]|3[5-9]|2[0-3]|4[0-2]|[07][0-9]|9[78])|4(?:5[0-79]|1[2-9]|[246-8][0-9]|00|91)|3(?:[1256][0-9]|[37][0-4]|8[2-7]|0[0-9])|2(?:[1-69][0-9]|7[0-3]|8[0-9]|0[09])|0(?:[0-24-8][0-9]|3[02-689]|9[0-9])|7(?:[013-9][0-9]|2[0-2])|[159][0-9][0-9])|8(?:8(?:[03-5][0-9]|2[0-258]|1[0189]|6[6-8]|9[089]|8[0-9]|77)|7(?:[013-57][0-9]|6[5-7]|8[6-8]|9[89]|27)|2(?:[2-7][0-9]|1[0-2]|9[89]|05|82)|0(?:[3-9][0-9]|0[0189]|1[03])|5(?:[346-8][1-9]|[59][0-9])|6(?:[0-7][0-9]|8[67]|98)|(?:9[0-5]|1[0-9])[0-9]|3(?:[02-9][0-9]|10)|4(?:[0-5][0-9]|98))|[56][0-9][0-9][0-9])|6(?:9(?:3(?:4[0-7]|9[0-479]|0[0-46]|8[0-38]|6[0-26]|1[013]|2[0-2]|3[039]|5[05]|7[07])|6(?:[0-47-9][0-9]|5[0-6]|6[0-4])|4(?:3[0-48]|[0-249][0-9])|1(?:3[0-5]|2[29])|[589][0-9][0-9]|[02][0-9][0-9]|727)|3(?:9(?:0[0-79]|9[04-79]|7[06-9]|1[019]|[26][0-9]|3[09]|[45]0)|8(?:[1-9][0-9]|0[0-57-9])|6(?:[5-9][0-9]|[0-4][0-9])|[0-57][0-9][0-9])|4(?:9(?:[0-46-8][0-9]|[59][0-9])|(?:[235-8][0-9]|4[0-9])[0-9]|0(?:[1-9][0-9]|0[0-9])|1(?:[0-57-9][0-9]|6[0-9]))|0(?:(?:[137-9][0-9]|[245][0-9])[0-9]|6(?:[0-4][0-9]|[5-9][0-9]))|5(?:(?:[0-2457-9][0-9]|3[0-9])[0-9]|6(?:[0-57-9][0-9]|6[0-9]))|(?:6(?:[0-8][0-9]|9[0-9])|[1278][0-9][0-9])[0-9])|4(?:2(?:2(?:5[1-9]|7[013-9]|8[0-46-9]|[0-469][0-9])|0(?:5[57-9]|[01][0-9]|[2-4]0|6[01]|9[45]|88)|8(?:[0-35-9][0-9]|4[0-24-9])|3(?:0[0-8]|1[12])|[67][0-9][0-9])|8(?:5(?:7[1-9]|4[0-5]|8[05-8]|[0-3][0-9])|7(?:9[04-9]|[0-5][0-9]|8[89])|[0-4689][0-9][0-9])|4(?:4(?:0[0-6]|5[0-5]|3[7-9]|8[89]|4[0-9])|8(?:[0-46-9][0-9]|5[0-79])|[23][0-9][0-9])|6(?:5(?:2[0-689]|7[02-9]|5[0-6]|8[0-5]|6[5-9]|[0134][0-9])|[36-9][0-9][0-9])|1(?:5(?:8[0-8]|[0-7][0-9])|[13][0-9][0-9])|5(?:8(?:[0-7][0-9]|8[0-5])|[067][0-9][0-9])|(?:(?:3[02478]|7[0-9])|9[0-9])[0-9][0-9])|5(?:9(?:6(?:0[0-7]|4[0-246-8]|3[05-9]|9[4-8]|[5-7][0-9]|2[78]|8[09]|10)|0(?:4[0-46-9]|[02589][0-9]|3[0-289]|1[0-3]|6[0189]|7[07])|4(?:4[0346-9]|5[6-9]|6[0-3]|[023][0-9]|9[014]|1[01]|80))|3(?:6(?:[34][0-8]|1[1-9]|2[0-57-9]|0[0-9]|53)|2(?:[0-58][0-9]|6[0-3])|[13-5][0-9][0-9])|8(?:6(?:8[0-35-9]|[0-479][0-9]|6[5-9]|5[01])|2(?:[0-79][0-9]|8[013-9])|[17][0-9][0-9])|5(?:4(?:2[1-9]|5[0-8]|[0134][0-9])|[35-9][0-9][0-9])|6(?:4(?:[0-24-9][0-9]|3[013-9])|[1-357][0-9][0-9])|(?:4[024-79]|(?:24|79))[0-9][0-9]|1(?:80[0-6]|[679][0-9][0-9])|08(?:4[0-24]|5[05]))|2(?:6(?:2(?:0[1-9]|[1-79][0-9]|8[0-257-9])|9(?:6[0-79]|0[67]|5[01]|[78]0)|1(?:[0-8][0-9]|9[03-9]))|5(?:7(?:[0-8][0-9]|9[0-24-9])|5(?:[0-36-9][0-9]|5[5-9])|8(?:2[0-2]|[01][0-9])|[0-46][0-9][0-9])|7(?:9(?:3[0-8]|8[0-24-9]|[0-2][0-9]|9[0-2]|79)|[26-8][0-9][0-9])|2(?:1(?:1[1-9]|5[0-7]|[02-4][0-9])|[237-9][0-9][0-9])|4(?:2(?:[0-8][0-9]|9[0-6])|[013-9][0-9][0-9])|(?:(?:(?:1[48]|85)|3[0-8])|9[06-9])[0-9][0-9])|3(?:7(?:4(?:1[1-9]|2[0-24-9]|[03-589][0-9]|6[0-5]|7[4-9])|5(?:2[0-8]|6[0-5]|[013-5][0-9])|9(?:[0-2][0-9]|3[01])|[0-3][0-9][0-9])|5(?:3(?:0[02-9]|4[0-7]|[1-3][0-9])|6(?:[0-4][0-9]|5[0-2])|[12457-9][0-9][0-9])|6(?:7(?:1[0-57-9]|8[0-689]|4[0-6]|[023679][0-9])|[0-689][0-9][0-9])|(?:(?:(?:(?:2[0-9]|10)|4[45])|8[0-9])|9[01])[0-9][0-9]|39(?:7[0-7]|[0-489][0-9]|50))|1(?:8(?:6(?:2[0-46-9]|[01346-9][0-9]|5[01])|0(?:[013-9][0-9]|2[1-9])|7(?:2[1-9]|[3-9][0-9])|(?:[1-5][0-9]|8[01])[0-9])|(?:(?:(?:(?:3[049]|4[0-9])|5[035-8])|6[0149])|7[0-9])[0-9][0-9]|(?:(?:9[01]|05)[0-9]|24[12])[0-9]))[0-9]|8(?:(?:2(?:1(?:4[02-9]|2[0-589]|5[0-57]|3[0346-8]|6[0-256]|7[04578]|[0189][0-9])|6(?:[14][0-6]|0[0-24-9]|5[0-35-79]|8[0-24-68]|9[05-79]|[2367][0-9])|5(?:2[0-8]|4[02-57-9]|6[0235-9]|9[024578]|[01358][0-9]|7[24-7])|0(?:4[0-8]|7[0-57-9]|9[02-9]|6[0-25-9]|[0-358][0-9]))|6(?:0(?:0[0-24-79]|1[0-25-9]|4[0-24-7]|9[0-469]|6[0-2458]|7[014589]|8[246-8]|3[0378]|2[268]|5[17])|8(?:3[02389]|4[0-26]|9[0-29]|7[089]|8[468]|0[17]|5[27]|6[08]|11|22))|1(?:1(?:[27][0-8]|[89][0-24-9]|3[0-46-9]|4[0-689]|5[0-79]|6[024-9]|[01][0-9])|2(?:0[0-68]|1[0-4]|2[0-2]|8[01]|34|42)|9(?:0[25]|1[09])|0[0-9][0-9])|4(?:1(?:0[013-5]|1[0-3]|4[12])|3(?:0[0-589]|99))|5(?:0[0-2469]|8[58]|[45]0|28|66)[0-9]|8428)[0-9]|9(?:(?:0(?:3[0-79]|0[0-478]|4[0-6]|5[04-9]|7[015-9]|2[0-5]|8[014-69]|9[0-27-9]|1[0-3]|6[0145])|2(?:0[0-79]|1[02-9]|3[013-9]|4[0-35-9]|5[1-9]|6[0-689]|8[0146-9]|[279][0-9])|9(?:[159][02-9]|[78][0-24-9]|2[1-9]|4[0-689]|0[1-46-9]|6[0-69]|3[346-9])|1(?:0[0-7]|1[0-24689]|3[035-9]|5[013-7]|2[2-6]|4[3-68]|6[0579]|7[0178]|8[049]|9[27])|7(?:7[0-24-689]|1[02368]|0[0145]|2[1-4]|5[05-7]|3[7-9]|4[469]|6[569]|8[79]|97))[0-9]|5(?:0(?:8[0-29]|7[79]|20)|2(?:3[2-4]|2[67]|00)|8(?:9[5-8]|8[89])|1(?:0[0-9]|23)|6(?:8[01]|9[0-9])|7(?:0[01]|95)|[59]00)|84(?:0[124]|4[0-9])|30(?:0[0-9]|10))|0(?:(?:5(?:3[02-9]|4[0-79]|9[0-35-9]|6[0-3569]|7[0135-7]|8[0-2568]|[0-25][0-9])|6(?:1[0-46]|0[06-9]|[69][09]|5[04]|8[01]|23|70)|1(?:2[0136]|8[0-2]|1[01]|0[0-9]|38|77|90)|3(?:0[1-9]|8[0-468]|3[02357])|9(?:1[0239]|0[126]|3[268]|[489]0|54)|0[0-9][0-9])[0-9]|88(?:0[015-9]|10))|36(?:(?:0[1-36-9]|4[7-9]|5[49]|6[02]|99)[0-9]|7(?:[35][0-9]|47)))|7(?:(?:5(?:7(?:5[0-8]|0[0-57]|[239][0-9]|6[37]|7[79]|[18]7|4[0-9])|0(?:[1-489][0-9]|5[0-378]|7[0-5]|[06][0-9])|5(?:[0-47-9][0-9]|6[0-8]|5[0-7])|2(?:[1-9][0-9]|0[0-6])|4(?:[0-24-9][0-9]|3[0-2])|(?:[389][0-9]|[16][0-9])[0-9])|8(?:(?:[1-359][0-9]|[478][0-9])[0-9]|0(?:[0-8][0-9]|9[0-9])|6(?:[1-9][0-9]|0[0-9]))|7(?:(?:[6-9][0-9]|5[0-6]|0[0-9])[0-9]|1(?:[0-46-8][0-9]|9[0-4]|5[0-9]))|6(?:(?:[1-57-9][0-9]|69)[0-9]|0(?:[1-9][0-9]|0[0-9])))[0-9]|0000[0-4]))[0-9][0-9][0-9]))\z/
}

sub RE_FULL() {
    qr/\A(?:(?:1(?:1(?:8(?:6(?:0[069]|1[128]|66)|7(?:1[0-38]|0[07])|0(?:0[0-26-8]|18)|8(?:1[168]|00|88)|5(?:1[58]|00|55)|2(?:00|18|22)|3(?:00|18|33)|9(?:00|18|99)|4(?:00|18))|[259]|6000)|0(?:1[0-8]|2[02-6]|0[157]|3[034]|6[148]|9[079]|5[57]|44)|[578]))|(?:3(?:2(?:0[0-689]|1[0-689]|2[02-9]|3[0-79]|5[0-46-9]|8[02-9]|6[024-8]|9[02-49]|4[0-9]|7[0-9])|9(?:0[0-79]|1[0-4679]|3[0-35-79]|2[0-479]|4[03-689]|7[0135-79]|9[0-24579]|5[0579]|8[0189]|6[069])|6(?:2[0-689]|3[0-24-79]|5[0-24-8]|6[013-79]|0[015-9]|9[025689]|7[0679]|8[02]|1[0-9]|4[0-9])|0(?:0[024579]|3[0-356]|2[02356]|1[057]|8[079]|[467]0|5[05]|9[09])|4(?:9[13-79]|4[02-57]|3[03-6]|5[04-6]|2[024]|0[04]|88)|1(?:1[0-367]|0[036]|2[013]|3[0-2]|55|90)))|(?:(?:(?:3651)?(?:[047-9]|16(?:1[013-578]|2[1356]|6[04-6]|3[038]|5[479]|9[079]|[78]0|03|44))|(?:00|\+)33))(?:(?:(?:(?:9(?:7(?:6(?:[06][1-9]|1[0-378]|7[1-367]|3[1-37]|4[017]|5[0-2]|2[27]|9[0-9])|8(?:[156][0-9]|3[5-9]|2[0-3]|4[0-2]|[07][0-9]|9[78])|4(?:5[0-79]|1[2-9]|[246-8][0-9]|00|91)|3(?:[1256][0-9]|[37][0-4]|8[2-7]|0[0-9])|2(?:[1-69][0-9]|7[0-3]|8[0-9]|0[09])|0(?:[0-24-8][0-9]|3[02-689]|9[0-9])|7(?:[013-9][0-9]|2[0-2])|[159][0-9][0-9])|8(?:8(?:[03-5][0-9]|2[0-258]|1[0189]|6[6-8]|9[089]|8[0-9]|77)|7(?:[013-57][0-9]|6[5-7]|8[6-8]|9[89]|27)|2(?:[2-7][0-9]|1[0-2]|9[89]|05|82)|0(?:[3-9][0-9]|0[0189]|1[03])|5(?:[346-8][1-9]|[59][0-9])|6(?:[0-7][0-9]|8[67]|98)|(?:9[0-5]|1[0-9])[0-9]|3(?:[02-9][0-9]|10)|4(?:[0-5][0-9]|98))|[56][0-9][0-9][0-9])|6(?:9(?:3(?:4[0-7]|9[0-479]|0[0-46]|8[0-38]|6[0-26]|1[013]|2[0-2]|3[039]|5[05]|7[07])|6(?:[0-47-9][0-9]|5[0-6]|6[0-4])|4(?:3[0-48]|[0-249][0-9])|1(?:3[0-5]|2[29])|[589][0-9][0-9]|[02][0-9][0-9]|727)|3(?:9(?:0[0-79]|9[04-79]|7[06-9]|1[019]|[26][0-9]|3[09]|[45]0)|8(?:[1-9][0-9]|0[0-57-9])|6(?:[5-9][0-9]|[0-4][0-9])|[0-57][0-9][0-9])|4(?:9(?:[0-46-8][0-9]|[59][0-9])|(?:[235-8][0-9]|4[0-9])[0-9]|0(?:[1-9][0-9]|0[0-9])|1(?:[0-57-9][0-9]|6[0-9]))|0(?:(?:[137-9][0-9]|[245][0-9])[0-9]|6(?:[0-4][0-9]|[5-9][0-9]))|5(?:(?:[0-2457-9][0-9]|3[0-9])[0-9]|6(?:[0-57-9][0-9]|6[0-9]))|(?:6(?:[0-8][0-9]|9[0-9])|[1278][0-9][0-9])[0-9])|4(?:2(?:2(?:5[1-9]|7[013-9]|8[0-46-9]|[0-469][0-9])|0(?:5[57-9]|[01][0-9]|[2-4]0|6[01]|9[45]|88)|8(?:[0-35-9][0-9]|4[0-24-9])|3(?:0[0-8]|1[12])|[67][0-9][0-9])|8(?:5(?:7[1-9]|4[0-5]|8[05-8]|[0-3][0-9])|7(?:9[04-9]|[0-5][0-9]|8[89])|[0-4689][0-9][0-9])|4(?:4(?:0[0-6]|5[0-5]|3[7-9]|8[89]|4[0-9])|8(?:[0-46-9][0-9]|5[0-79])|[23][0-9][0-9])|6(?:5(?:2[0-689]|7[02-9]|5[0-6]|8[0-5]|6[5-9]|[0134][0-9])|[36-9][0-9][0-9])|1(?:5(?:8[0-8]|[0-7][0-9])|[13][0-9][0-9])|5(?:8(?:[0-7][0-9]|8[0-5])|[067][0-9][0-9])|(?:(?:3[02478]|7[0-9])|9[0-9])[0-9][0-9])|5(?:9(?:6(?:0[0-7]|4[0-246-8]|3[05-9]|9[4-8]|[5-7][0-9]|2[78]|8[09]|10)|0(?:4[0-46-9]|[02589][0-9]|3[0-289]|1[0-3]|6[0189]|7[07])|4(?:4[0346-9]|5[6-9]|6[0-3]|[023][0-9]|9[014]|1[01]|80))|3(?:6(?:[34][0-8]|1[1-9]|2[0-57-9]|0[0-9]|53)|2(?:[0-58][0-9]|6[0-3])|[13-5][0-9][0-9])|8(?:6(?:8[0-35-9]|[0-479][0-9]|6[5-9]|5[01])|2(?:[0-79][0-9]|8[013-9])|[17][0-9][0-9])|5(?:4(?:2[1-9]|5[0-8]|[0134][0-9])|[35-9][0-9][0-9])|6(?:4(?:[0-24-9][0-9]|3[013-9])|[1-357][0-9][0-9])|(?:4[024-79]|(?:24|79))[0-9][0-9]|1(?:80[0-6]|[679][0-9][0-9])|08(?:4[0-24]|5[05]))|2(?:6(?:2(?:0[1-9]|[1-79][0-9]|8[0-257-9])|9(?:6[0-79]|0[67]|5[01]|[78]0)|1(?:[0-8][0-9]|9[03-9]))|5(?:7(?:[0-8][0-9]|9[0-24-9])|5(?:[0-36-9][0-9]|5[5-9])|8(?:2[0-2]|[01][0-9])|[0-46][0-9][0-9])|7(?:9(?:3[0-8]|8[0-24-9]|[0-2][0-9]|9[0-2]|79)|[26-8][0-9][0-9])|2(?:1(?:1[1-9]|5[0-7]|[02-4][0-9])|[237-9][0-9][0-9])|4(?:2(?:[0-8][0-9]|9[0-6])|[013-9][0-9][0-9])|(?:(?:(?:1[48]|85)|3[0-8])|9[06-9])[0-9][0-9])|3(?:7(?:4(?:1[1-9]|2[0-24-9]|[03-589][0-9]|6[0-5]|7[4-9])|5(?:2[0-8]|6[0-5]|[013-5][0-9])|9(?:[0-2][0-9]|3[01])|[0-3][0-9][0-9])|5(?:3(?:0[02-9]|4[0-7]|[1-3][0-9])|6(?:[0-4][0-9]|5[0-2])|[12457-9][0-9][0-9])|6(?:7(?:1[0-57-9]|8[0-689]|4[0-6]|[023679][0-9])|[0-689][0-9][0-9])|(?:(?:(?:(?:2[0-9]|10)|4[45])|8[0-9])|9[01])[0-9][0-9]|39(?:7[0-7]|[0-489][0-9]|50))|1(?:8(?:6(?:2[0-46-9]|[01346-9][0-9]|5[01])|0(?:[013-9][0-9]|2[1-9])|7(?:2[1-9]|[3-9][0-9])|(?:[1-5][0-9]|8[01])[0-9])|(?:(?:(?:(?:3[049]|4[0-9])|5[035-8])|6[0149])|7[0-9])[0-9][0-9]|(?:(?:9[01]|05)[0-9]|24[12])[0-9]))[0-9]|8(?:(?:2(?:1(?:4[02-9]|2[0-589]|5[0-57]|3[0346-8]|6[0-256]|7[04578]|[0189][0-9])|6(?:[14][0-6]|0[0-24-9]|5[0-35-79]|8[0-24-68]|9[05-79]|[2367][0-9])|5(?:2[0-8]|4[02-57-9]|6[0235-9]|9[024578]|[01358][0-9]|7[24-7])|0(?:4[0-8]|7[0-57-9]|9[02-9]|6[0-25-9]|[0-358][0-9]))|6(?:0(?:0[0-24-79]|1[0-25-9]|4[0-24-7]|9[0-469]|6[0-2458]|7[014589]|8[246-8]|3[0378]|2[268]|5[17])|8(?:3[02389]|4[0-26]|9[0-29]|7[089]|8[468]|0[17]|5[27]|6[08]|11|22))|1(?:1(?:[27][0-8]|[89][0-24-9]|3[0-46-9]|4[0-689]|5[0-79]|6[024-9]|[01][0-9])|2(?:0[0-68]|1[0-4]|2[0-2]|8[01]|34|42)|9(?:0[25]|1[09])|0[0-9][0-9])|4(?:1(?:0[013-5]|1[0-3]|4[12])|3(?:0[0-589]|99))|5(?:0[0-2469]|8[58]|[45]0|28|66)[0-9]|8428)[0-9]|9(?:(?:0(?:3[0-79]|0[0-478]|4[0-6]|5[04-9]|7[015-9]|2[0-5]|8[014-69]|9[0-27-9]|1[0-3]|6[0145])|2(?:0[0-79]|1[02-9]|3[013-9]|4[0-35-9]|5[1-9]|6[0-689]|8[0146-9]|[279][0-9])|9(?:[159][02-9]|[78][0-24-9]|2[1-9]|4[0-689]|0[1-46-9]|6[0-69]|3[346-9])|1(?:0[0-7]|1[0-24689]|3[035-9]|5[013-7]|2[2-6]|4[3-68]|6[0579]|7[0178]|8[049]|9[27])|7(?:7[0-24-689]|1[02368]|0[0145]|2[1-4]|5[05-7]|3[7-9]|4[469]|6[569]|8[79]|97))[0-9]|5(?:0(?:8[0-29]|7[79]|20)|2(?:3[2-4]|2[67]|00)|8(?:9[5-8]|8[89])|1(?:0[0-9]|23)|6(?:8[01]|9[0-9])|7(?:0[01]|95)|[59]00)|84(?:0[124]|4[0-9])|30(?:0[0-9]|10))|0(?:(?:5(?:3[02-9]|4[0-79]|9[0-35-9]|6[0-3569]|7[0135-7]|8[0-2568]|[0-25][0-9])|6(?:1[0-46]|0[06-9]|[69][09]|5[04]|8[01]|23|70)|1(?:2[0136]|8[0-2]|1[01]|0[0-9]|38|77|90)|3(?:0[1-9]|8[0-468]|3[02357])|9(?:1[0239]|0[126]|3[268]|[489]0|54)|0[0-9][0-9])[0-9]|88(?:0[015-9]|10))|36(?:(?:0[1-36-9]|4[7-9]|5[49]|6[02]|99)[0-9]|7(?:[35][0-9]|47)))|7(?:(?:5(?:7(?:5[0-8]|0[0-57]|[239][0-9]|6[37]|7[79]|[18]7|4[0-9])|0(?:[1-489][0-9]|5[0-378]|7[0-5]|[06][0-9])|5(?:[0-47-9][0-9]|6[0-8]|5[0-7])|2(?:[1-9][0-9]|0[0-6])|4(?:[0-24-9][0-9]|3[0-2])|(?:[389][0-9]|[16][0-9])[0-9])|8(?:(?:[1-359][0-9]|[478][0-9])[0-9]|0(?:[0-8][0-9]|9[0-9])|6(?:[1-9][0-9]|0[0-9]))|7(?:(?:[6-9][0-9]|5[0-6]|0[0-9])[0-9]|1(?:[0-46-8][0-9]|9[0-4]|5[0-9]))|6(?:(?:[1-57-9][0-9]|69)[0-9]|0(?:[1-9][0-9]|0[0-9])))[0-9]|0000[0-4]))[0-9][0-9][0-9])))\z/
}

sub RE_PFX() {
    qr/(?:(?:3651)?(?:[047-9]|16(?:1[013-578]|2[1356]|6[04-6]|3[038]|5[479]|9[079]|[78]0|03|44))|(?:00|\+)33)/
}

sub operator
{
    my $num = Number::Phone::FR::subscriber(@_);
    return unless defined $num;
    $num .= '_' x (9 - length($num));
    if ("${num}FRTESFR0COMPFREEBOUYCOLTOVH MCI EQFRUPCFLEGOPJT3PROSPHONOPENHUBTNRJ JAG ORCASRR PAOPVOXBALNIOUTRBUYCBJTPINITIPDIALPLATOWNAVASEWAITNFMWSPMIASORIGNEOCSISTINCLTELCNWTIFUTURMIIAXLYGIBMARNECHMULEFRTHECDVENAFINCORILEONTLONPRIXEMESSENTDIABOPTIREMMAVIRBRETLISILPTLFINERHOVCELYDAUFDIDWFRMOAFONAIEXBICSLGPHLYCANERIAVMIINNEMOQUNAITNETWVGSFWENGBTSIGETGMBIUONOFTOBJVPSL3620COMCEASYIMSDMKSDTRATSTENSVCMAABABDMAFINGGSCOHERAKIOSVIADYOOTAICTCMRPFRMTGLOBMOTLMTPEMYSTWAREABPLERGAHPAFIDOMINUPIOVOMTARSPROVIMUZEOPDURAEMODETOIGTPMMTPMOXTEPRODA6TEADONCLEMELOQLINKLLEILNUMMCAZNETEOPWAPRCPTRANVASO440HADSLANELAPWAATTGCPODDEVOECOMEVMIEWAYFEBOFLEXGLOAGNTLGUYAGYPMHADRHALYHIGHNORNNUMENXTOPIOLPOLYPOMTSAPFSPMTSTMBTF1 THDTVASTW3TEYNOVZEMO123UACNCADISAMNEAPPEAPPSARAGASSAAVMMBEETBFINBUFRCALICAWICLIMCOENCOMGCPOMDFRADIMTESEYEURVEYESIGWAIKACINFSINGRIPARIPXTITLBKEYCKWAOLANELCNGLGC LITOLUXNMAQUMDIAMTOFMUNDNEOENEOINOTLNOTONTLSODBEONETOPSTP1SEPAJAPALOPAREPWLKR188SOCTSTMASWTFSYSESYSTTDF TECHTELNTERYTRAITYLIUPSAVELDVITSWAELWEAS" =~ m/^(3(?:6(?:7(?:7(?:[08][0-9][0-9][0-9][0-9].{116}|1[0-9][0-9][0-9][0-9].{484}|2[0-9][0-9][0-9][0-9].{196}|3[0-9][0-9][0-9][0-9].{328}|4[0-9][0-9][0-9][0-9].{156}|5[0-9][0-9][0-9][0-9].{292}|9[0-9][0-9][0-9][0-9].{148}|6[0-9][0-9][0-9][0-9].{56}|7[0-9][0-9][0-9][0-9].{52}|_____.{96})|2(?:[23][0-9][0-9][0-9][0-9].{112}|[01][0-9][0-9][0-9][0-9].{44}|[78][0-9][0-9][0-9][0-9].{36}|4[0-9][0-9][0-9][0-9].{188}|5[0-9][0-9][0-9][0-9].{268}|6[0-9][0-9][0-9][0-9].{28}|9[0-9][0-9][0-9][0-9].{60})|8(?:[23][0-9][0-9][0-9][0-9].{60}|[48][0-9][0-9][0-9][0-9].{88}|0[0-9][0-9][0-9][0-9].{196}|5[0-9][0-9][0-9][0-9].{320}|6[0-9][0-9][0-9][0-9].{168}|9[0-9][0-9][0-9][0-9].{460}|1[0-9][0-9][0-9][0-9].{36})|1(?:[239][0-9][0-9][0-9][0-9].{44}|4[0-9][0-9][0-9][0-9].{232}|8[0-9][0-9][0-9][0-9].{144}|0[0-9][0-9][0-9][0-9].{28}|1[0-9][0-9][0-9][0-9].{40}|7[0-9][0-9][0-9][0-9].{56}|5[0-9][0-9][0-9][0-9].{8})|6(?:[2-5][0-9][0-9][0-9][0-9].{64}|[16][0-9][0-9][0-9][0-9].{60}|0[0-9][0-9][0-9][0-9].{212}|8[0-9][0-9][0-9][0-9].{352}|7[0-9][0-9][0-9][0-9].{92}|9[0-9][0-9][0-9][0-9].{36}|_____.{52})|9(?:[47-9][0-9][0-9][0-9][0-9].{8}|[01][0-9][0-9][0-9][0-9].{92}|[23][0-9][0-9][0-9][0-9].{36}|5[0-9][0-9][0-9][0-9].{132}|6[0-9][0-9][0-9][0-9].{364}|_____.{52})|3(?:[016-8][0-9][0-9][0-9][0-9].{28}|[45][0-9][0-9][0-9][0-9].{128}|2[0-9][0-9][0-9][0-9].{404}|3[0-9][0-9][0-9][0-9].{240}|9[0-9][0-9][0-9][0-9].{276})|0(?:(?:[0-5][0-9][0-9][0-9][0-9]|_____).{4}|[89][0-9][0-9][0-9][0-9].{40}|6[0-9][0-9][0-9][0-9].{108}|7[0-9][0-9][0-9][0-9].{8})|4[0-6][0-9][0-9][0-9][0-9].{48})|6(?:7(?:[67][0-9][0-9][0-9][0-9].{56}|[89][0-9][0-9][0-9][0-9].{52}|1[0-9][0-9][0-9][0-9].{124}|0[0-9][0-9][0-9][0-9].{12}|2[0-9][0-9][0-9][0-9].{28}|3[0-9][0-9][0-9][0-9].{40}|4[0-9][0-9][0-9][0-9].{88}|5[0-9][0-9][0-9][0-9].{92}|_____.{4})|8(?:[1-5][0-9][0-9][0-9][0-9].{52}|[89][0-9][0-9][0-9][0-9].{88}|0[0-9][0-9][0-9][0-9].{172}|6[0-9][0-9][0-9][0-9].{56}|7[0-9][0-9][0-9][0-9].{28})|2(?:[5-9][0-9][0-9][0-9][0-9].{12}|[23][0-9][0-9][0-9][0-9].{8}|0[0-9][0-9][0-9][0-9].{20}|1[0-9][0-9][0-9][0-9].{36}|4[0-9][0-9][0-9][0-9].{28})|9(?:[0-5][0-9][0-9][0-9][0-9].{52}|[67][0-9][0-9][0-9][0-9].{40}|9[0-9][0-9][0-9][0-9].{172}|8[0-9][0-9][0-9][0-9].{28}|_____.{664})|6(?:[013-58][0-9][0-9][0-9][0-9].{40}|[26][0-9][0-9][0-9][0-9].{56}|[79][0-9][0-9][0-9][0-9].{72}|_____.{148})|0(?:[0-5][0-9][0-9][0-9][0-9].{12}|[7-9][0-9][0-9][0-9][0-9].{40}|6[0-9][0-9][0-9][0-9].{112}|_____.{4})|3(?:[014-9][0-9][0-9][0-9][0-9].{12}|2[0-9][0-9][0-9][0-9].{228}|3[0-9][0-9][0-9][0-9].{52}|_____.{444})|4(?:[3-9][0-9][0-9][0-9][0-9].{4}|[01][0-9][0-9][0-9][0-9].{12}|2[0-9][0-9][0-9][0-9].{40}|_____.{392})|5(?:[0-7][0-9][0-9][0-9][0-9].{4}|8[0-9][0-9][0-9][0-9].{60}|9[0-9][0-9][0-9][0-9].{56}|_____.{148})|1(?:[0-9][0-9][0-9][0-9][0-9].{20}|_____.{104}))|9(?:6(?:[7-9][0-9][0-9][0-9][0-9].{32}|[2-4][0-9][0-9][0-9][0-9].{8}|0[0-9][0-9][0-9][0-9].{16}|1[0-9][0-9][0-9][0-9].{56}|5[0-9][0-9][0-9][0-9].{12}|6[0-9][0-9][0-9][0-9].{44}|_____.{356})|2(?:[1378][0-9][0-9][0-9][0-9].{8}|[02][0-9][0-9][0-9][0-9].{12}|[45][0-9][0-9][0-9][0-9].{24}|[69][0-9][0-9][0-9][0-9].{40}|_____.{216})|0(?:[1-4][0-9][0-9][0-9][0-9].{40}|[578][0-9][0-9][0-9][0-9].{8}|[69][0-9][0-9][0-9][0-9].{12}|0[0-9][0-9][0-9][0-9].{16}|_____.{356})|7(?:[3-69][0-9][0-9][0-9][0-9].{8}|[01][0-9][0-9][0-9][0-9].{32}|[27][0-9][0-9][0-9][0-9].{12}|8[0-9][0-9][0-9][0-9].{40})|3(?:[124578][0-9][0-9][0-9][0-9].{8}|[06][0-9][0-9][0-9][0-9].{40}|3[0-9][0-9][0-9][0-9].{12}|9[0-9][0-9][0-9][0-9].{16})|8(?:[03-6][0-9][0-9][0-9][0-9].{20}|[1279][0-9][0-9][0-9][0-9].{40}|8[0-9][0-9][0-9][0-9].{12}|_____.{4})|5(?:(?:[346-9][0-9][0-9][0-9][0-9]|_____).{8}|[0-2][0-9][0-9][0-9][0-9].{24}|5[0-9][0-9][0-9][0-9].{12})|9(?:[0-578][0-9][0-9][0-9][0-9].{16}|9[0-9][0-9][0-9][0-9].{12}|6[0-9][0-9][0-9][0-9].{8}|_____.{4})|4(?:[0357-9][0-9][0-9][0-9][0-9].{8}|[14][0-9][0-9][0-9][0-9].{12}|[26][0-9][0-9][0-9][0-9].{40})|1(?:[02-8][0-9][0-9][0-9][0-9].{8}|1[0-9][0-9][0-9][0-9].{12}|9[0-9][0-9][0-9][0-9].{40}))|2(?:8(?:[0237][0-9][0-9][0-9][0-9].{12}|[4-6][0-9][0-9][0-9][0-9].{124}|1[0-9][0-9][0-9][0-9].{132}|9[0-9][0-9][0-9][0-9].{40}|8[0-9][0-9][0-9][0-9].{8}|_____.{200})|2(?:[2-58][0-9][0-9][0-9][0-9].{8}|[01][0-9][0-9][0-9][0-9].{12}|9[0-9][0-9][0-9][0-9].{304}|6[0-9][0-9][0-9][0-9].{60}|7[0-9][0-9][0-9][0-9].{56}|_____.{180})|5(?:[0359][0-9][0-9][0-9][0-9].{12}|[146][0-9][0-9][0-9][0-9].{32}|[27][0-9][0-9][0-9][0-9].{40}|8[0-9][0-9][0-9][0-9].{124}|_____.{216})|6(?:[7-9][0-9][0-9][0-9][0-9].{124}|[0-2][0-9][0-9][0-9][0-9].{12}|[3-5][0-9][0-9][0-9][0-9].{8}|6[0-9][0-9][0-9][0-9].{40}|_____.{4})|9(?:[3-689][0-9][0-9][0-9][0-9].{12}|[0-2][0-9][0-9][0-9][0-9].{40}|7[0-9][0-9][0-9][0-9].{44}|_____.{216})|0(?:[13-9][0-9][0-9][0-9][0-9].{8}|2[0-9][0-9][0-9][0-9].{104}|0[0-9][0-9][0-9][0-9].{16}|_____.{360})|7(?:[02-689][0-9][0-9][0-9][0-9].{12}|1[0-9][0-9][0-9][0-9].{124}|7[0-9][0-9][0-9][0-9].{8})|3(?:[0-4][0-9][0-9][0-9][0-9].{16}|[5-9][0-9][0-9][0-9][0-9].{32}|_____.{180})|4(?:[0-6][0-9][0-9][0-9][0-9].{24}|[7-9][0-9][0-9][0-9][0-9].{32}|_____.{52})|1(?:[1-9][0-9][0-9][0-9][0-9].{8}|0[0-9][0-9][0-9][0-9].{40}|_____.{216}))|8(?:6(?:[02-6][0-9][0-9][0-9][0-9].{12}|7[0-9][0-9][0-9][0-9].{172}|8[0-9][0-9][0-9][0-9].{108}|1[0-9][0-9][0-9][0-9].{44}|9[0-9][0-9][0-9][0-9].{84})|3(?:[0-2][0-9][0-9][0-9][0-9].{24}|[3-5][0-9][0-9][0-9][0-9].{12}|[679][0-9][0-9][0-9][0-9].{8}|8[0-9][0-9][0-9][0-9].{104})|4(?:[02-5][0-9][0-9][0-9][0-9].{12}|[89][0-9][0-9][0-9][0-9].{32}|[17][0-9][0-9][0-9][0-9].{8}|6[0-9][0-9][0-9][0-9].{188})|5(?:[5-8][0-9][0-9][0-9][0-9].{124}|[1-4][0-9][0-9][0-9][0-9].{32}|0[0-9][0-9][0-9][0-9].{12}|9[0-9][0-9][0-9][0-9].{36})|7(?:[1-5][0-9][0-9][0-9][0-9].{20}|[679][0-9][0-9][0-9][0-9].{12}|0[0-9][0-9][0-9][0-9].{84}|8[0-9][0-9][0-9][0-9].{88})|9(?:[04-9][0-9][0-9][0-9][0-9].{12}|1[0-9][0-9][0-9][0-9].{296}|3[0-9][0-9][0-9][0-9].{304}|2[0-9][0-9][0-9][0-9].{4})|0(?:[3-7][0-9][0-9][0-9][0-9].{8}|[089][0-9][0-9][0-9][0-9].{12}|[12][0-9][0-9][0-9][0-9].{16}|_____.{688})|2(?:[2-8][0-9][0-9][0-9][0-9].{12}|[09][0-9][0-9][0-9][0-9].{8}|1[0-9][0-9][0-9][0-9].{16}|_____.{120})|1(?:[0-8][0-9][0-9][0-9][0-9].{12}|9[0-9][0-9][0-9][0-9].{260})|8(?:[0-8][0-9][0-9][0-9][0-9].{12}|9[0-9][0-9][0-9][0-9].{384}))|1(?:6(?:[04-6][0-9][0-9][0-9][0-9].{12}|[2378][0-9][0-9][0-9][0-9].{84}|1[0-9][0-9][0-9][0-9].{332}|9[0-9][0-9][0-9][0-9].{16}|_____.{200})|9(?:[4-9][0-9][0-9][0-9][0-9].{8}|[23][0-9][0-9][0-9][0-9].{40}|0[0-9][0-9][0-9][0-9].{16}|1[0-9][0-9][0-9][0-9].{84}|_____.{216})|3(?:[0-47][0-9][0-9][0-9][0-9].{8}|[56][0-9][0-9][0-9][0-9].{16}|[89][0-9][0-9][0-9][0-9].{40}|_____.{148})|7(?:[2-9][0-9][0-9][0-9][0-9].{12}|0[0-9][0-9][0-9][0-9].{16}|1[0-9][0-9][0-9][0-9].{84}|_____.{180})|5(?:[3-9][0-9][0-9][0-9][0-9].{12}|[12][0-9][0-9][0-9][0-9].{8}|0[0-9][0-9][0-9][0-9].{40}|_____.{4})|8(?:[3-9][0-9][0-9][0-9][0-9].{8}|[02][0-9][0-9][0-9][0-9].{12}|1[0-9][0-9][0-9][0-9].{84}|_____.{4})|0(?:(?:[0-69][0-9][0-9][0-9][0-9]|_____).{8}|8[0-9][0-9][0-9][0-9].{108}|7[0-9][0-9][0-9][0-9].{16})|2(?:[1-57-9][0-9][0-9][0-9][0-9].{8}|[06][0-9][0-9][0-9][0-9].{12}|_____.{148})|1(?:[1-9][0-9][0-9][0-9][0-9].{8}|0[0-9][0-9][0-9][0-9].{12}|_____.{148})|4(?:[1-9][0-9][0-9][0-9][0-9].{8}|0[0-9][0-9][0-9][0-9].{12}|_____.{4}))|0(?:8(?:[4-6][0-9][0-9][0-9][0-9].{88}|[78][0-9][0-9][0-9][0-9].{236}|2[0-9][0-9][0-9][0-9].{132}|0[0-9][0-9][0-9][0-9].{12}|3[0-9][0-9][0-9][0-9].{24}|9[0-9][0-9][0-9][0-9].{44}|1[0-9][0-9][0-9][0-9].{8}|_____.{4})|7(?:[1-4][0-9][0-9][0-9][0-9].{8}|[08][0-9][0-9][0-9][0-9].{16}|[59][0-9][0-9][0-9][0-9].{24}|[67][0-9][0-9][0-9][0-9].{12}|_____.{4})|6(?:[23689][0-9][0-9][0-9][0-9].{20}|[145][0-9][0-9][0-9][0-9].{16}|7[0-9][0-9][0-9][0-9].{84}|0[0-9][0-9][0-9][0-9].{8}|_____.{356})|5(?:[0-37][0-9][0-9][0-9][0-9].{8}|[589][0-9][0-9][0-9][0-9].{20}|[46][0-9][0-9][0-9][0-9].{12}|_____.{24})|3(?:[2-9][0-9][0-9][0-9][0-9].{8}|0[0-9][0-9][0-9][0-9].{12}|1[0-9][0-9][0-9][0-9].{84})|1(?:[0-4][0-9][0-9][0-9][0-9].{288}|[5-9][0-9][0-9][0-9][0-9].{8}|_____.{52})|0(?:[1-9][0-9][0-9][0-9][0-9].{8}|0[0-9][0-9][0-9][0-9].{16}|_____.{180})|2(?:[1-9][0-9][0-9][0-9][0-9].{8}|0[0-9][0-9][0-9][0-9].{12})|4(?:[0-35-9][0-9][0-9][0-9][0-9].{8}|4[0-9][0-9][0-9][0-9].{12})|9(?:[0-9][0-9][0-9][0-9][0-9].{16}|_____.{4}))|5(?:6(?:[02-4][0-9][0-9][0-9][0-9].{12}|[6-8][0-9][0-9][0-9][0-9].{72}|1[0-9][0-9][0-9][0-9].{248}|9[0-9][0-9][0-9][0-9].{112}|5[0-9][0-9][0-9][0-9].{56}|_____.{232})|9(?:[1-4][0-9][0-9][0-9][0-9].{36}|[6-9][0-9][0-9][0-9][0-9].{28}|0[0-9][0-9][0-9][0-9].{116}|5[0-9][0-9][0-9][0-9].{56})|1(?:[0-6][0-9][0-9][0-9][0-9].{12}|[89][0-9][0-9][0-9][0-9].{20}|7[0-9][0-9][0-9][0-9].{28}|_____.{4})|8(?:[0-7][0-9][0-9][0-9][0-9].{44}|8[0-9][0-9][0-9][0-9].{56}|9[0-9][0-9][0-9][0-9].{28}|_____.{52})|4(?:(?:[4-9][0-9][0-9][0-9][0-9]|_____).{4}|[0-2][0-9][0-9][0-9][0-9].{12}|3[0-9][0-9][0-9][0-9].{8})|7(?:[0-8][0-9][0-9][0-9][0-9].{52}|9[0-9][0-9][0-9][0-9].{112}|_____.{8})|0(?:[0-8][0-9][0-9][0-9][0-9].{32}|9[0-9][0-9][0-9][0-9].{8}|_____.{52})|5(?:(?:[0-8][0-9][0-9][0-9][0-9]|_____).{4}|9[0-9][0-9][0-9][0-9].{108})|3(?:[0-7][0-9][0-9][0-9][0-9].{20}|[89][0-9][0-9][0-9][0-9].{12})|2(?:[0-9][0-9][0-9][0-9][0-9].{12}|_____.{796}))|3(?:1(?:[02-478][0-9][0-9][0-9][0-9].{8}|1[0-9][0-9][0-9][0-9].{28}|5[0-9][0-9][0-9][0-9].{12}|6[0-9][0-9][0-9][0-9].{84}|9[0-9][0-9][0-9][0-9].{24}|_____.{4})|6(?:[0159][0-9][0-9][0-9][0-9].{20}|[23][0-9][0-9][0-9][0-9].{16}|[6-8][0-9][0-9][0-9][0-9].{8}|4[0-9][0-9][0-9][0-9].{12}|_____.{96})|7(?:[4-8][0-9][0-9][0-9][0-9].{8}|[01][0-9][0-9][0-9][0-9].{12}|[23][0-9][0-9][0-9][0-9].{24}|9[0-9][0-9][0-9][0-9].{40}|_____.{4})|5(?:[0-267][0-9][0-9][0-9][0-9].{8}|[3-5][0-9][0-9][0-9][0-9].{12}|[89][0-9][0-9][0-9][0-9].{20}|_____.{52})|8(?:[06-9][0-9][0-9][0-9][0-9].{8}|[2-5][0-9][0-9][0-9][0-9].{12}|1[0-9][0-9][0-9][0-9].{40})|0(?:[1-9][0-9][0-9][0-9][0-9].{8}|0[0-9][0-9][0-9][0-9].{16}|_____.{520})|2(?:[1-9][0-9][0-9][0-9][0-9].{24}|0[0-9][0-9][0-9][0-9].{12}|_____.{4})|3(?:[1-9][0-9][0-9][0-9][0-9].{8}|0[0-9][0-9][0-9][0-9].{24})|9(?:[0-9][0-9][0-9][0-9][0-9].{16}|_____.{4})|4(?:[0-9][0-9][0-9][0-9][0-9].{8}|_____.{4}))|4(?:8(?:(?:6[0-9][0-9][0-9][0-9]|_____).{8}|[1-5][0-9][0-9][0-9][0-9].{236}|[089][0-9][0-9][0-9][0-9].{12}|7[0-9][0-9][0-9][0-9].{52})|4(?:[2-6][0-9][0-9][0-9][0-9].{12}|[01][0-9][0-9][0-9][0-9].{16}|[7-9][0-9][0-9][0-9][0-9].{8}|_____.{104})|6(?:[0-37][0-9][0-9][0-9][0-9].{236}|[4-6][0-9][0-9][0-9][0-9].{12}|[89][0-9][0-9][0-9][0-9].{8}|_____.{52})|9(?:[35-9][0-9][0-9][0-9][0-9].{32}|[014][0-9][0-9][0-9][0-9].{12}|2[0-9][0-9][0-9][0-9].{8}|_____.{356})|2(?:[0-7][0-9][0-9][0-9][0-9].{8}|[89][0-9][0-9][0-9][0-9].{12}|_____.{24})|1(?:[2-9][0-9][0-9][0-9][0-9].{8}|[01][0-9][0-9][0-9][0-9].{24}|_____.{4})|7(?:(?:[1-9][0-9][0-9][0-9][0-9]|_____).{8}|0[0-9][0-9][0-9][0-9].{12})|0(?:[0-9][0-9][0-9][0-9][0-9].{24}|_____.{520})|3(?:[0-9][0-9][0-9][0-9][0-9].{12}|_____.{356})|5(?:[0-9][0-9][0-9][0-9][0-9]|_____).{8}))|5(?:9(?:6(?:[02][0-9][0-9][0-9][0-9].{32}|[39][0-9][0-9][0-9][0-9].{12}|[45][0-9][0-9][0-9][0-9].{20}|[6-8][0-9][0-9][0-9][0-9].{8}|1[0-9][0-9][0-9][0-9].{128})|2(?:[0134][0-9][0-9][0-9][0-9].{20}|[56][0-9][0-9][0-9][0-9].{28}|[27][0-9][0-9][0-9][0-9].{8}|8[0-9][0-9][0-9][0-9].{448}|9[0-9][0-9][0-9][0-9].{16})|3(?:[015][0-9][0-9][0-9][0-9].{12}|[2-4][0-9][0-9][0-9][0-9].{16}|[7-9][0-9][0-9][0-9][0-9].{8}|6[0-9][0-9][0-9][0-9].{32})|5(?:[0-4][0-9][0-9][0-9][0-9].{8}|[67][0-9][0-9][0-9][0-9].{12}|[89][0-9][0-9][0-9][0-9].{32}|5[0-9][0-9][0-9][0-9].{44})|9(?:[1-4][0-9][0-9][0-9][0-9].{24}|[057][0-9][0-9][0-9][0-9].{8}|[68][0-9][0-9][0-9][0-9].{16}|9[0-9][0-9][0-9][0-9].{32})|4(?:[5-8][0-9][0-9][0-9][0-9].{24}|[1-4][0-9][0-9][0-9][0-9].{8}|0[0-9][0-9][0-9][0-9].{176}|9[0-9][0-9][0-9][0-9].{16})|0(?:[0-58][0-9][0-9][0-9][0-9].{8}|[67][0-9][0-9][0-9][0-9].{16}|9[0-9][0-9][0-9][0-9].{12})|1(?:[03-589][0-9][0-9][0-9][0-9].{16}|[267][0-9][0-9][0-9][0-9].{20}|1[0-9][0-9][0-9][0-9].{8})|7(?:[014-9][0-9][0-9][0-9][0-9].{8}|2[0-9][0-9][0-9][0-9].{20}|3[0-9][0-9][0-9][0-9].{12})|8(?:[1-8][0-9][0-9][0-9][0-9].{24}|[09][0-9][0-9][0-9][0-9].{8}))|2(?:7(?:[5-7][0-9][0-9][0-9][0-9].{36}|[03][0-9][0-9][0-9][0-9].{44}|9[0-9][0-9][0-9][0-9].{452}|1[0-9][0-9][0-9][0-9].{52}|2[0-9][0-9][0-9][0-9].{56}|4[0-9][0-9][0-9][0-9].{28}|8[0-9][0-9][0-9][0-9].{60})|5(?:[4-6][0-9][0-9][0-9][0-9].{72}|[01][0-9][0-9][0-9][0-9].{12}|[23][0-9][0-9][0-9][0-9].{56}|[78][0-9][0-9][0-9][0-9].{44}|9[0-9][0-9][0-9][0-9].{112})|8(?:[35-7][0-9][0-9][0-9][0-9].{28}|[048][0-9][0-9][0-9][0-9].{88}|1[0-9][0-9][0-9][0-9].{52}|2[0-9][0-9][0-9][0-9].{56}|9[0-9][0-9][0-9][0-9].{36})|4(?:[6-9][0-9][0-9][0-9][0-9].{12}|[0-3][0-9][0-9][0-9][0-9].{4}|4[0-9][0-9][0-9][0-9].{108}|5[0-9][0-9][0-9][0-9].{40})|9(?:[3-9][0-9][0-9][0-9][0-9].{28}|0[0-9][0-9][0-9][0-9].{60}|1[0-9][0-9][0-9][0-9].{92}|2[0-9][0-9][0-9][0-9].{56})|6(?:[3-9][0-9][0-9][0-9][0-9].{44}|[01][0-9][0-9][0-9][0-9].{52}|2[0-9][0-9][0-9][0-9].{112})|2(?:[0-7][0-9][0-9][0-9][0-9].{12}|[89][0-9][0-9][0-9][0-9].{4})|0(?:[013-9][0-9][0-9][0-9][0-9].{12}|2[0-9][0-9][0-9][0-9].{36})|1(?:[0-8][0-9][0-9][0-9][0-9].{20}|9[0-9][0-9][0-9][0-9].{12})|3[0-9][0-9][0-9][0-9][0-9].{4})|4(?:6(?:[4-7][0-9][0-9][0-9][0-9].{8}|[13][0-9][0-9][0-9][0-9].{20}|[89][0-9][0-9][0-9][0-9].{32}|0[0-9][0-9][0-9][0-9].{12}|2[0-9][0-9][0-9][0-9].{40})|7(?:[14578][0-9][0-9][0-9][0-9].{20}|[39][0-9][0-9][0-9][0-9].{8}|6[0-9][0-9][0-9][0-9].{108}|0[0-9][0-9][0-9][0-9].{32}|2[0-9][0-9][0-9][0-9].{12})|8(?:[0-35-7][0-9][0-9][0-9][0-9].{8}|9[0-9][0-9][0-9][0-9].{364}|4[0-9][0-9][0-9][0-9].{12}|8[0-9][0-9][0-9][0-9].{40})|1(?:[24-689][0-9][0-9][0-9][0-9].{8}|[013][0-9][0-9][0-9][0-9].{16}|7[0-9][0-9][0-9][0-9].{60})|5(?:[1-59][0-9][0-9][0-9][0-9].{8}|[6-8][0-9][0-9][0-9][0-9].{20}|0[0-9][0-9][0-9][0-9].{12})|0(?:[15-9][0-9][0-9][0-9][0-9].{16}|[02-4][0-9][0-9][0-9][0-9].{8})|2(?:[0-37-9][0-9][0-9][0-9][0-9].{8}|[4-6][0-9][0-9][0-9][0-9].{24})|4(?:[2-9][0-9][0-9][0-9][0-9].{8}|[01][0-9][0-9][0-9][0-9].{12})|9(?:[0-46-9][0-9][0-9][0-9][0-9].{16}|5[0-9][0-9][0-9][0-9].{8})|3[0-9][0-9][0-9][0-9][0-9].{8})|5(?:5(?:[37-9][0-9][0-9][0-9][0-9].{12}|[0-2][0-9][0-9][0-9][0-9].{24}|[45][0-9][0-9][0-9][0-9].{84}|6[0-9][0-9][0-9][0-9].{8})|7(?:[1-3][0-9][0-9][0-9][0-9].{12}|[4-68][0-9][0-9][0-9][0-9].{8}|[09][0-9][0-9][0-9][0-9].{16}|7[0-9][0-9][0-9][0-9].{40})|3(?:[124-7][0-9][0-9][0-9][0-9].{12}|[89][0-9][0-9][0-9][0-9].{24}|3[0-9][0-9][0-9][0-9].{156}|0[0-9][0-9][0-9][0-9].{8})|2(?:[5-9][0-9][0-9][0-9][0-9].{12}|[1-4][0-9][0-9][0-9][0-9].{8}|0[0-9][0-9][0-9][0-9].{40})|0(?:[0135-9][0-9][0-9][0-9][0-9].{8}|2[0-9][0-9][0-9][0-9].{12}|4[0-9][0-9][0-9][0-9].{40})|6(?:[1-79][0-9][0-9][0-9][0-9].{12}|0[0-9][0-9][0-9][0-9].{16}|8[0-9][0-9][0-9][0-9].{8})|8(?:[1-79][0-9][0-9][0-9][0-9].{8}|0[0-9][0-9][0-9][0-9].{40}|8[0-9][0-9][0-9][0-9].{12})|1(?:[2-9][0-9][0-9][0-9][0-9].{8}|[01][0-9][0-9][0-9][0-9].{16})|9(?:[1-9][0-9][0-9][0-9][0-9].{8}|0[0-9][0-9][0-9][0-9].{12})|4[0-9][0-9][0-9][0-9][0-9].{24})|7(?:5(?:[0-29][0-9][0-9][0-9][0-9].{12}|[45][0-9][0-9][0-9][0-9].{172}|[37][0-9][0-9][0-9][0-9].{40}|[68][0-9][0-9][0-9][0-9].{44})|9(?:[235-8][0-9][0-9][0-9][0-9].{4}|[01][0-9][0-9][0-9][0-9].{20}|9[0-9][0-9][0-9][0-9].{172}|4[0-9][0-9][0-9][0-9].{12})|7(?:[0-468][0-9][0-9][0-9][0-9].{12}|5[0-9][0-9][0-9][0-9].{56}|7[0-9][0-9][0-9][0-9].{36}|9[0-9][0-9][0-9][0-9].{4})|2(?:[0-7][0-9][0-9][0-9][0-9].{32}|8[0-9][0-9][0-9][0-9].{40}|9[0-9][0-9][0-9][0-9].{8})|1(?:[3-9][0-9][0-9][0-9][0-9].{32}|[0-2][0-9][0-9][0-9][0-9].{8})|3(?:[0-8][0-9][0-9][0-9][0-9].{12}|9[0-9][0-9][0-9][0-9].{20})|4(?:[0-79][0-9][0-9][0-9][0-9].{12}|8[0-9][0-9][0-9][0-9].{88})|0(?:[0-8][0-9][0-9][0-9][0-9].{8}|9[0-9][0-9][0-9][0-9].{12})|6[0-9][0-9][0-9][0-9][0-9].{12}|8[0-9][0-9][0-9][0-9][0-9].{20})|1(?:8(?:[3679][0-9][0-9][0-9][0-9].{24}|[024][0-9][0-9][0-9][0-9].{12}|5[0-9][0-9][0-9][0-9].{40}|8[0-9][0-9][0-9][0-9].{44}|1[0-9][0-9][0-9][0-9].{8})|1(?:[014-8][0-9][0-9][0-9][0-9].{8}|2[0-9][0-9][0-9][0-9].{32}|3[0-9][0-9][0-9][0-9].{84}|9[0-9][0-9][0-9][0-9].{28})|6(?:[0-49][0-9][0-9][0-9][0-9].{8}|[578][0-9][0-9][0-9][0-9].{20}|6[0-9][0-9][0-9][0-9].{24})|7(?:[13468][0-9][0-9][0-9][0-9].{20}|[2579][0-9][0-9][0-9][0-9].{24}|0[0-9][0-9][0-9][0-9].{8})|0(?:[2-7][0-9][0-9][0-9][0-9].{16}|[0189][0-9][0-9][0-9][0-9].{8})|3(?:[2-46-9][0-9][0-9][0-9][0-9].{8}|[015][0-9][0-9][0-9][0-9].{12})|2(?:[0-46-9][0-9][0-9][0-9][0-9].{8}|5[0-9][0-9][0-9][0-9].{128})|5(?:[0-689][0-9][0-9][0-9][0-9].{8}|7[0-9][0-9][0-9][0-9].{84})|9[0-9][0-9][0-9][0-9][0-9].{16}|4[0-9][0-9][0-9][0-9][0-9].{8})|8(?:6(?:[5-8][0-9][0-9][0-9][0-9].{16}|[019][0-9][0-9][0-9][0-9].{12}|[2-4][0-9][0-9][0-9][0-9].{8})|4(?:[1-7][0-9][0-9][0-9][0-9].{8}|[89][0-9][0-9][0-9][0-9].{12}|0[0-9][0-9][0-9][0-9].{24})|7(?:[1-6][0-9][0-9][0-9][0-9].{12}|[7-9][0-9][0-9][0-9][0-9].{8}|0[0-9][0-9][0-9][0-9].{16})|8(?:[015-79][0-9][0-9][0-9][0-9].{8}|[238][0-9][0-9][0-9][0-9].{12}|4[0-9][0-9][0-9][0-9].{40})|9(?:[1-8][0-9][0-9][0-9][0-9].{8}|0[0-9][0-9][0-9][0-9].{40}|9[0-9][0-9][0-9][0-9].{12})|[23][0-9][0-9][0-9][0-9][0-9].{24}|[01][0-9][0-9][0-9][0-9][0-9].{8}|5[0-9][0-9][0-9][0-9][0-9].{12})|3(?:1(?:[6-9][0-9][0-9][0-9][0-9].{52}|[0-2][0-9][0-9][0-9][0-9].{36}|4[0-9][0-9][0-9][0-9].{116}|5[0-9][0-9][0-9][0-9].{48}|3[0-9][0-9][0-9][0-9].{8})|3(?:[3-9][0-9][0-9][0-9][0-9].{48}|2[0-9][0-9][0-9][0-9].{276}|0[0-9][0-9][0-9][0-9].{52}|1[0-9][0-9][0-9][0-9].{8})|2(?:[0-25-9][0-9][0-9][0-9][0-9].{52}|4[0-9][0-9][0-9][0-9].{132}|3[0-9][0-9][0-9][0-9].{40})|0(?:[2-9][0-9][0-9][0-9][0-9].{36}|0[0-9][0-9][0-9][0-9].{92})|4[0-7][0-9][0-9][0-9][0-9].{48})|6(?:3(?:[5-9][0-9][0-9][0-9][0-9].{48}|[014][0-9][0-9][0-9][0-9].{52}|3[0-9][0-9][0-9][0-9].{340}|2[0-9][0-9][0-9][0-9].{8})|1(?:[13-5][0-9][0-9][0-9][0-9].{60}|[6-9][0-9][0-9][0-9][0-9].{52}|0[0-9][0-9][0-9][0-9].{36}|2[0-9][0-9][0-9][0-9].{8})|2(?:[0-37-9][0-9][0-9][0-9][0-9].{52}|[45][0-9][0-9][0-9][0-9].{40}|6[0-9][0-9][0-9][0-9].{132})|(?:5[0-2]|4[0-9])[0-9][0-9][0-9][0-9].{48}|0[0-9][0-9][0-9][0-9][0-9].{36}))|7(?:2(?:8(?:[05][0-9][0-9][0-9][0-9].{60}|1[0-9][0-9][0-9][0-9].{372}|3[0-9][0-9][0-9][0-9].{176}|7[0-9][0-9][0-9][0-9].{352}|2[0-9][0-9][0-9][0-9].{56}|4[0-9][0-9][0-9][0-9].{92}|6[0-9][0-9][0-9][0-9].{40}|8[0-9][0-9][0-9][0-9].{88}|9[0-9][0-9][0-9][0-9].{44})|4(?:[23][0-9][0-9][0-9][0-9].{112}|[4-6][0-9][0-9][0-9][0-9].{52}|[89][0-9][0-9][0-9][0-9].{36}|1[0-9][0-9][0-9][0-9].{44}|7[0-9][0-9][0-9][0-9].{28}|0[0-9][0-9][0-9][0-9].{8})|9(?:[5-8][0-9][0-9][0-9][0-9].{36}|[49][0-9][0-9][0-9][0-9].{60}|0[0-9][0-9][0-9][0-9].{92}|2[0-9][0-9][0-9][0-9].{56}|3[0-9][0-9][0-9][0-9].{40}|1[0-9][0-9][0-9][0-9].{8})|6(?:[24-7][0-9][0-9][0-9][0-9].{28}|[01][0-9][0-9][0-9][0-9].{128}|8[0-9][0-9][0-9][0-9].{668}|3[0-9][0-9][0-9][0-9].{20}|9[0-9][0-9][0-9][0-9].{40})|5(?:[2-4689][0-9][0-9][0-9][0-9].{28}|7[0-9][0-9][0-9][0-9].{108}|0[0-9][0-9][0-9][0-9].{84}|1[0-9][0-9][0-9][0-9].{60}|5[0-9][0-9][0-9][0-9].{56})|2(?:[5689][0-9][0-9][0-9][0-9].{44}|[2-4][0-9][0-9][0-9][0-9].{72}|[01][0-9][0-9][0-9][0-9].{12}|7[0-9][0-9][0-9][0-9].{308})|7(?:[5-9][0-9][0-9][0-9][0-9].{28}|[01][0-9][0-9][0-9][0-9].{168}|[23][0-9][0-9][0-9][0-9].{56}|4[0-9][0-9][0-9][0-9].{12})|1(?:[16-9][0-9][0-9][0-9][0-9].{12}|[3-5][0-9][0-9][0-9][0-9].{40}|2[0-9][0-9][0-9][0-9].{56}|0[0-9][0-9][0-9][0-9].{4})|3(?:[0-35-7][0-9][0-9][0-9][0-9].{44}|8[0-9][0-9][0-9][0-9].{112}|4[0-9][0-9][0-9][0-9].{40}|9[0-9][0-9][0-9][0-9].{28})|0[0-9][0-9][0-9][0-9][0-9].{4})|4(?:2(?:[01][0-9][0-9][0-9][0-9].{28}|8[0-9][0-9][0-9][0-9].{116}|9[0-9][0-9][0-9][0-9].{328}|2[0-9][0-9][0-9][0-9].{60}|4[0-9][0-9][0-9][0-9].{44}|5[0-9][0-9][0-9][0-9].{92}|6[0-9][0-9][0-9][0-9].{40}|7[0-9][0-9][0-9][0-9].{12})|0(?:[1569][0-9][0-9][0-9][0-9].{28}|[23][0-9][0-9][0-9][0-9].{112}|7[0-9][0-9][0-9][0-9].{244}|8[0-9][0-9][0-9][0-9].{476}|4[0-9][0-9][0-9][0-9].{44}|0[0-9][0-9][0-9][0-9].{8})|9(?:[0-3][0-9][0-9][0-9][0-9].{64}|[78][0-9][0-9][0-9][0-9].{36}|5[0-9][0-9][0-9][0-9].{388}|4[0-9][0-9][0-9][0-9].{60}|6[0-9][0-9][0-9][0-9].{28}|9[0-9][0-9][0-9][0-9].{40})|8(?:[6-9][0-9][0-9][0-9][0-9].{64}|[013][0-9][0-9][0-9][0-9].{60}|2[0-9][0-9][0-9][0-9].{164}|4[0-9][0-9][0-9][0-9].{216}|5[0-9][0-9][0-9][0-9].{432})|3(?:[3-8][0-9][0-9][0-9][0-9].{36}|1[0-9][0-9][0-9][0-9].{384}|2[0-9][0-9][0-9][0-9].{292}|9[0-9][0-9][0-9][0-9].{116}|0[0-9][0-9][0-9][0-9].{92})|4(?:[014-6][0-9][0-9][0-9][0-9].{8}|[23][0-9][0-9][0-9][0-9].{40}|7[0-9][0-9][0-9][0-9].{104}|8[0-9][0-9][0-9][0-9].{324}|9[0-9][0-9][0-9][0-9].{48})|7(?:[89][0-9][0-9][0-9][0-9].{60}|4[0-9][0-9][0-9][0-9].{212}|6[0-9][0-9][0-9][0-9].{168}|5[0-9][0-9][0-9][0-9].{44}|7[0-9][0-9][0-9][0-9].{28})|1(?:[2-7][0-9][0-9][0-9][0-9].{36}|[89][0-9][0-9][0-9][0-9].{28}|1[0-9][0-9][0-9][0-9].{196})|5(?:[1-9][0-9][0-9][0-9][0-9].{48}|0[0-9][0-9][0-9][0-9].{412})|6[0-5][0-9][0-9][0-9][0-9].{48})|3(?:8(?:[08][0-9][0-9][0-9][0-9].{88}|[67][0-9][0-9][0-9][0-9].{36}|4[0-9][0-9][0-9][0-9].{424}|9[0-9][0-9][0-9][0-9].{108}|1[0-9][0-9][0-9][0-9].{60}|2[0-9][0-9][0-9][0-9].{40}|3[0-9][0-9][0-9][0-9].{56}|5[0-9][0-9][0-9][0-9].{92})|7(?:[27][0-9][0-9][0-9][0-9].{136}|[689][0-9][0-9][0-9][0-9].{36}|[01][0-9][0-9][0-9][0-9].{28}|[34][0-9][0-9][0-9][0-9].{56}|5[0-9][0-9][0-9][0-9].{252})|9(?:[4-7][0-9][0-9][0-9][0-9].{36}|[0-2][0-9][0-9][0-9][0-9].{28}|9[0-9][0-9][0-9][0-9].{172}|3[0-9][0-9][0-9][0-9].{56}|8[0-9][0-9][0-9][0-9].{84})|2(?:[1-489][0-9][0-9][0-9][0-9].{44}|5[0-9][0-9][0-9][0-9].{108}|6[0-9][0-9][0-9][0-9].{124}|0[0-9][0-9][0-9][0-9].{12}|7[0-9][0-9][0-9][0-9].{28})|5(?:[37-9][0-9][0-9][0-9][0-9].{28}|[0-2][0-9][0-9][0-9][0-9].{36}|[56][0-9][0-9][0-9][0-9].{128}|4[0-9][0-9][0-9][0-9].{428})|1(?:[4-9][0-9][0-9][0-9][0-9].{12}|[01][0-9][0-9][0-9][0-9].{4}|2[0-9][0-9][0-9][0-9].{108}|3[0-9][0-9][0-9][0-9].{40})|4(?:[0-4][0-9][0-9][0-9][0-9].{44}|[6-9][0-9][0-9][0-9][0-9].{52}|5[0-9][0-9][0-9][0-9].{112})|6(?:[014-9][0-9][0-9][0-9][0-9].{28}|3[0-9][0-9][0-9][0-9].{136}|2[0-9][0-9][0-9][0-9].{60})|3[0-9][0-9][0-9][0-9][0-9].{44}|0[0-9][0-9][0-9][0-9][0-9].{4})|0(?:8(?:[1-6][0-9][0-9][0-9][0-9].{4}|[89][0-9][0-9][0-9][0-9].{56}|7[0-9][0-9][0-9][0-9].{108}|0[0-9][0-9][0-9][0-9].{36})|4(?:[3-9][0-9][0-9][0-9][0-9].{12}|[01][0-9][0-9][0-9][0-9].{32}|2[0-9][0-9][0-9][0-9].{28})|9(?:[015-8][0-9][0-9][0-9][0-9].{12}|[2-4][0-9][0-9][0-9][0-9].{40}|9[0-9][0-9][0-9][0-9].{56})|0(?:[4-9][0-9][0-9][0-9][0-9].{8}|[1-3][0-9][0-9][0-9][0-9].{12}|0[0-9][0-9][0-9][0-9].{16})|2(?:[2-8][0-9][0-9][0-9][0-9].{8}|[01][0-9][0-9][0-9][0-9].{40}|9[0-9][0-9][0-9][0-9].{32})|5(?:[0-7][0-9][0-9][0-9][0-9].{20}|[89][0-9][0-9][0-9][0-9].{12})|6(?:[4-9][0-9][0-9][0-9][0-9].{4}|[0-3][0-9][0-9][0-9][0-9].{12})|7(?:[0-8][0-9][0-9][0-9][0-9].{12}|9[0-9][0-9][0-9][0-9].{4})|3[0-9][0-9][0-9][0-9][0-9].{32}|1[0-9][0-9][0-9][0-9][0-9].{8})|5(?:4(?:[2-4][0-9][0-9][0-9][0-9].{40}|[16][0-9][0-9][0-9][0-9].{8}|0[0-9][0-9][0-9][0-9].{960}|7[0-9][0-9][0-9][0-9].{364}|9[0-9][0-9][0-9][0-9].{420}|5[0-9][0-9][0-9][0-9].{44}|8[0-9][0-9][0-9][0-9].{60})|2(?:[147][0-9][0-9][0-9][0-9].{60}|[356][0-9][0-9][0-9][0-9].{92}|0[0-9][0-9][0-9][0-9].{44}|2[0-9][0-9][0-9][0-9].{36}|8[0-9][0-9][0-9][0-9].{40})|0(?:[1-5][0-9][0-9][0-9][0-9].{28}|[6-9][0-9][0-9][0-9][0-9].{56}|0[0-9][0-9][0-9][0-9].{128})|1(?:[4-689][0-9][0-9][0-9][0-9].{60}|[0-3][0-9][0-9][0-9][0-9].{28}|7[0-9][0-9][0-9][0-9].{244})|5(?:[1-9][0-9][0-9][0-9][0-9].{48}|0[0-9][0-9][0-9][0-9].{8})|6[0-5][0-9][0-9][0-9][0-9].{48}|3[0-9][0-9][0-9][0-9][0-9].{36})|1(?:4(?:[6-9][0-9][0-9][0-9][0-9].{20}|[0-2][0-9][0-9][0-9][0-9].{28}|[3-5][0-9][0-9][0-9][0-9].{12})|1(?:[0-46-8][0-9][0-9][0-9][0-9].{8}|5[0-9][0-9][0-9][0-9].{12}|9[0-9][0-9][0-9][0-9].{40})|5(?:[0-5][0-9][0-9][0-9][0-9].{20}|[6-9][0-9][0-9][0-9][0-9].{12})|6(?:[2-9][0-9][0-9][0-9][0-9].{12}|[01][0-9][0-9][0-9][0-9].{20})|8(?:[0-57-9][0-9][0-9][0-9][0-9].{12}|6[0-9][0-9][0-9][0-9].{36})|9(?:[1-9][0-9][0-9][0-9][0-9].{4}|0[0-9][0-9][0-9][0-9].{12})|[23][0-9][0-9][0-9][0-9][0-9].{32}|7[0-9][0-9][0-9][0-9][0-9].{12}|0[0-9][0-9][0-9][0-9][0-9].{8})|9(?:0(?:[0-7][0-9][0-9][0-9][0-9].{36}|8[0-9][0-9][0-9][0-9].{60}|9[0-9][0-9][0-9][0-9].{40})|1(?:[1-9][0-9][0-9][0-9][0-9].{48}|0[0-9][0-9][0-9][0-9].{276})|(?:3[01]|2[0-9])[0-9][0-9][0-9][0-9].{48}))|2(?:8(?:0(?:[0-9][0-9][0-9][0-9][0-9].{4}|_____.{688})|2(?:[0-9][0-9][0-9][0-9][0-9].{4}|_____.{200})|3(?:[0-9][0-9][0-9][0-9][0-9].{4}|_____.{148})|4(?:[0-9][0-9][0-9][0-9][0-9].{4}|_____.{148})|5(?:[0-9][0-9][0-9][0-9][0-9].{4}|_____.{200})|6(?:[0-9][0-9][0-9][0-9][0-9].{4}|_____.{148})|8(?:[0-9][0-9][0-9][0-9][0-9].{4}|_____.{912})|9(?:[0-9][0-9][0-9][0-9][0-9].{4}|_____.{200})|7(?:[0-9][0-9][0-9][0-9][0-9].{4}|_____.{8})|1[0-9][0-9][0-9][0-9][0-9].{4})|1(?:(?:2(?:[0-9][0-9][0-9][0-9][0-9]|_____)|7[0-9][0-9][0-9][0-9][0-9]).{4}|1(?:[0-9][0-9][0-9][0-9][0-9].{4}|_____.{148})|3(?:[0-9][0-9][0-9][0-9][0-9].{4}|_____.{204})|4(?:[0-9][0-9][0-9][0-9][0-9].{4}|_____.{200})|6(?:[0-9][0-9][0-9][0-9][0-9].{4}|_____.{176})|9(?:[0-9][0-9][0-9][0-9][0-9].{4}|_____.{104})|0(?:[0-9][0-9][0-9][0-9][0-9].{4}|_____.{52})|5(?:[0-9][0-9][0-9][0-9][0-9].{4}|_____.{84})|8(?:[0-9][0-9][0-9][0-9][0-9].{4}|_____.{8}))|5(?:(?:8(?:[0-9][0-9][0-9][0-9][0-9]|_____)|5[0-9][0-9][0-9][0-9][0-9]).{4}|0(?:[0-9][0-9][0-9][0-9][0-9].{4}|_____.{868})|2(?:[0-9][0-9][0-9][0-9][0-9].{4}|_____.{176})|3(?:[0-9][0-9][0-9][0-9][0-9].{4}|_____.{148})|4(?:[0-9][0-9][0-9][0-9][0-9].{4}|_____.{148})|7(?:[0-9][0-9][0-9][0-9][0-9].{4}|_____.{148})|9(?:[0-9][0-9][0-9][0-9][0-9].{4}|_____.{148})|1(?:[0-9][0-9][0-9][0-9][0-9].{4}|_____.{8})|6(?:[0-9][0-9][0-9][0-9][0-9].{4}|_____.{8}))|0(?:(?:3(?:[0-9][0-9][0-9][0-9][0-9]|_____)|7[0-9][0-9][0-9][0-9][0-9]).{4}|0(?:[0-9][0-9][0-9][0-9][0-9].{4}|_____.{736})|2(?:[0-9][0-9][0-9][0-9][0-9].{4}|_____.{200})|5(?:[0-9][0-9][0-9][0-9][0-9].{4}|_____.{392})|6(?:[0-9][0-9][0-9][0-9][0-9].{4}|_____.{204})|8(?:[0-9][0-9][0-9][0-9][0-9].{4}|_____.{148})|1(?:[0-9][0-9][0-9][0-9][0-9].{4}|_____.{52})|4(?:[0-9][0-9][0-9][0-9][0-9].{4}|_____.{8})|9(?:[0-9][0-9][0-9][0-9][0-9].{4}|_____.{8}))|3(?:(?:7(?:[0-9][0-9][0-9][0-9][0-9]|_____)|8[0-9][0-9][0-9][0-9][0-9]).{4}|0(?:[0-9][0-9][0-9][0-9][0-9].{4}|_____.{104})|6(?:[0-9][0-9][0-9][0-9][0-9].{4}|_____.{148})|9(?:[0-9][0-9][0-9][0-9][0-9].{4}|_____.{200})|2(?:[0-9][0-9][0-9][0-9][0-9].{4}|_____.{24})|4(?:[0-9][0-9][0-9][0-9][0-9].{4}|_____.{52})|5(?:[0-9][0-9][0-9][0-9][0-9].{4}|_____.{52})|1(?:[0-9][0-9][0-9][0-9][0-9].{4}|_____.{8})|3(?:[0-9][0-9][0-9][0-9][0-9].{4}|_____.{8}))|7(?:1(?:[0-9][0-9][0-9][0-9][0-9].{4}|_____.{148})|4(?:[0-9][0-9][0-9][0-9][0-9].{4}|_____.{148})|6(?:[0-9][0-9][0-9][0-9][0-9].{4}|_____.{200})|7(?:[0-9][0-9][0-9][0-9][0-9].{4}|_____.{104})|8(?:[0-9][0-9][0-9][0-9][0-9].{4}|_____.{104})|9(?:[0-9][0-9][0-9][0-9][0-9].{4}|_____.{200})|0(?:[0-9][0-9][0-9][0-9][0-9].{4}|_____.{52})|2(?:[0-9][0-9][0-9][0-9][0-9].{4}|_____.{52})|[35](?:[0-9][0-9][0-9][0-9][0-9]|_____).{4})|2(?:(?:[03](?:[0-9][0-9][0-9][0-9][0-9]|_____)|1[0-9][0-9][0-9][0-9][0-9]).{4}|6(?:[0-9][0-9][0-9][0-9][0-9].{4}|_____.{216})|7(?:[0-9][0-9][0-9][0-9][0-9].{4}|_____.{180})|5(?:[0-9][0-9][0-9][0-9][0-9].{4}|_____.{52})|8(?:[0-9][0-9][0-9][0-9][0-9].{4}|_____.{52})|2(?:[0-9][0-9][0-9][0-9][0-9].{4}|_____.{8})|4(?:[0-9][0-9][0-9][0-9][0-9].{4}|_____.{8})|9(?:[0-9][0-9][0-9][0-9][0-9].{4}|_____.{8}))|4(?:2(?:[0-9][0-9][0-9][0-9][0-9].{4}|_____.{164})|7(?:[0-9][0-9][0-9][0-9][0-9].{4}|_____.{180})|8(?:[0-9][0-9][0-9][0-9][0-9].{4}|_____.{176})|9(?:[0-9][0-9][0-9][0-9][0-9].{4}|_____.{356})|4(?:[0-9][0-9][0-9][0-9][0-9].{4}|_____.{16})|[0135](?:[0-9][0-9][0-9][0-9][0-9]|_____).{4}|6(?:[0-9][0-9][0-9][0-9][0-9].{4}|_____.{8}))|6(?:(?:[06](?:[0-9][0-9][0-9][0-9][0-9]|_____)|[139][0-9][0-9][0-9][0-9][0-9]).{4}|5(?:[0-9][0-9][0-9][0-9][0-9].{4}|_____.{200})|7(?:[0-9][0-9][0-9][0-9][0-9].{4}|_____.{392})|8(?:[0-9][0-9][0-9][0-9][0-9].{4}|_____.{200})|2(?:[0-9][0-9][0-9][0-9][0-9].{4}|_____.{52})|4(?:[0-9][0-9][0-9][0-9][0-9].{4}|_____.{52}))|9(?:(?:2(?:[0-9][0-9][0-9][0-9][0-9]|_____)|[15-8][0-9][0-9][0-9][0-9][0-9]).{4}|0(?:[0-9][0-9][0-9][0-9][0-9].{4}|_____.{392})|3(?:[0-9][0-9][0-9][0-9][0-9].{4}|_____.{200})|9(?:[0-9][0-9][0-9][0-9][0-9].{4}|_____.{104})|4(?:[0-9][0-9][0-9][0-9][0-9].{4}|_____.{24})))|4(?:5(?:6(?:[4689][0-9][0-9][0-9][0-9].{20}|[2357][0-9][0-9][0-9][0-9].{8}|0[0-9][0-9][0-9][0-9].{12}|1[0-9][0-9][0-9][0-9].{16}|_____.{216})|0(?:[0135-7][0-9][0-9][0-9][0-9].{16}|[248][0-9][0-9][0-9][0-9].{8}|9[0-9][0-9][0-9][0-9].{32}|_____.{52})|1(?:[02-5][0-9][0-9][0-9][0-9].{16}|[17-9][0-9][0-9][0-9][0-9].{8}|6[0-9][0-9][0-9][0-9].{12})|4(?:[0-8][0-9][0-9][0-9][0-9].{8}|9[0-9][0-9][0-9][0-9].{84}|_____.{240})|5(?:[0-579][0-9][0-9][0-9][0-9].{8}|[68][0-9][0-9][0-9][0-9].{20}|_____.{4})|7(?:[4-9][0-9][0-9][0-9][0-9].{8}|[0-3][0-9][0-9][0-9][0-9].{20})|2(?:[0-8][0-9][0-9][0-9][0-9].{8}|9[0-9][0-9][0-9][0-9].{352})|8(?:[0-8][0-9][0-9][0-9][0-9].{8}|9[0-9][0-9][0-9][0-9].{12})|9[0-9][0-9][0-9][0-9][0-9].{16}|3[0-9][0-9][0-9][0-9][0-9].{8})|4(?:0(?:[0-9][0-9][0-9][0-9][0-9].{4}|_____.{200})|2(?:[0-9][0-9][0-9][0-9][0-9].{4}|_____.{104})|3(?:[0-9][0-9][0-9][0-9][0-9].{4}|_____.{360})|4(?:[0-9][0-9][0-9][0-9][0-9].{4}|_____.{148})|5(?:[0-9][0-9][0-9][0-9][0-9].{4}|_____.{104})|7(?:[0-9][0-9][0-9][0-9][0-9].{4}|_____.{204})|[1689][0-9][0-9][0-9][0-9][0-9].{4})|3(?:4_____.{180}|6_____.{240}|0_____.{52}|3_____.{8}|5_____.{4})|9(?:[3-7]_____.{312}|1_____.{164}|9_____.{4})|2(?:2_____.{488}|0_____.{4}|4_____.{8})|0(?:4_____.{180}|0_____.{8})|88_____.{488})|9(?:1(?:(?:[29](?:[0-9][0-9][0-9][0-9][0-9]|_____)|[58][0-9][0-9][0-9][0-9][0-9]).{4}|4(?:[0-9][0-9][0-9][0-9][0-9].{4}|_____.{240})|6(?:[0-9][0-9][0-9][0-9][0-9].{4}|_____.{144})|1(?:[0-9][0-9][0-9][0-9][0-9].{4}|_____.{52})|3(?:[0-9][0-9][0-9][0-9][0-9].{4}|_____.{24})|7(?:[0-9][0-9][0-9][0-9][0-9].{4}|_____.{24})|0(?:[0-9][0-9][0-9][0-9][0-9].{4}|_____.{8}))|0(?:(?:[01379](?:[0-9][0-9][0-9][0-9][0-9]|_____)|8[0-9][0-9][0-9][0-9][0-9]).{4}|2(?:[0-9][0-9][0-9][0-9][0-9].{4}|_____.{148})|4(?:[0-9][0-9][0-9][0-9][0-9].{4}|_____.{164})|5(?:[0-9][0-9][0-9][0-9][0-9].{4}|_____.{8})|6(?:[0-9][0-9][0-9][0-9][0-9].{4}|_____.{8}))|3(?:[26]_____.{52}|[35]_____.{4}|0_____.{520}|1_____.{120}|7_____.{200}|9_____.{8})|2(?:[09]_____.{8}|1_____.{144}|2_____.{488}|3_____.{776}|4_____.{24}|7_____.{4})|9(?:[12]_____.{8}|7_____.{860}|9_____.{180}|0_____.{40}|5_____.{52}|4_____.{4})|4(?:[36]_____.{356}|[04]_____.{4}|5_____.{180}|8_____.{216}|9_____.{52})|7(?:[05-7]_____.{4}|[19]_____.{120}|3_____.{216})|5(?:[57]_____.{4}|9_____.{356}|0_____.{64})|8(?:[09]_____.{4}|1_____.{216}|8_____.{8})|6(?:0_____.{120}|9_____.{180}|6_____.{4}))|39(?:2(?:[2-4][0-9][0-9][0-9][0-9].{52}|[589][0-9][0-9][0-9][0-9].{28}|1[0-9][0-9][0-9][0-9].{112}|7[0-9][0-9][0-9][0-9].{128}|0[0-9][0-9][0-9][0-9].{44}|6[0-9][0-9][0-9][0-9].{36})|0(?:[57-9][0-9][0-9][0-9][0-9].{44}|[01][0-9][0-9][0-9][0-9].{12}|[46][0-9][0-9][0-9][0-9].{40}|3[0-9][0-9][0-9][0-9].{212}|2[0-9][0-9][0-9][0-9].{8})|7(?:[4-7][0-9][0-9][0-9][0-9].{48}|2[0-9][0-9][0-9][0-9].{132}|0[0-9][0-9][0-9][0-9].{56}|1[0-9][0-9][0-9][0-9].{40}|3[0-9][0-9][0-9][0-9].{8})|4(?:[2-8][0-9][0-9][0-9][0-9].{36}|0[0-9][0-9][0-9][0-9].{212}|1[0-9][0-9][0-9][0-9].{92}|9[0-9][0-9][0-9][0-9].{60})|8(?:[4-7][0-9][0-9][0-9][0-9].{36}|[028][0-9][0-9][0-9][0-9].{88}|[139][0-9][0-9][0-9][0-9].{60})|3(?:[1-8][0-9][0-9][0-9][0-9].{28}|0[0-9][0-9][0-9][0-9].{212}|9[0-9][0-9][0-9][0-9].{56})|1(?:[2-9][0-9][0-9][0-9][0-9].{44}|[01][0-9][0-9][0-9][0-9].{364})|9(?:[1-9][0-9][0-9][0-9][0-9].{48}|0[0-9][0-9][0-9][0-9].{84})|50[0-9][0-9][0-9][0-9].{352})|1(?:0(?:9(?:[17-9][0-9][0-9][0-9][0-9].{12}|[346][0-9][0-9][0-9][0-9].{28}|[25][0-9][0-9][0-9][0-9].{8}|0[0-9][0-9][0-9][0-9].{236})|3(?:[2-6][0-9][0-9][0-9][0-9].{12}|[01][0-9][0-9][0-9][0-9].{16}|[7-9][0-9][0-9][0-9][0-9].{8}|_____.{4})|4(?:[1-46-9][0-9][0-9][0-9][0-9].{8}|0[0-9][0-9][0-9][0-9].{16}|5[0-9][0-9][0-9][0-9].{60})|0(?:[0-6][0-9][0-9][0-9][0-9].{24}|[7-9][0-9][0-9][0-9][0-9].{8}|_____.{20})|6(?:[1-689][0-9][0-9][0-9][0-9].{8}|[07][0-9][0-9][0-9][0-9].{12}|_____.{20})|7(?:[0-4][0-9][0-9][0-9][0-9].{12}|[5-9][0-9][0-9][0-9][0-9].{32})|2(?:[2-9][0-9][0-9][0-9][0-9].{12}|[01][0-9][0-9][0-9][0-9].{8})|5(?:[2-9][0-9][0-9][0-9][0-9].{8}|[01][0-9][0-9][0-9][0-9].{12})|8[0-9][0-9][0-9][0-9][0-9].{32}|1[0-9][0-9][0-9][0-9][0-9].{8})|1(?:[023]_____.{4}|[17]_____.{8}|6_____.{52})|3(?:[12]_____.{4}|0_____.{20})|2(?:[01]_____.{4}|3_____.{8})|55_____.{4}|90_____.{8})|0(?:0(?:[057]_____.{4}|[49]_____.{8}|2_____.{24})|3(?:[256]_____.{4}|[03]_____.{8}|1_____.{52})|2(?:[023]_____.{8}|[56]_____.{4})|1(?:[05]_____.{4}|7_____.{148})|9(?:9_____.{120}|0_____.{24})|5(?:0_____.{4}|5_____.{8})|(?:8[079]|60)_____.{4}|[47]0_____.{8})|8[0-9][0-9][0-9][0-9][0-9][0-9][0-9].{4})|4(?:8(?:4(?:3(?:[26][0-9][0-9][0-9][0-9].{112}|[7-9][0-9][0-9][0-9][0-9].{44}|0[0-9][0-9][0-9][0-9].{108}|1[0-9][0-9][0-9][0-9].{232}|4[0-9][0-9][0-9][0-9].{144}|3[0-9][0-9][0-9][0-9].{40}|5[0-9][0-9][0-9][0-9].{12})|8(?:[379][0-9][0-9][0-9][0-9].{28}|[45][0-9][0-9][0-9][0-9].{56}|1[0-9][0-9][0-9][0-9].{476}|2[0-9][0-9][0-9][0-9].{136}|6[0-9][0-9][0-9][0-9].{236}|8[0-9][0-9][0-9][0-9].{308}|0[0-9][0-9][0-9][0-9].{88})|4(?:[1-5][0-9][0-9][0-9][0-9].{44}|0[0-9][0-9][0-9][0-9].{292}|6[0-9][0-9][0-9][0-9].{268}|7[0-9][0-9][0-9][0-9].{112}|8[0-9][0-9][0-9][0-9].{56}|9[0-9][0-9][0-9][0-9].{28})|9(?:[2-7][0-9][0-9][0-9][0-9].{36}|1[0-9][0-9][0-9][0-9].{660}|9[0-9][0-9][0-9][0-9].{212}|0[0-9][0-9][0-9][0-9].{72}|8[0-9][0-9][0-9][0-9].{88})|5(?:[35-9][0-9][0-9][0-9][0-9].{64}|0[0-9][0-9][0-9][0-9].{104}|1[0-9][0-9][0-9][0-9].{28}|4[0-9][0-9][0-9][0-9].{56}|2[0-9][0-9][0-9][0-9].{8})|2(?:[0-4][0-9][0-9][0-9][0-9].{12}|[7-9][0-9][0-9][0-9][0-9].{108}|5[0-9][0-9][0-9][0-9].{28}|6[0-9][0-9][0-9][0-9].{8})|7(?:[0-3578][0-9][0-9][0-9][0-9].{64}|9[0-9][0-9][0-9][0-9].{384}|4[0-9][0-9][0-9][0-9].{56}|6[0-9][0-9][0-9][0-9].{12})|1(?:[5-9][0-9][0-9][0-9][0-9].{40}|[0-2][0-9][0-9][0-9][0-9].{4}|[34][0-9][0-9][0-9][0-9].{8})|6[0-9][0-9][0-9][0-9][0-9].{52}|0[0-9][0-9][0-9][0-9][0-9].{4})|6(?:8(?:[38][0-9][0-9][0-9][0-9].{132}|[59][0-9][0-9][0-9][0-9].{8}|0[0-9][0-9][0-9][0-9].{228}|4[0-9][0-9][0-9][0-9].{260}|6[0-9][0-9][0-9][0-9].{332}|7[0-9][0-9][0-9][0-9].{108}|1[0-9][0-9][0-9][0-9].{40}|2[0-9][0-9][0-9][0-9].{12})|2(?:[57-9][0-9][0-9][0-9][0-9].{24}|[26][0-9][0-9][0-9][0-9].{84}|[34][0-9][0-9][0-9][0-9].{16}|0[0-9][0-9][0-9][0-9].{12}|1[0-9][0-9][0-9][0-9].{40})|1(?:[03-5][0-9][0-9][0-9][0-9].{12}|[7-9][0-9][0-9][0-9][0-9].{8}|1[0-9][0-9][0-9][0-9].{156}|2[0-9][0-9][0-9][0-9].{40}|6[0-9][0-9][0-9][0-9].{84})|0(?:[02-5][0-9][0-9][0-9][0-9].{8}|[78][0-9][0-9][0-9][0-9].{16}|1[0-9][0-9][0-9][0-9].{60}|6[0-9][0-9][0-9][0-9].{32}|9[0-9][0-9][0-9][0-9].{12})|6(?:[2-59][0-9][0-9][0-9][0-9].{8}|[07][0-9][0-9][0-9][0-9].{12}|1[0-9][0-9][0-9][0-9].{40}|6[0-9][0-9][0-9][0-9].{84}|8[0-9][0-9][0-9][0-9].{56})|4(?:[1-49][0-9][0-9][0-9][0-9].{8}|[6-8][0-9][0-9][0-9][0-9].{16}|0[0-9][0-9][0-9][0-9].{12}|5[0-9][0-9][0-9][0-9].{24})|9(?:[013479][0-9][0-9][0-9][0-9].{8}|[25][0-9][0-9][0-9][0-9].{40}|6[0-9][0-9][0-9][0-9].{12}|8[0-9][0-9][0-9][0-9].{16})|7(?:[1-578][0-9][0-9][0-9][0-9].{8}|[069][0-9][0-9][0-9][0-9].{12})|3(?:[1-9][0-9][0-9][0-9][0-9].{8}|0[0-9][0-9][0-9][0-9].{12})|5(?:[0-57-9][0-9][0-9][0-9][0-9].{12}|6[0-9][0-9][0-9][0-9].{8}))|3(?:8(?:[08][0-9][0-9][0-9][0-9].{12}|[34][0-9][0-9][0-9][0-9].{84}|[5-7][0-9][0-9][0-9][0-9].{8}|1[0-9][0-9][0-9][0-9].{132}|2[0-9][0-9][0-9][0-9].{108}|9[0-9][0-9][0-9][0-9].{40})|5(?:[045][0-9][0-9][0-9][0-9].{40}|[1-3][0-9][0-9][0-9][0-9].{32}|6[0-9][0-9][0-9][0-9].{36}|8[0-9][0-9][0-9][0-9].{88}|9[0-9][0-9][0-9][0-9].{12}|7[0-9][0-9][0-9][0-9].{8})|4(?:[6-9][0-9][0-9][0-9][0-9].{32}|[01][0-9][0-9][0-9][0-9].{16}|[45][0-9][0-9][0-9][0-9].{40}|3[0-9][0-9][0-9][0-9].{104}|2[0-9][0-9][0-9][0-9].{8})|3(?:[124-69][0-9][0-9][0-9][0-9].{8}|3[0-9][0-9][0-9][0-9].{104}|0[0-9][0-9][0-9][0-9].{12}|7[0-9][0-9][0-9][0-9].{40}|8[0-9][0-9][0-9][0-9].{84})|9(?:[0-2458][0-9][0-9][0-9][0-9].{12}|6[0-9][0-9][0-9][0-9].{112}|3[0-9][0-9][0-9][0-9].{56}|7[0-9][0-9][0-9][0-9].{88}|9[0-9][0-9][0-9][0-9].{8})|0(?:[1-4][0-9][0-9][0-9][0-9].{16}|[57-9][0-9][0-9][0-9][0-9].{8}|[06][0-9][0-9][0-9][0-9].{12})|2(?:[2-5][0-9][0-9][0-9][0-9].{12}|[6-9][0-9][0-9][0-9][0-9].{8}|[01][0-9][0-9][0-9][0-9].{16})|7(?:[0-246-9][0-9][0-9][0-9][0-9].{12}|5[0-9][0-9][0-9][0-9].{108}|3[0-9][0-9][0-9][0-9].{56})|6(?:[0-4][0-9][0-9][0-9][0-9].{12}|[5-9][0-9][0-9][0-9][0-9].{20})|1(?:[0-24-6][0-9][0-9][0-9][0-9].{8}|[37-9][0-9][0-9][0-9][0-9].{12}))|2(?:7(?:[0-3][0-9][0-9][0-9][0-9].{64}|[89][0-9][0-9][0-9][0-9].{176}|4[0-9][0-9][0-9][0-9].{424}|5[0-9][0-9][0-9][0-9].{248}|7[0-9][0-9][0-9][0-9].{128}|6[0-9][0-9][0-9][0-9].{12})|8(?:[579][0-9][0-9][0-9][0-9].{136}|[2-4][0-9][0-9][0-9][0-9].{56}|6[0-9][0-9][0-9][0-9].{124}|0[0-9][0-9][0-9][0-9].{24}|1[0-9][0-9][0-9][0-9].{88}|8[0-9][0-9][0-9][0-9].{12})|9(?:[3-7][0-9][0-9][0-9][0-9].{44}|0[0-9][0-9][0-9][0-9].{136}|2[0-9][0-9][0-9][0-9].{56}|8[0-9][0-9][0-9][0-9].{92}|9[0-9][0-9][0-9][0-9].{12}|1[0-9][0-9][0-9][0-9].{8})|5(?:[5-9][0-9][0-9][0-9][0-9].{64}|[01][0-9][0-9][0-9][0-9].{12}|2[0-9][0-9][0-9][0-9].{40}|3[0-9][0-9][0-9][0-9].{28}|4[0-9][0-9][0-9][0-9].{72})|3(?:[3-9][0-9][0-9][0-9][0-9].{40}|0[0-9][0-9][0-9][0-9].{400}|2[0-9][0-9][0-9][0-9].{56}|1[0-9][0-9][0-9][0-9].{8})|0(?:[013-6][0-9][0-9][0-9][0-9].{12}|[7-9][0-9][0-9][0-9][0-9].{4}|2[0-9][0-9][0-9][0-9].{136})|2(?:[0-7][0-9][0-9][0-9][0-9].{4}|9[0-9][0-9][0-9][0-9].{448}|8[0-9][0-9][0-9][0-9].{8})|4(?:[2-9][0-9][0-9][0-9][0-9].{12}|[01][0-9][0-9][0-9][0-9].{40})|6(?:[013-9][0-9][0-9][0-9][0-9].{64}|2[0-9][0-9][0-9][0-9].{56})|1[0-9][0-9][0-9][0-9][0-9].{4})|8(?:5(?:[1-39][0-9][0-9][0-9][0-9].{20}|[67][0-9][0-9][0-9][0-9].{12}|[45][0-9][0-9][0-9][0-9].{8}|0[0-9][0-9][0-9][0-9].{40}|8[0-9][0-9][0-9][0-9].{16})|6(?:[1459][0-9][0-9][0-9][0-9].{8}|[6-8][0-9][0-9][0-9][0-9].{12}|0[0-9][0-9][0-9][0-9].{128}|2[0-9][0-9][0-9][0-9].{92}|3[0-9][0-9][0-9][0-9].{40})|1(?:[1268][0-9][0-9][0-9][0-9].{16}|[045][0-9][0-9][0-9][0-9].{8}|[79][0-9][0-9][0-9][0-9].{12}|3[0-9][0-9][0-9][0-9].{32})|2(?:[018][0-9][0-9][0-9][0-9].{16}|[4-6][0-9][0-9][0-9][0-9].{20}|[279][0-9][0-9][0-9][0-9].{8}|3[0-9][0-9][0-9][0-9].{40})|0(?:[03-589][0-9][0-9][0-9][0-9].{8}|[26][0-9][0-9][0-9][0-9].{16}|1[0-9][0-9][0-9][0-9].{12}|7[0-9][0-9][0-9][0-9].{40})|8(?:[0-3][0-9][0-9][0-9][0-9].{24}|[7-9][0-9][0-9][0-9][0-9].{32}|[4-6][0-9][0-9][0-9][0-9].{8})|3(?:[0-58][0-9][0-9][0-9][0-9].{16}|[79][0-9][0-9][0-9][0-9].{8}|6[0-9][0-9][0-9][0-9].{188})|7(?:[1-378][0-9][0-9][0-9][0-9].{12}|[4-69][0-9][0-9][0-9][0-9].{24}|0[0-9][0-9][0-9][0-9].{88})|4(?:[0-4][0-9][0-9][0-9][0-9].{8}|[5-79][0-9][0-9][0-9][0-9].{20}|8[0-9][0-9][0-9][0-9].{16})|9(?:[1-8][0-9][0-9][0-9][0-9].{24}|0[0-9][0-9][0-9][0-9].{16}|9[0-9][0-9][0-9][0-9].{32}))|9(?:6(?:[3-5][0-9][0-9][0-9][0-9].{20}|[02][0-9][0-9][0-9][0-9].{12}|[6-8][0-9][0-9][0-9][0-9].{8}|1[0-9][0-9][0-9][0-9].{108}|9[0-9][0-9][0-9][0-9].{16})|5(?:[46-8][0-9][0-9][0-9][0-9].{16}|[0-2][0-9][0-9][0-9][0-9].{24}|5[0-9][0-9][0-9][0-9].{12}|9[0-9][0-9][0-9][0-9].{20}|3[0-9][0-9][0-9][0-9].{8})|1(?:[01458][0-9][0-9][0-9][0-9].{8}|[369][0-9][0-9][0-9][0-9].{16}|2[0-9][0-9][0-9][0-9].{32}|7[0-9][0-9][0-9][0-9].{12})|2(?:[12459][0-9][0-9][0-9][0-9].{8}|[6-8][0-9][0-9][0-9][0-9].{20}|0[0-9][0-9][0-9][0-9].{16}|3[0-9][0-9][0-9][0-9].{92})|3(?:[014-6][0-9][0-9][0-9][0-9].{8}|[7-9][0-9][0-9][0-9][0-9].{24}|2[0-9][0-9][0-9][0-9].{52}|3[0-9][0-9][0-9][0-9].{44})|9(?:[046-9][0-9][0-9][0-9][0-9].{8}|[25][0-9][0-9][0-9][0-9].{40}|1[0-9][0-9][0-9][0-9].{16}|3[0-9][0-9][0-9][0-9].{12})|7(?:[1247-9][0-9][0-9][0-9][0-9].{8}|[03][0-9][0-9][0-9][0-9].{12}|[56][0-9][0-9][0-9][0-9].{16})|8(?:[0135-8][0-9][0-9][0-9][0-9].{12}|[29][0-9][0-9][0-9][0-9].{8}|4[0-9][0-9][0-9][0-9].{188})|0(?:[02358][0-9][0-9][0-9][0-9].{8}|[1467][0-9][0-9][0-9][0-9].{12}|9[0-9][0-9][0-9][0-9].{40})|4[0-9][0-9][0-9][0-9][0-9].{24})|1(?:4(?:[4-6][0-9][0-9][0-9][0-9].{124}|[0-2][0-9][0-9][0-9][0-9].{32}|[78][0-9][0-9][0-9][0-9].{12}|3[0-9][0-9][0-9][0-9].{28}|9[0-9][0-9][0-9][0-9].{36})|6(?:[0-5][0-9][0-9][0-9][0-9].{20}|7[0-9][0-9][0-9][0-9].{12}|8[0-9][0-9][0-9][0-9].{88}|9[0-9][0-9][0-9][0-9].{44}|6[0-9][0-9][0-9][0-9].{8})|0(?:[0-5][0-9][0-9][0-9][0-9].{8}|[78][0-9][0-9][0-9][0-9].{12}|6[0-9][0-9][0-9][0-9].{296}|9[0-9][0-9][0-9][0-9].{116})|1(?:[2-5][0-9][0-9][0-9][0-9].{60}|[018][0-9][0-9][0-9][0-9].{8}|[67][0-9][0-9][0-9][0-9].{28}|9[0-9][0-9][0-9][0-9].{32})|8(?:[1-69][0-9][0-9][0-9][0-9].{12}|8[0-9][0-9][0-9][0-9].{112}|0[0-9][0-9][0-9][0-9].{44}|7[0-9][0-9][0-9][0-9].{40})|9(?:[2-8][0-9][0-9][0-9][0-9].{12}|[09][0-9][0-9][0-9][0-9].{184}|1[0-9][0-9][0-9][0-9].{56})|3(?:[013469][0-9][0-9][0-9][0-9].{12}|[2578][0-9][0-9][0-9][0-9].{32})|5(?:[0-46-9][0-9][0-9][0-9][0-9].{20}|5[0-9][0-9][0-9][0-9].{32})|7(?:[1-9][0-9][0-9][0-9][0-9].{12}|0[0-9][0-9][0-9][0-9].{44})|2[0-9][0-9][0-9][0-9][0-9].{32})|0(?:9(?:[4-68][0-9][0-9][0-9][0-9].{56}|[23][0-9][0-9][0-9][0-9].{108}|9[0-9][0-9][0-9][0-9].{184}|0[0-9][0-9][0-9][0-9].{12}|1[0-9][0-9][0-9][0-9].{36}|7[0-9][0-9][0-9][0-9].{8})|3(?:[3-6][0-9][0-9][0-9][0-9].{12}|[79][0-9][0-9][0-9][0-9].{4}|0[0-9][0-9][0-9][0-9].{32}|1[0-9][0-9][0-9][0-9].{92}|2[0-9][0-9][0-9][0-9].{36}|8[0-9][0-9][0-9][0-9].{40})|8(?:[35-9][0-9][0-9][0-9][0-9].{12}|[01][0-9][0-9][0-9][0-9].{56}|2[0-9][0-9][0-9][0-9].{292}|4[0-9][0-9][0-9][0-9].{40})|1(?:[0-245][0-9][0-9][0-9][0-9].{8}|[7-9][0-9][0-9][0-9][0-9].{32}|3[0-9][0-9][0-9][0-9].{12}|6[0-9][0-9][0-9][0-9].{28})|7(?:[016-8][0-9][0-9][0-9][0-9].{12}|[2-5][0-9][0-9][0-9][0-9].{4}|9[0-9][0-9][0-9][0-9].{56})|4(?:[0-8][0-9][0-9][0-9][0-9].{20}|9[0-9][0-9][0-9][0-9].{12})|2[0-9][0-9][0-9][0-9][0-9].{32}|5[0-9][0-9][0-9][0-9][0-9].{12}|0[0-9][0-9][0-9][0-9][0-9].{8}|6[0-9][0-9][0-9][0-9][0-9].{4})|7(?:3(?:[0-2][0-9][0-9][0-9][0-9].{252}|[49][0-9][0-9][0-9][0-9].{48}|[78][0-9][0-9][0-9][0-9].{8}|3[0-9][0-9][0-9][0-9].{324}|5[0-9][0-9][0-9][0-9].{412}|6[0-9][0-9][0-9][0-9].{420})|2(?:[126][0-9][0-9][0-9][0-9].{60}|[3-5][0-9][0-9][0-9][0-9].{8}|0[0-9][0-9][0-9][0-9].{136}|7[0-9][0-9][0-9][0-9].{424}|8[0-9][0-9][0-9][0-9].{40}|9[0-9][0-9][0-9][0-9].{20})|9(?:[56][0-9][0-9][0-9][0-9].{252}|[78][0-9][0-9][0-9][0-9].{36}|4[0-9][0-9][0-9][0-9].{292}|0[0-9][0-9][0-9][0-9].{92}|9[0-9][0-9][0-9][0-9].{8})|0(?:[5-9][0-9][0-9][0-9][0-9].{36}|[2-4][0-9][0-9][0-9][0-9].{264}|[01][0-9][0-9][0-9][0-9].{116})|8(?:8[0-9][0-9][0-9][0-9].{136}|9[0-9][0-9][0-9][0-9].{328})|[45][0-9][0-9][0-9][0-9][0-9].{48}|1[0-9][0-9][0-9][0-9][0-9].{36})|5(?:4(?:[02][0-9][0-9][0-9][0-9].{60}|1[0-9][0-9][0-9][0-9].{424}|3[0-9][0-9][0-9][0-9].{276}|5[0-9][0-9][0-9][0-9].{136}|4[0-9][0-9][0-9][0-9].{88})|0(?:[0-3][0-9][0-9][0-9][0-9].{40}|[6-9][0-9][0-9][0-9][0-9].{64}|[45][0-9][0-9][0-9][0-9].{12})|3(?:[1-79][0-9][0-9][0-9][0-9].{48}|0[0-9][0-9][0-9][0-9].{28}|8[0-9][0-9][0-9][0-9].{92})|8(?:[08][0-9][0-9][0-9][0-9].{88}|[67][0-9][0-9][0-9][0-9].{60}|5[0-9][0-9][0-9][0-9].{136})|1(?:[0-8][0-9][0-9][0-9][0-9].{64}|9[0-9][0-9][0-9][0-9].{112})|2(?:[0-8][0-9][0-9][0-9][0-9].{44}|9[0-9][0-9][0-9][0-9].{28})|7(?:[1-46-9][0-9][0-9][0-9][0-9].{48}|5[0-9][0-9][0-9][0-9].{136})))|2(?:2(?:6(?:[17][0-9][0-9][0-9][0-9].{196}|[06][0-9][0-9][0-9][0-9].{60}|2[0-9][0-9][0-9][0-9].{136}|5[0-9][0-9][0-9][0-9].{484}|8[0-9][0-9][0-9][0-9].{328}|9[0-9][0-9][0-9][0-9].{156}|3[0-9][0-9][0-9][0-9].{44}|4[0-9][0-9][0-9][0-9].{36})|8(?:[89][0-9][0-9][0-9][0-9].{60}|2[0-9][0-9][0-9][0-9].{116}|6[0-9][0-9][0-9][0-9].{528}|1[0-9][0-9][0-9][0-9].{40}|3[0-9][0-9][0-9][0-9].{92}|4[0-9][0-9][0-9][0-9].{88}|7[0-9][0-9][0-9][0-9].{72}|0[0-9][0-9][0-9][0-9].{8})|1(?:[12][0-9][0-9][0-9][0-9].{124}|[78][0-9][0-9][0-9][0-9].{112}|[34][0-9][0-9][0-9][0-9].{28}|[06][0-9][0-9][0-9][0-9].{8}|5[0-9][0-9][0-9][0-9].{84}|9[0-9][0-9][0-9][0-9].{44})|5(?:[34][0-9][0-9][0-9][0-9].{128}|[67][0-9][0-9][0-9][0-9].{28}|[89][0-9][0-9][0-9][0-9].{60}|1[0-9][0-9][0-9][0-9].{428}|2[0-9][0-9][0-9][0-9].{404}|5[0-9][0-9][0-9][0-9].{52})|7(?:[08][0-9][0-9][0-9][0-9].{116}|[14][0-9][0-9][0-9][0-9].{92}|[67][0-9][0-9][0-9][0-9].{36}|[39][0-9][0-9][0-9][0-9].{8}|5[0-9][0-9][0-9][0-9].{292})|2(?:[4-9][0-9][0-9][0-9][0-9].{64}|0[0-9][0-9][0-9][0-9].{212}|2[0-9][0-9][0-9][0-9].{236}|3[0-9][0-9][0-9][0-9].{56}|1[0-9][0-9][0-9][0-9].{8})|3(?:[3-7][0-9][0-9][0-9][0-9].{52}|[01][0-9][0-9][0-9][0-9].{64}|[89][0-9][0-9][0-9][0-9].{36}|2[0-9][0-9][0-9][0-9].{56})|4(?:[6-9][0-9][0-9][0-9][0-9].{28}|[01][0-9][0-9][0-9][0-9].{36}|[2-4][0-9][0-9][0-9][0-9].{8}|5[0-9][0-9][0-9][0-9].{60})|9(?:[0-26-9][0-9][0-9][0-9][0-9].{72}|[3-5][0-9][0-9][0-9][0-9].{168})|0(?:[0-7][0-9][0-9][0-9][0-9].{4}|[89][0-9][0-9][0-9][0-9].{40}))|8(?:6(?:[01][0-9][0-9][0-9][0-9].{400}|[48][0-9][0-9][0-9][0-9].{60}|2[0-9][0-9][0-9][0-9].{460}|3[0-9][0-9][0-9][0-9].{164}|5[0-9][0-9][0-9][0-9].{216}|6[0-9][0-9][0-9][0-9].{432}|9[0-9][0-9][0-9][0-9].{452}|7[0-9][0-9][0-9][0-9].{24})|8(?:[568][0-9][0-9][0-9][0-9].{136}|[34][0-9][0-9][0-9][0-9].{40}|0[0-9][0-9][0-9][0-9].{404}|7[0-9][0-9][0-9][0-9].{352}|1[0-9][0-9][0-9][0-9].{92}|2[0-9][0-9][0-9][0-9].{56}|9[0-9][0-9][0-9][0-9].{8})|7(?:[1-49][0-9][0-9][0-9][0-9].{60}|0[0-9][0-9][0-9][0-9].{388}|6[0-9][0-9][0-9][0-9].{116}|7[0-9][0-9][0-9][0-9].{276}|5[0-9][0-9][0-9][0-9].{84}|8[0-9][0-9][0-9][0-9].{92})|0(?:[089][0-9][0-9][0-9][0-9].{112}|[5-7][0-9][0-9][0-9][0-9].{172}|[23][0-9][0-9][0-9][0-9].{44}|1[0-9][0-9][0-9][0-9].{144}|4[0-9][0-9][0-9][0-9].{28})|2(?:[0-3][0-9][0-9][0-9][0-9].{44}|[4-6][0-9][0-9][0-9][0-9].{52}|7[0-9][0-9][0-9][0-9].{384}|8[0-9][0-9][0-9][0-9].{212}|9[0-9][0-9][0-9][0-9].{28})|3(?:[05-79][0-9][0-9][0-9][0-9].{28}|[2-4][0-9][0-9][0-9][0-9].{36}|1[0-9][0-9][0-9][0-9].{196}|8[0-9][0-9][0-9][0-9].{128})|4(?:[0-289][0-9][0-9][0-9][0-9].{28}|[67][0-9][0-9][0-9][0-9].{168}|4[0-9][0-9][0-9][0-9].{116}|5[0-9][0-9][0-9][0-9].{40})|1(?:[3-9][0-9][0-9][0-9][0-9].{44}|[12][0-9][0-9][0-9][0-9].{52}|0[0-9][0-9][0-9][0-9].{104})|5(?:[0-5][0-9][0-9][0-9][0-9].{28}|[6-9][0-9][0-9][0-9][0-9].{72})|9[0-9][0-9][0-9][0-9][0-9].{264})|6(?:7(?:[457][0-9][0-9][0-9][0-9].{40}|[0-2][0-9][0-9][0-9][0-9].{8}|8[0-9][0-9][0-9][0-9].{128}|3[0-9][0-9][0-9][0-9].{12}|6[0-9][0-9][0-9][0-9].{16}|9[0-9][0-9][0-9][0-9].{20})|8(?:[3-579][0-9][0-9][0-9][0-9].{24}|[026][0-9][0-9][0-9][0-9].{64}|1[0-9][0-9][0-9][0-9].{40}|8[0-9][0-9][0-9][0-9].{60})|6(?:[0-267][0-9][0-9][0-9][0-9].{8}|[3-5][0-9][0-9][0-9][0-9].{40}|8[0-9][0-9][0-9][0-9].{12}|9[0-9][0-9][0-9][0-9].{32})|4(?:[0-3578][0-9][0-9][0-9][0-9].{8}|6[0-9][0-9][0-9][0-9].{108}|4[0-9][0-9][0-9][0-9].{12}|9[0-9][0-9][0-9][0-9].{84})|2(?:[0-248][0-9][0-9][0-9][0-9].{8}|[5-7][0-9][0-9][0-9][0-9].{32}|[39][0-9][0-9][0-9][0-9].{12})|0(?:[04-9][0-9][0-9][0-9][0-9].{8}|[12][0-9][0-9][0-9][0-9].{40}|3[0-9][0-9][0-9][0-9].{32})|9(?:[1-57-9][0-9][0-9][0-9][0-9].{24}|0[0-9][0-9][0-9][0-9].{16}|6[0-9][0-9][0-9][0-9].{40})|5(?:[1-57-9][0-9][0-9][0-9][0-9].{8}|0[0-9][0-9][0-9][0-9].{40}|6[0-9][0-9][0-9][0-9].{84})|1(?:[1-9][0-9][0-9][0-9][0-9].{8}|0[0-9][0-9][0-9][0-9].{12})|3(?:[0-57-9][0-9][0-9][0-9][0-9].{8}|6[0-9][0-9][0-9][0-9].{12}))|7(?:8(?:[027][0-9][0-9][0-9][0-9].{8}|[19][0-9][0-9][0-9][0-9].{40}|[56][0-9][0-9][0-9][0-9].{12}|3[0-9][0-9][0-9][0-9].{132}|4[0-9][0-9][0-9][0-9].{52}|8[0-9][0-9][0-9][0-9].{24})|7(?:[6-9][0-9][0-9][0-9][0-9].{8}|[13][0-9][0-9][0-9][0-9].{16}|[24][0-9][0-9][0-9][0-9].{20}|0[0-9][0-9][0-9][0-9].{12}|5[0-9][0-9][0-9][0-9].{92})|3(?:[0-4][0-9][0-9][0-9][0-9].{20}|[68][0-9][0-9][0-9][0-9].{12}|[79][0-9][0-9][0-9][0-9].{16}|5[0-9][0-9][0-9][0-9].{8})|1(?:[0589][0-9][0-9][0-9][0-9].{12}|[1346][0-9][0-9][0-9][0-9].{8}|[27][0-9][0-9][0-9][0-9].{16})|0(?:[035-9][0-9][0-9][0-9][0-9].{16}|[12][0-9][0-9][0-9][0-9].{8}|4[0-9][0-9][0-9][0-9].{188})|4(?:[0-589][0-9][0-9][0-9][0-9].{8}|6[0-9][0-9][0-9][0-9].{12}|7[0-9][0-9][0-9][0-9].{16})|2(?:[0-35][0-9][0-9][0-9][0-9].{16}|[46-9][0-9][0-9][0-9][0-9].{20})|5(?:[0-689][0-9][0-9][0-9][0-9].{8}|7[0-9][0-9][0-9][0-9].{16})|6(?:[0-689][0-9][0-9][0-9][0-9].{8}|7[0-9][0-9][0-9][0-9].{16})|9[0-9][0-9][0-9][0-9][0-9].{16})|0(?:1(?:5[0-9][0-9][0-9][0-9].{128}|7[0-9][0-9][0-9][0-9].{372}|0[0-9][0-9][0-9][0-9].{24}|1[0-9][0-9][0-9][0-9].{52}|2[0-9][0-9][0-9][0-9].{44}|3[0-9][0-9][0-9][0-9].{28}|4[0-9][0-9][0-9][0-9].{36}|6[0-9][0-9][0-9][0-9].{40}|8[0-9][0-9][0-9][0-9].{92}|9[0-9][0-9][0-9][0-9].{60})|0(?:[0-46][0-9][0-9][0-9][0-9].{8}|[58][0-9][0-9][0-9][0-9].{12}|7[0-9][0-9][0-9][0-9].{32}|9[0-9][0-9][0-9][0-9].{4})|5(?:8[0-9][0-9][0-9][0-9].{116}|9[0-9][0-9][0-9][0-9].{136}|5[0-9][0-9][0-9][0-9].{16}|7[0-9][0-9][0-9][0-9].{8})|6(?:0[0-9][0-9][0-9][0-9].{48}|1[0-9][0-9][0-9][0-9].{20})|9[45][0-9][0-9][0-9][0-9].{16}|30[0-9][0-9][0-9][0-9].{12}|40[0-9][0-9][0-9][0-9].{56}|88[0-9][0-9][0-9][0-9].{88}|20[0-9][0-9][0-9][0-9].{8})|3(?:0(?:[1-8][0-9][0-9][0-9][0-9].{48}|0[0-9][0-9][0-9][0-9].{340})|1[12][0-9][0-9][0-9][0-9].{276}))|6(?:5(?:3(?:[02][0-9][0-9][0-9][0-9].{60}|1[0-9][0-9][0-9][0-9].{584}|3[0-9][0-9][0-9][0-9].{148}|7[0-9][0-9][0-9][0-9].{496}|4[0-9][0-9][0-9][0-9].{52}|5[0-9][0-9][0-9][0-9].{36}|6[0-9][0-9][0-9][0-9].{92}|9[0-9][0-9][0-9][0-9].{40}|8[0-9][0-9][0-9][0-9].{8})|4(?:[4-9][0-9][0-9][0-9][0-9].{48}|0[0-9][0-9][0-9][0-9].{116}|1[0-9][0-9][0-9][0-9].{196}|2[0-9][0-9][0-9][0-9].{328}|3[0-9][0-9][0-9][0-9].{276})|0(?:[1-389][0-9][0-9][0-9][0-9].{28}|[45][0-9][0-9][0-9][0-9].{8}|6[0-9][0-9][0-9][0-9].{240}|7[0-9][0-9][0-9][0-9].{128}|0[0-9][0-9][0-9][0-9].{60})|1(?:[3-8][0-9][0-9][0-9][0-9].{72}|1[0-9][0-9][0-9][0-9].{320}|2[0-9][0-9][0-9][0-9].{244}|9[0-9][0-9][0-9][0-9].{168}|0[0-9][0-9][0-9][0-9].{28})|7(?:[3-7][0-9][0-9][0-9][0-9].{36}|2[0-9][0-9][0-9][0-9].{252}|8[0-9][0-9][0-9][0-9].{784}|9[0-9][0-9][0-9][0-9].{400}|0[0-9][0-9][0-9][0-9].{60})|8(?:[15][0-9][0-9][0-9][0-9].{8}|3[0-9][0-9][0-9][0-9].{116}|4[0-9][0-9][0-9][0-9].{104}|0[0-9][0-9][0-9][0-9].{60}|2[0-9][0-9][0-9][0-9].{92})|6(?:5[0-9][0-9][0-9][0-9].{352}|6[0-9][0-9][0-9][0-9].{196}|7[0-9][0-9][0-9][0-9].{116}|8[0-9][0-9][0-9][0-9].{92}|9[0-9][0-9][0-9][0-9].{60})|2(?:[01][0-9][0-9][0-9][0-9].{168}|[689][0-9][0-9][0-9][0-9].{60}|[23][0-9][0-9][0-9][0-9].{28}|[45][0-9][0-9][0-9][0-9].{72})|5[0-6][0-9][0-9][0-9][0-9].{48})|3(?:6(?:[2-46][0-9][0-9][0-9][0-9].{8}|[7-9][0-9][0-9][0-9][0-9].{20}|0[0-9][0-9][0-9][0-9].{32}|1[0-9][0-9][0-9][0-9].{16}|5[0-9][0-9][0-9][0-9].{40})|5(?:[0246-8][0-9][0-9][0-9][0-9].{24}|1[0-9][0-9][0-9][0-9].{40}|3[0-9][0-9][0-9][0-9].{16}|9[0-9][0-9][0-9][0-9].{20}|5[0-9][0-9][0-9][0-9].{8})|3(?:[05-7][0-9][0-9][0-9][0-9].{12}|[489][0-9][0-9][0-9][0-9].{24}|[13][0-9][0-9][0-9][0-9].{8}|2[0-9][0-9][0-9][0-9].{16})|0(?:[236-9][0-9][0-9][0-9][0-9].{8}|[45][0-9][0-9][0-9][0-9].{12}|0[0-9][0-9][0-9][0-9].{16}|1[0-9][0-9][0-9][0-9].{84})|7(?:[16-9][0-9][0-9][0-9][0-9].{8}|[235][0-9][0-9][0-9][0-9].{20}|0[0-9][0-9][0-9][0-9].{16}|4[0-9][0-9][0-9][0-9].{24})|4(?:[25-9][0-9][0-9][0-9][0-9].{24}|[014][0-9][0-9][0-9][0-9].{8}|3[0-9][0-9][0-9][0-9].{16})|2(?:[0-24-9][0-9][0-9][0-9][0-9].{8}|3[0-9][0-9][0-9][0-9].{16})|[18][0-9][0-9][0-9][0-9][0-9].{8}|9[0-9][0-9][0-9][0-9][0-9].{16})|9(?:7(?:[3479][0-9][0-9][0-9][0-9].{12}|[12][0-9][0-9][0-9][0-9].{16}|[568][0-9][0-9][0-9][0-9].{8}|0[0-9][0-9][0-9][0-9].{40})|9(?:[1-57][0-9][0-9][0-9][0-9].{8}|[09][0-9][0-9][0-9][0-9].{12}|6[0-9][0-9][0-9][0-9].{104}|8[0-9][0-9][0-9][0-9].{304})|6(?:[1-6][0-9][0-9][0-9][0-9].{12}|[78][0-9][0-9][0-9][0-9].{8}|0[0-9][0-9][0-9][0-9].{40}|9[0-9][0-9][0-9][0-9].{16})|4(?:[0-7][0-9][0-9][0-9][0-9].{12}|9[0-9][0-9][0-9][0-9].{16}|8[0-9][0-9][0-9][0-9].{8})|5(?:[4-9][0-9][0-9][0-9][0-9].{12}|[0-3][0-9][0-9][0-9][0-9].{16})|1(?:[4-9][0-9][0-9][0-9][0-9].{8}|[0-3][0-9][0-9][0-9][0-9].{24})|3(?:[0-7][0-9][0-9][0-9][0-9].{8}|[89][0-9][0-9][0-9][0-9].{40})|8(?:[1-7][0-9][0-9][0-9][0-9].{8}|[089][0-9][0-9][0-9][0-9].{12})|0[0-9][0-9][0-9][0-9][0-9].{24}|2[0-9][0-9][0-9][0-9][0-9].{8})|[6-8][0-9][0-9][0-9][0-9][0-9][0-9].{4})|5(?:8(?:4(?:[47][0-9][0-9][0-9][0-9].{116}|[02][0-9][0-9][0-9][0-9].{60}|3[0-9][0-9][0-9][0-9].{180}|6[0-9][0-9][0-9][0-9].{196}|8[0-9][0-9][0-9][0-9].{136}|1[0-9][0-9][0-9][0-9].{12}|5[0-9][0-9][0-9][0-9].{36}|9[0-9][0-9][0-9][0-9].{40})|5(?:[0-2][0-9][0-9][0-9][0-9].{136}|[34][0-9][0-9][0-9][0-9].{168}|5[0-9][0-9][0-9][0-9].{352}|6[0-9][0-9][0-9][0-9].{560}|7[0-9][0-9][0-9][0-9].{60}|8[0-9][0-9][0-9][0-9].{72}|9[0-9][0-9][0-9][0-9].{36})|6(?:[3-5][0-9][0-9][0-9][0-9].{264}|[89][0-9][0-9][0-9][0-9].{36}|0[0-9][0-9][0-9][0-9].{328}|2[0-9][0-9][0-9][0-9].{116}|7[0-9][0-9][0-9][0-9].{252}|1[0-9][0-9][0-9][0-9].{92}|6[0-9][0-9][0-9][0-9].{8})|8(?:0[0-9][0-9][0-9][0-9].{132}|1[0-9][0-9][0-9][0-9].{116}|2[0-9][0-9][0-9][0-9].{400}|5[0-9][0-9][0-9][0-9].{320}|3[0-9][0-9][0-9][0-9].{60}|4[0-9][0-9][0-9][0-9].{52})|1(?:[014-69][0-9][0-9][0-9][0-9].{28}|[23][0-9][0-9][0-9][0-9].{36}|7[0-9][0-9][0-9][0-9].{128}|8[0-9][0-9][0-9][0-9].{400})|0(?:[3-9][0-9][0-9][0-9][0-9].{44}|[12][0-9][0-9][0-9][0-9].{112}|0[0-9][0-9][0-9][0-9].{28})|2(?:[0-5][0-9][0-9][0-9][0-9].{28}|[6-9][0-9][0-9][0-9][0-9].{72})|7(?:[0-7][0-9][0-9][0-9][0-9].{36}|[89][0-9][0-9][0-9][0-9].{40})|3(?:[0-8][0-9][0-9][0-9][0-9].{72}|9[0-9][0-9][0-9][0-9].{60}))|6(?:4(?:[0-24][0-9][0-9][0-9][0-9].{12}|[359][0-9][0-9][0-9][0-9].{8}|[78][0-9][0-9][0-9][0-9].{20}|6[0-9][0-9][0-9][0-9].{16})|5(?:[013][0-9][0-9][0-9][0-9].{20}|[5-79][0-9][0-9][0-9][0-9].{8}|[28][0-9][0-9][0-9][0-9].{12}|4[0-9][0-9][0-9][0-9].{32})|8(?:[1256][0-9][0-9][0-9][0-9].{8}|[7-9][0-9][0-9][0-9][0-9].{64}|[34][0-9][0-9][0-9][0-9].{20}|0[0-9][0-9][0-9][0-9].{12})|0(?:[0-5][0-9][0-9][0-9][0-9].{8}|[6-8][0-9][0-9][0-9][0-9].{16}|9[0-9][0-9][0-9][0-9].{32})|1(?:[0-2478][0-9][0-9][0-9][0-9].{8}|[356][0-9][0-9][0-9][0-9].{16}|9[0-9][0-9][0-9][0-9].{60})|3(?:[0-579][0-9][0-9][0-9][0-9].{8}|6[0-9][0-9][0-9][0-9].{16}|8[0-9][0-9][0-9][0-9].{12})|9(?:[013-57-9][0-9][0-9][0-9][0-9].{16}|2[0-9][0-9][0-9][0-9].{20}|6[0-9][0-9][0-9][0-9].{8})|6(?:[0-578][0-9][0-9][0-9][0-9].{24}|[69][0-9][0-9][0-9][0-9].{20})|7[0-9][0-9][0-9][0-9][0-9].{40}|2[0-9][0-9][0-9][0-9][0-9].{8})|7(?:0(?:[13589][0-9][0-9][0-9][0-9].{8}|[267][0-9][0-9][0-9][0-9].{16}|0[0-9][0-9][0-9][0-9].{84}|4[0-9][0-9][0-9][0-9].{12})|8(?:[0189][0-9][0-9][0-9][0-9].{12}|[4-7][0-9][0-9][0-9][0-9].{16}|[23][0-9][0-9][0-9][0-9].{8})|7(?:[2-46-9][0-9][0-9][0-9][0-9].{12}|[01][0-9][0-9][0-9][0-9].{24}|5[0-9][0-9][0-9][0-9].{84})|5(?:[0-468][0-9][0-9][0-9][0-9].{12}|[59][0-9][0-9][0-9][0-9].{8}|7[0-9][0-9][0-9][0-9].{84})|3(?:[0-7][0-9][0-9][0-9][0-9].{8}|8[0-9][0-9][0-9][0-9].{12}|9[0-9][0-9][0-9][0-9].{40})|4(?:[25-9][0-9][0-9][0-9][0-9].{12}|[0134][0-9][0-9][0-9][0-9].{8})|9(?:[0-279][0-9][0-9][0-9][0-9].{12}|[3-68][0-9][0-9][0-9][0-9].{8})|2(?:[013-9][0-9][0-9][0-9][0-9].{8}|2[0-9][0-9][0-9][0-9].{16})|6[0-9][0-9][0-9][0-9][0-9].{24}|1[0-9][0-9][0-9][0-9][0-9].{8})|0[0-9][0-9][0-9][0-9][0-9][0-9].{4})|1(?:1(?:6(?:[23][0-9][0-9][0-9][0-9].{108}|[578][0-9][0-9][0-9][0-9].{40}|[01][0-9][0-9][0-9][0-9].{4}|6[0-9][0-9][0-9][0-9].{56}|9[0-9][0-9][0-9][0-9].{12}|4[0-9][0-9][0-9][0-9].{8})|8(?:[024-6][0-9][0-9][0-9][0-9].{44}|7[0-9][0-9][0-9][0-9].{124}|1[0-9][0-9][0-9][0-9].{56}|8[0-9][0-9][0-9][0-9].{88}|9[0-9][0-9][0-9][0-9].{92}|3[0-9][0-9][0-9][0-9].{8})|9(?:[4-6][0-9][0-9][0-9][0-9].{112}|[028][0-9][0-9][0-9][0-9].{88}|[79][0-9][0-9][0-9][0-9].{52}|1[0-9][0-9][0-9][0-9].{56}|3[0-9][0-9][0-9][0-9].{28})|7(?:[02-4][0-9][0-9][0-9][0-9].{12}|[69][0-9][0-9][0-9][0-9].{44}|[57][0-9][0-9][0-9][0-9].{8}|8[0-9][0-9][0-9][0-9].{124}|1[0-9][0-9][0-9][0-9].{56})|3(?:[35-9][0-9][0-9][0-9][0-9].{12}|[01][0-9][0-9][0-9][0-9].{20}|2[0-9][0-9][0-9][0-9].{36}|4[0-9][0-9][0-9][0-9].{44})|1(?:[1-7][0-9][0-9][0-9][0-9].{12}|0[0-9][0-9][0-9][0-9].{32}|8[0-9][0-9][0-9][0-9].{36}|9[0-9][0-9][0-9][0-9].{40})|4(?:[0-7][0-9][0-9][0-9][0-9].{12}|[89][0-9][0-9][0-9][0-9].{4})|0[0-9][0-9][0-9][0-9][0-9].{32}|2[0-9][0-9][0-9][0-9][0-9].{20}|5[0-9][0-9][0-9][0-9][0-9].{4})|3(?:4(?:[4-9][0-9][0-9][0-9][0-9].{32}|0[0-9][0-9][0-9][0-9].{40}|1[0-9][0-9][0-9][0-9].{56}|2[0-9][0-9][0-9][0-9].{12}|3[0-9][0-9][0-9][0-9].{8})|3(?:[0-24][0-9][0-9][0-9][0-9].{12}|[6-9][0-9][0-9][0-9][0-9].{8}|3[0-9][0-9][0-9][0-9].{104}|5[0-9][0-9][0-9][0-9].{304})|6(?:[0-2479][0-9][0-9][0-9][0-9].{12}|[36][0-9][0-9][0-9][0-9].{40}|5[0-9][0-9][0-9][0-9].{36}|8[0-9][0-9][0-9][0-9].{88})|0(?:[0-49][0-9][0-9][0-9][0-9].{12}|[5-7][0-9][0-9][0-9][0-9].{8}|8[0-9][0-9][0-9][0-9].{16})|2(?:[124-8][0-9][0-9][0-9][0-9].{8}|[39][0-9][0-9][0-9][0-9].{12}|0[0-9][0-9][0-9][0-9].{40})|5(?:[03-8][0-9][0-9][0-9][0-9].{12}|[12][0-9][0-9][0-9][0-9].{32}|9[0-9][0-9][0-9][0-9].{8})|9(?:[0-578][0-9][0-9][0-9][0-9].{20}|6[0-9][0-9][0-9][0-9].{112}|9[0-9][0-9][0-9][0-9].{12})|8(?:[2-9][0-9][0-9][0-9][0-9].{12}|[01][0-9][0-9][0-9][0-9].{108})|1(?:[0-257-9][0-9][0-9][0-9][0-9].{8}|[346][0-9][0-9][0-9][0-9].{12})|7(?:[02-9][0-9][0-9][0-9][0-9].{12}|1[0-9][0-9][0-9][0-9].{20}))|5(?:8(?:[6-8][0-9][0-9][0-9][0-9].{48}|[23][0-9][0-9][0-9][0-9].{60}|5[0-9][0-9][0-9][0-9].{132}|0[0-9][0-9][0-9][0-9].{36}|4[0-9][0-9][0-9][0-9].{40}|1[0-9][0-9][0-9][0-9].{8})|4(?:[6-9][0-9][0-9][0-9][0-9].{28}|[12][0-9][0-9][0-9][0-9].{52}|[34][0-9][0-9][0-9][0-9].{44}|0[0-9][0-9][0-9][0-9].{112}|5[0-9][0-9][0-9][0-9].{56})|5(?:[36-9][0-9][0-9][0-9][0-9].{28}|[12][0-9][0-9][0-9][0-9].{52}|0[0-9][0-9][0-9][0-9].{84}|4[0-9][0-9][0-9][0-9].{60}|5[0-9][0-9][0-9][0-9].{56})|6(?:[0-3][0-9][0-9][0-9][0-9].{28}|[47-9][0-9][0-9][0-9][0-9].{36}|6[0-9][0-9][0-9][0-9].{116}|5[0-9][0-9][0-9][0-9].{92})|3(?:[3-8][0-9][0-9][0-9][0-9].{12}|[01][0-9][0-9][0-9][0-9].{4}|2[0-9][0-9][0-9][0-9].{40}|9[0-9][0-9][0-9][0-9].{8})|1(?:[0-5][0-9][0-9][0-9][0-9].{12}|[6-9][0-9][0-9][0-9][0-9].{4})|0[0-9][0-9][0-9][0-9][0-9].{12}|7[0-9][0-9][0-9][0-9][0-9].{36}|2[0-9][0-9][0-9][0-9][0-9].{4}))|4(?:8(?:0(?:[023][0-9][0-9][0-9][0-9].{52}|[15][0-9][0-9][0-9][0-9].{44}|[67][0-9][0-9][0-9][0-9].{28}|4[0-9][0-9][0-9][0-9].{268}|9[0-9][0-9][0-9][0-9].{36}|8[0-9][0-9][0-9][0-9].{8})|7(?:[0-4][0-9][0-9][0-9][0-9].{408}|[89][0-9][0-9][0-9][0-9].{8}|5[0-9][0-9][0-9][0-9].{132}|6[0-9][0-9][0-9][0-9].{116}|7[0-9][0-9][0-9][0-9].{252})|6(?:[0-5][0-9][0-9][0-9][0-9].{36}|7[0-9][0-9][0-9][0-9].{948}|9[0-9][0-9][0-9][0-9].{408}|6[0-9][0-9][0-9][0-9].{60}|8[0-9][0-9][0-9][0-9].{8})|2(?:[0-2][0-9][0-9][0-9][0-9].{128}|[3-6][0-9][0-9][0-9][0-9].{28}|[89][0-9][0-9][0-9][0-9].{168}|7[0-9][0-9][0-9][0-9].{60})|1(?:[0-3][0-9][0-9][0-9][0-9].{36}|[4-6][0-9][0-9][0-9][0-9].{28}|[78][0-9][0-9][0-9][0-9].{8}|9[0-9][0-9][0-9][0-9].{116})|9(?:[3-9][0-9][0-9][0-9][0-9].{48}|0[0-9][0-9][0-9][0-9].{116}|2[0-9][0-9][0-9][0-9].{276}|1[0-9][0-9][0-9][0-9].{92})|5(?:[0-4][0-9][0-9][0-9][0-9].{60}|[67][0-9][0-9][0-9][0-9].{92}|5[0-9][0-9][0-9][0-9].{44}|9[0-9][0-9][0-9][0-9].{36})|8(?:[1-7][0-9][0-9][0-9][0-9].{48}|0[0-9][0-9][0-9][0-9].{276}|8[0-9][0-9][0-9][0-9].{56}|9[0-9][0-9][0-9][0-9].{8})|3(?:[0-3][0-9][0-9][0-9][0-9].{28}|[6-9][0-9][0-9][0-9][0-9].{72}|[45][0-9][0-9][0-9][0-9].{560})|4(?:[0-7][0-9][0-9][0-9][0-9].{72}|8[0-9][0-9][0-9][0-9].{212}|9[0-9][0-9][0-9][0-9].{116}))|3(?:8(?:[0-257][0-9][0-9][0-9][0-9].{12}|[89][0-9][0-9][0-9][0-9].{20}|4[0-9][0-9][0-9][0-9].{108}|6[0-9][0-9][0-9][0-9].{172}|3[0-9][0-9][0-9][0-9].{36})|5(?:[1-47][0-9][0-9][0-9][0-9].{8}|[06][0-9][0-9][0-9][0-9].{28}|5[0-9][0-9][0-9][0-9].{128}|8[0-9][0-9][0-9][0-9].{40}|9[0-9][0-9][0-9][0-9].{32})|7(?:[036-9][0-9][0-9][0-9][0-9].{12}|[1245][0-9][0-9][0-9][0-9].{32})|1(?:[5-9][0-9][0-9][0-9][0-9].{12}|[0-4][0-9][0-9][0-9][0-9].{8})|2(?:[3-9][0-9][0-9][0-9][0-9].{8}|[0-2][0-9][0-9][0-9][0-9].{12})|4(?:[0-24-8][0-9][0-9][0-9][0-9].{8}|[39][0-9][0-9][0-9][0-9].{12})|3(?:[1-9][0-9][0-9][0-9][0-9].{8}|0[0-9][0-9][0-9][0-9].{16})|6[0-9][0-9][0-9][0-9][0-9].{32}|9[0-9][0-9][0-9][0-9][0-9].{20}|0[0-9][0-9][0-9][0-9][0-9].{8})|4(?:4(?:[0-289][0-9][0-9][0-9][0-9].{48}|[34][0-9][0-9][0-9][0-9].{56}|[56][0-9][0-9][0-9][0-9].{44}|7[0-9][0-9][0-9][0-9].{60})|0(?:[0-2][0-9][0-9][0-9][0-9].{172}|[34][0-9][0-9][0-9][0-9].{44}|5[0-9][0-9][0-9][0-9].{28}|6[0-9][0-9][0-9][0-9].{92})|5(?:[0-35][0-9][0-9][0-9][0-9].{48}|4[0-9][0-9][0-9][0-9].{136})|8(?:9[0-9][0-9][0-9][0-9].{276}|8[0-9][0-9][0-9][0-9].{88})|3[7-9][0-9][0-9][0-9][0-9].{48})|2[0-9][0-9][0-9][0-9][0-9][0-9].{4})|3(?:0(?:0(?:[127-9][0-9][0-9][0-9][0-9].{8}|[34][0-9][0-9][0-9][0-9].{16}|[56][0-9][0-9][0-9][0-9].{12}|0[0-9][0-9][0-9][0-9].{24})|6(?:[1-36][0-9][0-9][0-9][0-9].{12}|[57-9][0-9][0-9][0-9][0-9].{8}|[04][0-9][0-9][0-9][0-9].{16})|9(?:[0-59][0-9][0-9][0-9][0-9].{12}|[78][0-9][0-9][0-9][0-9].{32}|6[0-9][0-9][0-9][0-9].{56})|1(?:[16-9][0-9][0-9][0-9][0-9].{8}|[2-5][0-9][0-9][0-9][0-9].{16}|0[0-9][0-9][0-9][0-9].{40})|4(?:[0-5][0-9][0-9][0-9][0-9].{8}|[7-9][0-9][0-9][0-9][0-9].{12}|6[0-9][0-9][0-9][0-9].{40})|8(?:[1-35-79][0-9][0-9][0-9][0-9].{8}|[48][0-9][0-9][0-9][0-9].{12}|0[0-9][0-9][0-9][0-9].{40})|5(?:[1-35-9][0-9][0-9][0-9][0-9].{12}|0[0-9][0-9][0-9][0-9].{40}|4[0-9][0-9][0-9][0-9].{16})|3(?:[4-9][0-9][0-9][0-9][0-9].{8}|[0-3][0-9][0-9][0-9][0-9].{24})|7(?:[1-9][0-9][0-9][0-9][0-9].{8}|0[0-9][0-9][0-9][0-9].{12})|2[0-9][0-9][0-9][0-9][0-9].{24})|4(?:5(?:[1-368][0-9][0-9][0-9][0-9].{8}|[05][0-9][0-9][0-9][0-9].{12}|4[0-9][0-9][0-9][0-9].{16}|7[0-9][0-9][0-9][0-9].{20}|9[0-9][0-9][0-9][0-9].{84})|7(?:[1-35][0-9][0-9][0-9][0-9].{12}|[46][0-9][0-9][0-9][0-9].{84}|[7-9][0-9][0-9][0-9][0-9].{8}|0[0-9][0-9][0-9][0-9].{20})|6(?:[0-3568][0-9][0-9][0-9][0-9].{20}|[47][0-9][0-9][0-9][0-9].{16}|9[0-9][0-9][0-9][0-9].{84})|0(?:[0-24-8][0-9][0-9][0-9][0-9].{8}|3[0-9][0-9][0-9][0-9].{12}|9[0-9][0-9][0-9][0-9].{32})|1(?:[0-389][0-9][0-9][0-9][0-9].{8}|[4-7][0-9][0-9][0-9][0-9].{12})|3(?:[2-9][0-9][0-9][0-9][0-9].{8}|[01][0-9][0-9][0-9][0-9].{16})|8(?:[02-8][0-9][0-9][0-9][0-9].{12}|[19][0-9][0-9][0-9][0-9].{8})|2(?:[1-9][0-9][0-9][0-9][0-9].{8}|0[0-9][0-9][0-9][0-9].{12})|4(?:[0-79][0-9][0-9][0-9][0-9].{8}|8[0-9][0-9][0-9][0-9].{60})|9[0-9][0-9][0-9][0-9][0-9].{16})|[278][0-9][0-9][0-9][0-9][0-9][0-9].{4})|[79][0-9][0-9][0-9][0-9][0-9][0-9][0-9].{4})|8(?:9(?:9(?:1(?:0[0-9][0-9][0-9][0-9].{240}|2[0-9][0-9][0-9][0-9].{656}|3[0-9][0-9][0-9][0-9].{260}|4[0-9][0-9][0-9][0-9].{188}|5[0-9][0-9][0-9][0-9].{664}|6[0-9][0-9][0-9][0-9].{204}|7[0-9][0-9][0-9][0-9].{144}|8[0-9][0-9][0-9][0-9].{164}|9[0-9][0-9][0-9][0-9].{8})|9(?:2[0-9][0-9][0-9][0-9].{480}|3[0-9][0-9][0-9][0-9].{396}|4[0-9][0-9][0-9][0-9].{108}|5[0-9][0-9][0-9][0-9].{472}|8[0-9][0-9][0-9][0-9].{120}|0[0-9][0-9][0-9][0-9].{16}|6[0-9][0-9][0-9][0-9].{24}|7[0-9][0-9][0-9][0-9].{96}|9[0-9][0-9][0-9][0-9].{52})|4(?:[48][0-9][0-9][0-9][0-9].{180}|0[0-9][0-9][0-9][0-9].{120}|1[0-9][0-9][0-9][0-9].{888}|2[0-9][0-9][0-9][0-9].{324}|3[0-9][0-9][0-9][0-9].{672}|5[0-9][0-9][0-9][0-9].{212}|6[0-9][0-9][0-9][0-9].{12}|9[0-9][0-9][0-9][0-9].{28})|8(?:[24][0-9][0-9][0-9][0-9].{180}|0[0-9][0-9][0-9][0-9].{992}|1[0-9][0-9][0-9][0-9].{144}|8[0-9][0-9][0-9][0-9].{612}|9[0-9][0-9][0-9][0-9].{200}|5[0-9][0-9][0-9][0-9].{36}|6[0-9][0-9][0-9][0-9].{24}|7[0-9][0-9][0-9][0-9].{8})|7(?:[01][0-9][0-9][0-9][0-9].{4}|2[0-9][0-9][0-9][0-9].{536}|4[0-9][0-9][0-9][0-9].{180}|5[0-9][0-9][0-9][0-9].{104}|6[0-9][0-9][0-9][0-9].{232}|9[0-9][0-9][0-9][0-9].{128}|7[0-9][0-9][0-9][0-9].{92}|8[0-9][0-9][0-9][0-9].{8})|0(?:2[0-9][0-9][0-9][0-9].{164}|3[0-9][0-9][0-9][0-9].{240}|4[0-9][0-9][0-9][0-9].{828}|6[0-9][0-9][0-9][0-9].{180}|7[0-9][0-9][0-9][0-9].{376}|8[0-9][0-9][0-9][0-9].{444}|1[0-9][0-9][0-9][0-9].{52}|9[0-9][0-9][0-9][0-9].{8})|6(?:0[0-9][0-9][0-9][0-9].{120}|1[0-9][0-9][0-9][0-9].{148}|2[0-9][0-9][0-9][0-9].{176}|3[0-9][0-9][0-9][0-9].{228}|4[0-9][0-9][0-9][0-9].{180}|6[0-9][0-9][0-9][0-9].{296}|5[0-9][0-9][0-9][0-9].{24}|9[0-9][0-9][0-9][0-9].{8})|2(?:[26][0-9][0-9][0-9][0-9].{444}|[37][0-9][0-9][0-9][0-9].{24}|1[0-9][0-9][0-9][0-9].{164}|4[0-9][0-9][0-9][0-9].{148}|8[0-9][0-9][0-9][0-9].{496}|9[0-9][0-9][0-9][0-9].{520}|5[0-9][0-9][0-9][0-9].{56})|5(?:[289][0-9][0-9][0-9][0-9].{180}|0[0-9][0-9][0-9][0-9].{120}|3[0-9][0-9][0-9][0-9].{216}|4[0-9][0-9][0-9][0-9].{200}|5[0-9][0-9][0-9][0-9].{648}|7[0-9][0-9][0-9][0-9].{140}|6[0-9][0-9][0-9][0-9].{12})|3(?:3[0-9][0-9][0-9][0-9].{260}|4[0-9][0-9][0-9][0-9].{240}|6[0-9][0-9][0-9][0-9].{312}|8[0-9][0-9][0-9][0-9].{104}|7[0-9][0-9][0-9][0-9].{24}|9[0-9][0-9][0-9][0-9].{8}))|2(?:9(?:[17][0-9][0-9][0-9][0-9].{24}|0[0-9][0-9][0-9][0-9].{712}|3[0-9][0-9][0-9][0-9].{200}|4[0-9][0-9][0-9][0-9].{108}|8[0-9][0-9][0-9][0-9].{308}|9[0-9][0-9][0-9][0-9].{604}|2[0-9][0-9][0-9][0-9].{52}|6[0-9][0-9][0-9][0-9].{96}|5[0-9][0-9][0-9][0-9].{4})|1(?:2[0-9][0-9][0-9][0-9].{144}|4[0-9][0-9][0-9][0-9].{188}|5[0-9][0-9][0-9][0-9].{260}|6[0-9][0-9][0-9][0-9].{204}|7[0-9][0-9][0-9][0-9].{480}|8[0-9][0-9][0-9][0-9].{164}|9[0-9][0-9][0-9][0-9].{268}|3[0-9][0-9][0-9][0-9].{16}|0[0-9][0-9][0-9][0-9].{8})|2(?:[68][0-9][0-9][0-9][0-9].{444}|[25][0-9][0-9][0-9][0-9].{8}|0[0-9][0-9][0-9][0-9].{132}|1[0-9][0-9][0-9][0-9].{396}|4[0-9][0-9][0-9][0-9].{148}|7[0-9][0-9][0-9][0-9].{164}|9[0-9][0-9][0-9][0-9].{612}|3[0-9][0-9][0-9][0-9].{24})|6(?:[89][0-9][0-9][0-9][0-9].{4}|0[0-9][0-9][0-9][0-9].{180}|1[0-9][0-9][0-9][0-9].{416}|2[0-9][0-9][0-9][0-9].{176}|3[0-9][0-9][0-9][0-9].{188}|4[0-9][0-9][0-9][0-9].{336}|6[0-9][0-9][0-9][0-9].{164}|5[0-9][0-9][0-9][0-9].{24})|5(?:[26][0-9][0-9][0-9][0-9].{12}|1[0-9][0-9][0-9][0-9].{112}|3[0-9][0-9][0-9][0-9].{268}|4[0-9][0-9][0-9][0-9].{200}|7[0-9][0-9][0-9][0-9].{140}|9[0-9][0-9][0-9][0-9].{376}|8[0-9][0-9][0-9][0-9].{92}|5[0-9][0-9][0-9][0-9].{8})|4(?:[26][0-9][0-9][0-9][0-9].{12}|0[0-9][0-9][0-9][0-9].{656}|1[0-9][0-9][0-9][0-9].{180}|7[0-9][0-9][0-9][0-9].{228}|8[0-9][0-9][0-9][0-9].{104}|3[0-9][0-9][0-9][0-9].{56}|9[0-9][0-9][0-9][0-9].{28}|5[0-9][0-9][0-9][0-9].{8})|7(?:[46][0-9][0-9][0-9][0-9].{12}|[01][0-9][0-9][0-9][0-9].{4}|[89][0-9][0-9][0-9][0-9].{8}|2[0-9][0-9][0-9][0-9].{232}|3[0-9][0-9][0-9][0-9].{324}|5[0-9][0-9][0-9][0-9].{104}|7[0-9][0-9][0-9][0-9].{120})|8(?:0[0-9][0-9][0-9][0-9].{344}|1[0-9][0-9][0-9][0-9].{144}|4[0-9][0-9][0-9][0-9].{368}|6[0-9][0-9][0-9][0-9].{212}|7[0-9][0-9][0-9][0-9].{24}|9[0-9][0-9][0-9][0-9].{52}|8[0-9][0-9][0-9][0-9].{8})|0(?:[03][0-9][0-9][0-9][0-9].{120}|[256][0-9][0-9][0-9][0-9].{8}|4[0-9][0-9][0-9][0-9].{128}|7[0-9][0-9][0-9][0-9].{204}|9[0-9][0-9][0-9][0-9].{272}|1[0-9][0-9][0-9][0-9].{52})|3(?:[0469][0-9][0-9][0-9][0-9].{8}|1[0-9][0-9][0-9][0-9].{360}|3[0-9][0-9][0-9][0-9].{120}|7[0-9][0-9][0-9][0-9].{296}|8[0-9][0-9][0-9][0-9].{104}|5[0-9][0-9][0-9][0-9].{4}))|0(?:3(?:[45][0-9][0-9][0-9][0-9].{104}|[69][0-9][0-9][0-9][0-9].{8}|0[0-9][0-9][0-9][0-9].{392}|1[0-9][0-9][0-9][0-9].{524}|2[0-9][0-9][0-9][0-9].{808}|3[0-9][0-9][0-9][0-9].{120}|7[0-9][0-9][0-9][0-9].{412})|5(?:4[0-9][0-9][0-9][0-9].{336}|5[0-9][0-9][0-9][0-9].{120}|7[0-9][0-9][0-9][0-9].{140}|8[0-9][0-9][0-9][0-9].{232}|9[0-9][0-9][0-9][0-9].{608}|0[0-9][0-9][0-9][0-9].{92}|6[0-9][0-9][0-9][0-9].{12})|4(?:[26][0-9][0-9][0-9][0-9].{12}|0[0-9][0-9][0-9][0-9].{456}|1[0-9][0-9][0-9][0-9].{196}|3[0-9][0-9][0-9][0-9].{240}|4[0-9][0-9][0-9][0-9].{120}|5[0-9][0-9][0-9][0-9].{480})|2(?:0[0-9][0-9][0-9][0-9].{104}|1[0-9][0-9][0-9][0-9].{240}|2[0-9][0-9][0-9][0-9].{120}|4[0-9][0-9][0-9][0-9].{148}|5[0-9][0-9][0-9][0-9].{356}|3[0-9][0-9][0-9][0-9].{12})|7(?:[01][0-9][0-9][0-9][0-9].{4}|5[0-9][0-9][0-9][0-9].{104}|6[0-9][0-9][0-9][0-9].{228}|7[0-9][0-9][0-9][0-9].{396}|9[0-9][0-9][0-9][0-9].{488}|8[0-9][0-9][0-9][0-9].{8})|0(?:[03][0-9][0-9][0-9][0-9].{144}|7[0-9][0-9][0-9][0-9].{312}|8[0-9][0-9][0-9][0-9].{916}|1[0-9][0-9][0-9][0-9].{52}|2[0-9][0-9][0-9][0-9].{8}|4[0-9][0-9][0-9][0-9].{4})|9(?:7[0-9][0-9][0-9][0-9].{344}|8[0-9][0-9][0-9][0-9].{388}|9[0-9][0-9][0-9][0-9].{176}|0[0-9][0-9][0-9][0-9].{52}|2[0-9][0-9][0-9][0-9].{16}|1[0-9][0-9][0-9][0-9].{8})|8(?:4[0-9][0-9][0-9][0-9].{368}|5[0-9][0-9][0-9][0-9].{852}|1[0-9][0-9][0-9][0-9].{96}|6[0-9][0-9][0-9][0-9].{24}|9[0-9][0-9][0-9][0-9].{52}|0[0-9][0-9][0-9][0-9].{8})|1(?:1[0-9][0-9][0-9][0-9].{164}|3[0-9][0-9][0-9][0-9].{536}|0[0-9][0-9][0-9][0-9].{24}|2[0-9][0-9][0-9][0-9].{8})|6(?:0[0-9][0-9][0-9][0-9].{272}|1[0-9][0-9][0-9][0-9].{24}|4[0-9][0-9][0-9][0-9].{4}|5[0-9][0-9][0-9][0-9].{8}))|1(?:0(?:[02][0-9][0-9][0-9][0-9].{8}|4[0-9][0-9][0-9][0-9].{144}|5[0-9][0-9][0-9][0-9].{324}|6[0-9][0-9][0-9][0-9].{616}|7[0-9][0-9][0-9][0-9].{204}|1[0-9][0-9][0-9][0-9].{52}|3[0-9][0-9][0-9][0-9].{56})|1(?:4[0-9][0-9][0-9][0-9].{188}|6[0-9][0-9][0-9][0-9].{204}|8[0-9][0-9][0-9][0-9].{396}|9[0-9][0-9][0-9][0-9].{392}|0[0-9][0-9][0-9][0-9].{24}|2[0-9][0-9][0-9][0-9].{16}|1[0-9][0-9][0-9][0-9].{8})|5(?:[16][0-9][0-9][0-9][0-9].{12}|3[0-9][0-9][0-9][0-9].{268}|4[0-9][0-9][0-9][0-9].{336}|5[0-9][0-9][0-9][0-9].{120}|7[0-9][0-9][0-9][0-9].{140}|0[0-9][0-9][0-9][0-9].{52})|3(?:[69][0-9][0-9][0-9][0-9].{8}|7[0-9][0-9][0-9][0-9].{296}|8[0-9][0-9][0-9][0-9].{104}|0[0-9][0-9][0-9][0-9].{24}|3[0-9][0-9][0-9][0-9].{92}|5[0-9][0-9][0-9][0-9].{12})|4(?:3[0-9][0-9][0-9][0-9].{188}|4[0-9][0-9][0-9][0-9].{120}|8[0-9][0-9][0-9][0-9].{104}|6[0-9][0-9][0-9][0-9].{12}|5[0-9][0-9][0-9][0-9].{8})|2(?:[35][0-9][0-9][0-9][0-9].{8}|2[0-9][0-9][0-9][0-9].{120}|4[0-9][0-9][0-9][0-9].{148}|6[0-9][0-9][0-9][0-9].{260})|6(?:0[0-9][0-9][0-9][0-9].{232}|5[0-9][0-9][0-9][0-9].{24}|9[0-9][0-9][0-9][0-9].{28}|7[0-9][0-9][0-9][0-9].{4})|7(?:[01][0-9][0-9][0-9][0-9].{4}|7[0-9][0-9][0-9][0-9].{120}|8[0-9][0-9][0-9][0-9].{8})|8(?:4[0-9][0-9][0-9][0-9].{368}|0[0-9][0-9][0-9][0-9].{8}|9[0-9][0-9][0-9][0-9].{4})|9(?:7[0-9][0-9][0-9][0-9].{344}|2[0-9][0-9][0-9][0-9].{96}))|7(?:7(?:[01][0-9][0-9][0-9][0-9].{4}|2[0-9][0-9][0-9][0-9].{396}|4[0-9][0-9][0-9][0-9].{232}|5[0-9][0-9][0-9][0-9].{92}|6[0-9][0-9][0-9][0-9].{56}|9[0-9][0-9][0-9][0-9].{96}|8[0-9][0-9][0-9][0-9].{8})|1(?:0[0-9][0-9][0-9][0-9].{104}|3[0-9][0-9][0-9][0-9].{272}|6[0-9][0-9][0-9][0-9].{204}|2[0-9][0-9][0-9][0-9].{24}|8[0-9][0-9][0-9][0-9].{16})|0(?:0[0-9][0-9][0-9][0-9].{120}|4[0-9][0-9][0-9][0-9].{144}|5[0-9][0-9][0-9][0-9].{376}|1[0-9][0-9][0-9][0-9].{52})|2(?:1[0-9][0-9][0-9][0-9].{164}|2[0-9][0-9][0-9][0-9].{120}|4[0-9][0-9][0-9][0-9].{148}|3[0-9][0-9][0-9][0-9].{24})|5(?:0[0-9][0-9][0-9][0-9].{104}|5[0-9][0-9][0-9][0-9].{120}|7[0-9][0-9][0-9][0-9].{140}|6[0-9][0-9][0-9][0-9].{12})|4(?:4[0-9][0-9][0-9][0-9].{120}|9[0-9][0-9][0-9][0-9].{344}|6[0-9][0-9][0-9][0-9].{12})|3(?:7[0-9][0-9][0-9][0-9].{296}|8[0-9][0-9][0-9][0-9].{104}|9[0-9][0-9][0-9][0-9].{8})|6(?:[56][0-9][0-9][0-9][0-9].{4}|9[0-9][0-9][0-9][0-9].{28})|8(?:7[0-9][0-9][0-9][0-9].{24}|9[0-9][0-9][0-9][0-9].{52})|97[0-9][0-9][0-9][0-9].{8})|5(?:6(?:9(?:[289][0-9][0-9][0-9].{8}|0[0-9][0-9][0-9].{240}|1[0-9][0-9][0-9].{524}|3[0-9][0-9][0-9].{340}|4[0-9][0-9][0-9].{228}|5[0-9][0-9][0-9].{480}|7[0-9][0-9][0-9].{312}|6[0-9][0-9][0-9].{4})|8(?:1[0-9][0-9][0-9].{228}|0[0-9][0-9][0-9].{4}))|0(?:8(?:0[0-9][0-9][0-9].{488}|1[0-9][0-9][0-9].{744}|2[0-9][0-9][0-9].{180}|9[0-9][0-9][0-9].{176})|7(?:9[0-9][0-9][0-9].{608}|7[0-9][0-9][0-9].{92})|20[0-9][0-9][0-9].{216})|2(?:3(?:[24][0-9][0-9][0-9].{24}|3[0-9][0-9][0-9].{28})|2(?:7[0-9][0-9][0-9].{876}|6[0-9][0-9][0-9].{4})|00[0-9][0-9][0-9].{104})|8(?:9(?:5[0-9][0-9][0-9].{216}|6[0-9][0-9][0-9].{204}|8[0-9][0-9][0-9].{696}|7[0-9][0-9][0-9].{8})|8[89][0-9][0-9][0-9].{144})|1(?:0[0-9][0-9][0-9][0-9].{148}|23[0-9][0-9][0-9].{104})|7(?:0[01][0-9][0-9][0-9].{4}|95[0-9][0-9][0-9].{56})|500[0-9][0-9][0-9].{216}|900[0-9][0-9][0-9].{204})|30(?:0(?:[89][0-9][0-9][0-9].{340}|1[0-9][0-9][0-9].{240}|2[0-9][0-9][0-9].{672}|3[0-9][0-9][0-9].{604}|4[0-9][0-9][0-9].{648}|5[0-9][0-9][0-9].{216}|6[0-9][0-9][0-9].{924}|0[0-9][0-9][0-9].{52}|7[0-9][0-9][0-9].{56})|10[0-9][0-9][0-9].{340})|84(?:0(?:1[0-9][0-9][0-9].{216}|2[0-9][0-9][0-9].{420}|4[0-9][0-9][0-9].{52})|4[0-9][0-9][0-9][0-9].{104}))|2(?:6(?:2(?:[57][0-9][0-9][0-9][0-9].{52}|[02][0-9][0-9][0-9][0-9].{8}|1[0-9][0-9][0-9][0-9].{268}|3[0-9][0-9][0-9][0-9].{312}|4[0-9][0-9][0-9][0-9].{132}|6[0-9][0-9][0-9][0-9].{120}|8[0-9][0-9][0-9][0-9].{308}|9[0-9][0-9][0-9][0-9].{164})|6(?:[7-9][0-9][0-9][0-9][0-9].{12}|1[0-9][0-9][0-9][0-9].{416}|2[0-9][0-9][0-9][0-9].{176}|3[0-9][0-9][0-9][0-9].{188}|4[0-9][0-9][0-9][0-9].{336}|0[0-9][0-9][0-9][0-9].{56}|5[0-9][0-9][0-9][0-9].{24}|6[0-9][0-9][0-9][0-9].{8})|1(?:1[0-9][0-9][0-9][0-9].{120}|2[0-9][0-9][0-9][0-9].{112}|3[0-9][0-9][0-9][0-9].{568}|4[0-9][0-9][0-9][0-9].{188}|5[0-9][0-9][0-9][0-9].{268}|6[0-9][0-9][0-9][0-9].{204}|0[0-9][0-9][0-9][0-9].{24})|8(?:1[0-9][0-9][0-9][0-9].{148}|4[0-9][0-9][0-9][0-9].{568}|5[0-9][0-9][0-9][0-9].{260}|2[0-9][0-9][0-9][0-9].{52}|6[0-9][0-9][0-9][0-9].{24}|8[0-9][0-9][0-9][0-9].{12}|0[0-9][0-9][0-9][0-9].{8})|0(?:[56][0-9][0-9][0-9][0-9].{120}|[18][0-9][0-9][0-9][0-9].{52}|[02][0-9][0-9][0-9][0-9].{8}|4[0-9][0-9][0-9][0-9].{128}|7[0-9][0-9][0-9][0-9].{240}|9[0-9][0-9][0-9][0-9].{12})|5(?:[1-3][0-9][0-9][0-9][0-9].{12}|0[0-9][0-9][0-9][0-9].{704}|6[0-9][0-9][0-9][0-9].{144}|7[0-9][0-9][0-9][0-9].{140}|9[0-9][0-9][0-9][0-9].{232}|5[0-9][0-9][0-9][0-9].{8})|3(?:[1-6][0-9][0-9][0-9][0-9].{12}|0[0-9][0-9][0-9][0-9].{164}|7[0-9][0-9][0-9][0-9].{296}|8[0-9][0-9][0-9][0-9].{104}|9[0-9][0-9][0-9][0-9].{8})|9(?:7[0-9][0-9][0-9][0-9].{108}|9[0-9][0-9][0-9][0-9].{104}|5[0-9][0-9][0-9][0-9].{56}|6[0-9][0-9][0-9][0-9].{24}|0[0-9][0-9][0-9][0-9].{8})|4(?:[1-6][0-9][0-9][0-9][0-9].{12}|0[0-9][0-9][0-9][0-9].{4})|7[0-9][0-9][0-9][0-9][0-9].{12})|1(?:0(?:[18][0-9][0-9][0-9][0-9].{52}|[02][0-9][0-9][0-9][0-9].{8}|5[0-9][0-9][0-9][0-9].{120}|6[0-9][0-9][0-9][0-9].{112}|3[0-9][0-9][0-9][0-9].{56}|7[0-9][0-9][0-9][0-9].{16}|9[0-9][0-9][0-9][0-9].{12}|4[0-9][0-9][0-9][0-9].{4})|1(?:[36-9][0-9][0-9][0-9][0-9].{12}|[01][0-9][0-9][0-9][0-9].{120}|2[0-9][0-9][0-9][0-9].{760}|4[0-9][0-9][0-9][0-9].{188}|5[0-9][0-9][0-9][0-9].{260})|2(?:[289][0-9][0-9][0-9][0-9].{52}|[01][0-9][0-9][0-9][0-9].{8}|4[0-9][0-9][0-9][0-9].{148}|5[0-9][0-9][0-9][0-9].{260}|3[0-9][0-9][0-9][0-9].{24})|5(?:[0-2][0-9][0-9][0-9][0-9].{96}|3[0-9][0-9][0-9][0-9].{188}|4[0-9][0-9][0-9][0-9].{336}|7[0-9][0-9][0-9][0-9].{140}|5[0-9][0-9][0-9][0-9].{8})|3(?:[36][0-9][0-9][0-9][0-9].{8}|7[0-9][0-9][0-9][0-9].{296}|8[0-9][0-9][0-9][0-9].{104}|0[0-9][0-9][0-9][0-9].{24}|4[0-9][0-9][0-9][0-9].{52})|7(?:0[0-9][0-9][0-9][0-9].{120}|5[0-9][0-9][0-9][0-9].{104}|8[0-9][0-9][0-9][0-9].{616}|4[0-9][0-9][0-9][0-9].{12}|7[0-9][0-9][0-9][0-9].{92})|4(?:[5-9][0-9][0-9][0-9][0-9].{12}|[04][0-9][0-9][0-9][0-9].{8}|3[0-9][0-9][0-9][0-9].{188}|2[0-9][0-9][0-9][0-9].{56})|6(?:[15][0-9][0-9][0-9][0-9].{24}|0[0-9][0-9][0-9][0-9].{136}|2[0-9][0-9][0-9][0-9].{176}|6[0-9][0-9][0-9][0-9].{416})|8(?:[3-9][0-9][0-9][0-9][0-9].{12}|[02][0-9][0-9][0-9][0-9].{8}|1[0-9][0-9][0-9][0-9].{56})|9(?:[0-7][0-9][0-9][0-9][0-9].{12}|8[0-9][0-9][0-9][0-9].{36}|9[0-9][0-9][0-9][0-9].{4}))|5(?:5(?:[12][0-9][0-9][0-9][0-9].{96}|[78][0-9][0-9][0-9][0-9].{24}|3[0-9][0-9][0-9][0-9].{532}|4[0-9][0-9][0-9][0-9].{336}|6[0-9][0-9][0-9][0-9].{12}|9[0-9][0-9][0-9][0-9].{28}|0[0-9][0-9][0-9][0-9].{4}|5[0-9][0-9][0-9][0-9].{8})|6(?:2[0-9][0-9][0-9][0-9].{176}|3[0-9][0-9][0-9][0-9].{360}|6[0-9][0-9][0-9][0-9].{156}|8[0-9][0-9][0-9][0-9].{228}|9[0-9][0-9][0-9][0-9].{132}|5[0-9][0-9][0-9][0-9].{84}|7[0-9][0-9][0-9][0-9].{56}|0[0-9][0-9][0-9][0-9].{8})|4(?:3[0-9][0-9][0-9][0-9].{480}|4[0-9][0-9][0-9][0-9].{120}|7[0-9][0-9][0-9][0-9].{164}|8[0-9][0-9][0-9][0-9].{568}|9[0-9][0-9][0-9][0-9].{184}|2[0-9][0-9][0-9][0-9].{56}|0[0-9][0-9][0-9][0-9].{4}|5[0-9][0-9][0-9][0-9].{8})|1(?:[36][0-9][0-9][0-9][0-9].{204}|[025][0-9][0-9][0-9][0-9].{8}|1[0-9][0-9][0-9][0-9].{120}|4[0-9][0-9][0-9][0-9].{104}|7[0-9][0-9][0-9][0-9].{324}|9[0-9][0-9][0-9][0-9].{504}|8[0-9][0-9][0-9][0-9].{60})|2(?:[026][0-9][0-9][0-9][0-9].{4}|[78][0-9][0-9][0-9][0-9].{8}|3[0-9][0-9][0-9][0-9].{376}|4[0-9][0-9][0-9][0-9].{200}|1[0-9][0-9][0-9][0-9].{92}|5[0-9][0-9][0-9][0-9].{12})|9(?:0[0-9][0-9][0-9][0-9].{164}|4[0-9][0-9][0-9][0-9].{368}|7[0-9][0-9][0-9][0-9].{344}|2[0-9][0-9][0-9][0-9].{16}|8[0-9][0-9][0-9][0-9].{92}|5[0-9][0-9][0-9][0-9].{4})|7(?:[27][0-9][0-9][0-9][0-9].{8}|5[0-9][0-9][0-9][0-9].{236}|6[0-9][0-9][0-9][0-9].{536}|4[0-9][0-9][0-9][0-9].{12})|[038][0-9][0-9][0-9][0-9][0-9].{4})|0(?:9(?:[89][0-9][0-9][0-9][0-9].{52}|2[0-9][0-9][0-9][0-9].{132}|4[0-9][0-9][0-9][0-9].{368}|6[0-9][0-9][0-9][0-9].{456}|7[0-9][0-9][0-9][0-9].{344}|3[0-9][0-9][0-9][0-9].{92}|5[0-9][0-9][0-9][0-9].{56}|0[0-9][0-9][0-9][0-9].{8})|5(?:[079][0-9][0-9][0-9][0-9].{4}|[68][0-9][0-9][0-9][0-9].{12}|1[0-9][0-9][0-9][0-9].{504}|2[0-9][0-9][0-9][0-9].{268}|3[0-9][0-9][0-9][0-9].{232}|4[0-9][0-9][0-9][0-9].{336}|5[0-9][0-9][0-9][0-9].{156})|4(?:[28][0-9][0-9][0-9][0-9].{12}|[67][0-9][0-9][0-9][0-9].{24}|[05][0-9][0-9][0-9][0-9].{8}|1[0-9][0-9][0-9][0-9].{360}|3[0-9][0-9][0-9][0-9].{128}|4[0-9][0-9][0-9][0-9].{120})|6(?:[01][0-9][0-9][0-9][0-9].{4}|[57][0-9][0-9][0-9][0-9].{8}|2[0-9][0-9][0-9][0-9].{176}|6[0-9][0-9][0-9][0-9].{184}|8[0-9][0-9][0-9][0-9].{212}|9[0-9][0-9][0-9][0-9].{28})|1(?:[02-4][0-9][0-9][0-9][0-9].{8}|[19][0-9][0-9][0-9][0-9].{120}|[56][0-9][0-9][0-9][0-9].{204}|7[0-9][0-9][0-9][0-9].{564}|8[0-9][0-9][0-9][0-9].{164})|2(?:[02579][0-9][0-9][0-9][0-9].{4}|[68][0-9][0-9][0-9][0-9].{12}|3[0-9][0-9][0-9][0-9].{164}|4[0-9][0-9][0-9][0-9].{144}|1[0-9][0-9][0-9][0-9].{52})|7(?:[135][0-9][0-9][0-9][0-9].{4}|[89][0-9][0-9][0-9][0-9].{24}|[27][0-9][0-9][0-9][0-9].{8}|0[0-9][0-9][0-9][0-9].{120}|4[0-9][0-9][0-9][0-9].{200})|[038][0-9][0-9][0-9][0-9][0-9].{4}))|0(?:5(?:1(?:[01][0-9][0-9][0-9][0-9].{32}|3[0-9][0-9][0-9][0-9].{156}|4[0-9][0-9][0-9][0-9].{188}|6[0-9][0-9][0-9][0-9].{204}|7[0-9][0-9][0-9][0-9].{260}|9[0-9][0-9][0-9][0-9].{120}|5[0-9][0-9][0-9][0-9].{96}|8[0-9][0-9][0-9][0-9].{72}|2[0-9][0-9][0-9][0-9].{8})|2(?:[05][0-9][0-9][0-9][0-9].{8}|1[0-9][0-9][0-9][0-9].{360}|3[0-9][0-9][0-9][0-9].{132}|4[0-9][0-9][0-9][0-9].{156}|6[0-9][0-9][0-9][0-9].{144}|8[0-9][0-9][0-9][0-9].{112}|9[0-9][0-9][0-9][0-9].{128}|2[0-9][0-9][0-9][0-9].{32}|7[0-9][0-9][0-9][0-9].{4})|5(?:[12][0-9][0-9][0-9][0-9].{96}|3[0-9][0-9][0-9][0-9].{232}|4[0-9][0-9][0-9][0-9].{336}|7[0-9][0-9][0-9][0-9].{140}|8[0-9][0-9][0-9][0-9].{212}|9[0-9][0-9][0-9][0-9].{136}|0[0-9][0-9][0-9][0-9].{52}|6[0-9][0-9][0-9][0-9].{12}|5[0-9][0-9][0-9][0-9].{8})|3(?:2[0-9][0-9][0-9][0-9].{228}|3[0-9][0-9][0-9][0-9].{120}|4[0-9][0-9][0-9][0-9].{200}|8[0-9][0-9][0-9][0-9].{104}|5[0-9][0-9][0-9][0-9].{24}|6[0-9][0-9][0-9][0-9].{12}|7[0-9][0-9][0-9][0-9].{92}|9[0-9][0-9][0-9][0-9].{60}|0[0-9][0-9][0-9][0-9].{8})|4(?:[24][0-9][0-9][0-9][0-9].{120}|[06][0-9][0-9][0-9][0-9].{12}|3[0-9][0-9][0-9][0-9].{188}|7[0-9][0-9][0-9][0-9].{296}|9[0-9][0-9][0-9][0-9].{144}|1[0-9][0-9][0-9][0-9].{52}|5[0-9][0-9][0-9][0-9].{24})|9(?:[19][0-9][0-9][0-9][0-9].{12}|[23][0-9][0-9][0-9][0-9].{16}|6[0-9][0-9][0-9][0-9].{108}|7[0-9][0-9][0-9][0-9].{344}|0[0-9][0-9][0-9][0-9].{52}|5[0-9][0-9][0-9][0-9].{56}|8[0-9][0-9][0-9][0-9].{36})|0(?:[1245][0-9][0-9][0-9][0-9].{8}|6[0-9][0-9][0-9][0-9].{120}|3[0-9][0-9][0-9][0-9].{56}|7[0-9][0-9][0-9][0-9].{84}|8[0-9][0-9][0-9][0-9].{88}|9[0-9][0-9][0-9][0-9].{12}|0[0-9][0-9][0-9][0-9].{4})|6(?:0[0-9][0-9][0-9][0-9].{184}|2[0-9][0-9][0-9][0-9].{176}|5[0-9][0-9][0-9][0-9].{164}|1[0-9][0-9][0-9][0-9].{88}|3[0-9][0-9][0-9][0-9].{32}|9[0-9][0-9][0-9][0-9].{28}|6[0-9][0-9][0-9][0-9].{8})|8(?:[01][0-9][0-9][0-9][0-9].{8}|2[0-9][0-9][0-9][0-9].{456}|6[0-9][0-9][0-9][0-9].{416}|8[0-9][0-9][0-9][0-9].{120}|5[0-9][0-9][0-9][0-9].{12})|7(?:[017][0-9][0-9][0-9][0-9].{8}|3[0-9][0-9][0-9][0-9].{164}|5[0-9][0-9][0-9][0-9].{24}|6[0-9][0-9][0-9][0-9].{12}))|6(?:1(?:0[0-9][0-9][0-9][0-9].{372}|2[0-9][0-9][0-9][0-9].{204}|3[0-9][0-9][0-9][0-9].{272}|4[0-9][0-9][0-9][0-9].{308}|6[0-9][0-9][0-9][0-9].{376}|1[0-9][0-9][0-9][0-9].{28})|0(?:8[0-9][0-9][0-9][0-9].{164}|9[0-9][0-9][0-9][0-9].{144}|6[0-9][0-9][0-9][0-9].{52}|7[0-9][0-9][0-9][0-9].{56}|0[0-9][0-9][0-9][0-9].{8})|6(?:0[0-9][0-9][0-9][0-9].{232}|9[0-9][0-9][0-9][0-9].{136})|9(?:0[0-9][0-9][0-9][0-9].{176}|9[0-9][0-9][0-9][0-9].{184})|5(?:0[0-9][0-9][0-9][0-9].{456}|4[0-9][0-9][0-9][0-9].{12})|8(?:1[0-9][0-9][0-9][0-9].{92}|0[0-9][0-9][0-9][0-9].{4})|70[0-9][0-9][0-9][0-9].{128}|23[0-9][0-9][0-9][0-9].{24})|1(?:0(?:0[0-9][0-9][0-9][0-9].{376}|3[0-9][0-9][0-9][0-9].{240}|4[0-9][0-9][0-9][0-9].{156}|5[0-9][0-9][0-9][0-9].{524}|6[0-9][0-9][0-9][0-9].{328}|7[0-9][0-9][0-9][0-9].{308}|8[0-9][0-9][0-9][0-9].{232}|9[0-9][0-9][0-9][0-9].{372}|1[0-9][0-9][0-9][0-9].{52}|2[0-9][0-9][0-9][0-9].{44})|2(?:0[0-9][0-9][0-9][0-9].{148}|1[0-9][0-9][0-9][0-9].{340}|6[0-9][0-9][0-9][0-9].{492}|3[0-9][0-9][0-9][0-9].{24})|8(?:1[0-9][0-9][0-9][0-9].{12}|0[0-9][0-9][0-9][0-9].{4}|2[0-9][0-9][0-9][0-9].{8})|1(?:0[0-9][0-9][0-9][0-9].{272}|1[0-9][0-9][0-9][0-9].{548})|(?:38|90)[0-9][0-9][0-9][0-9].{4}|77[0-9][0-9][0-9][0-9].{92})|9(?:1(?:3[0-9][0-9][0-9][0-9].{272}|9[0-9][0-9][0-9][0-9].{92}|0[0-9][0-9][0-9][0-9].{4}|2[0-9][0-9][0-9][0-9].{8})|3(?:2[0-9][0-9][0-9][0-9].{156}|6[0-9][0-9][0-9][0-9].{8}|8[0-9][0-9][0-9][0-9].{4})|0(?:[26][0-9][0-9][0-9][0-9].{8}|1[0-9][0-9][0-9][0-9].{156})|[49]0[0-9][0-9][0-9][0-9].{8}|80[0-9][0-9][0-9][0-9].{52}|54[0-9][0-9][0-9][0-9].{4})|0(?:9(?:[0189][0-9][0-9][0-9][0-9].{4}|[257][0-9][0-9][0-9][0-9].{8}|3[0-9][0-9][0-9][0-9].{396}|6[0-9][0-9][0-9][0-9].{144}|4[0-9][0-9][0-9][0-9].{24})|7(?:[02579][0-9][0-9][0-9][0-9].{4}|[13][0-9][0-9][0-9][0-9].{8}|8[0-9][0-9][0-9][0-9].{396}|4[0-9][0-9][0-9][0-9].{12}|6[0-9][0-9][0-9][0-9].{16})|[0-68][0-9][0-9][0-9][0-9][0-9].{4})|88(?:0(?:1[0-9][0-9][0-9].{548}|5[0-9][0-9][0-9].{140}|6[0-9][0-9][0-9].{176}|8[0-9][0-9][0-9].{52}|9[0-9][0-9][0-9].{24}|0[0-9][0-9][0-9].{4}|7[0-9][0-9][0-9].{8})|10[0-9][0-9][0-9].{324})|3(?:0[1-9]|8[0-468]|3[02357])[0-9][0-9][0-9][0-9].{4})|1(?:1(?:1(?:0[0-9][0-9][0-9][0-9].{120}|2[0-9][0-9][0-9][0-9].{360}|3[0-9][0-9][0-9][0-9].{204}|4[0-9][0-9][0-9][0-9].{188}|5[0-9][0-9][0-9][0-9].{156}|7[0-9][0-9][0-9][0-9].{116}|8[0-9][0-9][0-9][0-9].{164}|9[0-9][0-9][0-9][0-9].{112}|1[0-9][0-9][0-9][0-9].{12}|6[0-9][0-9][0-9][0-9].{4})|9(?:6[0-9][0-9][0-9][0-9].{236}|7[0-9][0-9][0-9][0-9].{344}|9[0-9][0-9][0-9][0-9].{184}|1[0-9][0-9][0-9][0-9].{52}|2[0-9][0-9][0-9][0-9].{16}|4[0-9][0-9][0-9][0-9].{84}|5[0-9][0-9][0-9][0-9].{56}|8[0-9][0-9][0-9][0-9].{36}|0[0-9][0-9][0-9][0-9].{8})|8(?:[01][0-9][0-9][0-9][0-9].{8}|2[0-9][0-9][0-9][0-9].{548}|4[0-9][0-9][0-9][0-9].{368}|5[0-9][0-9][0-9][0-9].{108}|6[0-9][0-9][0-9][0-9].{416}|7[0-9][0-9][0-9][0-9].{232}|8[0-9][0-9][0-9][0-9].{12}|9[0-9][0-9][0-9][0-9].{24})|4(?:[45][0-9][0-9][0-9][0-9].{8}|0[0-9][0-9][0-9][0-9].{120}|3[0-9][0-9][0-9][0-9].{188}|8[0-9][0-9][0-9][0-9].{104}|9[0-9][0-9][0-9][0-9].{144}|1[0-9][0-9][0-9][0-9].{24}|2[0-9][0-9][0-9][0-9].{84}|6[0-9][0-9][0-9][0-9].{12})|5(?:[12][0-9][0-9][0-9][0-9].{96}|3[0-9][0-9][0-9][0-9].{188}|4[0-9][0-9][0-9][0-9].{104}|7[0-9][0-9][0-9][0-9].{140}|9[0-9][0-9][0-9][0-9].{144}|0[0-9][0-9][0-9][0-9].{52}|6[0-9][0-9][0-9][0-9].{12}|5[0-9][0-9][0-9][0-9].{8})|3(?:[27][0-9][0-9][0-9][0-9].{120}|[36][0-9][0-9][0-9][0-9].{8}|1[0-9][0-9][0-9][0-9].{260}|4[0-9][0-9][0-9][0-9].{164}|8[0-9][0-9][0-9][0-9].{104}|9[0-9][0-9][0-9][0-9].{228}|0[0-9][0-9][0-9][0-9].{96})|0(?:[025][0-9][0-9][0-9][0-9].{8}|[18][0-9][0-9][0-9][0-9].{52}|4[0-9][0-9][0-9][0-9].{128}|3[0-9][0-9][0-9][0-9].{56}|6[0-9][0-9][0-9][0-9].{28}|7[0-9][0-9][0-9][0-9].{16}|9[0-9][0-9][0-9][0-9].{12})|6(?:[09][0-9][0-9][0-9][0-9].{28}|2[0-9][0-9][0-9][0-9].{176}|4[0-9][0-9][0-9][0-9].{336}|7[0-9][0-9][0-9][0-9].{296}|8[0-9][0-9][0-9][0-9].{104}|5[0-9][0-9][0-9][0-9].{24}|6[0-9][0-9][0-9][0-9].{92})|7(?:[57][0-9][0-9][0-9][0-9].{120}|[46][0-9][0-9][0-9][0-9].{12}|[01][0-9][0-9][0-9][0-9].{8}|2[0-9][0-9][0-9][0-9].{156}|3[0-9][0-9][0-9][0-9].{268}|8[0-9][0-9][0-9][0-9].{88})|2(?:[0245][0-9][0-9][0-9][0-9].{8}|8[0-9][0-9][0-9][0-9].{132}|1[0-9][0-9][0-9][0-9].{12}|3[0-9][0-9][0-9][0-9].{24}|6[0-9][0-9][0-9][0-9].{56}|7[0-9][0-9][0-9][0-9].{4}))|2(?:0(?:[45][0-9][0-9][0-9][0-9].{8}|1[0-9][0-9][0-9][0-9].{324}|3[0-9][0-9][0-9][0-9].{376}|6[0-9][0-9][0-9][0-9].{240}|8[0-9][0-9][0-9][0-9].{212}|0[0-9][0-9][0-9][0-9].{56}|2[0-9][0-9][0-9][0-9].{60})|1(?:0[0-9][0-9][0-9][0-9].{128}|2[0-9][0-9][0-9][0-9].{244}|4[0-9][0-9][0-9][0-9].{388}|1[0-9][0-9][0-9][0-9].{44}|3[0-9][0-9][0-9][0-9].{52})|2(?:0[0-9][0-9][0-9][0-9].{136}|1[0-9][0-9][0-9][0-9].{308}|2[0-9][0-9][0-9][0-9].{92})|8(?:0[0-9][0-9][0-9][0-9].{456}|1[0-9][0-9][0-9][0-9].{52})|42[0-9][0-9][0-9][0-9].{312}|34[0-9][0-9][0-9][0-9].{56})|9(?:1(?:9[0-9][0-9][0-9][0-9].{260}|0[0-9][0-9][0-9][0-9].{4})|0[25][0-9][0-9][0-9][0-9].{56})|0[0-9][0-9][0-9][0-9][0-9][0-9].{4})|6(?:0(?:1(?:[56][0-9][0-9][0-9][0-9].{16}|[89][0-9][0-9][0-9][0-9].{12}|1[0-9][0-9][0-9][0-9].{120}|0[0-9][0-9][0-9][0-9].{24}|7[0-9][0-9][0-9][0-9].{96}|2[0-9][0-9][0-9][0-9].{8})|0(?:[19][0-9][0-9][0-9][0-9].{16}|[45][0-9][0-9][0-9][0-9].{12}|[27][0-9][0-9][0-9][0-9].{8}|6[0-9][0-9][0-9][0-9].{812}|0[0-9][0-9][0-9][0-9].{4})|6(?:[45][0-9][0-9][0-9][0-9].{8}|0[0-9][0-9][0-9][0-9].{764}|8[0-9][0-9][0-9][0-9].{592}|1[0-9][0-9][0-9][0-9].{24}|2[0-9][0-9][0-9][0-9].{16})|8(?:2[0-9][0-9][0-9][0-9].{132}|4[0-9][0-9][0-9][0-9].{368}|6[0-9][0-9][0-9][0-9].{120}|7[0-9][0-9][0-9][0-9].{8}|8[0-9][0-9][0-9][0-9].{4})|9(?:[239][0-9][0-9][0-9][0-9].{16}|[01][0-9][0-9][0-9][0-9].{8}|4[0-9][0-9][0-9][0-9].{368}|6[0-9][0-9][0-9][0-9].{52})|4(?:[256][0-9][0-9][0-9][0-9].{12}|[014][0-9][0-9][0-9][0-9].{8}|7[0-9][0-9][0-9][0-9].{36})|3(?:[03][0-9][0-9][0-9][0-9].{8}|8[0-9][0-9][0-9][0-9].{900}|7[0-9][0-9][0-9][0-9].{36})|2(?:8[0-9][0-9][0-9][0-9].{592}|2[0-9][0-9][0-9][0-9].{8}|6[0-9][0-9][0-9][0-9].{4})|7(?:[0189][0-9][0-9][0-9][0-9].{8}|[45][0-9][0-9][0-9][0-9].{12})|5(?:7[0-9][0-9][0-9][0-9].{140}|1[0-9][0-9][0-9][0-9].{16}))|8(?:3(?:[89][0-9][0-9][0-9][0-9].{24}|[03][0-9][0-9][0-9][0-9].{8}|2[0-9][0-9][0-9][0-9].{12})|8(?:4[0-9][0-9][0-9][0-9].{368}|6[0-9][0-9][0-9][0-9].{8}|8[0-9][0-9][0-9][0-9].{4})|9(?:[29][0-9][0-9][0-9][0-9].{16}|[01][0-9][0-9][0-9][0-9].{8})|4(?:[0-2][0-9][0-9][0-9][0-9].{8}|6[0-9][0-9][0-9][0-9].{12})|5(?:7[0-9][0-9][0-9][0-9].{140}|2[0-9][0-9][0-9][0-9].{8})|0(?:1[0-9][0-9][0-9][0-9].{52}|7[0-9][0-9][0-9][0-9].{8})|6(?:0[0-9][0-9][0-9][0-9].{16}|8[0-9][0-9][0-9][0-9].{8})|(?:11|22)[0-9][0-9][0-9][0-9].{120}|7[089][0-9][0-9][0-9][0-9].{8}))|4(?:1(?:0(?:[01][0-9][0-9][0-9][0-9].{24}|4[0-9][0-9][0-9][0-9].{108}|3[0-9][0-9][0-9][0-9].{32}|5[0-9][0-9][0-9][0-9].{4})|1[0-3][0-9][0-9][0-9][0-9].{24}|4[12][0-9][0-9][0-9][0-9].{676})|3(?:0(?:[2-58][0-9][0-9][0-9][0-9].{4}|[01][0-9][0-9][0-9][0-9].{52}|9[0-9][0-9][0-9][0-9].{8})|99[0-9][0-9][0-9][0-9].{8}))|5(?:0(?:[249][0-9][0-9][0-9][0-9][0-9].{8}|0[0-9][0-9][0-9][0-9][0-9].{12}|1[0-9][0-9][0-9][0-9][0-9].{36}|6[0-9][0-9][0-9][0-9][0-9].{4})|8(?:5[0-9][0-9][0-9][0-9][0-9].{8}|8[0-9][0-9][0-9][0-9][0-9].{4})|[45]0[0-9][0-9][0-9][0-9][0-9].{8}|28[0-9][0-9][0-9][0-9][0-9].{336}|66[0-9][0-9][0-9][0-9][0-9].{20})|36(?:(?:(?:4[7-9]|5[49]|99)[0-9]|7(?:[35][0-9]|47))[0-9][0-9][0-9].{4}|0(?:[1-36-8][0-9][0-9][0-9][0-9].{4}|9[0-9][0-9][0-9][0-9].{224})|6(?:0[0-9][0-9][0-9][0-9].{224}|2[0-9][0-9][0-9][0-9].{4}))|8428[0-9][0-9][0-9][0-9].{8})|2(?:5(?:2(?:3(?:[01][0-9][0-9][0-9][0-9].{52}|[34][0-9][0-9][0-9][0-9].{44}|[56][0-9][0-9][0-9][0-9].{28}|[89][0-9][0-9][0-9][0-9].{36}|2[0-9][0-9][0-9][0-9].{268}|7[0-9][0-9][0-9][0-9].{116})|5(?:[013-5][0-9][0-9][0-9][0-9].{28}|2[0-9][0-9][0-9][0-9].{212}|6[0-9][0-9][0-9][0-9].{448}|7[0-9][0-9][0-9][0-9].{552}|8[0-9][0-9][0-9][0-9].{240}|9[0-9][0-9][0-9][0-9].{128})|7(?:[47-9][0-9][0-9][0-9][0-9].{28}|[15][0-9][0-9][0-9][0-9].{60}|0[0-9][0-9][0-9][0-9].{144}|2[0-9][0-9][0-9][0-9].{136}|3[0-9][0-9][0-9][0-9].{64}|6[0-9][0-9][0-9][0-9].{12})|6(?:[3-7][0-9][0-9][0-9][0-9].{28}|[01][0-9][0-9][0-9][0-9].{128}|8[0-9][0-9][0-9][0-9].{164}|2[0-9][0-9][0-9][0-9].{20}|9[0-9][0-9][0-9][0-9].{60})|8(?:[0-3][0-9][0-9][0-9][0-9].{28}|[468][0-9][0-9][0-9][0-9].{88}|5[0-9][0-9][0-9][0-9].{420}|7[0-9][0-9][0-9][0-9].{168}|9[0-9][0-9][0-9][0-9].{52})|1(?:[2-7][0-9][0-9][0-9][0-9].{44}|9[0-9][0-9][0-9][0-9].{552}|1[0-9][0-9][0-9][0-9].{52}|8[0-9][0-9][0-9][0-9].{12}|0[0-9][0-9][0-9][0-9].{8})|4(?:[135-79][0-9][0-9][0-9][0-9].{28}|[28][0-9][0-9][0-9][0-9].{88}|0[0-9][0-9][0-9][0-9].{36}|4[0-9][0-9][0-9][0-9].{92})|0(?:[0-6][0-9][0-9][0-9][0-9].{64}|7[0-9][0-9][0-9][0-9].{232}|8[0-9][0-9][0-9][0-9].{88}|9[0-9][0-9][0-9][0-9].{8})|2(?:[3-9][0-9][0-9][0-9][0-9].{52}|[0-2][0-9][0-9][0-9][0-9].{112})|9(?:[0-7][0-9][0-9][0-9][0-9].{52}|[89][0-9][0-9][0-9][0-9].{60}))|7(?:2(?:[34][0-9][0-9][0-9][0-9].{112}|0[0-9][0-9][0-9][0-9].{364}|2[0-9][0-9][0-9][0-9].{144}|5[0-9][0-9][0-9][0-9].{84}|6[0-9][0-9][0-9][0-9].{12}|7[0-9][0-9][0-9][0-9].{36}|8[0-9][0-9][0-9][0-9].{88}|9[0-9][0-9][0-9][0-9].{52}|1[0-9][0-9][0-9][0-9].{8})|5(?:[5689][0-9][0-9][0-9][0-9].{36}|[01][0-9][0-9][0-9][0-9].{44}|3[0-9][0-9][0-9][0-9].{476}|4[0-9][0-9][0-9][0-9].{196}|2[0-9][0-9][0-9][0-9].{28}|7[0-9][0-9][0-9][0-9].{56})|8(?:[0-36][0-9][0-9][0-9][0-9].{28}|[48][0-9][0-9][0-9][0-9].{88}|5[0-9][0-9][0-9][0-9].{244}|9[0-9][0-9][0-9][0-9].{52}|7[0-9][0-9][0-9][0-9].{8})|6(?:[2-59][0-9][0-9][0-9][0-9].{28}|[78][0-9][0-9][0-9][0-9].{128}|[01][0-9][0-9][0-9][0-9].{36}|6[0-9][0-9][0-9][0-9].{404})|4(?:[1-6][0-9][0-9][0-9][0-9].{52}|[08][0-9][0-9][0-9][0-9].{88}|7[0-9][0-9][0-9][0-9].{112}|9[0-9][0-9][0-9][0-9].{44})|1(?:[0-7][0-9][0-9][0-9][0-9].{44}|9[0-9][0-9][0-9][0-9].{108}|8[0-9][0-9][0-9][0-9].{28})|7(?:[0-47-9][0-9][0-9][0-9][0-9].{28}|5[0-9][0-9][0-9][0-9].{92}|6[0-9][0-9][0-9][0-9].{12})|9(?:[4-9][0-9][0-9][0-9][0-9].{60}|[0-2][0-9][0-9][0-9][0-9].{52})|0[0-9][0-9][0-9][0-9][0-9].{44}|3[0-9][0-9][0-9][0-9][0-9].{52})|5(?:0(?:[08][0-9][0-9][0-9][0-9].{60}|1[0-9][0-9][0-9][0-9].{216}|2[0-9][0-9][0-9][0-9].{196}|3[0-9][0-9][0-9][0-9].{276}|4[0-9][0-9][0-9][0-9].{340}|5[0-9][0-9][0-9][0-9].{324}|6[0-9][0-9][0-9][0-9].{412}|7[0-9][0-9][0-9][0-9].{572}|9[0-9][0-9][0-9][0-9].{8})|6(?:[2-4][0-9][0-9][0-9][0-9].{92}|[7-9][0-9][0-9][0-9][0-9].{36}|0[0-9][0-9][0-9][0-9].{196}|1[0-9][0-9][0-9][0-9].{328}|6[0-9][0-9][0-9][0-9].{292}|5[0-9][0-9][0-9][0-9].{60})|9(?:[1-4][0-9][0-9][0-9][0-9].{40}|[58][0-9][0-9][0-9][0-9].{8}|6[0-9][0-9][0-9][0-9].{132}|7[0-9][0-9][0-9][0-9].{116}|9[0-9][0-9][0-9][0-9].{104}|0[0-9][0-9][0-9][0-9].{60})|5(?:6[0-9][0-9][0-9][0-9].{148}|9[0-9][0-9][0-9][0-9].{116}|5[0-9][0-9][0-9][0-9].{44}|7[0-9][0-9][0-9][0-9].{36}|8[0-9][0-9][0-9][0-9].{8})|1(?:[3-9][0-9][0-9][0-9][0-9].{48}|[01][0-9][0-9][0-9][0-9].{8}|2[0-9][0-9][0-9][0-9].{320})|8(?:[0-7][0-9][0-9][0-9][0-9].{36}|[89][0-9][0-9][0-9][0-9].{60})|[23][0-9][0-9][0-9][0-9][0-9].{48}|7[0-9][0-9][0-9][0-9][0-9].{36})|0(?:5(?:[1-379][0-9][0-9][0-9][0-9].{8}|[568][0-9][0-9][0-9][0-9].{20}|0[0-9][0-9][0-9][0-9].{40}|4[0-9][0-9][0-9][0-9].{84})|6(?:[0-4][0-9][0-9][0-9][0-9].{20}|[6-9][0-9][0-9][0-9][0-9].{8}|5[0-9][0-9][0-9][0-9].{40})|7(?:[03-79][0-9][0-9][0-9][0-9].{8}|[12][0-9][0-9][0-9][0-9].{12}|8[0-9][0-9][0-9][0-9].{16})|8(?:[2-79][0-9][0-9][0-9][0-9].{24}|[01][0-9][0-9][0-9][0-9].{8}|8[0-9][0-9][0-9][0-9].{44})|0(?:[02-5][0-9][0-9][0-9][0-9].{16}|[16-9][0-9][0-9][0-9][0-9].{8})|4(?:[3-9][0-9][0-9][0-9][0-9].{8}|[0-2][0-9][0-9][0-9][0-9].{12})|3(?:[0-46-9][0-9][0-9][0-9][0-9].{12}|5[0-9][0-9][0-9][0-9].{16})|1(?:[0-46-9][0-9][0-9][0-9][0-9].{8}|5[0-9][0-9][0-9][0-9].{12})|9(?:[1-9][0-9][0-9][0-9][0-9].{16}|0[0-9][0-9][0-9][0-9].{8})|2[0-9][0-9][0-9][0-9][0-9].{8})|3(?:5(?:[0249][0-9][0-9][0-9][0-9].{12}|[68][0-9][0-9][0-9][0-9].{84}|[57][0-9][0-9][0-9][0-9].{8}|3[0-9][0-9][0-9][0-9].{332}|1[0-9][0-9][0-9][0-9].{16})|4(?:[1-35][0-9][0-9][0-9][0-9].{40}|[068][0-9][0-9][0-9][0-9].{12}|[79][0-9][0-9][0-9][0-9].{8}|4[0-9][0-9][0-9][0-9].{108})|9(?:[02-7][0-9][0-9][0-9][0-9].{8}|[89][0-9][0-9][0-9][0-9].{16}|1[0-9][0-9][0-9][0-9].{40})|3(?:[0-46-8][0-9][0-9][0-9][0-9].{12}|5[0-9][0-9][0-9][0-9].{56}|9[0-9][0-9][0-9][0-9].{84})|0(?:[35-9][0-9][0-9][0-9][0-9].{8}|[0-24][0-9][0-9][0-9][0-9].{12})|2(?:[346-9][0-9][0-9][0-9][0-9].{12}|[0-25][0-9][0-9][0-9][0-9].{8})|8(?:[1-8][0-9][0-9][0-9][0-9].{8}|[09][0-9][0-9][0-9][0-9].{12})|6(?:[1-9][0-9][0-9][0-9][0-9].{8}|0[0-9][0-9][0-9][0-9].{12})|[17][0-9][0-9][0-9][0-9][0-9].{8})|6(?:5(?:[02-5][0-9][0-9][0-9][0-9].{8}|[67][0-9][0-9][0-9][0-9].{12}|[89][0-9][0-9][0-9][0-9].{16}|1[0-9][0-9][0-9][0-9].{40})|6(?:[4-7][0-9][0-9][0-9][0-9].{12}|[1-3][0-9][0-9][0-9][0-9].{8}|[89][0-9][0-9][0-9][0-9].{24}|0[0-9][0-9][0-9][0-9].{16})|9(?:[1-358][0-9][0-9][0-9][0-9].{12}|[467][0-9][0-9][0-9][0-9].{16}|0[0-9][0-9][0-9][0-9].{24}|9[0-9][0-9][0-9][0-9].{8})|0(?:[1457-9][0-9][0-9][0-9][0-9].{8}|[026][0-9][0-9][0-9][0-9].{84}|3[0-9][0-9][0-9][0-9].{12})|3(?:[1-46-9][0-9][0-9][0-9][0-9].{8}|5[0-9][0-9][0-9][0-9].{108}|0[0-9][0-9][0-9][0-9].{84})|2(?:[0-8][0-9][0-9][0-9][0-9].{8}|9[0-9][0-9][0-9][0-9].{40})|[78][0-9][0-9][0-9][0-9][0-9].{24}|[14][0-9][0-9][0-9][0-9][0-9].{8})|8(?:0(?:[0-5][0-9][0-9][0-9][0-9].{36}|[89][0-9][0-9][0-9][0-9].{48}|7[0-9][0-9][0-9][0-9].{132}|6[0-9][0-9][0-9][0-9].{60})|(?:2[0-2]|1[0-9])[0-9][0-9][0-9][0-9].{48})|[14][0-9][0-9][0-9][0-9][0-9][0-9].{4})|7(?:8(?:9(?:[01][0-9][0-9][0-9][0-9].{44}|[39][0-9][0-9][0-9][0-9].{28}|[67][0-9][0-9][0-9][0-9].{36}|4[0-9][0-9][0-9][0-9].{112}|2[0-9][0-9][0-9][0-9].{88}|5[0-9][0-9][0-9][0-9].{52}|8[0-9][0-9][0-9][0-9].{56})|7(?:[2-4][0-9][0-9][0-9][0-9].{12}|[08][0-9][0-9][0-9][0-9].{44}|[56][0-9][0-9][0-9][0-9].{72}|9[0-9][0-9][0-9][0-9].{596}|1[0-9][0-9][0-9][0-9].{40}|7[0-9][0-9][0-9][0-9].{28})|6(?:[13-6][0-9][0-9][0-9][0-9].{4}|[28][0-9][0-9][0-9][0-9].{12}|7[0-9][0-9][0-9][0-9].{108}|0[0-9][0-9][0-9][0-9].{44}|9[0-9][0-9][0-9][0-9].{40})|2(?:[0-489][0-9][0-9][0-9][0-9].{12}|[56][0-9][0-9][0-9][0-9].{20}|7[0-9][0-9][0-9][0-9].{36})|0(?:[3-79][0-9][0-9][0-9][0-9].{32}|[0-2][0-9][0-9][0-9][0-9].{8}|8[0-9][0-9][0-9][0-9].{56})|4(?:[1-7][0-9][0-9][0-9][0-9].{12}|[89][0-9][0-9][0-9][0-9].{4}|0[0-9][0-9][0-9][0-9].{44})|8(?:[0235-79][0-9][0-9][0-9][0-9].{44}|[48][0-9][0-9][0-9][0-9].{88}|1[0-9][0-9][0-9][0-9].{8})|5(?:[2-9][0-9][0-9][0-9][0-9].{4}|0[0-9][0-9][0-9][0-9].{44}|1[0-9][0-9][0-9][0-9].{12})|1(?:[0-7][0-9][0-9][0-9][0-9].{32}|[89][0-9][0-9][0-9][0-9].{12})|3(?:[0-4][0-9][0-9][0-9][0-9].{20}|[5-9][0-9][0-9][0-9][0-9].{12}))|2(?:8(?:[12679][0-9][0-9][0-9][0-9].{8}|[3-5][0-9][0-9][0-9][0-9].{16}|8[0-9][0-9][0-9][0-9].{128}|0[0-9][0-9][0-9][0-9].{20})|5(?:[013478][0-9][0-9][0-9][0-9].{20}|[29][0-9][0-9][0-9][0-9].{8}|5[0-9][0-9][0-9][0-9].{16}|6[0-9][0-9][0-9][0-9].{12})|7(?:[1347-9][0-9][0-9][0-9][0-9].{8}|[26][0-9][0-9][0-9][0-9].{12}|0[0-9][0-9][0-9][0-9].{16}|5[0-9][0-9][0-9][0-9].{20})|1(?:[246-8][0-9][0-9][0-9][0-9].{8}|[019][0-9][0-9][0-9][0-9].{24}|[35][0-9][0-9][0-9][0-9].{16})|2(?:[13689][0-9][0-9][0-9][0-9].{16}|[027][0-9][0-9][0-9][0-9].{8}|[45][0-9][0-9][0-9][0-9].{24})|6(?:[02356][0-9][0-9][0-9][0-9].{8}|[179][0-9][0-9][0-9][0-9].{20}|[48][0-9][0-9][0-9][0-9].{12})|0(?:[3-79][0-9][0-9][0-9][0-9].{24}|[0-2][0-9][0-9][0-9][0-9].{8}|8[0-9][0-9][0-9][0-9].{16})|4(?:[135-79][0-9][0-9][0-9][0-9].{20}|[048][0-9][0-9][0-9][0-9].{16}|2[0-9][0-9][0-9][0-9].{8})|3(?:[0135-9][0-9][0-9][0-9][0-9].{16}|4[0-9][0-9][0-9][0-9].{32}|2[0-9][0-9][0-9][0-9].{8})|9(?:[0347-9][0-9][0-9][0-9][0-9].{16}|[1256][0-9][0-9][0-9][0-9].{8}))|7(?:7(?:[2-59][0-9][0-9][0-9][0-9].{8}|[07][0-9][0-9][0-9][0-9].{84}|1[0-9][0-9][0-9][0-9].{16}|6[0-9][0-9][0-9][0-9].{40}|8[0-9][0-9][0-9][0-9].{12})|1(?:[2-689][0-9][0-9][0-9][0-9].{8}|0[0-9][0-9][0-9][0-9].{40}|1[0-9][0-9][0-9][0-9].{16}|7[0-9][0-9][0-9][0-9].{12})|8(?:[07-9][0-9][0-9][0-9][0-9].{12}|[2-6][0-9][0-9][0-9][0-9].{8}|1[0-9][0-9][0-9][0-9].{132})|6(?:[1269][0-9][0-9][0-9][0-9].{12}|[3-578][0-9][0-9][0-9][0-9].{8}|0[0-9][0-9][0-9][0-9].{16})|0(?:[0-579][0-9][0-9][0-9][0-9].{8}|6[0-9][0-9][0-9][0-9].{12}|8[0-9][0-9][0-9][0-9].{24})|4(?:[4-9][0-9][0-9][0-9][0-9].{12}|[0-3][0-9][0-9][0-9][0-9].{24})|2(?:[0-68][0-9][0-9][0-9][0-9].{8}|[79][0-9][0-9][0-9][0-9].{12})|5(?:[013-9][0-9][0-9][0-9][0-9].{12}|2[0-9][0-9][0-9][0-9].{16})|3[0-9][0-9][0-9][0-9][0-9].{24}|9[0-9][0-9][0-9][0-9][0-9].{8})|6(?:8(?:[3-5][0-9][0-9][0-9][0-9].{12}|[01][0-9][0-9][0-9][0-9].{40}|[29][0-9][0-9][0-9][0-9].{8}|8[0-9][0-9][0-9][0-9].{176}|6[0-9][0-9][0-9][0-9].{44}|7[0-9][0-9][0-9][0-9].{92})|5(?:[1348][0-9][0-9][0-9][0-9].{12}|[679][0-9][0-9][0-9][0-9].{20}|[025][0-9][0-9][0-9][0-9].{8})|6(?:[0235][0-9][0-9][0-9][0-9].{20}|[489][0-9][0-9][0-9][0-9].{12}|[167][0-9][0-9][0-9][0-9].{8})|3(?:[1-35-9][0-9][0-9][0-9][0-9].{8}|0[0-9][0-9][0-9][0-9].{12}|4[0-9][0-9][0-9][0-9].{32})|0(?:[3-7][0-9][0-9][0-9][0-9].{16}|[0-289][0-9][0-9][0-9][0-9].{8})|4(?:[0-35-8][0-9][0-9][0-9][0-9].{12}|[49][0-9][0-9][0-9][0-9].{8})|7(?:[0-4][0-9][0-9][0-9][0-9].{20}|[5-9][0-9][0-9][0-9][0-9].{8})|2(?:[1-9][0-9][0-9][0-9][0-9].{8}|0[0-9][0-9][0-9][0-9].{12})|9[0-9][0-9][0-9][0-9][0-9].{16}|1[0-9][0-9][0-9][0-9][0-9].{8})|9(?:1(?:[1-4][0-9][0-9][0-9][0-9].{28}|[56][0-9][0-9][0-9][0-9].{60}|0[0-9][0-9][0-9][0-9].{168}|7[0-9][0-9][0-9][0-9].{460}|8[0-9][0-9][0-9][0-9].{432}|9[0-9][0-9][0-9][0-9].{92})|8(?:[4-9][0-9][0-9][0-9][0-9].{36}|1[0-9][0-9][0-9][0-9].{196}|0[0-9][0-9][0-9][0-9].{48}|2[0-9][0-9][0-9][0-9].{92})|0(?:[03-9][0-9][0-9][0-9][0-9].{28}|[12][0-9][0-9][0-9][0-9].{128})|2(?:[0-5][0-9][0-9][0-9][0-9].{36}|[6-9][0-9][0-9][0-9][0-9].{48})|9(?:[01][0-9][0-9][0-9][0-9].{8}|2[0-9][0-9][0-9][0-9].{596})|3[0-8][0-9][0-9][0-9][0-9].{48}|79[0-9][0-9][0-9][0-9].{352}))|4(?:6(?:8(?:[0248][0-9][0-9][0-9][0-9].{88}|[19][0-9][0-9][0-9][0-9].{52}|5[0-9][0-9][0-9][0-9].{116}|3[0-9][0-9][0-9][0-9].{28}|6[0-9][0-9][0-9][0-9].{56}|7[0-9][0-9][0-9][0-9].{44})|9(?:[3-578][0-9][0-9][0-9][0-9].{36}|[26][0-9][0-9][0-9][0-9].{56}|9[0-9][0-9][0-9][0-9].{128}|0[0-9][0-9][0-9][0-9].{52}|1[0-9][0-9][0-9][0-9].{28})|0(?:[015-7][0-9][0-9][0-9][0-9].{4}|[34][0-9][0-9][0-9][0-9].{12}|2[0-9][0-9][0-9][0-9].{108}|9[0-9][0-9][0-9][0-9].{40}|8[0-9][0-9][0-9][0-9].{8})|6(?:[0-49][0-9][0-9][0-9][0-9].{44}|6[0-9][0-9][0-9][0-9].{428}|5[0-9][0-9][0-9][0-9].{28}|8[0-9][0-9][0-9][0-9].{88}|7[0-9][0-9][0-9][0-9].{8})|7(?:[03-578][0-9][0-9][0-9][0-9].{44}|[12][0-9][0-9][0-9][0-9].{112}|6[0-9][0-9][0-9][0-9].{12}|9[0-9][0-9][0-9][0-9].{52})|2(?:[3-7][0-9][0-9][0-9][0-9].{44}|[0-2][0-9][0-9][0-9][0-9].{12}|[89][0-9][0-9][0-9][0-9].{64})|5(?:[0-57][0-9][0-9][0-9][0-9].{64}|[89][0-9][0-9][0-9][0-9].{44}|6[0-9][0-9][0-9][0-9].{56})|4(?:[0-589][0-9][0-9][0-9][0-9].{64}|7[0-9][0-9][0-9][0-9].{172}|6[0-9][0-9][0-9][0-9].{56})|1(?:[1-9][0-9][0-9][0-9][0-9].{12}|0[0-9][0-9][0-9][0-9].{40})|3[0-9][0-9][0-9][0-9][0-9].{64})|9(?:8(?:[13-5][0-9][0-9][0-9][0-9].{12}|2[0-9][0-9][0-9][0-9].{92}|6[0-9][0-9][0-9][0-9].{20}|7[0-9][0-9][0-9][0-9].{40}|8[0-9][0-9][0-9][0-9].{88}|9[0-9][0-9][0-9][0-9].{36}|0[0-9][0-9][0-9][0-9].{8})|5(?:[4-9][0-9][0-9][0-9][0-9].{20}|[01][0-9][0-9][0-9][0-9].{32}|3[0-9][0-9][0-9][0-9].{36}|2[0-9][0-9][0-9][0-9].{8})|2(?:[4-9][0-9][0-9][0-9][0-9].{32}|[0-2][0-9][0-9][0-9][0-9].{8}|3[0-9][0-9][0-9][0-9].{124})|4(?:[0-35-8][0-9][0-9][0-9][0-9].{32}|9[0-9][0-9][0-9][0-9].{304}|4[0-9][0-9][0-9][0-9].{40})|1(?:[0-69][0-9][0-9][0-9][0-9].{8}|7[0-9][0-9][0-9][0-9].{296}|8[0-9][0-9][0-9][0-9].{12})|6(?:[02-9][0-9][0-9][0-9][0-9].{20}|1[0-9][0-9][0-9][0-9].{12})|7(?:[0-8][0-9][0-9][0-9][0-9].{12}|9[0-9][0-9][0-9][0-9].{52})|3[0-9][0-9][0-9][0-9][0-9].{32}|9[0-9][0-9][0-9][0-9][0-9].{12}|0[0-9][0-9][0-9][0-9][0-9].{8})|4(?:8(?:[1-35-79][0-9][0-9][0-9][0-9].{8}|4[0-9][0-9][0-9][0-9].{104}|0[0-9][0-9][0-9][0-9].{16}|8[0-9][0-9][0-9][0-9].{12})|6(?:[3-9][0-9][0-9][0-9][0-9].{12}|[12][0-9][0-9][0-9][0-9].{16}|0[0-9][0-9][0-9][0-9].{8})|7(?:[2-589][0-9][0-9][0-9][0-9].{8}|[167][0-9][0-9][0-9][0-9].{12}|0[0-9][0-9][0-9][0-9].{16})|5(?:[2-9][0-9][0-9][0-9][0-9].{8}|1[0-9][0-9][0-9][0-9].{260}|0[0-9][0-9][0-9][0-9].{12})|2(?:[0-6][0-9][0-9][0-9][0-9].{24}|[7-9][0-9][0-9][0-9][0-9].{8})|4(?:[2-9][0-9][0-9][0-9][0-9].{12}|[01][0-9][0-9][0-9][0-9].{8})|9(?:[1-8][0-9][0-9][0-9][0-9].{8}|[09][0-9][0-9][0-9][0-9].{12})|0(?:[1-9][0-9][0-9][0-9][0-9].{8}|0[0-9][0-9][0-9][0-9].{16})|1[0-9][0-9][0-9][0-9][0-9].{24}|3[0-9][0-9][0-9][0-9][0-9].{8})|2(?:2(?:[0-4][0-9][0-9][0-9][0-9].{28}|[56][0-9][0-9][0-9][0-9].{60}|7[0-9][0-9][0-9][0-9].{156}|8[0-9][0-9][0-9][0-9].{52}|9[0-9][0-9][0-9][0-9].{92})|6(?:[0-5][0-9][0-9][0-9][0-9].{36}|[89][0-9][0-9][0-9][0-9].{8}|7[0-9][0-9][0-9][0-9].{116}|6[0-9][0-9][0-9][0-9].{40})|0(?:[0-49][0-9][0-9][0-9][0-9].{28}|[5-7][0-9][0-9][0-9][0-9].{60}|8[0-9][0-9][0-9][0-9].{168})|4(?:[5-9][0-9][0-9][0-9][0-9].{36}|[0-3][0-9][0-9][0-9][0-9].{52}|4[0-9][0-9][0-9][0-9].{60})|3(?:[2-9][0-9][0-9][0-9][0-9].{52}|[01][0-9][0-9][0-9][0-9].{92})|(?:9[0-6]|[78][0-9])[0-9][0-9][0-9][0-9].{48}|1[0-9][0-9][0-9][0-9][0-9].{28}|5[0-9][0-9][0-9][0-9][0-9].{36})|5(?:4(?:[0-6][0-9][0-9][0-9][0-9].{20}|7[0-9][0-9][0-9][0-9].{40}|9[0-9][0-9][0-9][0-9].{12}|8[0-9][0-9][0-9][0-9].{8})|1(?:[0-6][0-9][0-9][0-9][0-9].{32}|[7-9][0-9][0-9][0-9][0-9].{12})|2(?:[0-5][0-9][0-9][0-9][0-9].{12}|[6-9][0-9][0-9][0-9][0-9].{20})|7(?:[0-7][0-9][0-9][0-9][0-9].{12}|[89][0-9][0-9][0-9][0-9].{4})|3(?:[1-9][0-9][0-9][0-9][0-9].{20}|0[0-9][0-9][0-9][0-9].{36})|6(?:[1-9][0-9][0-9][0-9][0-9].{12}|0[0-9][0-9][0-9][0-9].{20})|[89][0-9][0-9][0-9][0-9][0-9].{4}|0[0-9][0-9][0-9][0-9][0-9].{32}|5[0-9][0-9][0-9][0-9][0-9].{12})|[01378][0-9][0-9][0-9][0-9][0-9][0-9].{4})|3(?:0(?:9(?:[019][0-9][0-9][0-9][0-9].{56}|[2-4][0-9][0-9][0-9][0-9].{12}|[78][0-9][0-9][0-9][0-9].{44}|5[0-9][0-9][0-9][0-9].{172}|6[0-9][0-9][0-9][0-9].{28})|0(?:[5-9][0-9][0-9][0-9][0-9].{248}|[12][0-9][0-9][0-9][0-9].{40}|3[0-9][0-9][0-9][0-9].{112}|0[0-9][0-9][0-9][0-9].{12}|4[0-9][0-9][0-9][0-9].{36})|8(?:[01479][0-9][0-9][0-9][0-9].{12}|[36][0-9][0-9][0-9][0-9].{40}|5[0-9][0-9][0-9][0-9].{56}|8[0-9][0-9][0-9][0-9].{88}|2[0-9][0-9][0-9][0-9].{8})|3(?:[3-9][0-9][0-9][0-9][0-9].{12}|[01][0-9][0-9][0-9][0-9].{248}|2[0-9][0-9][0-9][0-9].{228})|2(?:[5-9][0-9][0-9][0-9][0-9].{248}|[0-4][0-9][0-9][0-9][0-9].{20})|5(?:[0-5][0-9][0-9][0-9][0-9].{12}|[6-9][0-9][0-9][0-9][0-9].{4})|7(?:[0-8][0-9][0-9][0-9][0-9].{4}|9[0-9][0-9][0-9][0-9].{108})|1[0-9][0-9][0-9][0-9][0-9].{20}|4[0-9][0-9][0-9][0-9][0-9].{12}|6[0-9][0-9][0-9][0-9][0-9].{4})|6(?:5(?:[1-5][0-9][0-9][0-9][0-9].{8}|[6-8][0-9][0-9][0-9][0-9].{12}|0[0-9][0-9][0-9][0-9].{16}|9[0-9][0-9][0-9][0-9].{24})|1(?:[4-8][0-9][0-9][0-9][0-9].{8}|[1-3][0-9][0-9][0-9][0-9].{40}|[09][0-9][0-9][0-9][0-9].{12})|6(?:[016-9][0-9][0-9][0-9][0-9].{8}|[245][0-9][0-9][0-9][0-9].{24}|3[0-9][0-9][0-9][0-9].{12})|7(?:[1-79][0-9][0-9][0-9][0-9].{24}|0[0-9][0-9][0-9][0-9].{40}|8[0-9][0-9][0-9][0-9].{12})|0(?:[1-689][0-9][0-9][0-9][0-9].{8}|[07][0-9][0-9][0-9][0-9].{12})|8(?:[02-9][0-9][0-9][0-9][0-9].{24}|1[0-9][0-9][0-9][0-9].{132})|9(?:[1-6][0-9][0-9][0-9][0-9].{24}|[07-9][0-9][0-9][0-9][0-9].{8})|3(?:[0-57-9][0-9][0-9][0-9][0-9].{8}|6[0-9][0-9][0-9][0-9].{12})|4(?:[0-8][0-9][0-9][0-9][0-9].{8}|9[0-9][0-9][0-9][0-9].{16})|2[0-9][0-9][0-9][0-9][0-9].{8})|4(?:5(?:[013479][0-9][0-9][0-9][0-9].{8}|[56][0-9][0-9][0-9][0-9].{288}|2[0-9][0-9][0-9][0-9].{128}|8[0-9][0-9][0-9][0-9].{20})|2(?:[0-367][0-9][0-9][0-9][0-9].{16}|[49][0-9][0-9][0-9][0-9].{8}|5[0-9][0-9][0-9][0-9].{288}|8[0-9][0-9][0-9][0-9].{12})|6(?:[3568][0-9][0-9][0-9][0-9].{20}|[1479][0-9][0-9][0-9][0-9].{8}|[02][0-9][0-9][0-9][0-9].{84})|8(?:[04-79][0-9][0-9][0-9][0-9].{8}|[1-3][0-9][0-9][0-9][0-9].{20}|8[0-9][0-9][0-9][0-9].{308})|0(?:[02-8][0-9][0-9][0-9][0-9].{8}|1[0-9][0-9][0-9][0-9].{16}|9[0-9][0-9][0-9][0-9].{32})|4(?:[1-57-9][0-9][0-9][0-9][0-9].{8}|[06][0-9][0-9][0-9][0-9].{28})|7(?:[013478][0-9][0-9][0-9][0-9].{8}|[2569][0-9][0-9][0-9][0-9].{20})|3(?:[1-9][0-9][0-9][0-9][0-9].{8}|0[0-9][0-9][0-9][0-9].{12})|[19][0-9][0-9][0-9][0-9][0-9].{16})|[1-3578][0-9][0-9][0-9][0-9][0-9][0-9].{4})|6(?:1(?:8(?:[2-5][0-9][0-9][0-9][0-9].{28}|9[0-9][0-9][0-9][0-9].{364}|0[0-9][0-9][0-9][0-9].{60}|1[0-9][0-9][0-9][0-9].{56}|6[0-9][0-9][0-9][0-9].{36}|7[0-9][0-9][0-9][0-9].{92}|8[0-9][0-9][0-9][0-9].{88})|6(?:[3-6][0-9][0-9][0-9][0-9].{44}|[0-2][0-9][0-9][0-9][0-9].{52}|7[0-9][0-9][0-9][0-9].{128}|8[0-9][0-9][0-9][0-9].{384}|9[0-9][0-9][0-9][0-9].{28})|3(?:[3-7][0-9][0-9][0-9][0-9].{12}|[89][0-9][0-9][0-9][0-9].{72}|[01][0-9][0-9][0-9][0-9].{4}|2[0-9][0-9][0-9][0-9].{40})|5(?:[4-9][0-9][0-9][0-9][0-9].{52}|[13][0-9][0-9][0-9][0-9].{28}|2[0-9][0-9][0-9][0-9].{112}|0[0-9][0-9][0-9][0-9].{44})|1(?:[3-6][0-9][0-9][0-9][0-9].{12}|[0-2][0-9][0-9][0-9][0-9].{20}|[7-9][0-9][0-9][0-9][0-9].{4})|7(?:[02-8][0-9][0-9][0-9][0-9].{28}|1[0-9][0-9][0-9][0-9].{56}|9[0-9][0-9][0-9][0-9].{60})|4(?:[1-9][0-9][0-9][0-9][0-9].{44}|0[0-9][0-9][0-9][0-9].{72})|9(?:[3-9][0-9][0-9][0-9][0-9].{36}|0[0-9][0-9][0-9][0-9].{60})|0[0-9][0-9][0-9][0-9][0-9].{12}|2[0-9][0-9][0-9][0-9][0-9].{4})|2(?:0(?:[12][0-9][0-9][0-9][0-9].{492}|[89][0-9][0-9][0-9][0-9].{80}|7[0-9][0-9][0-9][0-9].{772}|3[0-9][0-9][0-9][0-9].{44}|4[0-9][0-9][0-9][0-9].{36}|5[0-9][0-9][0-9][0-9].{60}|6[0-9][0-9][0-9][0-9].{52})|6(?:[457-9][0-9][0-9][0-9][0-9].{140}|0[0-9][0-9][0-9][0-9].{944}|1[0-9][0-9][0-9][0-9].{492}|6[0-9][0-9][0-9][0-9].{104}|2[0-9][0-9][0-9][0-9].{56}|3[0-9][0-9][0-9][0-9].{96})|8(?:[89][0-9][0-9][0-9][0-9].{344}|0[0-9][0-9][0-9][0-9].{468}|1[0-9][0-9][0-9][0-9].{140}|2[0-9][0-9][0-9][0-9].{920}|7[0-9][0-9][0-9][0-9].{880}|5[0-9][0-9][0-9][0-9].{80})|7(?:[0-5][0-9][0-9][0-9][0-9].{4}|7[0-9][0-9][0-9][0-9].{344}|8[0-9][0-9][0-9][0-9].{492}|9[0-9][0-9][0-9][0-9].{112}|6[0-9][0-9][0-9][0-9].{92})|1(?:[0-489][0-9][0-9][0-9][0-9].{80}|[67][0-9][0-9][0-9][0-9].{96}|5[0-9][0-9][0-9][0-9].{748})|3(?:[0-57-9][0-9][0-9][0-9][0-9].{4}|6[0-9][0-9][0-9][0-9].{96})|[2459][0-9][0-9][0-9][0-9][0-9].{4})|9(?:6(?:[0-46][0-9][0-9][0-9][0-9].{4}|7[0-9][0-9][0-9][0-9].{340}|5[0-9][0-9][0-9][0-9].{92}|9[0-9][0-9][0-9][0-9].{56})|5(?:0[0-9][0-9][0-9][0-9].{104}|1[0-9][0-9][0-9][0-9].{80})|0(?:6[0-9][0-9][0-9][0-9].{44}|7[0-9][0-9][0-9][0-9].{36})|80[0-9][0-9][0-9][0-9].{468}|70[0-9][0-9][0-9][0-9].{96}))|1(?:4(?:9(?:[235-8][0-9][0-9][0-9][0-9].{20}|[01][0-9][0-9][0-9][0-9].{12}|9[0-9][0-9][0-9][0-9].{172}|4[0-9][0-9][0-9][0-9].{36})|6(?:[5-9][0-9][0-9][0-9][0-9].{32}|[01][0-9][0-9][0-9][0-9].{12}|[2-4][0-9][0-9][0-9][0-9].{8})|7(?:[35-9][0-9][0-9][0-9][0-9].{32}|[0-2][0-9][0-9][0-9][0-9].{12}|4[0-9][0-9][0-9][0-9].{56})|4(?:[03-9][0-9][0-9][0-9][0-9].{8}|1[0-9][0-9][0-9][0-9].{16}|2[0-9][0-9][0-9][0-9].{12})|8(?:[05-9][0-9][0-9][0-9][0-9].{12}|[1-4][0-9][0-9][0-9][0-9].{32})|0(?:[0-7][0-9][0-9][0-9][0-9].{24}|[89][0-9][0-9][0-9][0-9].{8})|2(?:[2-9][0-9][0-9][0-9][0-9].{12}|[01][0-9][0-9][0-9][0-9].{8})|5(?:[1-46-9][0-9][0-9][0-9][0-9].{8}|[05][0-9][0-9][0-9][0-9].{12})|3(?:[0-8][0-9][0-9][0-9][0-9].{12}|9[0-9][0-9][0-9][0-9].{8})|1[0-9][0-9][0-9][0-9][0-9].{8})|8(?:8(?:[3-57][0-9][0-9][0-9][0-9].{12}|[69][0-9][0-9][0-9][0-9].{32}|[02][0-9][0-9][0-9][0-9].{8}|1[0-9][0-9][0-9][0-9].{28}|8[0-9][0-9][0-9][0-9].{56})|3(?:[1-7][0-9][0-9][0-9][0-9].{12}|[09][0-9][0-9][0-9][0-9].{16}|8[0-9][0-9][0-9][0-9].{8})|4(?:[1-5][0-9][0-9][0-9][0-9].{12}|[6-9][0-9][0-9][0-9][0-9].{8}|0[0-9][0-9][0-9][0-9].{16})|9(?:[12457-9][0-9][0-9][0-9][0-9].{32}|[036][0-9][0-9][0-9][0-9].{12})|1(?:[4-9][0-9][0-9][0-9][0-9].{12}|[0-3][0-9][0-9][0-9][0-9].{8})|2(?:[0-6][0-9][0-9][0-9][0-9].{12}|[7-9][0-9][0-9][0-9][0-9].{8})|5(?:[1-9][0-9][0-9][0-9][0-9].{8}|0[0-9][0-9][0-9][0-9].{12})|7(?:[0-8][0-9][0-9][0-9][0-9].{8}|9[0-9][0-9][0-9][0-9].{12})|[06][0-9][0-9][0-9][0-9][0-9].{8}))|2(?:2(?:5(?:[0-3][0-9][0-9][0-9][0-9].{12}|[7-9][0-9][0-9][0-9][0-9].{32}|[56][0-9][0-9][0-9][0-9].{8}|4[0-9][0-9][0-9][0-9].{188})|9(?:[5-9][0-9][0-9][0-9][0-9].{12}|[01][0-9][0-9][0-9][0-9].{60}|[23][0-9][0-9][0-9][0-9].{8}|4[0-9][0-9][0-9][0-9].{28})|1(?:[2-9][0-9][0-9][0-9][0-9].{8}|0[0-9][0-9][0-9][0-9].{16}|1[0-9][0-9][0-9][0-9].{12})|7(?:[0-7][0-9][0-9][0-9][0-9].{12}|[89][0-9][0-9][0-9][0-9].{32})|8(?:[0-7][0-9][0-9][0-9][0-9].{32}|[89][0-9][0-9][0-9][0-9].{12})|0(?:[0-6][0-9][0-9][0-9][0-9].{12}|[7-9][0-9][0-9][0-9][0-9].{8})|2(?:[14-8][0-9][0-9][0-9][0-9].{8}|[0239][0-9][0-9][0-9][0-9].{12})|3(?:[0-246-9][0-9][0-9][0-9][0-9].{8}|[35][0-9][0-9][0-9][0-9].{12})|4(?:[0-35-9][0-9][0-9][0-9][0-9].{8}|4[0-9][0-9][0-9][0-9].{104})|6(?:[0-57-9][0-9][0-9][0-9][0-9].{32}|6[0-9][0-9][0-9][0-9].{56}))|1(?:0(?:[23][0-9][0-9][0-9][0-9].{556}|[79][0-9][0-9][0-9][0-9].{8}|0[0-9][0-9][0-9][0-9].{452}|1[0-9][0-9][0-9][0-9].{116}|4[0-9][0-9][0-9][0-9].{372}|5[0-9][0-9][0-9][0-9].{484}|6[0-9][0-9][0-9][0-9].{92}|8[0-9][0-9][0-9][0-9].{60})|3(?:[5-9][0-9][0-9][0-9][0-9].{48}|1[0-9][0-9][0-9][0-9].{132}|2[0-9][0-9][0-9][0-9].{116}|4[0-9][0-9][0-9][0-9].{572}|0[0-9][0-9][0-9][0-9].{40}|3[0-9][0-9][0-9][0-9].{8})|2(?:[0-6][0-9][0-9][0-9][0-9].{36}|[89][0-9][0-9][0-9][0-9].{40}|7[0-9][0-9][0-9][0-9].{8})|1(?:[2-9][0-9][0-9][0-9][0-9].{36}|1[0-9][0-9][0-9][0-9].{252})|(?:5[0-7]|4[0-9])[0-9][0-9][0-9][0-9].{48})|[37-9][0-9][0-9][0-9][0-9][0-9][0-9].{4})|85(?:3(?:[189][0-9][0-9][0-9][0-9].{12}|[467][0-9][0-9][0-9][0-9].{40}|[23][0-9][0-9][0-9][0-9].{8}|0[0-9][0-9][0-9][0-9].{108}|5[0-9][0-9][0-9][0-9].{56})|6(?:[0-46][0-9][0-9][0-9][0-9].{44}|8[0-9][0-9][0-9][0-9].{124}|5[0-9][0-9][0-9][0-9].{56}|7[0-9][0-9][0-9][0-9].{60}|9[0-9][0-9][0-9][0-9].{64})|7(?:[0-249][0-9][0-9][0-9][0-9].{64}|[6-8][0-9][0-9][0-9][0-9].{12}|3[0-9][0-9][0-9][0-9].{176}|5[0-9][0-9][0-9][0-9].{56})|5(?:[05-9][0-9][0-9][0-9][0-9].{44}|[34][0-9][0-9][0-9][0-9].{72}|1[0-9][0-9][0-9][0-9].{12}|2[0-9][0-9][0-9][0-9].{28})|8(?:[0-3679][0-9][0-9][0-9][0-9].{64}|[48][0-9][0-9][0-9][0-9].{12}|5[0-9][0-9][0-9][0-9].{56})|9(?:[0-2467][0-9][0-9][0-9][0-9].{64}|[389][0-9][0-9][0-9][0-9].{12}|5[0-9][0-9][0-9][0-9].{56})|4(?:[0-46-8][0-9][0-9][0-9][0-9].{12}|5[0-9][0-9][0-9][0-9].{56}|9[0-9][0-9][0-9][0-9].{40})|0(?:[2-9][0-9][0-9][0-9][0-9].{4}|[01][0-9][0-9][0-9][0-9].{12})|2(?:[0-8][0-9][0-9][0-9][0-9].{4}|9[0-9][0-9][0-9][0-9].{388})|1[0-9][0-9][0-9][0-9][0-9].{4})|9(?:0(?:8(?:[13-6][0-9][0-9][0-9][0-9].{12}|[029][0-9][0-9][0-9][0-9].{8}|7[0-9][0-9][0-9][0-9].{156}|8[0-9][0-9][0-9][0-9].{840})|3(?:[01679][0-9][0-9][0-9][0-9].{8}|[3-5][0-9][0-9][0-9][0-9].{16}|2[0-9][0-9][0-9][0-9].{12}|8[0-9][0-9][0-9][0-9].{28})|2(?:[027-9][0-9][0-9][0-9][0-9].{8}|[13-5][0-9][0-9][0-9][0-9].{16}|6[0-9][0-9][0-9][0-9].{12})|9(?:[013489][0-9][0-9][0-9][0-9].{8}|[5-7][0-9][0-9][0-9][0-9].{16}|2[0-9][0-9][0-9][0-9].{32})|0(?:[1-489][0-9][0-9][0-9][0-9].{8}|[05-7][0-9][0-9][0-9][0-9].{16})|4(?:[0-578][0-9][0-9][0-9][0-9].{8}|[69][0-9][0-9][0-9][0-9].{20})|5(?:[1-59][0-9][0-9][0-9][0-9].{20}|[06-8][0-9][0-9][0-9][0-9].{8})|6(?:[2-69][0-9][0-9][0-9][0-9].{20}|[0178][0-9][0-9][0-9][0-9].{8})|7(?:[0-47-9][0-9][0-9][0-9][0-9].{8}|[56][0-9][0-9][0-9][0-9].{12})|1(?:[1-9][0-9][0-9][0-9][0-9].{16}|0[0-9][0-9][0-9][0-9].{8}))|[6-9][0-9][0-9][0-9][0-9][0-9][0-9].{4}))|5(?:3(?:3(?:0(?:[257][0-9][0-9][0-9][0-9].{8}|[34][0-9][0-9][0-9][0-9].{28}|0[0-9][0-9][0-9][0-9].{188}|6[0-9][0-9][0-9][0-9].{448}|8[0-9][0-9][0-9][0-9].{428}|9[0-9][0-9][0-9][0-9].{128}|1[0-9][0-9][0-9][0-9].{44})|5(?:[5689][0-9][0-9][0-9][0-9].{12}|0[0-9][0-9][0-9][0-9].{184}|2[0-9][0-9][0-9][0-9].{88}|3[0-9][0-9][0-9][0-9].{20}|4[0-9][0-9][0-9][0-9].{32}|7[0-9][0-9][0-9][0-9].{40}|1[0-9][0-9][0-9][0-9].{8})|7(?:[236-8][0-9][0-9][0-9][0-9].{12}|[45][0-9][0-9][0-9][0-9].{20}|0[0-9][0-9][0-9][0-9].{184}|9[0-9][0-9][0-9][0-9].{476}|1[0-9][0-9][0-9][0-9].{32})|4(?:[1-356][0-9][0-9][0-9][0-9].{32}|[78][0-9][0-9][0-9][0-9].{40}|0[0-9][0-9][0-9][0-9].{184}|4[0-9][0-9][0-9][0-9].{12}|9[0-9][0-9][0-9][0-9].{36})|1(?:[6-9][0-9][0-9][0-9][0-9].{32}|[2-4][0-9][0-9][0-9][0-9].{28}|0[0-9][0-9][0-9][0-9].{304}|5[0-9][0-9][0-9][0-9].{40}|1[0-9][0-9][0-9][0-9].{8})|6(?:[25-9][0-9][0-9][0-9][0-9].{12}|[04][0-9][0-9][0-9][0-9].{184}|1[0-9][0-9][0-9][0-9].{32}|3[0-9][0-9][0-9][0-9].{52})|2(?:[1-35-9][0-9][0-9][0-9][0-9].{32}|4[0-9][0-9][0-9][0-9].{184}|0[0-9][0-9][0-9][0-9].{12})|3(?:[124-9][0-9][0-9][0-9][0-9].{32}|0[0-9][0-9][0-9][0-9].{184}|3[0-9][0-9][0-9][0-9].{12})|[89][0-9][0-9][0-9][0-9][0-9].{20})|2(?:5(?:[3689][0-9][0-9][0-9][0-9].{8}|[45][0-9][0-9][0-9][0-9].{40}|0[0-9][0-9][0-9][0-9].{212}|1[0-9][0-9][0-9][0-9].{252}|7[0-9][0-9][0-9][0-9].{340}|2[0-9][0-9][0-9][0-9].{56})|3(?:[4-8][0-9][0-9][0-9][0-9].{36}|0[0-9][0-9][0-9][0-9].{292}|1[0-9][0-9][0-9][0-9].{136}|9[0-9][0-9][0-9][0-9].{116}|2[0-9][0-9][0-9][0-9].{92}|3[0-9][0-9][0-9][0-9].{44})|2(?:[1-57][0-9][0-9][0-9][0-9].{52}|6[0-9][0-9][0-9][0-9].{116}|8[0-9][0-9][0-9][0-9].{384}|0[0-9][0-9][0-9][0-9].{44}|9[0-9][0-9][0-9][0-9].{28})|0(?:[1346-8][0-9][0-9][0-9][0-9].{44}|0[0-9][0-9][0-9][0-9].{308}|9[0-9][0-9][0-9][0-9].{128}|5[0-9][0-9][0-9][0-9].{52}|2[0-9][0-9][0-9][0-9].{8})|8(?:[2-7][0-9][0-9][0-9][0-9].{36}|[08][0-9][0-9][0-9][0-9].{88}|1[0-9][0-9][0-9][0-9].{52}|9[0-9][0-9][0-9][0-9].{8})|4(?:[3-9][0-9][0-9][0-9][0-9].{36}|0[0-9][0-9][0-9][0-9].{60}|2[0-9][0-9][0-9][0-9].{56}|1[0-9][0-9][0-9][0-9].{8})|6(?:1[0-9][0-9][0-9][0-9].{420}|3[0-9][0-9][0-9][0-9].{276}|2[0-9][0-9][0-9][0-9].{56}|0[0-9][0-9][0-9][0-9].{8})|1(?:[2-9][0-9][0-9][0-9][0-9].{44}|0[0-9][0-9][0-9][0-9].{504}|1[0-9][0-9][0-9][0-9].{112}))|1(?:5(?:[1-3][0-9][0-9][0-9][0-9].{28}|[89][0-9][0-9][0-9][0-9].{32}|0[0-9][0-9][0-9][0-9].{304}|5[0-9][0-9][0-9][0-9].{404}|6[0-9][0-9][0-9][0-9].{240}|7[0-9][0-9][0-9][0-9].{12}|4[0-9][0-9][0-9][0-9].{8})|9(?:[0-5][0-9][0-9][0-9][0-9].{32}|9[0-9][0-9][0-9][0-9].{124}|6[0-9][0-9][0-9][0-9].{12}|7[0-9][0-9][0-9][0-9].{60}|8[0-9][0-9][0-9][0-9].{40})|1(?:[2-5][0-9][0-9][0-9][0-9].{12}|[189][0-9][0-9][0-9][0-9].{16}|[067][0-9][0-9][0-9][0-9].{8})|6(?:[2-9][0-9][0-9][0-9][0-9].{32}|0[0-9][0-9][0-9][0-9].{104}|1[0-9][0-9][0-9][0-9].{56})|8(?:[0-6][0-9][0-9][0-9][0-9].{184}|[7-9][0-9][0-9][0-9][0-9].{32})|7(?:[0-46-8][0-9][0-9][0-9][0-9].{12}|[59][0-9][0-9][0-9][0-9].{32})|0(?:[0-8][0-9][0-9][0-9][0-9].{12}|9[0-9][0-9][0-9][0-9].{260})|3(?:[4-9][0-9][0-9][0-9][0-9].{8}|[0-3][0-9][0-9][0-9][0-9].{12})|2(?:[1-9][0-9][0-9][0-9][0-9].{8}|0[0-9][0-9][0-9][0-9].{16})|4[0-9][0-9][0-9][0-9][0-9].{8})|5(?:5(?:[0-2][0-9][0-9][0-9][0-9].{12}|[7-9][0-9][0-9][0-9][0-9].{64}|[35][0-9][0-9][0-9][0-9].{56}|6[0-9][0-9][0-9][0-9].{124}|4[0-9][0-9][0-9][0-9].{28})|3(?:[3-6][0-9][0-9][0-9][0-9].{12}|[189][0-9][0-9][0-9][0-9].{8}|2[0-9][0-9][0-9][0-9].{108}|7[0-9][0-9][0-9][0-9].{248}|0[0-9][0-9][0-9][0-9].{4})|4(?:[2-47-9][0-9][0-9][0-9][0-9].{12}|[016][0-9][0-9][0-9][0-9].{40}|5[0-9][0-9][0-9][0-9].{56})|7(?:[02-49][0-9][0-9][0-9][0-9].{64}|[16-8][0-9][0-9][0-9][0-9].{12}|5[0-9][0-9][0-9][0-9].{56})|9(?:[0-47-9][0-9][0-9][0-9][0-9].{12}|5[0-9][0-9][0-9][0-9].{172}|6[0-9][0-9][0-9][0-9].{64})|8(?:[0-25689][0-9][0-9][0-9][0-9].{12}|[347][0-9][0-9][0-9][0-9].{64})|0(?:[2-9][0-9][0-9][0-9][0-9].{4}|[01][0-9][0-9][0-9][0-9].{12})|6(?:[0-46-9][0-9][0-9][0-9][0-9].{64}|5[0-9][0-9][0-9][0-9].{56})|[12][0-9][0-9][0-9][0-9][0-9].{4})|6(?:4(?:[68][0-9][0-9][0-9][0-9].{60}|0[0-9][0-9][0-9][0-9].{196}|2[0-9][0-9][0-9][0-9].{484}|3[0-9][0-9][0-9][0-9].{328}|4[0-9][0-9][0-9][0-9].{156}|5[0-9][0-9][0-9][0-9].{116}|1[0-9][0-9][0-9][0-9].{92}|7[0-9][0-9][0-9][0-9].{8})|3(?:[0348][0-9][0-9][0-9][0-9].{60}|1[0-9][0-9][0-9][0-9].{216}|5[0-9][0-9][0-9][0-9].{116}|6[0-9][0-9][0-9][0-9].{148}|7[0-9][0-9][0-9][0-9].{196}|2[0-9][0-9][0-9][0-9].{40})|2(?:[2-4][0-9][0-9][0-9][0-9].{72}|[01][0-9][0-9][0-9][0-9].{28}|7[0-9][0-9][0-9][0-9].{460}|8[0-9][0-9][0-9][0-9].{164}|9[0-9][0-9][0-9][0-9].{60}|5[0-9][0-9][0-9][0-9].{8})|0(?:[3-8][0-9][0-9][0-9][0-9].{28}|[0-2][0-9][0-9][0-9][0-9].{36}|9[0-9][0-9][0-9][0-9].{60})|1(?:[2-9][0-9][0-9][0-9][0-9].{28}|1[0-9][0-9][0-9][0-9].{168})|53[0-9][0-9][0-9][0-9].{92})|4[0-9][0-9][0-9][0-9][0-9][0-9].{4})|8(?:6(?:4(?:[0-4][0-9][0-9][0-9][0-9].{36}|6[0-9][0-9][0-9][0-9].{136}|8[0-9][0-9][0-9][0-9].{132}|5[0-9][0-9][0-9][0-9].{60}|7[0-9][0-9][0-9][0-9].{40}|9[0-9][0-9][0-9][0-9].{52})|7(?:[0-36][0-9][0-9][0-9][0-9].{52}|[78][0-9][0-9][0-9][0-9].{92}|4[0-9][0-9][0-9][0-9].{196}|5[0-9][0-9][0-9][0-9].{60}|9[0-9][0-9][0-9][0-9].{56})|1(?:[2-5][0-9][0-9][0-9][0-9].{44}|[7-9][0-9][0-9][0-9][0-9].{36}|0[0-9][0-9][0-9][0-9].{84}|1[0-9][0-9][0-9][0-9].{52}|6[0-9][0-9][0-9][0-9].{28})|0(?:[1-5][0-9][0-9][0-9][0-9].{44}|[7-9][0-9][0-9][0-9][0-9].{112}|0[0-9][0-9][0-9][0-9].{364}|6[0-9][0-9][0-9][0-9].{52})|2(?:[2-7][0-9][0-9][0-9][0-9].{28}|[01][0-9][0-9][0-9][0-9].{36}|8[0-9][0-9][0-9][0-9].{60}|9[0-9][0-9][0-9][0-9].{40})|8(?:[1-357][0-9][0-9][0-9][0-9].{60}|[08][0-9][0-9][0-9][0-9].{88}|6[0-9][0-9][0-9][0-9].{56}|9[0-9][0-9][0-9][0-9].{28})|3(?:[2-9][0-9][0-9][0-9][0-9].{36}|0[0-9][0-9][0-9][0-9].{128}|1[0-9][0-9][0-9][0-9].{92})|9(?:[0-7][0-9][0-9][0-9][0-9].{28}|8[0-9][0-9][0-9][0-9].{116}|9[0-9][0-9][0-9][0-9].{60})|6(?:[6-9][0-9][0-9][0-9][0-9].{52}|5[0-9][0-9][0-9][0-9].{20})|5(?:1[0-9][0-9][0-9][0-9].{60}|0[0-9][0-9][0-9][0-9].{8}))|2(?:9(?:[0134][0-9][0-9][0-9][0-9].{12}|[78][0-9][0-9][0-9][0-9].{44}|6[0-9][0-9][0-9][0-9].{296}|9[0-9][0-9][0-9][0-9].{172}|2[0-9][0-9][0-9][0-9].{56}|5[0-9][0-9][0-9][0-9].{28})|7(?:[6-9][0-9][0-9][0-9][0-9].{12}|[0-2][0-9][0-9][0-9][0-9].{4}|3[0-9][0-9][0-9][0-9].{28}|5[0-9][0-9][0-9][0-9].{40}|4[0-9][0-9][0-9][0-9].{8})|8(?:[5-79][0-9][0-9][0-9][0-9].{12}|[013][0-9][0-9][0-9][0-9].{56}|4[0-9][0-9][0-9][0-9].{228}|8[0-9][0-9][0-9][0-9].{88})|0(?:[2-6][0-9][0-9][0-9][0-9].{12}|[01][0-9][0-9][0-9][0-9].{124}|[7-9][0-9][0-9][0-9][0-9].{20})|3(?:[135-9][0-9][0-9][0-9][0-9].{12}|[04][0-9][0-9][0-9][0-9].{4}|2[0-9][0-9][0-9][0-9].{44})|2(?:[0-7][0-9][0-9][0-9][0-9].{20}|8[0-9][0-9][0-9][0-9].{36}|9[0-9][0-9][0-9][0-9].{12})|1(?:[1-7][0-9][0-9][0-9][0-9].{20}|[089][0-9][0-9][0-9][0-9].{12})|5(?:[3-9][0-9][0-9][0-9][0-9].{4}|[0-2][0-9][0-9][0-9][0-9].{12})|4(?:[1-9][0-9][0-9][0-9][0-9].{12}|0[0-9][0-9][0-9][0-9].{44})|6[0-9][0-9][0-9][0-9][0-9].{4})|1(?:1(?:[15-79][0-9][0-9][0-9][0-9].{8}|[24][0-9][0-9][0-9][0-9].{12}|8[0-9][0-9][0-9][0-9].{108}|0[0-9][0-9][0-9][0-9].{84}|3[0-9][0-9][0-9][0-9].{16})|8(?:[4-9][0-9][0-9][0-9][0-9].{24}|0[0-9][0-9][0-9][0-9].{132}|1[0-9][0-9][0-9][0-9].{332}|2[0-9][0-9][0-9][0-9].{12}|3[0-9][0-9][0-9][0-9].{8})|3(?:[05-9][0-9][0-9][0-9][0-9].{8}|[12][0-9][0-9][0-9][0-9].{12}|3[0-9][0-9][0-9][0-9].{156}|4[0-9][0-9][0-9][0-9].{40})|9(?:[02-6][0-9][0-9][0-9][0-9].{24}|[19][0-9][0-9][0-9][0-9].{12}|[78][0-9][0-9][0-9][0-9].{8})|7(?:[013-578][0-9][0-9][0-9][0-9].{8}|[26][0-9][0-9][0-9][0-9].{12}|9[0-9][0-9][0-9][0-9].{24})|0(?:[0-7][0-9][0-9][0-9][0-9].{8}|8[0-9][0-9][0-9][0-9].{32}|9[0-9][0-9][0-9][0-9].{12})|6(?:[014-9][0-9][0-9][0-9][0-9].{8}|[23][0-9][0-9][0-9][0-9].{12})|2(?:[0-57-9][0-9][0-9][0-9][0-9].{8}|6[0-9][0-9][0-9][0-9].{16})|[45][0-9][0-9][0-9][0-9][0-9].{8})|7(?:0(?:[14-68][0-9][0-9][0-9][0-9].{8}|[79][0-9][0-9][0-9][0-9].{28}|0[0-9][0-9][0-9][0-9].{16}|2[0-9][0-9][0-9][0-9].{84}|3[0-9][0-9][0-9][0-9].{12})|2(?:[5-9][0-9][0-9][0-9][0-9].{24}|[023][0-9][0-9][0-9][0-9].{12}|[14][0-9][0-9][0-9][0-9].{8})|3(?:[4-9][0-9][0-9][0-9][0-9].{8}|[0-2][0-9][0-9][0-9][0-9].{24}|3[0-9][0-9][0-9][0-9].{112})|6(?:[0136-9][0-9][0-9][0-9][0-9].{12}|[24][0-9][0-9][0-9][0-9].{20}|5[0-9][0-9][0-9][0-9].{8})|7(?:[2457-9][0-9][0-9][0-9][0-9].{8}|[136][0-9][0-9][0-9][0-9].{16}|0[0-9][0-9][0-9][0-9].{40})|1(?:[0-36-9][0-9][0-9][0-9][0-9].{8}|4[0-9][0-9][0-9][0-9].{128}|5[0-9][0-9][0-9][0-9].{28})|4(?:[0-59][0-9][0-9][0-9][0-9].{8}|[6-8][0-9][0-9][0-9][0-9].{24})|8(?:[0-26-9][0-9][0-9][0-9][0-9].{8}|[3-5][0-9][0-9][0-9][0-9].{40})|5(?:[0-79][0-9][0-9][0-9][0-9].{8}|8[0-9][0-9][0-9][0-9].{20})|9[0-9][0-9][0-9][0-9][0-9].{16}))|1(?:9(?:7(?:[0-4][0-9][0-9][0-9][0-9].{44}|[56][0-9][0-9][0-9][0-9].{12}|[78][0-9][0-9][0-9][0-9].{52}|9[0-9][0-9][0-9][0-9].{56})|8(?:[1-5][0-9][0-9][0-9][0-9].{36}|[08][0-9][0-9][0-9][0-9].{88}|[79][0-9][0-9][0-9][0-9].{56}|6[0-9][0-9][0-9][0-9].{92})|5(?:[0-5][0-9][0-9][0-9][0-9].{4}|[89][0-9][0-9][0-9][0-9].{12}|7[0-9][0-9][0-9][0-9].{40}|6[0-9][0-9][0-9][0-9].{8})|2(?:[2-8][0-9][0-9][0-9][0-9].{12}|[01][0-9][0-9][0-9][0-9].{32}|9[0-9][0-9][0-9][0-9].{36})|6(?:[4-9][0-9][0-9][0-9][0-9].{44}|[0-2][0-9][0-9][0-9][0-9].{12}|3[0-9][0-9][0-9][0-9].{72})|9(?:[0-7][0-9][0-9][0-9][0-9].{28}|9[0-9][0-9][0-9][0-9].{172}|8[0-9][0-9][0-9][0-9].{60})|0(?:[0-7][0-9][0-9][0-9][0-9].{8}|9[0-9][0-9][0-9][0-9].{600}|8[0-9][0-9][0-9][0-9].{60})|4(?:[0-4][0-9][0-9][0-9][0-9].{12}|[5-9][0-9][0-9][0-9][0-9].{4})|1(?:[0-8][0-9][0-9][0-9][0-9].{32}|9[0-9][0-9][0-9][0-9].{12})|3[0-9][0-9][0-9][0-9][0-9].{20})|6(?:5(?:[34689][0-9][0-9][0-9][0-9].{20}|[12][0-9][0-9][0-9][0-9].{8}|0[0-9][0-9][0-9][0-9].{12}|5[0-9][0-9][0-9][0-9].{16}|7[0-9][0-9][0-9][0-9].{24})|6(?:[1479][0-9][0-9][0-9][0-9].{20}|[268][0-9][0-9][0-9][0-9].{16}|0[0-9][0-9][0-9][0-9].{12}|3[0-9][0-9][0-9][0-9].{24}|5[0-9][0-9][0-9][0-9].{8})|0(?:[2-57-9][0-9][0-9][0-9][0-9].{8}|[16][0-9][0-9][0-9][0-9].{12}|0[0-9][0-9][0-9][0-9].{16})|3(?:[124-689][0-9][0-9][0-9][0-9].{8}|[03][0-9][0-9][0-9][0-9].{16}|7[0-9][0-9][0-9][0-9].{84})|4(?:[0237][0-9][0-9][0-9][0-9].{12}|[15689][0-9][0-9][0-9][0-9].{8}|4[0-9][0-9][0-9][0-9].{32})|1(?:[016-9][0-9][0-9][0-9][0-9].{8}|[2-5][0-9][0-9][0-9][0-9].{16})|2(?:[0-8][0-9][0-9][0-9][0-9].{8}|9[0-9][0-9][0-9][0-9].{28})|8(?:[0-79][0-9][0-9][0-9][0-9].{8}|8[0-9][0-9][0-9][0-9].{44})|9[0-9][0-9][0-9][0-9][0-9].{16}|7[0-9][0-9][0-9][0-9][0-9].{8})|7(?:8(?:[067][0-9][0-9][0-9][0-9].{12}|[589][0-9][0-9][0-9][0-9].{32}|[2-4][0-9][0-9][0-9][0-9].{8}|1[0-9][0-9][0-9][0-9].{28})|5(?:[1-46][0-9][0-9][0-9][0-9].{12}|[7-9][0-9][0-9][0-9][0-9].{8}|0[0-9][0-9][0-9][0-9].{40}|5[0-9][0-9][0-9][0-9].{16})|4(?:[1-7][0-9][0-9][0-9][0-9].{8}|0[0-9][0-9][0-9][0-9].{40}|8[0-9][0-9][0-9][0-9].{16}|9[0-9][0-9][0-9][0-9].{12})|9(?:[4-9][0-9][0-9][0-9][0-9].{32}|[0-2][0-9][0-9][0-9][0-9].{12}|3[0-9][0-9][0-9][0-9].{108})|1(?:[0-6][0-9][0-9][0-9][0-9].{24}|[7-9][0-9][0-9][0-9][0-9].{8})|3(?:[0-6][0-9][0-9][0-9][0-9].{8}|[7-9][0-9][0-9][0-9][0-9].{12})|6(?:[1-57-9][0-9][0-9][0-9][0-9].{8}|[06][0-9][0-9][0-9][0-9].{12})|7(?:[1-9][0-9][0-9][0-9][0-9].{8}|0[0-9][0-9][0-9][0-9].{12})|0[0-9][0-9][0-9][0-9][0-9].{24}|2[0-9][0-9][0-9][0-9][0-9].{8})|80(?:[0-4][0-9][0-9][0-9][0-9].{36}|5[0-9][0-9][0-9][0-9].{132}|6[0-9][0-9][0-9][0-9].{116}))|6(?:4(?:3(?:[4-6][0-9][0-9][0-9][0-9].{28}|7[0-9][0-9][0-9][0-9].{116}|8[0-9][0-9][0-9][0-9].{244}|9[0-9][0-9][0-9][0-9].{168}|0[0-9][0-9][0-9][0-9].{36}|1[0-9][0-9][0-9][0-9].{60}|3[0-9][0-9][0-9][0-9].{92})|1(?:[4-8][0-9][0-9][0-9][0-9].{44}|[09][0-9][0-9][0-9][0-9].{112}|3[0-9][0-9][0-9][0-9].{144}|1[0-9][0-9][0-9][0-9].{28}|2[0-9][0-9][0-9][0-9].{8})|2(?:[0-3][0-9][0-9][0-9][0-9].{44}|[5-7][0-9][0-9][0-9][0-9].{28}|8[0-9][0-9][0-9][0-9].{196}|4[0-9][0-9][0-9][0-9].{56}|9[0-9][0-9][0-9][0-9].{36})|6(?:[5-9][0-9][0-9][0-9][0-9].{72}|[12][0-9][0-9][0-9][0-9].{28}|0[0-9][0-9][0-9][0-9].{212}|3[0-9][0-9][0-9][0-9].{44}|4[0-9][0-9][0-9][0-9].{8})|7(?:[0-3][0-9][0-9][0-9][0-9].{72}|[7-9][0-9][0-9][0-9][0-9].{52}|4[0-9][0-9][0-9][0-9].{60}|5[0-9][0-9][0-9][0-9].{44}|6[0-9][0-9][0-9][0-9].{12})|0(?:[0-6][0-9][0-9][0-9][0-9].{64}|7[0-9][0-9][0-9][0-9].{124}|8[0-9][0-9][0-9][0-9].{176}|9[0-9][0-9][0-9][0-9].{232})|4(?:[5-9][0-9][0-9][0-9][0-9].{28}|[01][0-9][0-9][0-9][0-9].{184}|[2-4][0-9][0-9][0-9][0-9].{52})|8(?:[0-79][0-9][0-9][0-9][0-9].{52}|8[0-9][0-9][0-9][0-9].{88})|5[0-9][0-9][0-9][0-9][0-9].{28}|9[0-9][0-9][0-9][0-9][0-9].{52})|7(?:2(?:[26-8][0-9][0-9][0-9][0-9].{8}|[13][0-9][0-9][0-9][0-9].{16}|[45][0-9][0-9][0-9][0-9].{24}|0[0-9][0-9][0-9][0-9].{12}|9[0-9][0-9][0-9][0-9].{28})|7(?:[037][0-9][0-9][0-9][0-9].{12}|[125][0-9][0-9][0-9][0-9].{20}|[89][0-9][0-9][0-9][0-9].{24}|4[0-9][0-9][0-9][0-9].{16}|6[0-9][0-9][0-9][0-9].{8})|6(?:[13-5][0-9][0-9][0-9][0-9].{20}|[02][0-9][0-9][0-9][0-9].{16}|[6-8][0-9][0-9][0-9][0-9].{8}|9[0-9][0-9][0-9][0-9].{12})|0(?:[05-9][0-9][0-9][0-9][0-9].{8}|[12][0-9][0-9][0-9][0-9].{24}|3[0-9][0-9][0-9][0-9].{176}|4[0-9][0-9][0-9][0-9].{12})|3(?:[025-9][0-9][0-9][0-9][0-9].{16}|1[0-9][0-9][0-9][0-9].{12}|4[0-9][0-9][0-9][0-9].{32}|3[0-9][0-9][0-9][0-9].{8})|9(?:[016-9][0-9][0-9][0-9][0-9].{24}|[3-5][0-9][0-9][0-9][0-9].{16}|2[0-9][0-9][0-9][0-9].{8})|1(?:[02-5][0-9][0-9][0-9][0-9].{16}|[16-9][0-9][0-9][0-9][0-9].{8})|4(?:[3-9][0-9][0-9][0-9][0-9].{8}|[0-2][0-9][0-9][0-9][0-9].{16})|8(?:[0-68][0-9][0-9][0-9][0-9].{24}|[79][0-9][0-9][0-9][0-9].{8})|5(?:[0-24-9][0-9][0-9][0-9][0-9].{8}|3[0-9][0-9][0-9][0-9].{20}))|[1-35][0-9][0-9][0-9][0-9][0-9][0-9].{4})|9(?:0(?:0(?:[17][0-9][0-9][0-9][0-9].{100}|[2-4][0-9][0-9][0-9][0-9].{40}|[89][0-9][0-9][0-9][0-9].{36}|0[0-9][0-9][0-9][0-9].{936}|5[0-9][0-9][0-9][0-9].{972}|6[0-9][0-9][0-9][0-9].{44})|4(?:[178][0-9][0-9][0-9][0-9].{4}|[26][0-9][0-9][0-9][0-9].{96}|0[0-9][0-9][0-9][0-9].{468}|3[0-9][0-9][0-9][0-9].{692}|4[0-9][0-9][0-9][0-9].{272}|9[0-9][0-9][0-9][0-9].{92})|3(?:[28][0-9][0-9][0-9][0-9].{4}|0[0-9][0-9][0-9][0-9].{804}|1[0-9][0-9][0-9][0-9].{112}|9[0-9][0-9][0-9][0-9].{52})|5(?:[3-57-9][0-9][0-9][0-9][0-9].{140}|[0-2][0-9][0-9][0-9][0-9].{4}|6[0-9][0-9][0-9][0-9].{96})|6(?:[018][0-9][0-9][0-9][0-9].{4}|9[0-9][0-9][0-9][0-9].{104})|7(?:7[0-9][0-9][0-9][0-9].{272}|0[0-9][0-9][0-9][0-9].{56})|1[0-3][0-9][0-9][0-9][0-9].{96}|[289][0-9][0-9][0-9][0-9][0-9].{4})|6(?:0(?:[034][0-9][0-9][0-9][0-9].{40}|1[0-9][0-9][0-9][0-9].{100}|2[0-9][0-9][0-9][0-9].{112}|5[0-9][0-9][0-9][0-9].{52}|6[0-9][0-9][0-9][0-9].{44}|7[0-9][0-9][0-9][0-9].{36})|3(?:[57][0-9][0-9][0-9][0-9].{140}|[089][0-9][0-9][0-9][0-9].{4}|6[0-9][0-9][0-9][0-9].{96})|4(?:[026-8][0-9][0-9][0-9][0-9].{4}|4[0-9][0-9][0-9][0-9].{272}|1[0-9][0-9][0-9][0-9].{92})|9(?:[5-8][0-9][0-9][0-9][0-9].{96}|4[0-9][0-9][0-9][0-9].{56})|8(?:0[0-9][0-9][0-9][0-9].{468}|9[0-9][0-9][0-9][0-9].{96})|2[78][0-9][0-9][0-9][0-9].{140}|[5-7][0-9][0-9][0-9][0-9][0-9].{4}|10[0-9][0-9][0-9][0-9].{104})|4(?:0(?:[3-57-9][0-9][0-9][0-9][0-9].{36}|[12][0-9][0-9][0-9][0-9].{100}|0[0-9][0-9][0-9][0-9].{52}|6[0-9][0-9][0-9][0-9].{44})|4(?:[6-9][0-9][0-9][0-9][0-9].{96}|0[0-9][0-9][0-9][0-9].{632}|4[0-9][0-9][0-9][0-9].{272}|3[0-9][0-9][0-9][0-9].{56})|3(?:[0-57-9][0-9][0-9][0-9][0-9].{4}|6[0-9][0-9][0-9][0-9].{980})|2(?:[0-57-9][0-9][0-9][0-9][0-9].{4}|6[0-9][0-9][0-9][0-9].{92})|1(?:0[0-9][0-9][0-9][0-9].{104}|1[0-9][0-9][0-9][0-9].{36})|(?:5[6-9]|6[0-3])[0-9][0-9][0-9][0-9].{140}|9[014][0-9][0-9][0-9][0-9].{96}|80[0-9][0-9][0-9][0-9].{468}))|4(?:0(?:1(?:[1459][0-9][0-9][0-9][0-9].{16}|[0238][0-9][0-9][0-9][0-9].{8}|6[0-9][0-9][0-9][0-9].{32}|7[0-9][0-9][0-9][0-9].{12})|8(?:[1-4][0-9][0-9][0-9][0-9].{16}|[0679][0-9][0-9][0-9][0-9].{8}|5[0-9][0-9][0-9][0-9].{12}|8[0-9][0-9][0-9][0-9].{64})|2(?:[4-9][0-9][0-9][0-9][0-9].{24}|[12][0-9][0-9][0-9][0-9].{16}|[03][0-9][0-9][0-9][0-9].{8})|4(?:[2479][0-9][0-9][0-9][0-9].{16}|[356][0-9][0-9][0-9][0-9].{20}|[018][0-9][0-9][0-9][0-9].{8})|5(?:[1368][0-9][0-9][0-9][0-9].{20}|[2579][0-9][0-9][0-9][0-9].{16}|[04][0-9][0-9][0-9][0-9].{8})|6(?:[1359][0-9][0-9][0-9][0-9].{20}|[2467][0-9][0-9][0-9][0-9].{16}|[08][0-9][0-9][0-9][0-9].{8})|0(?:[035-8][0-9][0-9][0-9][0-9].{8}|[249][0-9][0-9][0-9][0-9].{16}|1[0-9][0-9][0-9][0-9].{12})|3(?:[3-8][0-9][0-9][0-9][0-9].{24}|[019][0-9][0-9][0-9][0-9].{8}|2[0-9][0-9][0-9][0-9].{12})|7(?:[0-24-9][0-9][0-9][0-9][0-9].{8}|3[0-9][0-9][0-9][0-9].{20})|9(?:[1-9][0-9][0-9][0-9][0-9].{16}|0[0-9][0-9][0-9][0-9].{8}))|7(?:5(?:[1-37-9][0-9][0-9][0-9][0-9].{24}|[56][0-9][0-9][0-9][0-9].{8}|0[0-9][0-9][0-9][0-9].{172}|4[0-9][0-9][0-9][0-9].{132})|2(?:[04-6][0-9][0-9][0-9][0-9].{12}|[1378][0-9][0-9][0-9][0-9].{8}|2[0-9][0-9][0-9][0-9].{84}|9[0-9][0-9][0-9][0-9].{40})|1(?:[0-469][0-9][0-9][0-9][0-9].{8}|[78][0-9][0-9][0-9][0-9].{12}|5[0-9][0-9][0-9][0-9].{84})|4(?:[1-79][0-9][0-9][0-9][0-9].{8}|8[0-9][0-9][0-9][0-9].{108}|0[0-9][0-9][0-9][0-9].{12})|6(?:[0-357-9][0-9][0-9][0-9][0-9].{24}|4[0-9][0-9][0-9][0-9].{40}|6[0-9][0-9][0-9][0-9].{8})|7(?:[1-35-9][0-9][0-9][0-9][0-9].{8}|0[0-9][0-9][0-9][0-9].{84}|4[0-9][0-9][0-9][0-9].{56})|3(?:[0-356][0-9][0-9][0-9][0-9].{8}|[47-9][0-9][0-9][0-9][0-9].{16})|[089][0-9][0-9][0-9][0-9][0-9].{8})|[24-69][0-9][0-9][0-9][0-9][0-9][0-9].{4})|5(?:4(?:1(?:[89][0-9][0-9][0-9][0-9].{44}|1[0-9][0-9][0-9][0-9].{372}|3[0-9][0-9][0-9][0-9].{196}|4[0-9][0-9][0-9][0-9].{328}|6[0-9][0-9][0-9][0-9].{268}|0[0-9][0-9][0-9][0-9].{40}|2[0-9][0-9][0-9][0-9].{60}|5[0-9][0-9][0-9][0-9].{52}|7[0-9][0-9][0-9][0-9].{92})|5(?:[12][0-9][0-9][0-9][0-9].{8}|3[0-9][0-9][0-9][0-9].{276}|4[0-9][0-9][0-9][0-9].{104}|5[0-9][0-9][0-9][0-9].{324}|6[0-9][0-9][0-9][0-9].{172}|7[0-9][0-9][0-9][0-9].{412}|8[0-9][0-9][0-9][0-9].{320}|0[0-9][0-9][0-9][0-9].{40})|0(?:[013-58][0-9][0-9][0-9][0-9].{60}|2[0-9][0-9][0-9][0-9].{432}|6[0-9][0-9][0-9][0-9].{452}|7[0-9][0-9][0-9][0-9].{388}|9[0-9][0-9][0-9][0-9].{116})|4(?:[0-7][0-9][0-9][0-9][0-9].{36}|8[0-9][0-9][0-9][0-9].{136}|9[0-9][0-9][0-9][0-9].{8})|2(?:[2-9][0-9][0-9][0-9][0-9].{36}|1[0-9][0-9][0-9][0-9].{292})|3[0-9][0-9][0-9][0-9][0-9].{36})|[35-9][0-9][0-9][0-9][0-9][0-9][0-9].{4})|79(?:9(?:[02-46][0-9][0-9][0-9][0-9].{44}|[89][0-9][0-9][0-9][0-9].{88}|5[0-9][0-9][0-9][0-9].{172}|1[0-9][0-9][0-9][0-9].{12}|7[0-9][0-9][0-9][0-9].{56})|6(?:[0-5][0-9][0-9][0-9][0-9].{4}|6[0-9][0-9][0-9][0-9].{108}|7[0-9][0-9][0-9][0-9].{12}|8[0-9][0-9][0-9][0-9].{28}|9[0-9][0-9][0-9][0-9].{40})|8(?:[1-4][0-9][0-9][0-9][0-9].{12}|[5-8][0-9][0-9][0-9][0-9].{44}|0[0-9][0-9][0-9][0-9].{56}|9[0-9][0-9][0-9][0-9].{36})|7(?:[1-8][0-9][0-9][0-9][0-9].{12}|0[0-9][0-9][0-9][0-9].{40}|9[0-9][0-9][0-9][0-9].{56})|0(?:[0-7][0-9][0-9][0-9][0-9].{32}|[89][0-9][0-9][0-9][0-9].{12})|3(?:[2-9][0-9][0-9][0-9][0-9].{12}|[01][0-9][0-9][0-9][0-9].{20})|4(?:[0-6][0-9][0-9][0-9][0-9].{12}|[7-9][0-9][0-9][0-9][0-9].{4})|1(?:[02-9][0-9][0-9][0-9][0-9].{12}|1[0-9][0-9][0-9][0-9].{32})|2[0-9][0-9][0-9][0-9][0-9].{20}|5[0-9][0-9][0-9][0-9][0-9].{4})|24(?:6(?:[235-9][0-9][0-9][0-9][0-9].{8}|[01][0-9][0-9][0-9][0-9].{40}|4[0-9][0-9][0-9][0-9].{12})|8(?:[1-35-9][0-9][0-9][0-9][0-9].{8}|4[0-9][0-9][0-9][0-9].{104}|0[0-9][0-9][0-9][0-9].{12})|5(?:[0-7][0-9][0-9][0-9][0-9].{12}|8[0-9][0-9][0-9][0-9].{16}|9[0-9][0-9][0-9][0-9].{8})|0(?:[4-9][0-9][0-9][0-9][0-9].{8}|[0-3][0-9][0-9][0-9][0-9].{24})|3(?:[0-7][0-9][0-9][0-9][0-9].{8}|[89][0-9][0-9][0-9][0-9].{12})|9(?:[1-8][0-9][0-9][0-9][0-9].{8}|[09][0-9][0-9][0-9][0-9].{12})|7(?:[1-9][0-9][0-9][0-9][0-9].{8}|0[0-9][0-9][0-9][0-9].{12})|[12][0-9][0-9][0-9][0-9][0-9].{8}|4[0-9][0-9][0-9][0-9][0-9].{12})|08(?:4(?:[04][0-9][0-9][0-9][0-9].{624}|1[0-9][0-9][0-9][0-9].{680}|2[0-9][0-9][0-9][0-9].{36})|5(?:5[0-9][0-9][0-9][0-9].{680}|0[0-9][0-9][0-9][0-9].{56})))|1(?:8(?:6(?:9(?:0[0-9][0-9][0-9][0-9].{388}|2[0-9][0-9][0-9][0-9].{148}|4[0-9][0-9][0-9][0-9].{180}|6[0-9][0-9][0-9][0-9].{156}|7[0-9][0-9][0-9][0-9].{432}|8[0-9][0-9][0-9][0-9].{584}|1[0-9][0-9][0-9][0-9].{88}|5[0-9][0-9][0-9][0-9].{28}|9[0-9][0-9][0-9][0-9].{24}|3[0-9][0-9][0-9][0-9].{8})|7(?:[34][0-9][0-9][0-9][0-9].{580}|0[0-9][0-9][0-9][0-9].{496}|7[0-9][0-9][0-9][0-9].{312}|1[0-9][0-9][0-9][0-9].{40}|2[0-9][0-9][0-9][0-9].{92}|5[0-9][0-9][0-9][0-9].{52}|6[0-9][0-9][0-9][0-9].{32}|9[0-9][0-9][0-9][0-9].{36}|8[0-9][0-9][0-9][0-9].{8})|6(?:[379][0-9][0-9][0-9][0-9].{8}|0[0-9][0-9][0-9][0-9].{136}|1[0-9][0-9][0-9][0-9].{196}|2[0-9][0-9][0-9][0-9].{328}|4[0-9][0-9][0-9][0-9].{588}|6[0-9][0-9][0-9][0-9].{780}|8[0-9][0-9][0-9][0-9].{484}|5[0-9][0-9][0-9][0-9].{88})|2(?:[3489][0-9][0-9][0-9][0-9].{60}|2[0-9][0-9][0-9][0-9].{376}|7[0-9][0-9][0-9][0-9].{352}|0[0-9][0-9][0-9][0-9].{72}|6[0-9][0-9][0-9][0-9].{88}|1[0-9][0-9][0-9][0-9].{8})|8(?:[01][0-9][0-9][0-9][0-9].{372}|[2-4][0-9][0-9][0-9][0-9].{36}|[7-9][0-9][0-9][0-9][0-9].{32}|5[0-9][0-9][0-9][0-9].{752}|6[0-9][0-9][0-9][0-9].{164})|4(?:[1-5][0-9][0-9][0-9][0-9].{92}|[89][0-9][0-9][0-9][0-9].{144}|0[0-9][0-9][0-9][0-9].{216}|7[0-9][0-9][0-9][0-9].{44}|6[0-9][0-9][0-9][0-9].{8})|3(?:[02-9][0-9][0-9][0-9][0-9].{60}|1[0-9][0-9][0-9][0-9].{460})|5[01][0-9][0-9][0-9][0-9].{144}|[01][0-9][0-9][0-9][0-9][0-9].{72})|5(?:6(?:[26][0-9][0-9][0-9][0-9].{244}|[3-5][0-9][0-9][0-9][0-9].{24}|0[0-9][0-9][0-9][0-9].{452}|1[0-9][0-9][0-9][0-9].{212}|8[0-9][0-9][0-9][0-9].{404}|9[0-9][0-9][0-9][0-9].{240}|7[0-9][0-9][0-9][0-9].{8})|9(?:[0-2][0-9][0-9][0-9][0-9].{116}|[6-8][0-9][0-9][0-9][0-9].{168}|3[0-9][0-9][0-9][0-9].{988}|5[0-9][0-9][0-9][0-9].{136}|4[0-9][0-9][0-9][0-9].{28}|9[0-9][0-9][0-9][0-9].{72})|8(?:[3467][0-9][0-9][0-9][0-9].{60}|[01][0-9][0-9][0-9][0-9].{28}|8[0-9][0-9][0-9][0-9].{420}|9[0-9][0-9][0-9][0-9].{720}|2[0-9][0-9][0-9][0-9].{36}|5[0-9][0-9][0-9][0-9].{92})|0(?:[0-2][0-9][0-9][0-9][0-9].{116}|[34][0-9][0-9][0-9][0-9].{244}|[89][0-9][0-9][0-9][0-9].{28}|[67][0-9][0-9][0-9][0-9].{8}|5[0-9][0-9][0-9][0-9].{476})|5(?:[0-2][0-9][0-9][0-9][0-9].{28}|[5-8][0-9][0-9][0-9][0-9].{8}|3[0-9][0-9][0-9][0-9].{448}|4[0-9][0-9][0-9][0-9].{428}|9[0-9][0-9][0-9][0-9].{244})|7(?:[3468][0-9][0-9][0-9][0-9].{128}|[0-2][0-9][0-9][0-9][0-9].{244}|[79][0-9][0-9][0-9][0-9].{28}|5[0-9][0-9][0-9][0-9].{288})|3(?:[5-8][0-9][0-9][0-9][0-9].{60}|[01][0-9][0-9][0-9][0-9].{500}|[2-4][0-9][0-9][0-9][0-9].{8}|9[0-9][0-9][0-9][0-9].{28})|1(?:[46-9][0-9][0-9][0-9][0-9].{36}|[0-2][0-9][0-9][0-9][0-9].{28}|5[0-9][0-9][0-9][0-9].{196}|3[0-9][0-9][0-9][0-9].{72})|2[0-9][0-9][0-9][0-9][0-9].{36}|4[0-9][0-9][0-9][0-9][0-9].{28})|7(?:4(?:[7-9][0-9][0-9][0-9][0-9].{132}|[12][0-9][0-9][0-9][0-9].{8}|3[0-9][0-9][0-9][0-9].{172}|4[0-9][0-9][0-9][0-9].{832}|6[0-9][0-9][0-9][0-9].{620}|0[0-9][0-9][0-9][0-9].{24}|5[0-9][0-9][0-9][0-9].{40})|5(?:[4-7][0-9][0-9][0-9][0-9].{252}|[01][0-9][0-9][0-9][0-9].{132}|2[0-9][0-9][0-9][0-9].{232}|3[0-9][0-9][0-9][0-9].{228}|8[0-9][0-9][0-9][0-9].{700}|9[0-9][0-9][0-9][0-9].{116})|6(?:[0-39][0-9][0-9][0-9][0-9].{8}|4[0-9][0-9][0-9][0-9].{848}|5[0-9][0-9][0-9][0-9].{276}|6[0-9][0-9][0-9][0-9].{104}|7[0-9][0-9][0-9][0-9].{108}|8[0-9][0-9][0-9][0-9].{340})|2(?:[5-7][0-9][0-9][0-9][0-9].{8}|[89][0-9][0-9][0-9][0-9].{36}|1[0-9][0-9][0-9][0-9].{292}|2[0-9][0-9][0-9][0-9].{228}|4[0-9][0-9][0-9][0-9].{252}|3[0-9][0-9][0-9][0-9].{40})|7(?:[0-4][0-9][0-9][0-9][0-9].{24}|[67][0-9][0-9][0-9][0-9].{48}|5[0-9][0-9][0-9][0-9].{324}|8[0-9][0-9][0-9][0-9].{696}|9[0-9][0-9][0-9][0-9].{412})|8(?:[0-5][0-9][0-9][0-9][0-9].{320}|[69][0-9][0-9][0-9][0-9].{8}|7[0-9][0-9][0-9][0-9].{392}|8[0-9][0-9][0-9][0-9].{116})|3(?:[0-5][0-9][0-9][0-9][0-9].{36}|[67][0-9][0-9][0-9][0-9].{8}|8[0-9][0-9][0-9][0-9].{32}|9[0-9][0-9][0-9][0-9].{24})|9(?:[1-9][0-9][0-9][0-9][0-9].{48}|0[0-9][0-9][0-9][0-9].{8}))|4(?:8(?:0[0-9][0-9][0-9][0-9].{104}|3[0-9][0-9][0-9][0-9].{244}|4[0-9][0-9][0-9][0-9].{500}|5[0-9][0-9][0-9][0-9].{576}|6[0-9][0-9][0-9][0-9].{384}|7[0-9][0-9][0-9][0-9].{116}|1[0-9][0-9][0-9][0-9].{60}|8[0-9][0-9][0-9][0-9].{88}|9[0-9][0-9][0-9][0-9].{52}|2[0-9][0-9][0-9][0-9].{8})|1(?:[6-9][0-9][0-9][0-9][0-9].{28}|[12][0-9][0-9][0-9][0-9].{8}|0[0-9][0-9][0-9][0-9].{104}|3[0-9][0-9][0-9][0-9].{144}|4[0-9][0-9][0-9][0-9].{196}|5[0-9][0-9][0-9][0-9].{44})|0(?:[0-4][0-9][0-9][0-9][0-9].{112}|[78][0-9][0-9][0-9][0-9].{144}|[56][0-9][0-9][0-9][0-9].{40}|9[0-9][0-9][0-9][0-9].{8})|2(?:[013-5][0-9][0-9][0-9][0-9].{28}|[6-8][0-9][0-9][0-9][0-9].{112}|9[0-9][0-9][0-9][0-9].{528}|2[0-9][0-9][0-9][0-9].{12})|7(?:[4-9][0-9][0-9][0-9][0-9].{60}|[01][0-9][0-9][0-9][0-9].{44}|2[0-9][0-9][0-9][0-9].{268}|3[0-9][0-9][0-9][0-9].{28})|6(?:[2-9][0-9][0-9][0-9][0-9].{44}|0[0-9][0-9][0-9][0-9].{104}|1[0-9][0-9][0-9][0-9].{20})|3(?:[1-79][0-9][0-9][0-9][0-9].{44}|0[0-9][0-9][0-9][0-9].{32}|8[0-9][0-9][0-9][0-9].{72})|9(?:[0-7][0-9][0-9][0-9][0-9].{52}|[89][0-9][0-9][0-9][0-9].{116})|5(?:[0-4][0-9][0-9][0-9][0-9].{84}|[5-9][0-9][0-9][0-9][0-9].{44})|4[0-9][0-9][0-9][0-9][0-9].{84})|3(?:7(?:[68][0-9][0-9][0-9][0-9].{44}|[24][0-9][0-9][0-9][0-9].{8}|0[0-9][0-9][0-9][0-9].{364}|1[0-9][0-9][0-9][0-9].{308}|5[0-9][0-9][0-9][0-9].{116}|7[0-9][0-9][0-9][0-9].{416}|9[0-9][0-9][0-9][0-9].{112}|3[0-9][0-9][0-9][0-9].{56})|6(?:[5-8][0-9][0-9][0-9][0-9].{72}|[24][0-9][0-9][0-9][0-9].{28}|1[0-9][0-9][0-9][0-9].{112}|0[0-9][0-9][0-9][0-9].{40}|3[0-9][0-9][0-9][0-9].{56}|9[0-9][0-9][0-9][0-9].{8})|3(?:[0-4][0-9][0-9][0-9][0-9].{64}|[79][0-9][0-9][0-9][0-9].{40}|5[0-9][0-9][0-9][0-9].{248}|8[0-9][0-9][0-9][0-9].{56}|6[0-9][0-9][0-9][0-9].{8})|8(?:[13-68][0-9][0-9][0-9][0-9].{56}|[79][0-9][0-9][0-9][0-9].{8}|0[0-9][0-9][0-9][0-9].{156}|2[0-9][0-9][0-9][0-9].{52})|9(?:[124-8][0-9][0-9][0-9][0-9].{8}|0[0-9][0-9][0-9][0-9].{640}|9[0-9][0-9][0-9][0-9].{172}|3[0-9][0-9][0-9][0-9].{56})|0(?:[0-5][0-9][0-9][0-9][0-9].{4}|[7-9][0-9][0-9][0-9][0-9].{64}|6[0-9][0-9][0-9][0-9].{8})|4(?:[0-24-9][0-9][0-9][0-9][0-9].{40}|3[0-9][0-9][0-9][0-9].{56})|5(?:[0-24-9][0-9][0-9][0-9][0-9].{40}|3[0-9][0-9][0-9][0-9].{56})|[12][0-9][0-9][0-9][0-9][0-9].{64})|0(?:4(?:[0-5][0-9][0-9][0-9][0-9].{304}|[89][0-9][0-9][0-9][0-9].{12}|7[0-9][0-9][0-9][0-9].{124}|6[0-9][0-9][0-9][0-9].{8})|9(?:[4-8][0-9][0-9][0-9][0-9].{12}|[0-2][0-9][0-9][0-9][0-9].{56}|9[0-9][0-9][0-9][0-9].{124}|3[0-9][0-9][0-9][0-9].{16})|7(?:[4-79][0-9][0-9][0-9][0-9].{12}|[0-2][0-9][0-9][0-9][0-9].{124}|8[0-9][0-9][0-9][0-9].{40}|3[0-9][0-9][0-9][0-9].{8})|1(?:[5-9][0-9][0-9][0-9][0-9].{12}|[0-3][0-9][0-9][0-9][0-9].{8}|4[0-9][0-9][0-9][0-9].{296})|6(?:[3-9][0-9][0-9][0-9][0-9].{124}|[02][0-9][0-9][0-9][0-9].{8}|1[0-9][0-9][0-9][0-9].{12})|3(?:[1-4][0-9][0-9][0-9][0-9].{12}|[5-9][0-9][0-9][0-9][0-9].{8}|0[0-9][0-9][0-9][0-9].{56})|2(?:[1-7][0-9][0-9][0-9][0-9].{124}|9[0-9][0-9][0-9][0-9].{12}|8[0-9][0-9][0-9][0-9].{8})|5(?:[2-9][0-9][0-9][0-9][0-9].{12}|[01][0-9][0-9][0-9][0-9].{8})|8(?:[1-9][0-9][0-9][0-9][0-9].{56}|0[0-9][0-9][0-9][0-9].{108})|0[0-9][0-9][0-9][0-9][0-9].{8})|2(?:8(?:[014-79][0-9][0-9][0-9][0-9].{4}|2[0-9][0-9][0-9][0-9].{172}|3[0-9][0-9][0-9][0-9].{56}|8[0-9][0-9][0-9][0-9].{88})|0(?:[0-26-8][0-9][0-9][0-9][0-9].{8}|[3-5][0-9][0-9][0-9][0-9].{12}|9[0-9][0-9][0-9][0-9].{40})|1(?:[0-5][0-9][0-9][0-9][0-9].{40}|[6-8][0-9][0-9][0-9][0-9].{12}|9[0-9][0-9][0-9][0-9].{8})|2(?:[1-79][0-9][0-9][0-9][0-9].{12}|0[0-9][0-9][0-9][0-9].{36}|8[0-9][0-9][0-9][0-9].{56})|6(?:[0-36-9][0-9][0-9][0-9][0-9].{12}|5[0-9][0-9][0-9][0-9].{40}|4[0-9][0-9][0-9][0-9].{8})|4(?:[2-9][0-9][0-9][0-9][0-9].{12}|[01][0-9][0-9][0-9][0-9].{20})|7(?:[3-9][0-9][0-9][0-9][0-9].{4}|[0-2][0-9][0-9][0-9][0-9].{12})|3[0-9][0-9][0-9][0-9][0-9].{20}|5[0-9][0-9][0-9][0-9][0-9].{12}|9[0-9][0-9][0-9][0-9][0-9].{4})|1(?:2(?:[3-8][0-9][0-9][0-9][0-9].{124}|0[0-9][0-9][0-9][0-9].{108}|1[0-9][0-9][0-9][0-9].{244}|2[0-9][0-9][0-9][0-9].{228}|9[0-9][0-9][0-9][0-9].{40})|7(?:[02-6][0-9][0-9][0-9][0-9].{20}|[78][0-9][0-9][0-9][0-9].{108}|1[0-9][0-9][0-9][0-9].{12}|9[0-9][0-9][0-9][0-9].{8})|8(?:[2-79][0-9][0-9][0-9][0-9].{20}|0[0-9][0-9][0-9][0-9].{212}|1[0-9][0-9][0-9][0-9].{108}|8[0-9][0-9][0-9][0-9].{12})|9(?:[06-9][0-9][0-9][0-9][0-9].{12}|[1245][0-9][0-9][0-9][0-9].{108}|3[0-9][0-9][0-9][0-9].{20})|6(?:[02-8][0-9][0-9][0-9][0-9].{12}|1[0-9][0-9][0-9][0-9].{660}|9[0-9][0-9][0-9][0-9].{20})|3(?:[0-4][0-9][0-9][0-9][0-9].{124}|[5-9][0-9][0-9][0-9][0-9].{12})|[01][0-9][0-9][0-9][0-9][0-9].{108}|[45][0-9][0-9][0-9][0-9][0-9].{12})|8[01][0-9][0-9][0-9][0-9][0-9].{48})|7(?:4(?:9(?:[147-9][0-9][0-9][0-9][0-9].{16}|[23][0-9][0-9][0-9][0-9].{8}|0[0-9][0-9][0-9][0-9].{188}|5[0-9][0-9][0-9][0-9].{380}|6[0-9][0-9][0-9][0-9].{12})|3(?:[235689][0-9][0-9][0-9][0-9].{16}|0[0-9][0-9][0-9][0-9].{40}|1[0-9][0-9][0-9][0-9].{24}|7[0-9][0-9][0-9][0-9].{64}|4[0-9][0-9][0-9][0-9].{8})|7(?:[0-3][0-9][0-9][0-9][0-9].{12}|[6-9][0-9][0-9][0-9][0-9].{16}|[45][0-9][0-9][0-9][0-9].{20})|6(?:[1-35-7][0-9][0-9][0-9][0-9].{40}|[89][0-9][0-9][0-9][0-9].{16}|[04][0-9][0-9][0-9][0-9].{8})|8(?:[5-8][0-9][0-9][0-9][0-9].{12}|[349][0-9][0-9][0-9][0-9].{16}|[0-2][0-9][0-9][0-9][0-9].{8})|1(?:[0-37][0-9][0-9][0-9][0-9].{40}|[4-69][0-9][0-9][0-9][0-9].{16}|8[0-9][0-9][0-9][0-9].{24})|2(?:[1346-8][0-9][0-9][0-9][0-9].{16}|[259][0-9][0-9][0-9][0-9].{64}|0[0-9][0-9][0-9][0-9].{32})|0(?:[1-8][0-9][0-9][0-9][0-9].{12}|0[0-9][0-9][0-9][0-9].{84}|9[0-9][0-9][0-9][0-9].{40})|5(?:[0-35][0-9][0-9][0-9][0-9].{40}|[46-9][0-9][0-9][0-9][0-9].{8})|4[0-9][0-9][0-9][0-9][0-9].{20})|6(?:2(?:[02][0-9][0-9][0-9][0-9].{72}|[78][0-9][0-9][0-9][0-9].{44}|1[0-9][0-9][0-9][0-9].{128}|3[0-9][0-9][0-9][0-9].{144}|4[0-9][0-9][0-9][0-9].{176}|5[0-9][0-9][0-9][0-9].{424}|6[0-9][0-9][0-9][0-9].{200}|9[0-9][0-9][0-9][0-9].{8})|5(?:[5-79][0-9][0-9][0-9][0-9].{16}|[38][0-9][0-9][0-9][0-9].{8}|0[0-9][0-9][0-9][0-9].{104}|1[0-9][0-9][0-9][0-9].{204}|2[0-9][0-9][0-9][0-9].{20}|4[0-9][0-9][0-9][0-9].{92})|4(?:[0-46][0-9][0-9][0-9][0-9].{88}|5[0-9][0-9][0-9][0-9].{196}|7[0-9][0-9][0-9][0-9].{176}|8[0-9][0-9][0-9][0-9].{136}|9[0-9][0-9][0-9][0-9].{232})|3(?:[14-689][0-9][0-9][0-9][0-9].{88}|[237][0-9][0-9][0-9][0-9].{24}|0[0-9][0-9][0-9][0-9].{72})|7(?:[0-7][0-9][0-9][0-9][0-9].{32}|8[0-9][0-9][0-9][0-9].{12}|9[0-9][0-9][0-9][0-9].{16})|9(?:[02-46-9][0-9][0-9][0-9][0-9].{16}|[15][0-9][0-9][0-9][0-9].{12})|0(?:[1-9][0-9][0-9][0-9][0-9].{16}|0[0-9][0-9][0-9][0-9].{12})|1[0-9][0-9][0-9][0-9][0-9].{16}|6[0-9][0-9][0-9][0-9][0-9].{12}|8[0-9][0-9][0-9][0-9][0-9].{8})|7(?:4(?:[2-47][0-9][0-9][0-9][0-9].{156}|[589][0-9][0-9][0-9][0-9].{12}|0[0-9][0-9][0-9][0-9].{532}|1[0-9][0-9][0-9][0-9].{32}|6[0-9][0-9][0-9][0-9].{40})|3(?:[5-9][0-9][0-9][0-9][0-9].{156}|[24][0-9][0-9][0-9][0-9].{8}|0[0-9][0-9][0-9][0-9].{40}|1[0-9][0-9][0-9][0-9].{32}|3[0-9][0-9][0-9][0-9].{84})|8(?:[0-359][0-9][0-9][0-9][0-9].{8}|[78][0-9][0-9][0-9][0-9].{84}|4[0-9][0-9][0-9][0-9].{12}|6[0-9][0-9][0-9][0-9].{52})|6(?:[1-35689][0-9][0-9][0-9][0-9].{12}|4[0-9][0-9][0-9][0-9].{16}|7[0-9][0-9][0-9][0-9].{84}|0[0-9][0-9][0-9][0-9].{8})|9(?:[1-5][0-9][0-9][0-9][0-9].{12}|[08][0-9][0-9][0-9][0-9].{84}|[679][0-9][0-9][0-9][0-9].{8})|7(?:[0-24578][0-9][0-9][0-9][0-9].{12}|[69][0-9][0-9][0-9][0-9].{8}|3[0-9][0-9][0-9][0-9].{16})|5(?:[1-8][0-9][0-9][0-9][0-9].{12}|0[0-9][0-9][0-9][0-9].{156}|9[0-9][0-9][0-9][0-9].{8})|0(?:[0-6][0-9][0-9][0-9][0-9].{8}|[7-9][0-9][0-9][0-9][0-9].{84})|[12][0-9][0-9][0-9][0-9][0-9].{40})|0(?:1(?:[35689][0-9][0-9][0-9][0-9].{8}|[14][0-9][0-9][0-9][0-9].{16}|0[0-9][0-9][0-9][0-9].{40}|2[0-9][0-9][0-9][0-9].{32}|7[0-9][0-9][0-9][0-9].{12})|0(?:[0-2457][0-9][0-9][0-9][0-9].{40}|[89][0-9][0-9][0-9][0-9].{12}|3[0-9][0-9][0-9][0-9].{64}|6[0-9][0-9][0-9][0-9].{32})|4(?:[13579][0-9][0-9][0-9][0-9].{16}|[246][0-9][0-9][0-9][0-9].{8}|0[0-9][0-9][0-9][0-9].{40}|8[0-9][0-9][0-9][0-9].{36})|3(?:[6-9][0-9][0-9][0-9][0-9].{24}|[014][0-9][0-9][0-9][0-9].{16}|[235][0-9][0-9][0-9][0-9].{8})|6(?:[02489][0-9][0-9][0-9][0-9].{8}|[35-7][0-9][0-9][0-9][0-9].{32}|1[0-9][0-9][0-9][0-9].{108})|5(?:[135689][0-9][0-9][0-9][0-9].{8}|[247][0-9][0-9][0-9][0-9].{16}|0[0-9][0-9][0-9][0-9].{40})|8(?:[1-9][0-9][0-9][0-9][0-9].{24}|0[0-9][0-9][0-9][0-9].{32})|7[0-9][0-9][0-9][0-9][0-9].{32}|9[0-9][0-9][0-9][0-9][0-9].{24}|2[0-9][0-9][0-9][0-9][0-9].{8})|8(?:9(?:[27-9][0-9][0-9][0-9][0-9].{8}|[56][0-9][0-9][0-9][0-9].{260}|[34][0-9][0-9][0-9][0-9].{12}|0[0-9][0-9][0-9][0-9].{228}|1[0-9][0-9][0-9][0-9].{132})|8(?:[02-6][0-9][0-9][0-9][0-9].{8}|[79][0-9][0-9][0-9][0-9].{12}|1[0-9][0-9][0-9][0-9].{132}|8[0-9][0-9][0-9][0-9].{40})|4(?:[3-6][0-9][0-9][0-9][0-9].{12}|[0-2][0-9][0-9][0-9][0-9].{24}|[7-9][0-9][0-9][0-9][0-9].{8})|0(?:[0-5][0-9][0-9][0-9][0-9].{8}|[6-8][0-9][0-9][0-9][0-9].{16}|9[0-9][0-9][0-9][0-9].{12})|6(?:[3-689][0-9][0-9][0-9][0-9].{8}|[0-2][0-9][0-9][0-9][0-9].{16}|7[0-9][0-9][0-9][0-9].{12})|5(?:[0-4][0-9][0-9][0-9][0-9].{40}|[5-9][0-9][0-9][0-9][0-9].{16})|3(?:[5-9][0-9][0-9][0-9][0-9].{12}|[0-4][0-9][0-9][0-9][0-9].{8})|7(?:[0-689][0-9][0-9][0-9][0-9].{8}|7[0-9][0-9][0-9][0-9].{132})|1[0-9][0-9][0-9][0-9][0-9].{12}|2[0-9][0-9][0-9][0-9][0-9].{8})|9(?:3(?:[12479][0-9][0-9][0-9][0-9].{12}|[56][0-9][0-9][0-9][0-9].{112}|[03][0-9][0-9][0-9][0-9].{40}|8[0-9][0-9][0-9][0-9].{8})|9(?:[1-68][0-9][0-9][0-9][0-9].{8}|7[0-9][0-9][0-9][0-9].{108}|9[0-9][0-9][0-9][0-9].{516}|0[0-9][0-9][0-9][0-9].{12})|7(?:[06-9][0-9][0-9][0-9][0-9].{12}|[235][0-9][0-9][0-9][0-9].{104}|[14][0-9][0-9][0-9][0-9].{8})|8(?:[1-467][0-9][0-9][0-9][0-9].{8}|[089][0-9][0-9][0-9][0-9].{12}|5[0-9][0-9][0-9][0-9].{236})|4(?:[03-59][0-9][0-9][0-9][0-9].{12}|[1278][0-9][0-9][0-9][0-9].{8}|6[0-9][0-9][0-9][0-9].{40})|5(?:[0459][0-9][0-9][0-9][0-9].{12}|[1-378][0-9][0-9][0-9][0-9].{8}|6[0-9][0-9][0-9][0-9].{40})|6(?:[05-79][0-9][0-9][0-9][0-9].{12}|[1-48][0-9][0-9][0-9][0-9].{8})|0(?:[1-9][0-9][0-9][0-9][0-9].{12}|0[0-9][0-9][0-9][0-9].{8})|[12][0-9][0-9][0-9][0-9][0-9].{12})|2(?:9(?:[2-48][0-9][0-9][0-9][0-9].{12}|[01][0-9][0-9][0-9][0-9].{16}|[67][0-9][0-9][0-9][0-9].{84}|[59][0-9][0-9][0-9][0-9].{8})|6(?:[0-367][0-9][0-9][0-9][0-9].{8}|[45][0-9][0-9][0-9][0-9].{16}|[89][0-9][0-9][0-9][0-9].{12})|2(?:[0-3568][0-9][0-9][0-9][0-9].{32}|[79][0-9][0-9][0-9][0-9].{12}|4[0-9][0-9][0-9][0-9].{8})|7(?:[013-7][0-9][0-9][0-9][0-9].{12}|[89][0-9][0-9][0-9][0-9].{8}|2[0-9][0-9][0-9][0-9].{32})|8(?:[3-8][0-9][0-9][0-9][0-9].{8}|[129][0-9][0-9][0-9][0-9].{12}|0[0-9][0-9][0-9][0-9].{32})|3(?:[0-468][0-9][0-9][0-9][0-9].{8}|[579][0-9][0-9][0-9][0-9].{16})|4(?:[024689][0-9][0-9][0-9][0-9].{8}|[1357][0-9][0-9][0-9][0-9].{16})|5(?:[0-689][0-9][0-9][0-9][0-9].{8}|7[0-9][0-9][0-9][0-9].{16})|[01][0-9][0-9][0-9][0-9][0-9].{32})|5(?:8(?:[1346-9][0-9][0-9][0-9][0-9].{8}|0[0-9][0-9][0-9][0-9].{32}|2[0-9][0-9][0-9][0-9].{12}|5[0-9][0-9][0-9][0-9].{44})|7(?:[0-267][0-9][0-9][0-9][0-9].{12}|[3489][0-9][0-9][0-9][0-9].{8}|5[0-9][0-9][0-9][0-9].{332})|5(?:[013468][0-9][0-9][0-9][0-9].{40}|[579][0-9][0-9][0-9][0-9].{8}|2[0-9][0-9][0-9][0-9].{12})|4(?:[0-25-9][0-9][0-9][0-9][0-9].{8}|3[0-9][0-9][0-9][0-9].{56}|4[0-9][0-9][0-9][0-9].{12})|1(?:[3-9][0-9][0-9][0-9][0-9].{8}|[0-2][0-9][0-9][0-9][0-9].{12})|6(?:[0-57-9][0-9][0-9][0-9][0-9].{12}|6[0-9][0-9][0-9][0-9].{8})|9(?:[0-46-9][0-9][0-9][0-9][0-9].{8}|5[0-9][0-9][0-9][0-9].{44})|[23][0-9][0-9][0-9][0-9][0-9].{8}|0[0-9][0-9][0-9][0-9][0-9].{12})|3(?:6(?:[3-5][0-9][0-9][0-9][0-9].{40}|[7-9][0-9][0-9][0-9][0-9].{20}|[12][0-9][0-9][0-9][0-9].{32}|6[0-9][0-9][0-9][0-9].{84}|0[0-9][0-9][0-9][0-9].{8})|5(?:[1-35-9][0-9][0-9][0-9][0-9].{40}|0[0-9][0-9][0-9][0-9].{16}|4[0-9][0-9][0-9][0-9].{84})|3(?:[0-27-9][0-9][0-9][0-9][0-9].{24}|[3-6][0-9][0-9][0-9][0-9].{20})|4(?:[0-6][0-9][0-9][0-9][0-9].{24}|[7-9][0-9][0-9][0-9][0-9].{40})|9(?:[013-9][0-9][0-9][0-9][0-9].{20}|2[0-9][0-9][0-9][0-9].{16})|[0-2][0-9][0-9][0-9][0-9][0-9].{24}|8[0-9][0-9][0-9][0-9][0-9].{20}|7[0-9][0-9][0-9][0-9][0-9].{8})|1[0-9][0-9][0-9][0-9][0-9][0-9].{8})|4(?:8(?:6(?:[0135-9][0-9][0-9][0-9][0-9].{4}|[24][0-9][0-9][0-9][0-9].{64})|1(?:[0-57-9][0-9][0-9][0-9][0-9].{4}|6[0-9][0-9][0-9][0-9].{64})|[02-57-9][0-9][0-9][0-9][0-9][0-9].{4})|9(?:7(?:[0-46-9][0-9][0-9][0-9][0-9].{4}|5[0-9][0-9][0-9][0-9].{64})|[0-689][0-9][0-9][0-9][0-9][0-9].{4})|[0-7][0-9][0-9][0-9][0-9][0-9][0-9].{4})|(?:(?:(?:5[035-8]|3[049])|6[0149])[0-9][0-9]|(?:(?:9[01]|05)[0-9]|24[12])[0-9])[0-9][0-9][0-9][0-9].{4})|9(?:7(?:0(?:5(?:0[0-9][0-9][0-9][0-9].{144}|1[0-9][0-9][0-9][0-9].{896}|2[0-9][0-9][0-9][0-9].{800}|3[0-9][0-9][0-9][0-9].{824}|4[0-9][0-9][0-9][0-9].{336}|5[0-9][0-9][0-9][0-9].{552}|6[0-9][0-9][0-9][0-9].{756}|7[0-9][0-9][0-9][0-9].{188}|8[0-9][0-9][0-9][0-9].{420}|9[0-9][0-9][0-9][0-9].{400})|1(?:0[0-9][0-9][0-9][0-9].{308}|1[0-9][0-9][0-9][0-9].{120}|2[0-9][0-9][0-9][0-9].{576}|3[0-9][0-9][0-9][0-9].{500}|4[0-9][0-9][0-9][0-9].{448}|5[0-9][0-9][0-9][0-9].{144}|6[0-9][0-9][0-9][0-9].{376}|7[0-9][0-9][0-9][0-9].{176}|8[0-9][0-9][0-9][0-9].{196}|9[0-9][0-9][0-9][0-9].{60})|2(?:[78][0-9][0-9][0-9][0-9].{12}|0[0-9][0-9][0-9][0-9].{236}|1[0-9][0-9][0-9][0-9].{384}|2[0-9][0-9][0-9][0-9].{884}|3[0-9][0-9][0-9][0-9].{372}|4[0-9][0-9][0-9][0-9].{128}|5[0-9][0-9][0-9][0-9].{232}|6[0-9][0-9][0-9][0-9].{112}|9[0-9][0-9][0-9][0-9].{32})|7(?:[25][0-9][0-9][0-9][0-9].{116}|0[0-9][0-9][0-9][0-9].{104}|4[0-9][0-9][0-9][0-9].{472}|6[0-9][0-9][0-9][0-9].{940}|7[0-9][0-9][0-9][0-9].{108}|8[0-9][0-9][0-9][0-9].{268}|9[0-9][0-9][0-9][0-9].{956}|1[0-9][0-9][0-9][0-9].{60}|3[0-9][0-9][0-9][0-9].{88})|3(?:0[0-9][0-9][0-9][0-9].{212}|3[0-9][0-9][0-9][0-9].{268}|4[0-9][0-9][0-9][0-9].{200}|5[0-9][0-9][0-9][0-9].{540}|6[0-9][0-9][0-9][0-9].{360}|8[0-9][0-9][0-9][0-9].{196}|9[0-9][0-9][0-9][0-9].{768}|2[0-9][0-9][0-9][0-9].{32})|6(?:[0-3][0-9][0-9][0-9][0-9].{32}|4[0-9][0-9][0-9][0-9].{528}|5[0-9][0-9][0-9][0-9].{172}|7[0-9][0-9][0-9][0-9].{644}|8[0-9][0-9][0-9][0-9].{244}|9[0-9][0-9][0-9][0-9].{732}|6[0-9][0-9][0-9][0-9].{72})|0(?:[2-5][0-9][0-9][0-9][0-9].{288}|7[0-9][0-9][0-9][0-9].{816}|9[0-9][0-9][0-9][0-9].{360}|0[0-9][0-9][0-9][0-9].{64}|1[0-9][0-9][0-9][0-9].{36}|6[0-9][0-9][0-9][0-9].{32}|8[0-9][0-9][0-9][0-9].{4})|9[0-9][0-9][0-9][0-9][0-9].{16}|4[0-9][0-9][0-9][0-9][0-9].{12}|8[0-9][0-9][0-9][0-9][0-9].{8})|4(?:1(?:2[0-9][0-9][0-9][0-9].{432}|3[0-9][0-9][0-9][0-9].{704}|4[0-9][0-9][0-9][0-9].{472}|5[0-9][0-9][0-9][0-9].{412}|6[0-9][0-9][0-9][0-9].{572}|7[0-9][0-9][0-9][0-9].{908}|8[0-9][0-9][0-9][0-9].{320}|9[0-9][0-9][0-9][0-9].{116})|7(?:[467][0-9][0-9][0-9][0-9].{56}|[89][0-9][0-9][0-9][0-9].{8}|0[0-9][0-9][0-9][0-9].{472}|2[0-9][0-9][0-9][0-9].{668}|3[0-9][0-9][0-9][0-9].{332}|1[0-9][0-9][0-9][0-9].{84}|5[0-9][0-9][0-9][0-9].{52})|5(?:[0-245][0-9][0-9][0-9][0-9].{12}|6[0-9][0-9][0-9][0-9].{540}|7[0-9][0-9][0-9][0-9].{308}|9[0-9][0-9][0-9][0-9].{292}|3[0-9][0-9][0-9][0-9].{28})|6(?:[2356][0-9][0-9][0-9][0-9].{12}|[018][0-9][0-9][0-9][0-9].{8}|4[0-9][0-9][0-9][0-9].{332}|7[0-9][0-9][0-9][0-9].{532}|9[0-9][0-9][0-9][0-9].{4})|4(?:[0-6][0-9][0-9][0-9][0-9].{8}|7[0-9][0-9][0-9][0-9].{212}|9[0-9][0-9][0-9][0-9].{328}|8[0-9][0-9][0-9][0-9].{88})|8(?:[0-689][0-9][0-9][0-9][0-9].{8}|7[0-9][0-9][0-9][0-9].{452})|91[0-9][0-9][0-9][0-9].{176}|00[0-9][0-9][0-9][0-9].{12}|2[0-9][0-9][0-9][0-9][0-9].{8})|1(?:0(?:[45][0-9][0-9][0-9][0-9].{128}|[78][0-9][0-9][0-9][0-9].{292}|0[0-9][0-9][0-9][0-9].{172}|2[0-9][0-9][0-9][0-9].{976}|3[0-9][0-9][0-9][0-9].{428}|6[0-9][0-9][0-9][0-9].{984}|1[0-9][0-9][0-9][0-9].{12}|9[0-9][0-9][0-9][0-9].{72})|1(?:[12][0-9][0-9][0-9][0-9].{564}|[3-5][0-9][0-9][0-9][0-9].{12}|0[0-9][0-9][0-9][0-9].{120}|6[0-9][0-9][0-9][0-9].{116}|7[0-9][0-9][0-9][0-9].{968}|8[0-9][0-9][0-9][0-9].{588}|9[0-9][0-9][0-9][0-9].{728})|7(?:[5-9][0-9][0-9][0-9][0-9].{8}|1[0-9][0-9][0-9][0-9].{212}|4[0-9][0-9][0-9][0-9].{556}|0[0-9][0-9][0-9][0-9].{32}|2[0-9][0-9][0-9][0-9].{56}|3[0-9][0-9][0-9][0-9].{12})|5(?:[0-35-9][0-9][0-9][0-9][0-9].{4}|4[0-9][0-9][0-9][0-9].{904})|[2-46][0-9][0-9][0-9][0-9][0-9].{4}|[89][0-9][0-9][0-9][0-9][0-9].{8})|6(?:7(?:2[0-9][0-9][0-9][0-9].{132}|6[0-9][0-9][0-9][0-9].{332}|1[0-9][0-9][0-9][0-9].{40}|7[0-9][0-9][0-9][0-9].{52}|3[0-9][0-9][0-9][0-9].{4})|1(?:[023][0-9][0-9][0-9][0-9].{4}|1[0-9][0-9][0-9][0-9].{332}|8[0-9][0-9][0-9][0-9].{692}|7[0-9][0-9][0-9][0-9].{52})|4(?:0[0-9][0-9][0-9][0-9].{632}|1[0-9][0-9][0-9][0-9].{928}|7[0-9][0-9][0-9][0-9].{52})|0(?:[2-9][0-9][0-9][0-9][0-9].{4}|1[0-9][0-9][0-9][0-9].{132})|3(?:[1-3][0-9][0-9][0-9][0-9].{4}|7[0-9][0-9][0-9][0-9].{52})|2(?:2[0-9][0-9][0-9][0-9].{332}|7[0-9][0-9][0-9][0-9].{52})|(?:6[1-9]|5[0-2]|9[0-9])[0-9][0-9][0-9][0-9].{4})|8(?:0(?:[0-25][0-9][0-9][0-9][0-9].{4}|[34][0-9][0-9][0-9][0-9].{132}|6[0-9][0-9][0-9][0-9].{228}|7[0-9][0-9][0-9][0-9].{408}|8[0-9][0-9][0-9][0-9].{388}|9[0-9][0-9][0-9][0-9].{620})|3(?:5[0-9][0-9][0-9][0-9].{248}|6[0-9][0-9][0-9][0-9].{228}|7[0-9][0-9][0-9][0-9].{700}|9[0-9][0-9][0-9][0-9].{324}|8[0-9][0-9][0-9][0-9].{48})|2(?:[0-2][0-9][0-9][0-9][0-9].{16}|3[0-9][0-9][0-9][0-9].{504})|9(?:8[0-9][0-9][0-9][0-9].{216}|7[0-9][0-9][0-9][0-9].{52})|[156][0-9][0-9][0-9][0-9][0-9].{16}|4[0-2][0-9][0-9][0-9][0-9].{544}|7[0-9][0-9][0-9][0-9][0-9].{8})|7(?:4(?:[4-9][0-9][0-9][0-9][0-9].{4}|[0-3][0-9][0-9][0-9][0-9].{24})|7(?:[0-689][0-9][0-9][0-9][0-9].{4}|7[0-9][0-9][0-9][0-9].{156})|8(?:[0-79][0-9][0-9][0-9][0-9].{4}|8[0-9][0-9][0-9][0-9].{404})|5(?:[0-46-9][0-9][0-9][0-9][0-9].{4}|5[0-9][0-9][0-9][0-9].{88})|0(?:[02-9][0-9][0-9][0-9][0-9].{4}|1[0-9][0-9][0-9][0-9].{8})|(?:2[0-2]|1[0-9])[0-9][0-9][0-9][0-9].{12}|[369][0-9][0-9][0-9][0-9][0-9].{4})|3(?:7(?:0[0-9][0-9][0-9][0-9].{844}|1[0-9][0-9][0-9][0-9].{496}|3[0-9][0-9][0-9][0-9].{472}|4[0-9][0-9][0-9][0-9].{788}|2[0-9][0-9][0-9][0-9].{88})|3(?:[04][0-9][0-9][0-9][0-9].{332}|[12][0-9][0-9][0-9][0-9].{12}|3[0-9][0-9][0-9][0-9].{836})|8(?:[24-7][0-9][0-9][0-9][0-9].{12}|3[0-9][0-9][0-9][0-9].{864})|[1256][0-9][0-9][0-9][0-9][0-9].{16}|0[0-9][0-9][0-9][0-9][0-9].{44})|2(?:7(?:0[0-9][0-9][0-9][0-9].{312}|1[0-9][0-9][0-9][0-9].{856}|2[0-9][0-9][0-9][0-9].{52}|3[0-9][0-9][0-9][0-9].{56})|6(?:[0-6][0-9][0-9][0-9][0-9].{28}|[7-9][0-9][0-9][0-9][0-9].{12})|0(?:0[0-9][0-9][0-9][0-9].{120}|9[0-9][0-9][0-9][0-9].{84})|[1-5][0-9][0-9][0-9][0-9][0-9].{28}|8[0-9][0-9][0-9][0-9][0-9].{16}|9[0-9][0-9][0-9][0-9][0-9].{4})|5(?:1(?:[16][0-9][0-9][0-9][0-9].{652}|0[0-9][0-9][0-9][0-9].{792}|2[0-9][0-9][0-9][0-9].{228}|4[0-9][0-9][0-9][0-9].{188}|5[0-9][0-9][0-9][0-9].{204}|7[0-9][0-9][0-9][0-9].{108}|3[0-9][0-9][0-9][0-9].{28}|8[0-9][0-9][0-9][0-9].{88}|9[0-9][0-9][0-9][0-9].{84})|[2-9][0-9][0-9][0-9][0-9][0-9].{4}|0[0-9][0-9][0-9][0-9][0-9].{12})|9(?:9(?:[5-79][0-9][0-9][0-9][0-9].{12}|[0-2][0-9][0-9][0-9][0-9].{4}|3[0-9][0-9][0-9][0-9].{168}|8[0-9][0-9][0-9][0-9].{352}|4[0-9][0-9][0-9][0-9].{28})|[0-8][0-9][0-9][0-9][0-9][0-9].{4}))|8(?:0(?:0(?:0[0-9][0-9][0-9][0-9].{516}|1[0-9][0-9][0-9][0-9].{424}|9[0-9][0-9][0-9][0-9].{228}|8[0-9][0-9][0-9][0-9].{56})|3(?:[1-46-9][0-9][0-9][0-9][0-9].{16}|0[0-9][0-9][0-9][0-9].{640}|5[0-9][0-9][0-9][0-9].{724})|5(?:[1-9][0-9][0-9][0-9][0-9].{16}|0[0-9][0-9][0-9][0-9].{184})|6(?:[1-9][0-9][0-9][0-9][0-9].{16}|0[0-9][0-9][0-9][0-9].{204})|7(?:[1-9][0-9][0-9][0-9][0-9].{16}|0[0-9][0-9][0-9][0-9].{124})|8(?:[1-9][0-9][0-9][0-9][0-9].{16}|0[0-9][0-9][0-9][0-9].{104})|4(?:[1-9][0-9][0-9][0-9][0-9].{16}|0[0-9][0-9][0-9][0-9].{56})|9(?:[0-79][0-9][0-9][0-9][0-9].{16}|8[0-9][0-9][0-9][0-9].{52})|1[03][0-9][0-9][0-9][0-9].{516})|8(?:1(?:[89][0-9][0-9][0-9][0-9].{56}|0[0-9][0-9][0-9][0-9].{964}|1[0-9][0-9][0-9][0-9].{120})|2(?:[0-2][0-9][0-9][0-9][0-9].{52}|5[0-9][0-9][0-9][0-9].{892}|8[0-9][0-9][0-9][0-9].{56})|9(?:[08][0-9][0-9][0-9][0-9].{52}|9[0-9][0-9][0-9][0-9].{56})|6(?:[78][0-9][0-9][0-9][0-9].{8}|6[0-9][0-9][0-9][0-9].{56})|[03-5][0-9][0-9][0-9][0-9][0-9].{20}|77[0-9][0-9][0-9][0-9].{56}|8[0-9][0-9][0-9][0-9][0-9].{8})|7(?:6(?:6[0-9][0-9][0-9][0-9].{252}|5[0-9][0-9][0-9][0-9].{20}|7[0-9][0-9][0-9][0-9].{92})|8(?:[67][0-9][0-9][0-9][0-9].{136}|8[0-9][0-9][0-9][0-9].{56})|9(?:9[0-9][0-9][0-9][0-9].{600}|8[0-9][0-9][0-9][0-9].{52})|[013-57][0-9][0-9][0-9][0-9][0-9].{20}|27[0-9][0-9][0-9][0-9].{820})|5(?:5(?:[1-9][0-9][0-9][0-9][0-9].{16}|0[0-9][0-9][0-9][0-9].{440})|3(?:[1-46-9][0-9][0-9][0-9][0-9].{16}|5[0-9][0-9][0-9][0-9].{164})|9(?:[0-79][0-9][0-9][0-9][0-9].{16}|8[0-9][0-9][0-9][0-9].{52})|[46-8][1-9][0-9][0-9][0-9][0-9].{16})|2(?:1(?:[01][0-9][0-9][0-9][0-9].{32}|2[0-9][0-9][0-9][0-9].{56})|9(?:8[0-9][0-9][0-9][0-9].{204}|9[0-9][0-9][0-9][0-9].{60})|[2-7][0-9][0-9][0-9][0-9][0-9].{20}|05[0-9][0-9][0-9][0-9].{132}|82[0-9][0-9][0-9][0-9].{164})|6(?:8(?:6[0-9][0-9][0-9][0-9].{416}|7[0-9][0-9][0-9][0-9].{56})|[0-7][0-9][0-9][0-9][0-9][0-9].{20}|98[0-9][0-9][0-9][0-9].{52})|3(?:[02-9][0-9][0-9][0-9][0-9][0-9].{20}|10[0-9][0-9][0-9][0-9].{540})|4(?:[0-5][0-9][0-9][0-9][0-9][0-9].{16}|98[0-9][0-9][0-9][0-9].{52})|9[0-5][0-9][0-9][0-9][0-9][0-9].{16}|1[0-9][0-9][0-9][0-9][0-9][0-9].{20})|5[0-9][0-9][0-9][0-9][0-9][0-9][0-9].{16}|6[0-9][0-9][0-9][0-9][0-9][0-9][0-9].{4})|6(?:9(?:0(?:8(?:[0-6][0-9][0-9][0-9][0-9].{100}|7[0-9][0-9][0-9][0-9].{684}|8[0-9][0-9][0-9][0-9].{272}|9[0-9][0-9][0-9][0-9].{96})|0(?:[1-4][0-9][0-9][0-9][0-9].{508}|[6-9][0-9][0-9][0-9][0-9].{100}|[05][0-9][0-9][0-9][0-9].{96})|2(?:[013-5][0-9][0-9][0-9][0-9].{100}|[6-9][0-9][0-9][0-9][0-9].{76}|2[0-9][0-9][0-9][0-9].{272})|7(?:[0-6][0-9][0-9][0-9][0-9].{76}|[89][0-9][0-9][0-9][0-9].{96}|7[0-9][0-9][0-9][0-9].{272})|6(?:[0-578][0-9][0-9][0-9][0-9].{76}|6[0-9][0-9][0-9][0-9].{272}|9[0-9][0-9][0-9][0-9].{100})|4(?:[2-6][0-9][0-9][0-9][0-9].{100}|[017-9][0-9][0-9][0-9][0-9].{76})|1(?:[1-9][0-9][0-9][0-9][0-9].{100}|0[0-9][0-9][0-9][0-9].{684})|3(?:[0-57-9][0-9][0-9][0-9][0-9].{76}|6[0-9][0-9][0-9][0-9].{100})|5[0-9][0-9][0-9][0-9][0-9].{76}|9[0-9][0-9][0-9][0-9][0-9].{96})|3(?:6(?:[12][0-9][0-9][0-9][0-9].{708}|0[0-9][0-9][0-9][0-9].{160}|6[0-9][0-9][0-9][0-9].{4})|9(?:[0-39][0-9][0-9][0-9][0-9].{4}|[47][0-9][0-9][0-9][0-9].{80})|0(?:[1-4][0-9][0-9][0-9][0-9].{80}|[06][0-9][0-9][0-9][0-9].{4})|8(?:[0-3][0-9][0-9][0-9][0-9].{160}|8[0-9][0-9][0-9][0-9].{4})|3(?:[39][0-9][0-9][0-9][0-9].{4}|0[0-9][0-9][0-9][0-9].{160})|1(?:[03][0-9][0-9][0-9][0-9].{80}|1[0-9][0-9][0-9][0-9].{4})|2(?:[12][0-9][0-9][0-9][0-9].{4}|0[0-9][0-9][0-9][0-9].{80})|5(?:0[0-9][0-9][0-9][0-9].{160}|5[0-9][0-9][0-9][0-9].{4})|7(?:0[0-9][0-9][0-9][0-9].{160}|7[0-9][0-9][0-9][0-9].{4})|4[0-7][0-9][0-9][0-9][0-9].{160})|6(?:1(?:[016-9][0-9][0-9][0-9][0-9].{100}|[2-5][0-9][0-9][0-9][0-9].{512})|8(?:[0-6][0-9][0-9][0-9][0-9].{76}|[7-9][0-9][0-9][0-9][0-9].{96})|9(?:[0-8][0-9][0-9][0-9][0-9].{100}|9[0-9][0-9][0-9][0-9].{76})|5(?:[0-4][0-9][0-9][0-9][0-9].{100}|[56][0-9][0-9][0-9][0-9].{76})|(?:6[0-4]|0[0-9])[0-9][0-9][0-9][0-9].{96}|[2-4][0-9][0-9][0-9][0-9][0-9].{76}|7[0-9][0-9][0-9][0-9][0-9].{100})|4(?:1(?:[2-6][0-9][0-9][0-9][0-9].{100}|[01][0-9][0-9][0-9][0-9].{636}|[7-9][0-9][0-9][0-9][0-9].{96})|0(?:[0-7][0-9][0-9][0-9][0-9].{96}|[89][0-9][0-9][0-9][0-9].{100})|4(?:[0-589][0-9][0-9][0-9][0-9].{76}|[67][0-9][0-9][0-9][0-9].{96})|(?:3[0-48]|2[0-9])[0-9][0-9][0-9][0-9].{76}|9[0-9][0-9][0-9][0-9][0-9].{100})|2(?:9(?:[015-9][0-9][0-9][0-9][0-9].{80}|[2-4][0-9][0-9][0-9][0-9].{160})|4(?:[5-9][0-9][0-9][0-9][0-9].{80}|[0-4][0-9][0-9][0-9][0-9].{4})|0(?:[0-57-9][0-9][0-9][0-9][0-9].{4}|6[0-9][0-9][0-9][0-9].{80})|[15-8][0-9][0-9][0-9][0-9][0-9].{80}|[23][0-9][0-9][0-9][0-9][0-9].{4})|1(?:3(?:[1-5][0-9][0-9][0-9][0-9].{76}|0[0-9][0-9][0-9][0-9].{100})|2(?:2[0-9][0-9][0-9][0-9].{272}|9[0-9][0-9][0-9][0-9].{100}))|[89][0-9][0-9][0-9][0-9][0-9][0-9].{20}|5[0-9][0-9][0-9][0-9][0-9][0-9].{280}|727[0-9][0-9][0-9][0-9].{100})|3(?:9(?:0(?:[3-7][0-9][0-9][0-9][0-9].{160}|[0-2][0-9][0-9][0-9][0-9].{4}|9[0-9][0-9][0-9][0-9].{80})|9(?:[4-7][0-9][0-9][0-9][0-9].{160}|0[0-9][0-9][0-9][0-9].{104}|9[0-9][0-9][0-9][0-9].{4})|2(?:[0-57-9][0-9][0-9][0-9][0-9].{80}|6[0-9][0-9][0-9][0-9].{160})|6(?:[5-9][0-9][0-9][0-9][0-9].{80}|[0-4][0-9][0-9][0-9][0-9].{4})|7(?:[6-9][0-9][0-9][0-9][0-9].{4}|0[0-9][0-9][0-9][0-9].{104})|1(?:[01][0-9][0-9][0-9][0-9].{80}|9[0-9][0-9][0-9][0-9].{160})|3(?:0[0-9][0-9][0-9][0-9].{104}|9[0-9][0-9][0-9][0-9].{160})|50[0-9][0-9][0-9][0-9].{104}|40[0-9][0-9][0-9][0-9].{80})|8(?:0(?:[1-5][0-9][0-9][0-9][0-9].{220}|[7-9][0-9][0-9][0-9][0-9].{116}|0[0-9][0-9][0-9][0-9].{436})|[1-9][0-9][0-9][0-9][0-9][0-9].{4})|6(?:[5-9][0-9]|[0-4][0-9])[0-9][0-9][0-9][0-9].{68}|[0-37][0-9][0-9][0-9][0-9][0-9][0-9].{4}|[45][0-9][0-9][0-9][0-9][0-9][0-9].{8})|4(?:9(?:9(?:[467][0-9][0-9][0-9][0-9].{224}|[01][0-9][0-9][0-9][0-9].{156}|[58][0-9][0-9][0-9][0-9].{220}|[23][0-9][0-9][0-9][0-9].{4}|9[0-9][0-9][0-9][0-9].{168})|5(?:[1-9][0-9][0-9][0-9][0-9].{4}|0[0-9][0-9][0-9][0-9].{12})|[0-46-8][0-9][0-9][0-9][0-9][0-9].{4})|1(?:6(?:[6-9][0-9][0-9][0-9][0-9].{152}|[01][0-9][0-9][0-9][0-9].{68}|2[0-9][0-9][0-9][0-9].{316}|3[0-9][0-9][0-9][0-9].{932}|5[0-9][0-9][0-9][0-9].{224}|4[0-9][0-9][0-9][0-9].{44})|[0-589][0-9][0-9][0-9][0-9][0-9].{256}|7[0-9][0-9][0-9][0-9][0-9].{68})|0(?:0(?:[0-4][0-9][0-9][0-9][0-9].{436}|[5-9][0-9][0-9][0-9][0-9].{208})|[1-9][0-9][0-9][0-9][0-9][0-9].{4})|4(?:[07-9][0-9][0-9][0-9][0-9][0-9].{256}|[4-6][0-9][0-9][0-9][0-9][0-9].{380}|[1-3][0-9][0-9][0-9][0-9][0-9].{4})|[23578][0-9][0-9][0-9][0-9][0-9][0-9].{4}|6[0-9][0-9][0-9][0-9][0-9][0-9].{8})|0(?:2(?:[23][0-9][0-9][0-9][0-9][0-9].{284}|[45][0-9][0-9][0-9][0-9][0-9].{152}|[6-9][0-9][0-9][0-9][0-9][0-9].{8}|[01][0-9][0-9][0-9][0-9][0-9].{4})|4(?:[014][0-9][0-9][0-9][0-9][0-9].{284}|[5-9][0-9][0-9][0-9][0-9][0-9].{8}|[23][0-9][0-9][0-9][0-9][0-9].{224})|6(?:[0-3][0-9][0-9][0-9][0-9][0-9].{224}|[5-9][0-9][0-9][0-9][0-9][0-9].{68}|4[0-9][0-9][0-9][0-9][0-9].{284})|5(?:[5-9][0-9][0-9][0-9][0-9][0-9].{300}|[0-4][0-9][0-9][0-9][0-9][0-9].{68})|[139][0-9][0-9][0-9][0-9][0-9][0-9].{8}|[78][0-9][0-9][0-9][0-9][0-9][0-9].{4})|5(?:6(?:6(?:[02-5][0-9][0-9][0-9][0-9].{316}|[6-9][0-9][0-9][0-9][0-9].{220}|1[0-9][0-9][0-9][0-9].{740})|[0-59][0-9][0-9][0-9][0-9][0-9].{224}|[78][0-9][0-9][0-9][0-9][0-9].{256})|3(?:[5-9][0-9][0-9][0-9][0-9][0-9].{280}|[0-4][0-9][0-9][0-9][0-9][0-9].{20})|[089][0-9][0-9][0-9][0-9][0-9][0-9].{20}|[12][0-9][0-9][0-9][0-9][0-9][0-9].{280}|7[0-9][0-9][0-9][0-9][0-9][0-9].{224}|4[0-9][0-9][0-9][0-9][0-9][0-9].{4}|5[0-9][0-9][0-9][0-9][0-9][0-9].{8})|6(?:9(?:[0-79][0-9][0-9][0-9][0-9][0-9].{20}|8[0-9][0-9][0-9][0-9][0-9].{8})|[0-8][0-9][0-9][0-9][0-9][0-9][0-9].{20})|[12][0-9][0-9][0-9][0-9][0-9][0-9][0-9].{8}|[78][0-9][0-9][0-9][0-9][0-9][0-9][0-9].{4})|7(?:5(?:7(?:0(?:[1-5][0-9][0-9][0-9][0-9].{440}|0[0-9][0-9][0-9][0-9].{128}|7[0-9][0-9][0-9][0-9].{56})|5(?:[0-6][0-9][0-9][0-9][0-9].{208}|[78][0-9][0-9][0-9][0-9].{152})|7(?:7[0-9][0-9][0-9][0-9].{152}|9[0-9][0-9][0-9][0-9].{644})|(?:6[37]|87)[0-9][0-9][0-9][0-9].{152}|[23][0-9][0-9][0-9][0-9][0-9].{316}|9[0-9][0-9][0-9][0-9][0-9].{44}|4[0-9][0-9][0-9][0-9][0-9].{208}|17[0-9][0-9][0-9][0-9].{56})|0(?:7(?:[3-5][0-9][0-9][0-9][0-9].{116}|[12][0-9][0-9][0-9][0-9].{628}|0[0-9][0-9][0-9][0-9].{152})|6(?:[1-9][0-9][0-9][0-9][0-9].{4}|0[0-9][0-9][0-9][0-9].{152})|(?:5[0-378]|0[0-9])[0-9][0-9][0-9][0-9].{152}|[1-489][0-9][0-9][0-9][0-9][0-9].{8})|5(?:6(?:[0-4][0-9][0-9][0-9][0-9].{220}|[6-8][0-9][0-9][0-9][0-9].{152}|5[0-9][0-9][0-9][0-9].{128})|5(?:[0-4][0-9][0-9][0-9][0-9].{44}|[67][0-9][0-9][0-9][0-9].{156}|5[0-9][0-9][0-9][0-9].{152})|[0-47-9][0-9][0-9][0-9][0-9][0-9].{192})|4(?:3(?:0[0-9][0-9][0-9][0-9].{952}|2[0-9][0-9][0-9][0-9].{152}|1[0-9][0-9][0-9][0-9].{44})|[0-245][0-9][0-9][0-9][0-9][0-9].{192}|[89][0-9][0-9][0-9][0-9][0-9].{12}|6[0-9][0-9][0-9][0-9][0-9].{316}|7[0-9][0-9][0-9][0-9][0-9].{716})|2(?:0(?:[2-6][0-9][0-9][0-9][0-9].{220}|[01][0-9][0-9][0-9][0-9].{168})|[1-57-9][0-9][0-9][0-9][0-9][0-9].{192}|6[0-9][0-9][0-9][0-9][0-9].{8})|1(?:[0-5][0-9][0-9][0-9][0-9][0-9].{300}|[89][0-9][0-9][0-9][0-9][0-9].{192}|7[0-9][0-9][0-9][0-9][0-9].{12}|6[0-9][0-9][0-9][0-9][0-9].{8})|6(?:[0-4][0-9][0-9][0-9][0-9][0-9].{464}|[5-9][0-9][0-9][0-9][0-9][0-9].{380})|[38][0-9][0-9][0-9][0-9][0-9][0-9].{300}|9[0-9][0-9][0-9][0-9][0-9][0-9].{872})|7(?:1(?:5(?:[5-9][0-9][0-9][0-9][0-9].{68}|[0-4][0-9][0-9][0-9][0-9].{8})|(?:[0-26-8][0-9]|9[0-4])[0-9][0-9][0-9][0-9].{68}|[34][0-9][0-9][0-9][0-9][0-9].{8})|0(?:[5-9][0-9][0-9][0-9][0-9][0-9].{68}|[0-2][0-9][0-9][0-9][0-9][0-9].{4}|[34][0-9][0-9][0-9][0-9][0-9].{8})|5(?:[0-4][0-9][0-9][0-9][0-9][0-9].{8}|[56][0-9][0-9][0-9][0-9][0-9].{316})|[6-9][0-9][0-9][0-9][0-9][0-9][0-9].{8})|8(?:0(?:[0-6][0-9][0-9][0-9][0-9][0-9].{284}|[78][0-9][0-9][0-9][0-9][0-9].{192}|9[0-9][0-9][0-9][0-9][0-9].{348})|4(?:[0-5][0-9][0-9][0-9][0-9][0-9].{4}|[6-8][0-9][0-9][0-9][0-9][0-9].{256}|9[0-9][0-9][0-9][0-9][0-9].{68})|(?:(?:[59][0-9]|[78][0-9])[0-9]|6(?:[1-9][0-9]|0[0-9]))[0-9][0-9][0-9][0-9].{4}|[1-3][0-9][0-9][0-9][0-9][0-9][0-9].{280})|6(?:(?:0(?:[1-9][0-9]|0[0-9])|[1-5][0-9][0-9])[0-9][0-9][0-9][0-9].{20}|(?:[7-9][0-9]|69)[0-9][0-9][0-9][0-9][0-9].{280})|0000(?:2[0-9][0-9][0-9].{316}|4[0-9][0-9][0-9].{284}|3[0-9][0-9][0-9].{20}|0[0-9][0-9][0-9].{4}|1[0-9][0-9][0-9].{8})))/) {
        my $op = substr($1, -4);
        $op =~ s/ *$//;
        return $op;
    }
    return undef;
}

1; # vim:set ft=perl et sw=4 sts=4:
