# Before `make install' is performed this script should be runnable with
# `make test'. After `make install' it should work as `perl DBD-Pg-hstore.t'

#########################

use strict;
use warnings;
use Data::Dumper;

use constant HAS_LEAKTRACE => eval{ require Test::LeakTrace; Test::LeakTrace->import; 1; };
use Test::More HAS_LEAKTRACE ? (tests => 13) : (skip_all => 'require Test::LeakTrace');

BEGIN { use_ok('Pg::hstore') };

#########################

my @tests = (
	{
		win1251 => "\xc4\xee\xea\xee\xeb\xe5\x3f",
		binary  => "\x07\x03\xdb\xdb\x7a\xa7\xda\xad\x49\x94\xa0\x0a",
		tab     => "\t",
		"\t"    => "tab"
	},
	{
		null    => undef,
		russian => "Доколе?",
		"Доколе?"=>"russian",
		"spec" => "~!@#$%^&*()_+|-=\\/';\",.[]{}:<>?`"
	},
	{
		null    => undef
	},
	{
		"~!@#$%^&*()_+|-=\\/';\",.[]{}:<>?`" => "\x07\x03\xdb\xdb\x7a\xa7\xda\xad\x49\x94\xa0\x0a"
	}
);

foreach my $test (@tests) {
	my ($t1, $t2);
	no_leaks_ok (sub {
		$t1 = Pg::hstore::encode($test);
	}, 'encode no leaks');
	no_leaks_ok (sub {
		$t2 = Pg::hstore::decode($t1);
	}, 'decode no leaks');
	is_deeply($t2, $test, "Test struct $t1");
}

