Name:           perl-XAS
Version:        0.07
Release:        1%{?dist}
Summary:        XAS Perl module
License:        GPL+ or Artistic
Group:          Development/Libraries
URL:            http://search.cpan.org/dist/XAS/
Source0:        http://www.cpan.org/modules/by-module/XAS/XAS-%{version}.tar.gz
BuildRoot:      %{_tmppath}/%{name}-%{version}-%{release}-root-%(%{__id_u} -n)
BuildArch:      noarch
BuildRequires:  perl(Badger) >= 0.09
BuildRequires:  perl(Config::IniFiles) >= 2.72
BuildRequires:  perl(DateTime) >= 0.53
BuildRequires:  perl(DateTime::Format::Pg)
BuildRequires:  perl(DateTime::Format::Strptime) >= 1.1
BuildRequires:  perl(File::Pid)
BuildRequires:  perl(Hash::Merge) >= 0.12
BuildRequires:  perl(JSON::XS) >= 2.27
BuildRequires:  perl(LockFile::Simple) >= 0.207
BuildRequires:  perl(MIME::Lite) >= 3.027
BuildRequires:  perl(Module::Build)
BuildRequires:  perl(Params::Validate) >= 0.92
BuildRequires:  perl(POE) >= 1.35
BuildRequires:  perl(Test::More)
BuildRequires:  perl(Try::Tiny::Retry) >= 0.0
Requires:       perl(Badger) >= 0.09
Requires:       perl(Config::IniFiles) >= 2.72
Requires:       perl(DateTime) >= 0.53
Requires:       perl(DateTime::Format::Pg)
Requires:       perl(DateTime::Format::Strptime) >= 1.1
Requires:       perl(File::Pid)
Requires:       perl(Hash::Merge) >= 0.12
Requires:       perl(JSON::XS) >= 2.27
Requires:       perl(LockFile::Simple) >= 0.207
Requires:       perl(MIME::Lite) >= 3.027
Requires:       perl(Params::Validate) >= 0.92
Requires:       perl(POE) >= 1.35
Requires:       perl(Try::Tiny::Retry) >= 0.0
Requires:       perl(:MODULE_COMPAT_%(eval "`%{__perl} -V:version`"; echo $version))

# filter out Win32 stuff.

%{?filter_setup: %{?perl_default_filter} }
%filter_from_requires /Win32/d
%filter_setup

%description
This is middleware for Perl. It is cross platform capable.

%pre
getent group xas >/dev/null || groupadd -f -r xas
if ! getent passwd xas >/dev/null ; then
    useradd -r -g xas -d /var/lib/xas -s /sbin/nologin -c "XAS" xas
fi
exit 0

%prep
%setup -q -n XAS-%{version}

%build
%{__perl} Build.PL installdirs=site
./Build

%install
rm -rf $RPM_BUILD_ROOT

install -m 755 -d %{buildroot}/etc/xas
install -m 755 -d %{buildroot}/var/lib/xas
install -m 775 -d %{buildroot}/var/run/xas
install -m 775 -d %{buildroot}/var/log/xas
install -m 755 -d %{buildroot}/var/spool/xas
install -m 755 -d %{buildroot}/var/spool/xas/alerts
install -m 755 -d %{buildroot}/var/spool/xas/logstash

./Build install destdir=$RPM_BUILD_ROOT create_packlist=0
find $RPM_BUILD_ROOT -depth -type d -exec rmdir {} 2>/dev/null \;

%{_fixperms} $RPM_BUILD_ROOT/*

%check
./Build test

%post
chown -R root.xas /etc/xas
chown -R xas.xas  /var/lib/xas
chown -R xas.xas  /var/log/xas
chown -R xas.xas  /var/run/xas
chown -R xas.xas  /var/spool/xas

chmod g+s /var/lib/xas
chmod g+s /var/run/xas
chmod g+s /var/log/xas
chmod g+s /var/spool/xas
chmod g+s /var/spool/xas/alerts
chmod g+s /var/spool/xas/logstash

%postun
if [ "$1" = 0 ]; then
    rm -Rf /etc/xas
    rm -Rf /var/lib/xas
    rm -Rf /var/run/xas
    rm -Rf /var/log/xas
    rm -Rf /var/spool/xas
fi

%clean
rm -rf $RPM_BUILD_ROOT

%files
%defattr(-,root,root,-)
%doc Changes perl-XAS.spec README
%{perl_sitelib}/*
/usr/local/share/man/man3/*
/etc/profile.d/*

%changelog
* Tue Sep 24 2013 kesteb 0.07-1
- Specfile autogenerated by cpanspec 1.78.
