## -*- Mode: CPerl -*-
##
## File: DTA::CAB::Format::Null.pm
## Author: Bryan Jurish <moocow@cpan.org>
## Description: Datum parser|formatter: null formatter

package DTA::CAB::Format::Null;
use DTA::CAB::Format;
use DTA::CAB::Datum ':all';
use Carp;
use strict;

##==============================================================================
## Globals
##==============================================================================

our @ISA = qw(DTA::CAB::Format);

BEGIN {
  #DTA::CAB::Format->registerFormat(name=>__PACKAGE__, filenameRegex=>qr/\.(?i:prl|pl|perl|dump)$/);
  DTA::CAB::Format->registerFormat(name=>__PACKAGE__);
}

##==============================================================================
## Constructors etc.
##==============================================================================

## $fmt = CLASS_OR_OBJ->new(%args)
##  + object structure: assumed HASH
##    (
##     ##---- INHERITED from DTA::CAB::Format
##    )
sub new {
  my $that = shift;
  my $fmt = bless({
		   ##-- I/O common
		   utf8 => undef,

		   ##-- user args
		   @_
		  }, ref($that)||$that);
  return $fmt;
}

##==============================================================================
## Methods: Persistence
##==============================================================================

## @keys = $class_or_obj->noSaveKeys()
##  + returns list of keys not to be saved


##==============================================================================
## Methods: Input
##==============================================================================

##--------------------------------------------------------------
## Methods: Input: Generic API

## $doc = $fmt->parseDocument()
sub parseDocument { return DTA::CAB::Document->new; }


##==============================================================================
## Methods: Output
##==============================================================================

##--------------------------------------------------------------
## Methods: Output: Generic

## $type = $fmt->mimeType()
##  + default returns text/plain
sub mimeType { return 'text/plain'; }

## $ext = $fmt->defaultExtension()
##  + returns default filename extension for this format
sub defaultExtension { return '.null'; }

##--------------------------------------------------------------
## Methods: Output: API

## $fmt_or_undef = $fmt->toFh($fh,$formatLevel)
##  + flush buffered output document to filehandle $fh
##  + default implementation calls to $fmt->formatString($formatLevel)
sub toFh {
  return $_[0];
}

##--------------------------------------------------------------
## Methods: Output: Generic API

## $fmt = $fmt->putToken($tok)
sub putToken { return $_[0]; }

## $fmt = $fmt->putSentence($sent)
sub putSentence { return $_[0]; }

## $fmt = $fmt->putDocument($doc)
sub putDocument { return $_[0]; }


1; ##-- be happy

__END__
##========================================================================
## POD DOCUMENTATION, auto-generated by podextract.perl, edited

##========================================================================
## NAME
=pod

=head1 NAME

DTA::CAB::Format::Null - Datum parser|formatter (dummy)

=cut

##========================================================================
## SYNOPSIS
=pod

=head1 SYNOPSIS

 use DTA::CAB::Format::Null;
 
 ##========================================================================
 ## Methods
 
 $fmt = DTA::CAB::Format::Null->new(%args);
 $doc = $fmt->parseDocument();
 $type = $fmt->mimeType();
 $ext = $fmt->defaultExtension();
 $str = $fmt->toString();
 $fmt = $fmt->putToken($tok);
 $fmt = $fmt->putSentence($sent);
 $fmt = $fmt->putDocument($doc);
 

=cut

##========================================================================
## DESCRIPTION
=pod

=head1 DESCRIPTION

DTA::CAB::Format::Null is a
L<DTA::CAB::Format|DTA::CAB::Format>
subclass which doesn't actually perform
any I/O operations at all, but can be useful for testing and debugging.

=cut

##----------------------------------------------------------------
## DESCRIPTION: DTA::CAB::Format::Null: Constructors etc.
=pod

=head2 Methods

=over 4

=item new

 $fmt = CLASS_OR_OBJ->new(%args);

=item fromString

 $fmt = $fmt->fromString($string)

Really just calls $fmt-E<gt>close().

=item parseDocument

 $doc = $fmt->parseDocument();

Returns a new (empty) L<DTA::CAB::Document|DTA::CAB::Document>.

=item mimeType

 $type = $fmt->mimeType();

Default returns text/plain.

=item defaultExtension

 $ext = $fmt->defaultExtension();

Returns default filename extension for this format, here '.null'.

=item toString

 $str = $fmt->toString();
 $str = $fmt->toString($formatLevel);

Just returns an empty string.

=item putToken

 $fmt = $fmt->putToken($tok);

Does nothing.

=item putSentence

 $fmt = $fmt->putSentence($sent);

Does nothing.

=item putDocument

 $fmt = $fmt->putDocument($doc);

Does nothing.

=back

=cut

##========================================================================
## END POD DOCUMENTATION, auto-generated by podextract.perl

##======================================================================
## Footer
##======================================================================
=pod

=head1 AUTHOR

Bryan Jurish E<lt>moocow@cpan.orgE<gt>

=head1 COPYRIGHT AND LICENSE

Copyright (C) 2010-2019 by Bryan Jurish

This package is free software; you can redistribute it and/or modify
it under the same terms as Perl itself, either Perl version 5.24.1 or,
at your option, any later version of Perl 5 you may have available.

=head1 SEE ALSO

L<dta-cab-convert.perl(1)|dta-cab-convert.perl>,
L<DTA::CAB::Format(3pm)|DTA::CAB::Format>,
L<DTA::CAB::Format::Builtin(3pm)|DTA::CAB::Builtin>,
L<DTA::CAB(3pm)|DTA::CAB>,
L<perl(1)|perl>,
...


=cut
