#!/usr/bin/perl

package eBay::API::XML::DataType::AffiliateTrackingDetailsType;

use strict;
use warnings;  

##########################################################################
#
# Module: ............... <user defined location>eBay/API/XML
# File: ................. AffiliateTrackingDetailsType.pm
# Generated by: ......... genEBayApiDataTypes.pl
# Last Generated: ....... 08/24/2008 16:44
# API Release Number: ... 579
#
##########################################################################  

=head1 NAME

eBay::API::XML::DataType::AffiliateTrackingDetailsType

=head1 DESCRIPTION

Container for fields related to affiliate tracking. For additional information,
see the annotations to the elements in this type.



=head1 SYNOPSIS

=cut


=head1 INHERITANCE

eBay::API::XML::DataType::AffiliateTrackingDetailsType inherits from the L<eBay::API::XML::BaseDataType> class

=cut

use eBay::API::XML::BaseDataType;
our @ISA = ("eBay::API::XML::BaseDataType");

use eBay::API::XML::DataType::Enum::ApplicationDeviceTypeCodeType;


my @gaProperties = ( [ 'AffiliateUserID', 'xs:string', '', '', '' ]
	, [ 'ApplicationDeviceType', 'ns:ApplicationDeviceTypeCodeType', ''
	     ,'eBay::API::XML::DataType::Enum::ApplicationDeviceTypeCodeType', '' ]
	, [ 'TrackingID', 'xs:string', '', '', '' ]
	, [ 'TrackingPartnerCode', 'xs:string', '', '', '' ]
                    );
push @gaProperties, @{eBay::API::XML::BaseDataType::getPropertiesList()};

my @gaAttributes = ( 
                    );
push @gaAttributes, @{eBay::API::XML::BaseDataType::getAttributesList()};

=head1 Subroutines:

=cut

sub new {
  my $classname = shift;
  my %args = @_;
  my $self = $classname->SUPER::new(%args);
  return $self;
}

sub isScalar {
   return 0; 
}



=head2 setAffiliateUserID()

Need not be specified. You can define an AffiliateUserID 
(up to 256 characters) if you want to leverage it to better monitor
your marketing efforts.
If you are using the eBay Partner Network,
and you provide an AffiliateUserID, the tracking URL returned
by eBay Partner Network will contain the AffiliateUserID, but it 
will be referred to as a "customid".

  Calls: GetProducts
         GetSearchResults
         PlaceOffer
  RequiredInput: Conditionally

#    Argument: 'xs:string'

=cut

sub setAffiliateUserID {
  my $self = shift;
  $self->{'AffiliateUserID'} = shift
}

=head2 getAffiliateUserID()

#    Returns: 'xs:string'

=cut

sub getAffiliateUserID {
  my $self = shift;
  return $self->{'AffiliateUserID'};
}


=head2 setApplicationDeviceType()

Type of device from which the call originated. For PlaceOffer, if you are using
affiliate tracking, this field is required as part of the set of tags you
use in the AffiliateTrackingDetails container.

  Calls: PlaceOffer
  RequiredInput: Conditionally

#    Argument: 'ns:ApplicationDeviceTypeCodeType'

=cut

sub setApplicationDeviceType {
  my $self = shift;
  $self->{'ApplicationDeviceType'} = shift
}

=head2 getApplicationDeviceType()

#    Returns: 'ns:ApplicationDeviceTypeCodeType'

=cut

sub getApplicationDeviceType {
  my $self = shift;
  return $self->{'ApplicationDeviceType'};
}


=head2 setTrackingID()

The value you specify is obtained from your tracking partner.
For eBay Partner Network, the TrackingID is the Campaign ID ("campid")
provided by eBay Partner Network. A Campaign ID is a 9-digit, unique
number to be used for associating traffic. A Campaign ID is valid across all
programs to which you have been accepted. 
Another example is the Affiliate ID given to you by TradeDoubler.

  Calls: GetProducts
         GetSearchResults
         PlaceOffer
  RequiredInput: Conditionally

#    Argument: 'xs:string'

=cut

sub setTrackingID {
  my $self = shift;
  $self->{'TrackingID'} = shift
}

=head2 getTrackingID()

#    Returns: 'xs:string'

=cut

sub getTrackingID {
  my $self = shift;
  return $self->{'TrackingID'};
}


=head2 setTrackingPartnerCode()

Specifies your tracking partner for affiliate commissions.
Affiliates earn money from eBay for driving traffic to eBay.
Required if you specify a TrackingID.
Depending on your tracking partner, specify one of the
following values. Not all partners are valid for all sites. 
For PlaceOffer, only eBay Partner Network and Mediaplex are valid:
<br>
<br>2 = Be Free
<br>3 = Affilinet
<br>4 = TradeDoubler
<br>5 = Mediaplex
<br>6 = DoubleClick
<br>7 = Allyes
<br>8 = BJMT
<br>9 = eBay Partner Network
<br>
<br>
For information about the eBay Partner Network, see 
<a href="https://www.ebaypartnernetwork.com" target="_blank">eBay Partner Network</a>.

SeeLink: URL: http://developer.ebay.com/DevZone/XML/docs/WebHelp/index.htm?context=eBay_XML_API&topic=AffiliateTrackingConcepts
Title: Affiliate Tracking Concepts

  Calls: GetProducts
         GetSearchResults
         PlaceOffer
  RequiredInput: Conditionally

#    Argument: 'xs:string'

=cut

sub setTrackingPartnerCode {
  my $self = shift;
  $self->{'TrackingPartnerCode'} = shift
}

=head2 getTrackingPartnerCode()

#    Returns: 'xs:string'

=cut

sub getTrackingPartnerCode {
  my $self = shift;
  return $self->{'TrackingPartnerCode'};
}





##  Attribute and Property lists
sub getPropertiesList {
   my $self = shift;
   return \@gaProperties;
}

sub getAttributesList {
   my $self = shift;
   return \@gaAttributes;
}



1;   
