/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.metadata.iso.distribution;

import java.util.Collection;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.XmlType;
import org.apache.sis.internal.metadata.Dependencies;
import org.apache.sis.internal.metadata.LegacyPropertyAdapter;
import org.apache.sis.internal.metadata.MetadataUtilities;
import org.apache.sis.measure.ValueRange;
import org.apache.sis.metadata.iso.ISOMetadata;
import org.opengis.annotation.Obligation;
import org.opengis.annotation.Specification;
import org.opengis.annotation.UML;
import org.opengis.metadata.citation.OnlineResource;
import org.opengis.metadata.distribution.DigitalTransferOptions;
import org.opengis.metadata.distribution.Format;
import org.opengis.metadata.distribution.Medium;
import org.opengis.temporal.PeriodDuration;
import org.opengis.util.InternationalString;

@XmlType(name="MD_DigitalTransferOptions_Type", propOrder={"unitsOfDistribution", "transferSize", "onLines", "offLine"})
@XmlRootElement(name="MD_DigitalTransferOptions")
public class DefaultDigitalTransferOptions
extends ISOMetadata
implements DigitalTransferOptions {
    private static final long serialVersionUID = -2901375920581273330L;
    private InternationalString unitsOfDistribution;
    private Double transferSize;
    private Collection<OnlineResource> onLines;
    private Collection<Medium> offLines;
    private PeriodDuration transferFrequency;
    private Collection<Format> distributionFormats;

    public DefaultDigitalTransferOptions() {
    }

    public DefaultDigitalTransferOptions(DigitalTransferOptions digitalTransferOptions) {
        super(digitalTransferOptions);
        if (digitalTransferOptions != null) {
            this.unitsOfDistribution = digitalTransferOptions.getUnitsOfDistribution();
            this.transferSize = digitalTransferOptions.getTransferSize();
            this.onLines = this.copyCollection(digitalTransferOptions.getOnLines(), OnlineResource.class);
            if (digitalTransferOptions instanceof DefaultDigitalTransferOptions) {
                DefaultDigitalTransferOptions defaultDigitalTransferOptions = (DefaultDigitalTransferOptions)digitalTransferOptions;
                this.offLines = this.copyCollection(defaultDigitalTransferOptions.getOffLines(), Medium.class);
                this.transferFrequency = defaultDigitalTransferOptions.getTransferFrequency();
                this.distributionFormats = this.copyCollection(defaultDigitalTransferOptions.getDistributionFormats(), Format.class);
            } else {
                this.offLines = this.singleton(digitalTransferOptions.getOffLine(), Medium.class);
            }
        }
    }

    public static DefaultDigitalTransferOptions castOrCopy(DigitalTransferOptions digitalTransferOptions) {
        if (digitalTransferOptions == null || digitalTransferOptions instanceof DefaultDigitalTransferOptions) {
            return (DefaultDigitalTransferOptions)digitalTransferOptions;
        }
        return new DefaultDigitalTransferOptions(digitalTransferOptions);
    }

    @Override
    @XmlElement(name="unitsOfDistribution")
    public InternationalString getUnitsOfDistribution() {
        return this.unitsOfDistribution;
    }

    public void setUnitsOfDistribution(InternationalString internationalString) {
        this.checkWritePermission();
        this.unitsOfDistribution = internationalString;
    }

    @Override
    @XmlElement(name="transferSize")
    @ValueRange(minimum=0.0, isMinIncluded=false)
    public Double getTransferSize() {
        return this.transferSize;
    }

    public void setTransferSize(Double d) {
        this.checkWritePermission();
        if (MetadataUtilities.ensurePositive(DefaultDigitalTransferOptions.class, "transferSize", true, d)) {
            this.transferSize = d;
        }
    }

    @XmlElement(name="onLine")
    public Collection<OnlineResource> getOnLines() {
        this.onLines = this.nonNullCollection(this.onLines, OnlineResource.class);
        return this.onLines;
    }

    public void setOnLines(Collection<? extends OnlineResource> collection) {
        this.onLines = this.writeCollection(collection, this.onLines, OnlineResource.class);
    }

    @UML(identifier="offLine", obligation=Obligation.OPTIONAL, specification=Specification.ISO_19115)
    public Collection<Medium> getOffLines() {
        this.offLines = this.nonNullCollection(this.offLines, Medium.class);
        return this.offLines;
    }

    public void setOffLines(Collection<? extends Medium> collection) {
        this.offLines = this.writeCollection(collection, this.offLines, Medium.class);
    }

    @Override
    @Deprecated
    @XmlElement(name="offLine")
    @Dependencies(value={"getOffLines"})
    public Medium getOffLine() {
        return LegacyPropertyAdapter.getSingleton(this.getOffLines(), Medium.class, null, DefaultDigitalTransferOptions.class, "getOffLine");
    }

    @Deprecated
    public void setOffLine(Medium medium) {
        this.setOffLines(LegacyPropertyAdapter.asCollection(medium));
    }

    @UML(identifier="transferFrequency", obligation=Obligation.OPTIONAL, specification=Specification.ISO_19115)
    public PeriodDuration getTransferFrequency() {
        return this.transferFrequency;
    }

    public void setTransferFrequency(PeriodDuration periodDuration) {
        this.checkWritePermission();
        this.transferFrequency = periodDuration;
    }

    @UML(identifier="distributionFormat", obligation=Obligation.OPTIONAL, specification=Specification.ISO_19115)
    public Collection<Format> getDistributionFormats() {
        this.distributionFormats = this.nonNullCollection(this.distributionFormats, Format.class);
        return this.distributionFormats;
    }

    public void setDistributionFormats(Collection<? extends Format> collection) {
        this.distributionFormats = this.writeCollection(collection, this.distributionFormats, Format.class);
    }
}

