/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.javaocr.ocrPlugins;

import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.image.BufferedImage;
import java.io.File;
import java.io.IOException;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.imageio.ImageIO;
import net.sourceforge.javaocr.scanner.DocumentScanner;
import net.sourceforge.javaocr.scanner.DocumentScannerListenerAdaptor;
import net.sourceforge.javaocr.scanner.PixelImage;

public class CharacterTracer
extends DocumentScannerListenerAdaptor {
    private DocumentScanner documentScanner = new DocumentScanner();
    private BufferedImage bfImage;
    private Graphics2D bfImageGraphics;
    private static final Logger LOG = Logger.getLogger(CharacterTracer.class.getName());

    public BufferedImage getTracedImage(File inputImage) {
        try {
            this.bfImage = ImageIO.read(inputImage);
            this.bfImageGraphics = this.bfImage.createGraphics();
            BufferedImage img = ImageIO.read(inputImage);
            PixelImage pixelImage = new PixelImage(img);
            pixelImage.toGrayScale(true);
            pixelImage.filter();
            this.documentScanner.scan(pixelImage, this, 0, 0, pixelImage.width, pixelImage.height);
        }
        catch (IOException ex) {
            LOG.log(Level.SEVERE, null, ex);
        }
        this.bfImageGraphics.dispose();
        return this.bfImage;
    }

    public void processChar(PixelImage pixelImage, int x1, int y1, int x2, int y2, int rowY1, int rowY2) {
        try {
            this.bfImageGraphics.setStroke(new BasicStroke(4.0f));
            this.bfImageGraphics.setColor(Color.red);
            this.bfImageGraphics.drawRect(x1, y1, x2 - x1, y2 - y1);
        }
        catch (Exception ex) {
            LOG.log(Level.SEVERE, null, ex);
        }
    }

    public void processSpace(PixelImage pixelImage, int x1, int y1, int x2, int y2) {
        try {
            this.bfImageGraphics.setStroke(new BasicStroke(4.0f));
            this.bfImageGraphics.setColor(Color.yellow);
            this.bfImageGraphics.drawRect(x1, y1, x2 - x1, y2 - y1);
        }
        catch (Exception ex) {
            LOG.log(Level.SEVERE, null, ex);
        }
    }
}

