use strict;
use Test::More;
use xt::CLI;

{
    my $app = cli();

    $app->dir->child("cpanfile")->spew(<<EOF);
requires 'Try::Tiny', '== 0.11';
EOF

    $app->run("install");
    $app->run("list");
    like $app->stdout, qr/Try-Tiny-0\.11/;

    $app->clean_local;

    $app->run("install");
    $app->run("list");
    like $app->stdout, qr/Try-Tiny-0\.11/;
}

done_testing;

