# This Makefile.PL for X11-GLX was generated by
# Dist::Zilla::Plugin::MakeMaker::Awesome 0.38.
# Don't edit it but the dist.ini and plugins used to construct it.

use strict;
use warnings;

use ExtUtils::MakeMaker;

our %PREREQ_PM;
BEGIN {
    %PREREQ_PM= (
        'ExtUtils::Depends' => '0.405',
        'Devel::CheckLib'   => '1.03',
        'X11::Xlib'         => '0.15',
    );

    # If the prereqs for this script are missing,
    # write out a Makefile that tells CPAN to install them
    my $use_prereqs_code= join('', map { "use $_ '$PREREQ_PM{$_}'; " } keys %PREREQ_PM).'1;';
    print $use_prereqs_code."\n";
    unless (eval $use_prereqs_code) {
       warn "$@\n";
       WriteMakefile(
             NAME         => 'X11::GLX',
             PREREQ_FATAL => 1,
             PREREQ_PM    => \%PREREQ_PM,
       );
       exit 1; # not reached
    }
}

my $dep= ExtUtils::Depends->new('X11::GLX', 'X11::Xlib');

$dep->set_libs('-lGL');
$dep->add_xs('GLX.xs');
$dep->add_pm(map { my $n= $_; $n =~ s/^lib/\$(INST_LIB)/; $_ => $n } <lib/*/*.pm>, <lib/*/*/*.pm>);
$dep->add_typemaps('typemap');

my %WriteMakefileArgs = (
  "ABSTRACT" => "X11 OpenGL API, and DWIM utility object",
  "AUTHOR" => "Michael Conrad <mike\@nrdvana.net>",
  "CONFIGURE_REQUIRES" => {
    "Devel::CheckLib" => "1.03",
    "ExtUtils::Depends" => "0.405",
    "ExtUtils::MakeMaker" => 0,
    "X11::Xlib" => "0.15"
  },
  "DISTNAME" => "X11-GLX",
  "LICENSE" => "perl",
  "NAME" => "X11::GLX",
  "PREREQ_PM" => {
    "Carp" => 0,
    "Exporter" => 0,
    "Log::Any" => 0,
    "Moo" => 2,
    "Scalar::Util" => 0,
    "X11::Xlib" => "0.11",
    "X11::Xlib::Opaque" => 0,
    "X11::Xlib::Pixmap" => 0,
    "XSLoader" => 0,
    "parent" => 0,
    "strict" => 0,
    "warnings" => 0
  },
  "TEST_REQUIRES" => {
    "FindBin" => 0,
    "Log::Any::Adapter" => 0,
    "Log::Any::Adapter::TAP" => 0,
    "OpenGL" => 0,
    "POSIX" => 0,
    "Test::More" => 0,
    "Try::Tiny" => 0,
    "lib" => 0
  },
  "VERSION" => "0.05",
  "test" => {
    "TESTS" => "t/*.t"
  }
);

%WriteMakefileArgs = (
    %WriteMakefileArgs,
    $dep->get_makefile_vars,
);

my %FallbackPrereqs = (
  "Carp" => 0,
  "Exporter" => 0,
  "FindBin" => 0,
  "Log::Any" => 0,
  "Log::Any::Adapter" => 0,
  "Log::Any::Adapter::TAP" => 0,
  "Moo" => 2,
  "OpenGL" => 0,
  "POSIX" => 0,
  "Scalar::Util" => 0,
  "Test::More" => 0,
  "Try::Tiny" => 0,
  "X11::Xlib" => "0.11",
  "X11::Xlib::Opaque" => 0,
  "X11::Xlib::Pixmap" => 0,
  "XSLoader" => 0,
  "lib" => 0,
  "parent" => 0,
  "strict" => 0,
  "warnings" => 0
);

unless ( eval { ExtUtils::MakeMaker->VERSION(6.63_03) } ) {
  delete $WriteMakefileArgs{TEST_REQUIRES};
  delete $WriteMakefileArgs{BUILD_REQUIRES};
  $WriteMakefileArgs{PREREQ_PM} = \%FallbackPrereqs;
}

delete $WriteMakefileArgs{CONFIGURE_REQUIRES}
  unless eval { ExtUtils::MakeMaker->VERSION(6.52) };

WriteMakefile(%WriteMakefileArgs);
