# automatically generated file, don't edit



# Copyright 2011 David Cantrell, derived from data from libphonenumber
# http://code.google.com/p/libphonenumber/
#
# Licensed under the Apache License, Version 2.0 (the "License");
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
#     http://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.
package Number::Phone::StubCountry::DE;
use base qw(Number::Phone::StubCountry);

use strict;
use warnings;
use utf8;
our $VERSION = 1.20220307120116;

my $formatters = [
                {
                  'format' => '$1 $2',
                  'leading_digits' => '
            3[02]|
            40|
            [68]9
          ',
                  'national_rule' => '0$1',
                  'pattern' => '(\\d{2})(\\d{3,13})'
                },
                {
                  'format' => '$1 $2',
                  'leading_digits' => '
            2(?:
              0[1-389]|
              12[0-8]
            )|
            3(?:
              [35-9][15]|
              4[015]
            )|
            906|
            2(?:
              [13][14]|
              2[18]
            )|
            (?:
              2[4-9]|
              4[2-9]|
              [579][1-9]|
              [68][1-8]
            )1
          ',
                  'national_rule' => '0$1',
                  'pattern' => '(\\d{3})(\\d{3,12})'
                },
                {
                  'format' => '$1 $2',
                  'leading_digits' => '
            [24-6]|
            3(?:
              3(?:
                0[1-467]|
                2[127-9]|
                3[124578]|
                7[1257-9]|
                8[1256]|
                9[145]
              )|
              4(?:
                2[135]|
                4[13578]|
                9[1346]
              )|
              5(?:
                0[14]|
                2[1-3589]|
                6[1-4]|
                7[13468]|
                8[13568]
              )|
              6(?:
                2[1-489]|
                3[124-6]|
                6[13]|
                7[12579]|
                8[1-356]|
                9[135]
              )|
              7(?:
                2[1-7]|
                4[145]|
                6[1-5]|
                7[1-4]
              )|
              8(?:
                21|
                3[1468]|
                6|
                7[1467]|
                8[136]
              )|
              9(?:
                0[12479]|
                2[1358]|
                4[134679]|
                6[1-9]|
                7[136]|
                8[147]|
                9[1468]
              )
            )|
            70[2-8]|
            8(?:
              0[2-9]|
              [1-8]
            )|
            90[7-9]|
            [79][1-9]|
            3[68]4[1347]|
            3(?:
              47|
              60
            )[1356]|
            3(?:
              3[46]|
              46|
              5[49]
            )[1246]|
            3[4579]3[1357]
          ',
                  'national_rule' => '0$1',
                  'pattern' => '(\\d{4})(\\d{2,11})'
                },
                {
                  'format' => '$1 $2',
                  'leading_digits' => '138',
                  'national_rule' => '0$1',
                  'pattern' => '(\\d{3})(\\d{4})'
                },
                {
                  'format' => '$1 $2',
                  'leading_digits' => '3',
                  'national_rule' => '0$1',
                  'pattern' => '(\\d{5})(\\d{2,10})'
                },
                {
                  'format' => '$1 $2',
                  'leading_digits' => '181',
                  'national_rule' => '0$1',
                  'pattern' => '(\\d{3})(\\d{5,11})'
                },
                {
                  'format' => '$1 $2 $3',
                  'leading_digits' => '
            1(?:
              3|
              80
            )|
            9
          ',
                  'national_rule' => '0$1',
                  'pattern' => '(\\d{3})(\\d)(\\d{4,10})'
                },
                {
                  'format' => '$1 $2',
                  'leading_digits' => '1[67]',
                  'national_rule' => '0$1',
                  'pattern' => '(\\d{3})(\\d{7,8})'
                },
                {
                  'format' => '$1 $2',
                  'leading_digits' => '8',
                  'national_rule' => '0$1',
                  'pattern' => '(\\d{3})(\\d{7,12})'
                },
                {
                  'format' => '$1 $2',
                  'leading_digits' => '18500',
                  'national_rule' => '0$1',
                  'pattern' => '(\\d{5})(\\d{6})'
                },
                {
                  'format' => '$1 $2 $3',
                  'leading_digits' => '7',
                  'national_rule' => '0$1',
                  'pattern' => '(\\d{3})(\\d{4})(\\d{4})'
                },
                {
                  'format' => '$1 $2',
                  'leading_digits' => '18[68]',
                  'national_rule' => '0$1',
                  'pattern' => '(\\d{4})(\\d{7})'
                },
                {
                  'format' => '$1 $2',
                  'leading_digits' => '15[0568]',
                  'national_rule' => '0$1',
                  'pattern' => '(\\d{5})(\\d{6})'
                },
                {
                  'format' => '$1 $2',
                  'leading_digits' => '15[1279]',
                  'national_rule' => '0$1',
                  'pattern' => '(\\d{4})(\\d{7})'
                },
                {
                  'format' => '$1 $2',
                  'leading_digits' => '18',
                  'national_rule' => '0$1',
                  'pattern' => '(\\d{3})(\\d{8})'
                },
                {
                  'format' => '$1 $2 $3',
                  'leading_digits' => '
            1(?:
              6[023]|
              7
            )
          ',
                  'national_rule' => '0$1',
                  'pattern' => '(\\d{3})(\\d{2})(\\d{7,8})'
                },
                {
                  'format' => '$1 $2 $3',
                  'leading_digits' => '15[279]',
                  'national_rule' => '0$1',
                  'pattern' => '(\\d{4})(\\d{2})(\\d{7})'
                },
                {
                  'format' => '$1 $2 $3',
                  'leading_digits' => '15',
                  'national_rule' => '0$1',
                  'pattern' => '(\\d{3})(\\d{2})(\\d{8})'
                }
              ];

my $validators = {
                'fixed_line' => '
          32\\d{9,11}|
          49[2-6]\\d{10}|
          49[0-7]\\d{3,9}|
          (?:
            [34]0|
            [68]9
          )\\d{3,13}|
          (?:
            2(?:
              0[1-689]|
              [1-3569]\\d|
              4[0-8]|
              7[1-7]|
              8[0-7]
            )|
            3(?:
              [3569]\\d|
              4[0-79]|
              7[1-7]|
              8[1-8]
            )|
            4(?:
              1[02-9]|
              [2-48]\\d|
              5[0-6]|
              6[0-8]|
              7[0-79]
            )|
            5(?:
              0[2-8]|
              [124-6]\\d|
              [38][0-8]|
              [79][0-7]
            )|
            6(?:
              0[02-9]|
              [1-358]\\d|
              [47][0-8]|
              6[1-9]
            )|
            7(?:
              0[2-8]|
              1[1-9]|
              [27][0-7]|
              3\\d|
              [4-6][0-8]|
              8[0-5]|
              9[013-7]
            )|
            8(?:
              0[2-9]|
              1[0-79]|
              2\\d|
              3[0-46-9]|
              4[0-6]|
              5[013-9]|
              6[1-8]|
              7[0-8]|
              8[0-24-6]
            )|
            9(?:
              0[6-9]|
              [1-4]\\d|
              [589][0-7]|
              6[0-8]|
              7[0-467]
            )
          )\\d{3,12}
        ',
                'geographic' => '
          32\\d{9,11}|
          49[2-6]\\d{10}|
          49[0-7]\\d{3,9}|
          (?:
            [34]0|
            [68]9
          )\\d{3,13}|
          (?:
            2(?:
              0[1-689]|
              [1-3569]\\d|
              4[0-8]|
              7[1-7]|
              8[0-7]
            )|
            3(?:
              [3569]\\d|
              4[0-79]|
              7[1-7]|
              8[1-8]
            )|
            4(?:
              1[02-9]|
              [2-48]\\d|
              5[0-6]|
              6[0-8]|
              7[0-79]
            )|
            5(?:
              0[2-8]|
              [124-6]\\d|
              [38][0-8]|
              [79][0-7]
            )|
            6(?:
              0[02-9]|
              [1-358]\\d|
              [47][0-8]|
              6[1-9]
            )|
            7(?:
              0[2-8]|
              1[1-9]|
              [27][0-7]|
              3\\d|
              [4-6][0-8]|
              8[0-5]|
              9[013-7]
            )|
            8(?:
              0[2-9]|
              1[0-79]|
              2\\d|
              3[0-46-9]|
              4[0-6]|
              5[013-9]|
              6[1-8]|
              7[0-8]|
              8[0-24-6]
            )|
            9(?:
              0[6-9]|
              [1-4]\\d|
              [589][0-7]|
              6[0-8]|
              7[0-467]
            )
          )\\d{3,12}
        ',
                'mobile' => '
          15[0-25-9]\\d{8}|
          1(?:
            6[023]|
            7\\d
          )\\d{7,8}
        ',
                'pager' => '
          16(?:
            4\\d{1,10}|
            [89]\\d{1,11}
          )
        ',
                'personal_number' => '700\\d{8}',
                'specialrate' => '(
          180\\d{5,11}|
          13(?:
            7[1-6]\\d\\d|
            8
          )\\d{4}
        )|(
          (?:
            137[7-9]|
            900(?:
              [135]|
              9\\d
            )
          )\\d{6}
        )|(
          18(?:
            1\\d{5,11}|
            [2-9]\\d{8}
          )
        )',
                'toll_free' => '800\\d{7,12}',
                'voip' => ''
              };
my %areanames = ();
$areanames{en} = {"494563", "Scharbeutz\-Haffkrug",
"497484", "Simmersfeld",
"4938842", "Lüttenmark",
"496851", "St\ Wendel",
"495203", "Werther\ Westfalen",
"495043", "Lauenau",
"496159", "Messel",
"4934654", "Stolberg\ Harz",
"499392", "Faulbach\ Unterfranken",
"492486", "Nettersheim",
"495199", "Schneverdingen\-Heber",
"495948", "Itterbeck",
"492955", "Büren\-Wewelsburg",
"498237", "Aindling",
"494253", "Asendorf\ Kreis\ Diepholz",
"497242", "Rheinstetten",
"4936379", "Holzengel",
"499273", "Bad\ Berneck\ im\ Fichtelgebirge",
"493773", "Johanngeorgenstadt",
"4933396", "Klosterfelde",
"4938756", "Grabow",
"497938", "Mulfingen\ Jagst",
"499924", "Bodenmais",
"495232", "Lage\ Lippe",
"499521", "Hassfurt",
"494882", "Lunden",
"498684", "Fridolfing",
"495829", "Wriedel",
"492592", "Selm",
"4939451", "Wasserleben",
"496763", "Kirchberg\ Hunsrück",
"4935326", "Schönborn\ Kreis\ Elbe\-Elster",
"494346", "Gettorf",
"4933977", "Gumtow",
"492733", "Hilchenbach",
"498136", "Markt\ Indersdorf",
"498344", "Westendorf\ bei\ Kaufbeuren",
"495121", "Hildesheim",
"494134", "Embsen\ Kreis\ Lüneburg",
"497388", "Pfronstetten",
"497033", "Weil\ Der\ Stadt",
"495932", "Haren\ Ems",
"498035", "Raubling",
"4939059", "Wegenstedt",
"4939992", "Görmin",
"493724", "Burgstädt",
"495846", "Gartow\ Niedersachsen",
"495642", "Warburg\-Scherfede",
"493874", "Ludwigslust",
"494522", "Plön",
"493909", "Klötze\ Altmark",
"494735", "Butjadingen\-Stollhamm",
"4937605", "Hartenstein\ Sachsen",
"497447", "Baiersbronn\-Schwarzenberg",
"498432", "Burgheim",
"4934924", "Zahna",
"494329", "Langwedel\ Holstein",
"4939453", "Derenburg",
"499365", "Rimpar",
"495382", "Bad\ Gandersheim",
"499189", "Berg\ bei\ Neumarkt\ in\ der\ Oberpfalz",
"4933609", "Brieskow\-Finkenheerd",
"499078", "Mertingen",
"496676", "Hohenroda\ Hessen",
"4935242", "Nossen",
"496722", "Rüdesheim\ am\ Rhein",
"495437", "Menslage",
"492565", "Gronau\-Epe",
"492834", "Straelen",
"496872", "Losheim\ am\ See",
"498387", "Weiler\-Simmerberg",
"496301", "Otterbach\ Pfalz",
"495903", "Emsbüren",
"492182", "Grevenbroich\-Kapellen",
"492255", "Euskirchen\-Flamersheim",
"4934362", "Mügeln\ bei\ Oschatz",
"4936947", "Jüchsen",
"493583", "Zittau",
"4933708", "Rangsdorf",
"497942", "Neuenstein\ Württemberg",
"494953", "Bunde",
"497836", "Schiltach",
"495248", "Langenberg\ Kreis\ Gütersloh",
"497632", "Badenweiler",
"4939828", "Wustrow\ Kreis\ Mecklenburg\-Strelitz",
"498403", "Pförring",
"496535", "Osann\-Monzel",
"496864", "Mettlach",
"499973", "Furth\ im\ Wald",
"4933657", "Steinsdorf\ Brandenburg",
"4938455", "Plaaz",
"498642", "Übersee",
"496508", "Hetzerath\ Mosel",
"494844", "Pellworm",
"4939924", "Stuer",
"497947", "Forchtenberg",
"495035", "Gross\ Munzel",
"498846", "Uffing\ am\ Staffelsee",
"497191", "Backnang",
"498382", "Lindau\ Bodensee",
"4939050", "Bartensleben",
"492653", "Kaisersesch",
"4939007", "Tangeln",
"495432", "Löningen",
"496727", "Gensingen",
"499473", "Kallmünz",
"493867", "Lübstorf",
"497129", "Lichtenstein\ Württemberg",
"4936462", "Ossmannstedt",
"4936083", "Uder",
"4938422", "Neukloster",
"494708", "Ringstedt",
"497442", "Baiersbronn",
"494453", "Zetel",
"4939362", "Grieben\ bei\ Tangerhütte",
"495403", "Bad\ Iburg",
"494527", "Bosau",
"495647", "Lichtenau\-Kleinenberg",
"497821", "Lahr\ Schwarzwald",
"4933831", "Weseram",
"492745", "Brachbach\ Sieg",
"495937", "Geeste\-Gross\ Hesepe",
"497045", "Oberderdingen",
"4939389", "Schollene",
"497771", "Stockach",
"498248", "Lamerdingen",
"498203", "Grossaitingen",
"4933833", "Wollin\ bei\ Brandenburg",
"494188", "Welle\ Nordheide",
"497334", "Deggingen",
"498043", "Jachenau",
"4933927", "Linum",
"492455", "Waldfeucht",
"4933966", "Dranse",
"495448", "Barver",
"497146", "Remseck\ am\ Neckar",
"4936370", "Grossenehrich",
"494743", "Langen\ bei\ Bremerhaven",
"498638", "Waldkraiburg",
"492336", "Schwelm",
"497581", "Saulgau",
"492597", "Senden\ Westfalen",
"4936608", "Seelingstädt\ bei\ Gera",
"497905", "Langenburg",
"4936081", "Arenshausen",
"495237", "Augustdorf",
"492052", "Velbert\-Langenberg",
"495605", "Kaufungen\ Hessen",
"495684", "Frielendorf",
"499397", "Wertheim\-Dertingen",
"4933734", "Felgentreu",
"498232", "Schwabmünchen",
"497247", "Linkenheim\-Hochstetten",
"499536", "Kirchlauter",
"498121", "Markt\ Schwaben",
"499675", "Altendorf\ am\ Nabburg",
"495344", "Lengede",
"493601", "Mühlhausen\ Thüringen",
"492528", "Ennigerloh\-Enniger",
"499424", "Strasskirchen",
"4939247", "Güterglück",
"496543", "Büchenbeuren",
"495136", "Burgdorf\ Kreis\ Hannover",
"496661", "Schlüchtern",
"498273", "Nordendorf",
"4936739", "Rottenbach",
"497546", "Oberteuringen",
"498392", "Markt\ Rettenbach",
"496021", "Aschaffenburg",
"493737", "Rochlitz",
"495328", "Altenau\ Harz",
"4934773", "Schwittersdorf",
"492941", "Lippstadt",
"497181", "Schorndorf\ Württemberg",
"4933704", "Baruth\ Mark",
"4939978", "Gross\ Roge",
"499448", "Hausen\ Niederbayern",
"4936781", "Grossbreitenbach",
"4939487", "Friedrichsbrunn",
"4939824", "Hohenzieritz",
"492631", "Neuwied",
"497975", "Untergröningen",
"492777", "Breitscheid\ Hessen",
"4938297", "Moitin",
"495675", "Trendelburg",
"499344", "Gerchsheim",
"494431", "Wildeshausen",
"496788", "Sien",
"4933962", "Heiligengrabe",
"498709", "Eching\ Niederbayern",
"494740", "Loxstedt\-Dedesdorf",
"4933931", "Rheinsberg\ Mark",
"495424", "Bad\ Rothenfelde",
"492827", "Goch\-Hassum",
"493671", "Saalfeld\ Saale",
"494926", "Krummhörn\-Greetsiel",
"492296", "Reichshof\-Brüchermühle",
"499605", "Weiherhammer",
"4939723", "Krien",
"493306", "Gransee",
"497363", "Lauchheim",
"495536", "Holzminden\-Neuhaus",
"4934928", "Seegrehna",
"494249", "Bassum\-Nordwohlde",
"496357", "Standenbühl",
"4933989", "Sadenbeck",
"4939721", "Liepen\ bei\ Anklam",
"498365", "Wertach",
"496578", "Salmtal",
"496108", "Mühlheim\ am\ Main",
"4936427", "Dornburg\ Saale",
"4939366", "Kehnert",
"4939327", "Klietz",
"4938426", "Neuburg\-Steinhausen",
"492587", "Ennigerloh\-Westkirchen",
"494639", "Schafflund",
"49331", "Potsdam",
"4933933", "Lindow\ Mark",
"498224", "Offingen\ Donau",
"4939037", "Pretzier",
"497529", "Waldburg\ Württemberg",
"499403", "Donaustauf",
"4934771", "Querfurt",
"494828", "Lägerdorf",
"499647", "Kirchenthumbach",
"494778", "Wingst",
"4936783", "Gehren\ Thüringen",
"499937", "Oberpöring",
"4934444", "Lützen",
"497322", "Giengen\ an\ der\ Brenz",
"492241", "Siegburg",
"494127", "Westerhorn",
"495473", "Ostercappeln",
"4934658", "Hayn\ Harz",
"4935435", "Gollmitz\ bei\ Calau",
"497275", "Kandel",
"495694", "Diemelstadt",
"496654", "Gersfeld\ Rhön",
"496833", "Rehlingen\-Siersburg",
"4935246", "Ziegenhain\ Sachsen",
"499382", "Gerolzhofen",
"497327", "Dischingen",
"495365", "Wolfsburg\-Neindorf",
"494122", "Uetersen",
"494950", "Holtland",
"497673", "Schönau\ im\ Schwarzwald",
"4934327", "Waldheim\ Sachsen",
"494231", "Verden\ Aller",
"499846", "Ipsheim",
"495224", "Enger\ Westfalen",
"499932", "Osterhofen",
"493361", "Fürstenwalde\ Spree",
"4934721", "Nienburg\ Saale",
"499642", "Kemnath\ Stadt",
"492863", "Velen",
"492165", "Jüchen",
"4939996", "Törpin",
"492389", "Werne",
"496371", "Landstuhl",
"4933877", "Nitzahn",
"495973", "Neuenkirchen\ Kreis\ Steinfurt",
"496802", "Völklingen\-Lauterbach",
"494892", "Schenefeld\ Mittelholstein",
"492582", "Everswinkel",
"492751", "Bad\ Berleburg",
"4939771", "Ueckermünde",
"497051", "Calw",
"499903", "Schöllnach",
"4936604", "Münchenbernsdorf",
"496135", "Bodenheim\ Rhein",
"497475", "Burladingen",
"496269", "Gundelsheim\ Württemberg",
"494163", "Horneburg\ Niederelbe",
"496352", "Kirchheimbolanden",
"499948", "Eschlkam",
"4934978", "Radegast\ Kreis\ Köthen",
"499199", "Kunreuth",
"4938752", "Zierzow\ bei\ Ludwigslust",
"496036", "Wölfersheim",
"497624", "Grenzach\-Wyhlen",
"492441", "Kall",
"492764", "Welschen\ Ennest",
"49661", "Fulda",
"499638", "Neualbenreuth",
"4939773", "Altwarp",
"495273", "Beverungen",
"492066", "Duisburg\-Homberg",
"497072", "Gomaringen",
"496559", "Leidenborn",
"492822", "Emmerich",
"4935322", "Doberlug\-Kirchhain",
"496734", "Flonheim",
"492772", "Herborn\ Hessen",
"498328", "Balderschwang",
"492626", "Selters\ Westferwald",
"4936730", "Sitzendorf",
"499203", "Neudrossenfeld",
"4939928", "Möllenhagen",
"498424", "Nassenfels",
"499270", "Creussen",
"494381", "Lütjenburg",
"4936847", "Steinbach\-Hallenberg",
"493525", "Riesa",
"492192", "Hückeswagen",
"494426", "Wangerland\-Horumersiel",
"4938725", "Gross\ Godems",
"498536", "Kösslarn",
"495924", "Bad\ Bentheim\-Gildehaus",
"499232", "Wunsiedel",
"499779", "Nordheim\ von\ der\ Rhön",
"494931", "Norden",
"499829", "Flachslanden",
"494865", "Osterhever",
"494534", "Steinburg\ Kreis\ Storman",
"4938305", "Gingst",
"4935032", "Langenhennersdorf",
"494641", "Süderbrarup",
"495521", "Herzberg\ am\ Harz",
"4938722", "Raduhn",
"496355", "Albisheim\ Pfrimm",
"495323", "Clausthal\-Zellerfeld",
"4936337", "Schiedungen",
"497472", "Rottenburg\ am\ Neckar",
"49751", "Ravensburg",
"499607", "Luhe\-Wildenau",
"499443", "Abensberg",
"4936731", "Unterloquitz",
"4936762", "Steinach\ Thüringen",
"496524", "Rodershausen",
"492825", "Uedem",
"493391", "Neuruppin",
"4938302", "Sagard",
"497464", "Talheim\ Kreis\ Tuttlingen",
"497741", "Tiengen\ Hochrhein",
"492520", "Wadersloh\-Diestedde",
"492041", "Bottrop",
"495677", "Calden\-Westuffeln",
"496436", "Dornburg\ Hessen",
"492775", "Driedorf",
"494724", "Cuxhaven\-Lüdingworth",
"497977", "Oberrot\ bei\ Gaildorf",
"499854", "Wittelshofen",
"495731", "Bad\ Oeynhausen",
"498726", "Schönau\ Niederbayern",
"4936027", "Lengenfeld\ Unterm\ Stein",
"4938755", "Eldena",
"4933395", "Zerpenschleuse",
"493522", "Grossenhain\ Sachsen",
"494180", "Königsmoor",
"492195", "Radevormwald",
"494874", "Todenbüttel",
"494666", "Ladelund",
"493735", "Marienberg\ Sachsen",
"499235", "Thierstein",
"498024", "Holzkirchen",
"498664", "Chieming",
"4935325", "Rückersdorf\ bei\ Finsterwalde",
"496783", "Baumholder",
"498630", "Oberneukirchen",
"4933981", "Putlitz",
"493329", "Stahnsdorf",
"4933084", "Gutengermendorf",
"494862", "Garding",
"498459", "Manching",
"4933434", "Herzfelde\ bei\ Strausberg",
"493686", "Eisfeld",
"498651", "Bad\ Reichenhall",
"497277", "Wörth\-Büchelberg",
"495362", "Wolfsburg\-Fallersleben",
"4933983", "Gross\ Pankow\ Kreis\ Prignitz",
"494125", "Seestermühe",
"494193", "Henstedt\-Ulzburg",
"499385", "Kolitzheim",
"495259", "Bad\ Driburg\-Neuenheerse",
"499935", "Stephansposching",
"494209", "Schwanewede",
"496573", "Gillenfeld",
"496103", "Langen\ Hessen",
"493346", "Seelow",
"495374", "Isenbüttel",
"499645", "Eschenbach\ in\ der\ Oberpfalz",
"4937346", "Geyer",
"499861", "Rothenburg\ ob\ der\ Tauber",
"4937606", "Lengenfeld\ Vogtland",
"4934204", "Schkeuditz",
"497176", "Spraitbach",
"492162", "Viersen",
"497506", "Wangen\-Leupolz",
"496221", "Heidelberg",
"4934779", "Abberode",
"493563", "Spremberg",
"496805", "Kleinblittersdorf",
"497451", "Horb\ am\ Neckar",
"498073", "Gars\ am\ Inn",
"496500", "Waldrach",
"492585", "Warendorf\-Hoetmar",
"4939087", "Jerchel\ Altmark",
"492504", "Telgte",
"494823", "Wilster",
"492174", "Burscheid\ Rheinland",
"499408", "Altenthann",
"498367", "Rosshaupten\ Forggensee",
"496132", "Ingelheim\ am\ Rhein",
"494773", "Lamstedt",
"4939748", "Viereck",
"4936733", "Kaulsdorf",
"498362", "Füssen",
"4939751", "Penkun",
"498259", "Schiltberg",
"4938456", "Langhagen\ bei\ Güstrow",
"496691", "Schwalmstadt",
"499435", "Schwarzenfeld",
"495651", "Eschwege",
"499070", "Tapfheim",
"49981", "Ansbach",
"496838", "Saarwellingen",
"498374", "Dietmannsried",
"499356", "Burgsinn",
"4933631", "Bad\ Saarow\-Pieskow",
"496236", "Neuhofen\ Pfalz",
"4937464", "Schöneck\ Vogtland",
"492401", "Baesweiler",
"496629", "Schenklengsfeld",
"495073", "Neustadt\-Esperke",
"4936258", "Friemar",
"499908", "Schöfweg",
"492556", "Metelen",
"497264", "Bad\ Rappenau",
"499243", "Pottenstein",
"495367", "Rühen",
"497951", "Crailsheim",
"497393", "Munderkingen",
"497325", "Sontheim\ an\ der\ Brenz",
"495978", "Hörstel\-Dreierwalde",
"497739", "Hilzingen",
"4939779", "Eggesin",
"497554", "Heiligenberg\ Baden",
"497272", "Rülzheim",
"492266", "Lindlar",
"4939204", "Niederndodeleben",
"496842", "Blieskastel",
"4938794", "Cumlosen",
"4933965", "Herzsprung\ bei\ Wittstock",
"497561", "Leutkirch\ im\ Allgäu",
"498323", "Immenstadt\ im\ Allgäu",
"497964", "Stödtlen",
"498395", "Tannheim\ Württemberg",
"4937294", "Grünhainichen",
"499208", "Bindlach",
"497930", "Boxberg\ Baden",
"496646", "Grebenau",
"497251", "Bruchsal",
"4936077", "Grossbodungen",
"498677", "Burghausen\ Salzach",
"499943", "Lam\ Oberpfalz",
"4933633", "Spreenhagen",
"494168", "Neu\ Wulmstorf\-Elstorf",
"497972", "Gschwend\ bei\ Gaildorf",
"496386", "Altenkirchen\ Pfalz",
"4939854", "Kleptow",
"495278", "Höxter\-Ovenhausen",
"499633", "Mitterteich",
"496421", "Marburg",
"495726", "Wiedensahl",
"493844", "Schwaan",
"495672", "Bad\ Karlshafen",
"494409", "Westerstede\-Ocholt",
"498731", "Dingolfing",
"4933207", "Gross\ Kreutz",
"4939753", "Strasburg",
"495664", "Morschen",
"499602", "Neustadt\ an\ der\ Waldnaab",
"495459", "Hörstel",
"497477", "Jungingen\ bei\ Hechingen",
"495024", "Rohrsen\ Kreis\ Nienburg\ Weser",
"495943", "Emlichheim",
"496341", "Landau\ in\ der\ Pfalz",
"497161", "Göppingen",
"4934208", "Löbnitz\ bei\ Delitzsch",
"494258", "Schwarme",
"499278", "Weidenberg",
"495633", "Diemelsee",
"492452", "Heinsberg\ Rheinland",
"4933237", "Paulinenaue",
"4934692", "Alsleben\ Saale",
"4934383", "Trebsen\ Mulde",
"498443", "Hohenwart\ Paar",
"496681", "Hilders",
"497755", "Weilheim\ Kreis\ Waldshut",
"495208", "Leopoldshöhe",
"4939744", "Rothenklempenow",
"4936371", "Schlossvippach",
"492738", "Netphen",
"4933438", "Altlandsberg",
"499664", "Hahnbach",
"495602", "Hessisch\ Lichtenau",
"495806", "Barum\ bei\ Bad\ Bevensen",
"4933603", "Falkenhagen\ bei\ Seelow",
"492957", "Wünnenberg\-Haaren",
"494479", "Molbergen\-Peheim",
"4939459", "Hasselfelde",
"497383", "Münsingen\-Buttenhausen",
"497933", "Creglingen",
"49431", "Kiel",
"498320", "Missen\-Wilhams",
"494856", "Kronprinzenkoog",
"4939053", "Süplingen",
"499672", "Neunburg\ vorm\ Wald",
"499726", "Euerbach",
"499876", "Rohr\ Mittelfranken",
"497643", "Herbolzheim\ Breisgau",
"493949", "Oschersleben\ Bode",
"496396", "Hinterweidenthal",
"4939954", "Stavenhagen\ Reuterstadt",
"4939051", "Calvörde",
"498861", "Schongau",
"4939365", "Bellingen\ bei\ Stendal",
"4934423", "Heuckewalde",
"495356", "Helmstedt\-Barmke",
"4938425", "Kirchdorf\ Poel",
"49581", "Uelzen",
"4936465", "Oberndorf\ bei\ Apolda",
"492257", "Reckerscheid",
"493431", "Döbeln",
"495032", "Neustadt\ am\ Rübenberge",
"498385", "Hergatz",
"497233", "Niefern\-Öschelbronn",
"4933747", "Marzahna",
"4935697", "Bagenz",
"494671", "Bredstedt",
"498304", "Wildpoldsried",
"4933088", "Falkenthal",
"499651", "Vohenstrauss",
"495435", "Berge\ bei\ Quakenbrück",
"492567", "Ahaus\-Alstätte",
"4933601", "Podelzig",
"499749", "Oberbach\ Unterfranken",
"493588", "Niesky",
"492471", "Roetgen\ Eifel",
"494958", "Jemgum",
"4933830", "Ziesar",
"499367", "Unterpleichfeld",
"4934381", "Colditz",
"494737", "Stadland\-Schwei",
"498753", "Elsendorf\ Niederbayern",
"497445", "Pfalzgrafenweiler",
"4938452", "Lalendorf",
"499978", "Schönthal\ Oberpfalz",
"4936373", "Buttstädt",
"492156", "Willich\-Anrath",
"492742", "Wissen",
"4935436", "Laasow\ bei\ Calau",
"499073", "Gundelfingen\ an\ der\ Donau",
"497202", "Karlsbad",
"495908", "Wietmarschen\-Lohne",
"497154", "Kornwestheim",
"497042", "Vaihingen\ an\ der\ Enz",
"494354", "Fleckeby",
"4936703", "Gräfenthal",
"495935", "Twist\-Schöninghsdorf",
"498032", "Rohrdorf\ Kreis\ Rosenheim",
"494770", "Wischhafen",
"4935245", "Burkhardswalde\-Munzig",
"495861", "Dannenberg\ Elbe",
"492747", "Molzhain",
"499374", "Eschau",
"499569", "Sesslach",
"494525", "Ahrensbök",
"49881", "Weilheim\ in\ Oberbayern",
"495645", "Borgentreich\-Borgholz",
"493381", "Brandenburg\ an\ der\ Havel",
"493931", "Stendal",
"496503", "Hermeskeil",
"496173", "Kronberg\ im\ Taunus",
"498435", "Ehekirchen",
"494732", "Stadland\-Rodenkirchen",
"493641", "Jena",
"4939423", "Wegeleben",
"495304", "Meine",
"4934954", "Roitzsch\ bei\ Bitterfeld",
"493865", "Holthusen",
"497576", "Krauchenwies",
"492562", "Gronau\ Westfalen",
"496725", "Gau\-Algesheim",
"495753", "Auetal\-Bernsen",
"496875", "Nonnweiler\-Primstal",
"496339", "Grosssteinhausen",
"4939995", "Nossendorf",
"4937298", "Oelsnitz\ Erzgebirge",
"498243", "Fuchstal",
"492574", "Saerbeck",
"492369", "Dorsten\-Wulfen",
"492104", "Mettmann",
"4936481", "Neustadt\ an\ der\ Orla",
"495037", "Bad\ Rehburg",
"497945", "Wüstenrot",
"4933839", "Wusterwitz",
"492252", "Zülpich",
"4937602", "Kirchberg\ Sachsen",
"4937342", "Cranzahl",
"496532", "Zeltingen\-Rachtig",
"4933677", "Glienicke\ bei\ Beeskow",
"497635", "Schliengen",
"492971", "Schmallenberg\-Dorlar",
"494703", "Loxstedt\-Donnern",
"4939858", "Bietikow",
"494458", "Wiefelstede\-Spohle",
"498633", "Tüssling",
"497402", "Fluorn\-Winzeln",
"494748", "Stubben\ bei\ Bremerhaven",
"4937468", "Treuen\ Vogtland",
"4936483", "Ziegenrück",
"496124", "Bad\ Schwalbach",
"4939383", "Sandau\ Elbe",
"499677", "Oberviechtach\-Pullenried",
"4936254", "Friedrichswerth",
"49711", "Stuttgart",
"494183", "Jesteburg",
"497084", "Schömberg\ bei\ Neuenbürg",
"497245", "Durmersheim",
"498208", "Eurasburg\ bei\ Augsburg",
"492952", "Rüthen",
"499395", "Triefenstein",
"499323", "Iphofen",
"492271", "Bergheim\ Erft",
"4939208", "Loitsche",
"495607", "Fuldatal",
"495443", "Lemförde",
"495235", "Blomberg\ Lippe",
"498806", "Utting\ am\ Ammersee",
"4938726", "Spornitz",
"497907", "Schwäbisch\ Hall\-Sulzdorf",
"4938332", "Gross\ Bisdorf",
"492595", "Olfen",
"4936766", "Schalkau",
"4939421", "Osterwieck",
"4938845", "Kaarssen",
"494804", "Nordhastedt",
"492523", "Wadersloh",
"494885", "Bergenhusen",
"497433", "Balingen",
"4939407", "Seehausen\ Börde",
"4938306", "Samtens",
"496894", "St\ Ingbert",
"4936701", "Lichte",
"495854", "Bleckede\-Barskamp",
"494361", "Oldenburg\ in\ Holstein",
"4936647", "Saalburg\ Thüringen",
"495320", "Torfhaus",
"492662", "Hachenburg",
"497676", "Feldberg\ Schwarzwald",
"497722", "Triberg\ im\ Schwarzwald",
"499843", "Burgbernheim",
"4935439", "Zinnitz",
"4934722", "Preusslitz",
"496670", "Ludwigsau\ Hessen",
"499091", "Monheim\ Schwaben",
"4938854", "Redefin",
"492866", "Dorsten\-Rhade",
"492674", "Bad\ Bertrich",
"496836", "Überherrn",
"494967", "Rhauderfehn\-Burlage",
"499358", "Gössenheim",
"4935033", "Rosenthal\ Sächsische\ Schweiz",
"492425", "Nideggen\-Embken",
"4933768", "Prieros",
"498151", "Starnberg",
"49921", "Bayreuth",
"496238", "Dirmstein",
"49371", "Chemnitz\ Sachsen",
"494474", "Garrel",
"4938753", "Wöbbelin",
"4933393", "Gross\ Schönebeck\ Kreis\ Barnim",
"492558", "Horstmar",
"499454", "Aufhausen\ Oberpfalz",
"499906", "Mariaposching",
"495840", "Schnackenburg",
"494625", "Jübek",
"4939772", "Rothemühl",
"495545", "Hedemünden",
"496447", "Langgöns\-Niederkleen",
"493944", "Blankenburg\ Harz",
"498765", "Bruckberg\ Niederbayern",
"4935323", "Sonnewalde",
"494462", "Wittmund",
"493541", "Calau",
"495976", "Salzbergen",
"499145", "Solnhofen",
"492268", "Kürten",
"493634", "Sömmerda",
"4938720", "Grebbin",
"49991", "Deggendorf",
"492695", "Insul",
"492623", "Ransbach\-Baumbach",
"497763", "Murg",
"496648", "Bad\ Salzschlirf",
"498502", "Fürstenzell",
"4935727", "Burghammer",
"499206", "Mistelgau\-Obernsees",
"496757", "Becherbach\ bei\ Kirn",
"492377", "Wickede\ Ruhr",
"4938751", "Picher",
"494166", "Ahlerstedt",
"499744", "Zeitlofs\-Detter",
"499461", "Roding",
"4938300", "Insel\ Hiddensee",
"496033", "Butzbach",
"494340", "Achterwehr",
"4939456", "Altenbrak",
"495276", "Marienmünster",
"493987", "Templin",
"496405", "Laubach\ Hessen",
"498533", "Rotthalmünster",
"494557", "Blunk",
"497851", "Kehl",
"496484", "Beselich",
"4938204", "Broderstorf",
"499107", "Trautskirchen",
"4935934", "Grossdubrau",
"4936735", "Probstzella",
"4937324", "Reinsberg\ Sachsen",
"496242", "Osthofen",
"496002", "Ober\-Mörlen",
"497159", "Renningen",
"494267", "Lauenbrück",
"493596", "Neustadt\ in\ Sachsen",
"495507", "Ebergötzen",
"495177", "Edemissen\-Abbensen",
"494423", "Fedderwarden",
"494495", "Friesoythe\-Thüle",
"493337", "Biesenthal\ Brandenburg",
"4938309", "Trent",
"493332", "Schwedt\/Oder",
"499564", "Bad\ Rodach",
"499835", "Ehingen\ Mittelfranken",
"495502", "Dransfeld",
"495172", "Ilsede",
"499961", "Mitterfels",
"496247", "Worms\-Pfeddersheim",
"4936782", "Schmiedefeld\ am\ Rennsteig",
"494262", "Visselhövede",
"496007", "Rosbach\-Rodheim",
"498081", "Dorfen\ Stadt",
"499254", "Gefrees",
"495130", "Wedemark",
"498276", "Baar\ Schwaben",
"495164", "Hodenhagen",
"499102", "Wilhermsdorf",
"495309", "Lehre\-Wendhausen",
"499572", "Burgkunstadt",
"4938729", "Marnitz",
"49941", "Regensburg",
"496438", "Hünfelden",
"494552", "Leezen",
"497543", "Kressbronn\ am\ Bodensee",
"494274", "Varrel\ bei\ Sulingen",
"492225", "Meckenheim\ Rheinland",
"492293", "Nümbrecht",
"494923", "Krummhörn\-Pewsum",
"496334", "Thaleischweiler\-Fröschen",
"493303", "Birkenwerder",
"498728", "Geratskirchen",
"492372", "Hemer",
"497366", "Abtsgmünd",
"496146", "Hochheim\ am\ Main",
"495533", "Bodenwerder",
"492801", "Xanten",
"494668", "Klanxbüll",
"496752", "Kirn\ Nahe",
"498507", "Neuburg\ am\ Inn",
"498177", "Münsing\ Starnberger\ See",
"496581", "Saarburg",
"492364", "Haltern\ Westfalen",
"4933932", "Fehrbellin",
"499133", "Baiersdorf\ Mittelfranken",
"4940", "Hamburg",
"492330", "Herdecke",
"496129", "Schlangenbad",
"494295", "Emtinghausen",
"492925", "Warstein\-Allagen",
"492351", "Lüdenscheid",
"492993", "Marsberg\-Canstein",
"4933836", "Butzow\ bei\ Brandenburg",
"494223", "Ganderkesee\-Bookholzberg",
"496442", "Braunfels",
"4933963", "Wulfersdorf\ bei\ Wittstock",
"494467", "Wittmund\-Funnix",
"4939722", "Sarnow\ bei\ Anklam",
"496821", "Neunkirchen\ Saar",
"496771", "St\ Goarshausen",
"496205", "Hockenheim",
"4933635", "Arensdorf\ Kreis\ Oder\-Spree",
"496045", "Gedern",
"496284", "Mudau",
"498545", "Hofkirchen\ Bayern",
"495476", "Ostercappeln\-Venne",
"496637", "Feldatal",
"494962", "Papenburg\-Aschendorf",
"495151", "Hameln",
"493761", "Werdau\ Sachsen",
"499261", "Kronach",
"4934772", "Helbra",
"499954", "Simbach\ Niederbayern",
"499406", "Mintraching",
"494101", "Pinneberg",
"494974", "Neuharlingersiel",
"499551", "Burgwindheim",
"492667", "Stein\-Neukirch",
"497727", "Vöhrenbach",
"495859", "Thomasburg",
"495765", "Raddestorf",
"494791", "Osterholz\-Scharmbeck",
"492852", "Hamminkeln",
"4935938", "Grosspostwitz\ OL",
"492656", "Virneburg",
"4938208", "Kavelstorf",
"498091", "Kirchseeon",
"496322", "Bad\ Dürkheim",
"4934776", "Rothenschirmbach",
"4937328", "Grossschirma",
"497654", "Löffingen",
"4934385", "Mutzschen",
"496701", "Sprendlingen\ Rheinhessen",
"496275", "Rothenberg\ Odenwald",
"498145", "Mammendorf",
"495954", "Lorup",
"4933832", "Rogäsen",
"495406", "Belm",
"497578", "Wald\ Hohenz",
"494335", "Hohn\ bei\ Rendsburg",
"4933605", "Boossen",
"4937349", "Scheibenberg",
"499765", "Trappstadt",
"496591", "Gerolstein",
"4937609", "Wolkenburg\ Mulde",
"4938450", "Tarnow\ bei\ Bützow",
"495551", "Northeim",
"497807", "Neuried\ Ortenaukreis",
"4939726", "Ducherow",
"4936461", "Bad\ Sulza",
"498669", "Traunreut",
"494501", "Kastorf\ Holstein",
"494171", "Winsen\ Luhe",
"498454", "Karlshuld",
"495261", "Lemgo",
"4939361", "Lüderitz",
"4939055", "Hörsingen",
"494456", "Varel\-Altjührden",
"49821", "Augsburg",
"498029", "Kreuth\ bei\ Tegernsee",
"499151", "Hersbruck",
"494746", "Hagen\ bei\ Bremerhaven",
"495572", "Bodenfelde",
"492333", "Ennepetal",
"495102", "Laatzen",
"499164", "Langenfeld\ Mittelfranken",
"4936463", "Gebstedt",
"495254", "Paderborn\-Schloss\ Neuhaus",
"496294", "Krautheim\ Jagst",
"493831", "Stralsund",
"493965", "Burow\ bei\ Altentreptow",
"4936082", "Ershausen",
"498744", "Gerzen",
"498461", "Beilngries",
"4938423", "Bad\ Kleinen",
"49541", "Osnabrück",
"4934425", "Droyssig",
"4939363", "Angern",
"498206", "Egling\ an\ der\ Paar",
"499172", "Georgensgmünd",
"499502", "Frensdorf",
"495379", "Sassenburg\-Grussendorf",
"495835", "Wahrenholz",
"495564", "Dassel",
"498046", "Bad\ Heilbrunn",
"494204", "Thedinghausen",
"497357", "Attenweiler",
"495961", "Haselünne",
"492983", "Winterberg\-Siedlinghausen",
"497143", "Besigheim",
"494152", "Geesthacht",
"496363", "Niederkirchen",
"494285", "Rhade\ bei\ Zeven",
"494920", "Wirdum",
"498808", "Pähl",
"4938787", "Glöwen",
"4936375", "Kindelbrück",
"497661", "Kirchzarten",
"492721", "Lennestadt",
"492871", "Bocholt",
"4938858", "Lassahn",
"497021", "Kirchheim\ unter\ Teck",
"492302", "Witten",
"496181", "Hanau",
"4933764", "Mittenwalde\ Mark",
"492509", "Nottuln\-Appelhülsen",
"499533", "Untermerzbach",
"495461", "Bramsche\ Hase",
"495744", "Hüllhorst",
"4935243", "Weinböhla",
"494256", "Hilgermissen",
"49841", "Ingolstadt\ Donau",
"498572", "Tann\ Niederbayern",
"4935027", "Weesenstein",
"498102", "Höhenkirchen\-Siegertsbrunn",
"499276", "Bischofsgrün",
"4936705", "Oberweissbach\ Thüringer\ Wald",
"493622", "Waltershausen\ Thüringen",
"498254", "Altomünster",
"499081", "Nördlingen",
"4934363", "Cavertitz",
"4938841", "Neuhaus\ Elbe",
"4939425", "Dingelstedt\ am\ Huy",
"49591", "Lingen\ \(Ems\)",
"4938234", "Born\ Darss",
"492307", "Kamen",
"498564", "Johanniskirchen",
"498379", "Waltenhofen\-Oberdorf",
"495206", "Bielefeld\-Jöllenbeck",
"494343", "Laboe",
"497352", "Ochsenhausen",
"492736", "Burbach\ Siegerl",
"4939993", "Hohenmocker",
"496475", "Weilmünster\-Wolfenhausen",
"498133", "Haimhausen\ Oberbayern",
"497269", "Sulzfeld\ Baden",
"499177", "Heideck",
"49761", "Freiburg\ im\ Breisgau",
"495808", "Gerdau",
"496624", "Heringen\ Werra",
"497734", "Gailingen",
"494683", "Oldsum",
"499728", "Wülfershausen\ Unterfranken",
"492620", "Neuhäusel\ Westerwald",
"494858", "Sankt\ Margarethen\ Holstein",
"4939452", "Ilsenburg",
"496766", "Kisselbach",
"495358", "Bahrdorf\-Mackendorf",
"496398", "Vorderweidenthal",
"493663", "Schleiz",
"497802", "Oberkirch\ Baden",
"4939776", "Hintersee",
"497371", "Riedlingen\ Württemberg",
"492685", "Flammersfeld",
"492604", "Nassau\ Lahn",
"493928", "Schönebeck\ Elbe",
"4939991", "Daberkow",
"495843", "Wustrow\ Wendland",
"497135", "Brackenheim",
"496051", "Gelnhausen",
"494308", "Schwedeneck",
"494404", "Elsfleth",
"494956", "Uplengen",
"493586", "Neugersdorf\ Sachsen",
"4938843", "Bennin",
"4934361", "Dahlen\ Sachsen",
"494485", "Elsfleth\-Huntorf",
"498551", "Freyung",
"497833", "Hornberg\ Schwarzwaldbahn",
"498782", "Pfeffenhausen",
"495145", "Beedenbostel",
"498406", "Böhmfeld",
"492158", "Grefrath\ bei\ Krefeld",
"499976", "Rötz",
"496327", "Neustadt\-Lachen",
"4935241", "Lommatzsch",
"498261", "Mindelheim",
"496673", "Haunetal",
"49521", "Bielefeld",
"4938459", "Laage",
"499545", "Buttenheim",
"4937600", "Neumark\ Sachsen",
"495454", "Hörstel\-Riesenbeck",
"495906", "Lünne",
"492857", "Rees\-Mehr",
"497221", "Baden\-Baden",
"496506", "Welschbillig",
"4938333", "Horst\ bei\ Grimmen",
"495491", "Damme\ Dümmer",
"497805", "Appenweier",
"496451", "Frankenberg\ Eder",
"492682", "Hamm\ Sieg",
"494337", "Jevenstedt",
"493423", "Eilenburg",
"497132", "Neckarsulm",
"4935477", "Rietzneuendorf\-Friedrichshof",
"4935604", "Krieschow",
"498785", "Rottenburg\-Oberroning",
"494482", "Hatten",
"495429", "Melle\-Wellingholzhausen",
"4935240", "Tauscha\ bei\ Grossenhain",
"498704", "Altdorf\-Pfettrach",
"4936482", "Triptis",
"4937341", "Ehrenfriedersdorf",
"495142", "Eschede",
"4939382", "Kamern",
"4937601", "Mülsen\ Skt\ Jacob",
"499349", "Werbach\-Wenkheim",
"495054", "Bergen\-Sülze",
"496094", "Weibersbrunn",
"494706", "Schiffdorf",
"497573", "Stetten\ am\ kalten\ Markt",
"494244", "Harpstedt",
"4938429", "Glasin",
"499542", "Schesslitz",
"498246", "Waal",
"494186", "Buchholz\-Trelde",
"499481", "Pfatter",
"49471", "Bremerhaven",
"499326", "Markt\ Einersheim",
"493693", "Meiningen",
"497148", "Grossbottwar",
"495446", "Rehden",
"4933986", "Falkenhagen\ Kreis\ Prignitz",
"498105", "Gilching",
"4935057", "Hermsdorf\ Erzgebirge",
"493462", "Bad\ Dürrenberg",
"492338", "Breckerfeld",
"498636", "Ampfing",
"494944", "Wiesmoor",
"4939455", "Schierke",
"4937438", "Bad\ Brambach",
"4937603", "Wildenfels",
"494634", "Husby",
"4937343", "Jöhstadt",
"494541", "Ratzeburg",
"495621", "Bad\ Wildungen",
"4936964", "Dermbach\ Rhön",
"496472", "Weilmünster",
"4936702", "Lauscha",
"494287", "Heeslingen\-Boitzen",
"497355", "Hochdorf\ Riss",
"4934494", "Ehrenhain",
"497524", "Bad\ Waldsee",
"49651", "Trier",
"492434", "Wegberg",
"495837", "Sprakensehl",
"498803", "Peissenberg",
"4938737", "Ganzlin",
"496741", "St\ Goar",
"496464", "Angelburg",
"496659", "Eichenzell",
"493967", "Oertzenhof\ bei\ Strasburg",
"496430", "Hahnstätten",
"4936736", "Arnsgereuth",
"492526", "Sendenhorst",
"498291", "Zusmarshausen",
"495138", "Sehnde",
"4939422", "Badersleben",
"4938331", "Rakow\ Vorpom",
"497436", "Messstetten\-Oberdigisheim",
"493378", "Ludwigsfelde",
"495184", "Freden\ Leine",
"499331", "Ochsenfurt",
"498446", "Pörnbach",
"495105", "Barsinghausen",
"4934691", "Könnern",
"4938453", "Mistorf",
"494444", "Goldenstedt",
"494761", "Bremervörde",
"4936372", "Kleinneuhausen",
"493962", "Penzlin\ bei\ Waren",
"495946", "Georgsdorf",
"493571", "Hoyerswerda",
"499175", "Spalt",
"498621", "Trostberg",
"495832", "Hankensbüttel",
"499505", "Litzendorf",
"494155", "Büchen",
"496477", "Greifenstein\-Nenderoth",
"494282", "Sittensen",
"498061", "Bad\ Aibling",
"495636", "Lichtenfels\-Goddelsheim",
"497936", "Schrozberg\-Bartenstein",
"4934422", "Osterfeld",
"496561", "Bitburg",
"497842", "Kappelrodeck",
"494853", "Sankt\ Michaelisdonn",
"4936085", "Reinholterode",
"499723", "Röthlein",
"492305", "Castrop\-Rauxel",
"499873", "Abenberg\-Wassermungenau",
"497646", "Weisweil\ Breisgau",
"492384", "Welver",
"4938828", "Schönberg",
"492934", "Sundern\-Altenhellefeld",
"494348", "Schönkirchen",
"496251", "Bensheim",
"498138", "Schwabhausen\ bei\ Dachau",
"4935387", "Seyda",
"495803", "Rosche",
"492644", "Linz\ am\ Rhein",
"497386", "Hayingen",
"497629", "Tegernau\ Baden",
"492855", "Voerde\ Niederrhein",
"493923", "Zerbst",
"497236", "Keltern",
"495848", "Trebel",
"499547", "Zapfendorf",
"4933602", "Alt\ Zeschdorf",
"496264", "Neudenau",
"499194", "Ebermannstadt",
"494303", "Schlesen",
"4933835", "Golzow\ bei\ Brandenburg",
"496393", "Fischbach\ bei\ Dahn",
"496325", "Lambrecht\ Pfalz",
"4939264", "Kroppenstedt",
"495353", "Königslutter\ am\ Elm",
"4933636", "Steinhöfel\ Kreis\ Oder\-Spree",
"492234", "Frechen",
"4939999", "Tutow",
"4939052", "Erxleben\ bei\ Haldensleben",
"495147", "Uetze\-Hänigsen",
"496272", "Hirschhorn\ Neckar",
"494487", "Grossenkneten\-Huntlosen",
"495594", "Bovenden\-Reyershausen",
"4930", "Berlin",
"496554", "Waxweiler",
"494332", "Hamdorf\ bei\ Rendsburg",
"499076", "Wittislingen",
"498142", "Olching",
"498054", "Breitbrunn\ am\ Chiemsee",
"496678", "Wildeck\-Hönebach",
"495704", "Petershagen\-Friedewalde",
"499762", "Saal\ an\ der\ Saale",
"492687", "Horhausen\ Westerwald",
"494754", "Bülkau",
"4934382", "Nerchau",
"499824", "Dietenhofen",
"4935249", "Basslitz",
"494539", "Westerau",
"495246", "Verl",
"497838", "Nordrach",
"498756", "Nandlstadt",
"499281", "Hof\ Saale",
"4938451", "Hoppenrade\ bei\ Güstrow",
"499350", "Eussenheim\-Hundsbach",
"499774", "Oberelsbach",
"492153", "Nettetal\-Lobberich",
"492150", "Meerbusch\-Lank",
"494292", "Ritterhude",
"492922", "Werl",
"499147", "Nennslingen",
"4934498", "Rositz",
"499353", "Karlstadt",
"496445", "Schöffengrund",
"494627", "Dörpstedt",
"499848", "Simmershofen",
"4939752", "Blumenhagen\ bei\ Strasburg",
"4934386", "Dürrweitzschen\ bei\ Grimma",
"495194", "Bispingen",
"496154", "Ober\-Ramstadt",
"496042", "Büdingen\ Hessen",
"496202", "Schwetzingen",
"4934775", "Wippra",
"499246", "Pegnitz\-Trockau",
"498542", "Ortenburg",
"495824", "Bad\ Bodenteich",
"492427", "Nideggen",
"495774", "Wagenfeld\-Ströhen",
"4934297", "Liebertwolkwitz",
"492263", "Engelskirchen",
"495281", "Bad\ Pyrmont",
"499929", "Ruhmannsfelden",
"4933606", "Müllrose",
"494965", "Surwold",
"4938874", "Lützow",
"496233", "Frankenthal\ Pfalz",
"4937434", "Bobenneukirchen",
"498349", "Stötten\ am\ Auerberg",
"4939056", "Klüden",
"492394", "Neuenrade\-Affeln",
"4933632", "Hangelsberg",
"494139", "Hohnstorf\ Elbe",
"499704", "Euerdorf",
"4936968", "Rossdorf\ Rhön",
"492553", "Ochtrup",
"499832", "Wassertrüdingen",
"495505", "Hardegsen",
"4935329", "Dollenchen",
"495175", "Lehrte\-Arpke",
"4934467", "Eckartsberga",
"494497", "Barssel\-Harkebrügge",
"493335", "Finowfurt",
"499946", "Hohenwarth\ bei\ Kötzing",
"4934426", "Kayna",
"495584", "Hattorf\ am\ Harz",
"492963", "Brilon\-Messinghausen",
"499229", "Mainleus",
"496383", "Glan\-Münchweiler",
"494265", "Fintel",
"499636", "Plössberg",
"499105", "Grosshabersdorf",
"494324", "Brokstedt",
"4938759", "Tewswoos",
"499575", "Weismain",
"493501", "Pirna",
"495331", "Wolfenbüttel",
"499184", "Deining\ Oberpfalz",
"492628", "Rhens",
"498326", "Fischen\ im\ Allgäu",
"499720", "Üchtelhausen",
"493904", "Haldensleben",
"496407", "Rabenau\ Hessen",
"494555", "Seedorf\ bei\ Bad\ Segeberg",
"496643", "Herbstein",
"4938377", "Zinnowitz",
"4936785", "Gräfinau\-Angstedt",
"496161", "Brensbach",
"492222", "Bornheim\ Rheinland",
"4936376", "Straussfurt",
"492375", "Balve",
"499803", "Colmberg",
"492839", "Straelen\-Herongen",
"496869", "Merzig\-Silwingen",
"497681", "Waldkirch\ Breisgau",
"495723", "Bad\ Nenndorf",
"498538", "Pocking\-Hartkirchen",
"496755", "Odernheim\ am\ Glan",
"4935433", "Vetschau",
"492697", "Blankenheim\-Ahrhütte",
"4935608", "Gross\ Ossnig",
"492131", "Neuss",
"495873", "Eimke",
"4937207", "Hainichen\ Sachsen",
"4938301", "Putbus",
"4938750", "Malliss",
"498505", "Hutthurm",
"496433", "Hadamar",
"499621", "Amberg\ Oberpfalz",
"49906", "Donauwörth",
"498584", "Breitenberg\ Niederbayern",
"494849", "Hooge",
"492692", "Kelberg",
"495326", "Langelsheim",
"4938721", "Ziegendorf",
"492463", "Titz",
"495481", "Lengerich\ Westfalen",
"494141", "Stade",
"4936761", "Heubisch",
"4938327", "Elmenhorst\ Vorpom",
"4939426", "Hessen",
"499446", "Altmannstein",
"498331", "Memmingen",
"492227", "Bornheim\-Merten",
"4936732", "Könitz",
"494663", "Süderlügum",
"496402", "Hungen",
"4933982", "Hoppenrade\ Kreis\ Prignitz",
"49611", "Wiesbaden",
"496786", "Kempfeld",
"497124", "Trochtelfingen\ Hohenz",
"494928", "Ihlow\-Riepe",
"496084", "Schmitten\ Taunus",
"496245", "Biblis",
"4939268", "Egeln",
"494492", "Saterland",
"498723", "Arnstorf",
"499837", "Haundorf",
"4933969", "Stepenitz",
"495767", "Warmsen",
"492841", "Moers",
"4939775", "Ahlbeck\ bei\ Torgelow",
"496106", "Rodgau",
"497725", "Königsfeld\ im\ Schwarzwald",
"4939386", "Seehausen\ Altmark",
"4938824", "Mallentin",
"497570", "Sigmaringen\-Gutenstein",
"498194", "Vilgertshofen",
"493683", "Schmalkalden",
"499491", "Hemau",
"498547", "Osterhofen\-Gergweis",
"497532", "Meersburg",
"496635", "Kirtorf",
"492422", "Kreuzau",
"496047", "Altenstadt\ Hessen",
"4938723", "Kladrum",
"498774", "Bayerbach\ bei\ Ergoldsbach",
"494826", "Hohenlockstedt",
"496207", "Wald\-Michelbach",
"498281", "Thannhausen\ Schwaben",
"495542", "Witzenhausen",
"494622", "Taarstedt",
"494776", "Osten\-Altendorf",
"498824", "Oberau\ Loisach",
"499429", "Rain\ Niederbayern",
"494465", "Friedeburg\ Ostfriesland",
"498762", "Wartenberg\ Oberbayern",
"497503", "Wilhelmsdorf\ Württemberg",
"4939297", "Eickendorf\ Kreis\ Schönebeck",
"4938303", "Sellin\ Ostseebad",
"497173", "Heubach",
"494297", "Ottersberg\-Posthausen",
"499142", "Treuchtlingen",
"492927", "Neuengeseke",
"498076", "Pfaffing",
"497974", "Bühlerzell",
"499857", "Schopfloch\ Mittelfranken",
"492545", "Rosendahl\-Darfeld",
"4939921", "Ankershagen",
"494877", "Hennstedt\ bei\ Itzehoe",
"497571", "Sigmaringen",
"497962", "Fichtenau",
"499158", "Offenhausen\ Mittelfranken",
"498027", "Dietramszell",
"496844", "Blieskastel\-Altheim",
"498667", "Seeon\-Seebruck",
"4933733", "Stülpe",
"494178", "Radbruch",
"494508", "Krummesse",
"493386", "Premnitz",
"495022", "Wietzen",
"493421", "Torgau",
"4939265", "Löderburg",
"499604", "Wernberg\-Köblitz",
"495662", "Felsberg\ Hessen",
"496527", "Oberweis",
"496453", "Gemünden\ Wohra",
"495425", "Borgholzhausen",
"496708", "Bad\ Münster\ am\ Stein\-Ebernburg",
"495493", "Neuenkirchen\ Kreis\ Vechta",
"497467", "Neuhausen\ ob\ Eck",
"4933834", "Pritzerbe",
"499345", "Külsheim\ Baden",
"495674", "Grebenstein",
"497223", "Bühl\ Baden",
"498225", "Jettingen\-Scheppach",
"498293", "Welden\ bei\ Augsburg",
"498372", "Obergünzburg",
"497668", "Ihringen",
"4936259", "Tabarz\ Thüringer\ Wald",
"496887", "Schmelz\ Saar",
"496743", "Bacharach",
"4939740", "Nechlin",
"498801", "Seeshaupt",
"494366", "Grömitz\-Cismar",
"4934973", "Osternienburg",
"492507", "Havixbeck",
"494140", "Estorf\ Kreis\ Stade",
"498364", "Seeg",
"499736", "Oberthulba",
"493629", "Stadtilm",
"4936084", "Heuthen",
"4939778", "Ferdinandshof\ bei\ Torgelow",
"498330", "Legau",
"496188", "Kahl\ am\ Main",
"495623", "Edertal",
"496655", "Neuhof\ Kreis\ Fulda",
"497552", "Pfullendorf",
"495695", "Twistetal",
"494543", "Nusse",
"498468", "Altmannstein\-Pondorf",
"497274", "Germersheim",
"49208", "Oberhausen\ Rheinland",
"4933337", "Altkünkendorf",
"4933731", "Trebbin",
"499307", "Altertheim",
"493838", "Bergen\ auf\ Rügen",
"4933762", "Zeuthen",
"495063", "Bad\ Salzdetfurth",
"4939923", "Priborn",
"497262", "Eppingen",
"493691", "Eisenach\ Thüringen",
"495377", "Ehra\-Lessien",
"492533", "Münster\-Nienberge",
"495372", "Meinersen",
"499179", "Freystadt",
"4937326", "Frauenstein\ Sachsen",
"4938232", "Zingst\ Ostseebad",
"497423", "Oberndorf\ am\ Neckar",
"4937367", "Lengefeld\ Erzgebirge",
"495293", "Paderborn\-Dahl",
"495225", "Spenge",
"496253", "Fürth\ Odenwald",
"4939973", "Altkalen",
"494159", "Basthorst",
"497267", "Gemmingen",
"495109", "Ronnenberg",
"495364", "Velpke",
"499302", "Rottendorf\ Unterfranken",
"4934651", "Rossla",
"4936207", "Plaue\ Thüringen",
"499871", "Windsbach",
"4939749", "Grambow\ bei\ Pasewalk",
"497557", "Herdwangen\-Schönach",
"4938206", "Graal\-Müritz\ Seeheilbad",
"499721", "Schweinfurt",
"494851", "Marne",
"496563", "Kyllburg",
"4935936", "Sohland\ Spree",
"4934495", "Dobitschen",
"496134", "Mainz\-Kastel",
"498063", "Feldkirchen\-Westerham",
"497340", "Neenstetten",
"4939728", "Medow\ bei\ Anklam",
"4936965", "Stadtlengsfeld",
"498623", "Kirchweidach",
"497166", "Adelberg",
"496346", "Annweiler\ am\ Trifels",
"4939454", "Elbingerode\ Harz",
"492502", "Nottuln",
"4934923", "Cobbelsdorf",
"495468", "Bramsche\-Engter",
"493573", "Senftenberg",
"498377", "Unterthingau",
"494763", "Gnarrenburg",
"492309", "Waltrop",
"499333", "Sommerhausen",
"499088", "Mönchsdeggingen",
"492164", "Jüchen\-Otzenrath",
"4939959", "Dargun",
"4934907", "Jeber\-Bergfrieden",
"493847", "Sternberg",
"492151", "Krefeld",
"499283", "Rehau",
"496329", "Weidenthal\ Pfalz",
"498558", "Hohenau\ Niederbayern",
"496735", "Eppelsheim",
"497462", "Immendingen",
"497625", "Zell\ im\ Wiesental",
"492859", "Wesel\-Bislich",
"496522", "Mettendorf",
"4934921", "Kemberg",
"498268", "Tussenhausen",
"495027", "Linsburg",
"497474", "Haigerloch",
"498662", "Siegsdorf\ Kreis\ Traunstein",
"4933457", "Altreetz",
"494830", "Süderhastedt",
"4935605", "Komptendorf",
"494864", "Oldenswort",
"494535", "Nahe",
"4934653", "Rottleberode",
"497967", "Jagstzell",
"495351", "Helmstedt",
"498022", "Tegernsee",
"496391", "Dahn",
"495925", "Wietmarschen",
"496058", "Gründau",
"499656", "Moosbach\ bei\ Vohenstrauss",
"494872", "Hanerau\-Hademarschen",
"494722", "Cuxhaven\-Altenbruch",
"493921", "Burg\ bei\ Magdeburg",
"499852", "Feuchtwangen",
"4938856", "Pritzier\ bei\ Hagenow",
"4939971", "Gnoien",
"492551", "Steinfurt\-Burgsteinfurt",
"497082", "Neuenbürg\ Württemberg",
"492406", "Herzogenrath",
"492954", "Rüthen\-Oestereiden",
"498158", "Tutzing",
"496231", "Hochdorf\-Assenheim",
"492261", "Gummersbach",
"495283", "Lügde\-Rischenau",
"496122", "Hofheim\-Wallau",
"496449", "Ehringshausen\-Katzenfurt",
"4938852", "Wittenburg",
"497404", "Epfendorf",
"497485", "Empfingen",
"498857", "Benediktbeuern",
"494833", "Wesselburen",
"495656", "Waldkappel",
"496696", "Gilserberg",
"494135", "Kirchgellersen",
"497308", "Nersingen",
"498345", "Stöttwang",
"495852", "Bleckede",
"494802", "Wrohm",
"498685", "Kirchanschöring",
"4938825", "Klütz",
"494371", "Burg\ auf\ Fehmarn",
"499351", "Gemünden\ am\ Main",
"499925", "Bayerisch\ Eisenstein",
"499280", "Selbitz\ Oberfranken",
"4939774", "Mönkebude",
"494606", "Wanderup",
"4936601", "Hermsdorf\ Thüringen",
"4939209", "Wanzleben",
"495302", "Vechelde",
"499364", "Zellingen",
"492133", "Dormagen",
"494559", "Wensin",
"494734", "Stadland\-Seefeld",
"4936603", "Weida",
"495721", "Stadthagen",
"497683", "Simonswald",
"49461", "Flensburg",
"4933838", "Päwesin",
"499372", "Klingenberg\ am\ Main",
"495509", "Rosdorf\ Kreis\ Göttingen",
"496163", "Höchst\ im\ Odenwald",
"497343", "Buch\ bei\ Illertissen",
"494352", "Damp",
"493725", "Zschopau",
"4939859", "Fürstenwerder",
"499293", "Berg\ Oberfranken",
"498034", "Brannenburg",
"497157", "Waldenbuch",
"494269", "Ahausen\-Kirchwalsede",
"499225", "Stadtsteinach",
"496641", "Lauterbach\ Hessen",
"496865", "Mettlach\-Orscholz",
"496534", "Mülheim\ Mosel",
"4937322", "Brand\-Erbisdorf",
"49241", "Aachen",
"492102", "Ratingen",
"495333", "Dettum",
"497566", "Argenbühl",
"4933080", "Marienthal\ Kreis\ Oberhavel",
"492572", "Emsdetten",
"492254", "Weilerswist",
"496426", "Fronhausen",
"496381", "Kusel",
"492961", "Brilon",
"4935932", "Guttau",
"497420", "Deisslingen",
"492835", "Issum",
"492379", "Menden\-Asbeck",
"492564", "Vreden",
"499468", "Zell\ Oberpfalz",
"4938202", "Volkenshagen",
"497256", "Philippsburg",
"499480", "Sünching",
"498721", "Eggenfelden",
"4933766", "Teupitz",
"498302", "Görisried",
"495060", "Bodenburg",
"4933701", "Grossbeeren",
"495034", "Neustadt\-Hagen",
"496588", "Pluwig",
"4936784", "Stützerbach",
"494845", "Ostenfeld\ Husum",
"4934443", "Teuchern",
"498179", "Eurasburg\ an\ der\ Loisach",
"4935797", "Schwepnitz",
"4939821", "Carpin",
"498509", "Ruderting",
"494661", "Niebüll",
"496249", "Guntersblum",
"497204", "Malsch\-Völkersbach",
"494357", "Sehestedt\ Eider",
"498333", "Babenhausen\ Schwaben",
"497044", "Mönsheim",
"497152", "Leonberg\ Württemberg",
"494143", "Drochtersen",
"492461", "Jülich",
"495483", "Lienen",
"492744", "Herdorf",
"499377", "Freudenberg\-Boxtal",
"492206", "Overath",
"496431", "Limburg\ an\ der\ Lahn",
"497746", "Wutöschingen",
"49291", "Meschede",
"4933089", "Himmelpfort",
"493537", "Jessen\ Elster",
"495307", "Braunschweig\-Wenden",
"4933439", "Fredersdorf\-Vogelsdorf",
"4939724", "Klein\ Bünzow",
"499268", "Teuschnitz",
"497220", "Forbach\-Hundsbach",
"496198", "Eppstein",
"497456", "Haiterbach",
"497904", "Ilshofen",
"495158", "Hemeringen",
"4939458", "Heudeber",
"4938875", "Schlagsdorf\ bei\ Gadebusch",
"4937435", "Reuth\ bei\ Plauen",
"497171", "Schwäbisch\ Gmünd",
"496226", "Meckesheim",
"496639", "Ottrau",
"497729", "Tennenbronn",
"495857", "Bleckede\-Brackede",
"492454", "Gangelt",
"496897", "Sulzbach\ Saar",
"498283", "Neuburg\ an\ der\ Kammel",
"494108", "Rosengarten\ Kreis\ Harburg",
"49221", "Cologne",
"497335", "Wiesensteig",
"4933703", "Sperenberg",
"494469", "Wangerooge",
"4934774", "Röblingen\ am\ See",
"499493", "Beratzhausen",
"496127", "Niedernhausen\ Taunus",
"498656", "Anger",
"492358", "Meinerzhagen\-Valbert",
"4939823", "Rechlin",
"4939200", "Gommern",
"493681", "Suhl",
"495345", "Baddeckenstedt",
"4934441", "Hohenmölsen",
"499674", "Schönsee",
"493341", "Strausberg",
"495685", "Knüllwald",
"492843", "Rheinberg",
"49209", "Gelsenkirchen",
"499662", "Vilseck",
"495604", "Grossalmerode",
"492054", "Essen\-Kettwig",
"499927", "Kirchberg\ Wald",
"4939754", "Löcknitz\ Vorpom",
"497754", "Görwihl",
"494838", "Tellingstedt",
"492429", "Hürtgenwald",
"4939428", "Pabstorf",
"498687", "Taching\-Tengling",
"497056", "Gechingen",
"498347", "Friesenried",
"497332", "Lauterstein",
"496050", "Biebergemünd",
"498153", "Wessling",
"494137", "Barendorf",
"499422", "Bogen\ Niederbayern",
"4939266", "Förderstedt",
"4933634", "Berkenbrück\ Kreis\ Oder\-Spree",
"498550", "Philippsreut",
"4937432", "Pausa\ Vogtland",
"4938872", "Rehna",
"499149", "Weissenburg\-Suffersheim",
"4939853", "Holzendorf\ bei\ Prenzlau",
"4938793", "Dergenthin",
"499093", "Polsingen",
"498234", "Bobingen",
"493366", "Beeskow",
"497303", "Illertissen",
"499665", "Königstein\ Oberpfalz",
"4939201", "Wolmirstedt",
"4937293", "Eppendorf\ Sachsen",
"499841", "Bad\ Windsheim",
"494236", "Kirchlinteln",
"495682", "Borken\ Hessen",
"499126", "Eckental",
"494421", "Wilhelmshaven",
"492837", "Weeze",
"495434", "Essen\ Oldenburg",
"4938791", "Bad\ Wilsnack",
"4937291", "Augustusburg",
"4939203", "Barleben",
"4939820", "Triepkendorf",
"497348", "Beimerstetten",
"498384", "Röthenbach\ Allgäu",
"494646", "Mohrkirch",
"499080", "Harburg\ Schwaben",
"4937463", "Bergen\ Vogtland",
"4939851", "Göritz\ bei\ Prenzlau",
"496867", "Perl",
"494936", "Grossheide",
"497853", "Kehl\-Bodersweier",
"494842", "Nordstrand",
"498531", "Pocking",
"4939388", "Goldbeck\ Altm",
"499227", "Neuenmarkt",
"493727", "Mittweida",
"492446", "Heimbach\ Eifel",
"496031", "Friedberg\ Hessen",
"499463", "Wald\ Oberpfalz",
"493877", "Wittenberge",
"494499", "Barssel",
"497761", "Bad\ Säckingen",
"497444", "Alpirsbach",
"496409", "Biebertal",
"492621", "Lahnstein",
"495083", "Hohne\ bei\ Celle",
"493535", "Herzberg\ Elster",
"495305", "Sickte",
"499131", "Erlangen",
"495384", "Seesen\-Gross\ Rhüden",
"496583", "Palzem",
"4936734", "Leutenberg",
"498460", "Berching\-Holnstein",
"4937325", "Niederbobritzsch",
"498434", "Rennertshofen",
"495644", "Willebadessen\-Peckelsheim",
"4938205", "Tessin\ bei\ Rostock",
"494524", "Scharbeutz\-Pönitz",
"499375", "Freudenberg\ Baden",
"492803", "Wesel\-Büderich",
"495531", "Holzminden",
"4934496", "Nöbdenitz",
"4935935", "Kleinwelka",
"493301", "Oranienburg",
"4934203", "Zwenkau",
"499222", "Presseck",
"495934", "Haren\-Rütenbrock",
"494921", "Emden\ Stadt",
"492291", "Waldbröl",
"4939829", "Blankenförde",
"494355", "Rieseby",
"493722", "Limbach\-Oberfrohna",
"497634", "Sulzburg",
"496026", "Grossostheim",
"497541", "Friedrichshafen",
"497660", "St\ Peter\ Schwarzwald",
"494847", "Oster\-Ohrstedt",
"499628", "Ursensollen",
"4939058", "Uthmöden",
"497944", "Kupferzell",
"4936927", "Unterellen",
"496666", "Freiensteinau",
"492575", "Greven\-Reckenfeld",
"4936966", "Kaltennordheim",
"492636", "Burgbrohl",
"498083", "Isen",
"498338", "Böhen",
"496874", "Wadern\-Nunkirchen",
"4934637", "Frankleben",
"49201", "Essen",
"494148", "Drochtersen\-Assel",
"4933433", "Buckow\ Märkische\ Schweiz",
"499963", "Konzell",
"49771", "Donaueschingen",
"4933608", "Jacobsdorf\ Mark",
"496724", "Stromberg\ Hunsrück",
"4933984", "Blumenthal\ bei\ Pritzwalk",
"492832", "Kevelaer",
"499553", "Ebrach\ Oberfranken",
"494103", "Wedel",
"496049", "Kefenrod",
"499394", "Esselbach",
"4933083", "Schulzendorf\ Kreis\ Oberhavel",
"497244", "Weingarten\ Baden",
"497085", "Enzklösterle",
"496209", "Mörlenbach",
"495347", "Burgdorf\ bei\ Salzgitter",
"499263", "Ludwigsstadt",
"495153", "Salzhemmendorf",
"493763", "Glauchau",
"497706", "Oberbaldingen",
"499427", "Leiblfing",
"497482", "Horb\-Dettingen",
"4938822", "Diedrichshagen\ bei\ Grevesmühlen",
"492246", "Lohmar\ Rheinland",
"497337", "Nellingen\ Alb",
"498342", "Marktoberdorf",
"494132", "Amelinghausen",
"496773", "Kamp\-Bornhofen",
"495855", "Nahrendorf",
"495769", "Steyerberg\-Voigtei",
"4935606", "Briesen\ bei\ Cottbus",
"498549", "Vilshofen\-Pleinting",
"494884", "Schwabstedt",
"499498", "Laaber",
"498682", "Laufen\ Salzach",
"494805", "Schafstedt",
"49385", "Schwerin",
"4938855", "Lübtheen",
"492594", "Dülmen",
"494221", "Delmenhorst",
"492353", "Halver",
"492991", "Marsberg\-Bredelar",
"499922", "Zwiesel",
"495234", "Horn\-Bad\ Meinberg",
"4936378", "Ostramondra",
"499153", "Schnaittach",
"492774", "Dietzhölztal",
"499347", "Wittighausen",
"495263", "Barntrup",
"4939929", "Jabel\ bei\ Waren",
"497465", "Emmingen\-Liptingen",
"4935602", "Drebkau",
"492824", "Kalkar",
"495427", "Melle\-Buer",
"494173", "Wulfsen",
"4934920", "Kropstädt",
"494503", "Timmendorfer\ Strand",
"496732", "Wörrstadt",
"49228", "Bonn",
"4935342", "Mühlberg\ Elbe",
"495553", "Kalefeld",
"496525", "Irrel",
"492762", "Wenden\ Südsauerland",
"497622", "Schopfheim",
"496593", "Hillesheim\ Eifel",
"4934262", "Falkenhain\ bei\ Wurzen",
"497062", "Beilstein\ Württemberg",
"497826", "Schuttertal",
"494532", "Bargteheide",
"4934979", "Wulfen\ Sachsen\-Anhalt",
"498841", "Murnau\ am\ Staffelsee",
"496458", "Rosenthal\ Hessen",
"496703", "Wöllstein\ Rheinhessen",
"498665", "Inzell",
"495922", "Bad\ Bentheim",
"498025", "Miesbach",
"496190", "Hattersheim\ am\ Main",
"498093", "Glonn\ Kreis\ Ebersberg",
"499234", "Neusorg",
"497228", "Forbach",
"499260", "Wilhelmsthal\ Oberfranken",
"4934743", "Ermsleben",
"494339", "Christiansholm",
"494875", "Stafstedt",
"4936484", "Knau\ bei\ Pössneck",
"49361", "Erfurt",
"492547", "Rosendahl\-Osterwick",
"4939384", "Arendsee\ Altmark",
"4936253", "Georgenthal\ Thüringer\ Wald",
"4938826", "Dassow",
"498422", "Dollnstein",
"494793", "Hambergen",
"499855", "Dentlein\ am\ Forst",
"494725", "Helgoland",
"499531", "Ebern",
"499644", "Pressath",
"4934741", "Frose",
"495839", "Wittingen\-Ohrdorf",
"495375", "Müden\ Aller",
"4933638", "Rüdersdorf\ bei\ Berlin",
"4936962", "Vacha",
"494289", "Kirchtimke",
"4934347", "Oelzschau\ bei\ Borna",
"495222", "Bad\ Salzuflen",
"496183", "Erlensee",
"4934607", "Wettin",
"499384", "Schwanfeld",
"495131", "Garbsen",
"493371", "Luckenwalde",
"497023", "Weilheim\ an\ der\ Teck",
"494124", "Glückstadt",
"499305", "Estenfeld",
"492873", "Isselburg\-Werth",
"492723", "Kirchhundem",
"497663", "Eichstetten",
"493606", "Heiligenstadt\ Heilbad",
"496657", "Hofbieber",
"493969", "Siedenbollentin",
"4935267", "Diesbar\-Seusslitz",
"497141", "Ludwigsburg\ Württemberg",
"496361", "Rockenhausen",
"495963", "Bawinkel",
"492981", "Winterberg\ Westfalen",
"4934953", "Gräfenhainichen",
"4939424", "Schwanebeck\ Sachsen\-Anhalt",
"492175", "Leichlingen\ Rheinland",
"492505", "Altenberge\ Westfalen",
"4939887", "Gerswalde",
"492584", "Warendorf\-Milte",
"4934492", "Lucka",
"496580", "Zemmer",
"4936704", "Steinheid",
"498463", "Greding",
"496804", "Mandelbachtal",
"495068", "Elze\ Leine",
"497586", "Herbertingen",
"492331", "Hagen\ Westfalen",
"4933765", "Märkisch\ Buchholz",
"499526", "Riedbach",
"498222", "Burgau\ Schwaben",
"4933847", "Görzke",
"494681", "Wyk\ auf\ Föhr",
"498375", "Weitnau",
"496568", "Wolsfeld",
"499434", "Bodenwöhr",
"4934659", "Blankenheim\ bei\ Sangerhausen",
"4939607", "Kotelow",
"492538", "Drensteinfurt\-Rinkerode",
"495126", "Algermissen",
"4939347", "Kade",
"497428", "Rosenfeld",
"496258", "Gernsheim",
"498131", "Dachau",
"4939741", "Jatznick",
"4936374", "Weissensee",
"494768", "Hipstedt",
"497555", "Deggenhausertal",
"495692", "Wolfhagen",
"496652", "Hünfeld",
"497324", "Herbrechtingen",
"496856", "St\ Wendel\-Niederkirchen",
"499338", "Röttingen\ Unterfranken",
"4934671", "Bad\ Frankenhausen\ Kyffhäuser",
"49631", "Kaiserslautern",
"499083", "Möttingen",
"496479", "Waldbrunn\ Westerwald",
"497265", "Angelbachtal",
"4934424", "Reuden\ bei\ Zeitz",
"4939953", "Schwinkendorf",
"498628", "Kienberg\ Oberbayern",
"493578", "Kamenz",
"4938876", "Roggendorf",
"4937436", "Weischlitz",
"492542", "Gescher",
"496306", "Trippstadt",
"4939054", "Flechtingen",
"4939951", "Faulenrost",
"4939262", "Güsten\ Anh",
"498427", "Wellheim",
"492689", "Dierdorf",
"499090", "Rain\ Lech",
"497300", "Roggenburg",
"498263", "Breitenbrunn\ Schwaben",
"497139", "Neuenstadt\ am\ Kocher",
"498394", "Lautrach",
"499288", "Bad\ Steben",
"497965", "Ellwangen\-Röhlingen",
"497831", "Hausach",
"4934929", "Straach",
"494537", "Sülfeld\ Holstein",
"498553", "Spiegelau",
"4934673", "Heldrungen",
"4933477", "Trebnitz\ bei\ Müncheberg",
"4933604", "Lebus",
"496053", "Wächtersbach",
"495025", "Estorf\ Weser",
"4934384", "Grossbothen",
"495841", "Lüchow\ Wendland",
"497627", "Steinen\ Kreis\ Lörrach",
"499682", "Erbendorf",
"4936738", "Königsee",
"495665", "Guxhagen",
"4939743", "Zerrenthin",
"499549", "Lisberg",
"494489", "Apen",
"497373", "Zwiefalten",
"496737", "Köngernheim",
"495422", "Melle",
"493661", "Greiz",
"499342", "Wertheim",
"495149", "Wienhausen",
"4933702", "Wünsdorf",
"496274", "Waldbrunn\ Odenwald",
"496781", "Idar\-Oberstein",
"498707", "Adlkofen",
"497655", "Feldberg\-Altglashütten",
"495592", "Gleichen\-Bremke",
"496552", "Olzheim",
"492779", "Greifenstein\-Beilstein",
"4939822", "Kratzeburg",
"492232", "Brühl\ Rheinland",
"496262", "Aglasterhausen",
"494247", "Affinghausen",
"499192", "Gräfenberg",
"4935248", "Schönfeld\ bei\ Grossenhain",
"496359", "Grünstadt",
"495733", "Vlotho",
"49212", "Solingen",
"496028", "Sulzbach\ am\ Main",
"492203", "Cologne\-Porz",
"49395", "Neubrandenburg",
"4939855", "Parmen\-Weggun",
"499772", "Bischofsheim\ an\ der\ Rhön",
"499626", "Hohenburg",
"492043", "Gladbeck",
"497743", "Ühlingen\-Birkendorf",
"494752", "Neuhaus\ Oste",
"499822", "Bechhofen\ an\ der\ Heide",
"496668", "Birstein\-Lichenroth",
"4939998", "Loitz\ bei\ Demmin",
"498336", "Erkheim",
"492638", "Waldbreitbach",
"4937295", "Lugau\ Erzgebirge",
"495702", "Petershagen\-Lahde",
"499764", "Höchheim",
"499441", "Kelheim",
"494146", "Stade\-Bützfleth",
"492948", "Lippstadt\-Rebbeke",
"494334", "Bredenbek\ bei\ Rendsburg",
"4933964", "Fretzdorf",
"495321", "Goslar",
"495955", "Esterwegen",
"498052", "Aschau\ im\ Chiemgau",
"498144", "Grafrath",
"494284", "Selsingen",
"494771", "Hemmoor",
"492903", "Meschede\-Freienohl",
"494205", "Ottersberg",
"4939205", "Langenweddingen",
"497527", "Wolfegg",
"494821", "Itzehoe",
"495565", "Einbeck\-Wenzen",
"495834", "Wittingen\-Knesebeck",
"496467", "Hatzfeld\ Eder",
"498071", "Wasserburg\ am\ Inn",
"4934976", "Gröbzig",
"497453", "Altensteig\ Württemberg",
"494442", "Lohne\ Oldenburg",
"497708", "Geisingen\-Leipferdingen",
"498745", "Bodenkirchen",
"493964", "Bredenfelde\ bei\ Strasburg",
"4937465", "Tannenbergsthal\ Vogtland",
"493561", "Guben",
"496295", "Rosenberg\ Baden",
"496223", "Neckargemünd",
"495255", "Altenbeken",
"495182", "Gronau\ Leine",
"499165", "Sugenheim",
"492248", "Hennef\-Uckerath",
"494129", "Haseldorf",
"492642", "Remagen",
"4937430", "Eichigt",
"492932", "Neheim\-Hüsten",
"496101", "Bad\ Vilbel",
"496571", "Wittlich",
"4935877", "Cunewalde",
"494947", "Aurich\-Ogenbargen",
"494191", "Kaltenkirchen\ Holstein",
"4938848", "Vellahn",
"4939926", "Grabowhöfe",
"492382", "Ahlen\ Westfalen",
"494637", "Sterup",
"497844", "Rheinau",
"496809", "Grossrosseln",
"494632", "Steinbergkirche",
"498860", "Bernbeuren",
"495286", "Ottenstein\ Niedersachsen",
"4937323", "Lichtenberg\ Erzgebirge",
"498565", "Dietersburg\-Baumgarten",
"493741", "Plauen",
"493464", "Sangerhausen",
"494942", "Südbrookmerland",
"497953", "Blaufelden",
"497391", "Ehingen\ Donau",
"4939976", "Gross\ Bützin",
"492387", "Drensteinfurt\-Walstedde",
"4938851", "Zarrentin",
"494836", "Hennstedt\ Dithmarschen",
"499241", "Pegnitz",
"4935827", "Nieder\-Seifersdorf",
"492937", "Arnsberg\-Oeventrop",
"49351", "Dresden",
"4935933", "Neschwitz",
"495071", "Schwarmstedt",
"4934205", "Markranstädt",
"492647", "Kesseling",
"492758", "Bad\ Berleburg\-Girkhausen",
"492403", "Eschweiler\ Rheinland",
"499439", "Neunburg\-Kemnath",
"495745", "Stemwede\-Levern",
"4939397", "Geestgottberg",
"4938203", "Bad\ Doberan",
"495187", "Delligsen",
"497329", "Steinheim\ am\ Albuch",
"4934926", "Pretzsch\ Elbe",
"4936602", "Ronneburg\ Thüringen",
"496462", "Gladenbach",
"494603", "Havetoft",
"497735", "Öhningen",
"494447", "Vechta\-Langförden",
"496625", "Niederaula",
"4937439", "Jocketa",
"495653", "Sontra",
"497522", "Wangen\ im\ Allgäu",
"496693", "Neuental",
"492432", "Wassenberg",
"4933435", "Rehfelde",
"496474", "Villmar\-Aumenau",
"494238", "Neddenaverbergen",
"4935324", "Crinitz",
"496340", "Wörth\-Schaidt",
"499128", "Feucht",
"498057", "Aschau\-Sachrang",
"497134", "Weinsberg",
"4933085", "Seilershof",
"497346", "Illerkirchberg",
"496166", "Fischbachtal",
"492605", "Löf",
"492684", "Puderbach\ Westerwald",
"495707", "Petershagen\ Weser",
"498592", "Wegscheid\ Niederbayern",
"499827", "Lichtenau\ Mittelfranken",
"4933394", "Blumberg\ Kreis\ Barnim",
"4938754", "Leussow\ bei\ Ludwigslust",
"495528", "Gieboldehausen",
"498733", "Mengkofen",
"494757", "Wanna",
"4938428", "Hohenkirchen\ bei\ Wismar",
"494938", "Hagermarsch",
"499777", "Ostheim\ von\ der\ Rhön",
"499631", "Tirschenreuth",
"4934656", "Wallhausen\ Sachsen\-Anhalt",
"496423", "Wetter\ Hessen",
"495455", "Tecklenburg\-Brochterbeck",
"499544", "Baunach",
"492448", "Hellenthal\-Rescheid",
"496267", "Fahrenbach\ Baden",
"4938201", "Gelbensande",
"499941", "Kötzting",
"4935931", "Königswartha",
"497253", "Bad\ Schönborn",
"494242", "Syke",
"499197", "Egloffstein",
"4937321", "Frankenstein\ Sachsen",
"4938227", "Lüdershagen\ bei\ Barth",
"495052", "Hermannsburg",
"495144", "Wathlingen",
"492237", "Kerpen\ Rheinland\-Türnich",
"496092", "Heimbuchenthal",
"498321", "Sonthofen",
"495336", "Semmenstedt",
"497563", "Kisslegg",
"494484", "Hude\-Wüsting",
"4938853", "Drönnewitz\ bei\ Hagenow",
"496557", "Hallschlag",
"494405", "Edewecht",
"49345", "Halle\ Saale",
"498702", "Wörth\ an\ der\ Isar",
"497534", "Reichenau\ Baden",
"495827", "Unterlüss",
"492424", "Vettweiss",
"497641", "Emmendingen",
"4934652", "Allstedt",
"499528", "Donnersdorf",
"498192", "Schondorf\ am\ Ammersee",
"495777", "Diepenau\-Essern",
"496566", "Körperich",
"492675", "Ediger\-Eller",
"497931", "Bad\ Mergentheim",
"497381", "Münsingen",
"492536", "Münster\-Albachten",
"497250", "Kraichtal",
"4938844", "Gülze",
"497426", "Gosheim",
"4938231", "Barth",
"495128", "Hohenhameln",
"496256", "Lampertheim\-Hüttenfeld",
"496420", "Lahntal",
"493635", "Kölleda",
"499144", "Pleinfeld",
"494766", "Basdahl",
"496683", "Ehrenberg\ Rhön",
"498441", "Pfaffenhofen\ an\ der\ Ilm",
"498764", "Mauern\ Kreis\ Freising",
"496858", "Ottweiler\-Fürth",
"499336", "Bütthard",
"495544", "Reinhardshagen",
"494624", "Kropp",
"498822", "Oberammergau",
"4936255", "Goldbach\ bei\ Gotha",
"495631", "Korbach",
"498066", "Bad\ Feilnbach",
"496157", "Pfungstadt",
"494475", "Molbergen",
"495197", "Soltau\-Frielingen",
"498772", "Mallersdorf\-Pfaffenberg",
"497163", "Ebersbach\ an\ der\ Fils",
"496343", "Bad\ Bergzabern",
"4934745", "Winningen\ Sachsen\-Anhalt",
"498239", "Langenneufnach",
"495941", "Neuenhaus\ Dinkel",
"493576", "Weisswasser",
"496308", "Olsbrücken",
"498165", "Neufahrn\ bei\ Freising",
"498389", "Weissensberg",
"4935600", "Döbern\ NL",
"499745", "Wildflecken",
"499071", "Dillingen\ an\ der\ Donau",
"495650", "Cornberg",
"4936606", "Kraftsdorf",
"495439", "Bersenbrück",
"4934922", "Mühlanger",
"498649", "Schleching",
"498582", "Röhrnbach",
"4939994", "Metschow",
"499286", "Oberkotzau",
"498751", "Mainburg",
"492694", "Wershofen",
"4933968", "Meyenburg\ Kreis\ Prignitz",
"495241", "Gütersloh",
"492473", "Simmerath",
"494494", "Bösel\ Oldenburg",
"4938233", "Prerow\ Ostseebad",
"499653", "Eslarn",
"4934955", "Gossa",
"4934364", "Wermsdorf",
"494673", "Joldelund",
"4939972", "Walkendorf",
"497231", "Pforzheim",
"496082", "Niederreifenberg",
"493433", "Borna\ Stadt",
"4935244", "Krögis",
"494327", "Grossenaspe",
"499187", "Altdorf\ bei\ Nürnberg",
"497950", "Schnelldorf",
"497122", "St\ Johann\ Württemberg",
"496485", "Nentershausen\ Westerwald",
"493907", "Gardelegen",
"497449", "Baiersbronn\-Obertal",
"496404", "Lich\ Hessen",
"492973", "Eslohe\ Sauerland",
"493902", "Diesdorf\ Altm",
"494275", "Ehrenburg",
"498650", "Marktschellenberg",
"495165", "Rethem\ Aller",
"494322", "Bordesholm",
"493869", "Dümmer",
"4933763", "Bestensee",
"497127", "Neckartenzlingen",
"499182", "Velburg",
"499255", "Marktleugast",
"495939", "Sustrum",
"498241", "Buchloe",
"4939922", "Dambeck\ bei\ Röbel",
"496087", "Waldems",
"494529", "Süsel\-Bujendorf",
"499565", "Untersiemau",
"499834", "Theilenhofen",
"495751", "Rinteln",
"4934446", "Grosskorbetha",
"4935609", "Drachhausen",
"495582", "Sankt\ Andreasberg",
"497949", "Pfedelbach\-Untersteinbach",
"496456", "Haina\ Kloster",
"493643", "Weimar\ Thüringen",
"492365", "Marl",
"496220", "Wilhelmsfeld",
"496171", "Oberursel\ Taunus",
"496501", "Konz",
"497226", "Bühl\-Sand",
"493933", "Genthin",
"4936464", "Wormstedt",
"495863", "Zernien",
"4938758", "Dömitz",
"4933398", "Werneuchen",
"4939955", "Jürgenstorf",
"496335", "Trulben",
"4939364", "Dolle",
"4938424", "Bobitz",
"492224", "Bad\ Honnef",
"495192", "Munster",
"496285", "Walldürn\-Altheim",
"496044", "Schotten\ Hessen",
"496152", "Gross\-Gerau",
"494363", "Lensahn",
"497249", "Stutensee",
"496204", "Viernheim",
"499733", "Münnerstadt",
"497431", "Albstadt\-Ebingen",
"498296", "Villenbach",
"492521", "Beckum",
"492924", "Möhnesee",
"494294", "Riede\ Kreis\ Verden",
"496746", "Pfalzfeld",
"4936969", "Merkers",
"4939745", "Hetzdorf\ bei\ Strasburg",
"495764", "Steyerberg",
"495441", "Diepholz",
"492273", "Kerpen\-Horrem",
"494975", "Westerholt\ Ostfriesland",
"499321", "Kitzingen",
"499955", "Mamming",
"4939826", "Blankensee\ bei\ Neustrelitz",
"492392", "Werdohl",
"494181", "Buchholz\ in\ der\ Nordheide",
"495626", "Bad\ Zwesten",
"495772", "Espelkamp",
"494546", "Mustin\ Lauenburg",
"493445", "Naumburg\ Saale",
"4933367", "Friedrichswalde\ Brandenburg",
"498544", "Eging\ am\ See",
"4933732", "Hennickendorf\ bei\ Luckenwalde",
"492599", "Ascheberg\-Herbern",
"495822", "Ebstorf",
"498631", "Mühldorf\ am\ Inn",
"495066", "Sarstedt",
"497031", "Böblingen",
"496282", "Walldürn",
"494477", "Lastrup\-Hemmelte",
"496155", "Griesheim\ Hessen",
"495123", "Schellerten",
"495195", "Neuenkirchen\ bei\ Soltau",
"492440", "Nettersheim\-Tondorf",
"4939742", "Brüssow\ bei\ Pasewalk",
"496444", "Bischoffen",
"496761", "Simmern\ Hunsrück",
"499523", "Hofheim\ in\ Unterfranken",
"493947", "Thale",
"494972", "Langeoog",
"493771", "Aue\ Sachsen",
"499271", "Thurnau\-Alladorf",
"4939263", "Unseburg",
"494251", "Hoya",
"492323", "Herne",
"492395", "Finnentrop\-Rönkhausen",
"4939856", "Beenz\ bei\ Prenzlau",
"499120", "Leinburg",
"495466", "Merzen",
"499952", "Eichendorf",
"493821", "Ribnitz\-Damgarten",
"4933760", "Münchehofe\ Kreis\ Dahme\-Spreewald",
"496348", "Offenbach\ an\ der\ Queich",
"494964", "Rhede\ Ems",
"492677", "Lutzerath",
"495041", "Springe\ Deister",
"495201", "Halle\ Westfalen",
"4938796", "Viesecke",
"495775", "Diepenau",
"496853", "Marpingen",
"495825", "Wieren",
"4937296", "Stollberg\ Erzgebirge",
"4934672", "Rossleben",
"495520", "Braunlage",
"494561", "Neustadt\ in\ Holstein",
"499086", "Fremdingen",
"499971", "Cham",
"494554", "Wahlstedt",
"493984", "Prenzlau",
"494272", "Siedenburg",
"499185", "Mühlhausen\ Oberpfalz",
"499252", "Helmbrechts",
"498556", "Haidmühle",
"494393", "Boostedt",
"494951", "Weener",
"493581", "Görlitz",
"499369", "Uettingen",
"499574", "Marktzeuln",
"4939206", "Eichenbarleben",
"499104", "Emskirchen",
"495162", "Fallingbostel",
"494230", "Verden\-Walle",
"495901", "Fürstenau\ bei\ Bramsche",
"496303", "Enkenbach\-Alsenborn",
"494264", "Sottrum\ Kreis\ Rotenburg",
"498039", "Rott\ am\ Inn",
"4939952", "Grammentin",
"495585", "Herzberg\-Sieber",
"4934975", "Görzig\ Kreis\ Köthen",
"493334", "Eberswalde",
"498266", "Kirchheim\ in\ Schwaben",
"495174", "Lahstedt",
"499562", "Sonnefeld",
"495504", "Friedland\ Kreis\ Göttingen",
"49760", "Oberried\ Breisgau",
"497376", "Langenenslingen",
"492362", "Dorsten",
"4938308", "Göhren\ Rügen",
"496754", "Martinstein",
"498868", "Schwabsoien",
"492374", "Iserlohn\-Letmathe",
"4938728", "Domsühl",
"496056", "Bad\ Soden\-Salmünster",
"492750", "Diedenshausen",
"499747", "Geroda\ Bayern",
"499658", "Georgenberg",
"4938454", "Kritzkow",
"4939925", "Wredenhagen",
"498167", "Zolling",
"496332", "Zweibrücken",
"495556", "Lindau\ Harz",
"496596", "Üdersdorf",
"497773", "Bodman\-Ludwigshafen",
"4939975", "Thürkow",
"496337", "Grossbundenbach",
"497823", "Seelbach\ Schutter",
"499742", "Kalbach\ Rhön",
"4934261", "Kühren\ bei\ Wurzen",
"495401", "Georgsmarienhütte",
"4934206", "Rötha",
"499156", "Neuhaus\ an\ der\ Pegnitz",
"4934493", "Gössnitz\ Thüringen",
"494451", "Varel\ Jadebusen",
"498585", "Grainet",
"498504", "Tittling",
"495266", "Lemgo\-Kirchheide",
"492367", "Henrichenburg",
"4935341", "Bad\ Liebenwerda",
"494506", "Stockelsdorf\-Krumbeck",
"494176", "Marschacht",
"4935601", "Peitz",
"499471", "Burglengenfeld",
"4934925", "Bad\ Schmiedeberg",
"499567", "Sesslach\-Gemünda",
"492651", "Mayen",
"4936963", "Dorndorf\ Rhön",
"4937344", "Crottendorf\ Sachsen",
"496244", "Westhofen\ Rheinhessenen",
"496085", "Waldsolms",
"494796", "Teufelsmoor",
"496004", "Lich\-Eberstadt",
"4937604", "Mosel",
"4933436", "Prötzel",
"497125", "Bad\ Urach",
"496706", "Wallhausen\ Nahe",
"497193", "Sulzbach\ an\ der\ Murr",
"499257", "Zell\ Oberfranken",
"495167", "Walsrode\-Westenholz",
"496482", "Runkel",
"494277", "Schwaförden",
"496541", "Traben\-Trarbach",
"496660", "Steinau\-Marjoss",
"496634", "Gemünden\ Felda",
"497026", "Lenningen",
"497666", "Denzlingen",
"492672", "Treis\-Karden",
"493447", "Altenburg\ Thüringen",
"493603", "Bad\ Langensalza",
"4933086", "Grieben\ Kreis\ Oberhavel",
"498195", "Weil\ Kreis\ Landsberg\ am\ Lech",
"496020", "Heigenbrücken",
"498123", "Moosinning",
"4934742", "Sylda",
"497724", "St\ Georgen\ im\ Schwarzwald",
"492664", "Rennerod",
"4936252", "Tambach\-Dietharz",
"494977", "Blomberg\ Ostfriesland",
"496186", "Grosskrotzenburg",
"492630", "Mülheim\-Kärlich",
"4936961", "Bad\ Liebenstein",
"49671", "Bad\ Kreuznach",
"499738", "Rottershausen",
"4934491", "Schmölln\ Thüringen",
"493632", "Sondershausen",
"498466", "Denkendorf\ Oberbayern",
"493836", "Wolgast",
"4935603", "Burg\ Spreewald",
"497583", "Bad\ Schussenried",
"494741", "Nordholz\ bei\ Bremerhaven",
"494464", "Wittmund\-Carolinensiel",
"4935343", "Hirschfeld\ bei\ Elsterwerda",
"49451", "Lübeck",
"498825", "Krün",
"495966", "Meppen\-Apeldorn",
"499452", "Langquaid",
"495609", "Ahnatal",
"498041", "Bad\ Tölz",
"4934263", "Hohburg",
"4933769", "Töpchin",
"4938334", "Grammendorf",
"496287", "Limbach\ Baden",
"494472", "Lastrup",
"4938304", "Garz\ Rügen",
"495957", "Lindern\ Oldenburg",
"497361", "Aalen",
"493494", "Wolfen",
"492602", "Montabaur",
"496849", "Kirkel",
"497804", "Oppenau",
"493327", "Werder\ Havel",
"498457", "Vohburg\ an\ der\ Donau",
"494433", "Dötlingen",
"4938724", "Siggelkow",
"4936764", "Neuhaus\-Schierschnitz",
"496586", "Beuren\ Hochwald",
"4938458", "Zehna",
"492633", "Brohl\-Lützing",
"498086", "Buchbach\ Oberbayern",
"495452", "Mettingen\ Westfalen",
"499966", "Wiesenfelden",
"4937320", "Mulda\ Sachsen",
"494245", "Neuenkirchen\ bei\ Bassum",
"497183", "Rudersberg\ Württemberg",
"4969", "Frankfurt\ am\ Main",
"492943", "Erwitte",
"4933082", "Menz\ Kreis\ Oberhavel",
"496095", "Bessenbach",
"495055", "Fassberg",
"496023", "Alzenau\ in\ Unterfranken",
"4935207", "Moritzburg",
"492208", "Niederkassel",
"4934746", "Giersleben",
"4937757", "Rittersgrün",
"497657", "Eisenbach\ Hochschwarzwald",
"498705", "Altfraunhofen",
"4935930", "Seitschen",
"497748", "Grafenhausen\ Hochschwarzwald",
"498271", "Meitingen",
"494402", "Rastede",
"496663", "Steinau\ an\ der\ Strasse",
"4936256", "Wechmar",
"4938823", "Selmsdorf",
"498784", "Hohenthann",
"498562", "Triftern",
"499266", "Mitwitz",
"495156", "Coppenbrügge",
"4936605", "Bad\ Köstritz",
"497458", "Ebhausen",
"497703", "Bonndorf\ im\ Schwarzwald",
"494635", "Sörup",
"496196", "Bad\ Soden\ am\ Taunus",
"496228", "Schönau\ Odenwald",
"4938821", "Lüdersdorf",
"495471", "Bohmte",
"494945", "Grossefehn\-Timmel",
"492243", "Eitorf",
"498104", "Sauerlach",
"498574", "Wittibreut",
"498369", "Rückholz",
"499556", "Geiselwind",
"493624", "Ohrdruf",
"4933432", "Müncheberg",
"498252", "Schrobenhausen",
"4938850", "Gammelin",
"494106", "Quickborn\ Kreis\ Pinneberg",
"499401", "Neutraubling",
"495742", "Preussisch\ Oldendorf",
"493475", "Lutherstadt\ Eisleben",
"499167", "Oberscheinfeld",
"496297", "Ravenstein\ Baden",
"495257", "Hövelhof",
"496074", "Rödermark",
"497732", "Radolfzell\ am\ Bodensee",
"496465", "Breidenbach\ bei\ Biedenkopf",
"4934956", "Zörbig",
"49281", "Wesel",
"492435", "Erkelenz\-Lövenich",
"499868", "Schillingsfürst",
"497525", "Aulendorf",
"496776", "Dachsenhausen",
"496622", "Bebra",
"4934202", "Delitzsch",
"496062", "Erbach\ Odenwald",
"497354", "Erolzheim",
"496826", "Bexbach",
"494207", "Oyten",
"494202", "Achim\ bei\ Bremen",
"4935434", "Altdöbern",
"499901", "Hengersberg\ Bayern",
"497053", "Bad\ Teinach\-Zavelstein",
"494154", "Trittau",
"492753", "Erndtebrück",
"492408", "Aachen\-Kornelimünster",
"499504", "Stadelhofen",
"495562", "Dassel\-Markoldendorf",
"499174", "Hilpoltstein",
"496627", "Nentershausen\ Hessen",
"4938859", "Alt\ Zachun",
"498742", "Velden\ Vils",
"494445", "Visbek\ Kreis\ Vechta",
"493546", "Lübben\ Spreewald",
"495971", "Rheine",
"4934445", "Stössen",
"496373", "Schönenberg\-Kübelberg",
"497958", "Rot\ Am\ See\-Brettheim",
"499162", "Scheinfeld",
"495574", "Oberweser",
"495252", "Bad\ Lippspringe",
"495185", "Duingen",
"496292", "Seckach",
"496698", "Schrecksbach",
"495883", "Lemgow",
"492861", "Borken\ Westfalen",
"495658", "Wehretal",
"492645", "Vettelschoss",
"497306", "Vöhringen\ Iller",
"4939202", "Gross\ Ammensleben",
"496139", "Budenheim",
"498257", "Inchenhofen",
"494233", "Blender",
"497671", "Todtnau",
"492935", "Sundern\-Hachen",
"492385", "Hamm\-Rhynern",
"4939956", "Neukalen",
"4938871", "Mühlen\ Eichsen",
"4937431", "Mehltheuer\ Vogtland",
"4937462", "Rothenkirchen\ Vogtland",
"492304", "Schwerte",
"496831", "Saarlouis",
"494608", "Handewitt",
"496555", "Bleialf",
"495523", "Bad\ Sachsa",
"494407", "Wardenburg",
"494643", "Gelting\ Angeln",
"497652", "Hinterzarten",
"4938873", "Carlow",
"4937433", "Gutenfürst",
"494933", "Dornum\ Ostfriesland",
"4937608", "Waldenburg\ Sachsen",
"49731", "Ulm\ Donau",
"492235", "Erftstadt",
"4939852", "Schönermark\ bei\ Prenzlau",
"496324", "Hassloch",
"4937348", "Oberwiesenthal\ Kurort",
"499123", "Lauf\ an\ der\ Pegnitz",
"4938792", "Lenzen\ \(Elbe\)",
"499195", "Adelsdorf\ Mittelfranken",
"496265", "Billigheim\ Baden",
"493591", "Bautzen",
"494383", "Grebin",
"493994", "Malchin",
"495457", "Hopsten\-Schale",
"4937292", "Oederan",
"499201", "Gesees",
"499775", "Schönau\ an\ der\ Brend",
"494902", "Jemgum\-Ditzum",
"4939825", "Wokuhl",
"4939746", "Krackow",
"4938209", "Sanitz\ bei\ Rostock",
"497568", "Bad\ Wurzach\-Hauerz",
"495086", "Celle\-Scheuen",
"498452", "Geisenfeld",
"499825", "Herrieden",
"4935939", "Hochkirch",
"494755", "Ihlienworth",
"493322", "Falkensee",
"495271", "Höxter",
"496428", "Stadtallendorf",
"495705", "Petershagen\-Windheim",
"4937329", "Grosshartmannsdorf",
"492443", "Mechernich",
"492607", "Kobern\-Gondorf",
"498055", "Halfing",
"499466", "Stamsried",
"495952", "Sögel",
"498679", "Burgkirchen\ an\ der\ Alz",
"494161", "Buxtehude",
"497258", "Oberderdingen\-Flehingen",
"493529", "Heidenau\ Sachsen",
"499099", "Kaisheim",
"4939086", "Jävenitz",
"497309", "Weissenhorn",
"497164", "Boll\ Kreis\ Göppingen",
"496344", "Schwegenheim",
"4938733", "Karbow\-Vietlübbe",
"497130", "Löwenstein\ Württemberg",
"4936945", "Henneberg",
"494623", "Böklund",
"496136", "Nieder\-Olm",
"495543", "Staufenberg\ Niedersachsen",
"492680", "Mündersbach",
"492166", "Mönchengladbach\-Rheydt",
"497172", "Lorch\ Württemberg",
"497502", "Wolpertswende",
"496684", "Hofbieber\-Schwarzbach",
"499357", "Gräfendorf\ Bayern",
"494968", "Neulehe",
"4935471", "Birkenhainchen",
"499143", "Pappenheim\ Mittelfranken",
"493342", "Neuenhagen\ bei\ Berlin",
"499845", "Oberdachstetten",
"499661", "Sulzbach\-Rosenberg",
"492557", "Wettringen\ Kreis\ Steinfurt",
"4933672", "Pfaffendorfb\ Beeskow",
"4937347", "Bärenstein\ Kreis\ Annaberg",
"496237", "Maxdorf",
"4937607", "Ebersbrunn\ Sachsen",
"492267", "Wipperfürth",
"493682", "Zella\-Mehlis",
"494480", "Ovelgönne\-Strückhausen",
"492423", "Langerwehe",
"4935053", "Glashütte\ Sachsen",
"493886", "Gadebusch",
"498851", "Kochel\ am\ See",
"4935843", "Hirschfelde\ bei\ Zittau",
"495366", "Jembke",
"497533", "Allensbach",
"498535", "Haarbach",
"496758", "Waldböckelheim",
"496403", "Linden\ Hessen",
"496647", "Herbstein\-Stockhausen",
"494662", "Leck",
"4935841", "Grossschönau\ Sachsen",
"4933975", "Dannenwalde\ Kreis\ Prignitz",
"4935365", "Falkenberg\ Elster",
"4935954", "Grossharthau",
"494674", "Ockholm",
"496387", "Sankt\ Julian",
"499654", "Pleystein",
"4936026", "Struth\ bei\ Mühlhausen",
"494425", "Wangerland\-Hooksiel",
"499469", "Roding\-Neubäu",
"498722", "Gangkofen",
"4935020", "Struppen",
"492378", "Fröndenberg\-Langschede",
"494493", "Friesoythe\-Gehlenberg",
"492474", "Nideggen\-Schmidt",
"4938789", "Wolfshagen\ bei\ Perleberg",
"492065", "Duisburg\-Rheinhausen",
"4939402", "Völpke",
"4936642", "Harra",
"492693", "Antweiler",
"4935473", "Neu\ Lübbenau",
"497765", "Rickenbach\ Hotzenwald",
"492625", "Ochtendung",
"496432", "Diez",
"494558", "Todesfelde",
"493338", "Bernau\ Brandenburg",
"497476", "Bisingen",
"492462", "Linnich",
"4938731", "Lübz",
"495508", "Gleichen\-Rittmarshausen",
"4936336", "Klettenberg",
"496035", "Reichelsheim\ Wetterau",
"494268", "Bötersen",
"497151", "Waiblingen",
"492223", "Königswinter",
"496008", "Echzell",
"494351", "Eckernförde",
"494925", "Hinte",
"492295", "Ruppichteroth",
"4933206", "Fichtenwalde",
"499606", "Pfreimd",
"4939245", "Loburg",
"4937384", "Wechselburg",
"495535", "Polle",
"499802", "Ansbach\-Katterbach",
"495864", "Jameln",
"499371", "Miltenberg",
"495722", "Bückeburg",
"495676", "Liebenau\ Hessen",
"4933232", "Brieselang",
"499135", "Hessdorf\ Mittelfranken",
"493644", "Apolda",
"495872", "Stoetze",
"495301", "Lehre\-Essenrode",
"493531", "Finsterwalde",
"4936076", "Niederorschel",
"498727", "Falkenberg\ Niederbayern",
"499833", "Heidenheim\ Mittelfranken",
"496382", "Lauterecken",
"492962", "Olsberg",
"497976", "Sulzbach\-Laufen",
"492571", "Greven\ Westfalen",
"4933925", "Wustrau\-Altfriesack",
"4938780", "Lanz\ Brandenburg",
"498178", "Icking",
"496642", "Schlitz",
"497545", "Immenstaad\ am\ Bodensee",
"496589", "Kell\ am\ See",
"494667", "Dagebüll",
"492974", "Schmallenberg\-Fredeburg",
"494468", "Friedeburg\-Reepsholt",
"4935692", "Kerkwitz",
"4935383", "Elster\ Elbe",
"4933742", "Oehna\ Brandenburg",
"498543", "Aidenbach",
"497276", "Herxheim\ bei\ Landau\ Pfalz",
"492262", "Wiehl",
"492359", "Kierspe",
"497081", "Bad\ Wildbad",
"4935208", "Radeburg",
"496232", "Speyer",
"492274", "Elsdorf\ Rheinland",
"492552", "Steinfurt\-Borghorst",
"495763", "Uchte",
"499352", "Lohr\ am\ Main",
"495159", "Coppenbrügge\-Bisperode",
"492923", "Lippetal\-Herzfeld",
"494293", "Ottersberg\-Fischerhude",
"4939005", "Kusey",
"499269", "Tettau\ Kreis\ Kronach",
"496638", "Schwalmtal\-Renzendorf",
"49961", "Weiden\ in\ der\ Oberpfalz",
"494372", "Westfehmarn",
"499734", "Burkardroth",
"498366", "Oy\-Mittelberg",
"497728", "Niedereschach",
"495851", "Dahlenburg",
"494330", "Emkendorf",
"4938457", "Krakow\ am\ See",
"4933655", "Grunow\ Kreis\ Oder\-Spree",
"496203", "Ladenburg",
"4934782", "Mansfeld\ Südharz",
"496043", "Nidda",
"494109", "Tangstedt\ Bz\ Hamburg",
"494364", "Dahme\ Kreis\ Ostholstein",
"498143", "Inning\ am\ Ammersee",
"494333", "Erfde",
"49791", "Schwäbisch\ Hall",
"497046", "Zaberfeld",
"499763", "Sulzdorf\ an\ der\ Lederhecke",
"4936452", "Berlstedt",
"493394", "Wittstock\ Dosse",
"4938373", "Katzow",
"497461", "Tuttlingen",
"497744", "Stühlingen",
"496709", "Fürfeld\ Kreis\ Bad\ Kreuznach",
"492152", "Kempen",
"4939035", "Kuhfelde",
"492204", "Bensberg",
"494721", "Cuxhaven",
"499851", "Dinkelsbühl",
"4935696", "Briesnig",
"4933746", "Werbig\ bei\ Jüterbog",
"495734", "Bergkirchen\ Westfalen",
"496599", "Weidenbach\ bei\ Gerolstein",
"494302", "Kirchbarkau",
"4934291", "Borsdorf",
"497577", "Veringenstadt",
"494871", "Hohenwestedt",
"4934463", "Bad\ Kösen",
"495352", "Schöningen",
"496392", "Hauenstein\ Pfalz",
"498021", "Waakirchen",
"4939325", "Vinzelberg",
"494179", "Winsen\-Tönnhausen",
"498661", "Grabenstätt\ Chiemsee",
"4935895", "Klitten",
"494509", "Gross\ Grönau",
"495036", "Neustadt\-Schneeren",
"498845", "Bad\ Kohlgrub",
"49561", "Kassel",
"4936425", "Isserstedt",
"497808", "Hohberg\ bei\ Offenburg",
"499676", "Winklarn",
"4934461", "Nebra\ Unstrut",
"499722", "Werneck",
"497843", "Renchen",
"498469", "Freystadt\-Burggriesbach",
"494852", "Brunsbüttel",
"496078", "Gross\-Umstadt",
"498654", "Freilassing",
"4936072", "Weissenborn\-Lüderode",
"493375", "Königs\ Wusterhausen",
"499872", "Heilsbronn",
"495135", "Burgwedel\-Fuhrberg",
"495606", "Zierenberg",
"497358", "Eberhardzell\-Füramoos",
"495371", "Gifhorn",
"4938295", "Satow\ bei\ Bad\ Doberan",
"499535", "Pfarrweisach",
"495802", "Wrestedt",
"4934293", "Naunhof\ bei\ Grimma",
"4938371", "Karlshagen",
"492335", "Wetter\ Ruhr",
"49721", "Karlsruhe",
"4933202", "Töplitz",
"496224", "Sandhausen\ Baden",
"4939485", "Gernrode\ Harz",
"493963", "Woldegk",
"497454", "Sulz\ am\ Neckar",
"497906", "Braunsbach",
"497669", "St\ Märgen",
"496881", "Lebach",
"498807", "Diessen\ am\ Ammersee",
"495833", "Brome",
"492171", "Leverkusen\-Opladen",
"492501", "Münster\-Hiltrup",
"493628", "Arnstadt",
"492456", "Selfkant",
"492904", "Bestwig",
"492985", "Winterberg\-Niedersfeld",
"494283", "Tarmstedt",
"497145", "Markgröningen",
"4939406", "Harbke",
"4939293", "Dreileben",
"4938307", "Poseritz",
"496473", "Leun",
"498135", "Sulzemoos",
"4935751", "Welzow",
"496694", "Neukirchen\ Knüll",
"495654", "Herleshausen",
"4936646", "Tanna\ bei\ Schleiz",
"4936332", "Ellrich",
"494604", "Grossenwiehe",
"4936845", "Gehlberg",
"4938727", "Mestlin",
"498802", "Huglfing",
"4938321", "Martensdorf\ bei\ Stralsund",
"492308", "Unna\-Hemmerde",
"499089", "Bissingen\-Unterringingen",
"492485", "Schleiden\-Dreiborn",
"495807", "Altenmedingen",
"492404", "Alsdorf\ Rheinland",
"499178", "Abenberg\ Mittelfranken",
"494158", "Roseburg",
"497261", "Sinsheim",
"4935204", "Wilsdruff",
"497954", "Kirchberg\ an\ der\ Jagst",
"495108", "Gehrden\ Han",
"494857", "Barlt",
"497551", "Überlingen\ Bodensee",
"4937754", "Zwönitz",
"499727", "Schonungen\-Marktsteinach",
"496400", "Mücke",
"4936022", "Grossengottern",
"4938483", "Brüel",
"492256", "Mechernich\-Satzvey",
"494483", "Ovelgönne\-Grossenmeer",
"497835", "Zell\ am\ Harmersbach",
"497564", "Bad\ Wurzach",
"497961", "Ellwangen\ Jagst",
"4938481", "Witzin",
"496536", "Kleinich",
"495143", "Winsen\ Aller",
"496397", "Leimen\ Pfalz",
"495357", "Grasleben",
"4933676", "Friedland\ bei\ Beeskow",
"497254", "Waghäusel",
"4933875", "Rhinow",
"494307", "Raisdorf",
"496675", "Breitenbach\ am\ Herzberg",
"496059", "Jossgrund",
"497572", "Mengen\ Württemberg",
"492566", "Legden",
"49741", "Rottweil",
"499543", "Hirschaid",
"496424", "Ebsdorfergrund",
"496328", "Elmstein",
"492157", "Nettetal\-Kaldenkirchen",
"493841", "Wismar",
"494736", "Butjadingen\-Tossens",
"4939082", "Mieste",
"4934325", "Mochau\-Lüttewitz",
"499366", "Geroldshausen\ Unterfranken",
"498734", "Reisbach\ Niederbayern",
"4938323", "Prohn",
"492858", "Hünxe",
"495661", "Melsungen",
"498036", "Stephanskirchen\ Simssee",
"492683", "Asbach\ Westerwald",
"493998", "Demmin",
"4939291", "Calbe\ Saale",
"4937203", "Gersdorf\ bei\ Chemnitz",
"495845", "Bergen\ Dumme",
"49861", "Traunstein",
"498269", "Unteregg\ bei\ Mindelheim",
"497133", "Lauffen\ am\ Neckar",
"495021", "Nienburg\ Weser",
"4935753", "Grossräschen",
"498783", "Rohr\ in\ Niederbayern",
"498847", "Obersöchering",
"4936946", "Erbenhausen\ Thüringen",
"497832", "Haslach\ im\ Kinzigtal",
"496664", "Sinntal\-Sterbfritz",
"497946", "Bretzfeld",
"49271", "Siegen",
"496630", "Schwalmtal\-Storndorf",
"4934322", "Rosswein",
"4939085", "Zichtau",
"497229", "Iffezheim",
"496024", "Schöllkrippen",
"497636", "Münstertal\ Schwarzwald",
"4933368", "Hohensaaten",
"497575", "Messkirch",
"496672", "Eiterfeld",
"496726", "Lorch\ Rheingau",
"492944", "Rietberg\-Mastholte",
"494338", "Alt\ Duvenstedt",
"497184", "Kaisersbach",
"497720", "Schwenningen\ am\ Neckar",
"492541", "Coesfeld",
"4939394", "Hohenberg\-Krusemark",
"496876", "Weiskirchen\ Saar",
"492634", "Rengsdorf",
"499341", "Tauberbischofsheim",
"494434", "Colnrade",
"4938353", "Gützkow\ bei\ Greifswald",
"4934299", "Gaschwitz",
"497803", "Gengenbach",
"493866", "Cambs",
"495421", "Dissen\ am\ Teutoburger\ Wald",
"495842", "Schnega",
"499681", "Windischeschenbach",
"495936", "Twist",
"4935723", "Bernsdorf\ OL",
"493493", "Bitterfeld",
"493425", "Wurzen",
"4933872", "Hohennauen",
"494526", "Ascheberg\ Holstein",
"495646", "Willebadessen",
"4933976", "Wutike",
"4935327", "Priessen",
"497147", "Sachsenheim\ Württemberg",
"497353", "Schwendi",
"494342", "Preetz\ Kreis\ Plön",
"4938320", "Tribsees",
"495236", "Blomberg\-Grossenmarpe",
"4933397", "Wandlitz",
"4938757", "Neustadt\-Glewe",
"494682", "Amrum",
"498805", "Hohenpeissenberg",
"4936025", "Körner",
"498170", "Strasslach\-Dingharting",
"4937200", "Wittgensdorf\ bei\ Chemnitz",
"496073", "Babenhausen\ Hessen",
"492596", "Nordkirchen",
"495069", "Nordstemmen",
"4938351", "Mesekenhagen",
"498221", "Günzburg",
"492337", "Hagen\-Dahl",
"495838", "Gross\ Oesingen",
"497246", "Malsch\ Kreis\ Karlsruhe",
"4938379", "Benz\ Usedom",
"499396", "Urspringen\ bei\ Lohr",
"492482", "Hellenthal",
"493695", "Bad\ Salzungen",
"493623", "Friedrichroda",
"494288", "Horstedt\ Kreis\ Rotenburg",
"498573", "Ering",
"492244", "Königswinter\-Oberpleis",
"493377", "Zossen\ Brandenburg",
"4938224", "Gresenhorst",
"495137", "Seelze",
"497704", "Geisingen\ Baden",
"493968", "Schönbeck",
"495691", "Bad\ Arolsen",
"4936842", "Oberhof\ Thüringen",
"4936335", "Grosswechsungen",
"496651", "Rasdorf",
"494550", "Bühnsdorf",
"4936693", "Crossen\ an\ der\ Elster",
"4937209", "Einsiedel\ bei\ Chemnitz",
"494855", "Eddelak",
"494769", "Bremervörde\-Iselersheim",
"499725", "Poppenhausen\ Unterfranken",
"492303", "Unna",
"499875", "Wolframs\-Eschenbach",
"499339", "Ippesheim",
"4939482", "Gatersleben",
"495132", "Lehrte",
"4933205", "Michendorf",
"493372", "Jüterbog",
"4939246", "Lindau\ Anh",
"494234", "Dörverden",
"495221", "Herford",
"494260", "Visselhövede\-Wittorf",
"496478", "Greifenstein\-Ulm",
"499532", "Maroldsweisach",
"495805", "Oetzen",
"493364", "Eisenhüttenstadt",
"498236", "Fischach",
"498629", "Palling",
"495103", "Wennigsen\ Deister",
"492332", "Gevelsberg",
"495573", "Uslar\-Volpriehausen",
"496569", "Bickendorf",
"496374", "Weilerbach",
"4936075", "Dingelstädt\ Eichsfeld",
"492056", "Heiligenhaus",
"497429", "Egesheim",
"499503", "Oberhaid\ Oberfranken",
"499173", "Thalmässing",
"492754", "Bad\ Laasphe\-Feudingen",
"4938370", "Kröslin",
"4935771", "Bad\ Muskau",
"4938292", "Kröpelin",
"497054", "Wildberg\ Württemberg",
"497142", "Bietigheim\-Bissingen",
"498137", "Petershausen",
"496362", "Alsenz",
"494153", "Lauenburg\ Elbe",
"4933926", "Herzberg\ Mark",
"492982", "Medebach",
"494347", "Flintbek",
"4933967", "Freyenstein",
"4935773", "Schleife",
"499548", "Mühlhausen\ Mittelfranken",
"492444", "Schleiden\-Gemünd",
"492761", "Olpe\ Biggesee",
"497621", "Lörrach",
"4936422", "Reinstädt\ Thüringen",
"496440", "Kölschhausen",
"494488", "Westerstede",
"496731", "Alzey",
"4935892", "Horka\ OL",
"495148", "Steinhorst\ Niedersachsen",
"4939322", "Tangermünde",
"497446", "Lossburg",
"4938462", "Baumgarten",
"498386", "Oberstaufen",
"492688", "Kroppach",
"492853", "Schermbeck",
"498421", "Eichstätt\ Bayern",
"493925", "Stassfurt",
"4935874", "Bernstadt\ an\ der\ Eigen",
"496677", "Neuenstein\ Hessen",
"497138", "Schwaigern",
"494384", "Selent",
"495436", "Nortrup",
"49335", "Frankfurt\ \(Oder\)",
"494305", "Westensee",
"4939006", "Miesterhorst",
"495921", "Nordhorn",
"496395", "Münchweiler\ an\ der\ Rodalb",
"4939061", "Weferlingen",
"499289", "Schwarzenbach\ am\ Wald",
"4933656", "Bahro",
"496323", "Edenkoben",
"495355", "Frellstedt",
"4939032", "Mahlsdorf\ bei\ Salzwedel",
"494934", "Marienhafe",
"4936691", "Eisenberg\ Thüringen",
"494531", "Bad\ Oldesloe",
"497837", "Oberharmersbach",
"494644", "Karby",
"495524", "Bad\ Lauterberg\ im\ Harz",
"496854", "Oberthal\ Saar",
"497326", "Neresheim",
"4939002", "Oebisfelde",
"499148", "Ettenstatt",
"492265", "Reichshof\-Eckenhagen",
"494963", "Dörpen",
"496235", "Schifferstadt",
"4934785", "Sandersleben",
"4939036", "Binde",
"4933652", "Neuzelle",
"4938783", "Dallmin",
"4938228", "Dettmannsdorf\-Kölzow",
"492324", "Hattingen\ Ruhr",
"492555", "Schöppingen",
"492850", "Rees\-Haldern",
"499847", "Ergersheim",
"4935451", "Dahme\ Brandenburg",
"494222", "Ganderkesee",
"492992", "Marsberg",
"499921", "Regen",
"499355", "Frammersbach",
"492428", "Niederzier",
"494839", "Wöhrden\ Dithmarschen",
"499524", "Zeil\ am\ Main",
"498681", "Waging\ am\ See",
"4935695", "Simmersdorf",
"4933745", "Petkus",
"496443", "Ehringshausen\ Dill",
"4936426", "Ottendorf\ bei\ Stadtroda",
"498341", "Kaufbeuren",
"4938466", "Jürgenshagen",
"494131", "Lüneburg",
"499436", "Nittenau",
"4938427", "Blowatz",
"499221", "Kulmbach",
"494922", "Borkum",
"492292", "Windeck\ Sieg",
"493721", "Meinersdorf",
"493871", "Parchim",
"499170", "Schwanstetten",
"492373", "Menden\ Sauerland",
"499805", "Burgoberbach",
"495532", "Stadtoldendorf",
"494498", "Saterland\-Ramsloh",
"493302", "Hennigsdorf",
"4938296", "Rerik\ Ostseebad",
"495725", "Lindhorst\ bei\ Stadthagen",
"496753", "Meisenheim",
"496408", "Buseck",
"4935453", "Drahnsdorf",
"492627", "Braubach",
"499132", "Herzogenaurach",
"495875", "Emmendorf",
"4933922", "Karwesee",
"495339", "Gielde",
"495173", "Uetze",
"4938781", "Mellen",
"495503", "Nörten\-Hardenberg",
"492831", "Geldern",
"494263", "Scheessel",
"4939242", "Prödel",
"496385", "Reichenbach\-Steegen",
"496304", "Wolfstein\ Pfalz",
"499573", "Staffelstein\ Oberfranken",
"499103", "Cadolzburg",
"494394", "Bokhorst",
"4935974", "Hinterhermsdorf",
"4933364", "Gross\ Ziethen\ Kreis\ Barnim",
"4933235", "Friesack",
"4935828", "Reichenbach\ OL",
"4939398", "Gross\ Garz",
"496861", "Merzig",
"498537", "Bad\ Füssing\-Aigen",
"497542", "Tettnang",
"494553", "Geschendorf",
"496645", "Ulrichstein",
"494665", "Emmelsbüll\-Horsbüll",
"494841", "Husum\ Nordsee",
"499236", "Nagel",
"498532", "Griesbach\ im\ Rottal",
"4936645", "Mühltroff",
"4939405", "Hötensleben",
"4935021", "Königstein\ Sächsische\ Schweiz",
"497194", "Spiegelberg",
"4938847", "Boizenburg\ Elbe",
"492228", "Remagen\-Rolandseck",
"494149", "Fredenbeck",
"496003", "Rosbach\ von\ der\ Höhe",
"496243", "Monsheim",
"498725", "Wurmannsquick",
"494422", "Sande\ Kreis\ Friesl",
"4936846", "Suhl\-Dietzhausen",
"492196", "Wermelskirchen",
"4935362", "Schönewalde\ bei\ Herzberg",
"492826", "Kranenburg\ Niederrhein",
"4933972", "Breddin",
"496435", "Wallmerod",
"498503", "Neuhaus\ am\ Inn",
"497762", "Wehr\ Baden",
"492776", "Bad\ Endbach\-Hartenrod",
"492622", "Bendorf\ am\ Rhein",
"496356", "Carlsberg\ Pfalz",
"497824", "Schwanau",
"493307", "Zehdenick",
"49681", "Saarbrücken",
"4934242", "Hohenpriessnitz",
"4935389", "Holzdorf\ Elster",
"492465", "Inden",
"497774", "Eigeltingen",
"496032", "Bad\ Nauheim",
"494927", "Krummhörn\-Loquard",
"492297", "Wildbergerhütte",
"497331", "Geislingen\ an\ der\ Steige",
"492586", "Beelen",
"4933675", "Tauche",
"495768", "Petershagen\-Heimsen",
"494463", "Wangerland",
"499499", "Painten",
"497584", "Altshausen",
"497175", "Leinzell",
"497505", "Fronreute",
"4939997", "Jarmen",
"498548", "Vilshofen\-Sandbach",
"49214", "Leverkusen",
"496806", "Heusweiler",
"4933876", "Buschow",
"499936", "Wallerfing",
"499842", "Uffenheim",
"497723", "Furtwangen\ im\ Schwarzwald",
"495681", "Homberg\ Efze",
"492663", "Westerburg\ Westerwald",
"499646", "Freihung",
"4933093", "Fürstenberg\ Havel",
"496048", "Büdingen\-Eckartshausen",
"4935247", "Zehren\ Sachsen",
"498124", "Forstern\ Oberbayern",
"493685", "Hildburghausen",
"495341", "Salzgitter",
"492928", "Soest\-Ostönnen",
"494298", "Lilienthal",
"494126", "Horst\ Holstein",
"496633", "Homberg\ Ohm",
"499421", "Straubing",
"4935023", "Bad\ Gottleuba",
"499386", "Prosselsheim",
"4938736", "Goldberg",
"4936331", "Ilfeld",
"4939083", "Messdorf",
"497432", "Albstadt\-Tailfingen",
"4936737", "Drognitz",
"492522", "Oelde",
"496765", "Gemünden\ Hunsrück",
"4938322", "Richtenberg",
"492735", "Neunkirchen\ Siegerl",
"496476", "Mengerskirchen",
"4937202", "Claussnitz\ bei\ Chemnitz",
"498238", "Gessertshausen",
"495191", "Soltau",
"496151", "Darmstadt",
"495947", "Laar\ Vechte",
"4935752", "Ruhland",
"4939489", "Strassberg\ Harz",
"494834", "Büsum",
"499529", "Oberaurach",
"497403", "Dunningen",
"495821", "Bad\ Bevensen",
"493466", "Artern\ Unstrut",
"4938355", "Züssow",
"4936924", "Mihla",
"4936021", "Schlotheim",
"495771", "Rahden\ Westfalen",
"492058", "Wülfrath",
"495205", "Bielefeld\-Sennestadt",
"495284", "Schwalenberg",
"497937", "Dörzbach",
"495045", "Springe\-Bennigsen",
"4936878", "Oberland",
"495129", "Söhlde",
"498670", "Reischach\ Kreis\ Altötting",
"497387", "Hohenstein\ Württemberg",
"492953", "Wünnenberg",
"492391", "Plettenberg",
"4935725", "Wittichenau",
"494255", "Martfeld",
"494182", "Tostedt",
"495442", "Barnstorf\ Kreis\ Diepholz",
"499701", "Sandberg\ Unterfranken",
"4933478", "Gross\ Neuendorf",
"499275", "Speichersdorf",
"4935056", "Altenberg\ Sachsen",
"4936840", "Trusetal",
"495752", "Auetal\-Hattendorf",
"492563", "Stadtlohn",
"497237", "Neulingen\ Enzkreis",
"499546", "Burgebrach",
"495905", "Beesten",
"4939329", "Möringen",
"492253", "Bad\ Münstereifel",
"494321", "Neumünster",
"494955", "Westoverledingen",
"493585", "Löbau",
"493504", "Dippoldiswalde",
"494486", "Edewecht\-Friedrichsfehn",
"499181", "Neumarkt\ in\ der\ Oberpfalz",
"495334", "Hornburg\ Kreis\ Wolfenbüttel",
"497448", "Seewald",
"494702", "Sandstedt",
"495146", "Wietze",
"496533", "Morbach\ Hunsrück",
"493901", "Salzwedel",
"498405", "Stammham\ bei\ Ingolstadt",
"4936023", "Horsmar",
"499975", "Waldmünchen\-Geigant",
"4938482", "Warin",
"4939292", "Biederitz",
"492686", "Weyerbusch",
"499294", "Regnitzlosau",
"498033", "Oberaudorf",
"4939039", "Bonese",
"498388", "Hergensweiler",
"496130", "Schwabenheim\ an\ der\ Selz",
"496164", "Reichelsheim\ Odenwald",
"497344", "Blaubeuren",
"495438", "Bakum\-Lüsche",
"497136", "Bad\ Friedrichshall",
"4933848", "Raben",
"499077", "Bachhagel",
"4935476", "Wittmannsdorf\-Bückchen",
"4936333", "Heringen\ Helme",
"4939348", "Klitsche",
"497684", "Glottertal",
"4939081", "Kakerbeck\ Sachsen\-Anhalt",
"494733", "Butjadingen\-Burhave",
"496172", "Bad\ Homburg\ von\ der\ Höhe",
"4939608", "Staven",
"496502", "Schweich",
"495247", "Harsewinkel",
"4934224", "Belgern\ Sachsen",
"499363", "Arnstein\ Unterfranken",
"4933870", "Zollchow\ bei\ Rathenow",
"4936451", "Buttelstedt",
"495242", "Rheda\-Wiedenbrück",
"4933203", "Kleinmachnow",
"497948", "Öhringen\-Ohrnberg",
"499624", "Ensdorf\ Oberpfalz",
"498581", "Waldkirchen\ Niederbayern",
"4936695", "Söllmnitz",
"49340", "Dessau\ Anh",
"4939888", "Lychen",
"494455", "Jade\-Schweiburg",
"496507", "Neumagen\-Dhron",
"498752", "Au\ in\ der\ Hallertau",
"496728", "Ober\-Hilbersheim",
"498146", "Moorenweis",
"495405", "Hasbergen\ Kreis\ Osnabrück",
"499072", "Lauingen\ Donau",
"494336", "Owschlag",
"495484", "Lienen\-Kattenvenne",
"492743", "Daaden",
"497043", "Maulbronn",
"494144", "Himmelpforten",
"499766", "Grosswenkheim",
"4939320", "Schinne",
"498334", "Bad\ Grönenbach",
"497203", "Walzbachtal",
"4933637", "Beerfelde",
"494707", "Langen\-Neuenwalde",
"4939224", "Büden",
"495033", "Wunstorf\-Grossenheidorn",
"4934348", "Frohburg",
"493868", "Rastow",
"496276", "Hesseneck",
"497121", "Reutlingen",
"498247", "Bad\ Wörishofen",
"497232", "Königsbach\-Stein",
"496081", "Usingen",
"4939030", "Brunau",
"4935268", "Stauchitz",
"492655", "Weibern",
"495648", "Brakel\-Gehrden",
"494528", "Schönwalde\ am\ Bungsberg",
"4934292", "Brandis\ bei\ Wurzen",
"495603", "Gudensberg",
"495447", "Lembruch",
"492844", "Rheinberg\-Orsoy",
"4935386", "Prettin",
"497382", "Römerstein",
"4935775", "Pechern",
"494187", "Holm\-Seppensen",
"499673", "Tiefenbach\ Oberpfalz",
"4936071", "Teistungen",
"498191", "Landsberg\ am\ Lech",
"495238", "Nieheim\-Himmighausen",
"4934462", "Laucha\ Unstrut",
"497932", "Niederstetten\ Württemberg",
"492598", "Senden\-Ottmarsbocholt",
"497642", "Endingen\ Kaiserstuhl",
"498637", "Lohkirchen",
"496545", "Blankenrath",
"498205", "Dasing",
"497248", "Marxzell",
"498771", "Ergoldsbach",
"495836", "Wittingen\-Radenbeck",
"498284", "Ziemetshausen",
"498045", "Lenggries\-Fall",
"495942", "Uelsen",
"499398", "Birkenfeld\ bei\ Würzburg",
"4936849", "Kleinschmalkalden",
"492453", "Heinsberg\-Randerath",
"498821", "Garmisch\-Partenkirchen",
"495632", "Willingen\ Upland",
"494286", "Gyhum",
"494745", "Bad\ Bederkesa",
"4933201", "Gross\ Glienicke",
"498442", "Wolnzach",
"4936453", "Mellingen",
"4938372", "Usedom",
"492527", "Lippetal\-Lippborg",
"493966", "Cölpin",
"497903", "Mainhardt",
"497224", "Gernsbach",
"495673", "Immenhausen\ Hessen",
"496029", "Mömbris",
"499238", "Röslau",
"49621", "Mannheim",
"496669", "Neuhof\-Hauswurz",
"4933844", "Brück\ Brandenburg",
"4933231", "Pausin",
"495494", "Holdorf\ Niedersachsen",
"496454", "Lichtenfels\-Sachsenberg",
"4933054", "Liebenwalde",
"492226", "Rheinbach",
"4939604", "Wildberg\ bei\ Altentreptow",
"4938376", "Zirchow",
"492639", "Anhausen\ Kreis\ Neuwied",
"499603", "Floss",
"4939344", "Güsen",
"499447", "Essing",
"498591", "Obernzell",
"4936377", "Rastenberg",
"4938785", "Berge\ bei\ Perleberg",
"497365", "Essingen\ Württemberg",
"496145", "Flörsheim\ am\ Main",
"4934783", "Gerbstedt",
"4933920", "Walsleben\ bei\ Neuruppin",
"495327", "Bad\ Grund\ Harz",
"492828", "Emmerich\-Elten",
"4933743", "Blönsdorf",
"4935693", "Lauschütz",
"496787", "Niederbrombach",
"496843", "Gersheim",
"495051", "Bergen\ Kreis\ Celle",
"498322", "Oberstdorf",
"492778", "Siegbach",
"4933979", "Wusterhausen\ Dosse",
"496358", "Kriegsfeld",
"4934466", "Janisroda",
"499942", "Viechtach",
"499836", "Gunzenhausen\-Cronheim",
"494241", "Bassum",
"499632", "Waldsassen",
"493679", "Neuhaus\ am\ Rennweg",
"497973", "Obersontheim",
"493471", "Bernburg\ Saale",
"492588", "Harsewinkel\-Greffen",
"4939057", "Rätzlingen\ Sachsen\-Anhalt",
"495072", "Neustadt\-Mandelsloh",
"499484", "Brennberg",
"499405", "Bad\ Abbach",
"496107", "Kelsterbach",
"4936874", "Schönbrunn\ bei\ Hildburghaus",
"4939000", "Beetzendorf",
"4936928", "Neuenhof\ Thüringen",
"495766", "Rehburg\-Loccum",
"495064", "Gross\ Düngen",
"497392", "Laupheim",
"494941", "Aurich",
"4934638", "Zöschen",
"498546", "Windorf\-Otterskirchen",
"495475", "Bohmte\-Hunteburg",
"4933741", "Niedergörsdorf",
"4935691", "Bärenklau\ NL",
"499242", "Gössweinstein",
"4934296", "Groitzsch\ bei\ Pegau",
"494631", "Glücksburg\ Ostsee",
"497273", "Hagenbach\ Pfalz",
"4935455", "Walddrehna",
"4933607", "Briesen\ Mark",
"494544", "Berkenthin",
"4933474", "Neutrebbin",
"495624", "Bad\ Emstal",
"499938", "Moos\ Niederbayern",
"498363", "Pfronten",
"494777", "Cadenberge",
"494827", "Wacken",
"499648", "Neustadt\ am\ Kulm",
"4934781", "Greifenhagen",
"496206", "Lampertheim",
"496046", "Ortenberg\ Hessen",
"492431", "Erkelenz",
"4936949", "Obermassfeld\-Grimmenthal",
"496744", "Oberwesel",
"496461", "Biedenkopf",
"497709", "Wutach",
"494296", "Schwanewede\-Aschwarden",
"4933233", "Ketzin",
"494128", "Kollmar",
"498294", "Horgau",
"493562", "Forst\ Lausitz",
"499334", "Giebelstadt",
"492163", "Schwalmtal\ Niederrhein",
"495181", "Alfeld\ Leine",
"497328", "Königsbronn",
"498766", "Gammelsdorf",
"499360", "Thüngen",
"4939296", "Welsleben",
"4939403", "Gröningen\ Sachsen\-Anhalt",
"4936643", "Thimmendorf",
"4935472", "Schlepzig",
"498072", "Haag\ in\ Oberbayern",
"495975", "Rheine\-Mesum",
"494441", "Vechta",
"494764", "Gnarrenburg\-Klenkendorf",
"499146", "Markt\ Berolzheim",
"493574", "Lauchhammer",
"494822", "Kellinghusen",
"498624", "Obing",
"494239", "Dörverden\-Westen",
"499905", "Bernried\ Niederbayern",
"498064", "Au\ bei\ Bad\ Aibling",
"494626", "Treia",
"494772", "Oberndorf\ Oste",
"4939009", "Badel",
"493971", "Anklam",
"496133", "Oppenheim",
"495546", "Scheden",
"496564", "Neuerburg\ Eifel",
"496835", "Beckingen",
"4936940", "Oepfershausen",
"492426", "Nörvenich",
"493883", "Hagenow",
"494192", "Bad\ Bramstedt",
"495363", "Wolfsburg\-Vorsfelde",
"492381", "Hamm\ Westfalen",
"497675", "Bernau\ Baden",
"492931", "Arnsberg",
"496102", "Neu\-Isenburg",
"496572", "Manderscheid\ Eifel",
"496254", "Lautertal\ Odenwald",
"495294", "Hövelhof\-Espeln",
"4938486", "Gustävel",
"4939387", "Havelberg",
"497424", "Spaichingen",
"492641", "Bad\ Neuenahr\-Ahrweiler",
"492759", "Bad\ Berleburg\-Aue",
"49641", "Giessen",
"499438", "Fensterbach",
"4933671", "Lieberose",
"492865", "Raesfeld",
"492534", "Münster\-Roxel",
"492449", "Blankenheim\ Ahr",
"499637", "Falkenberg\ Oberpfalz",
"4934344", "Kohren\-Sahlis",
"496261", "Mosbach\ Baden",
"4933673", "Weichensdorf",
"499947", "Neukirchen\ bei\ Hl\ Blut",
"4933929", "Gühlen\-Glienicke",
"493523", "Coswig\ bei\ Dresden",
"4934604", "Niemberg",
"499191", "Forchheim\ Oberfranken",
"494496", "Friesoythe\-Markhausen",
"496406", "Lollar",
"498327", "Rettenberg",
"494863", "Sankt\ Peter\-Ording",
"4935052", "Kipsdorf\ Kurort",
"496782", "Birkenfeld\ Nahe",
"4935842", "Oderwitz",
"4935264", "Strehla",
"496551", "Prüm",
"497473", "Mössingen",
"499129", "Wendelstein",
"495322", "Bad\ Harzburg",
"494165", "Hollenstedt\ Nordheide",
"4933970", "Neustadt\ Dosse",
"498051", "Prien\ am\ Chiemsee",
"4938732", "Gallin\ bei\ Lübz",
"4938326", "Grimmen",
"4939884", "Hassleben\ bei\ Prenzlau",
"4939427", "Ströbeck",
"499442", "Riedenburg",
"495275", "Höxter\-Ottbergen",
"494751", "Otterndorf",
"4939401", "Neuwegersleben",
"4935025", "Liebstadt",
"4937206", "Frankenberg\ Sachsen",
"495529", "Rhumspringe",
"499284", "Schwarzenbach\ an\ der\ Saale",
"492696", "Nohn\ Eifel",
"4935756", "Hosena",
"499771", "Bad\ Neustadt\ an\ der\ Saale",
"494939", "Baltrum",
"499205", "Vorbach",
"494794", "Worpswede\-Ostersode",
"496246", "Eich\ Rheinhessen",
"4937364", "Reitzenhain\ Erzgebirge",
"499608", "Kohlberg\ Oberpfalz",
"4936943", "Bettenhausen\ Thüringen",
"4938735", "Plau\ am\ See",
"492193", "Dabringhausen",
"497240", "Pfinztal",
"4933239", "Gross\ Behnitz",
"493592", "Kirschau",
"4936204", "Stotternheim",
"493733", "Annaberg\-Buchholz",
"499233", "Arzberg\ Oberfranken",
"498094", "Steinhöring",
"496785", "Herrstein",
"497651", "Titisee\-Neustadt",
"4935022", "Bad\ Schandau",
"496704", "Langenlonsheim",
"495951", "Werlte",
"4934241", "Jesewitz",
"496353", "Freinsheim",
"495325", "Goslar\-Hahnenklee",
"494162", "Jork",
"4939400", "Wefensleben",
"497367", "Aalen\-Ebnat",
"496147", "Trebur",
"495272", "Brakel\ Westfalen",
"4936640", "Remptendorf",
"499445", "Neustadt\ an\ der\ Donau",
"496594", "Birresborn",
"4938356", "Behrenhoff",
"495554", "Moringen",
"4939457", "Benneckenstein\ Harz",
"4933971", "Kyritz\ Brandenburg",
"492823", "Goch",
"494174", "Stelle\ Kreis\ Harburg",
"494504", "Ratekau",
"497073", "Ammerbuch",
"496848", "Homburg\-Einöd",
"4935055", "Höckendorf\ bei\ Dippoldiswalde",
"4935361", "Schlieben",
"492590", "Dülmen\-Buldern",
"493321", "Nauen\ Brandenburg",
"499202", "Waischenfeld",
"495264", "Kalletal",
"498506", "Bad\ Höhenstadt",
"498176", "Egling\ bei\ Wolfratshausen",
"492773", "Haiger",
"499154", "Pommelsbrunn",
"4935726", "Gross\ Särchen",
"4935363", "Fermerswalde",
"494466", "Wittmund\-Ardorf",
"499161", "Neustadt\ an\ der\ Aisch",
"4934904", "Oranienbaum",
"493860", "Raben\ Steinfeld",
"495251", "Paderborn",
"493834", "Greifswald",
"496291", "Adelsheim",
"4933973", "Zernitz\ bei\ Neustadt\ Dosse",
"498464", "Dietfurt\ an\ der\ Altmühl",
"498741", "Vilsbiburg",
"496803", "Mandelbachtal\-Ommersheim",
"498075", "Amerang",
"495561", "Einbeck",
"492583", "Sassenberg",
"494825", "Burg\ Dithmarschen",
"499869", "Wettringen\ Mittelfranken",
"4934243", "Bad\ Düben",
"494893", "Hohenaspe",
"49851", "Passau",
"494775", "Grossenwörden",
"495964", "Lähden",
"497459", "Nagold\-Hochdorf",
"4933454", "Wölsickendorf\/Wollenberg",
"496832", "Beckingen\-Reimsbach",
"492724", "Finnentrop\-Serkenrode",
"4935475", "Straupitz",
"497664", "Freiburg\-Tiengen",
"497024", "Wendlingen\ am\ Neckar",
"497940", "Künzelsau",
"494123", "Barmstedt",
"492874", "Isselburg",
"494195", "Hartenholm",
"496636", "Romrod",
"496229", "Neckarsteinach",
"499383", "Wiesentheid",
"499933", "Wallersdorf",
"4936941", "Wasungen",
"496184", "Langenselbold",
"496105", "Mörfelden\-Walldorf",
"496575", "Landscheid",
"492666", "Freilingen\ Westerwald",
"497672", "St\ Blasien",
"498368", "Halblech",
"497726", "Bad\ Dürrheim",
"499407", "Wenzenbach",
"492862", "Südlohn",
"499643", "Auerbach\ in\ der\ Oberpfalz",
"499402", "Regenstauf",
"495741", "Lübbecke",
"495464", "Alfhausen",
"492867", "Heiden\ Kreis\ Borken",
"495659", "Ringgau",
"4939243", "Nedlitz\ bei\ Zerbst",
"49911", "Nuremberg",
"496138", "Mommenheim",
"498380", "Achberg",
"498251", "Aichach",
"499245", "Obertrubach",
"499084", "Bissingen\ Schwaben",
"495472", "Bad\ Essen",
"497395", "Ehingen\-Dächingen",
"493745", "Falkenstein\ Vogtland",
"497323", "Gerstetten",
"498561", "Pfarrkirchen\ Niederbayern",
"494609", "Eggebek",
"498640", "Reit\ Im\ Winkl",
"49551", "Göttingen",
"4939001", "Apenburg",
"496837", "Wallerfangen",
"494966", "Neubörger",
"496061", "Michelstadt",
"499907", "Zenting",
"496621", "Bad\ Hersfeld",
"499433", "Nabburg",
"492409", "Stolberg\-Gressenich",
"497731", "Singen\ Hohentwiel",
"49203", "Duisburg",
"4933837", "Brielow",
"4935452", "Golssen",
"497440", "Bad\ Rippoldsau",
"495977", "Spelle",
"495368", "Parsau",
"4933923", "Flecken\ Zechlin",
"4933679", "Wendisch\ Rietz",
"497959", "Frankenhardt",
"496446", "Hohenahr",
"499207", "Königsfeld\ Oberfranken",
"496756", "Winterbach\ Soonwald",
"4936628", "Zeulenroda",
"4933921", "Zechlinerhütte",
"497569", "Isny\-Eisenbach",
"497374", "Uttenweiler",
"4935385", "Annaburg",
"495277", "Höxter\-Fürstenau",
"496429", "Schweinsberg\ Hessen",
"492601", "Nauort",
"493528", "Radeberg",
"494167", "Apensen",
"497259", "Östringen\-Odenheim",
"4933230", "Börnicke\ Kreis\ Havelland",
"498678", "Marktl",
"496054", "Birstein",
"497362", "Bopfingen",
"496142", "Rüsselsheim",
"4936087", "Wüstheuterode",
"499106", "Markt\ Erlbach",
"499576", "Lichtenfels\-Isling",
"498272", "Wertingen",
"494401", "Brake\ Unterweser",
"498554", "Schönberg\ Niederbayern",
"4933334", "Greiffenberg",
"4939003", "Jübar",
"498325", "Oberstaufen\-Thalkirchdorf",
"498393", "Holzgünz",
"494556", "Ahrensbök\-Gnissau",
"495506", "Adelebsen",
"4939409", "Eilsleben",
"495176", "Edemissen",
"497478", "Hirrlingen",
"4938782", "Reetz\ bei\ Perleberg",
"4933653", "Ziltendorf",
"499945", "Arnbruck",
"498230", "Gablingen",
"494266", "Brockel",
"499635", "Bärnau",
"4936649", "Gefell\ bei\ Schleiz",
"495451", "Ibbenbüren",
"4939241", "Leitzkau",
"4933458", "Falkenberg\ Mark",
"499277", "Warmensteinach",
"497304", "Blaustein\ Württemberg",
"496349", "Billigheim\-Ingenheim",
"494257", "Schweringen",
"499094", "Tagmersheim",
"498233", "Kissing",
"497385", "Gomadingen",
"497935", "Schrozberg",
"492671", "Cochem",
"4939033", "Wallstawe",
"495207", "Schloss\ Holte\-Stukenbrock",
"496542", "Bullay",
"492306", "Lünen",
"497645", "Freiamt",
"4938375", "Koserow",
"4939481", "Hedersleben\ bei\ Aschersleben",
"498042", "Lenggries",
"495945", "Wilsum",
"4935772", "Rietschen",
"499176", "Allersberg",
"492958", "Büren\-Harth",
"4933200", "Bergholz\-Rehbrücke",
"494471", "Cloppenburg",
"498202", "Althegnenberg",
"494156", "Talkau",
"4936029", "Menteroda",
"499451", "Schierling",
"495635", "Vöhl",
"492737", "Netphen\-Deuz",
"4936423", "Orlamünde",
"498445", "Gerolsbach",
"493941", "Halberstadt",
"494742", "Dorum",
"497753", "Albbruck",
"4935893", "Mücka",
"492053", "Velbert\-Neviges",
"4939323", "Schönhausen\ Elbe",
"4934465", "Bad\ Bibra",
"493544", "Luckau\ Brandenburg",
"493631", "Nordhausen\ Thüringen",
"4939727", "Spantekow",
"4935891", "Rothenburg\ OL",
"495245", "Herzebrock\-Clarholz",
"495084", "Hambühren",
"499472", "Hohenfels\ Oberpfalz",
"4936421", "Camburg",
"49951", "Bamberg",
"4938461", "Bützow",
"498869", "Kinsau",
"494452", "Zetel\-Neuenburg",
"497443", "Dornstetten",
"4939321", "Arneburg",
"499659", "Leuchtenberg",
"4934295", "Krensitz",
"499075", "Glött",
"4935456", "Terpt",
"492568", "Heek",
"4936450", "Kranichfeld",
"495402", "Bissendorf\ Kreis\ Osnabrück",
"499741", "Bad\ Brückenau",
"499464", "Walderbach",
"4938293", "Kühlungsborn\ Ostseebad",
"49511", "Hannover",
"498161", "Freising",
"4939934", "Gross\ Plasten",
"4939031", "Dähre",
"4937368", "Deutschneudorf",
"497854", "Kehl\-Goldscheuer",
"499977", "Arnschwang",
"4936692", "Bürgel",
"496326", "Deidesheim",
"4939062", "Bebertal",
"498407", "Grossmehring",
"4939483", "Ballenstedt",
"494957", "Detern",
"498038", "Vogtareuth",
"4939089", "Bismark\ Altmark",
"498383", "Grünenbach\ Allgäu",
"495907", "Geeste",
"492856", "Hamminkeln\-Brünen",
"49231", "Dortmund",
"497235", "Unterreichenbach\ Kreis\ Calw",
"4936208", "Ermstedt",
"493996", "Teterow",
"495433", "Badbergen",
"492652", "Mendig",
"4933338", "Stolpe\/Oder",
"4936459", "Blankenhain\ Thüringen",
"496723", "Oestrich\-Winkel",
"495755", "Kalletal\-Varenholz",
"492657", "Uersfeld",
"499561", "Coburg",
"495902", "Freren",
"499964", "Stallwang",
"496873", "Nonnweiler",
"498245", "Türkheim\ Wertach",
"498084", "Taufkirchen\ Vils",
"4939295", "Zuchau",
"499251", "Münchberg",
"49811", "Hallbergmoos",
"4934321", "Leisnig",
"497943", "Schöntal\ Jagst",
"494952", "Rhauderfehn",
"494120", "Ellerhoop",
"495161", "Walsrode",
"492183", "Rommerskirchen",
"499972", "Waldmünchen",
"4936843", "Benshausen",
"498402", "Münchsmünster",
"494271", "Sulingen",
"497633", "Staufen\ im\ Breisgau",
"494705", "Wremen",
"49375", "Zwickau",
"495933", "Lathen",
"4939080", "Kalbe\ Milde",
"4936624", "Teichwolframsdorf",
"496331", "Pirmasens",
"493496", "Köthen\ Anhalt",
"494523", "Malente",
"495407", "Wallenhorst",
"492804", "Xanten\-Marienbaum",
"495643", "Borgentreich",
"498433", "Königsmoos",
"496175", "Friedrichsdorf\ Taunus",
"4938485", "Dabel",
"496505", "Kordel",
"496584", "Wellen\ Mosel",
"4936744", "Remda",
"4939777", "Borkenfriede",
"495383", "Lutter\ am\ Barenberge",
"492361", "Recklinghausen",
"497806", "Bad\ Peterstal\-Griesbach",
"493863", "Crivitz",
"495233", "Steinheim\ Westfalen",
"492770", "Eschenburg",
"492354", "Meinerzhagen",
"496762", "Kastellaun",
"4938352", "Kemnitz\ bei\ Greifswald",
"492593", "Ascheberg\ Westfalen",
"492525", "Beckum\-Neubeckum",
"494883", "Süderstapel",
"494747", "Beverstedt",
"497435", "Albstadt\-Laufen",
"49781", "Offenburg",
"4936330", "Grossberndten",
"495608", "Söhrewald",
"492732", "Kreuztal",
"496824", "Ottweiler",
"497356", "Schemmerhofen",
"4935722", "Lauta\ bei\ Hoyerswerda",
"496774", "Kaub",
"497032", "Herrenberg",
"496281", "Buchen\ Odenwald",
"4933873", "Grosswudicke",
"498207", "Affing",
"498635", "Pleiskirchen",
"4938325", "Rolofshagen",
"494562", "Grömitz",
"4936841", "Schleusingen",
"495042", "Bad\ Münder\ am\ Deister",
"493764", "Meerane",
"495154", "Aerzen",
"493441", "Zeitz",
"499264", "Küps",
"495202", "Oerlinghausen",
"494252", "Bruchhausen\-Vilsen",
"497243", "Ettlingen",
"4935755", "Ortrand",
"494185", "Marxen\ Auetal",
"4933209", "Caputh",
"499393", "Rothenfels\ Unterfranken",
"499951", "Landau\ an\ der\ Isar",
"499325", "Kleinlangheim",
"494104", "Aumühle\ bei\ Hamburg",
"494971", "Esens",
"493772", "Schneeberg\ Erzgebirge",
"499554", "Untersteinbach\ Unterfranken",
"4935026", "Dürrröhrsdorf\-Dittersbach",
"499272", "Fichtelberg",
"495445", "Drebber",
"4936020", "Ebeleben",
"498106", "Vaterstetten",
"4939342", "Gladau",
"492205", "Rösrath",
"494903", "Wymeer",
"492771", "Dillenburg",
"4939602", "Kleeth",
"4937381", "Penig",
"492045", "Bottrop\-Kirchhellen",
"497745", "Jestetten",
"493395", "Pritzwalk",
"498708", "Weihmichl\-Unterneuhausen",
"498453", "Reichertshofen\ Oberbayern",
"497071", "Tübingen",
"492821", "Kleve\ Niederrhein",
"496789", "Heimbach\ Nahe",
"493677", "Ilmenau\ Thüringen",
"4939298", "Barby\ Elbe",
"4933052", "Leegebruch",
"492129", "Haan\ Rheinland",
"494248", "Bassum\-Neubruchhausen",
"496351", "Eisenberg\ Pfalz",
"4933335", "Pinnow\ Kreis\ Uckermark",
"495953", "Börger",
"496667", "Steinau\-Ulmbach",
"4937423", "Adorf\ Vogtland",
"497653", "Lenzkirch",
"494642", "Kappeln\ Schlei",
"495522", "Osterode\ am\ Harz",
"494846", "Hattstedt",
"499231", "Marktredwitz",
"493731", "Freiberg\ Sachsen",
"4938488", "Demen",
"496027", "Stockstadt\ am\ Main",
"494932", "Norderney",
"494382", "Wangels",
"492191", "Remscheid",
"4935384", "Steinsdorf\ bei\ Jessen",
"495329", "Schulenberg\ im\ Oberharz",
"492947", "Anröchte",
"499122", "Schwabach",
"492637", "Weissenthurm",
"499865", "Adelshofen\ Mittelfranken",
"499534", "Burgpreppach",
"494829", "Wewelsfleth",
"493362", "Erkner",
"499560", "Grub\ am\ Forst",
"499641", "Grafenwöhr",
"497528", "Neukirch\ bei\ Tettnang",
"495882", "Gorleben",
"495686", "Schwarzenborn\ Knüll",
"4933472", "Golzow\ bei\ Seelow",
"494232", "Langwedel\ Kreis\ Verden",
"499931", "Plattling",
"494779", "Freiburg\ Elbe",
"499381", "Volkach",
"4939267", "Schneidlingen",
"492247", "Neunkirchen\-Seelscheid",
"4937421", "Oelsnitz\ Vogtland",
"499426", "Oberschneiding",
"4939226", "Hohenziatz",
"494121", "Elmshorn",
"497707", "Bräunlingen",
"495346", "Liebenburg",
"496468", "Dautphetal\-Mornshausen",
"496364", "Nussbach\ Pfalz",
"497144", "Marbach\ am\ Neckar",
"496109", "Frankfurt\-Bergen\-Enkheim",
"497052", "Bad\ Liebenzell",
"492984", "Hallenberg",
"492905", "Bestwig\-Ramsbeck",
"494203", "Weyhe\ bei\ Bremen",
"4937208", "Auerswalde",
"492581", "Warendorf",
"497336", "Lonsee",
"495563", "Kreiensen",
"492752", "Bad\ Laasphe",
"4937383", "Lunzenau",
"496372", "Bruchmühlbach\-Miesau",
"494638", "Tarp",
"497455", "Dornhan",
"498743", "Geisenhausen",
"496293", "Schefflenz",
"492360", "Haltern\-Lippramsdorf",
"495253", "Bad\ Driburg",
"492334", "Hagen\-Hohenlimburg",
"4938328", "Miltzow",
"499163", "Dachsbach",
"494948", "Wiesmoor\-Marcardsmoor",
"492388", "Hamm\-Uentrop",
"498686", "Petting",
"4938378", "Heringsdorf\ Seebad",
"494684", "Langeness\ Hallig",
"499926", "Frauenau",
"497733", "Engen\ Hegau",
"49365", "Gera",
"494605", "Medelby",
"499431", "Schwandorf",
"495655", "Wanfried",
"496623", "Rotenburg\ an\ der\ Fulda",
"494136", "Scharnebeck",
"496695", "Jesberg",
"498346", "Pforzen",
"498134", "Odelzhausen",
"492938", "Ense",
"4935607", "Jänschwalde",
"494344", "Schönberg\ Holstein",
"4935474", "Schönwalde\ bei\ Lübben",
"496063", "Bad\ König",
"497702", "Blumberg\ Baden",
"498563", "Bad\ Birnbach\ Rottal",
"497321", "Heidenheim\ an\ der\ Brenz",
"492242", "Hennef\ Sieg",
"497955", "Wallhausen\ Württemberg",
"497486", "Horb\-Altheim",
"494237", "Bendingbostel",
"498253", "Pöttmes",
"4935953", "Burkau",
"492405", "Würselen",
"4934905", "Wörlitz",
"495743", "Espelkamp\-Gestringen",
"492484", "Mechernich\-Eiserfey",
"4934636", "Schafstädt",
"496425", "Rauschenberg\ Hessen",
"495453", "Recke",
"492632", "Andernach",
"492836", "Wachtendonk",
"4935844", "Oybin\ Kurort",
"496674", "Friedewald\ Hessen",
"4935951", "Neukirch\ Lausitz",
"4935054", "Lauenstein\ Sachsen",
"4934298", "Taucha\ bei\ Leipzig",
"499127", "Rosstal\ Mittelfranken",
"492942", "Geseke",
"497182", "Welzheim",
"497255", "Graben\-Neudorf",
"499778", "Fladungen",
"496866", "Perl\-Nennig",
"496022", "Obernburg\ am\ Main",
"497834", "Wolfach",
"4936926", "Creuzburg",
"497565", "Aichstetten\ Kreis\ Ravensburg",
"4934602", "Landsberg\ Sachsen\-Anhalt",
"494403", "Bad\ Zwischenahn",
"4936967", "Geisa",
"495527", "Duderstadt",
"494758", "Nordleda",
"499828", "Rügland",
"4934342", "Neukieritzsch",
"499198", "Heiligenstadt\ in\ Oberfranken",
"4934497", "Langenleuba\-Niederhain",
"496268", "Hüffenhardt",
"493876", "Perleberg",
"493672", "Rudolstadt",
"495844", "Clenze",
"493726", "Flöha",
"492447", "Dahlem\ bei\ Kall",
"4936205", "Gräfenroda",
"492603", "Bad\ Ems",
"499639", "Mähring",
"494432", "Dötlingen\-Brettorf",
"496558", "Büdesheim\ Eifel",
"498735", "Gangkofen\-Kollbach",
"4933369", "Oderberg",
"492238", "Pulheim",
"4937365", "Sayda",
"4939882", "Gollin",
"4937204", "Lichtenstein\ Sachsen",
"497939", "Schrozberg\-Spielbach",
"492051", "Velbert",
"4935754", "Klettwitz",
"499527", "Knetzgau",
"497751", "Waldshut",
"493943", "Wernigerode",
"495828", "Himbergen",
"497582", "Bad\ Buchau",
"499453", "Thalmassing",
"499708", "Bad\ Bocklet",
"495127", "Harsum",
"494473", "Emstek",
"4939886", "Milmersdorf",
"4938324", "Velgast",
"497389", "Heroldstatt",
"497165", "Göppingen\-Hohenstaufen",
"496345", "Albersweiler",
"496857", "Namborn",
"4934632", "Mücheln\ Geiseltal",
"4938220", "Wustrow\ Ostseebad",
"498122", "Erding",
"4935266", "Heyda\ bei\ Riesa",
"492673", "Ellenz\-Poltersdorf",
"4935201", "Langebrück",
"492327", "Bochum\-Wattenscheid",
"498231", "Königsbrunn\ bei\ Augsburg",
"495198", "Schneverdingen\-Wintermoor",
"496158", "Riedstadt",
"4934346", "Narsdorf",
"495226", "Bruchmühlen\ Westfalen",
"499844", "Obernzenn",
"4934606", "Teicha\ Sachsen\-Anhalt",
"4936922", "Gerstungen",
"495431", "Quakenbrück",
"499655", "Tännesberg",
"4935820", "Zodel",
"4935203", "Tharandt",
"4938827", "Kalkhorst",
"4939390", "Iden",
"4938484", "Ventschow",
"498426", "Walting\ Kreis\ Eichstätt",
"498250", "Hilgertshausen\-Tandern",
"498381", "Lindenberg\ im\ Allgäu",
"49381", "Rostock",
"496307", "Schopp",
"493435", "Oschatz",
"4935388", "Klöden",
"497192", "Murrhardt",
"494536", "Steinhorst\ Lauenburg",
"496483", "Selters\ Taunus",
"498641", "Grassau\ Kreis\ Traunstein",
"495926", "Engden",
"498534", "Tettenweis",
"4936625", "Langenwetzendorf",
"497626", "Kandern",
"496034", "Wöllstadt",
"497066", "Bad\ Rappenau\-Bonfeld",
"497822", "Ettenheim",
"496620", "Philippsthal\ Werra",
"4934222", "Arzberg\ bei\ Torgau",
"492624", "Höhr\-Grenzhausen",
"497441", "Freudenstadt",
"497764", "Herrischried",
"4936652", "Wurzbach",
"4939294", "Gross\ Rosenburg",
"496736", "Bechenheim",
"492064", "Dinslaken",
"499188", "Postbauer\-Heng",
"494328", "Rickling",
"493861", "Plate",
"495426", "Glandorf",
"497128", "Sonnenbühl",
"492363", "Datteln",
"495381", "Seesen",
"499134", "Neunkirchen\ am\ Brand",
"495250", "Delbrück\ Westfalen",
"499346", "Grünsfeld",
"493935", "Tangerhütte",
"498431", "Neuburg\ an\ der\ Donau",
"495641", "Warburg",
"493385", "Rathenow",
"4935829", "Gersdorf\ bei\ Görlitz",
"494521", "Eutin",
"4938738", "Karow\ bei\ Lübz",
"495534", "Eschershausen\ an\ der\ Lenne",
"495865", "Gusborn",
"493304", "Velten",
"496333", "Waldfischbach\-Burgalben",
"498249", "Ettringen\ Wertach",
"495931", "Meppen",
"4939399", "Kleinau",
"492294", "Morsbach\ Sieg",
"494924", "Moormerland\-Oldersum",
"497777", "Sauldorf",
"497631", "Müllheim\ Baden",
"492975", "Schmallenberg\-Oberkirchen",
"494273", "Kirchdorf\ bei\ Sulingen",
"496509", "Büdlich",
"497544", "Markdorf",
"495163", "Fallingbostel\-Dorfmark",
"492181", "Grevenbroich",
"4935058", "Pretzschendorf",
"4934294", "Rackwitz",
"494392", "Nortorf\ bei\ Neumünster",
"497941", "Öhringen",
"4933476", "Neuhardenberg",
"499253", "Weissenstadt",
"4937437", "Bad\ Elster",
"496871", "Wadern",
"4939222", "Möser",
"492546", "Coesfeld\-Lette",
"496302", "Winnweiler",
"499563", "Rödental",
"496721", "Bingen\ am\ Rhein",
"4934464", "Freyburg\ Unstrut",
"492275", "Kerpen\-Buir",
"494973", "Wittmund\-Burhafe",
"499391", "Marktheidenfeld",
"499953", "Pilsting",
"496656", "Ebersburg",
"495696", "Bad\ Arolsen\-Landau",
"493443", "Weissenfels\ Sachsen\-Anhalt",
"4938392", "Sassnitz",
"492529", "Oelde\-Stromberg",
"496852", "Nohfelden",
"494365", "Heringsdorf\ Holstein",
"496283", "Hardheim\ Odenwald",
"4939606", "Glienke",
"4938374", "Lassan\ bei\ Wolgast",
"494189", "Undeloh",
"4935795", "Königsbrück",
"4939346", "Tucheim",
"499735", "Massbach",
"498226", "Bibertal",
"497587", "Hosskirch",
"4938229", "Bad\ Sülze",
"499522", "Eltmann",
"494881", "Friedrichstadt",
"498639", "Neumarkt\-Sankt\ Veit",
"492591", "Lüdinghausen",
"498450", "Ingolstadt\-Zuchering",
"4933846", "Dippmannsdorf",
"492994", "Marsberg\-Westheim",
"494224", "Gross\ Ippener",
"4935478", "Goyatz",
"495231", "Detmold",
"4933056", "Mühlenbeck\ Kreis\ Oberhavel",
"497266", "Kirchardt",
"492272", "Bedburg\ Erft",
"492554", "Laer\ Kreis\ Steinfurt",
"492739", "Wilnsdorf",
"492325", "Wanne\-Eickel",
"494478", "Cappeln\ Oldenburg",
"492951", "Büren",
"4935792", "Ossling",
"492393", "Sundern\-Allendorf",
"499190", "Heroldsbach",
"496234", "Mutterstadt",
"492264", "Marienheide",
"497556", "Uhldingen\-Mühlhofen",
"4933336", "Passow\ Kreis\ Uckermark",
"495773", "Stemwede\-Wehdem",
"496855", "Freisen",
"495823", "Bienenbüttel",
"496550", "Irrhausen",
"4935873", "Herrnhut",
"496347", "Hochstadt\ Pfalz",
"494362", "Heiligenhafen",
"495193", "Schneverdingen",
"499732", "Hammelburg",
"499279", "Mistelgau",
"4935209", "Mohorn",
"499820", "Lehrberg",
"4935774", "Boxberg\ Sachsen",
"499525", "Königsberg\ in\ Bayern",
"499354", "Rieneck",
"498376", "Sulzberg\ Allgäu",
"492678", "Büchel\ bei\ Cochem",
"495209", "Gütersloh\-Friedrichsdorf",
"495874", "Soltendieck",
"494959", "Dollart",
"494731", "Nordenham",
"495724", "Obernkirchen",
"495026", "Steimbke",
"495862", "Hitzacker\ Elbe",
"499804", "Aurach",
"493382", "Lehnin",
"495909", "Wettrup",
"4939225", "Altengrabow",
"498031", "Rosenheim\ Oberbayern",
"496644", "Grebenhain",
"498867", "Rottenbuch\ Oberbayern",
"496531", "Bernkastel\-Kues",
"492972", "Schmallenberg",
"497966", "Unterschneidheim",
"499183", "Burgthann",
"493437", "Grimma",
"494323", "Bornhöved",
"4935028", "Krippen",
"492251", "Euskirchen",
"498168", "Attenkirchen",
"496305", "Hochspeyer",
"496384", "Konken",
"4936694", "Schkölen\ Thüringen",
"4939932", "Malchow\ bei\ Waren",
"492964", "Brilon\-Alme",
"499657", "Waldthurn",
"492561", "Ahaus",
"495583", "Braunlage\-Hohegeiss",
"499748", "Motten",
"494876", "Reher\ Holstein",
"499652", "Waidhaus",
"495409", "Hilter\ am\ Teutoburger\ Wald",
"4938223", "Saal\ Vorpom",
"4938788", "Gross\ Warnow",
"498724", "Massing",
"496338", "Hornbach\ Pfalz",
"49931", "Würzburg",
"496083", "Weilrod",
"499856", "Dürrwangen",
"494672", "Langenhorn",
"497123", "Metzingen\ Württemberg",
"4933456", "Wriezen",
"497195", "Winnenden",
"492368", "Oer\-Erkenschwick",
"495031", "Wunstorf",
"498666", "Teisendorf",
"498026", "Hausham",
"498862", "Steingaden\ Oberbayern",
"494630", "Barderup",
"492977", "Schmallenberg\-Bödefeld",
"494664", "Neukirchen\ bei\ Niebüll",
"4939391", "Lückstedt",
"496526", "Bollendorf",
"4936742", "Uhlstädt",
"497775", "Mühlingen",
"497041", "Mühlacker",
"497520", "Bodnegg",
"492464", "Aldenhoven\ bei\ Jülich",
"492741", "Betzdorf",
"499568", "Neustadt\ bei\ Coburg",
"497825", "Kippenheim",
"4936622", "Triebes",
"493937", "Osterburg\ Altmark",
"4934906", "Raguhn",
"498583", "Neureichenau",
"496434", "Bad\ Camberg",
"49251", "Münster",
"497466", "Beuron",
"492472", "Monschau",
"493647", "Pössneck",
"495168", "Walsrode\-Stellichte",
"493448", "Meuselwitz\ Thüringen",
"4934635", "Bad\ Lauchstädt",
"497504", "Horgenzell",
"497174", "Mögglingen",
"497585", "Ostrach",
"496682", "Tann\ Rhön",
"4935724", "Lohsa",
"499737", "Wartmannsroth",
"4936925", "Marksuhl",
"498823", "Mittenwald",
"492451", "Geilenkirchen",
"496342", "Schweigen\-Rechtenbach",
"497162", "Süssen",
"492506", "Münster\-Wolbeck",
"498773", "Neufahrn\ in\ Niederbayern",
"494367", "Grossenbrode",
"4938354", "Wusterhusen",
"4936206", "Grossfahner",
"4935823", "Ostritz",
"4935200", "Arnsdorf\ bei\ Dresden",
"494749", "Schiffdorf\-Geestenseth",
"499306", "Kist",
"4938207", "Stäbelow",
"493605", "Leinefelde",
"49465", "Sylt",
"4939393", "Werben\ Elbe",
"4935937", "Prischwitz",
"498193", "Geltendorf",
"499671", "Oberviechtach",
"4937327", "Rechenberg\-Bienenmühle",
"4938221", "Marlow",
"4937366", "Rübenau",
"494240", "Syke\-Heiligenfelde",
"495376", "Wesendorf\ Kreis\ Gifhorn",
"493344", "Bad\ Freienwalde",
"495601", "Schauenburg",
"497971", "Gaildorf",
"492635", "Rheinbrohl",
"496422", "Kirchhain",
"4936202", "Neudietendorf",
"494243", "Twistringen",
"497252", "Bretten",
"4935024", "Stadt\ Wehlen",
"492945", "Lippstadt\-Benninghausen",
"497574", "Gammertingen",
"496093", "Laufach",
"4939885", "Jakobshagen",
"4937362", "Seiffen\ Erzgebirge",
"495053", "Fassberg\-Müden",
"498703", "Essenbach",
"496841", "Homburg\ Saar",
"498458", "Gaimersheim",
"493328", "Teltow",
"4933094", "Löwenberg",
"496665", "Sinntal\-Altengronau",
"497562", "Isny\ im\ Allgäu",
"499376", "Collenberg",
"4935265", "Glaubitz",
"49481", "Heide\ Holstein",
"498593", "Untergriesbach",
"493675", "Sonneberg\ Thüringen",
"494356", "Gross\ Wittensee",
"4934345", "Bad\ Lausick",
"495306", "Cremlingen",
"4934605", "Gröbers",
"498732", "Frontenhausen",
"497747", "Berau",
"494435", "Grossenkneten",
"495671", "Hofgeismar",
"492207", "Kürten\-Dürscheid",
"494806", "Sarzbüttel",
"496227", "Walldorf\ Baden",
"497457", "Rottenburg\-Ergenzingen",
"494602", "Freienwill",
"499409", "Pielenhofen",
"492433", "Hückelhoven",
"496692", "Neustadt\ Hessen",
"4936626", "Auma",
"495652", "Bad\ Sooden\-Allendorf",
"498361", "Nesselwang",
"49531", "Braunschweig",
"497271", "Wörth\ am\ Rhein",
"4936042", "Tonna",
"496126", "Idstein",
"494633", "Satrup",
"498657", "Ramsau\ bei\ Berchtesgaden",
"497705", "Wolterdingen\ Schwarzw",
"495258", "Salzkotten",
"496298", "Möckmühl",
"497952", "Gerabronn",
"494943", "Grossefehn",
"492245", "Much",
"49211", "Düsseldorf",
"494208", "Grasberg",
"4933452", "Neulewin",
"499867", "Geslau",
"492402", "Stolberg\ Rheinland",
"493473", "Aschersleben\ Sachsen\-Anhalt",
"4933363", "Altenhof\ Kreis\ Barnim",
"496628", "Oberaula",
"492643", "Altenahr",
"4935973", "Stolpen",
"492407", "Herzogenrath\-Kohlscheid",
"495804", "Rätzlingen\ Kreis\ Uelzen",
"499666", "Illschwang",
"494235", "Langwedel\-Etelsen",
"496068", "Beerfelden",
"492933", "Sundern\ Sauerland",
"492383", "Bönen",
"495361", "Wolfsburg",
"498856", "Penzberg",
"494320", "Heidmühlen",
"493881", "Grevesmühlen",
"499180", "Pyrbaum",
"49831", "Kempten\ Allgäu",
"499874", "Neuendettelsau",
"497957", "Kressberg",
"499724", "Stadtlauringen",
"494854", "Friedrichskoog",
"498652", "Berchtesgaden",
"4939863", "Seehausen\ bei\ Prenzlau",
"497738", "Steisslingen",
"496131", "Mainz",
"493973", "Pasewalk",
"492902", "Warstein",
"498258", "Sielenbach",
"4935454", "Uckro",
"4933475", "Letschin",
"497055", "Neuweiler\ Kreis\ Calw",
"492755", "Bad\ Berleburg\-Schwarzenau",
"4935728", "Uhyst\ Spree",
"495657", "Meissner",
"496697", "Willingshausen",
"494607", "Janneby",
"4936875", "Straufhain\-Streufdorf",
"497452", "Nagold",
"494443", "Dinklage",
"496375", "Wallhalben",
"495183", "Lamspringe",
"492161", "Mönchengladbach",
"496222", "Wiesloch",
"492154", "Willich",
"499773", "Unsleben",
"492202", "Bergisch\ Gladbach",
"499823", "Leutershausen",
"494408", "Hude\ Oldenburg",
"497742", "Klettgau",
"494753", "Balje",
"497156", "Ditzingen",
"495703", "Hille",
"495458", "Hopsten",
"492445", "Schleiden\ Eifel",
"496150", "Weiterstadt",
"498053", "Bad\ Endorf",
"495190", "Soltau\-Emmingen",
"497471", "Hechingen",
"495525", "Walkenried",
"496553", "Schönecken",
"495593", "Bovenden\-Lenglern",
"4938784", "Kleinow\ Kreis\ Prignitz",
"495820", "Suhlendorf",
"497567", "Leutkirch\-Friesenhofen",
"494861", "Tönning",
"4939861", "Gramzow\ bei\ Prenzlau",
"494935", "Juist",
"4939605", "Gross\ Nemerow",
"499209", "Emtmannsberg",
"492233", "Hürth\ Rheinland",
"4939832", "Wesenberg",
"495354", "Jerxheim",
"4935796", "Panschwitz\-Kuckau",
"4939345", "Parchen",
"496394", "Bundenthal",
"494169", "Sauensiek",
"4935971", "Sebnitz",
"498671", "Altötting",
"4933845", "Borkheide",
"499193", "Höchstadt\ an\ der\ Aisch",
"4933332", "Gartz\ Oder",
"497257", "Bruchsal\-Untergrombach",
"493521", "Meissen",
"4933055", "Kremmen",
"494385", "Hohenfelde\ bei\ Kiel",
"4933361", "Joachimsthal",
"496263", "Neckargerach",
"498306", "Ronsberg",
"4933767", "Friedersdorf\ bei\ Berlin",
"492608", "Welschneudorf",
"496427", "Cölbe\-Schönstadt",
"495732", "Löhne",
"4936454", "Magdala",
"496144", "Bischofsheim\ bei\ Rüsselsheim",
"497579", "Schwenningen\ Baden",
"497364", "Oberkochen",
"496052", "Bad\ Orb",
"493491", "Lutherstadt\ Wittenberg",
"496336", "Dellfeld",
"499683", "Friedenfels",
"496597", "Jünkerath",
"4935875", "Obercunnersdorf\ bei\ Löbau",
"496455", "Frankenau\ Hessen",
"495423", "Versmold",
"494177", "Drage\ Elbe",
"495495", "Vörden\ Kreis\ Vechta",
"4939408", "Hadmersleben",
"492366", "Herten\ Westfalen",
"499343", "Lauda\-Königshofen",
"4936648", "Dittersdorf\ bei\ Schleiz",
"498028", "Fischbachau",
"499157", "Alfeld\ Mittelfranken",
"497225", "Gaggenau",
"4937467", "Klingenthal\ Sachsen",
"492543", "Billerbeck\ Westfalen",
"4939221", "Möckern\ bei\ Magdeburg",
"499566", "Meeder",
"498262", "Mittelneufnach",
"494276", "Borstel\ bei\ Sulingen",
"499420", "Feldkirchen\ Niederbayern",
"495166", "Walsrode\-Kirchboitzen",
"498274", "Buttenwiesen",
"4939207", "Colbitz",
"4938393", "Binz\ Ostseebad",
"498552", "Grafenau\ Niederbayern",
"496707", "Windesheim",
"498781", "Rottenburg\ an\ der\ Laaber",
"499256", "Stammbach",
"496653", "Burghaun",
"495625", "Naumburg\ Hessen",
"496888", "Lebach\-Steinbach",
"495693", "Volkmarsen",
"494545", "Seedorf\ Lauenburg",
"497667", "Breisach\ am\ Rhein",
"498809", "Wessobrunn",
"4938797", "Karstädt\ Kreis\ Prignitz",
"4937297", "Thum\ Sachsen",
"499082", "Oettingen\ in\ Bayern",
"4938391", "Altenkirchen\ Rügen",
"495474", "Stemwede\-Dielingen",
"495065", "Sibbesse",
"496187", "Schöneck",
"498571", "Simbach\ am\ Inn",
"4936074", "Worbis",
"4939223", "Theessen",
"493621", "Gotha\ Thüringen",
"494976", "Spiekeroog",
"4939857", "Drense",
"492508", "Drensteinfurt",
"4933678", "Storkow\ Mark",
"499404", "Nittendorf",
"499956", "Eichendorf\-Aufhausen",
"495462", "Ankum",
"498223", "Ichenhausen",
"498295", "Altenmünster\ Schwaben",
"496071", "Dieburg",
"498467", "Kinding",
"496745", "Gondershausen",
"496286", "Walldürn\-Rippberg",
"4933204", "Beelitz\ Mark",
"495378", "Sassenburg\-Platendorf",
"497351", "Biberach\ an\ der\ Riss",
"497268", "Bad\ Rappenau\-Obergimpern",
"499220", "Kasendorf\-Azendorf",
"495962", "Herzlake",
"499904", "Lalling",
"498065", "Tuntenhausen\-Schönau",
"494151", "Schwarzenbek",
"4936334", "Wolkramshausen",
"4938225", "Trinwillershagen",
"499171", "Roth\ Mittelfranken",
"4934223", "Dommitzsch",
"493636", "Greussen",
"498462", "Berching",
"494859", "Windbergen",
"499729", "Grettstadt",
"494765", "Ebersdorf\ bei\ Bremervörde",
"4936653", "Lehesten\ Thüringer\ Wald",
"497558", "Illmensee",
"495571", "Uslar",
"495101", "Pattensen",
"493946", "Quedlinburg",
"499335", "Aub\ Kreis\ Würzburg",
"492864", "Reken",
"495467", "Voltlage",
"492535", "Sendenhorst\-Albersloh",
"497425", "Trossingen",
"4935202", "Klingenberg\ Sachsen",
"495295", "Lichtenau\ Westfalen",
"496182", "Seligenstadt",
"496255", "Lindenfels",
"4936921", "Wutha\-Farnroda",
"495223", "Bünde",
"4936024", "Diedorf\ bei\ Mühlhausen",
"4937752", "Eibenstock",
"497674", "Todtmoos",
"492872", "Rhede\ Westfalen",
"4933748", "Treuenbrietzen",
"497022", "Nürtingen",
"4935698", "Hornow",
"499087", "Marktoffingen",
"492301", "Holzwickede",
"496565", "Dudeldorf",
"496834", "Bous",
"492676", "Ulmen",
"497662", "Vogtsburg\ im\ Kaiserstuhl",
"4933087", "Bredereiche",
"498378", "Buchenberg\ bei\ Kempten",
"492722", "Attendorn",
"4933437", "Reichenberg\ bei\ Strausberg",
"4934633", "Braunsbedra",
"498557", "Mauth",
"494533", "Reinfeld\ Holstein",
"496486", "Katzenelnbogen",
"492159", "Meerbusch\-Osterath",
"498092", "Grafing\ bei\ München",
"496321", "Neustadt\ an\ der\ Weinstrasse",
"495923", "Schüttorf",
"498267", "Dirlewang",
"495028", "Pennigsehl",
"493594", "Bischofswerda",
"493991", "Waren\ Müritz",
"494792", "Worpswede",
"498423", "Titting",
"492851", "Rees",
"4936923", "Treffurt",
"499204", "Plankenfels",
"495262", "Extertal",
"4936651", "Lobenstein",
"4934207", "Zwochau",
"4939395", "Wanzer",
"499285", "Kirchenlamitz",
"499920", "Bischofsmais",
"499152", "Hartenstein\ Mittelfranken",
"496733", "Gau\-Odernheim",
"4933238", "Senzke",
"4935825", "Kodersdorf",
"494502", "Lübeck\-Travemünde",
"494172", "Salzhausen",
"495274", "Nieheim",
"4939084", "Lindstedt",
"498166", "Allershausen\ Oberbayern",
"496592", "Daun",
"497623", "Rheinfelden\ Baden",
"492763", "Drolshagen\-Bleche",
"495552", "Katlenburg",
"4934221", "Schildau\ Gneisenaustadt",
"499746", "Zeitlofs",
"498340", "Baisweil",
"494164", "Harsefeld",
"497063", "Bad\ Wimpfen",
"496057", "Flörsbachtal",
"496772", "Nastätten",
"496626", "Wildeck\-Obersuhl",
"494133", "Wittorf\ Kreis\ Lüneburg",
"498157", "Feldafing",
"497034", "Ehningen",
"496239", "Bobenheim\-Roxheim",
"498343", "Aitrang",
"497620", "Schopfheim\-Gersbach",
"492734", "Freudenberg\ Westfalen",
"496066", "Michelstadt\-Vielbrunn",
"498858", "Kochel\-Walchensee",
"496764", "Rheinböllen",
"496441", "Wetzlar",
"498683", "Tittmoning",
"4933208", "Fahrland",
"49261", "Koblenz\ am\ Rhein",
"492269", "Kierspe\-Rönsahl",
"499923", "Teisnach",
"497736", "Tengen",
"492352", "Altena\ Westfalen",
"4939883", "Gross\ Dölln",
"49441", "Oldenburg",
"499552", "Burghaslach",
"493774", "Schwarzenberg",
"499274", "Hollfeld",
"499097", "Marxheim",
"494254", "Eystrup",
"497307", "Senden\ Iller",
"4935263", "Gröditz\ bei\ Riesa",
"495746", "Rödinghausen",
"494102", "Ahrensburg",
"494961", "Papenburg",
"496192", "Hofheim\ am\ Taunus",
"493762", "Crimmitschau",
"495152", "Hessisch\ Oldendorf",
"499359", "Karlstadt\-Wiesenfeld",
"495285", "Bad\ Pyrmont\-Kleinenberg",
"495044", "Springe\-Eldagsen",
"495204", "Steinhagen\ Westfalen",
"499262", "Wallenfels",
"4934603", "Nauendorf\ Sachsen\-Anhalt",
"497483", "Horb\-Mühringen",
"4933674", "Trebatsch",
"4934343", "Regis\-Breitingen",
"494564", "Schashagen",
"494835", "Albersdorf\ Holstein",
"4935206", "Kreischa\ bei\ Dresden",
"499974", "Traitsching",
"493981", "Neustrelitz",
"494551", "Bad\ Segeberg",
"498404", "Oberdolling",
"4936200", "Elxleben\ bei\ Arnstadt",
"495335", "Schladen",
"4937756", "Breitenbrunn\ Erzgebirge",
"4934341", "Geithain",
"494406", "Berne",
"494954", "Moormerland",
"499101", "Langenzenn",
"499571", "Lichtenfels\ Bayern",
"4936257", "Luisenthal\ Thüringen",
"4934601", "Teutschenthal",
"495456", "Westerkappeln\-Velpe",
"499962", "Schwarzach\ Niederbayern",
"495904", "Lengerich\ Emsl",
"4937360", "Olbernhau",
"497158", "Neuhausen\ auf\ den\ Fildern",
"494261", "Rotenburg\ Wümme",
"498082", "Schwindegg",
"4935952", "Grossröhrsdorf\ OL",
"492833", "Kerken",
"493331", "Angermünde",
"495171", "Peine",
"4936458", "Bad\ Berka",
"4939881", "Ringenwalde\ bei\ Templin",
"497685", "Gutach\-Bleibach",
"496751", "Bad\ Sobernheim",
"496582", "Freudenburg",
"4939404", "Ausleben",
"492371", "Iserlohn",
"492802", "Alpen",
"499467", "Michelsneukirchen",
"497345", "Langenau\ Württemberg",
"493723", "Hohenstein\-Ernstthal",
"496165", "Breuberg",
"492606", "Winningen\ Mosel",
"499295", "Töpen",
"4936644", "Hirschberg\ Saale",
"499223", "Rugendorf",
"498335", "Fellheim",
"4937369", "Wolkenstein",
"495485", "Ladbergen",
"4933841", "Belzig",
"4935975", "Hohnstein",
"4933365", "Lüdersdorf\ Kreis\ Barnim",
"4933051", "Nassenheide",
"495956", "Rastdorf",
"499462", "Falkenstein\ Oberpfalz",
"4933234", "Wustermark",
"495404", "Westerkappeln",
"4937382", "Geringswalde",
"4936209", "Klettbach",
"4939601", "Friedland",
"494454", "Jade",
"4939088", "Letzlingen",
"498501", "Thyrnau",
"496587", "Zerf",
"499625", "Kastl\ bei\ Amberg",
"498171", "Wolfratshausen",
"4939341", "Redekin",
"49421", "Bremen",
"498456", "Lenting",
"4939747", "Züsedom",
"495082", "Langlingen",
"499474", "Schmidmühlen",
"499378", "Eichenbühl\-Riedern",
"492654", "Polch",
"4933473", "Zechin",
"496241", "Worms",
"494358", "Loose\ bei\ Eckernförde",
"495308", "Lehre",
"497656", "Schluchsee",
"497852", "Willstätt",
"494843", "Viöl",
"496650", "Hosenfeld",
"4936873", "Themar",
"496439", "Holzappel",
"4937422", "Markneukirchen",
"496544", "Rhaunen",
"4939957", "Gielow",
"4934909", "Aken\ Elbe",
"496631", "Alsfeld",
"499423", "Geiselhöring",
"499495", "Breitenbrunn\ Oberpfalz",
"495157", "Emmerthal\-Börry",
"4936871", "Bad\ Colberg\-Heldburg",
"499267", "Nordhalben",
"4936028", "Kammerforst\ Thüringen",
"497302", "Pfaffenhofen\ an\ der\ Roth",
"499092", "Wemding",
"4933744", "Hohenseefeld",
"494107", "Siek\ Kreis\ Stormarn",
"4935694", "Gosda\ bei\ Klinge",
"495683", "Wabern\ Hessen",
"496898", "Völklingen",
"492661", "Bad\ Marienberg\ Westerwald",
"497721", "Villingen\ im\ Schwarzwald",
"495858", "Hitzacker\-Wietzetze",
"492845", "Neukirchen\-Vluyn",
"49202", "Wuppertal",
"4939343", "Jerichow",
"4936338", "Bleicherode",
"493542", "Lübbenau\ Spreewald",
"492357", "Herscheid\ Westfalen",
"4939603", "Burg\ Stargard",
"499340", "Königheim\-Brehmen",
"496128", "Taunusstein",
"496296", "Ahorn\ Baden",
"499166", "Münchsteinach",
"494461", "Jever",
"494744", "Loxstedt",
"496827", "Eppelborn",
"494206", "Stuhr\-Heiligenrode",
"4933053", "Zehlendorf\ Kreis\ Oberhavel",
"498152", "Herrsching\ am\ Ammersee",
"498285", "Burtenbach",
"497333", "Laichingen",
"498204", "Mickhausen",
"49491", "Leer\ Ostfriesland",
"4933843", "Niemegk",
"499492", "Parsberg",
"497531", "Konstanz",
"4933654", "Fünfeichen",
"494837", "Neuenkirchen\ Dithmarschen",
"497644", "Kenzingen",
"492421", "Düren",
"4939927", "Nossentiner\ Hütte",
"499928", "Kirchdorf\ im\ Wald",
"4933470", "Lietzen",
"4939833", "Mirow\ Kreis\ Neustrelitz",
"4936848", "Wernshausen",
"497934", "Weikersheim",
"494138", "Betzendorf\ Kreis\ Lüneburg",
"497384", "Schelklingen\-Hütten",
"4933333", "Tantow",
"498348", "Bidingen",
"492646", "Königsfeld\ Eifel",
"497305", "Erbach\ Donau",
"499663", "Neukirchen\ bei\ Sulzbach\-Rosenberg",
"4935876", "Weissenberg\ Sachsen",
"492842", "Kamp\-Lintfort",
"4936870", "Masserberg",
"4939004", "Köckte\ bei\ Gardelegen",
"499141", "Weissenburg\ in\ Bayern",
"4934977", "Quellendorf",
"494446", "Bakum\ Kreis\ Vechta",
"498761", "Moosburg\ an\ der\ Isar",
"498444", "Schweitenkirchen",
"495186", "Salzhemmendorf\-Wallensen",
"49571", "Minden\ Westfalen",
"493976", "Torgelow\ bei\ Ueckermünde",
"495541", "Hann\.\ Münden",
"494621", "Schleswig",
"495634", "Waldeck\-Sachsenhausen",
"498282", "Krumbach\ Schwaben",
"495944", "Hoogstede",
"497153", "Plochingen",
"494142", "Steinkirchen\ Kreis\ Stade",
"495706", "Porta\ Westfalica",
"496167", "Modautal",
"498332", "Ottobeuren",
"497347", "Dietenheim",
"4939600", "Zwiedorf",
"498056", "Eggstätt",
"499465", "Neukirchen\-Balbini",
"492838", "Sonsbeck",
"4933924", "Rägelin",
"4934609", "Salzmünde",
"499074", "Höchstädt\ an\ der\ Donau",
"4933878", "Nennhausen",
"495482", "Tecklenburg",
"498370", "Wiggensbach",
"499776", "Mellrichstadt",
"499622", "Hirschau\ Oberpfalz",
"496868", "Mettlach\-Tünsdorf",
"498754", "Volkenschwand",
"492691", "Adenau",
"492137", "Neuss\-Norf",
"495244", "Rietberg",
"495085", "Burgdorf\-Ehlershausen",
"499826", "Weidenbach\ Mittelfranken",
"494756", "Odisheim",
"494491", "Friesoythe",
"4933362", "Liepe\ Kreis\ Barnim",
"499196", "Wiesenttal",
"496266", "Hassmersheim",
"4933331", "Casekow",
"4939889", "Boitzenburg",
"498303", "Waltenhofen",
"497234", "Tiefenbronn",
"499228", "Thurnau",
"496039", "Karben",
"497260", "Sinsheim\-Hilsbach",
"496556", "Pronsfeld",
"495337", "Kissenbrück",
"4934328", "Hartha\ bei\ Döbeln",
"4939831", "Feldberg",
"492236", "Wesseling\ Rheinland",
"4939862", "Schmölln\ bei\ Prenzlau",
"4939244", "Steutz",
"496401", "Grünberg\ Hessen",
"494704", "Drangstedt",
"496096", "Wiesen\ Unterfranken",
"495056", "Winsen\-Meissendorf",
"4938226", "Dierhagen\ Ostseebad",
"4936043", "Kirchheilingen",
"4939038", "Henningen",
"4937361", "Neuhausen\ Erzgebirge",
"4933849", "Wiesenburg\ Mark",
"498706", "Vilsheim",
"492573", "Nordwalde",
"495332", "Schöppenstedt",
"492103", "Hilden",
"498085", "Sankt\ Wolfgang",
"4936201", "Walschleben",
"499965", "Sankt\ Englmar",
"4939349", "Parey\ Elbe",
"494929", "Ihlow\ Kreis\ Aurich",
"4934600", "Ostrau\ Saalkreis",
"499831", "Gunzenhausen",
"494246", "Twistringen\-Heiligenloh",
"495754", "Extertal\-Bremke",
"493533", "Elsterwerda",
"4936428", "Stadtroda",
"492132", "Meerbusch\-Büderich",
"4934244", "Mockrehna",
"495303", "Wendeburg",
"494848", "Rantrum",
"499627", "Freudenberg\ Oberpfalz",
"496585", "Ralingen",
"497682", "Elzach",
"4939328", "Rochau",
"496504", "Thalfang",
"496174", "Königstein\ im\ Taunus",
"4933974", "Dessow",
"499373", "Amorbach",
"4934903", "Coswig\ Anhalt",
"4935364", "Lebusa",
"4935955", "Pulsnitz",
"499292", "Konradsreuth",
"496162", "Reinheim\ Odenwald",
"498337", "Altenstadt\ Iller",
"494353", "Ascheffel",
"492436", "Wegberg\-Rödgen",
"4934901", "Rosslau\ Elbe",
"496041", "Glauburg",
"496201", "Weinheim\ Bergstr",
"496775", "Strüth\ Taunus",
"495853", "Neu\ Darchau",
"496825", "Illingen\ Saar",
"496893", "Saarbrücken\-Ensheim",
"497434", "Winterlingen",
"494803", "Pahlen",
"492524", "Ennigerloh",
"499428", "Kirchroth",
"492355", "Schalksmühle",
"492921", "Soest",
"4934927", "Globig\-Bleddin",
"496466", "Dautphetal\-Friedensdorf",
"4933479", "Küstrin\-Kietz",
"495444", "Wagenfeld",
"495761", "Stolzenau",
"4933451", "Heckelberg",
"4935826", "Königshain\ bei\ Görlitz",
"499555", "Schlüsselfeld\-Aschbach",
"49871", "Landshut",
"4936203", "Vieselbach",
"494105", "Seevetal",
"499324", "Dettelbach",
"4939396", "Neukirchen\ Altmark",
"493476", "Hettstedt\ Sachsen\-Anhalt",
"494184", "Hanstedt\ Nordheide",
"497083", "Bad\ Herrenalb",
"4936944", "Rentwertshausen",
"4936041", "Bad\ Tennstedt",
"499265", "Pressig",
"4937363", "Zöblitz",
"495155", "Emmerthal",
"496123", "Eltville\ am\ Rhein",
"493765", "Reichenbach\ Vogtland",
"498020", "Weyarn",
"495282", "Schieder\-Schwalenberg",
"494636", "Langballig",
"496195", "Kelkheim\ Taunus",
"494832", "Meldorf",
"499497", "Seubersdorf\ in\ der\ Oberpfalz",
"498541", "Vilshofen\ Niederbayern",
"4939488", "Güntersberge",
"494946", "Grossefehn\-Bagband",
"498634", "Garching\ an\ der\ Alz",
"4939977", "Jördenstorf",
"496271", "Eberbach\ Baden",
"497126", "Burladingen\-Melchingen",
"495428", "Melle\-Neuenkirchen",
"4935822", "Hagenwerder",
"496784", "Weierbach",
"498663", "Ruhpolding",
"496120", "Aarbergen",
"498023", "Bayrischzell",
"498095", "Aying",
"4939392", "Rönnebeck\ Sachsen\-Anhalt",
"499348", "Werbach\-Gamburg",
"494873", "Aukrug",
"4934324", "Ostrau\ Sachsen",
"4989", "Munich",
"4939248", "Dobritz",
"496086", "Grävenwiesbach",
"499853", "Wilburgstetten",
"494795", "Garlstedt",
"494723", "Cuxhaven\-Altenwalde",
"499282", "Naila",
"499155", "Simmelsdorf",
"498586", "Hauzenberg",
"497227", "Lichtenau\ Baden",
"4936621", "Elsterberg\ bei\ Plauen",
"495265", "Dörentrup",
"497463", "Mühlheim\ an\ der\ Donau",
"4933874", "Stechow\ Brandenburg",
"494505", "Stockelsdorf\-Curau",
"49355", "Cottbus",
"494175", "Egestorf\ Nordheide",
"496457", "Burgwald\ Eder",
"4933928", "Wildberg\ Brandenburg",
"495555", "Moringen\-Fredelsloh",
"496523", "Holsthum",
"496595", "Dockweiler",
"499444", "Siegenburg",
"499761", "Bad\ Königshofen\ im\ Grabfeld",
"495850", "Neetze",
"4936741", "Bad\ Blankenburg",
"492548", "Dülmen\-Rorup",
"494331", "Rendsburg",
"495324", "Vienenburg",
"498141", "Fürstenfeldbruck",
"4936607", "Niederpöllnitz",
"4936743", "Teichel",
"494281", "Zeven",
"4937755", "Schönheide\ Erzgebirge",
"498062", "Bruckmühl\ Mangfall",
"495965", "Klein\ Berssen",
"494774", "Hechthausen",
"49341", "Leipzig",
"4935205", "Ottendorf\-Okrilla",
"492173", "Langenfeld\ Rheinland",
"494824", "Krempe",
"498622", "Tacherting\-Peterskirchen",
"495831", "Wittingen",
"4936623", "Berga\ Elster",
"496747", "Emmelshausen",
"496658", "Poppenhausen\ Wasserkuppe",
"498074", "Schnaitsee",
"494762", "Kutenholz",
"493961", "Altentreptow",
"498465", "Kipfenberg",
"493564", "Schwarze\ Pumpe",
"493379", "Mahlow",
"495139", "Burgwedel",
"499332", "Marktbreit",
"495300", "Salzgitter\-Üfingen",
"497422", "Schramberg",
"4938222", "Semlow",
"495373", "Hillerse\ Kreis\ Gifhorn",
"492532", "Ostbevern",
"4936844", "Rohr\ Thüringen",
"496574", "Hasborn",
"496104", "Heusenstamm",
"496185", "Hammersbach\ Hessen",
"496252", "Heppenheim\ Bergstrasse",
"495292", "Lichtenau\-Atteln",
"495067", "Bockenem",
"494194", "Sievershütten",
"492339", "Sprockhövel\-Hasslinghausen",
"499303", "Eibelstadt",
"497025", "Neuffen",
"497665", "March\ Breisgau",
"492725", "Lennestadt\-Oedingen",
"4939008", "Kunrau",
"496562", "Speicher",
"498196", "Pürgen",
"4936920", "Grossenlupnitz",
"497841", "Achern",
"494547", "Gudow\ Lauenburg",
"496567", "Oberkail",
"4933366", "Chorin",
"497553", "Salem\ Baden",
"494542", "Mölln\ Lauenburg",
"495622", "Fritzlar",
"495776", "Preussisch\ Ströhen",
"493744", "Auerbach\ Vogtland",
"495826", "Suderburg",
"493461", "Merseburg\ Saale",
"495062", "Holle\ bei\ Hildesheim",
"497394", "Schelklingen",
"499244", "Betzenstein",
"499085", "Alerheim",
"498139", "Röhrmoos",
"497263", "Waibstadt",
"494349", "Dänischenhagen",
"4936948", "Römhild",
"496257", "Seeheim\-Jugenheim",
"4939933", "Vollrathsruhe",
"495074", "Rodewald",
"497427", "Schömberg\ bei\ Balingen",
"49391", "Magdeburg",
"499482", "Wörth\ an\ der\ Donau",
"495465", "Neuenkirchen\ bei\ Bramsche",
"4939827", "Schwarz\ bei\ Neustrelitz",
"4939484", "Harzgerode",
"499337", "Gaukönigshofen",
"4938294", "Neubukow",
"498292", "Dinkelscherben",
"4936929", "Ruhla",
"496742", "Boppard",
"498373", "Altusried",
"494767", "Bremervörde\-Bevern",
"4934639", "Wallendorf\ Luppe",
"495196", "Wietzendorf",
"498067", "Tuntenhausen",
"495228", "Vlotho\-Exter",
"496471", "Weilburg",
"497150", "Korntal\-Münchingen",
"4935894", "Hähnichen",
"496055", "Freigericht",
"495023", "Liebenau\ Kreis\ Nieburg\ Weser",
"497131", "Heilbronn\ Neckar",
"4936424", "Kahla\ Thüringen",
"4938464", "Bernitt",
"495663", "Spangenberg",
"492681", "Altenkirchen\ Westerwald",
"4939324", "Kläden\ bei\ Stendal",
"49234", "Bochum",
"497375", "Obermarchtal",
"497839", "Schapbach",
"495492", "Steinfeld\ Oldenburg",
"4933978", "Segeletz",
"496452", "Battenberg\ Eder",
"497222", "Rastatt",
"499287", "Selb",
"493843", "Güstrow",
"499634", "Wiesau",
"4939034", "Fleetmark",
"4939931", "Röbel\ Müritz",
"495849", "Waddeweitz",
"497628", "Efringen\-Kirchen",
"495586", "Wieda",
"499944", "Miltach",
"4935793", "Elstra",
"498265", "Pfaffenhausen\ Schwaben",
"495141", "Celle",
"498324", "Hindelang",
"497963", "Adelmannsfelden",
"499186", "Lauterhofen\ Oberpfalz",
"49971", "Bad\ Kissingen",
"494481", "Hatten\-Sandkrug",
"498555", "Perlesreut",
"4935872", "Neusalza\-Spremberg",
"494326", "Wankendorf",};
$areanames{de} = {"498367", "Roßhaupten\ Forggensee",
"498633", "Tüßling",
"498536", "Kößlarn",
"497355", "Hochdorf\ Riß",
"4935240", "Tauscha\ bei\ Großenhain",
"494497", "Barßel\-Harkebrügge",
"499636", "Plößberg",
"4938234", "Born\ Darß",
"4936705", "Oberweißbach\ Thüringer\ Wald",
"4935938", "Großpostwitz\ OL",
"495384", "Seesen\-Groß\ Rhüden",
"4936484", "Knau\ bei\ Pößneck",
"499656", "Moosbach\ bei\ Vohenstrauß",
"49221", "Köln",
"499567", "Seßlach\-Gemünda",
"4934493", "Gößnitz\ Thüringen",
"4934445", "Stößen",
"496663", "Steinau\ an\ der\ Straße",
"4939976", "Groß\ Bützin",
"492203", "Köln\-Porz",
"4935248", "Schönfeld\ bei\ Großenhain",
"495827", "Unterlüß",
"498170", "Straßlach\-Dingharting",
"4935841", "Großschönau\ Sachsen",
"4935753", "Großräschen",
"494483", "Ovelgönne\-Großenmeer",
"498807", "Dießen\ am\ Ammersee",
"4936072", "Weißenborn\-Lüderode",
"494509", "Groß\ Grönau",
"49911", "Nürnberg",
"4935726", "Groß\ Särchen",
"4939934", "Groß\ Plasten",
"4936949", "Obermaßfeld\-Grimmenthal",
"495064", "Groß\ Düngen",
"499242", "Gößweinstein",
"497162", "Süßen",
"493647", "Pößneck",
"495053", "Faßberg\-Müden",
"494684", "Langeneß\ Hallig",
"496364", "Nußbach\ Pfalz",
"4934901", "Roßlau\ Elbe",
"499141", "Weißenburg\ in\ Bayern",
"492339", "Sprockhövel\-Haßlinghausen",
"496252", "Heppenheim\ Bergstraße",
"4989", "München",
"496321", "Neustadt\ an\ der\ Weinstraße",
"497351", "Biberach\ an\ der\ Riß",
"4935952", "Großröhrsdorf\ OL",
"4939883", "Groß\ Dölln",};

    sub new {
      my $class = shift;
      my $number = shift;
      $number =~ s/(^\+49|\D)//g;
      my $self = bless({ number => $number, formatters => $formatters, validators => $validators, areanames => \%areanames}, $class);
      return $self if ($self->is_valid());
      $number =~ s/^(?:0)//;
      $self = bless({ number => $number, formatters => $formatters, validators => $validators, areanames => \%areanames}, $class);
      return $self->is_valid() ? $self : undef;
    }
1;